// Code generated by smithy-go-codegen DO NOT EDIT.

package arcregionswitch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/arcregionswitch/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Retrieves the evaluation status of a Region switch plan. The evaluation status
// provides information about the last time the plan was evaluated and any warnings
// or issues detected.
func (c *Client) GetPlanEvaluationStatus(ctx context.Context, params *GetPlanEvaluationStatusInput, optFns ...func(*Options)) (*GetPlanEvaluationStatusOutput, error) {
	if params == nil {
		params = &GetPlanEvaluationStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPlanEvaluationStatus", params, optFns, c.addOperationGetPlanEvaluationStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPlanEvaluationStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetPlanEvaluationStatusInput struct {

	// The Amazon Resource Name (ARN) of the Region switch plan to retrieve evaluation
	// status for.
	//
	// This member is required.
	PlanArn *string

	// The number of objects that you want to return with this call.
	MaxResults *int32

	// Specifies that you want to receive the next page of results. Valid only if you
	// received a nextToken response in the previous request. If you did, it indicates
	// that more output is available. Set this parameter to the value provided by the
	// previous call's nextToken response to request the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetPlanEvaluationStatusOutput struct {

	// The Amazon Resource Name (ARN) of the plan.
	//
	// This member is required.
	PlanArn *string

	// The evaluation state for the plan.
	EvaluationState types.EvaluationStatus

	// The version of the last evaluation of the plan.
	LastEvaluatedVersion *string

	// The time of the last time that Region switch ran an evaluation of the plan.
	LastEvaluationTime *time.Time

	// Specifies that you want to receive the next page of results. Valid only if you
	// received a nextToken response in the previous request. If you did, it indicates
	// that more output is available. Set this parameter to the value provided by the
	// previous call's nextToken response to request the next page of results.
	NextToken *string

	// The Amazon Web Services Region for the plan.
	Region *string

	// The current evaluation warnings for the plan.
	Warnings []types.ResourceWarning

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetPlanEvaluationStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&smithyRpcv2cbor_serializeOpGetPlanEvaluationStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&smithyRpcv2cbor_deserializeOpGetPlanEvaluationStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetPlanEvaluationStatus"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addUserAgentFeatureProtocolRPCV2CBOR(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetPlanEvaluationStatusValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetPlanEvaluationStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// PlanEvaluationStatusPassedWaiterOptions are waiter options for
// PlanEvaluationStatusPassedWaiter
type PlanEvaluationStatusPassedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// PlanEvaluationStatusPassedWaiter will use default minimum delay of 30 seconds.
	// Note that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, PlanEvaluationStatusPassedWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetPlanEvaluationStatusInput, *GetPlanEvaluationStatusOutput, error) (bool, error)
}

// PlanEvaluationStatusPassedWaiter defines the waiters for
// PlanEvaluationStatusPassed
type PlanEvaluationStatusPassedWaiter struct {
	client GetPlanEvaluationStatusAPIClient

	options PlanEvaluationStatusPassedWaiterOptions
}

// NewPlanEvaluationStatusPassedWaiter constructs a
// PlanEvaluationStatusPassedWaiter.
func NewPlanEvaluationStatusPassedWaiter(client GetPlanEvaluationStatusAPIClient, optFns ...func(*PlanEvaluationStatusPassedWaiterOptions)) *PlanEvaluationStatusPassedWaiter {
	options := PlanEvaluationStatusPassedWaiterOptions{}
	options.MinDelay = 30 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = planEvaluationStatusPassedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &PlanEvaluationStatusPassedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for PlanEvaluationStatusPassed waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *PlanEvaluationStatusPassedWaiter) Wait(ctx context.Context, params *GetPlanEvaluationStatusInput, maxWaitDur time.Duration, optFns ...func(*PlanEvaluationStatusPassedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for PlanEvaluationStatusPassed waiter
// and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *PlanEvaluationStatusPassedWaiter) WaitForOutput(ctx context.Context, params *GetPlanEvaluationStatusInput, maxWaitDur time.Duration, optFns ...func(*PlanEvaluationStatusPassedWaiterOptions)) (*GetPlanEvaluationStatusOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetPlanEvaluationStatus(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for PlanEvaluationStatusPassed waiter")
}

func planEvaluationStatusPassedStateRetryable(ctx context.Context, input *GetPlanEvaluationStatusInput, output *GetPlanEvaluationStatusOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.EvaluationState
		expectedValue := "passed"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.EvaluationState
		expectedValue := "actionRequired"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.EvaluationState
		expectedValue := "pendingEvaluation"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// GetPlanEvaluationStatusPaginatorOptions is the paginator options for
// GetPlanEvaluationStatus
type GetPlanEvaluationStatusPaginatorOptions struct {
	// The number of objects that you want to return with this call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetPlanEvaluationStatusPaginator is a paginator for GetPlanEvaluationStatus
type GetPlanEvaluationStatusPaginator struct {
	options   GetPlanEvaluationStatusPaginatorOptions
	client    GetPlanEvaluationStatusAPIClient
	params    *GetPlanEvaluationStatusInput
	nextToken *string
	firstPage bool
}

// NewGetPlanEvaluationStatusPaginator returns a new
// GetPlanEvaluationStatusPaginator
func NewGetPlanEvaluationStatusPaginator(client GetPlanEvaluationStatusAPIClient, params *GetPlanEvaluationStatusInput, optFns ...func(*GetPlanEvaluationStatusPaginatorOptions)) *GetPlanEvaluationStatusPaginator {
	if params == nil {
		params = &GetPlanEvaluationStatusInput{}
	}

	options := GetPlanEvaluationStatusPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetPlanEvaluationStatusPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetPlanEvaluationStatusPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetPlanEvaluationStatus page.
func (p *GetPlanEvaluationStatusPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetPlanEvaluationStatusOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetPlanEvaluationStatus(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetPlanEvaluationStatusAPIClient is a client that implements the
// GetPlanEvaluationStatus operation.
type GetPlanEvaluationStatusAPIClient interface {
	GetPlanEvaluationStatus(context.Context, *GetPlanEvaluationStatusInput, ...func(*Options)) (*GetPlanEvaluationStatusOutput, error)
}

var _ GetPlanEvaluationStatusAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetPlanEvaluationStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetPlanEvaluationStatus",
	}
}
