// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts an asynchronous job that generates a snapshot of a dashboard's output.
// You can request one or several of the following format configurations in each
// API call.
//
//   - 1 Paginated PDF
//
//   - 1 Excel workbook that includes up to 5 table or pivot table visuals
//
//   - 5 CSVs from table or pivot table visuals
//
// The status of a submitted job can be polled with the
// DescribeDashboardSnapshotJob API. When you call the DescribeDashboardSnapshotJob
// API, check the JobStatus field in the response. Once the job reaches a COMPLETED
// or FAILED status, use the DescribeDashboardSnapshotJobResult API to obtain the
// URLs for the generated files. If the job fails, the
// DescribeDashboardSnapshotJobResult API returns detailed information about the
// error that occurred.
//
// # StartDashboardSnapshotJob API throttling
//
// Amazon QuickSight utilizes API throttling to create a more consistent user
// experience within a time span for customers when they call the
// StartDashboardSnapshotJob . By default, 12 jobs can run simlutaneously in one
// Amazon Web Services account and users can submit up 10 API requests per second
// before an account is throttled. If an overwhelming number of API requests are
// made by the same user in a short period of time, Amazon QuickSight throttles the
// API calls to maintin an optimal experience and reliability for all Amazon
// QuickSight users.
//
// # Common throttling scenarios
//
// The following list provides information about the most commin throttling
// scenarios that can occur.
//
//   - A large number of SnapshotExport API jobs are running simultaneously on an
//     Amazon Web Services account. When a new StartDashboardSnapshotJob is created
//     and there are already 12 jobs with the RUNNING status, the new job request
//     fails and returns a LimitExceededException error. Wait for a current job to
//     comlpete before you resubmit the new job.
//
//   - A large number of API requests are submitted on an Amazon Web Services
//     account. When a user makes more than 10 API calls to the Amazon QuickSight API
//     in one second, a ThrottlingException is returned.
//
// If your use case requires a higher throttling limit, contact your account admin
// or [Amazon Web ServicesSupport]to explore options to tailor a more optimal expereince for your account.
//
// # Best practices to handle throttling
//
// If your use case projects high levels of API traffic, try to reduce the degree
// of frequency and parallelism of API calls as much as you can to avoid
// throttling. You can also perform a timing test to calculate an estimate for the
// total processing time of your projected load that stays within the throttling
// limits of the Amazon QuickSight APIs. For example, if your projected traffic is
// 100 snapshot jobs before 12:00 PM per day, start 12 jobs in parallel and measure
// the amount of time it takes to proccess all 12 jobs. Once you obtain the result,
// multiply the duration by 9, for example (12 minutes * 9 = 108 minutes) . Use the
// new result to determine the latest time at which the jobs need to be started to
// meet your target deadline.
//
// The time that it takes to process a job can be impacted by the following
// factors:
//
//   - The dataset type (Direct Query or SPICE).
//
//   - The size of the dataset.
//
//   - The complexity of the calculated fields that are used in the dashboard.
//
//   - The number of visuals that are on a sheet.
//
//   - The types of visuals that are on the sheet.
//
//   - The number of formats and snapshots that are requested in the job
//     configuration.
//
//   - The size of the generated snapshots.
//
// [Amazon Web ServicesSupport]: http://aws.amazon.com/contact-us/
func (c *Client) StartDashboardSnapshotJob(ctx context.Context, params *StartDashboardSnapshotJobInput, optFns ...func(*Options)) (*StartDashboardSnapshotJobOutput, error) {
	if params == nil {
		params = &StartDashboardSnapshotJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartDashboardSnapshotJob", params, optFns, c.addOperationStartDashboardSnapshotJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartDashboardSnapshotJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartDashboardSnapshotJobInput struct {

	// The ID of the Amazon Web Services account that the dashboard snapshot job is
	// executed in.
	//
	// This member is required.
	AwsAccountId *string

	// The ID of the dashboard that you want to start a snapshot job for.
	//
	// This member is required.
	DashboardId *string

	// A structure that describes the configuration of the dashboard snapshot.
	//
	// This member is required.
	SnapshotConfiguration *types.SnapshotConfiguration

	// An ID for the dashboard snapshot job. This ID is unique to the dashboard while
	// the job is running. This ID can be used to poll the status of a job with a
	// DescribeDashboardSnapshotJob while the job runs. You can reuse this ID for
	// another job 24 hours after the current job is completed.
	//
	// This member is required.
	SnapshotJobId *string

	//  A structure that contains information about the anonymous users that the
	// generated snapshot is for. This API will not return information about registered
	// Amazon QuickSight.
	//
	// This member is required.
	UserConfiguration *types.SnapshotUserConfiguration

	noSmithyDocumentSerde
}

type StartDashboardSnapshotJobOutput struct {

	// The Amazon Resource Name (ARN) for the dashboard snapshot job.
	Arn *string

	//  The Amazon Web Services request ID for this operation.
	RequestId *string

	// The ID of the job. The job ID is set when you start a new job with a
	// StartDashboardSnapshotJob API call.
	SnapshotJobId *string

	// The HTTP status of the request
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartDashboardSnapshotJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartDashboardSnapshotJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartDashboardSnapshotJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartDashboardSnapshotJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartDashboardSnapshotJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartDashboardSnapshotJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartDashboardSnapshotJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartDashboardSnapshotJob",
	}
}
