// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of clusters and metadata associated with an image.
func (c *Client) GetClustersForImage(ctx context.Context, params *GetClustersForImageInput, optFns ...func(*Options)) (*GetClustersForImageOutput, error) {
	if params == nil {
		params = &GetClustersForImageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetClustersForImage", params, optFns, c.addOperationGetClustersForImageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetClustersForImageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetClustersForImageInput struct {

	// The resource Id for the Amazon ECR image.
	//
	// This member is required.
	Filter *types.ClusterForImageFilterCriteria

	// The maximum number of results to be returned in a single page of results.
	MaxResults *int32

	// The pagination token from a previous request used to retrieve the next page of
	// results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetClustersForImageOutput struct {

	// A unit of work inside of a cluster, which can include metadata about the
	// cluster.
	//
	// This member is required.
	Cluster []types.ClusterInformation

	// The pagination token from a previous request used to retrieve the next page of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetClustersForImageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetClustersForImage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetClustersForImage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetClustersForImage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetClustersForImageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetClustersForImage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetClustersForImagePaginatorOptions is the paginator options for
// GetClustersForImage
type GetClustersForImagePaginatorOptions struct {
	// The maximum number of results to be returned in a single page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetClustersForImagePaginator is a paginator for GetClustersForImage
type GetClustersForImagePaginator struct {
	options   GetClustersForImagePaginatorOptions
	client    GetClustersForImageAPIClient
	params    *GetClustersForImageInput
	nextToken *string
	firstPage bool
}

// NewGetClustersForImagePaginator returns a new GetClustersForImagePaginator
func NewGetClustersForImagePaginator(client GetClustersForImageAPIClient, params *GetClustersForImageInput, optFns ...func(*GetClustersForImagePaginatorOptions)) *GetClustersForImagePaginator {
	if params == nil {
		params = &GetClustersForImageInput{}
	}

	options := GetClustersForImagePaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetClustersForImagePaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetClustersForImagePaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetClustersForImage page.
func (p *GetClustersForImagePaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetClustersForImageOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetClustersForImage(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetClustersForImageAPIClient is a client that implements the
// GetClustersForImage operation.
type GetClustersForImageAPIClient interface {
	GetClustersForImage(context.Context, *GetClustersForImageInput, ...func(*Options)) (*GetClustersForImageOutput, error)
}

var _ GetClustersForImageAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetClustersForImage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetClustersForImage",
	}
}
