// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

//	The data type for an attribute. Each attribute value is described as a
//
// name-value pair. The name is the AD schema name, and the value is the data
// itself. For a list of supported attributes, see [Directory Service Data Attributes].
//
// The following types satisfy this interface:
//
//	AttributeValueMemberBOOL
//	AttributeValueMemberN
//	AttributeValueMemberS
//	AttributeValueMemberSS
//
// [Directory Service Data Attributes]: https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ad_data_attributes.html
type AttributeValue interface {
	isAttributeValue()
}

// Indicates that the attribute type value is a boolean. For example:
//
//	"BOOL": true
type AttributeValueMemberBOOL struct {
	Value bool

	noSmithyDocumentSerde
}

func (*AttributeValueMemberBOOL) isAttributeValue() {}

// Indicates that the attribute type value is a number. For example:
//
//	"N": "16"
type AttributeValueMemberN struct {
	Value int64

	noSmithyDocumentSerde
}

func (*AttributeValueMemberN) isAttributeValue() {}

// Indicates that the attribute type value is a string. For example:
//
//	"S": "S Group"
type AttributeValueMemberS struct {
	Value string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberS) isAttributeValue() {}

// Indicates that the attribute type value is a string set. For example:
//
//	"SS": ["sample_service_class/host.sample.com:1234/sample_service_name_1",
//	"sample_service_class/host.sample.com:1234/sample_service_name_2"]
type AttributeValueMemberSS struct {
	Value []string

	noSmithyDocumentSerde
}

func (*AttributeValueMemberSS) isAttributeValue() {}

//	A group object that contains identifying information and attributes for a
//
// specified group.
type Group struct {

	//  The name of the group.
	//
	// This member is required.
	SAMAccountName *string

	// The [distinguished name] of the object.
	//
	// [distinguished name]: https://learn.microsoft.com/en-us/windows/win32/ad/object-names-and-identities#distinguished-name
	DistinguishedName *string

	//  The scope of the AD group. For details, see [Active Directory security groups]
	//
	// [Active Directory security groups]: https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope
	GroupScope GroupScope

	//  The AD group type. For details, see [Active Directory security group type].
	//
	// [Active Directory security group type]: https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work
	GroupType GroupType

	//  An expression of one or more attributes, data types, and the values of a
	// group.
	OtherAttributes map[string]AttributeValue

	//  The unique security identifier (SID) of the group.
	SID *string

	noSmithyDocumentSerde
}

// A structure containing a subset of fields of a group object from a directory.
type GroupSummary struct {

	// The scope of the AD group. For details, see [Active Directory security groups].
	//
	// [Active Directory security groups]: https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#group-scope
	//
	// This member is required.
	GroupScope GroupScope

	// The AD group type. For details, see [Active Directory security group type].
	//
	// [Active Directory security group type]: https://learn.microsoft.com/en-us/windows-server/identity/ad-ds/manage/understand-security-groups#how-active-directory-security-groups-work
	//
	// This member is required.
	GroupType GroupType

	// The name of the group.
	//
	// This member is required.
	SAMAccountName *string

	// The unique security identifier (SID) of the group.
	//
	// This member is required.
	SID *string

	noSmithyDocumentSerde
}

// A member object that contains identifying information for a specified member.
type Member struct {

	//  The AD type of the member object.
	//
	// This member is required.
	MemberType MemberType

	//  The name of the group member.
	//
	// This member is required.
	SAMAccountName *string

	//  The unique security identifier (SID) of the group member.
	//
	// This member is required.
	SID *string

	noSmithyDocumentSerde
}

//	A user object that contains identifying information and attributes for a
//
// specified user.
type User struct {

	//  The name of the user.
	//
	// This member is required.
	SAMAccountName *string

	//  The [distinguished name] of the object.
	//
	// [distinguished name]: https://learn.microsoft.com/en-us/windows/win32/ad/object-names-and-identities#distinguished-name
	DistinguishedName *string

	//  The email address of the user.
	EmailAddress *string

	//  Indicates whether the user account is active.
	Enabled *bool

	//  The first name of the user.
	GivenName *string

	//  An expression that includes one or more attributes, data types, and values of
	// a user.
	OtherAttributes map[string]AttributeValue

	//  The unique security identifier (SID) of the user.
	SID *string

	//  The last name of the user.
	Surname *string

	//  The UPN that is an internet-style login name for a user and based on the
	// internet standard [RFC 822]. The UPN is shorter than the distinguished name and easier
	// to remember.
	//
	// [RFC 822]: https://datatracker.ietf.org/doc/html/rfc822
	UserPrincipalName *string

	noSmithyDocumentSerde
}

// A structure containing a subset of the fields of a user object from a directory.
type UserSummary struct {

	// Indicates whether the user account is active.
	//
	// This member is required.
	Enabled *bool

	// The name of the user.
	//
	// This member is required.
	SAMAccountName *string

	//  The unique security identifier (SID) of the user.
	//
	// This member is required.
	SID *string

	// The first name of the user.
	GivenName *string

	// The last name of the user.
	Surname *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAttributeValue() {}
