// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a response headers policy.
//
// A response headers policy contains information about a set of HTTP headers. To
// create a response headers policy, you provide some metadata about the policy and
// a set of configurations that specify the headers.
//
// After you create a response headers policy, you can use its ID to attach it to
// one or more cache behaviors in a CloudFront distribution. When it's attached to
// a cache behavior, the response headers policy affects the HTTP headers that
// CloudFront includes in HTTP responses to requests that match the cache behavior.
// CloudFront adds or removes response headers according to the configuration of
// the response headers policy.
//
// For more information, see [Adding or removing HTTP headers in CloudFront responses] in the Amazon CloudFront Developer Guide.
//
// [Adding or removing HTTP headers in CloudFront responses]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/modifying-response-headers.html
func (c *Client) CreateResponseHeadersPolicy(ctx context.Context, params *CreateResponseHeadersPolicyInput, optFns ...func(*Options)) (*CreateResponseHeadersPolicyOutput, error) {
	if params == nil {
		params = &CreateResponseHeadersPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateResponseHeadersPolicy", params, optFns, c.addOperationCreateResponseHeadersPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateResponseHeadersPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateResponseHeadersPolicyInput struct {

	// Contains metadata about the response headers policy, and a set of
	// configurations that specify the HTTP headers.
	//
	// This member is required.
	ResponseHeadersPolicyConfig *types.ResponseHeadersPolicyConfig

	noSmithyDocumentSerde
}

type CreateResponseHeadersPolicyOutput struct {

	// The version identifier for the current version of the response headers policy.
	ETag *string

	// The URL of the response headers policy.
	Location *string

	// Contains a response headers policy.
	ResponseHeadersPolicy *types.ResponseHeadersPolicy

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateResponseHeadersPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpCreateResponseHeadersPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpCreateResponseHeadersPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateResponseHeadersPolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateResponseHeadersPolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateResponseHeadersPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateResponseHeadersPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateResponseHeadersPolicy",
	}
}
