// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of trained model inference jobs that match the request
// parameters.
func (c *Client) ListTrainedModelInferenceJobs(ctx context.Context, params *ListTrainedModelInferenceJobsInput, optFns ...func(*Options)) (*ListTrainedModelInferenceJobsOutput, error) {
	if params == nil {
		params = &ListTrainedModelInferenceJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTrainedModelInferenceJobs", params, optFns, c.addOperationListTrainedModelInferenceJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTrainedModelInferenceJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTrainedModelInferenceJobsInput struct {

	// The membership
	//
	// This member is required.
	MembershipIdentifier *string

	// The maximum size of the results that is returned per call.
	MaxResults *int32

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string

	// The Amazon Resource Name (ARN) of a trained model that was used to create the
	// trained model inference jobs that you are interested in.
	TrainedModelArn *string

	noSmithyDocumentSerde
}

type ListTrainedModelInferenceJobsOutput struct {

	// Returns the requested trained model inference jobs.
	//
	// This member is required.
	TrainedModelInferenceJobs []types.TrainedModelInferenceJobSummary

	// The token value used to access the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTrainedModelInferenceJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTrainedModelInferenceJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTrainedModelInferenceJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTrainedModelInferenceJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListTrainedModelInferenceJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTrainedModelInferenceJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListTrainedModelInferenceJobsPaginatorOptions is the paginator options for
// ListTrainedModelInferenceJobs
type ListTrainedModelInferenceJobsPaginatorOptions struct {
	// The maximum size of the results that is returned per call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTrainedModelInferenceJobsPaginator is a paginator for
// ListTrainedModelInferenceJobs
type ListTrainedModelInferenceJobsPaginator struct {
	options   ListTrainedModelInferenceJobsPaginatorOptions
	client    ListTrainedModelInferenceJobsAPIClient
	params    *ListTrainedModelInferenceJobsInput
	nextToken *string
	firstPage bool
}

// NewListTrainedModelInferenceJobsPaginator returns a new
// ListTrainedModelInferenceJobsPaginator
func NewListTrainedModelInferenceJobsPaginator(client ListTrainedModelInferenceJobsAPIClient, params *ListTrainedModelInferenceJobsInput, optFns ...func(*ListTrainedModelInferenceJobsPaginatorOptions)) *ListTrainedModelInferenceJobsPaginator {
	if params == nil {
		params = &ListTrainedModelInferenceJobsInput{}
	}

	options := ListTrainedModelInferenceJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTrainedModelInferenceJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTrainedModelInferenceJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTrainedModelInferenceJobs page.
func (p *ListTrainedModelInferenceJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTrainedModelInferenceJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTrainedModelInferenceJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTrainedModelInferenceJobsAPIClient is a client that implements the
// ListTrainedModelInferenceJobs operation.
type ListTrainedModelInferenceJobsAPIClient interface {
	ListTrainedModelInferenceJobs(context.Context, *ListTrainedModelInferenceJobsInput, ...func(*Options)) (*ListTrainedModelInferenceJobsOutput, error)
}

var _ ListTrainedModelInferenceJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTrainedModelInferenceJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTrainedModelInferenceJobs",
	}
}
