// Code generated by smithy-go-codegen DO NOT EDIT.

package chatbot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/chatbot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists Slack channel configurations optionally filtered by ChatConfigurationArn
func (c *Client) DescribeSlackChannelConfigurations(ctx context.Context, params *DescribeSlackChannelConfigurationsInput, optFns ...func(*Options)) (*DescribeSlackChannelConfigurationsOutput, error) {
	if params == nil {
		params = &DescribeSlackChannelConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSlackChannelConfigurations", params, optFns, c.addOperationDescribeSlackChannelConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSlackChannelConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSlackChannelConfigurationsInput struct {

	// An optional Amazon Resource Name (ARN) of a SlackChannelConfiguration to
	// describe.
	ChatConfigurationArn *string

	// The maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so that
	// the remaining results can be retrieved.
	MaxResults *int32

	//  An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeSlackChannelConfigurationsOutput struct {

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string

	// A list of Slack channel configurations.
	SlackChannelConfigurations []types.SlackChannelConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSlackChannelConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeSlackChannelConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeSlackChannelConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeSlackChannelConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSlackChannelConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeSlackChannelConfigurationsPaginatorOptions is the paginator options for
// DescribeSlackChannelConfigurations
type DescribeSlackChannelConfigurationsPaginatorOptions struct {
	// The maximum number of results to include in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so that
	// the remaining results can be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeSlackChannelConfigurationsPaginator is a paginator for
// DescribeSlackChannelConfigurations
type DescribeSlackChannelConfigurationsPaginator struct {
	options   DescribeSlackChannelConfigurationsPaginatorOptions
	client    DescribeSlackChannelConfigurationsAPIClient
	params    *DescribeSlackChannelConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewDescribeSlackChannelConfigurationsPaginator returns a new
// DescribeSlackChannelConfigurationsPaginator
func NewDescribeSlackChannelConfigurationsPaginator(client DescribeSlackChannelConfigurationsAPIClient, params *DescribeSlackChannelConfigurationsInput, optFns ...func(*DescribeSlackChannelConfigurationsPaginatorOptions)) *DescribeSlackChannelConfigurationsPaginator {
	if params == nil {
		params = &DescribeSlackChannelConfigurationsInput{}
	}

	options := DescribeSlackChannelConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeSlackChannelConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeSlackChannelConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeSlackChannelConfigurations page.
func (p *DescribeSlackChannelConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeSlackChannelConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeSlackChannelConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeSlackChannelConfigurationsAPIClient is a client that implements the
// DescribeSlackChannelConfigurations operation.
type DescribeSlackChannelConfigurationsAPIClient interface {
	DescribeSlackChannelConfigurations(context.Context, *DescribeSlackChannelConfigurationsInput, ...func(*Options)) (*DescribeSlackChannelConfigurationsOutput, error)
}

var _ DescribeSlackChannelConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeSlackChannelConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeSlackChannelConfigurations",
	}
}
