//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsupport

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FileWorkspacesNoSubscriptionClient contains the methods for the FileWorkspacesNoSubscription group.
// Don't use this type directly, use NewFileWorkspacesNoSubscriptionClient() instead.
type FileWorkspacesNoSubscriptionClient struct {
	internal *arm.Client
}

// NewFileWorkspacesNoSubscriptionClient creates a new instance of FileWorkspacesNoSubscriptionClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewFileWorkspacesNoSubscriptionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*FileWorkspacesNoSubscriptionClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &FileWorkspacesNoSubscriptionClient{
		internal: cl,
	}
	return client, nil
}

// Create - Creates a new file workspace.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01
//   - fileWorkspaceName - File workspace name.
//   - options - FileWorkspacesNoSubscriptionClientCreateOptions contains the optional parameters for the FileWorkspacesNoSubscriptionClient.Create
//     method.
func (client *FileWorkspacesNoSubscriptionClient) Create(ctx context.Context, fileWorkspaceName string, options *FileWorkspacesNoSubscriptionClientCreateOptions) (FileWorkspacesNoSubscriptionClientCreateResponse, error) {
	var err error
	const operationName = "FileWorkspacesNoSubscriptionClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, fileWorkspaceName, options)
	if err != nil {
		return FileWorkspacesNoSubscriptionClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileWorkspacesNoSubscriptionClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FileWorkspacesNoSubscriptionClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *FileWorkspacesNoSubscriptionClient) createCreateRequest(ctx context.Context, fileWorkspaceName string, options *FileWorkspacesNoSubscriptionClientCreateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}"
	if fileWorkspaceName == "" {
		return nil, errors.New("parameter fileWorkspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileWorkspaceName}", url.PathEscape(fileWorkspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *FileWorkspacesNoSubscriptionClient) createHandleResponse(resp *http.Response) (FileWorkspacesNoSubscriptionClientCreateResponse, error) {
	result := FileWorkspacesNoSubscriptionClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileWorkspaceDetails); err != nil {
		return FileWorkspacesNoSubscriptionClientCreateResponse{}, err
	}
	return result, nil
}

// Get - Gets details for a specific file workspace.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01
//   - fileWorkspaceName - File Workspace Name
//   - options - FileWorkspacesNoSubscriptionClientGetOptions contains the optional parameters for the FileWorkspacesNoSubscriptionClient.Get
//     method.
func (client *FileWorkspacesNoSubscriptionClient) Get(ctx context.Context, fileWorkspaceName string, options *FileWorkspacesNoSubscriptionClientGetOptions) (FileWorkspacesNoSubscriptionClientGetResponse, error) {
	var err error
	const operationName = "FileWorkspacesNoSubscriptionClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, fileWorkspaceName, options)
	if err != nil {
		return FileWorkspacesNoSubscriptionClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileWorkspacesNoSubscriptionClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileWorkspacesNoSubscriptionClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *FileWorkspacesNoSubscriptionClient) getCreateRequest(ctx context.Context, fileWorkspaceName string, options *FileWorkspacesNoSubscriptionClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}"
	if fileWorkspaceName == "" {
		return nil, errors.New("parameter fileWorkspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileWorkspaceName}", url.PathEscape(fileWorkspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FileWorkspacesNoSubscriptionClient) getHandleResponse(resp *http.Response) (FileWorkspacesNoSubscriptionClientGetResponse, error) {
	result := FileWorkspacesNoSubscriptionClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileWorkspaceDetails); err != nil {
		return FileWorkspacesNoSubscriptionClientGetResponse{}, err
	}
	return result, nil
}
