//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstreamanalytics_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/streamanalytics/armstreamanalytics/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Subscription_ListQuotas.json
func ExampleSubscriptionsClient_ListQuotas() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSubscriptionsClient().ListQuotas(ctx, "West US", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SubscriptionQuotasListResult = armstreamanalytics.SubscriptionQuotasListResult{
	// 	Value: []*armstreamanalytics.SubscriptionQuota{
	// 		{
	// 			Name: to.Ptr("StreamingUnits"),
	// 			Type: to.Ptr("Microsoft.StreamAnalytics/quotas"),
	// 			ID: to.Ptr("/subscriptions/56b5e0a9-b645-407d-99b0-c64f86013e3d/providers/Microsoft.StreamAnalytics/locations/West US/quotas/StreamingUnits"),
	// 			Properties: &armstreamanalytics.SubscriptionQuotaProperties{
	// 				CurrentCount: to.Ptr[int32](0),
	// 				MaxCount: to.Ptr[int32](200),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Subscription_TestQuery.json
func ExampleSubscriptionsClient_BeginTestQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSubscriptionsClient().BeginTestQuery(ctx, "West US", armstreamanalytics.TestQuery{
		Diagnostics: &armstreamanalytics.TestQueryDiagnostics{
			Path:     to.Ptr("/pathto/subdirectory"),
			WriteURI: to.Ptr("http://myoutput.com"),
		},
		StreamingJob: &armstreamanalytics.StreamingJob{
			Location: to.Ptr("West US"),
			Tags: map[string]*string{
				"key1":      to.Ptr("value1"),
				"key3":      to.Ptr("value3"),
				"randomKey": to.Ptr("randomValue"),
			},
			Properties: &armstreamanalytics.StreamingJobProperties{
				CompatibilityLevel:                 to.Ptr(armstreamanalytics.CompatibilityLevelOne0),
				DataLocale:                         to.Ptr("en-US"),
				EventsLateArrivalMaxDelayInSeconds: to.Ptr[int32](5),
				EventsOutOfOrderMaxDelayInSeconds:  to.Ptr[int32](0),
				EventsOutOfOrderPolicy:             to.Ptr(armstreamanalytics.EventsOutOfOrderPolicyDrop),
				Functions:                          []*armstreamanalytics.Function{},
				Inputs: []*armstreamanalytics.Input{
					{
						Name: to.Ptr("inputtest"),
						Properties: &armstreamanalytics.StreamInputProperties{
							Type: to.Ptr("Stream"),
							Serialization: &armstreamanalytics.JSONSerialization{
								Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
								Properties: &armstreamanalytics.JSONSerializationProperties{
									Encoding: to.Ptr(armstreamanalytics.EncodingUTF8),
								},
							},
							Datasource: &armstreamanalytics.RawStreamInputDataSource{
								Type: to.Ptr("Raw"),
								Properties: &armstreamanalytics.RawInputDatasourceProperties{
									PayloadURI: to.Ptr("http://myinput.com"),
								},
							},
						},
					}},
				OutputErrorPolicy: to.Ptr(armstreamanalytics.OutputErrorPolicyDrop),
				Outputs: []*armstreamanalytics.Output{
					{
						Name: to.Ptr("outputtest"),
						Properties: &armstreamanalytics.OutputProperties{
							Datasource: &armstreamanalytics.RawOutputDatasource{
								Type: to.Ptr("Raw"),
								Properties: &armstreamanalytics.RawOutputDatasourceProperties{
									PayloadURI: to.Ptr("http://myoutput.com"),
								},
							},
							Serialization: &armstreamanalytics.JSONSerialization{
								Type: to.Ptr(armstreamanalytics.EventSerializationTypeJSON),
							},
						},
					}},
				SKU: &armstreamanalytics.SKU{
					Name: to.Ptr(armstreamanalytics.SKUNameStandard),
				},
				Transformation: &armstreamanalytics.Transformation{
					Name: to.Ptr("transformationtest"),
					Properties: &armstreamanalytics.TransformationProperties{
						Query:          to.Ptr("Select Id, Name from inputtest"),
						StreamingUnits: to.Ptr[int32](1),
					},
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryTestingResult = armstreamanalytics.QueryTestingResult{
	// 	OutputURI: to.Ptr("http://myoutput.com"),
	// 	Status: to.Ptr(armstreamanalytics.QueryTestingResultStatusSuccess),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Subscription_CompileQuery.json
func ExampleSubscriptionsClient_CompileQuery() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSubscriptionsClient().CompileQuery(ctx, "West US", armstreamanalytics.CompileQuery{
		CompatibilityLevel: to.Ptr(armstreamanalytics.CompatibilityLevelOne2),
		Functions: []*armstreamanalytics.QueryFunction{
			{
				Name:        to.Ptr("function1"),
				Type:        to.Ptr("Scalar"),
				BindingType: to.Ptr("Microsoft.StreamAnalytics/JavascriptUdf"),
				Inputs: []*armstreamanalytics.FunctionInput{
					{
						DataType: to.Ptr("any"),
					}},
				Output: &armstreamanalytics.FunctionOutput{
					DataType: to.Ptr("bigint"),
				},
			}},
		Inputs: []*armstreamanalytics.QueryInput{
			{
				Name: to.Ptr("input1"),
				Type: to.Ptr("Stream"),
			}},
		JobType: to.Ptr(armstreamanalytics.JobTypeCloud),
		Query:   to.Ptr("SELECT\r\n    *\r\nINTO\r\n    [output1]\r\nFROM\r\n    [input1]"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryCompilationResult = armstreamanalytics.QueryCompilationResult{
	// 	Errors: []*armstreamanalytics.QueryCompilationError{
	// 		{
	// 			IsGlobal: to.Ptr(true),
	// 			Message: to.Ptr("Query failed to compile."),
	// 	}},
	// 	Functions: []*string{
	// 		to.Ptr("transformationtest")},
	// 		Inputs: []*string{
	// 			to.Ptr("inputtest")},
	// 			Outputs: []*string{
	// 				to.Ptr("outputtest")},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Subscription_SampleInput.json
func ExampleSubscriptionsClient_BeginSampleInput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSubscriptionsClient().BeginSampleInput(ctx, "West US", armstreamanalytics.SampleInput{
		CompatibilityLevel: to.Ptr("1.2"),
		DataLocale:         to.Ptr("en-US"),
		EventsURI:          to.Ptr("http://myoutput.com"),
		Input: &armstreamanalytics.Input{
			Properties: &armstreamanalytics.StreamInputProperties{
				Type: to.Ptr("Stream"),
				Serialization: &armstreamanalytics.CSVSerialization{
					Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
					Properties: &armstreamanalytics.CSVSerializationProperties{
						Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
						FieldDelimiter: to.Ptr(","),
					},
				},
				Datasource: &armstreamanalytics.BlobStreamInputDataSource{
					Type: to.Ptr("Microsoft.Storage/Blob"),
					Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
						Container:   to.Ptr("state"),
						DateFormat:  to.Ptr("yyyy/MM/dd"),
						PathPattern: to.Ptr("{date}/{time}"),
						StorageAccounts: []*armstreamanalytics.StorageAccount{
							{
								AccountKey:  to.Ptr("someAccountKey=="),
								AccountName: to.Ptr("someAccountName"),
							}},
						TimeFormat:           to.Ptr("HH"),
						SourcePartitionCount: to.Ptr[int32](16),
					},
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Subscription_TestInput.json
func ExampleSubscriptionsClient_BeginTestInput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSubscriptionsClient().BeginTestInput(ctx, "West US", armstreamanalytics.TestInput{
		Input: &armstreamanalytics.Input{
			Properties: &armstreamanalytics.StreamInputProperties{
				Type: to.Ptr("Stream"),
				Serialization: &armstreamanalytics.CSVSerialization{
					Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
					Properties: &armstreamanalytics.CSVSerializationProperties{
						Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
						FieldDelimiter: to.Ptr(","),
					},
				},
				Datasource: &armstreamanalytics.BlobStreamInputDataSource{
					Type: to.Ptr("Microsoft.Storage/Blob"),
					Properties: &armstreamanalytics.BlobStreamInputDataSourceProperties{
						Container:   to.Ptr("state"),
						DateFormat:  to.Ptr("yyyy/MM/dd"),
						PathPattern: to.Ptr("{date}/{time}"),
						StorageAccounts: []*armstreamanalytics.StorageAccount{
							{
								AccountKey:  to.Ptr("someAccountKey=="),
								AccountName: to.Ptr("someAccountName"),
							}},
						TimeFormat:           to.Ptr("HH"),
						SourcePartitionCount: to.Ptr[int32](16),
					},
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/Subscription_TestOutput.json
func ExampleSubscriptionsClient_BeginTestOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSubscriptionsClient().BeginTestOutput(ctx, "West US", armstreamanalytics.TestOutput{
		Output: &armstreamanalytics.Output{
			Properties: &armstreamanalytics.OutputProperties{
				Datasource: &armstreamanalytics.BlobOutputDataSource{
					Type: to.Ptr("Microsoft.Storage/Blob"),
					Properties: &armstreamanalytics.BlobOutputDataSourceProperties{
						Container:   to.Ptr("state"),
						DateFormat:  to.Ptr("yyyy/MM/dd"),
						PathPattern: to.Ptr("{date}/{time}"),
						StorageAccounts: []*armstreamanalytics.StorageAccount{
							{
								AccountKey:  to.Ptr("accountKey=="),
								AccountName: to.Ptr("someAccountName"),
							}},
						TimeFormat: to.Ptr("HH"),
					},
				},
				Serialization: &armstreamanalytics.CSVSerialization{
					Type: to.Ptr(armstreamanalytics.EventSerializationTypeCSV),
					Properties: &armstreamanalytics.CSVSerializationProperties{
						Encoding:       to.Ptr(armstreamanalytics.EncodingUTF8),
						FieldDelimiter: to.Ptr(","),
					},
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
