//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/streamanalytics/armstreamanalytics/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// OutputsServer is a fake server for instances of the armstreamanalytics.OutputsClient type.
type OutputsServer struct {
	// CreateOrReplace is the fake for method OutputsClient.CreateOrReplace
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrReplace func(ctx context.Context, resourceGroupName string, jobName string, outputName string, output armstreamanalytics.Output, options *armstreamanalytics.OutputsClientCreateOrReplaceOptions) (resp azfake.Responder[armstreamanalytics.OutputsClientCreateOrReplaceResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method OutputsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, jobName string, outputName string, options *armstreamanalytics.OutputsClientDeleteOptions) (resp azfake.Responder[armstreamanalytics.OutputsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method OutputsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, jobName string, outputName string, options *armstreamanalytics.OutputsClientGetOptions) (resp azfake.Responder[armstreamanalytics.OutputsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByStreamingJobPager is the fake for method OutputsClient.NewListByStreamingJobPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByStreamingJobPager func(resourceGroupName string, jobName string, options *armstreamanalytics.OutputsClientListByStreamingJobOptions) (resp azfake.PagerResponder[armstreamanalytics.OutputsClientListByStreamingJobResponse])

	// BeginTest is the fake for method OutputsClient.BeginTest
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTest func(ctx context.Context, resourceGroupName string, jobName string, outputName string, options *armstreamanalytics.OutputsClientBeginTestOptions) (resp azfake.PollerResponder[armstreamanalytics.OutputsClientTestResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method OutputsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, jobName string, outputName string, output armstreamanalytics.Output, options *armstreamanalytics.OutputsClientUpdateOptions) (resp azfake.Responder[armstreamanalytics.OutputsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewOutputsServerTransport creates a new instance of OutputsServerTransport with the provided implementation.
// The returned OutputsServerTransport instance is connected to an instance of armstreamanalytics.OutputsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewOutputsServerTransport(srv *OutputsServer) *OutputsServerTransport {
	return &OutputsServerTransport{
		srv:                        srv,
		newListByStreamingJobPager: newTracker[azfake.PagerResponder[armstreamanalytics.OutputsClientListByStreamingJobResponse]](),
		beginTest:                  newTracker[azfake.PollerResponder[armstreamanalytics.OutputsClientTestResponse]](),
	}
}

// OutputsServerTransport connects instances of armstreamanalytics.OutputsClient to instances of OutputsServer.
// Don't use this type directly, use NewOutputsServerTransport instead.
type OutputsServerTransport struct {
	srv                        *OutputsServer
	newListByStreamingJobPager *tracker[azfake.PagerResponder[armstreamanalytics.OutputsClientListByStreamingJobResponse]]
	beginTest                  *tracker[azfake.PollerResponder[armstreamanalytics.OutputsClientTestResponse]]
}

// Do implements the policy.Transporter interface for OutputsServerTransport.
func (o *OutputsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "OutputsClient.CreateOrReplace":
		resp, err = o.dispatchCreateOrReplace(req)
	case "OutputsClient.Delete":
		resp, err = o.dispatchDelete(req)
	case "OutputsClient.Get":
		resp, err = o.dispatchGet(req)
	case "OutputsClient.NewListByStreamingJobPager":
		resp, err = o.dispatchNewListByStreamingJobPager(req)
	case "OutputsClient.BeginTest":
		resp, err = o.dispatchBeginTest(req)
	case "OutputsClient.Update":
		resp, err = o.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *OutputsServerTransport) dispatchCreateOrReplace(req *http.Request) (*http.Response, error) {
	if o.srv.CreateOrReplace == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrReplace not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outputs/(?P<outputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstreamanalytics.Output](req)
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	outputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("outputName")])
	if err != nil {
		return nil, err
	}
	var options *armstreamanalytics.OutputsClientCreateOrReplaceOptions
	if ifMatchParam != nil || ifNoneMatchParam != nil {
		options = &armstreamanalytics.OutputsClientCreateOrReplaceOptions{
			IfMatch:     ifMatchParam,
			IfNoneMatch: ifNoneMatchParam,
		}
	}
	respr, errRespr := o.srv.CreateOrReplace(req.Context(), resourceGroupNameParam, jobNameParam, outputNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Output, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (o *OutputsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if o.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outputs/(?P<outputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	outputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("outputName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := o.srv.Delete(req.Context(), resourceGroupNameParam, jobNameParam, outputNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (o *OutputsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if o.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outputs/(?P<outputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	outputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("outputName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := o.srv.Get(req.Context(), resourceGroupNameParam, jobNameParam, outputNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Output, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}

func (o *OutputsServerTransport) dispatchNewListByStreamingJobPager(req *http.Request) (*http.Response, error) {
	if o.srv.NewListByStreamingJobPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByStreamingJobPager not implemented")}
	}
	newListByStreamingJobPager := o.newListByStreamingJobPager.get(req)
	if newListByStreamingJobPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outputs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		var options *armstreamanalytics.OutputsClientListByStreamingJobOptions
		if selectParam != nil {
			options = &armstreamanalytics.OutputsClientListByStreamingJobOptions{
				Select: selectParam,
			}
		}
		resp := o.srv.NewListByStreamingJobPager(resourceGroupNameParam, jobNameParam, options)
		newListByStreamingJobPager = &resp
		o.newListByStreamingJobPager.add(req, newListByStreamingJobPager)
		server.PagerResponderInjectNextLinks(newListByStreamingJobPager, req, func(page *armstreamanalytics.OutputsClientListByStreamingJobResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByStreamingJobPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		o.newListByStreamingJobPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByStreamingJobPager) {
		o.newListByStreamingJobPager.remove(req)
	}
	return resp, nil
}

func (o *OutputsServerTransport) dispatchBeginTest(req *http.Request) (*http.Response, error) {
	if o.srv.BeginTest == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTest not implemented")}
	}
	beginTest := o.beginTest.get(req)
	if beginTest == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outputs/(?P<outputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/test`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstreamanalytics.Output](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		outputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("outputName")])
		if err != nil {
			return nil, err
		}
		var options *armstreamanalytics.OutputsClientBeginTestOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armstreamanalytics.OutputsClientBeginTestOptions{
				Output: &body,
			}
		}
		respr, errRespr := o.srv.BeginTest(req.Context(), resourceGroupNameParam, jobNameParam, outputNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTest = &respr
		o.beginTest.add(req, beginTest)
	}

	resp, err := server.PollerResponderNext(beginTest, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		o.beginTest.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTest) {
		o.beginTest.remove(req)
	}

	return resp, nil
}

func (o *OutputsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if o.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StreamAnalytics/streamingjobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outputs/(?P<outputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstreamanalytics.Output](req)
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	outputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("outputName")])
	if err != nil {
		return nil, err
	}
	var options *armstreamanalytics.OutputsClientUpdateOptions
	if ifMatchParam != nil {
		options = &armstreamanalytics.OutputsClientUpdateOptions{
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := o.srv.Update(req.Context(), resourceGroupNameParam, jobNameParam, outputNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Output, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).ETag; val != nil {
		resp.Header.Set("ETag", *val)
	}
	return resp, nil
}
