//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorageactions

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// StorageTasksReportClient contains the methods for the StorageTasksReport group.
// Don't use this type directly, use NewStorageTasksReportClient() instead.
type StorageTasksReportClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewStorageTasksReportClient creates a new instance of StorageTasksReportClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewStorageTasksReportClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*StorageTasksReportClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &StorageTasksReportClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListPager - Fetch the storage tasks run report summary for each assignment.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - storageTaskName - The name of the storage task within the specified resource group. Storage task names must be between
//     3 and 18 characters in length and use numbers and lower-case letters only.
//   - options - StorageTasksReportClientListOptions contains the optional parameters for the StorageTasksReportClient.NewListPager
//     method.
func (client *StorageTasksReportClient) NewListPager(resourceGroupName string, storageTaskName string, options *StorageTasksReportClientListOptions) *runtime.Pager[StorageTasksReportClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[StorageTasksReportClientListResponse]{
		More: func(page StorageTasksReportClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *StorageTasksReportClientListResponse) (StorageTasksReportClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "StorageTasksReportClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, storageTaskName, options)
			}, nil)
			if err != nil {
				return StorageTasksReportClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *StorageTasksReportClient) listCreateRequest(ctx context.Context, resourceGroupName string, storageTaskName string, options *StorageTasksReportClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}/reports"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if storageTaskName == "" {
		return nil, errors.New("parameter storageTaskName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{storageTaskName}", url.PathEscape(storageTaskName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Maxpagesize != nil {
		reqQP.Set("$maxpagesize", *options.Maxpagesize)
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *StorageTasksReportClient) listHandleResponse(resp *http.Response) (StorageTasksReportClientListResponse, error) {
	result := StorageTasksReportClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.StorageTaskReportSummary); err != nil {
		return StorageTasksReportClientListResponse{}, err
	}
	return result, nil
}
