//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storageactions/armstorageactions"
	"net/http"
	"net/url"
	"regexp"
)

// StorageTaskAssignmentServer is a fake server for instances of the armstorageactions.StorageTaskAssignmentClient type.
type StorageTaskAssignmentServer struct {
	// NewListPager is the fake for method StorageTaskAssignmentClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, storageTaskName string, options *armstorageactions.StorageTaskAssignmentClientListOptions) (resp azfake.PagerResponder[armstorageactions.StorageTaskAssignmentClientListResponse])
}

// NewStorageTaskAssignmentServerTransport creates a new instance of StorageTaskAssignmentServerTransport with the provided implementation.
// The returned StorageTaskAssignmentServerTransport instance is connected to an instance of armstorageactions.StorageTaskAssignmentClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewStorageTaskAssignmentServerTransport(srv *StorageTaskAssignmentServer) *StorageTaskAssignmentServerTransport {
	return &StorageTaskAssignmentServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armstorageactions.StorageTaskAssignmentClientListResponse]](),
	}
}

// StorageTaskAssignmentServerTransport connects instances of armstorageactions.StorageTaskAssignmentClient to instances of StorageTaskAssignmentServer.
// Don't use this type directly, use NewStorageTaskAssignmentServerTransport instead.
type StorageTaskAssignmentServerTransport struct {
	srv          *StorageTaskAssignmentServer
	newListPager *tracker[azfake.PagerResponder[armstorageactions.StorageTaskAssignmentClientListResponse]]
}

// Do implements the policy.Transporter interface for StorageTaskAssignmentServerTransport.
func (s *StorageTaskAssignmentServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "StorageTaskAssignmentClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *StorageTaskAssignmentServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageActions/storageTasks/(?P<storageTaskName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storageTaskAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageTaskNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageTaskName")])
		if err != nil {
			return nil, err
		}
		maxpagesizeUnescaped, err := url.QueryUnescape(qp.Get("$maxpagesize"))
		if err != nil {
			return nil, err
		}
		maxpagesizeParam := getOptional(maxpagesizeUnescaped)
		var options *armstorageactions.StorageTaskAssignmentClientListOptions
		if maxpagesizeParam != nil {
			options = &armstorageactions.StorageTaskAssignmentClientListOptions{
				Maxpagesize: maxpagesizeParam,
			}
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, storageTaskNameParam, options)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armstorageactions.StorageTaskAssignmentClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
