//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

// AgentClientCreateOrUpdateResponse contains the response from method AgentClient.CreateOrUpdate.
type AgentClientCreateOrUpdateResponse struct {
	// A recoverable managed database resource.
	AgentConfiguration
}

// AgentClientGetResponse contains the response from method AgentClient.Get.
type AgentClientGetResponse struct {
	// A recoverable managed database resource.
	AgentConfiguration
}

// BackupShortTermRetentionPoliciesClientCreateOrUpdateResponse contains the response from method BackupShortTermRetentionPoliciesClient.BeginCreateOrUpdate.
type BackupShortTermRetentionPoliciesClientCreateOrUpdateResponse struct {
	// A short term retention policy.
	BackupShortTermRetentionPolicy
}

// BackupShortTermRetentionPoliciesClientGetResponse contains the response from method BackupShortTermRetentionPoliciesClient.Get.
type BackupShortTermRetentionPoliciesClientGetResponse struct {
	// A short term retention policy.
	BackupShortTermRetentionPolicy
}

// BackupShortTermRetentionPoliciesClientListByDatabaseResponse contains the response from method BackupShortTermRetentionPoliciesClient.NewListByDatabasePager.
type BackupShortTermRetentionPoliciesClientListByDatabaseResponse struct {
	// A list of short term retention policies.
	BackupShortTermRetentionPolicyListResult
}

// BackupShortTermRetentionPoliciesClientUpdateResponse contains the response from method BackupShortTermRetentionPoliciesClient.BeginUpdate.
type BackupShortTermRetentionPoliciesClientUpdateResponse struct {
	// A short term retention policy.
	BackupShortTermRetentionPolicy
}

// CapabilitiesClientListByLocationResponse contains the response from method CapabilitiesClient.ListByLocation.
type CapabilitiesClientListByLocationResponse struct {
	// The location capability.
	LocationCapabilities
}

// DataMaskingPoliciesClientCreateOrUpdateResponse contains the response from method DataMaskingPoliciesClient.CreateOrUpdate.
type DataMaskingPoliciesClientCreateOrUpdateResponse struct {
	// Represents a database data masking policy.
	DataMaskingPolicy
}

// DataMaskingPoliciesClientGetResponse contains the response from method DataMaskingPoliciesClient.Get.
type DataMaskingPoliciesClientGetResponse struct {
	// Represents a database data masking policy.
	DataMaskingPolicy
}

// DataMaskingRulesClientCreateOrUpdateResponse contains the response from method DataMaskingRulesClient.CreateOrUpdate.
type DataMaskingRulesClientCreateOrUpdateResponse struct {
	// Represents a database data masking rule.
	DataMaskingRule
}

// DataMaskingRulesClientListByDatabaseResponse contains the response from method DataMaskingRulesClient.NewListByDatabasePager.
type DataMaskingRulesClientListByDatabaseResponse struct {
	// The response to a list data masking rules request.
	DataMaskingRuleListResult
}

// DataWarehouseUserActivitiesClientGetResponse contains the response from method DataWarehouseUserActivitiesClient.Get.
type DataWarehouseUserActivitiesClientGetResponse struct {
	// User activities of a data warehouse
	DataWarehouseUserActivities
}

// DataWarehouseUserActivitiesClientListByDatabaseResponse contains the response from method DataWarehouseUserActivitiesClient.NewListByDatabasePager.
type DataWarehouseUserActivitiesClientListByDatabaseResponse struct {
	// User activities of a data warehouse
	DataWarehouseUserActivitiesListResult
}

// DatabaseAdvancedThreatProtectionSettingsClientCreateOrUpdateResponse contains the response from method DatabaseAdvancedThreatProtectionSettingsClient.CreateOrUpdate.
type DatabaseAdvancedThreatProtectionSettingsClientCreateOrUpdateResponse struct {
	// A database Advanced Threat Protection.
	DatabaseAdvancedThreatProtection
}

// DatabaseAdvancedThreatProtectionSettingsClientGetResponse contains the response from method DatabaseAdvancedThreatProtectionSettingsClient.Get.
type DatabaseAdvancedThreatProtectionSettingsClientGetResponse struct {
	// A database Advanced Threat Protection.
	DatabaseAdvancedThreatProtection
}

// DatabaseAdvancedThreatProtectionSettingsClientListByDatabaseResponse contains the response from method DatabaseAdvancedThreatProtectionSettingsClient.NewListByDatabasePager.
type DatabaseAdvancedThreatProtectionSettingsClientListByDatabaseResponse struct {
	// A list of the database's Advanced Threat Protection configurations.
	DatabaseAdvancedThreatProtectionListResult
}

// DatabaseAdvisorsClientGetResponse contains the response from method DatabaseAdvisorsClient.Get.
type DatabaseAdvisorsClientGetResponse struct {
	// Database, Server or Elastic Pool Advisor.
	Advisor
}

// DatabaseAdvisorsClientListByDatabaseResponse contains the response from method DatabaseAdvisorsClient.ListByDatabase.
type DatabaseAdvisorsClientListByDatabaseResponse struct {
	// Array of Advisor
	AdvisorArray []*Advisor
}

// DatabaseAdvisorsClientUpdateResponse contains the response from method DatabaseAdvisorsClient.Update.
type DatabaseAdvisorsClientUpdateResponse struct {
	// Database, Server or Elastic Pool Advisor.
	Advisor
}

// DatabaseAutomaticTuningClientGetResponse contains the response from method DatabaseAutomaticTuningClient.Get.
type DatabaseAutomaticTuningClientGetResponse struct {
	// Database-level Automatic Tuning.
	DatabaseAutomaticTuning
}

// DatabaseAutomaticTuningClientUpdateResponse contains the response from method DatabaseAutomaticTuningClient.Update.
type DatabaseAutomaticTuningClientUpdateResponse struct {
	// Database-level Automatic Tuning.
	DatabaseAutomaticTuning
}

// DatabaseBlobAuditingPoliciesClientCreateOrUpdateResponse contains the response from method DatabaseBlobAuditingPoliciesClient.CreateOrUpdate.
type DatabaseBlobAuditingPoliciesClientCreateOrUpdateResponse struct {
	// A database blob auditing policy.
	DatabaseBlobAuditingPolicy
}

// DatabaseBlobAuditingPoliciesClientGetResponse contains the response from method DatabaseBlobAuditingPoliciesClient.Get.
type DatabaseBlobAuditingPoliciesClientGetResponse struct {
	// A database blob auditing policy.
	DatabaseBlobAuditingPolicy
}

// DatabaseBlobAuditingPoliciesClientListByDatabaseResponse contains the response from method DatabaseBlobAuditingPoliciesClient.NewListByDatabasePager.
type DatabaseBlobAuditingPoliciesClientListByDatabaseResponse struct {
	// A list of database auditing settings.
	DatabaseBlobAuditingPolicyListResult
}

// DatabaseColumnsClientGetResponse contains the response from method DatabaseColumnsClient.Get.
type DatabaseColumnsClientGetResponse struct {
	// A database column resource.
	DatabaseColumn
}

// DatabaseColumnsClientListByDatabaseResponse contains the response from method DatabaseColumnsClient.NewListByDatabasePager.
type DatabaseColumnsClientListByDatabaseResponse struct {
	// A list of database columns.
	DatabaseColumnListResult
}

// DatabaseColumnsClientListByTableResponse contains the response from method DatabaseColumnsClient.NewListByTablePager.
type DatabaseColumnsClientListByTableResponse struct {
	// A list of database columns.
	DatabaseColumnListResult
}

// DatabaseEncryptionProtectorsClientRevalidateResponse contains the response from method DatabaseEncryptionProtectorsClient.BeginRevalidate.
type DatabaseEncryptionProtectorsClientRevalidateResponse struct {
	// placeholder for future response values
}

// DatabaseEncryptionProtectorsClientRevertResponse contains the response from method DatabaseEncryptionProtectorsClient.BeginRevert.
type DatabaseEncryptionProtectorsClientRevertResponse struct {
	// placeholder for future response values
}

// DatabaseExtensionsClientCreateOrUpdateResponse contains the response from method DatabaseExtensionsClient.BeginCreateOrUpdate.
type DatabaseExtensionsClientCreateOrUpdateResponse struct {
	// An Extension operation result resource.
	ImportExportExtensionsOperationResult
}

// DatabaseExtensionsClientGetResponse contains the response from method DatabaseExtensionsClient.Get.
type DatabaseExtensionsClientGetResponse struct {
	// placeholder for future response values
}

// DatabaseExtensionsClientListByDatabaseResponse contains the response from method DatabaseExtensionsClient.NewListByDatabasePager.
type DatabaseExtensionsClientListByDatabaseResponse struct {
	// Import export operation extensions list.
	ImportExportExtensionsOperationListResult
}

// DatabaseOperationsClientCancelResponse contains the response from method DatabaseOperationsClient.Cancel.
type DatabaseOperationsClientCancelResponse struct {
	// placeholder for future response values
}

// DatabaseOperationsClientListByDatabaseResponse contains the response from method DatabaseOperationsClient.NewListByDatabasePager.
type DatabaseOperationsClientListByDatabaseResponse struct {
	// The response to a list database operations request
	DatabaseOperationListResult
}

// DatabaseRecommendedActionsClientGetResponse contains the response from method DatabaseRecommendedActionsClient.Get.
type DatabaseRecommendedActionsClientGetResponse struct {
	// Database, Server or Elastic Pool Recommended Action.
	RecommendedAction
}

// DatabaseRecommendedActionsClientListByDatabaseAdvisorResponse contains the response from method DatabaseRecommendedActionsClient.ListByDatabaseAdvisor.
type DatabaseRecommendedActionsClientListByDatabaseAdvisorResponse struct {
	// Array of RecommendedAction
	RecommendedActionArray []*RecommendedAction
}

// DatabaseRecommendedActionsClientUpdateResponse contains the response from method DatabaseRecommendedActionsClient.Update.
type DatabaseRecommendedActionsClientUpdateResponse struct {
	// Database, Server or Elastic Pool Recommended Action.
	RecommendedAction
}

// DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse contains the response from method DatabaseSQLVulnerabilityAssessmentBaselinesClient.CreateOrUpdate.
type DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse struct {
	// A database sql vulnerability assessment baseline set.
	DatabaseSQLVulnerabilityAssessmentBaselineSet
}

// DatabaseSQLVulnerabilityAssessmentBaselinesClientGetResponse contains the response from method DatabaseSQLVulnerabilityAssessmentBaselinesClient.Get.
type DatabaseSQLVulnerabilityAssessmentBaselinesClientGetResponse struct {
	// A database sql vulnerability assessment baseline set.
	DatabaseSQLVulnerabilityAssessmentBaselineSet
}

// DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse contains the response from method
// DatabaseSQLVulnerabilityAssessmentBaselinesClient.NewListBySQLVulnerabilityAssessmentPager.
type DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse struct {
	// A list of SQL Vulnerability Assessments baseline set.
	DatabaseSQLVulnerabilityAssessmentBaselineSetListResult
}

// DatabaseSQLVulnerabilityAssessmentExecuteScanClientExecuteResponse contains the response from method DatabaseSQLVulnerabilityAssessmentExecuteScanClient.BeginExecute.
type DatabaseSQLVulnerabilityAssessmentExecuteScanClientExecuteResponse struct {
	// placeholder for future response values
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse contains the response from method DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate.
type DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse struct {
	// A database sql vulnerability assessment rule baseline.
	DatabaseSQLVulnerabilityAssessmentRuleBaseline
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientDeleteResponse contains the response from method DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.Delete.
type DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientDeleteResponse struct {
	// placeholder for future response values
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetResponse contains the response from method DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.Get.
type DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientGetResponse struct {
	// A database sql vulnerability assessment rule baseline.
	DatabaseSQLVulnerabilityAssessmentRuleBaseline
}

// DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse contains the response from method DatabaseSQLVulnerabilityAssessmentRuleBaselinesClient.NewListByBaselinePager.
type DatabaseSQLVulnerabilityAssessmentRuleBaselinesClientListByBaselineResponse struct {
	// A list of SQL Vulnerability Assessments rule baseline.
	DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult
}

// DatabaseSQLVulnerabilityAssessmentScanResultClientGetResponse contains the response from method DatabaseSQLVulnerabilityAssessmentScanResultClient.Get.
type DatabaseSQLVulnerabilityAssessmentScanResultClientGetResponse struct {
	VulnerabilityAssessmentScanResults
}

// DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse contains the response from method DatabaseSQLVulnerabilityAssessmentScanResultClient.NewListByScanPager.
type DatabaseSQLVulnerabilityAssessmentScanResultClientListByScanResponse struct {
	// A list of vulnerability assessment scan results.
	VulnerabilityAssessmentScanListResult
}

// DatabaseSQLVulnerabilityAssessmentScansClientGetResponse contains the response from method DatabaseSQLVulnerabilityAssessmentScansClient.Get.
type DatabaseSQLVulnerabilityAssessmentScansClientGetResponse struct {
	// A vulnerability assessment scan record.
	VulnerabilityAssessmentScanRecordForSQL
}

// DatabaseSQLVulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse contains the response from method
// DatabaseSQLVulnerabilityAssessmentScansClient.NewListBySQLVulnerabilityAssessmentsPager.
type DatabaseSQLVulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse struct {
	// A list of vulnerability assessment scan records.
	VulnerabilityAssessmentScanRecordForSQLListResult
}

// DatabaseSQLVulnerabilityAssessmentsSettingsClientGetResponse contains the response from method DatabaseSQLVulnerabilityAssessmentsSettingsClient.Get.
type DatabaseSQLVulnerabilityAssessmentsSettingsClientGetResponse struct {
	// A SQL Vulnerability Assessment.
	VulnerabilityAssessment
}

// DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse contains the response from method DatabaseSQLVulnerabilityAssessmentsSettingsClient.NewListByDatabasePager.
type DatabaseSQLVulnerabilityAssessmentsSettingsClientListByDatabaseResponse struct {
	// A list of SQL Vulnerability Assessments.
	VulnerabilityAssessmentListResult
}

// DatabaseSchemasClientGetResponse contains the response from method DatabaseSchemasClient.Get.
type DatabaseSchemasClientGetResponse struct {
	// A database schema resource.
	DatabaseSchema
}

// DatabaseSchemasClientListByDatabaseResponse contains the response from method DatabaseSchemasClient.NewListByDatabasePager.
type DatabaseSchemasClientListByDatabaseResponse struct {
	// A list of database schemas.
	DatabaseSchemaListResult
}

// DatabaseSecurityAlertPoliciesClientCreateOrUpdateResponse contains the response from method DatabaseSecurityAlertPoliciesClient.CreateOrUpdate.
type DatabaseSecurityAlertPoliciesClientCreateOrUpdateResponse struct {
	// A database security alert policy.
	DatabaseSecurityAlertPolicy
}

// DatabaseSecurityAlertPoliciesClientGetResponse contains the response from method DatabaseSecurityAlertPoliciesClient.Get.
type DatabaseSecurityAlertPoliciesClientGetResponse struct {
	// A database security alert policy.
	DatabaseSecurityAlertPolicy
}

// DatabaseSecurityAlertPoliciesClientListByDatabaseResponse contains the response from method DatabaseSecurityAlertPoliciesClient.NewListByDatabasePager.
type DatabaseSecurityAlertPoliciesClientListByDatabaseResponse struct {
	// A list of the database's security alert policies.
	DatabaseSecurityAlertListResult
}

// DatabaseTablesClientGetResponse contains the response from method DatabaseTablesClient.Get.
type DatabaseTablesClientGetResponse struct {
	// A database table resource.
	DatabaseTable
}

// DatabaseTablesClientListBySchemaResponse contains the response from method DatabaseTablesClient.NewListBySchemaPager.
type DatabaseTablesClientListBySchemaResponse struct {
	// A list of database tables.
	DatabaseTableListResult
}

// DatabaseUsagesClientListByDatabaseResponse contains the response from method DatabaseUsagesClient.NewListByDatabasePager.
type DatabaseUsagesClientListByDatabaseResponse struct {
	// A list of database usage metrics.
	DatabaseUsageListResult
}

// DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse contains the response from method DatabaseVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate.
type DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse struct {
	// A database vulnerability assessment rule baseline.
	DatabaseVulnerabilityAssessmentRuleBaseline
}

// DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse contains the response from method DatabaseVulnerabilityAssessmentRuleBaselinesClient.Delete.
type DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse struct {
	// placeholder for future response values
}

// DatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse contains the response from method DatabaseVulnerabilityAssessmentRuleBaselinesClient.Get.
type DatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse struct {
	// A database vulnerability assessment rule baseline.
	DatabaseVulnerabilityAssessmentRuleBaseline
}

// DatabaseVulnerabilityAssessmentScansClientExportResponse contains the response from method DatabaseVulnerabilityAssessmentScansClient.Export.
type DatabaseVulnerabilityAssessmentScansClientExportResponse struct {
	// A database Vulnerability Assessment scan export resource.
	DatabaseVulnerabilityAssessmentScansExport
}

// DatabaseVulnerabilityAssessmentScansClientGetResponse contains the response from method DatabaseVulnerabilityAssessmentScansClient.Get.
type DatabaseVulnerabilityAssessmentScansClientGetResponse struct {
	// A vulnerability assessment scan record.
	VulnerabilityAssessmentScanRecord
}

// DatabaseVulnerabilityAssessmentScansClientInitiateScanResponse contains the response from method DatabaseVulnerabilityAssessmentScansClient.BeginInitiateScan.
type DatabaseVulnerabilityAssessmentScansClientInitiateScanResponse struct {
	// placeholder for future response values
}

// DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse contains the response from method DatabaseVulnerabilityAssessmentScansClient.NewListByDatabasePager.
type DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse struct {
	// A list of vulnerability assessment scan records.
	VulnerabilityAssessmentScanRecordListResult
}

// DatabaseVulnerabilityAssessmentsClientCreateOrUpdateResponse contains the response from method DatabaseVulnerabilityAssessmentsClient.CreateOrUpdate.
type DatabaseVulnerabilityAssessmentsClientCreateOrUpdateResponse struct {
	// A database vulnerability assessment.
	DatabaseVulnerabilityAssessment
}

// DatabaseVulnerabilityAssessmentsClientDeleteResponse contains the response from method DatabaseVulnerabilityAssessmentsClient.Delete.
type DatabaseVulnerabilityAssessmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// DatabaseVulnerabilityAssessmentsClientGetResponse contains the response from method DatabaseVulnerabilityAssessmentsClient.Get.
type DatabaseVulnerabilityAssessmentsClientGetResponse struct {
	// A database vulnerability assessment.
	DatabaseVulnerabilityAssessment
}

// DatabaseVulnerabilityAssessmentsClientListByDatabaseResponse contains the response from method DatabaseVulnerabilityAssessmentsClient.NewListByDatabasePager.
type DatabaseVulnerabilityAssessmentsClientListByDatabaseResponse struct {
	// A list of the database's vulnerability assessments.
	DatabaseVulnerabilityAssessmentListResult
}

// DatabasesClientCreateOrUpdateResponse contains the response from method DatabasesClient.BeginCreateOrUpdate.
type DatabasesClientCreateOrUpdateResponse struct {
	// A database resource.
	Database
}

// DatabasesClientDeleteResponse contains the response from method DatabasesClient.BeginDelete.
type DatabasesClientDeleteResponse struct {
	// placeholder for future response values
}

// DatabasesClientExportResponse contains the response from method DatabasesClient.BeginExport.
type DatabasesClientExportResponse struct {
	// An ImportExport operation result resource.
	ImportExportOperationResult
}

// DatabasesClientFailoverResponse contains the response from method DatabasesClient.BeginFailover.
type DatabasesClientFailoverResponse struct {
	// placeholder for future response values
}

// DatabasesClientGetResponse contains the response from method DatabasesClient.Get.
type DatabasesClientGetResponse struct {
	// A database resource.
	Database
}

// DatabasesClientImportResponse contains the response from method DatabasesClient.BeginImport.
type DatabasesClientImportResponse struct {
	// An ImportExport operation result resource.
	ImportExportOperationResult
}

// DatabasesClientListByElasticPoolResponse contains the response from method DatabasesClient.NewListByElasticPoolPager.
type DatabasesClientListByElasticPoolResponse struct {
	// A list of databases.
	DatabaseListResult
}

// DatabasesClientListByServerResponse contains the response from method DatabasesClient.NewListByServerPager.
type DatabasesClientListByServerResponse struct {
	// A list of databases.
	DatabaseListResult
}

// DatabasesClientListInaccessibleByServerResponse contains the response from method DatabasesClient.NewListInaccessibleByServerPager.
type DatabasesClientListInaccessibleByServerResponse struct {
	// A list of databases.
	DatabaseListResult
}

// DatabasesClientListMetricDefinitionsResponse contains the response from method DatabasesClient.NewListMetricDefinitionsPager.
type DatabasesClientListMetricDefinitionsResponse struct {
	// The response to a list database metric definitions request.
	MetricDefinitionListResult
}

// DatabasesClientListMetricsResponse contains the response from method DatabasesClient.NewListMetricsPager.
type DatabasesClientListMetricsResponse struct {
	// The response to a list database metrics request.
	MetricListResult
}

// DatabasesClientPauseResponse contains the response from method DatabasesClient.BeginPause.
type DatabasesClientPauseResponse struct {
	// A database resource.
	Database
}

// DatabasesClientRenameResponse contains the response from method DatabasesClient.Rename.
type DatabasesClientRenameResponse struct {
	// placeholder for future response values
}

// DatabasesClientResumeResponse contains the response from method DatabasesClient.BeginResume.
type DatabasesClientResumeResponse struct {
	// A database resource.
	Database
}

// DatabasesClientUpdateResponse contains the response from method DatabasesClient.BeginUpdate.
type DatabasesClientUpdateResponse struct {
	// A database resource.
	Database
}

// DatabasesClientUpgradeDataWarehouseResponse contains the response from method DatabasesClient.BeginUpgradeDataWarehouse.
type DatabasesClientUpgradeDataWarehouseResponse struct {
	// placeholder for future response values
}

// DeletedServersClientGetResponse contains the response from method DeletedServersClient.Get.
type DeletedServersClientGetResponse struct {
	// A deleted server.
	DeletedServer
}

// DeletedServersClientListByLocationResponse contains the response from method DeletedServersClient.NewListByLocationPager.
type DeletedServersClientListByLocationResponse struct {
	// A list of deleted servers.
	DeletedServerListResult
}

// DeletedServersClientListResponse contains the response from method DeletedServersClient.NewListPager.
type DeletedServersClientListResponse struct {
	// A list of deleted servers.
	DeletedServerListResult
}

// DeletedServersClientRecoverResponse contains the response from method DeletedServersClient.BeginRecover.
type DeletedServersClientRecoverResponse struct {
	// A deleted server.
	DeletedServer
}

// DistributedAvailabilityGroupsClientCreateOrUpdateResponse contains the response from method DistributedAvailabilityGroupsClient.BeginCreateOrUpdate.
type DistributedAvailabilityGroupsClientCreateOrUpdateResponse struct {
	// Distributed availability group between box and Sql Managed Instance.
	DistributedAvailabilityGroup
}

// DistributedAvailabilityGroupsClientDeleteResponse contains the response from method DistributedAvailabilityGroupsClient.BeginDelete.
type DistributedAvailabilityGroupsClientDeleteResponse struct {
	// placeholder for future response values
}

// DistributedAvailabilityGroupsClientGetResponse contains the response from method DistributedAvailabilityGroupsClient.Get.
type DistributedAvailabilityGroupsClientGetResponse struct {
	// Distributed availability group between box and Sql Managed Instance.
	DistributedAvailabilityGroup
}

// DistributedAvailabilityGroupsClientListByInstanceResponse contains the response from method DistributedAvailabilityGroupsClient.NewListByInstancePager.
type DistributedAvailabilityGroupsClientListByInstanceResponse struct {
	// A list of distributed availability groups in instance.
	DistributedAvailabilityGroupsListResult
}

// DistributedAvailabilityGroupsClientUpdateResponse contains the response from method DistributedAvailabilityGroupsClient.BeginUpdate.
type DistributedAvailabilityGroupsClientUpdateResponse struct {
	// Distributed availability group between box and Sql Managed Instance.
	DistributedAvailabilityGroup
}

// ElasticPoolActivitiesClientListByElasticPoolResponse contains the response from method ElasticPoolActivitiesClient.NewListByElasticPoolPager.
type ElasticPoolActivitiesClientListByElasticPoolResponse struct {
	// Represents the response to a list elastic pool activity request.
	ElasticPoolActivityListResult
}

// ElasticPoolDatabaseActivitiesClientListByElasticPoolResponse contains the response from method ElasticPoolDatabaseActivitiesClient.NewListByElasticPoolPager.
type ElasticPoolDatabaseActivitiesClientListByElasticPoolResponse struct {
	// Represents the response to a list elastic pool database activity request.
	ElasticPoolDatabaseActivityListResult
}

// ElasticPoolOperationsClientCancelResponse contains the response from method ElasticPoolOperationsClient.Cancel.
type ElasticPoolOperationsClientCancelResponse struct {
	// placeholder for future response values
}

// ElasticPoolOperationsClientListByElasticPoolResponse contains the response from method ElasticPoolOperationsClient.NewListByElasticPoolPager.
type ElasticPoolOperationsClientListByElasticPoolResponse struct {
	// The response to a list elastic pool operations request
	ElasticPoolOperationListResult
}

// ElasticPoolsClientCreateOrUpdateResponse contains the response from method ElasticPoolsClient.BeginCreateOrUpdate.
type ElasticPoolsClientCreateOrUpdateResponse struct {
	// An elastic pool.
	ElasticPool
}

// ElasticPoolsClientDeleteResponse contains the response from method ElasticPoolsClient.BeginDelete.
type ElasticPoolsClientDeleteResponse struct {
	// placeholder for future response values
}

// ElasticPoolsClientFailoverResponse contains the response from method ElasticPoolsClient.BeginFailover.
type ElasticPoolsClientFailoverResponse struct {
	// placeholder for future response values
}

// ElasticPoolsClientGetResponse contains the response from method ElasticPoolsClient.Get.
type ElasticPoolsClientGetResponse struct {
	// An elastic pool.
	ElasticPool
}

// ElasticPoolsClientListByServerResponse contains the response from method ElasticPoolsClient.NewListByServerPager.
type ElasticPoolsClientListByServerResponse struct {
	// The result of an elastic pool list request.
	ElasticPoolListResult
}

// ElasticPoolsClientListMetricDefinitionsResponse contains the response from method ElasticPoolsClient.NewListMetricDefinitionsPager.
type ElasticPoolsClientListMetricDefinitionsResponse struct {
	// The response to a list database metric definitions request.
	MetricDefinitionListResult
}

// ElasticPoolsClientListMetricsResponse contains the response from method ElasticPoolsClient.NewListMetricsPager.
type ElasticPoolsClientListMetricsResponse struct {
	// The response to a list database metrics request.
	MetricListResult
}

// ElasticPoolsClientUpdateResponse contains the response from method ElasticPoolsClient.BeginUpdate.
type ElasticPoolsClientUpdateResponse struct {
	// An elastic pool.
	ElasticPool
}

// EncryptionProtectorsClientCreateOrUpdateResponse contains the response from method EncryptionProtectorsClient.BeginCreateOrUpdate.
type EncryptionProtectorsClientCreateOrUpdateResponse struct {
	// The server encryption protector.
	EncryptionProtector
}

// EncryptionProtectorsClientGetResponse contains the response from method EncryptionProtectorsClient.Get.
type EncryptionProtectorsClientGetResponse struct {
	// The server encryption protector.
	EncryptionProtector
}

// EncryptionProtectorsClientListByServerResponse contains the response from method EncryptionProtectorsClient.NewListByServerPager.
type EncryptionProtectorsClientListByServerResponse struct {
	// A list of server encryption protectors.
	EncryptionProtectorListResult
}

// EncryptionProtectorsClientRevalidateResponse contains the response from method EncryptionProtectorsClient.BeginRevalidate.
type EncryptionProtectorsClientRevalidateResponse struct {
	// placeholder for future response values
}

// EndpointCertificatesClientGetResponse contains the response from method EndpointCertificatesClient.Get.
type EndpointCertificatesClientGetResponse struct {
	// Certificate used on an endpoint on the Managed Instance.
	EndpointCertificate
}

// EndpointCertificatesClientListByInstanceResponse contains the response from method EndpointCertificatesClient.NewListByInstancePager.
type EndpointCertificatesClientListByInstanceResponse struct {
	// A list of endpoint certificates on the target instance.
	EndpointCertificateListResult
}

// ExtendedDatabaseBlobAuditingPoliciesClientCreateOrUpdateResponse contains the response from method ExtendedDatabaseBlobAuditingPoliciesClient.CreateOrUpdate.
type ExtendedDatabaseBlobAuditingPoliciesClientCreateOrUpdateResponse struct {
	// An extended database blob auditing policy.
	ExtendedDatabaseBlobAuditingPolicy
}

// ExtendedDatabaseBlobAuditingPoliciesClientGetResponse contains the response from method ExtendedDatabaseBlobAuditingPoliciesClient.Get.
type ExtendedDatabaseBlobAuditingPoliciesClientGetResponse struct {
	// An extended database blob auditing policy.
	ExtendedDatabaseBlobAuditingPolicy
}

// ExtendedDatabaseBlobAuditingPoliciesClientListByDatabaseResponse contains the response from method ExtendedDatabaseBlobAuditingPoliciesClient.NewListByDatabasePager.
type ExtendedDatabaseBlobAuditingPoliciesClientListByDatabaseResponse struct {
	// A list of database extended auditing settings.
	ExtendedDatabaseBlobAuditingPolicyListResult
}

// ExtendedServerBlobAuditingPoliciesClientCreateOrUpdateResponse contains the response from method ExtendedServerBlobAuditingPoliciesClient.BeginCreateOrUpdate.
type ExtendedServerBlobAuditingPoliciesClientCreateOrUpdateResponse struct {
	// An extended server blob auditing policy.
	ExtendedServerBlobAuditingPolicy
}

// ExtendedServerBlobAuditingPoliciesClientGetResponse contains the response from method ExtendedServerBlobAuditingPoliciesClient.Get.
type ExtendedServerBlobAuditingPoliciesClientGetResponse struct {
	// An extended server blob auditing policy.
	ExtendedServerBlobAuditingPolicy
}

// ExtendedServerBlobAuditingPoliciesClientListByServerResponse contains the response from method ExtendedServerBlobAuditingPoliciesClient.NewListByServerPager.
type ExtendedServerBlobAuditingPoliciesClientListByServerResponse struct {
	// A list of server extended auditing settings.
	ExtendedServerBlobAuditingPolicyListResult
}

// FailoverGroupsClientCreateOrUpdateResponse contains the response from method FailoverGroupsClient.BeginCreateOrUpdate.
type FailoverGroupsClientCreateOrUpdateResponse struct {
	// A failover group.
	FailoverGroup
}

// FailoverGroupsClientDeleteResponse contains the response from method FailoverGroupsClient.BeginDelete.
type FailoverGroupsClientDeleteResponse struct {
	// placeholder for future response values
}

// FailoverGroupsClientFailoverResponse contains the response from method FailoverGroupsClient.BeginFailover.
type FailoverGroupsClientFailoverResponse struct {
	// A failover group.
	FailoverGroup
}

// FailoverGroupsClientForceFailoverAllowDataLossResponse contains the response from method FailoverGroupsClient.BeginForceFailoverAllowDataLoss.
type FailoverGroupsClientForceFailoverAllowDataLossResponse struct {
	// A failover group.
	FailoverGroup
}

// FailoverGroupsClientGetResponse contains the response from method FailoverGroupsClient.Get.
type FailoverGroupsClientGetResponse struct {
	// A failover group.
	FailoverGroup
}

// FailoverGroupsClientListByServerResponse contains the response from method FailoverGroupsClient.NewListByServerPager.
type FailoverGroupsClientListByServerResponse struct {
	// A list of failover groups.
	FailoverGroupListResult
}

// FailoverGroupsClientTryPlannedBeforeForcedFailoverResponse contains the response from method FailoverGroupsClient.BeginTryPlannedBeforeForcedFailover.
type FailoverGroupsClientTryPlannedBeforeForcedFailoverResponse struct {
	// A failover group.
	FailoverGroup
}

// FailoverGroupsClientUpdateResponse contains the response from method FailoverGroupsClient.BeginUpdate.
type FailoverGroupsClientUpdateResponse struct {
	// A failover group.
	FailoverGroup
}

// FirewallRulesClientCreateOrUpdateResponse contains the response from method FirewallRulesClient.CreateOrUpdate.
type FirewallRulesClientCreateOrUpdateResponse struct {
	// A server firewall rule.
	FirewallRule
}

// FirewallRulesClientDeleteResponse contains the response from method FirewallRulesClient.Delete.
type FirewallRulesClientDeleteResponse struct {
	// placeholder for future response values
}

// FirewallRulesClientGetResponse contains the response from method FirewallRulesClient.Get.
type FirewallRulesClientGetResponse struct {
	// A server firewall rule.
	FirewallRule
}

// FirewallRulesClientListByServerResponse contains the response from method FirewallRulesClient.NewListByServerPager.
type FirewallRulesClientListByServerResponse struct {
	// The response to a list firewall rules request
	FirewallRuleListResult
}

// FirewallRulesClientReplaceResponse contains the response from method FirewallRulesClient.Replace.
type FirewallRulesClientReplaceResponse struct {
	// A server firewall rule.
	FirewallRule
}

// GeoBackupPoliciesClientCreateOrUpdateResponse contains the response from method GeoBackupPoliciesClient.CreateOrUpdate.
type GeoBackupPoliciesClientCreateOrUpdateResponse struct {
	// A database geo backup policy.
	GeoBackupPolicy
}

// GeoBackupPoliciesClientGetResponse contains the response from method GeoBackupPoliciesClient.Get.
type GeoBackupPoliciesClientGetResponse struct {
	// A database geo backup policy.
	GeoBackupPolicy
}

// GeoBackupPoliciesClientListByDatabaseResponse contains the response from method GeoBackupPoliciesClient.NewListByDatabasePager.
type GeoBackupPoliciesClientListByDatabaseResponse struct {
	// The response to a list geo backup policies request.
	GeoBackupPolicyListResult
}

// IPv6FirewallRulesClientCreateOrUpdateResponse contains the response from method IPv6FirewallRulesClient.CreateOrUpdate.
type IPv6FirewallRulesClientCreateOrUpdateResponse struct {
	// An IPv6 server firewall rule.
	IPv6FirewallRule
}

// IPv6FirewallRulesClientDeleteResponse contains the response from method IPv6FirewallRulesClient.Delete.
type IPv6FirewallRulesClientDeleteResponse struct {
	// placeholder for future response values
}

// IPv6FirewallRulesClientGetResponse contains the response from method IPv6FirewallRulesClient.Get.
type IPv6FirewallRulesClientGetResponse struct {
	// An IPv6 server firewall rule.
	IPv6FirewallRule
}

// IPv6FirewallRulesClientListByServerResponse contains the response from method IPv6FirewallRulesClient.NewListByServerPager.
type IPv6FirewallRulesClientListByServerResponse struct {
	// The response to a list IPv6 firewall rules request
	IPv6FirewallRuleListResult
}

// InstanceFailoverGroupsClientCreateOrUpdateResponse contains the response from method InstanceFailoverGroupsClient.BeginCreateOrUpdate.
type InstanceFailoverGroupsClientCreateOrUpdateResponse struct {
	// An instance failover group.
	InstanceFailoverGroup
}

// InstanceFailoverGroupsClientDeleteResponse contains the response from method InstanceFailoverGroupsClient.BeginDelete.
type InstanceFailoverGroupsClientDeleteResponse struct {
	// placeholder for future response values
}

// InstanceFailoverGroupsClientFailoverResponse contains the response from method InstanceFailoverGroupsClient.BeginFailover.
type InstanceFailoverGroupsClientFailoverResponse struct {
	// An instance failover group.
	InstanceFailoverGroup
}

// InstanceFailoverGroupsClientForceFailoverAllowDataLossResponse contains the response from method InstanceFailoverGroupsClient.BeginForceFailoverAllowDataLoss.
type InstanceFailoverGroupsClientForceFailoverAllowDataLossResponse struct {
	// An instance failover group.
	InstanceFailoverGroup
}

// InstanceFailoverGroupsClientGetResponse contains the response from method InstanceFailoverGroupsClient.Get.
type InstanceFailoverGroupsClientGetResponse struct {
	// An instance failover group.
	InstanceFailoverGroup
}

// InstanceFailoverGroupsClientListByLocationResponse contains the response from method InstanceFailoverGroupsClient.NewListByLocationPager.
type InstanceFailoverGroupsClientListByLocationResponse struct {
	// A list of instance failover groups.
	InstanceFailoverGroupListResult
}

// InstancePoolsClientCreateOrUpdateResponse contains the response from method InstancePoolsClient.BeginCreateOrUpdate.
type InstancePoolsClientCreateOrUpdateResponse struct {
	// An Azure SQL instance pool.
	InstancePool
}

// InstancePoolsClientDeleteResponse contains the response from method InstancePoolsClient.BeginDelete.
type InstancePoolsClientDeleteResponse struct {
	// placeholder for future response values
}

// InstancePoolsClientGetResponse contains the response from method InstancePoolsClient.Get.
type InstancePoolsClientGetResponse struct {
	// An Azure SQL instance pool.
	InstancePool
}

// InstancePoolsClientListByResourceGroupResponse contains the response from method InstancePoolsClient.NewListByResourceGroupPager.
type InstancePoolsClientListByResourceGroupResponse struct {
	// A list of Azure SQL instance pools.
	InstancePoolListResult
}

// InstancePoolsClientListResponse contains the response from method InstancePoolsClient.NewListPager.
type InstancePoolsClientListResponse struct {
	// A list of Azure SQL instance pools.
	InstancePoolListResult
}

// InstancePoolsClientUpdateResponse contains the response from method InstancePoolsClient.BeginUpdate.
type InstancePoolsClientUpdateResponse struct {
	// An Azure SQL instance pool.
	InstancePool
}

// JobAgentsClientCreateOrUpdateResponse contains the response from method JobAgentsClient.BeginCreateOrUpdate.
type JobAgentsClientCreateOrUpdateResponse struct {
	// An Azure SQL job agent.
	JobAgent
}

// JobAgentsClientDeleteResponse contains the response from method JobAgentsClient.BeginDelete.
type JobAgentsClientDeleteResponse struct {
	// placeholder for future response values
}

// JobAgentsClientGetResponse contains the response from method JobAgentsClient.Get.
type JobAgentsClientGetResponse struct {
	// An Azure SQL job agent.
	JobAgent
}

// JobAgentsClientListByServerResponse contains the response from method JobAgentsClient.NewListByServerPager.
type JobAgentsClientListByServerResponse struct {
	// A list of Azure SQL job agents.
	JobAgentListResult
}

// JobAgentsClientUpdateResponse contains the response from method JobAgentsClient.BeginUpdate.
type JobAgentsClientUpdateResponse struct {
	// An Azure SQL job agent.
	JobAgent
}

// JobCredentialsClientCreateOrUpdateResponse contains the response from method JobCredentialsClient.CreateOrUpdate.
type JobCredentialsClientCreateOrUpdateResponse struct {
	// A stored credential that can be used by a job to connect to target databases.
	JobCredential
}

// JobCredentialsClientDeleteResponse contains the response from method JobCredentialsClient.Delete.
type JobCredentialsClientDeleteResponse struct {
	// placeholder for future response values
}

// JobCredentialsClientGetResponse contains the response from method JobCredentialsClient.Get.
type JobCredentialsClientGetResponse struct {
	// A stored credential that can be used by a job to connect to target databases.
	JobCredential
}

// JobCredentialsClientListByAgentResponse contains the response from method JobCredentialsClient.NewListByAgentPager.
type JobCredentialsClientListByAgentResponse struct {
	// A list of job credentials.
	JobCredentialListResult
}

// JobExecutionsClientCancelResponse contains the response from method JobExecutionsClient.Cancel.
type JobExecutionsClientCancelResponse struct {
	// placeholder for future response values
}

// JobExecutionsClientCreateOrUpdateResponse contains the response from method JobExecutionsClient.BeginCreateOrUpdate.
type JobExecutionsClientCreateOrUpdateResponse struct {
	// An execution of a job
	JobExecution
}

// JobExecutionsClientCreateResponse contains the response from method JobExecutionsClient.BeginCreate.
type JobExecutionsClientCreateResponse struct {
	// An execution of a job
	JobExecution
}

// JobExecutionsClientGetResponse contains the response from method JobExecutionsClient.Get.
type JobExecutionsClientGetResponse struct {
	// An execution of a job
	JobExecution
}

// JobExecutionsClientListByAgentResponse contains the response from method JobExecutionsClient.NewListByAgentPager.
type JobExecutionsClientListByAgentResponse struct {
	// A list of job executions.
	JobExecutionListResult
}

// JobExecutionsClientListByJobResponse contains the response from method JobExecutionsClient.NewListByJobPager.
type JobExecutionsClientListByJobResponse struct {
	// A list of job executions.
	JobExecutionListResult
}

// JobPrivateEndpointsClientCreateOrUpdateResponse contains the response from method JobPrivateEndpointsClient.BeginCreateOrUpdate.
type JobPrivateEndpointsClientCreateOrUpdateResponse struct {
	// A job agent private endpoint.
	JobPrivateEndpoint
}

// JobPrivateEndpointsClientDeleteResponse contains the response from method JobPrivateEndpointsClient.BeginDelete.
type JobPrivateEndpointsClientDeleteResponse struct {
	// placeholder for future response values
}

// JobPrivateEndpointsClientGetResponse contains the response from method JobPrivateEndpointsClient.Get.
type JobPrivateEndpointsClientGetResponse struct {
	// A job agent private endpoint.
	JobPrivateEndpoint
}

// JobPrivateEndpointsClientListByAgentResponse contains the response from method JobPrivateEndpointsClient.NewListByAgentPager.
type JobPrivateEndpointsClientListByAgentResponse struct {
	// A list of job agent private endpoints.
	JobPrivateEndpointListResult
}

// JobStepExecutionsClientGetResponse contains the response from method JobStepExecutionsClient.Get.
type JobStepExecutionsClientGetResponse struct {
	// An execution of a job
	JobExecution
}

// JobStepExecutionsClientListByJobExecutionResponse contains the response from method JobStepExecutionsClient.NewListByJobExecutionPager.
type JobStepExecutionsClientListByJobExecutionResponse struct {
	// A list of job executions.
	JobExecutionListResult
}

// JobStepsClientCreateOrUpdateResponse contains the response from method JobStepsClient.CreateOrUpdate.
type JobStepsClientCreateOrUpdateResponse struct {
	// A job step.
	JobStep
}

// JobStepsClientDeleteResponse contains the response from method JobStepsClient.Delete.
type JobStepsClientDeleteResponse struct {
	// placeholder for future response values
}

// JobStepsClientGetByVersionResponse contains the response from method JobStepsClient.GetByVersion.
type JobStepsClientGetByVersionResponse struct {
	// A job step.
	JobStep
}

// JobStepsClientGetResponse contains the response from method JobStepsClient.Get.
type JobStepsClientGetResponse struct {
	// A job step.
	JobStep
}

// JobStepsClientListByJobResponse contains the response from method JobStepsClient.NewListByJobPager.
type JobStepsClientListByJobResponse struct {
	// A list of job steps.
	JobStepListResult
}

// JobStepsClientListByVersionResponse contains the response from method JobStepsClient.NewListByVersionPager.
type JobStepsClientListByVersionResponse struct {
	// A list of job steps.
	JobStepListResult
}

// JobTargetExecutionsClientGetResponse contains the response from method JobTargetExecutionsClient.Get.
type JobTargetExecutionsClientGetResponse struct {
	// An execution of a job
	JobExecution
}

// JobTargetExecutionsClientListByJobExecutionResponse contains the response from method JobTargetExecutionsClient.NewListByJobExecutionPager.
type JobTargetExecutionsClientListByJobExecutionResponse struct {
	// A list of job executions.
	JobExecutionListResult
}

// JobTargetExecutionsClientListByStepResponse contains the response from method JobTargetExecutionsClient.NewListByStepPager.
type JobTargetExecutionsClientListByStepResponse struct {
	// A list of job executions.
	JobExecutionListResult
}

// JobTargetGroupsClientCreateOrUpdateResponse contains the response from method JobTargetGroupsClient.CreateOrUpdate.
type JobTargetGroupsClientCreateOrUpdateResponse struct {
	// A group of job targets.
	JobTargetGroup
}

// JobTargetGroupsClientDeleteResponse contains the response from method JobTargetGroupsClient.Delete.
type JobTargetGroupsClientDeleteResponse struct {
	// placeholder for future response values
}

// JobTargetGroupsClientGetResponse contains the response from method JobTargetGroupsClient.Get.
type JobTargetGroupsClientGetResponse struct {
	// A group of job targets.
	JobTargetGroup
}

// JobTargetGroupsClientListByAgentResponse contains the response from method JobTargetGroupsClient.NewListByAgentPager.
type JobTargetGroupsClientListByAgentResponse struct {
	// A list of target groups.
	JobTargetGroupListResult
}

// JobVersionsClientGetResponse contains the response from method JobVersionsClient.Get.
type JobVersionsClientGetResponse struct {
	// A job version.
	JobVersion
}

// JobVersionsClientListByJobResponse contains the response from method JobVersionsClient.NewListByJobPager.
type JobVersionsClientListByJobResponse struct {
	// A list of job versions.
	JobVersionListResult
}

// JobsClientCreateOrUpdateResponse contains the response from method JobsClient.CreateOrUpdate.
type JobsClientCreateOrUpdateResponse struct {
	// A job.
	Job
}

// JobsClientDeleteResponse contains the response from method JobsClient.Delete.
type JobsClientDeleteResponse struct {
	// placeholder for future response values
}

// JobsClientGetResponse contains the response from method JobsClient.Get.
type JobsClientGetResponse struct {
	// A job.
	Job
}

// JobsClientListByAgentResponse contains the response from method JobsClient.NewListByAgentPager.
type JobsClientListByAgentResponse struct {
	// A list of jobs.
	JobListResult
}

// LedgerDigestUploadsClientCreateOrUpdateResponse contains the response from method LedgerDigestUploadsClient.BeginCreateOrUpdate.
type LedgerDigestUploadsClientCreateOrUpdateResponse struct {
	// Azure SQL Database ledger digest upload settings.
	LedgerDigestUploads
}

// LedgerDigestUploadsClientDisableResponse contains the response from method LedgerDigestUploadsClient.BeginDisable.
type LedgerDigestUploadsClientDisableResponse struct {
	// Azure SQL Database ledger digest upload settings.
	LedgerDigestUploads
}

// LedgerDigestUploadsClientGetResponse contains the response from method LedgerDigestUploadsClient.Get.
type LedgerDigestUploadsClientGetResponse struct {
	// Azure SQL Database ledger digest upload settings.
	LedgerDigestUploads
}

// LedgerDigestUploadsClientListByDatabaseResponse contains the response from method LedgerDigestUploadsClient.NewListByDatabasePager.
type LedgerDigestUploadsClientListByDatabaseResponse struct {
	// A list of ledger digest upload settings.
	LedgerDigestUploadsListResult
}

// LongTermRetentionBackupsClientChangeAccessTierByResourceGroupResponse contains the response from method LongTermRetentionBackupsClient.BeginChangeAccessTierByResourceGroup.
type LongTermRetentionBackupsClientChangeAccessTierByResourceGroupResponse struct {
	// A long term retention backup.
	LongTermRetentionBackup
}

// LongTermRetentionBackupsClientChangeAccessTierResponse contains the response from method LongTermRetentionBackupsClient.BeginChangeAccessTier.
type LongTermRetentionBackupsClientChangeAccessTierResponse struct {
	// A long term retention backup.
	LongTermRetentionBackup
}

// LongTermRetentionBackupsClientCopyByResourceGroupResponse contains the response from method LongTermRetentionBackupsClient.BeginCopyByResourceGroup.
type LongTermRetentionBackupsClientCopyByResourceGroupResponse struct {
	// A LongTermRetentionBackup operation result resource.
	LongTermRetentionBackupOperationResult
}

// LongTermRetentionBackupsClientCopyResponse contains the response from method LongTermRetentionBackupsClient.BeginCopy.
type LongTermRetentionBackupsClientCopyResponse struct {
	// A LongTermRetentionBackup operation result resource.
	LongTermRetentionBackupOperationResult
}

// LongTermRetentionBackupsClientDeleteByResourceGroupResponse contains the response from method LongTermRetentionBackupsClient.BeginDeleteByResourceGroup.
type LongTermRetentionBackupsClientDeleteByResourceGroupResponse struct {
	// placeholder for future response values
}

// LongTermRetentionBackupsClientDeleteResponse contains the response from method LongTermRetentionBackupsClient.BeginDelete.
type LongTermRetentionBackupsClientDeleteResponse struct {
	// placeholder for future response values
}

// LongTermRetentionBackupsClientGetByResourceGroupResponse contains the response from method LongTermRetentionBackupsClient.GetByResourceGroup.
type LongTermRetentionBackupsClientGetByResourceGroupResponse struct {
	// A long term retention backup.
	LongTermRetentionBackup
}

// LongTermRetentionBackupsClientGetResponse contains the response from method LongTermRetentionBackupsClient.Get.
type LongTermRetentionBackupsClientGetResponse struct {
	// A long term retention backup.
	LongTermRetentionBackup
}

// LongTermRetentionBackupsClientListByDatabaseResponse contains the response from method LongTermRetentionBackupsClient.NewListByDatabasePager.
type LongTermRetentionBackupsClientListByDatabaseResponse struct {
	// A list of long term retention backups.
	LongTermRetentionBackupListResult
}

// LongTermRetentionBackupsClientListByLocationResponse contains the response from method LongTermRetentionBackupsClient.NewListByLocationPager.
type LongTermRetentionBackupsClientListByLocationResponse struct {
	// A list of long term retention backups.
	LongTermRetentionBackupListResult
}

// LongTermRetentionBackupsClientListByResourceGroupDatabaseResponse contains the response from method LongTermRetentionBackupsClient.NewListByResourceGroupDatabasePager.
type LongTermRetentionBackupsClientListByResourceGroupDatabaseResponse struct {
	// A list of long term retention backups.
	LongTermRetentionBackupListResult
}

// LongTermRetentionBackupsClientListByResourceGroupLocationResponse contains the response from method LongTermRetentionBackupsClient.NewListByResourceGroupLocationPager.
type LongTermRetentionBackupsClientListByResourceGroupLocationResponse struct {
	// A list of long term retention backups.
	LongTermRetentionBackupListResult
}

// LongTermRetentionBackupsClientListByResourceGroupServerResponse contains the response from method LongTermRetentionBackupsClient.NewListByResourceGroupServerPager.
type LongTermRetentionBackupsClientListByResourceGroupServerResponse struct {
	// A list of long term retention backups.
	LongTermRetentionBackupListResult
}

// LongTermRetentionBackupsClientListByServerResponse contains the response from method LongTermRetentionBackupsClient.NewListByServerPager.
type LongTermRetentionBackupsClientListByServerResponse struct {
	// A list of long term retention backups.
	LongTermRetentionBackupListResult
}

// LongTermRetentionBackupsClientUpdateByResourceGroupResponse contains the response from method LongTermRetentionBackupsClient.BeginUpdateByResourceGroup.
type LongTermRetentionBackupsClientUpdateByResourceGroupResponse struct {
	// A LongTermRetentionBackup operation result resource.
	LongTermRetentionBackupOperationResult
}

// LongTermRetentionBackupsClientUpdateResponse contains the response from method LongTermRetentionBackupsClient.BeginUpdate.
type LongTermRetentionBackupsClientUpdateResponse struct {
	// A LongTermRetentionBackup operation result resource.
	LongTermRetentionBackupOperationResult
}

// LongTermRetentionManagedInstanceBackupsClientDeleteByResourceGroupResponse contains the response from method LongTermRetentionManagedInstanceBackupsClient.BeginDeleteByResourceGroup.
type LongTermRetentionManagedInstanceBackupsClientDeleteByResourceGroupResponse struct {
	// placeholder for future response values
}

// LongTermRetentionManagedInstanceBackupsClientDeleteResponse contains the response from method LongTermRetentionManagedInstanceBackupsClient.BeginDelete.
type LongTermRetentionManagedInstanceBackupsClientDeleteResponse struct {
	// placeholder for future response values
}

// LongTermRetentionManagedInstanceBackupsClientGetByResourceGroupResponse contains the response from method LongTermRetentionManagedInstanceBackupsClient.GetByResourceGroup.
type LongTermRetentionManagedInstanceBackupsClientGetByResourceGroupResponse struct {
	// A long term retention backup for a managed database.
	ManagedInstanceLongTermRetentionBackup
}

// LongTermRetentionManagedInstanceBackupsClientGetResponse contains the response from method LongTermRetentionManagedInstanceBackupsClient.Get.
type LongTermRetentionManagedInstanceBackupsClientGetResponse struct {
	// A long term retention backup for a managed database.
	ManagedInstanceLongTermRetentionBackup
}

// LongTermRetentionManagedInstanceBackupsClientListByDatabaseResponse contains the response from method LongTermRetentionManagedInstanceBackupsClient.NewListByDatabasePager.
type LongTermRetentionManagedInstanceBackupsClientListByDatabaseResponse struct {
	// A list of long term retention backups for managed database(s).
	ManagedInstanceLongTermRetentionBackupListResult
}

// LongTermRetentionManagedInstanceBackupsClientListByInstanceResponse contains the response from method LongTermRetentionManagedInstanceBackupsClient.NewListByInstancePager.
type LongTermRetentionManagedInstanceBackupsClientListByInstanceResponse struct {
	// A list of long term retention backups for managed database(s).
	ManagedInstanceLongTermRetentionBackupListResult
}

// LongTermRetentionManagedInstanceBackupsClientListByLocationResponse contains the response from method LongTermRetentionManagedInstanceBackupsClient.NewListByLocationPager.
type LongTermRetentionManagedInstanceBackupsClientListByLocationResponse struct {
	// A list of long term retention backups for managed database(s).
	ManagedInstanceLongTermRetentionBackupListResult
}

// LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseResponse contains the response from method LongTermRetentionManagedInstanceBackupsClient.NewListByResourceGroupDatabasePager.
type LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseResponse struct {
	// A list of long term retention backups for managed database(s).
	ManagedInstanceLongTermRetentionBackupListResult
}

// LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceResponse contains the response from method LongTermRetentionManagedInstanceBackupsClient.NewListByResourceGroupInstancePager.
type LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceResponse struct {
	// A list of long term retention backups for managed database(s).
	ManagedInstanceLongTermRetentionBackupListResult
}

// LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationResponse contains the response from method LongTermRetentionManagedInstanceBackupsClient.NewListByResourceGroupLocationPager.
type LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationResponse struct {
	// A list of long term retention backups for managed database(s).
	ManagedInstanceLongTermRetentionBackupListResult
}

// LongTermRetentionPoliciesClientCreateOrUpdateResponse contains the response from method LongTermRetentionPoliciesClient.BeginCreateOrUpdate.
type LongTermRetentionPoliciesClientCreateOrUpdateResponse struct {
	// A long term retention policy.
	LongTermRetentionPolicy
}

// LongTermRetentionPoliciesClientGetResponse contains the response from method LongTermRetentionPoliciesClient.Get.
type LongTermRetentionPoliciesClientGetResponse struct {
	// A long term retention policy.
	LongTermRetentionPolicy
}

// LongTermRetentionPoliciesClientListByDatabaseResponse contains the response from method LongTermRetentionPoliciesClient.NewListByDatabasePager.
type LongTermRetentionPoliciesClientListByDatabaseResponse struct {
	// A list of long term retention policies.
	LongTermRetentionPolicyListResult
}

// MaintenanceWindowOptionsClientGetResponse contains the response from method MaintenanceWindowOptionsClient.Get.
type MaintenanceWindowOptionsClientGetResponse struct {
	// Maintenance window options.
	MaintenanceWindowOptions
}

// MaintenanceWindowsClientCreateOrUpdateResponse contains the response from method MaintenanceWindowsClient.CreateOrUpdate.
type MaintenanceWindowsClientCreateOrUpdateResponse struct {
	// placeholder for future response values
}

// MaintenanceWindowsClientGetResponse contains the response from method MaintenanceWindowsClient.Get.
type MaintenanceWindowsClientGetResponse struct {
	// Maintenance windows.
	MaintenanceWindows
}

// ManagedBackupShortTermRetentionPoliciesClientCreateOrUpdateResponse contains the response from method ManagedBackupShortTermRetentionPoliciesClient.BeginCreateOrUpdate.
type ManagedBackupShortTermRetentionPoliciesClientCreateOrUpdateResponse struct {
	// A short term retention policy.
	ManagedBackupShortTermRetentionPolicy
}

// ManagedBackupShortTermRetentionPoliciesClientGetResponse contains the response from method ManagedBackupShortTermRetentionPoliciesClient.Get.
type ManagedBackupShortTermRetentionPoliciesClientGetResponse struct {
	// A short term retention policy.
	ManagedBackupShortTermRetentionPolicy
}

// ManagedBackupShortTermRetentionPoliciesClientListByDatabaseResponse contains the response from method ManagedBackupShortTermRetentionPoliciesClient.NewListByDatabasePager.
type ManagedBackupShortTermRetentionPoliciesClientListByDatabaseResponse struct {
	// A list of short term retention policies.
	ManagedBackupShortTermRetentionPolicyListResult
}

// ManagedBackupShortTermRetentionPoliciesClientUpdateResponse contains the response from method ManagedBackupShortTermRetentionPoliciesClient.BeginUpdate.
type ManagedBackupShortTermRetentionPoliciesClientUpdateResponse struct {
	// A short term retention policy.
	ManagedBackupShortTermRetentionPolicy
}

// ManagedDatabaseAdvancedThreatProtectionSettingsClientCreateOrUpdateResponse contains the response from method ManagedDatabaseAdvancedThreatProtectionSettingsClient.CreateOrUpdate.
type ManagedDatabaseAdvancedThreatProtectionSettingsClientCreateOrUpdateResponse struct {
	// A managed database Advanced Threat Protection.
	ManagedDatabaseAdvancedThreatProtection
}

// ManagedDatabaseAdvancedThreatProtectionSettingsClientGetResponse contains the response from method ManagedDatabaseAdvancedThreatProtectionSettingsClient.Get.
type ManagedDatabaseAdvancedThreatProtectionSettingsClientGetResponse struct {
	// A managed database Advanced Threat Protection.
	ManagedDatabaseAdvancedThreatProtection
}

// ManagedDatabaseAdvancedThreatProtectionSettingsClientListByDatabaseResponse contains the response from method ManagedDatabaseAdvancedThreatProtectionSettingsClient.NewListByDatabasePager.
type ManagedDatabaseAdvancedThreatProtectionSettingsClientListByDatabaseResponse struct {
	// A list of the managed database's Advanced Threat Protection settings.
	ManagedDatabaseAdvancedThreatProtectionListResult
}

// ManagedDatabaseColumnsClientGetResponse contains the response from method ManagedDatabaseColumnsClient.Get.
type ManagedDatabaseColumnsClientGetResponse struct {
	// A database column resource.
	DatabaseColumn
}

// ManagedDatabaseColumnsClientListByDatabaseResponse contains the response from method ManagedDatabaseColumnsClient.NewListByDatabasePager.
type ManagedDatabaseColumnsClientListByDatabaseResponse struct {
	// A list of database columns.
	DatabaseColumnListResult
}

// ManagedDatabaseColumnsClientListByTableResponse contains the response from method ManagedDatabaseColumnsClient.NewListByTablePager.
type ManagedDatabaseColumnsClientListByTableResponse struct {
	// A list of database columns.
	DatabaseColumnListResult
}

// ManagedDatabaseMoveOperationsClientGetResponse contains the response from method ManagedDatabaseMoveOperationsClient.Get.
type ManagedDatabaseMoveOperationsClientGetResponse struct {
	// A managed database move operation.
	ManagedDatabaseMoveOperationResult
}

// ManagedDatabaseMoveOperationsClientListByLocationResponse contains the response from method ManagedDatabaseMoveOperationsClient.NewListByLocationPager.
type ManagedDatabaseMoveOperationsClientListByLocationResponse struct {
	// List of managed database move operations.
	ManagedDatabaseMoveOperationListResult
}

// ManagedDatabaseQueriesClientGetResponse contains the response from method ManagedDatabaseQueriesClient.Get.
type ManagedDatabaseQueriesClientGetResponse struct {
	// Database query.
	ManagedInstanceQuery
}

// ManagedDatabaseQueriesClientListByQueryResponse contains the response from method ManagedDatabaseQueriesClient.NewListByQueryPager.
type ManagedDatabaseQueriesClientListByQueryResponse struct {
	// Execution statistics for one particular query
	ManagedInstanceQueryStatistics
}

// ManagedDatabaseRecommendedSensitivityLabelsClientUpdateResponse contains the response from method ManagedDatabaseRecommendedSensitivityLabelsClient.Update.
type ManagedDatabaseRecommendedSensitivityLabelsClientUpdateResponse struct {
	// placeholder for future response values
}

// ManagedDatabaseRestoreDetailsClientGetResponse contains the response from method ManagedDatabaseRestoreDetailsClient.Get.
type ManagedDatabaseRestoreDetailsClientGetResponse struct {
	// A managed database restore details.
	ManagedDatabaseRestoreDetailsResult
}

// ManagedDatabaseSchemasClientGetResponse contains the response from method ManagedDatabaseSchemasClient.Get.
type ManagedDatabaseSchemasClientGetResponse struct {
	// A database schema resource.
	DatabaseSchema
}

// ManagedDatabaseSchemasClientListByDatabaseResponse contains the response from method ManagedDatabaseSchemasClient.NewListByDatabasePager.
type ManagedDatabaseSchemasClientListByDatabaseResponse struct {
	// A list of database schemas.
	DatabaseSchemaListResult
}

// ManagedDatabaseSecurityAlertPoliciesClientCreateOrUpdateResponse contains the response from method ManagedDatabaseSecurityAlertPoliciesClient.CreateOrUpdate.
type ManagedDatabaseSecurityAlertPoliciesClientCreateOrUpdateResponse struct {
	// A managed database security alert policy.
	ManagedDatabaseSecurityAlertPolicy
}

// ManagedDatabaseSecurityAlertPoliciesClientGetResponse contains the response from method ManagedDatabaseSecurityAlertPoliciesClient.Get.
type ManagedDatabaseSecurityAlertPoliciesClientGetResponse struct {
	// A managed database security alert policy.
	ManagedDatabaseSecurityAlertPolicy
}

// ManagedDatabaseSecurityAlertPoliciesClientListByDatabaseResponse contains the response from method ManagedDatabaseSecurityAlertPoliciesClient.NewListByDatabasePager.
type ManagedDatabaseSecurityAlertPoliciesClientListByDatabaseResponse struct {
	// A list of the managed database's security alert policies.
	ManagedDatabaseSecurityAlertPolicyListResult
}

// ManagedDatabaseSecurityEventsClientListByDatabaseResponse contains the response from method ManagedDatabaseSecurityEventsClient.NewListByDatabasePager.
type ManagedDatabaseSecurityEventsClientListByDatabaseResponse struct {
	// A list of security events.
	SecurityEventCollection
}

// ManagedDatabaseSensitivityLabelsClientCreateOrUpdateResponse contains the response from method ManagedDatabaseSensitivityLabelsClient.CreateOrUpdate.
type ManagedDatabaseSensitivityLabelsClientCreateOrUpdateResponse struct {
	// A sensitivity label.
	SensitivityLabel
}

// ManagedDatabaseSensitivityLabelsClientDeleteResponse contains the response from method ManagedDatabaseSensitivityLabelsClient.Delete.
type ManagedDatabaseSensitivityLabelsClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedDatabaseSensitivityLabelsClientDisableRecommendationResponse contains the response from method ManagedDatabaseSensitivityLabelsClient.DisableRecommendation.
type ManagedDatabaseSensitivityLabelsClientDisableRecommendationResponse struct {
	// placeholder for future response values
}

// ManagedDatabaseSensitivityLabelsClientEnableRecommendationResponse contains the response from method ManagedDatabaseSensitivityLabelsClient.EnableRecommendation.
type ManagedDatabaseSensitivityLabelsClientEnableRecommendationResponse struct {
	// placeholder for future response values
}

// ManagedDatabaseSensitivityLabelsClientGetResponse contains the response from method ManagedDatabaseSensitivityLabelsClient.Get.
type ManagedDatabaseSensitivityLabelsClientGetResponse struct {
	// A sensitivity label.
	SensitivityLabel
}

// ManagedDatabaseSensitivityLabelsClientListCurrentByDatabaseResponse contains the response from method ManagedDatabaseSensitivityLabelsClient.NewListCurrentByDatabasePager.
type ManagedDatabaseSensitivityLabelsClientListCurrentByDatabaseResponse struct {
	// A list of sensitivity labels.
	SensitivityLabelListResult
}

// ManagedDatabaseSensitivityLabelsClientListRecommendedByDatabaseResponse contains the response from method ManagedDatabaseSensitivityLabelsClient.NewListRecommendedByDatabasePager.
type ManagedDatabaseSensitivityLabelsClientListRecommendedByDatabaseResponse struct {
	// A list of sensitivity labels.
	SensitivityLabelListResult
}

// ManagedDatabaseSensitivityLabelsClientUpdateResponse contains the response from method ManagedDatabaseSensitivityLabelsClient.Update.
type ManagedDatabaseSensitivityLabelsClientUpdateResponse struct {
	// placeholder for future response values
}

// ManagedDatabaseTablesClientGetResponse contains the response from method ManagedDatabaseTablesClient.Get.
type ManagedDatabaseTablesClientGetResponse struct {
	// A database table resource.
	DatabaseTable
}

// ManagedDatabaseTablesClientListBySchemaResponse contains the response from method ManagedDatabaseTablesClient.NewListBySchemaPager.
type ManagedDatabaseTablesClientListBySchemaResponse struct {
	// A list of database tables.
	DatabaseTableListResult
}

// ManagedDatabaseTransparentDataEncryptionClientCreateOrUpdateResponse contains the response from method ManagedDatabaseTransparentDataEncryptionClient.CreateOrUpdate.
type ManagedDatabaseTransparentDataEncryptionClientCreateOrUpdateResponse struct {
	// A managed database transparent data encryption state.
	ManagedTransparentDataEncryption
}

// ManagedDatabaseTransparentDataEncryptionClientGetResponse contains the response from method ManagedDatabaseTransparentDataEncryptionClient.Get.
type ManagedDatabaseTransparentDataEncryptionClientGetResponse struct {
	// A managed database transparent data encryption state.
	ManagedTransparentDataEncryption
}

// ManagedDatabaseTransparentDataEncryptionClientListByDatabaseResponse contains the response from method ManagedDatabaseTransparentDataEncryptionClient.NewListByDatabasePager.
type ManagedDatabaseTransparentDataEncryptionClientListByDatabaseResponse struct {
	// A list of managed transparent data encryptions
	ManagedTransparentDataEncryptionListResult
}

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse struct {
	// A database vulnerability assessment rule baseline.
	DatabaseVulnerabilityAssessmentRuleBaseline
}

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.Delete.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.Get.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetResponse struct {
	// A database vulnerability assessment rule baseline.
	DatabaseVulnerabilityAssessmentRuleBaseline
}

// ManagedDatabaseVulnerabilityAssessmentScansClientExportResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentScansClient.Export.
type ManagedDatabaseVulnerabilityAssessmentScansClientExportResponse struct {
	// A database Vulnerability Assessment scan export resource.
	DatabaseVulnerabilityAssessmentScansExport
}

// ManagedDatabaseVulnerabilityAssessmentScansClientGetResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentScansClient.Get.
type ManagedDatabaseVulnerabilityAssessmentScansClientGetResponse struct {
	// A vulnerability assessment scan record.
	VulnerabilityAssessmentScanRecord
}

// ManagedDatabaseVulnerabilityAssessmentScansClientInitiateScanResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentScansClient.BeginInitiateScan.
type ManagedDatabaseVulnerabilityAssessmentScansClientInitiateScanResponse struct {
	// placeholder for future response values
}

// ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentScansClient.NewListByDatabasePager.
type ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse struct {
	// A list of vulnerability assessment scan records.
	VulnerabilityAssessmentScanRecordListResult
}

// ManagedDatabaseVulnerabilityAssessmentsClientCreateOrUpdateResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentsClient.CreateOrUpdate.
type ManagedDatabaseVulnerabilityAssessmentsClientCreateOrUpdateResponse struct {
	// A database vulnerability assessment.
	DatabaseVulnerabilityAssessment
}

// ManagedDatabaseVulnerabilityAssessmentsClientDeleteResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentsClient.Delete.
type ManagedDatabaseVulnerabilityAssessmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedDatabaseVulnerabilityAssessmentsClientGetResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentsClient.Get.
type ManagedDatabaseVulnerabilityAssessmentsClientGetResponse struct {
	// A database vulnerability assessment.
	DatabaseVulnerabilityAssessment
}

// ManagedDatabaseVulnerabilityAssessmentsClientListByDatabaseResponse contains the response from method ManagedDatabaseVulnerabilityAssessmentsClient.NewListByDatabasePager.
type ManagedDatabaseVulnerabilityAssessmentsClientListByDatabaseResponse struct {
	// A list of the database's vulnerability assessments.
	DatabaseVulnerabilityAssessmentListResult
}

// ManagedDatabasesClientCancelMoveResponse contains the response from method ManagedDatabasesClient.BeginCancelMove.
type ManagedDatabasesClientCancelMoveResponse struct {
	// placeholder for future response values
}

// ManagedDatabasesClientCompleteMoveResponse contains the response from method ManagedDatabasesClient.BeginCompleteMove.
type ManagedDatabasesClientCompleteMoveResponse struct {
	// placeholder for future response values
}

// ManagedDatabasesClientCompleteRestoreResponse contains the response from method ManagedDatabasesClient.BeginCompleteRestore.
type ManagedDatabasesClientCompleteRestoreResponse struct {
	// placeholder for future response values
}

// ManagedDatabasesClientCreateOrUpdateResponse contains the response from method ManagedDatabasesClient.BeginCreateOrUpdate.
type ManagedDatabasesClientCreateOrUpdateResponse struct {
	// A managed database resource.
	ManagedDatabase
}

// ManagedDatabasesClientDeleteResponse contains the response from method ManagedDatabasesClient.BeginDelete.
type ManagedDatabasesClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedDatabasesClientGetResponse contains the response from method ManagedDatabasesClient.Get.
type ManagedDatabasesClientGetResponse struct {
	// A managed database resource.
	ManagedDatabase
}

// ManagedDatabasesClientListByInstanceResponse contains the response from method ManagedDatabasesClient.NewListByInstancePager.
type ManagedDatabasesClientListByInstanceResponse struct {
	// A list of managed databases.
	ManagedDatabaseListResult
}

// ManagedDatabasesClientListInaccessibleByInstanceResponse contains the response from method ManagedDatabasesClient.NewListInaccessibleByInstancePager.
type ManagedDatabasesClientListInaccessibleByInstanceResponse struct {
	// A list of managed databases.
	ManagedDatabaseListResult
}

// ManagedDatabasesClientStartMoveResponse contains the response from method ManagedDatabasesClient.BeginStartMove.
type ManagedDatabasesClientStartMoveResponse struct {
	// placeholder for future response values
}

// ManagedDatabasesClientUpdateResponse contains the response from method ManagedDatabasesClient.BeginUpdate.
type ManagedDatabasesClientUpdateResponse struct {
	// A managed database resource.
	ManagedDatabase
}

// ManagedInstanceAdministratorsClientCreateOrUpdateResponse contains the response from method ManagedInstanceAdministratorsClient.BeginCreateOrUpdate.
type ManagedInstanceAdministratorsClientCreateOrUpdateResponse struct {
	// An Azure SQL managed instance administrator.
	ManagedInstanceAdministrator
}

// ManagedInstanceAdministratorsClientDeleteResponse contains the response from method ManagedInstanceAdministratorsClient.BeginDelete.
type ManagedInstanceAdministratorsClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedInstanceAdministratorsClientGetResponse contains the response from method ManagedInstanceAdministratorsClient.Get.
type ManagedInstanceAdministratorsClientGetResponse struct {
	// An Azure SQL managed instance administrator.
	ManagedInstanceAdministrator
}

// ManagedInstanceAdministratorsClientListByInstanceResponse contains the response from method ManagedInstanceAdministratorsClient.NewListByInstancePager.
type ManagedInstanceAdministratorsClientListByInstanceResponse struct {
	// A list of managed instance administrators.
	ManagedInstanceAdministratorListResult
}

// ManagedInstanceAdvancedThreatProtectionSettingsClientCreateOrUpdateResponse contains the response from method ManagedInstanceAdvancedThreatProtectionSettingsClient.BeginCreateOrUpdate.
type ManagedInstanceAdvancedThreatProtectionSettingsClientCreateOrUpdateResponse struct {
	// A managed instance Advanced Threat Protection.
	ManagedInstanceAdvancedThreatProtection
}

// ManagedInstanceAdvancedThreatProtectionSettingsClientGetResponse contains the response from method ManagedInstanceAdvancedThreatProtectionSettingsClient.Get.
type ManagedInstanceAdvancedThreatProtectionSettingsClientGetResponse struct {
	// A managed instance Advanced Threat Protection.
	ManagedInstanceAdvancedThreatProtection
}

// ManagedInstanceAdvancedThreatProtectionSettingsClientListByInstanceResponse contains the response from method ManagedInstanceAdvancedThreatProtectionSettingsClient.NewListByInstancePager.
type ManagedInstanceAdvancedThreatProtectionSettingsClientListByInstanceResponse struct {
	// A list of the managed instance's Advanced Threat Protection settings.
	ManagedInstanceAdvancedThreatProtectionListResult
}

// ManagedInstanceAzureADOnlyAuthenticationsClientCreateOrUpdateResponse contains the response from method ManagedInstanceAzureADOnlyAuthenticationsClient.BeginCreateOrUpdate.
type ManagedInstanceAzureADOnlyAuthenticationsClientCreateOrUpdateResponse struct {
	// Azure Active Directory only authentication.
	ManagedInstanceAzureADOnlyAuthentication
}

// ManagedInstanceAzureADOnlyAuthenticationsClientDeleteResponse contains the response from method ManagedInstanceAzureADOnlyAuthenticationsClient.BeginDelete.
type ManagedInstanceAzureADOnlyAuthenticationsClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedInstanceAzureADOnlyAuthenticationsClientGetResponse contains the response from method ManagedInstanceAzureADOnlyAuthenticationsClient.Get.
type ManagedInstanceAzureADOnlyAuthenticationsClientGetResponse struct {
	// Azure Active Directory only authentication.
	ManagedInstanceAzureADOnlyAuthentication
}

// ManagedInstanceAzureADOnlyAuthenticationsClientListByInstanceResponse contains the response from method ManagedInstanceAzureADOnlyAuthenticationsClient.NewListByInstancePager.
type ManagedInstanceAzureADOnlyAuthenticationsClientListByInstanceResponse struct {
	// A list of active directory only authentications.
	ManagedInstanceAzureADOnlyAuthListResult
}

// ManagedInstanceDtcsClientCreateOrUpdateResponse contains the response from method ManagedInstanceDtcsClient.BeginCreateOrUpdate.
type ManagedInstanceDtcsClientCreateOrUpdateResponse struct {
	// SQL Managed Instance DTC
	ManagedInstanceDtc
}

// ManagedInstanceDtcsClientGetResponse contains the response from method ManagedInstanceDtcsClient.Get.
type ManagedInstanceDtcsClientGetResponse struct {
	// SQL Managed Instance DTC
	ManagedInstanceDtc
}

// ManagedInstanceDtcsClientListByManagedInstanceResponse contains the response from method ManagedInstanceDtcsClient.NewListByManagedInstancePager.
type ManagedInstanceDtcsClientListByManagedInstanceResponse struct {
	// A list of managed instance's DTCs.
	ManagedInstanceDtcListResult
}

// ManagedInstanceEncryptionProtectorsClientCreateOrUpdateResponse contains the response from method ManagedInstanceEncryptionProtectorsClient.BeginCreateOrUpdate.
type ManagedInstanceEncryptionProtectorsClientCreateOrUpdateResponse struct {
	// The managed instance encryption protector.
	ManagedInstanceEncryptionProtector
}

// ManagedInstanceEncryptionProtectorsClientGetResponse contains the response from method ManagedInstanceEncryptionProtectorsClient.Get.
type ManagedInstanceEncryptionProtectorsClientGetResponse struct {
	// The managed instance encryption protector.
	ManagedInstanceEncryptionProtector
}

// ManagedInstanceEncryptionProtectorsClientListByInstanceResponse contains the response from method ManagedInstanceEncryptionProtectorsClient.NewListByInstancePager.
type ManagedInstanceEncryptionProtectorsClientListByInstanceResponse struct {
	// A list of managed instance encryption protectors.
	ManagedInstanceEncryptionProtectorListResult
}

// ManagedInstanceEncryptionProtectorsClientRevalidateResponse contains the response from method ManagedInstanceEncryptionProtectorsClient.BeginRevalidate.
type ManagedInstanceEncryptionProtectorsClientRevalidateResponse struct {
	// placeholder for future response values
}

// ManagedInstanceKeysClientCreateOrUpdateResponse contains the response from method ManagedInstanceKeysClient.BeginCreateOrUpdate.
type ManagedInstanceKeysClientCreateOrUpdateResponse struct {
	// A managed instance key.
	ManagedInstanceKey
}

// ManagedInstanceKeysClientDeleteResponse contains the response from method ManagedInstanceKeysClient.BeginDelete.
type ManagedInstanceKeysClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedInstanceKeysClientGetResponse contains the response from method ManagedInstanceKeysClient.Get.
type ManagedInstanceKeysClientGetResponse struct {
	// A managed instance key.
	ManagedInstanceKey
}

// ManagedInstanceKeysClientListByInstanceResponse contains the response from method ManagedInstanceKeysClient.NewListByInstancePager.
type ManagedInstanceKeysClientListByInstanceResponse struct {
	// A list of managed instance keys.
	ManagedInstanceKeyListResult
}

// ManagedInstanceLongTermRetentionPoliciesClientCreateOrUpdateResponse contains the response from method ManagedInstanceLongTermRetentionPoliciesClient.BeginCreateOrUpdate.
type ManagedInstanceLongTermRetentionPoliciesClientCreateOrUpdateResponse struct {
	// A long term retention policy.
	ManagedInstanceLongTermRetentionPolicy
}

// ManagedInstanceLongTermRetentionPoliciesClientGetResponse contains the response from method ManagedInstanceLongTermRetentionPoliciesClient.Get.
type ManagedInstanceLongTermRetentionPoliciesClientGetResponse struct {
	// A long term retention policy.
	ManagedInstanceLongTermRetentionPolicy
}

// ManagedInstanceLongTermRetentionPoliciesClientListByDatabaseResponse contains the response from method ManagedInstanceLongTermRetentionPoliciesClient.NewListByDatabasePager.
type ManagedInstanceLongTermRetentionPoliciesClientListByDatabaseResponse struct {
	// A list of long term retention policies.
	ManagedInstanceLongTermRetentionPolicyListResult
}

// ManagedInstanceOperationsClientCancelResponse contains the response from method ManagedInstanceOperationsClient.Cancel.
type ManagedInstanceOperationsClientCancelResponse struct {
	// placeholder for future response values
}

// ManagedInstanceOperationsClientGetResponse contains the response from method ManagedInstanceOperationsClient.Get.
type ManagedInstanceOperationsClientGetResponse struct {
	// A managed instance operation.
	ManagedInstanceOperation
}

// ManagedInstanceOperationsClientListByManagedInstanceResponse contains the response from method ManagedInstanceOperationsClient.NewListByManagedInstancePager.
type ManagedInstanceOperationsClientListByManagedInstanceResponse struct {
	// The response to a list managed instance operations request
	ManagedInstanceOperationListResult
}

// ManagedInstancePrivateEndpointConnectionsClientCreateOrUpdateResponse contains the response from method ManagedInstancePrivateEndpointConnectionsClient.BeginCreateOrUpdate.
type ManagedInstancePrivateEndpointConnectionsClientCreateOrUpdateResponse struct {
	// A private endpoint connection
	ManagedInstancePrivateEndpointConnection
}

// ManagedInstancePrivateEndpointConnectionsClientDeleteResponse contains the response from method ManagedInstancePrivateEndpointConnectionsClient.BeginDelete.
type ManagedInstancePrivateEndpointConnectionsClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedInstancePrivateEndpointConnectionsClientGetResponse contains the response from method ManagedInstancePrivateEndpointConnectionsClient.Get.
type ManagedInstancePrivateEndpointConnectionsClientGetResponse struct {
	// A private endpoint connection
	ManagedInstancePrivateEndpointConnection
}

// ManagedInstancePrivateEndpointConnectionsClientListByManagedInstanceResponse contains the response from method ManagedInstancePrivateEndpointConnectionsClient.NewListByManagedInstancePager.
type ManagedInstancePrivateEndpointConnectionsClientListByManagedInstanceResponse struct {
	// A list of private endpoint connections.
	ManagedInstancePrivateEndpointConnectionListResult
}

// ManagedInstancePrivateLinkResourcesClientGetResponse contains the response from method ManagedInstancePrivateLinkResourcesClient.Get.
type ManagedInstancePrivateLinkResourcesClientGetResponse struct {
	// A private link resource
	ManagedInstancePrivateLink
}

// ManagedInstancePrivateLinkResourcesClientListByManagedInstanceResponse contains the response from method ManagedInstancePrivateLinkResourcesClient.NewListByManagedInstancePager.
type ManagedInstancePrivateLinkResourcesClientListByManagedInstanceResponse struct {
	// A list of private link resources
	ManagedInstancePrivateLinkListResult
}

// ManagedInstanceTdeCertificatesClientCreateResponse contains the response from method ManagedInstanceTdeCertificatesClient.BeginCreate.
type ManagedInstanceTdeCertificatesClientCreateResponse struct {
	// placeholder for future response values
}

// ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateResponse contains the response from method ManagedInstanceVulnerabilityAssessmentsClient.CreateOrUpdate.
type ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateResponse struct {
	// A managed instance vulnerability assessment.
	ManagedInstanceVulnerabilityAssessment
}

// ManagedInstanceVulnerabilityAssessmentsClientDeleteResponse contains the response from method ManagedInstanceVulnerabilityAssessmentsClient.Delete.
type ManagedInstanceVulnerabilityAssessmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedInstanceVulnerabilityAssessmentsClientGetResponse contains the response from method ManagedInstanceVulnerabilityAssessmentsClient.Get.
type ManagedInstanceVulnerabilityAssessmentsClientGetResponse struct {
	// A managed instance vulnerability assessment.
	ManagedInstanceVulnerabilityAssessment
}

// ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse contains the response from method ManagedInstanceVulnerabilityAssessmentsClient.NewListByInstancePager.
type ManagedInstanceVulnerabilityAssessmentsClientListByInstanceResponse struct {
	// A list of the ManagedInstance's vulnerability assessments.
	ManagedInstanceVulnerabilityAssessmentListResult
}

// ManagedInstancesClientCreateOrUpdateResponse contains the response from method ManagedInstancesClient.BeginCreateOrUpdate.
type ManagedInstancesClientCreateOrUpdateResponse struct {
	// An Azure SQL managed instance.
	ManagedInstance
}

// ManagedInstancesClientDeleteResponse contains the response from method ManagedInstancesClient.BeginDelete.
type ManagedInstancesClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedInstancesClientFailoverResponse contains the response from method ManagedInstancesClient.BeginFailover.
type ManagedInstancesClientFailoverResponse struct {
	// placeholder for future response values
}

// ManagedInstancesClientGetResponse contains the response from method ManagedInstancesClient.Get.
type ManagedInstancesClientGetResponse struct {
	// An Azure SQL managed instance.
	ManagedInstance
}

// ManagedInstancesClientListByInstancePoolResponse contains the response from method ManagedInstancesClient.NewListByInstancePoolPager.
type ManagedInstancesClientListByInstancePoolResponse struct {
	// A list of managed instances.
	ManagedInstanceListResult
}

// ManagedInstancesClientListByManagedInstanceResponse contains the response from method ManagedInstancesClient.NewListByManagedInstancePager.
type ManagedInstancesClientListByManagedInstanceResponse struct {
	// A list of top resource consuming queries on managed instance
	TopQueriesListResult
}

// ManagedInstancesClientListByResourceGroupResponse contains the response from method ManagedInstancesClient.NewListByResourceGroupPager.
type ManagedInstancesClientListByResourceGroupResponse struct {
	// A list of managed instances.
	ManagedInstanceListResult
}

// ManagedInstancesClientListOutboundNetworkDependenciesByManagedInstanceResponse contains the response from method ManagedInstancesClient.NewListOutboundNetworkDependenciesByManagedInstancePager.
type ManagedInstancesClientListOutboundNetworkDependenciesByManagedInstanceResponse struct {
	// A collection of endpoints that the managed instance service requires outbound network access to.
	OutboundEnvironmentEndpointCollection
}

// ManagedInstancesClientListResponse contains the response from method ManagedInstancesClient.NewListPager.
type ManagedInstancesClientListResponse struct {
	// A list of managed instances.
	ManagedInstanceListResult
}

// ManagedInstancesClientStartResponse contains the response from method ManagedInstancesClient.BeginStart.
type ManagedInstancesClientStartResponse struct {
	// placeholder for future response values
}

// ManagedInstancesClientStopResponse contains the response from method ManagedInstancesClient.BeginStop.
type ManagedInstancesClientStopResponse struct {
	// placeholder for future response values
}

// ManagedInstancesClientUpdateResponse contains the response from method ManagedInstancesClient.BeginUpdate.
type ManagedInstancesClientUpdateResponse struct {
	// An Azure SQL managed instance.
	ManagedInstance
}

// ManagedLedgerDigestUploadsClientCreateOrUpdateResponse contains the response from method ManagedLedgerDigestUploadsClient.BeginCreateOrUpdate.
type ManagedLedgerDigestUploadsClientCreateOrUpdateResponse struct {
	// Azure SQL Database ledger digest upload settings.
	ManagedLedgerDigestUploads
}

// ManagedLedgerDigestUploadsClientDisableResponse contains the response from method ManagedLedgerDigestUploadsClient.BeginDisable.
type ManagedLedgerDigestUploadsClientDisableResponse struct {
	// Azure SQL Database ledger digest upload settings.
	ManagedLedgerDigestUploads
}

// ManagedLedgerDigestUploadsClientGetResponse contains the response from method ManagedLedgerDigestUploadsClient.Get.
type ManagedLedgerDigestUploadsClientGetResponse struct {
	// Azure SQL Database ledger digest upload settings.
	ManagedLedgerDigestUploads
}

// ManagedLedgerDigestUploadsClientListByDatabaseResponse contains the response from method ManagedLedgerDigestUploadsClient.NewListByDatabasePager.
type ManagedLedgerDigestUploadsClientListByDatabaseResponse struct {
	// A list of ledger digest upload settings.
	ManagedLedgerDigestUploadsListResult
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientCreateOrUpdateResponse contains the response from
// method ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.BeginCreateOrUpdate.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientCreateOrUpdateResponse struct {
	// A short term retention policy.
	ManagedBackupShortTermRetentionPolicy
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientGetResponse contains the response from method ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.Get.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientGetResponse struct {
	// A short term retention policy.
	ManagedBackupShortTermRetentionPolicy
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientListByRestorableDroppedDatabaseResponse contains
// the response from method ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.NewListByRestorableDroppedDatabasePager.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientListByRestorableDroppedDatabaseResponse struct {
	// A list of short term retention policies.
	ManagedBackupShortTermRetentionPolicyListResult
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientUpdateResponse contains the response from method
// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.BeginUpdate.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientUpdateResponse struct {
	// A short term retention policy.
	ManagedBackupShortTermRetentionPolicy
}

// ManagedServerDNSAliasesClientAcquireResponse contains the response from method ManagedServerDNSAliasesClient.BeginAcquire.
type ManagedServerDNSAliasesClientAcquireResponse struct {
	// A managed server DNS alias.
	ManagedServerDNSAlias
}

// ManagedServerDNSAliasesClientCreateOrUpdateResponse contains the response from method ManagedServerDNSAliasesClient.BeginCreateOrUpdate.
type ManagedServerDNSAliasesClientCreateOrUpdateResponse struct {
	// A managed server DNS alias.
	ManagedServerDNSAlias
}

// ManagedServerDNSAliasesClientDeleteResponse contains the response from method ManagedServerDNSAliasesClient.BeginDelete.
type ManagedServerDNSAliasesClientDeleteResponse struct {
	// placeholder for future response values
}

// ManagedServerDNSAliasesClientGetResponse contains the response from method ManagedServerDNSAliasesClient.Get.
type ManagedServerDNSAliasesClientGetResponse struct {
	// A managed server DNS alias.
	ManagedServerDNSAlias
}

// ManagedServerDNSAliasesClientListByManagedInstanceResponse contains the response from method ManagedServerDNSAliasesClient.NewListByManagedInstancePager.
type ManagedServerDNSAliasesClientListByManagedInstanceResponse struct {
	// A list of managed server DNS aliases.
	ManagedServerDNSAliasListResult
}

// ManagedServerSecurityAlertPoliciesClientCreateOrUpdateResponse contains the response from method ManagedServerSecurityAlertPoliciesClient.BeginCreateOrUpdate.
type ManagedServerSecurityAlertPoliciesClientCreateOrUpdateResponse struct {
	// A managed server security alert policy.
	ManagedServerSecurityAlertPolicy
}

// ManagedServerSecurityAlertPoliciesClientGetResponse contains the response from method ManagedServerSecurityAlertPoliciesClient.Get.
type ManagedServerSecurityAlertPoliciesClientGetResponse struct {
	// A managed server security alert policy.
	ManagedServerSecurityAlertPolicy
}

// ManagedServerSecurityAlertPoliciesClientListByInstanceResponse contains the response from method ManagedServerSecurityAlertPoliciesClient.NewListByInstancePager.
type ManagedServerSecurityAlertPoliciesClientListByInstanceResponse struct {
	// A list of the managed Server's security alert policies.
	ManagedServerSecurityAlertPolicyListResult
}

// OperationsClientListResponse contains the response from method OperationsClient.NewListPager.
type OperationsClientListResponse struct {
	// Result of the request to list SQL operations.
	OperationListResult
}

// OutboundFirewallRulesClientCreateOrUpdateResponse contains the response from method OutboundFirewallRulesClient.BeginCreateOrUpdate.
type OutboundFirewallRulesClientCreateOrUpdateResponse struct {
	// An Azure SQL DB Server Outbound Firewall Rule.
	OutboundFirewallRule
}

// OutboundFirewallRulesClientDeleteResponse contains the response from method OutboundFirewallRulesClient.BeginDelete.
type OutboundFirewallRulesClientDeleteResponse struct {
	// placeholder for future response values
}

// OutboundFirewallRulesClientGetResponse contains the response from method OutboundFirewallRulesClient.Get.
type OutboundFirewallRulesClientGetResponse struct {
	// An Azure SQL DB Server Outbound Firewall Rule.
	OutboundFirewallRule
}

// OutboundFirewallRulesClientListByServerResponse contains the response from method OutboundFirewallRulesClient.NewListByServerPager.
type OutboundFirewallRulesClientListByServerResponse struct {
	// A list of outbound rules.
	OutboundFirewallRuleListResult
}

// PrivateEndpointConnectionsClientCreateOrUpdateResponse contains the response from method PrivateEndpointConnectionsClient.BeginCreateOrUpdate.
type PrivateEndpointConnectionsClientCreateOrUpdateResponse struct {
	// A private endpoint connection
	PrivateEndpointConnection
}

// PrivateEndpointConnectionsClientDeleteResponse contains the response from method PrivateEndpointConnectionsClient.BeginDelete.
type PrivateEndpointConnectionsClientDeleteResponse struct {
	// placeholder for future response values
}

// PrivateEndpointConnectionsClientGetResponse contains the response from method PrivateEndpointConnectionsClient.Get.
type PrivateEndpointConnectionsClientGetResponse struct {
	// A private endpoint connection
	PrivateEndpointConnection
}

// PrivateEndpointConnectionsClientListByServerResponse contains the response from method PrivateEndpointConnectionsClient.NewListByServerPager.
type PrivateEndpointConnectionsClientListByServerResponse struct {
	// A list of private endpoint connections.
	PrivateEndpointConnectionListResult
}

// PrivateLinkResourcesClientGetResponse contains the response from method PrivateLinkResourcesClient.Get.
type PrivateLinkResourcesClientGetResponse struct {
	// A private link resource
	PrivateLinkResource
}

// PrivateLinkResourcesClientListByServerResponse contains the response from method PrivateLinkResourcesClient.NewListByServerPager.
type PrivateLinkResourcesClientListByServerResponse struct {
	// A list of private link resources
	PrivateLinkResourceListResult
}

// RecommendedSensitivityLabelsClientUpdateResponse contains the response from method RecommendedSensitivityLabelsClient.Update.
type RecommendedSensitivityLabelsClientUpdateResponse struct {
	// placeholder for future response values
}

// RecoverableDatabasesClientGetResponse contains the response from method RecoverableDatabasesClient.Get.
type RecoverableDatabasesClientGetResponse struct {
	// A recoverable database resource.
	RecoverableDatabase
}

// RecoverableDatabasesClientListByServerResponse contains the response from method RecoverableDatabasesClient.NewListByServerPager.
type RecoverableDatabasesClientListByServerResponse struct {
	// A list of recoverable databases.
	RecoverableDatabaseListResult
}

// RecoverableManagedDatabasesClientGetResponse contains the response from method RecoverableManagedDatabasesClient.Get.
type RecoverableManagedDatabasesClientGetResponse struct {
	// A recoverable managed database resource.
	RecoverableManagedDatabase
}

// RecoverableManagedDatabasesClientListByInstanceResponse contains the response from method RecoverableManagedDatabasesClient.NewListByInstancePager.
type RecoverableManagedDatabasesClientListByInstanceResponse struct {
	// A list of recoverable managed databases.
	RecoverableManagedDatabaseListResult
}

// ReplicationLinksClientDeleteResponse contains the response from method ReplicationLinksClient.BeginDelete.
type ReplicationLinksClientDeleteResponse struct {
	// placeholder for future response values
}

// ReplicationLinksClientFailoverAllowDataLossResponse contains the response from method ReplicationLinksClient.BeginFailoverAllowDataLoss.
type ReplicationLinksClientFailoverAllowDataLossResponse struct {
	// A replication link.
	ReplicationLink
}

// ReplicationLinksClientFailoverResponse contains the response from method ReplicationLinksClient.BeginFailover.
type ReplicationLinksClientFailoverResponse struct {
	// A replication link.
	ReplicationLink
}

// ReplicationLinksClientGetResponse contains the response from method ReplicationLinksClient.Get.
type ReplicationLinksClientGetResponse struct {
	// A replication link.
	ReplicationLink
}

// ReplicationLinksClientListByDatabaseResponse contains the response from method ReplicationLinksClient.NewListByDatabasePager.
type ReplicationLinksClientListByDatabaseResponse struct {
	// A list of replication links.
	ReplicationLinkListResult
}

// ReplicationLinksClientListByServerResponse contains the response from method ReplicationLinksClient.NewListByServerPager.
type ReplicationLinksClientListByServerResponse struct {
	// A list of replication links.
	ReplicationLinkListResult
}

// RestorableDroppedDatabasesClientGetResponse contains the response from method RestorableDroppedDatabasesClient.Get.
type RestorableDroppedDatabasesClientGetResponse struct {
	// A restorable dropped database resource.
	RestorableDroppedDatabase
}

// RestorableDroppedDatabasesClientListByServerResponse contains the response from method RestorableDroppedDatabasesClient.NewListByServerPager.
type RestorableDroppedDatabasesClientListByServerResponse struct {
	// A list of restorable dropped databases.
	RestorableDroppedDatabaseListResult
}

// RestorableDroppedManagedDatabasesClientGetResponse contains the response from method RestorableDroppedManagedDatabasesClient.Get.
type RestorableDroppedManagedDatabasesClientGetResponse struct {
	// A restorable dropped managed database resource.
	RestorableDroppedManagedDatabase
}

// RestorableDroppedManagedDatabasesClientListByInstanceResponse contains the response from method RestorableDroppedManagedDatabasesClient.NewListByInstancePager.
type RestorableDroppedManagedDatabasesClientListByInstanceResponse struct {
	// A list of restorable dropped managed databases.
	RestorableDroppedManagedDatabaseListResult
}

// RestorePointsClientCreateResponse contains the response from method RestorePointsClient.BeginCreate.
type RestorePointsClientCreateResponse struct {
	// Database restore points.
	RestorePoint
}

// RestorePointsClientDeleteResponse contains the response from method RestorePointsClient.Delete.
type RestorePointsClientDeleteResponse struct {
	// placeholder for future response values
}

// RestorePointsClientGetResponse contains the response from method RestorePointsClient.Get.
type RestorePointsClientGetResponse struct {
	// Database restore points.
	RestorePoint
}

// RestorePointsClientListByDatabaseResponse contains the response from method RestorePointsClient.NewListByDatabasePager.
type RestorePointsClientListByDatabaseResponse struct {
	// A list of long term retention backups.
	RestorePointListResult
}

// SensitivityLabelsClientCreateOrUpdateResponse contains the response from method SensitivityLabelsClient.CreateOrUpdate.
type SensitivityLabelsClientCreateOrUpdateResponse struct {
	// A sensitivity label.
	SensitivityLabel
}

// SensitivityLabelsClientDeleteResponse contains the response from method SensitivityLabelsClient.Delete.
type SensitivityLabelsClientDeleteResponse struct {
	// placeholder for future response values
}

// SensitivityLabelsClientDisableRecommendationResponse contains the response from method SensitivityLabelsClient.DisableRecommendation.
type SensitivityLabelsClientDisableRecommendationResponse struct {
	// placeholder for future response values
}

// SensitivityLabelsClientEnableRecommendationResponse contains the response from method SensitivityLabelsClient.EnableRecommendation.
type SensitivityLabelsClientEnableRecommendationResponse struct {
	// placeholder for future response values
}

// SensitivityLabelsClientGetResponse contains the response from method SensitivityLabelsClient.Get.
type SensitivityLabelsClientGetResponse struct {
	// A sensitivity label.
	SensitivityLabel
}

// SensitivityLabelsClientListCurrentByDatabaseResponse contains the response from method SensitivityLabelsClient.NewListCurrentByDatabasePager.
type SensitivityLabelsClientListCurrentByDatabaseResponse struct {
	// A list of sensitivity labels.
	SensitivityLabelListResult
}

// SensitivityLabelsClientListRecommendedByDatabaseResponse contains the response from method SensitivityLabelsClient.NewListRecommendedByDatabasePager.
type SensitivityLabelsClientListRecommendedByDatabaseResponse struct {
	// A list of sensitivity labels.
	SensitivityLabelListResult
}

// SensitivityLabelsClientUpdateResponse contains the response from method SensitivityLabelsClient.Update.
type SensitivityLabelsClientUpdateResponse struct {
	// placeholder for future response values
}

// ServerAdvancedThreatProtectionSettingsClientCreateOrUpdateResponse contains the response from method ServerAdvancedThreatProtectionSettingsClient.BeginCreateOrUpdate.
type ServerAdvancedThreatProtectionSettingsClientCreateOrUpdateResponse struct {
	// A server Advanced Threat Protection.
	ServerAdvancedThreatProtection
}

// ServerAdvancedThreatProtectionSettingsClientGetResponse contains the response from method ServerAdvancedThreatProtectionSettingsClient.Get.
type ServerAdvancedThreatProtectionSettingsClientGetResponse struct {
	// A server Advanced Threat Protection.
	ServerAdvancedThreatProtection
}

// ServerAdvancedThreatProtectionSettingsClientListByServerResponse contains the response from method ServerAdvancedThreatProtectionSettingsClient.NewListByServerPager.
type ServerAdvancedThreatProtectionSettingsClientListByServerResponse struct {
	// A list of the server's Advanced Threat Protection configurations.
	LogicalServerAdvancedThreatProtectionListResult
}

// ServerAdvisorsClientGetResponse contains the response from method ServerAdvisorsClient.Get.
type ServerAdvisorsClientGetResponse struct {
	// Database, Server or Elastic Pool Advisor.
	Advisor
}

// ServerAdvisorsClientListByServerResponse contains the response from method ServerAdvisorsClient.ListByServer.
type ServerAdvisorsClientListByServerResponse struct {
	// Array of Advisor
	AdvisorArray []*Advisor
}

// ServerAdvisorsClientUpdateResponse contains the response from method ServerAdvisorsClient.Update.
type ServerAdvisorsClientUpdateResponse struct {
	// Database, Server or Elastic Pool Advisor.
	Advisor
}

// ServerAutomaticTuningClientGetResponse contains the response from method ServerAutomaticTuningClient.Get.
type ServerAutomaticTuningClientGetResponse struct {
	// Server-level Automatic Tuning.
	ServerAutomaticTuning
}

// ServerAutomaticTuningClientUpdateResponse contains the response from method ServerAutomaticTuningClient.Update.
type ServerAutomaticTuningClientUpdateResponse struct {
	// Server-level Automatic Tuning.
	ServerAutomaticTuning
}

// ServerAzureADAdministratorsClientCreateOrUpdateResponse contains the response from method ServerAzureADAdministratorsClient.BeginCreateOrUpdate.
type ServerAzureADAdministratorsClientCreateOrUpdateResponse struct {
	// Azure Active Directory administrator.
	ServerAzureADAdministrator
}

// ServerAzureADAdministratorsClientDeleteResponse contains the response from method ServerAzureADAdministratorsClient.BeginDelete.
type ServerAzureADAdministratorsClientDeleteResponse struct {
	// placeholder for future response values
}

// ServerAzureADAdministratorsClientGetResponse contains the response from method ServerAzureADAdministratorsClient.Get.
type ServerAzureADAdministratorsClientGetResponse struct {
	// Azure Active Directory administrator.
	ServerAzureADAdministrator
}

// ServerAzureADAdministratorsClientListByServerResponse contains the response from method ServerAzureADAdministratorsClient.NewListByServerPager.
type ServerAzureADAdministratorsClientListByServerResponse struct {
	// A list of active directory administrators.
	AdministratorListResult
}

// ServerAzureADOnlyAuthenticationsClientCreateOrUpdateResponse contains the response from method ServerAzureADOnlyAuthenticationsClient.BeginCreateOrUpdate.
type ServerAzureADOnlyAuthenticationsClientCreateOrUpdateResponse struct {
	// Azure Active Directory only authentication.
	ServerAzureADOnlyAuthentication
}

// ServerAzureADOnlyAuthenticationsClientDeleteResponse contains the response from method ServerAzureADOnlyAuthenticationsClient.BeginDelete.
type ServerAzureADOnlyAuthenticationsClientDeleteResponse struct {
	// placeholder for future response values
}

// ServerAzureADOnlyAuthenticationsClientGetResponse contains the response from method ServerAzureADOnlyAuthenticationsClient.Get.
type ServerAzureADOnlyAuthenticationsClientGetResponse struct {
	// Azure Active Directory only authentication.
	ServerAzureADOnlyAuthentication
}

// ServerAzureADOnlyAuthenticationsClientListByServerResponse contains the response from method ServerAzureADOnlyAuthenticationsClient.NewListByServerPager.
type ServerAzureADOnlyAuthenticationsClientListByServerResponse struct {
	// A list of active directory only authentications.
	AzureADOnlyAuthListResult
}

// ServerBlobAuditingPoliciesClientCreateOrUpdateResponse contains the response from method ServerBlobAuditingPoliciesClient.BeginCreateOrUpdate.
type ServerBlobAuditingPoliciesClientCreateOrUpdateResponse struct {
	// A server blob auditing policy.
	ServerBlobAuditingPolicy
}

// ServerBlobAuditingPoliciesClientGetResponse contains the response from method ServerBlobAuditingPoliciesClient.Get.
type ServerBlobAuditingPoliciesClientGetResponse struct {
	// A server blob auditing policy.
	ServerBlobAuditingPolicy
}

// ServerBlobAuditingPoliciesClientListByServerResponse contains the response from method ServerBlobAuditingPoliciesClient.NewListByServerPager.
type ServerBlobAuditingPoliciesClientListByServerResponse struct {
	// A list of server auditing settings.
	ServerBlobAuditingPolicyListResult
}

// ServerCommunicationLinksClientCreateOrUpdateResponse contains the response from method ServerCommunicationLinksClient.BeginCreateOrUpdate.
type ServerCommunicationLinksClientCreateOrUpdateResponse struct {
	// Server communication link.
	ServerCommunicationLink
}

// ServerCommunicationLinksClientDeleteResponse contains the response from method ServerCommunicationLinksClient.Delete.
type ServerCommunicationLinksClientDeleteResponse struct {
	// placeholder for future response values
}

// ServerCommunicationLinksClientGetResponse contains the response from method ServerCommunicationLinksClient.Get.
type ServerCommunicationLinksClientGetResponse struct {
	// Server communication link.
	ServerCommunicationLink
}

// ServerCommunicationLinksClientListByServerResponse contains the response from method ServerCommunicationLinksClient.NewListByServerPager.
type ServerCommunicationLinksClientListByServerResponse struct {
	// A list of server communication links.
	ServerCommunicationLinkListResult
}

// ServerConfigurationOptionsClientCreateOrUpdateResponse contains the response from method ServerConfigurationOptionsClient.BeginCreateOrUpdate.
type ServerConfigurationOptionsClientCreateOrUpdateResponse struct {
	// A server configuration option
	ServerConfigurationOption
}

// ServerConfigurationOptionsClientGetResponse contains the response from method ServerConfigurationOptionsClient.Get.
type ServerConfigurationOptionsClientGetResponse struct {
	// A server configuration option
	ServerConfigurationOption
}

// ServerConfigurationOptionsClientListByManagedInstanceResponse contains the response from method ServerConfigurationOptionsClient.NewListByManagedInstancePager.
type ServerConfigurationOptionsClientListByManagedInstanceResponse struct {
	// A list of server configuration options.
	ServerConfigurationOptionListResult
}

// ServerConnectionPoliciesClientCreateOrUpdateResponse contains the response from method ServerConnectionPoliciesClient.BeginCreateOrUpdate.
type ServerConnectionPoliciesClientCreateOrUpdateResponse struct {
	// A server connection policy
	ServerConnectionPolicy
}

// ServerConnectionPoliciesClientGetResponse contains the response from method ServerConnectionPoliciesClient.Get.
type ServerConnectionPoliciesClientGetResponse struct {
	// A server connection policy
	ServerConnectionPolicy
}

// ServerConnectionPoliciesClientListByServerResponse contains the response from method ServerConnectionPoliciesClient.NewListByServerPager.
type ServerConnectionPoliciesClientListByServerResponse struct {
	// A list of server connection policy objects.
	ServerConnectionPolicyListResult
}

// ServerDNSAliasesClientAcquireResponse contains the response from method ServerDNSAliasesClient.BeginAcquire.
type ServerDNSAliasesClientAcquireResponse struct {
	// A server DNS alias.
	ServerDNSAlias
}

// ServerDNSAliasesClientCreateOrUpdateResponse contains the response from method ServerDNSAliasesClient.BeginCreateOrUpdate.
type ServerDNSAliasesClientCreateOrUpdateResponse struct {
	// A server DNS alias.
	ServerDNSAlias
}

// ServerDNSAliasesClientDeleteResponse contains the response from method ServerDNSAliasesClient.BeginDelete.
type ServerDNSAliasesClientDeleteResponse struct {
	// placeholder for future response values
}

// ServerDNSAliasesClientGetResponse contains the response from method ServerDNSAliasesClient.Get.
type ServerDNSAliasesClientGetResponse struct {
	// A server DNS alias.
	ServerDNSAlias
}

// ServerDNSAliasesClientListByServerResponse contains the response from method ServerDNSAliasesClient.NewListByServerPager.
type ServerDNSAliasesClientListByServerResponse struct {
	// A list of server DNS aliases.
	ServerDNSAliasListResult
}

// ServerDevOpsAuditSettingsClientCreateOrUpdateResponse contains the response from method ServerDevOpsAuditSettingsClient.BeginCreateOrUpdate.
type ServerDevOpsAuditSettingsClientCreateOrUpdateResponse struct {
	// A server DevOps auditing settings.
	ServerDevOpsAuditingSettings
}

// ServerDevOpsAuditSettingsClientGetResponse contains the response from method ServerDevOpsAuditSettingsClient.Get.
type ServerDevOpsAuditSettingsClientGetResponse struct {
	// A server DevOps auditing settings.
	ServerDevOpsAuditingSettings
}

// ServerDevOpsAuditSettingsClientListByServerResponse contains the response from method ServerDevOpsAuditSettingsClient.NewListByServerPager.
type ServerDevOpsAuditSettingsClientListByServerResponse struct {
	// A list of server DevOps audit settings.
	ServerDevOpsAuditSettingsListResult
}

// ServerKeysClientCreateOrUpdateResponse contains the response from method ServerKeysClient.BeginCreateOrUpdate.
type ServerKeysClientCreateOrUpdateResponse struct {
	// A server key.
	ServerKey
}

// ServerKeysClientDeleteResponse contains the response from method ServerKeysClient.BeginDelete.
type ServerKeysClientDeleteResponse struct {
	// placeholder for future response values
}

// ServerKeysClientGetResponse contains the response from method ServerKeysClient.Get.
type ServerKeysClientGetResponse struct {
	// A server key.
	ServerKey
}

// ServerKeysClientListByServerResponse contains the response from method ServerKeysClient.NewListByServerPager.
type ServerKeysClientListByServerResponse struct {
	// A list of server keys.
	ServerKeyListResult
}

// ServerOperationsClientListByServerResponse contains the response from method ServerOperationsClient.NewListByServerPager.
type ServerOperationsClientListByServerResponse struct {
	// The response to a list server operations request
	ServerOperationListResult
}

// ServerSecurityAlertPoliciesClientCreateOrUpdateResponse contains the response from method ServerSecurityAlertPoliciesClient.BeginCreateOrUpdate.
type ServerSecurityAlertPoliciesClientCreateOrUpdateResponse struct {
	// A server security alert policy.
	ServerSecurityAlertPolicy
}

// ServerSecurityAlertPoliciesClientGetResponse contains the response from method ServerSecurityAlertPoliciesClient.Get.
type ServerSecurityAlertPoliciesClientGetResponse struct {
	// A server security alert policy.
	ServerSecurityAlertPolicy
}

// ServerSecurityAlertPoliciesClientListByServerResponse contains the response from method ServerSecurityAlertPoliciesClient.NewListByServerPager.
type ServerSecurityAlertPoliciesClientListByServerResponse struct {
	// A list of the server's security alert policies.
	LogicalServerSecurityAlertPolicyListResult
}

// ServerTrustCertificatesClientCreateOrUpdateResponse contains the response from method ServerTrustCertificatesClient.BeginCreateOrUpdate.
type ServerTrustCertificatesClientCreateOrUpdateResponse struct {
	// Server trust certificate imported from box to enable connection between box and Sql Managed Instance.
	ServerTrustCertificate
}

// ServerTrustCertificatesClientDeleteResponse contains the response from method ServerTrustCertificatesClient.BeginDelete.
type ServerTrustCertificatesClientDeleteResponse struct {
	// placeholder for future response values
}

// ServerTrustCertificatesClientGetResponse contains the response from method ServerTrustCertificatesClient.Get.
type ServerTrustCertificatesClientGetResponse struct {
	// Server trust certificate imported from box to enable connection between box and Sql Managed Instance.
	ServerTrustCertificate
}

// ServerTrustCertificatesClientListByInstanceResponse contains the response from method ServerTrustCertificatesClient.NewListByInstancePager.
type ServerTrustCertificatesClientListByInstanceResponse struct {
	// A list of server trust certificates in instance.
	ServerTrustCertificatesListResult
}

// ServerTrustGroupsClientCreateOrUpdateResponse contains the response from method ServerTrustGroupsClient.BeginCreateOrUpdate.
type ServerTrustGroupsClientCreateOrUpdateResponse struct {
	// A server trust group.
	ServerTrustGroup
}

// ServerTrustGroupsClientDeleteResponse contains the response from method ServerTrustGroupsClient.BeginDelete.
type ServerTrustGroupsClientDeleteResponse struct {
	// placeholder for future response values
}

// ServerTrustGroupsClientGetResponse contains the response from method ServerTrustGroupsClient.Get.
type ServerTrustGroupsClientGetResponse struct {
	// A server trust group.
	ServerTrustGroup
}

// ServerTrustGroupsClientListByInstanceResponse contains the response from method ServerTrustGroupsClient.NewListByInstancePager.
type ServerTrustGroupsClientListByInstanceResponse struct {
	// A list of server trust groups.
	ServerTrustGroupListResult
}

// ServerTrustGroupsClientListByLocationResponse contains the response from method ServerTrustGroupsClient.NewListByLocationPager.
type ServerTrustGroupsClientListByLocationResponse struct {
	// A list of server trust groups.
	ServerTrustGroupListResult
}

// ServerUsagesClientListByServerResponse contains the response from method ServerUsagesClient.NewListByServerPager.
type ServerUsagesClientListByServerResponse struct {
	// Represents the response to a list server metrics request.
	ServerUsageListResult
}

// ServerVulnerabilityAssessmentsClientCreateOrUpdateResponse contains the response from method ServerVulnerabilityAssessmentsClient.CreateOrUpdate.
type ServerVulnerabilityAssessmentsClientCreateOrUpdateResponse struct {
	// A server vulnerability assessment.
	ServerVulnerabilityAssessment
}

// ServerVulnerabilityAssessmentsClientDeleteResponse contains the response from method ServerVulnerabilityAssessmentsClient.Delete.
type ServerVulnerabilityAssessmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// ServerVulnerabilityAssessmentsClientGetResponse contains the response from method ServerVulnerabilityAssessmentsClient.Get.
type ServerVulnerabilityAssessmentsClientGetResponse struct {
	// A server vulnerability assessment.
	ServerVulnerabilityAssessment
}

// ServerVulnerabilityAssessmentsClientListByServerResponse contains the response from method ServerVulnerabilityAssessmentsClient.NewListByServerPager.
type ServerVulnerabilityAssessmentsClientListByServerResponse struct {
	// A list of the server's vulnerability assessments.
	ServerVulnerabilityAssessmentListResult
}

// ServersClientCheckNameAvailabilityResponse contains the response from method ServersClient.CheckNameAvailability.
type ServersClientCheckNameAvailabilityResponse struct {
	// The result of a name availability check.
	CheckNameAvailabilityResponse
}

// ServersClientCreateOrUpdateResponse contains the response from method ServersClient.BeginCreateOrUpdate.
type ServersClientCreateOrUpdateResponse struct {
	// An Azure SQL Database server.
	Server
}

// ServersClientDeleteResponse contains the response from method ServersClient.BeginDelete.
type ServersClientDeleteResponse struct {
	// placeholder for future response values
}

// ServersClientGetResponse contains the response from method ServersClient.Get.
type ServersClientGetResponse struct {
	// An Azure SQL Database server.
	Server
}

// ServersClientImportDatabaseResponse contains the response from method ServersClient.BeginImportDatabase.
type ServersClientImportDatabaseResponse struct {
	// An ImportExport operation result resource.
	ImportExportOperationResult
}

// ServersClientListByResourceGroupResponse contains the response from method ServersClient.NewListByResourceGroupPager.
type ServersClientListByResourceGroupResponse struct {
	// A list of servers.
	ServerListResult
}

// ServersClientListResponse contains the response from method ServersClient.NewListPager.
type ServersClientListResponse struct {
	// A list of servers.
	ServerListResult
}

// ServersClientRefreshStatusResponse contains the response from method ServersClient.BeginRefreshStatus.
type ServersClientRefreshStatusResponse struct {
	// An RefreshExternalGovernanceStatus operation result resource.
	RefreshExternalGovernanceStatusOperationResult
}

// ServersClientUpdateResponse contains the response from method ServersClient.BeginUpdate.
type ServersClientUpdateResponse struct {
	// An Azure SQL Database server.
	Server
}

// ServiceObjectivesClientGetResponse contains the response from method ServiceObjectivesClient.Get.
type ServiceObjectivesClientGetResponse struct {
	// Represents a database service objective.
	ServiceObjective
}

// ServiceObjectivesClientListByServerResponse contains the response from method ServiceObjectivesClient.NewListByServerPager.
type ServiceObjectivesClientListByServerResponse struct {
	// Represents the response to a get database service objectives request.
	ServiceObjectiveListResult
}

// StartStopManagedInstanceSchedulesClientCreateOrUpdateResponse contains the response from method StartStopManagedInstanceSchedulesClient.CreateOrUpdate.
type StartStopManagedInstanceSchedulesClientCreateOrUpdateResponse struct {
	// Managed instance's Start/Stop schedule.
	StartStopManagedInstanceSchedule
}

// StartStopManagedInstanceSchedulesClientDeleteResponse contains the response from method StartStopManagedInstanceSchedulesClient.Delete.
type StartStopManagedInstanceSchedulesClientDeleteResponse struct {
	// placeholder for future response values
}

// StartStopManagedInstanceSchedulesClientGetResponse contains the response from method StartStopManagedInstanceSchedulesClient.Get.
type StartStopManagedInstanceSchedulesClientGetResponse struct {
	// Managed instance's Start/Stop schedule.
	StartStopManagedInstanceSchedule
}

// StartStopManagedInstanceSchedulesClientListByInstanceResponse contains the response from method StartStopManagedInstanceSchedulesClient.NewListByInstancePager.
type StartStopManagedInstanceSchedulesClientListByInstanceResponse struct {
	// Managed instance's Start/Stop schedule list result.
	StartStopManagedInstanceScheduleListResult
}

// SubscriptionUsagesClientGetResponse contains the response from method SubscriptionUsagesClient.Get.
type SubscriptionUsagesClientGetResponse struct {
	// Usage Metric of a Subscription in a Location.
	SubscriptionUsage
}

// SubscriptionUsagesClientListByLocationResponse contains the response from method SubscriptionUsagesClient.NewListByLocationPager.
type SubscriptionUsagesClientListByLocationResponse struct {
	// A list of subscription usage metrics in a location.
	SubscriptionUsageListResult
}

// SynapseLinkWorkspacesClientListByDatabaseResponse contains the response from method SynapseLinkWorkspacesClient.NewListByDatabasePager.
type SynapseLinkWorkspacesClientListByDatabaseResponse struct {
	// A list of synapselink workspaces
	SynapseLinkWorkspaceListResult
}

// SyncAgentsClientCreateOrUpdateResponse contains the response from method SyncAgentsClient.BeginCreateOrUpdate.
type SyncAgentsClientCreateOrUpdateResponse struct {
	// An Azure SQL Database sync agent.
	SyncAgent
}

// SyncAgentsClientDeleteResponse contains the response from method SyncAgentsClient.BeginDelete.
type SyncAgentsClientDeleteResponse struct {
	// placeholder for future response values
}

// SyncAgentsClientGenerateKeyResponse contains the response from method SyncAgentsClient.GenerateKey.
type SyncAgentsClientGenerateKeyResponse struct {
	// Properties of an Azure SQL Database sync agent key.
	SyncAgentKeyProperties
}

// SyncAgentsClientGetResponse contains the response from method SyncAgentsClient.Get.
type SyncAgentsClientGetResponse struct {
	// An Azure SQL Database sync agent.
	SyncAgent
}

// SyncAgentsClientListByServerResponse contains the response from method SyncAgentsClient.NewListByServerPager.
type SyncAgentsClientListByServerResponse struct {
	// A list of sync agents.
	SyncAgentListResult
}

// SyncAgentsClientListLinkedDatabasesResponse contains the response from method SyncAgentsClient.NewListLinkedDatabasesPager.
type SyncAgentsClientListLinkedDatabasesResponse struct {
	// A list of sync agent linked databases.
	SyncAgentLinkedDatabaseListResult
}

// SyncGroupsClientCancelSyncResponse contains the response from method SyncGroupsClient.CancelSync.
type SyncGroupsClientCancelSyncResponse struct {
	// placeholder for future response values
}

// SyncGroupsClientCreateOrUpdateResponse contains the response from method SyncGroupsClient.BeginCreateOrUpdate.
type SyncGroupsClientCreateOrUpdateResponse struct {
	// An Azure SQL Database sync group.
	SyncGroup
}

// SyncGroupsClientDeleteResponse contains the response from method SyncGroupsClient.BeginDelete.
type SyncGroupsClientDeleteResponse struct {
	// placeholder for future response values
}

// SyncGroupsClientGetResponse contains the response from method SyncGroupsClient.Get.
type SyncGroupsClientGetResponse struct {
	// An Azure SQL Database sync group.
	SyncGroup
}

// SyncGroupsClientListByDatabaseResponse contains the response from method SyncGroupsClient.NewListByDatabasePager.
type SyncGroupsClientListByDatabaseResponse struct {
	// A list of sync groups.
	SyncGroupListResult
}

// SyncGroupsClientListHubSchemasResponse contains the response from method SyncGroupsClient.NewListHubSchemasPager.
type SyncGroupsClientListHubSchemasResponse struct {
	// A list of sync schema properties.
	SyncFullSchemaPropertiesListResult
}

// SyncGroupsClientListLogsResponse contains the response from method SyncGroupsClient.NewListLogsPager.
type SyncGroupsClientListLogsResponse struct {
	// A list of sync group log properties.
	SyncGroupLogListResult
}

// SyncGroupsClientListSyncDatabaseIDsResponse contains the response from method SyncGroupsClient.NewListSyncDatabaseIDsPager.
type SyncGroupsClientListSyncDatabaseIDsResponse struct {
	// A list of sync database ID properties.
	SyncDatabaseIDListResult
}

// SyncGroupsClientRefreshHubSchemaResponse contains the response from method SyncGroupsClient.BeginRefreshHubSchema.
type SyncGroupsClientRefreshHubSchemaResponse struct {
	// placeholder for future response values
}

// SyncGroupsClientTriggerSyncResponse contains the response from method SyncGroupsClient.TriggerSync.
type SyncGroupsClientTriggerSyncResponse struct {
	// placeholder for future response values
}

// SyncGroupsClientUpdateResponse contains the response from method SyncGroupsClient.BeginUpdate.
type SyncGroupsClientUpdateResponse struct {
	// An Azure SQL Database sync group.
	SyncGroup
}

// SyncMembersClientCreateOrUpdateResponse contains the response from method SyncMembersClient.BeginCreateOrUpdate.
type SyncMembersClientCreateOrUpdateResponse struct {
	// An Azure SQL Database sync member.
	SyncMember
}

// SyncMembersClientDeleteResponse contains the response from method SyncMembersClient.BeginDelete.
type SyncMembersClientDeleteResponse struct {
	// placeholder for future response values
}

// SyncMembersClientGetResponse contains the response from method SyncMembersClient.Get.
type SyncMembersClientGetResponse struct {
	// An Azure SQL Database sync member.
	SyncMember
}

// SyncMembersClientListBySyncGroupResponse contains the response from method SyncMembersClient.NewListBySyncGroupPager.
type SyncMembersClientListBySyncGroupResponse struct {
	// A list of Azure SQL Database sync members.
	SyncMemberListResult
}

// SyncMembersClientListMemberSchemasResponse contains the response from method SyncMembersClient.NewListMemberSchemasPager.
type SyncMembersClientListMemberSchemasResponse struct {
	// A list of sync schema properties.
	SyncFullSchemaPropertiesListResult
}

// SyncMembersClientRefreshMemberSchemaResponse contains the response from method SyncMembersClient.BeginRefreshMemberSchema.
type SyncMembersClientRefreshMemberSchemaResponse struct {
	// placeholder for future response values
}

// SyncMembersClientUpdateResponse contains the response from method SyncMembersClient.BeginUpdate.
type SyncMembersClientUpdateResponse struct {
	// An Azure SQL Database sync member.
	SyncMember
}

// TdeCertificatesClientCreateResponse contains the response from method TdeCertificatesClient.BeginCreate.
type TdeCertificatesClientCreateResponse struct {
	// placeholder for future response values
}

// TimeZonesClientGetResponse contains the response from method TimeZonesClient.Get.
type TimeZonesClientGetResponse struct {
	// Time Zone.
	TimeZone
}

// TimeZonesClientListByLocationResponse contains the response from method TimeZonesClient.NewListByLocationPager.
type TimeZonesClientListByLocationResponse struct {
	// A list of time zones.
	TimeZoneListResult
}

// TransparentDataEncryptionsClientCreateOrUpdateResponse contains the response from method TransparentDataEncryptionsClient.BeginCreateOrUpdate.
type TransparentDataEncryptionsClientCreateOrUpdateResponse struct {
	// A logical database transparent data encryption state.
	LogicalDatabaseTransparentDataEncryption
}

// TransparentDataEncryptionsClientGetResponse contains the response from method TransparentDataEncryptionsClient.Get.
type TransparentDataEncryptionsClientGetResponse struct {
	// A logical database transparent data encryption state.
	LogicalDatabaseTransparentDataEncryption
}

// TransparentDataEncryptionsClientListByDatabaseResponse contains the response from method TransparentDataEncryptionsClient.NewListByDatabasePager.
type TransparentDataEncryptionsClientListByDatabaseResponse struct {
	// A list of transparent data encryptions
	LogicalDatabaseTransparentDataEncryptionListResult
}

// UsagesClientListByInstancePoolResponse contains the response from method UsagesClient.NewListByInstancePoolPager.
type UsagesClientListByInstancePoolResponse struct {
	// A list of usages.
	UsageListResult
}

// VirtualClustersClientDeleteResponse contains the response from method VirtualClustersClient.BeginDelete.
type VirtualClustersClientDeleteResponse struct {
	// placeholder for future response values
}

// VirtualClustersClientGetResponse contains the response from method VirtualClustersClient.Get.
type VirtualClustersClientGetResponse struct {
	// An Azure SQL virtual cluster.
	VirtualCluster
}

// VirtualClustersClientListByResourceGroupResponse contains the response from method VirtualClustersClient.NewListByResourceGroupPager.
type VirtualClustersClientListByResourceGroupResponse struct {
	// A list of virtual clusters.
	VirtualClusterListResult
}

// VirtualClustersClientListResponse contains the response from method VirtualClustersClient.NewListPager.
type VirtualClustersClientListResponse struct {
	// A list of virtual clusters.
	VirtualClusterListResult
}

// VirtualClustersClientUpdateDNSServersResponse contains the response from method VirtualClustersClient.BeginUpdateDNSServers.
type VirtualClustersClientUpdateDNSServersResponse struct {
	// A refresh DNS servers operation.
	UpdateVirtualClusterDNSServersOperation
}

// VirtualClustersClientUpdateResponse contains the response from method VirtualClustersClient.BeginUpdate.
type VirtualClustersClientUpdateResponse struct {
	// An Azure SQL virtual cluster.
	VirtualCluster
}

// VirtualNetworkRulesClientCreateOrUpdateResponse contains the response from method VirtualNetworkRulesClient.BeginCreateOrUpdate.
type VirtualNetworkRulesClientCreateOrUpdateResponse struct {
	// A virtual network rule.
	VirtualNetworkRule
}

// VirtualNetworkRulesClientDeleteResponse contains the response from method VirtualNetworkRulesClient.BeginDelete.
type VirtualNetworkRulesClientDeleteResponse struct {
	// placeholder for future response values
}

// VirtualNetworkRulesClientGetResponse contains the response from method VirtualNetworkRulesClient.Get.
type VirtualNetworkRulesClientGetResponse struct {
	// A virtual network rule.
	VirtualNetworkRule
}

// VirtualNetworkRulesClientListByServerResponse contains the response from method VirtualNetworkRulesClient.NewListByServerPager.
type VirtualNetworkRulesClientListByServerResponse struct {
	// A list of virtual network rules.
	VirtualNetworkRuleListResult
}

// VulnerabilityAssessmentBaselineClientGetResponse contains the response from method VulnerabilityAssessmentBaselineClient.Get.
type VulnerabilityAssessmentBaselineClientGetResponse struct {
	// A database sql vulnerability assessment baseline set.
	DatabaseSQLVulnerabilityAssessmentBaselineSet
}

// VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse contains the response from method VulnerabilityAssessmentBaselineClient.NewListBySQLVulnerabilityAssessmentPager.
type VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse struct {
	// A list of SQL Vulnerability Assessments baseline set.
	DatabaseSQLVulnerabilityAssessmentBaselineSetListResult
}

// VulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse contains the response from method VulnerabilityAssessmentBaselinesClient.CreateOrUpdate.
type VulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse struct {
	// A database sql vulnerability assessment baseline set.
	DatabaseSQLVulnerabilityAssessmentBaselineSet
}

// VulnerabilityAssessmentExecuteScanClientExecuteResponse contains the response from method VulnerabilityAssessmentExecuteScanClient.BeginExecute.
type VulnerabilityAssessmentExecuteScanClientExecuteResponse struct {
	// placeholder for future response values
}

// VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateResponse contains the response from method VulnerabilityAssessmentRuleBaselineClient.CreateOrUpdate.
type VulnerabilityAssessmentRuleBaselineClientCreateOrUpdateResponse struct {
	// A database sql vulnerability assessment rule baseline.
	DatabaseSQLVulnerabilityAssessmentRuleBaseline
}

// VulnerabilityAssessmentRuleBaselineClientGetResponse contains the response from method VulnerabilityAssessmentRuleBaselineClient.Get.
type VulnerabilityAssessmentRuleBaselineClientGetResponse struct {
	// A database sql vulnerability assessment rule baseline.
	DatabaseSQLVulnerabilityAssessmentRuleBaseline
}

// VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse contains the response from method VulnerabilityAssessmentRuleBaselineClient.NewListByBaselinePager.
type VulnerabilityAssessmentRuleBaselineClientListByBaselineResponse struct {
	// A list of SQL Vulnerability Assessments rule baseline.
	DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult
}

// VulnerabilityAssessmentRuleBaselinesClientDeleteResponse contains the response from method VulnerabilityAssessmentRuleBaselinesClient.Delete.
type VulnerabilityAssessmentRuleBaselinesClientDeleteResponse struct {
	// placeholder for future response values
}

// VulnerabilityAssessmentScanResultClientGetResponse contains the response from method VulnerabilityAssessmentScanResultClient.Get.
type VulnerabilityAssessmentScanResultClientGetResponse struct {
	VulnerabilityAssessmentScanResults
}

// VulnerabilityAssessmentScanResultClientListByScanResponse contains the response from method VulnerabilityAssessmentScanResultClient.NewListByScanPager.
type VulnerabilityAssessmentScanResultClientListByScanResponse struct {
	// A list of vulnerability assessment scan results.
	VulnerabilityAssessmentScanListResult
}

// VulnerabilityAssessmentScansClientGetResponse contains the response from method VulnerabilityAssessmentScansClient.Get.
type VulnerabilityAssessmentScansClientGetResponse struct {
	// A vulnerability assessment scan record.
	VulnerabilityAssessmentScanRecordForSQL
}

// VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse contains the response from method VulnerabilityAssessmentScansClient.NewListBySQLVulnerabilityAssessmentsPager.
type VulnerabilityAssessmentScansClientListBySQLVulnerabilityAssessmentsResponse struct {
	// A list of vulnerability assessment scan records.
	VulnerabilityAssessmentScanRecordForSQLListResult
}

// VulnerabilityAssessmentsClientDeleteResponse contains the response from method VulnerabilityAssessmentsClient.Delete.
type VulnerabilityAssessmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// VulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse contains the response from method VulnerabilityAssessmentsSettingsClient.CreateOrUpdate.
type VulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse struct {
	// A SQL Vulnerability Assessment.
	VulnerabilityAssessment
}

// VulnerabilityAssessmentsSettingsClientGetResponse contains the response from method VulnerabilityAssessmentsSettingsClient.Get.
type VulnerabilityAssessmentsSettingsClientGetResponse struct {
	// A SQL Vulnerability Assessment.
	VulnerabilityAssessment
}

// VulnerabilityAssessmentsSettingsClientListByServerResponse contains the response from method VulnerabilityAssessmentsSettingsClient.NewListByServerPager.
type VulnerabilityAssessmentsSettingsClientListByServerResponse struct {
	// A list of SQL Vulnerability Assessments.
	VulnerabilityAssessmentListResult
}

// WorkloadClassifiersClientCreateOrUpdateResponse contains the response from method WorkloadClassifiersClient.BeginCreateOrUpdate.
type WorkloadClassifiersClientCreateOrUpdateResponse struct {
	// Workload classifier operations for a data warehouse
	WorkloadClassifier
}

// WorkloadClassifiersClientDeleteResponse contains the response from method WorkloadClassifiersClient.BeginDelete.
type WorkloadClassifiersClientDeleteResponse struct {
	// placeholder for future response values
}

// WorkloadClassifiersClientGetResponse contains the response from method WorkloadClassifiersClient.Get.
type WorkloadClassifiersClientGetResponse struct {
	// Workload classifier operations for a data warehouse
	WorkloadClassifier
}

// WorkloadClassifiersClientListByWorkloadGroupResponse contains the response from method WorkloadClassifiersClient.NewListByWorkloadGroupPager.
type WorkloadClassifiersClientListByWorkloadGroupResponse struct {
	// A list of workload classifiers for a workload group.
	WorkloadClassifierListResult
}

// WorkloadGroupsClientCreateOrUpdateResponse contains the response from method WorkloadGroupsClient.BeginCreateOrUpdate.
type WorkloadGroupsClientCreateOrUpdateResponse struct {
	// Workload group operations for a data warehouse
	WorkloadGroup
}

// WorkloadGroupsClientDeleteResponse contains the response from method WorkloadGroupsClient.BeginDelete.
type WorkloadGroupsClientDeleteResponse struct {
	// placeholder for future response values
}

// WorkloadGroupsClientGetResponse contains the response from method WorkloadGroupsClient.Get.
type WorkloadGroupsClientGetResponse struct {
	// Workload group operations for a data warehouse
	WorkloadGroup
}

// WorkloadGroupsClientListByDatabaseResponse contains the response from method WorkloadGroupsClient.NewListByDatabasePager.
type WorkloadGroupsClientListByDatabaseResponse struct {
	// A list of workload groups.
	WorkloadGroupListResult
}
