//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// LongTermRetentionBackupsServer is a fake server for instances of the armsql.LongTermRetentionBackupsClient type.
type LongTermRetentionBackupsServer struct {
	// BeginChangeAccessTier is the fake for method LongTermRetentionBackupsClient.BeginChangeAccessTier
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginChangeAccessTier func(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters armsql.ChangeLongTermRetentionBackupAccessTierParameters, options *armsql.LongTermRetentionBackupsClientBeginChangeAccessTierOptions) (resp azfake.PollerResponder[armsql.LongTermRetentionBackupsClientChangeAccessTierResponse], errResp azfake.ErrorResponder)

	// BeginChangeAccessTierByResourceGroup is the fake for method LongTermRetentionBackupsClient.BeginChangeAccessTierByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginChangeAccessTierByResourceGroup func(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters armsql.ChangeLongTermRetentionBackupAccessTierParameters, options *armsql.LongTermRetentionBackupsClientBeginChangeAccessTierByResourceGroupOptions) (resp azfake.PollerResponder[armsql.LongTermRetentionBackupsClientChangeAccessTierByResourceGroupResponse], errResp azfake.ErrorResponder)

	// BeginCopy is the fake for method LongTermRetentionBackupsClient.BeginCopy
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCopy func(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters armsql.CopyLongTermRetentionBackupParameters, options *armsql.LongTermRetentionBackupsClientBeginCopyOptions) (resp azfake.PollerResponder[armsql.LongTermRetentionBackupsClientCopyResponse], errResp azfake.ErrorResponder)

	// BeginCopyByResourceGroup is the fake for method LongTermRetentionBackupsClient.BeginCopyByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCopyByResourceGroup func(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters armsql.CopyLongTermRetentionBackupParameters, options *armsql.LongTermRetentionBackupsClientBeginCopyByResourceGroupOptions) (resp azfake.PollerResponder[armsql.LongTermRetentionBackupsClientCopyByResourceGroupResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method LongTermRetentionBackupsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDelete func(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, options *armsql.LongTermRetentionBackupsClientBeginDeleteOptions) (resp azfake.PollerResponder[armsql.LongTermRetentionBackupsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeleteByResourceGroup is the fake for method LongTermRetentionBackupsClient.BeginDeleteByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDeleteByResourceGroup func(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, options *armsql.LongTermRetentionBackupsClientBeginDeleteByResourceGroupOptions) (resp azfake.PollerResponder[armsql.LongTermRetentionBackupsClientDeleteByResourceGroupResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method LongTermRetentionBackupsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, options *armsql.LongTermRetentionBackupsClientGetOptions) (resp azfake.Responder[armsql.LongTermRetentionBackupsClientGetResponse], errResp azfake.ErrorResponder)

	// GetByResourceGroup is the fake for method LongTermRetentionBackupsClient.GetByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetByResourceGroup func(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, options *armsql.LongTermRetentionBackupsClientGetByResourceGroupOptions) (resp azfake.Responder[armsql.LongTermRetentionBackupsClientGetByResourceGroupResponse], errResp azfake.ErrorResponder)

	// NewListByDatabasePager is the fake for method LongTermRetentionBackupsClient.NewListByDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDatabasePager func(locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, options *armsql.LongTermRetentionBackupsClientListByDatabaseOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByDatabaseResponse])

	// NewListByLocationPager is the fake for method LongTermRetentionBackupsClient.NewListByLocationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByLocationPager func(locationName string, options *armsql.LongTermRetentionBackupsClientListByLocationOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByLocationResponse])

	// NewListByResourceGroupDatabasePager is the fake for method LongTermRetentionBackupsClient.NewListByResourceGroupDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupDatabasePager func(resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, options *armsql.LongTermRetentionBackupsClientListByResourceGroupDatabaseOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByResourceGroupDatabaseResponse])

	// NewListByResourceGroupLocationPager is the fake for method LongTermRetentionBackupsClient.NewListByResourceGroupLocationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupLocationPager func(resourceGroupName string, locationName string, options *armsql.LongTermRetentionBackupsClientListByResourceGroupLocationOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByResourceGroupLocationResponse])

	// NewListByResourceGroupServerPager is the fake for method LongTermRetentionBackupsClient.NewListByResourceGroupServerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupServerPager func(resourceGroupName string, locationName string, longTermRetentionServerName string, options *armsql.LongTermRetentionBackupsClientListByResourceGroupServerOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByResourceGroupServerResponse])

	// NewListByServerPager is the fake for method LongTermRetentionBackupsClient.NewListByServerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByServerPager func(locationName string, longTermRetentionServerName string, options *armsql.LongTermRetentionBackupsClientListByServerOptions) (resp azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByServerResponse])

	// BeginUpdate is the fake for method LongTermRetentionBackupsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters armsql.UpdateLongTermRetentionBackupParameters, options *armsql.LongTermRetentionBackupsClientBeginUpdateOptions) (resp azfake.PollerResponder[armsql.LongTermRetentionBackupsClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateByResourceGroup is the fake for method LongTermRetentionBackupsClient.BeginUpdateByResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateByResourceGroup func(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters armsql.UpdateLongTermRetentionBackupParameters, options *armsql.LongTermRetentionBackupsClientBeginUpdateByResourceGroupOptions) (resp azfake.PollerResponder[armsql.LongTermRetentionBackupsClientUpdateByResourceGroupResponse], errResp azfake.ErrorResponder)
}

// NewLongTermRetentionBackupsServerTransport creates a new instance of LongTermRetentionBackupsServerTransport with the provided implementation.
// The returned LongTermRetentionBackupsServerTransport instance is connected to an instance of armsql.LongTermRetentionBackupsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLongTermRetentionBackupsServerTransport(srv *LongTermRetentionBackupsServer) *LongTermRetentionBackupsServerTransport {
	return &LongTermRetentionBackupsServerTransport{
		srv:                                  srv,
		beginChangeAccessTier:                newTracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientChangeAccessTierResponse]](),
		beginChangeAccessTierByResourceGroup: newTracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientChangeAccessTierByResourceGroupResponse]](),
		beginCopy:                            newTracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientCopyResponse]](),
		beginCopyByResourceGroup:             newTracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientCopyByResourceGroupResponse]](),
		beginDelete:                          newTracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientDeleteResponse]](),
		beginDeleteByResourceGroup:           newTracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientDeleteByResourceGroupResponse]](),
		newListByDatabasePager:               newTracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByDatabaseResponse]](),
		newListByLocationPager:               newTracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByLocationResponse]](),
		newListByResourceGroupDatabasePager:  newTracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByResourceGroupDatabaseResponse]](),
		newListByResourceGroupLocationPager:  newTracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByResourceGroupLocationResponse]](),
		newListByResourceGroupServerPager:    newTracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByResourceGroupServerResponse]](),
		newListByServerPager:                 newTracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByServerResponse]](),
		beginUpdate:                          newTracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientUpdateResponse]](),
		beginUpdateByResourceGroup:           newTracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientUpdateByResourceGroupResponse]](),
	}
}

// LongTermRetentionBackupsServerTransport connects instances of armsql.LongTermRetentionBackupsClient to instances of LongTermRetentionBackupsServer.
// Don't use this type directly, use NewLongTermRetentionBackupsServerTransport instead.
type LongTermRetentionBackupsServerTransport struct {
	srv                                  *LongTermRetentionBackupsServer
	beginChangeAccessTier                *tracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientChangeAccessTierResponse]]
	beginChangeAccessTierByResourceGroup *tracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientChangeAccessTierByResourceGroupResponse]]
	beginCopy                            *tracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientCopyResponse]]
	beginCopyByResourceGroup             *tracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientCopyByResourceGroupResponse]]
	beginDelete                          *tracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientDeleteResponse]]
	beginDeleteByResourceGroup           *tracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientDeleteByResourceGroupResponse]]
	newListByDatabasePager               *tracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByDatabaseResponse]]
	newListByLocationPager               *tracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByLocationResponse]]
	newListByResourceGroupDatabasePager  *tracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByResourceGroupDatabaseResponse]]
	newListByResourceGroupLocationPager  *tracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByResourceGroupLocationResponse]]
	newListByResourceGroupServerPager    *tracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByResourceGroupServerResponse]]
	newListByServerPager                 *tracker[azfake.PagerResponder[armsql.LongTermRetentionBackupsClientListByServerResponse]]
	beginUpdate                          *tracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientUpdateResponse]]
	beginUpdateByResourceGroup           *tracker[azfake.PollerResponder[armsql.LongTermRetentionBackupsClientUpdateByResourceGroupResponse]]
}

// Do implements the policy.Transporter interface for LongTermRetentionBackupsServerTransport.
func (l *LongTermRetentionBackupsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LongTermRetentionBackupsClient.BeginChangeAccessTier":
		resp, err = l.dispatchBeginChangeAccessTier(req)
	case "LongTermRetentionBackupsClient.BeginChangeAccessTierByResourceGroup":
		resp, err = l.dispatchBeginChangeAccessTierByResourceGroup(req)
	case "LongTermRetentionBackupsClient.BeginCopy":
		resp, err = l.dispatchBeginCopy(req)
	case "LongTermRetentionBackupsClient.BeginCopyByResourceGroup":
		resp, err = l.dispatchBeginCopyByResourceGroup(req)
	case "LongTermRetentionBackupsClient.BeginDelete":
		resp, err = l.dispatchBeginDelete(req)
	case "LongTermRetentionBackupsClient.BeginDeleteByResourceGroup":
		resp, err = l.dispatchBeginDeleteByResourceGroup(req)
	case "LongTermRetentionBackupsClient.Get":
		resp, err = l.dispatchGet(req)
	case "LongTermRetentionBackupsClient.GetByResourceGroup":
		resp, err = l.dispatchGetByResourceGroup(req)
	case "LongTermRetentionBackupsClient.NewListByDatabasePager":
		resp, err = l.dispatchNewListByDatabasePager(req)
	case "LongTermRetentionBackupsClient.NewListByLocationPager":
		resp, err = l.dispatchNewListByLocationPager(req)
	case "LongTermRetentionBackupsClient.NewListByResourceGroupDatabasePager":
		resp, err = l.dispatchNewListByResourceGroupDatabasePager(req)
	case "LongTermRetentionBackupsClient.NewListByResourceGroupLocationPager":
		resp, err = l.dispatchNewListByResourceGroupLocationPager(req)
	case "LongTermRetentionBackupsClient.NewListByResourceGroupServerPager":
		resp, err = l.dispatchNewListByResourceGroupServerPager(req)
	case "LongTermRetentionBackupsClient.NewListByServerPager":
		resp, err = l.dispatchNewListByServerPager(req)
	case "LongTermRetentionBackupsClient.BeginUpdate":
		resp, err = l.dispatchBeginUpdate(req)
	case "LongTermRetentionBackupsClient.BeginUpdateByResourceGroup":
		resp, err = l.dispatchBeginUpdateByResourceGroup(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchBeginChangeAccessTier(req *http.Request) (*http.Response, error) {
	if l.srv.BeginChangeAccessTier == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginChangeAccessTier not implemented")}
	}
	beginChangeAccessTier := l.beginChangeAccessTier.get(req)
	if beginChangeAccessTier == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/changeAccessTier`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ChangeLongTermRetentionBackupAccessTierParameters](req)
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginChangeAccessTier(req.Context(), locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, backupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginChangeAccessTier = &respr
		l.beginChangeAccessTier.add(req, beginChangeAccessTier)
	}

	resp, err := server.PollerResponderNext(beginChangeAccessTier, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginChangeAccessTier.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginChangeAccessTier) {
		l.beginChangeAccessTier.remove(req)
	}

	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchBeginChangeAccessTierByResourceGroup(req *http.Request) (*http.Response, error) {
	if l.srv.BeginChangeAccessTierByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginChangeAccessTierByResourceGroup not implemented")}
	}
	beginChangeAccessTierByResourceGroup := l.beginChangeAccessTierByResourceGroup.get(req)
	if beginChangeAccessTierByResourceGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/changeAccessTier`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ChangeLongTermRetentionBackupAccessTierParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginChangeAccessTierByResourceGroup(req.Context(), resourceGroupNameParam, locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, backupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginChangeAccessTierByResourceGroup = &respr
		l.beginChangeAccessTierByResourceGroup.add(req, beginChangeAccessTierByResourceGroup)
	}

	resp, err := server.PollerResponderNext(beginChangeAccessTierByResourceGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginChangeAccessTierByResourceGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginChangeAccessTierByResourceGroup) {
		l.beginChangeAccessTierByResourceGroup.remove(req)
	}

	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchBeginCopy(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCopy == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCopy not implemented")}
	}
	beginCopy := l.beginCopy.get(req)
	if beginCopy == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/copy`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.CopyLongTermRetentionBackupParameters](req)
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCopy(req.Context(), locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, backupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCopy = &respr
		l.beginCopy.add(req, beginCopy)
	}

	resp, err := server.PollerResponderNext(beginCopy, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginCopy.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCopy) {
		l.beginCopy.remove(req)
	}

	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchBeginCopyByResourceGroup(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCopyByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCopyByResourceGroup not implemented")}
	}
	beginCopyByResourceGroup := l.beginCopyByResourceGroup.get(req)
	if beginCopyByResourceGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/copy`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.CopyLongTermRetentionBackupParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCopyByResourceGroup(req.Context(), resourceGroupNameParam, locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, backupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCopyByResourceGroup = &respr
		l.beginCopyByResourceGroup.add(req, beginCopyByResourceGroup)
	}

	resp, err := server.PollerResponderNext(beginCopyByResourceGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginCopyByResourceGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCopyByResourceGroup) {
		l.beginCopyByResourceGroup.remove(req)
	}

	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if l.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := l.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginDelete(req.Context(), locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, backupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		l.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		l.beginDelete.remove(req)
	}

	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchBeginDeleteByResourceGroup(req *http.Request) (*http.Response, error) {
	if l.srv.BeginDeleteByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteByResourceGroup not implemented")}
	}
	beginDeleteByResourceGroup := l.beginDeleteByResourceGroup.get(req)
	if beginDeleteByResourceGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginDeleteByResourceGroup(req.Context(), resourceGroupNameParam, locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, backupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteByResourceGroup = &respr
		l.beginDeleteByResourceGroup.add(req, beginDeleteByResourceGroup)
	}

	resp, err := server.PollerResponderNext(beginDeleteByResourceGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginDeleteByResourceGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteByResourceGroup) {
		l.beginDeleteByResourceGroup.remove(req)
	}

	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
	if err != nil {
		return nil, err
	}
	longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
	if err != nil {
		return nil, err
	}
	backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Get(req.Context(), locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, backupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LongTermRetentionBackup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchGetByResourceGroup(req *http.Request) (*http.Response, error) {
	if l.srv.GetByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
	if err != nil {
		return nil, err
	}
	longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
	if err != nil {
		return nil, err
	}
	longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
	if err != nil {
		return nil, err
	}
	backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.GetByResourceGroup(req.Context(), resourceGroupNameParam, locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, backupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LongTermRetentionBackup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchNewListByDatabasePager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDatabasePager not implemented")}
	}
	newListByDatabasePager := l.newListByDatabasePager.get(req)
	if newListByDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionBackupsClientListByDatabaseOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionBackupsClientListByDatabaseOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByDatabasePager(locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, options)
		newListByDatabasePager = &resp
		l.newListByDatabasePager.add(req, newListByDatabasePager)
		server.PagerResponderInjectNextLinks(newListByDatabasePager, req, func(page *armsql.LongTermRetentionBackupsClientListByDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDatabasePager) {
		l.newListByDatabasePager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchNewListByLocationPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByLocationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByLocationPager not implemented")}
	}
	newListByLocationPager := l.newListByLocationPager.get(req)
	if newListByLocationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionBackupsClientListByLocationOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionBackupsClientListByLocationOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByLocationPager(locationNameParam, options)
		newListByLocationPager = &resp
		l.newListByLocationPager.add(req, newListByLocationPager)
		server.PagerResponderInjectNextLinks(newListByLocationPager, req, func(page *armsql.LongTermRetentionBackupsClientListByLocationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByLocationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByLocationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByLocationPager) {
		l.newListByLocationPager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchNewListByResourceGroupDatabasePager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByResourceGroupDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupDatabasePager not implemented")}
	}
	newListByResourceGroupDatabasePager := l.newListByResourceGroupDatabasePager.get(req)
	if newListByResourceGroupDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionBackupsClientListByResourceGroupDatabaseOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionBackupsClientListByResourceGroupDatabaseOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByResourceGroupDatabasePager(resourceGroupNameParam, locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, options)
		newListByResourceGroupDatabasePager = &resp
		l.newListByResourceGroupDatabasePager.add(req, newListByResourceGroupDatabasePager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupDatabasePager, req, func(page *armsql.LongTermRetentionBackupsClientListByResourceGroupDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByResourceGroupDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupDatabasePager) {
		l.newListByResourceGroupDatabasePager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchNewListByResourceGroupLocationPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByResourceGroupLocationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupLocationPager not implemented")}
	}
	newListByResourceGroupLocationPager := l.newListByResourceGroupLocationPager.get(req)
	if newListByResourceGroupLocationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionBackupsClientListByResourceGroupLocationOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionBackupsClientListByResourceGroupLocationOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByResourceGroupLocationPager(resourceGroupNameParam, locationNameParam, options)
		newListByResourceGroupLocationPager = &resp
		l.newListByResourceGroupLocationPager.add(req, newListByResourceGroupLocationPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupLocationPager, req, func(page *armsql.LongTermRetentionBackupsClientListByResourceGroupLocationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupLocationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByResourceGroupLocationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupLocationPager) {
		l.newListByResourceGroupLocationPager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchNewListByResourceGroupServerPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByResourceGroupServerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupServerPager not implemented")}
	}
	newListByResourceGroupServerPager := l.newListByResourceGroupServerPager.get(req)
	if newListByResourceGroupServerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionBackupsClientListByResourceGroupServerOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionBackupsClientListByResourceGroupServerOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByResourceGroupServerPager(resourceGroupNameParam, locationNameParam, longTermRetentionServerNameParam, options)
		newListByResourceGroupServerPager = &resp
		l.newListByResourceGroupServerPager.add(req, newListByResourceGroupServerPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupServerPager, req, func(page *armsql.LongTermRetentionBackupsClientListByResourceGroupServerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupServerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByResourceGroupServerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupServerPager) {
		l.newListByResourceGroupServerPager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchNewListByServerPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByServerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByServerPager not implemented")}
	}
	newListByServerPager := l.newListByServerPager.get(req)
	if newListByServerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseUnescaped, err := url.QueryUnescape(qp.Get("onlyLatestPerDatabase"))
		if err != nil {
			return nil, err
		}
		onlyLatestPerDatabaseParam, err := parseOptional(onlyLatestPerDatabaseUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		databaseStateUnescaped, err := url.QueryUnescape(qp.Get("databaseState"))
		if err != nil {
			return nil, err
		}
		databaseStateParam := getOptional(armsql.DatabaseState(databaseStateUnescaped))
		var options *armsql.LongTermRetentionBackupsClientListByServerOptions
		if onlyLatestPerDatabaseParam != nil || databaseStateParam != nil {
			options = &armsql.LongTermRetentionBackupsClientListByServerOptions{
				OnlyLatestPerDatabase: onlyLatestPerDatabaseParam,
				DatabaseState:         databaseStateParam,
			}
		}
		resp := l.srv.NewListByServerPager(locationNameParam, longTermRetentionServerNameParam, options)
		newListByServerPager = &resp
		l.newListByServerPager.add(req, newListByServerPager)
		server.PagerResponderInjectNextLinks(newListByServerPager, req, func(page *armsql.LongTermRetentionBackupsClientListByServerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByServerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByServerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByServerPager) {
		l.newListByServerPager.remove(req)
	}
	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := l.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/update`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.UpdateLongTermRetentionBackupParameters](req)
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginUpdate(req.Context(), locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, backupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		l.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		l.beginUpdate.remove(req)
	}

	return resp, nil
}

func (l *LongTermRetentionBackupsServerTransport) dispatchBeginUpdateByResourceGroup(req *http.Request) (*http.Response, error) {
	if l.srv.BeginUpdateByResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateByResourceGroup not implemented")}
	}
	beginUpdateByResourceGroup := l.beginUpdateByResourceGroup.get(req)
	if beginUpdateByResourceGroup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionServers/(?P<longTermRetentionServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionDatabases/(?P<longTermRetentionDatabaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/longTermRetentionBackups/(?P<backupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/update`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.UpdateLongTermRetentionBackupParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionServerName")])
		if err != nil {
			return nil, err
		}
		longTermRetentionDatabaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("longTermRetentionDatabaseName")])
		if err != nil {
			return nil, err
		}
		backupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("backupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginUpdateByResourceGroup(req.Context(), resourceGroupNameParam, locationNameParam, longTermRetentionServerNameParam, longTermRetentionDatabaseNameParam, backupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateByResourceGroup = &respr
		l.beginUpdateByResourceGroup.add(req, beginUpdateByResourceGroup)
	}

	resp, err := server.PollerResponderNext(beginUpdateByResourceGroup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginUpdateByResourceGroup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateByResourceGroup) {
		l.beginUpdateByResourceGroup.remove(req)
	}

	return resp, nil
}
