//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/servicelinker/armservicelinker/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// ConnectorServer is a fake server for instances of the armservicelinker.ConnectorClient type.
type ConnectorServer struct {
	// BeginCreateDryrun is the fake for method ConnectorClient.BeginCreateDryrun
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateDryrun func(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, parameters armservicelinker.DryrunResource, options *armservicelinker.ConnectorClientBeginCreateDryrunOptions) (resp azfake.PollerResponder[armservicelinker.ConnectorClientCreateDryrunResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method ConnectorClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, parameters armservicelinker.LinkerResource, options *armservicelinker.ConnectorClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armservicelinker.ConnectorClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ConnectorClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *armservicelinker.ConnectorClientBeginDeleteOptions) (resp azfake.PollerResponder[armservicelinker.ConnectorClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteDryrun is the fake for method ConnectorClient.DeleteDryrun
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteDryrun func(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, options *armservicelinker.ConnectorClientDeleteDryrunOptions) (resp azfake.Responder[armservicelinker.ConnectorClientDeleteDryrunResponse], errResp azfake.ErrorResponder)

	// GenerateConfigurations is the fake for method ConnectorClient.GenerateConfigurations
	// HTTP status codes to indicate success: http.StatusOK
	GenerateConfigurations func(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *armservicelinker.ConnectorClientGenerateConfigurationsOptions) (resp azfake.Responder[armservicelinker.ConnectorClientGenerateConfigurationsResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ConnectorClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *armservicelinker.ConnectorClientGetOptions) (resp azfake.Responder[armservicelinker.ConnectorClientGetResponse], errResp azfake.ErrorResponder)

	// GetDryrun is the fake for method ConnectorClient.GetDryrun
	// HTTP status codes to indicate success: http.StatusOK
	GetDryrun func(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, options *armservicelinker.ConnectorClientGetDryrunOptions) (resp azfake.Responder[armservicelinker.ConnectorClientGetDryrunResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ConnectorClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(subscriptionID string, resourceGroupName string, location string, options *armservicelinker.ConnectorClientListOptions) (resp azfake.PagerResponder[armservicelinker.ConnectorClientListResponse])

	// NewListDryrunPager is the fake for method ConnectorClient.NewListDryrunPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDryrunPager func(subscriptionID string, resourceGroupName string, location string, options *armservicelinker.ConnectorClientListDryrunOptions) (resp azfake.PagerResponder[armservicelinker.ConnectorClientListDryrunResponse])

	// BeginUpdate is the fake for method ConnectorClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, parameters armservicelinker.LinkerPatch, options *armservicelinker.ConnectorClientBeginUpdateOptions) (resp azfake.PollerResponder[armservicelinker.ConnectorClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateDryrun is the fake for method ConnectorClient.BeginUpdateDryrun
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateDryrun func(ctx context.Context, subscriptionID string, resourceGroupName string, location string, dryrunName string, parameters armservicelinker.DryrunPatch, options *armservicelinker.ConnectorClientBeginUpdateDryrunOptions) (resp azfake.PollerResponder[armservicelinker.ConnectorClientUpdateDryrunResponse], errResp azfake.ErrorResponder)

	// BeginValidate is the fake for method ConnectorClient.BeginValidate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginValidate func(ctx context.Context, subscriptionID string, resourceGroupName string, location string, connectorName string, options *armservicelinker.ConnectorClientBeginValidateOptions) (resp azfake.PollerResponder[armservicelinker.ConnectorClientValidateResponse], errResp azfake.ErrorResponder)
}

// NewConnectorServerTransport creates a new instance of ConnectorServerTransport with the provided implementation.
// The returned ConnectorServerTransport instance is connected to an instance of armservicelinker.ConnectorClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConnectorServerTransport(srv *ConnectorServer) *ConnectorServerTransport {
	return &ConnectorServerTransport{
		srv:                 srv,
		beginCreateDryrun:   newTracker[azfake.PollerResponder[armservicelinker.ConnectorClientCreateDryrunResponse]](),
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armservicelinker.ConnectorClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armservicelinker.ConnectorClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armservicelinker.ConnectorClientListResponse]](),
		newListDryrunPager:  newTracker[azfake.PagerResponder[armservicelinker.ConnectorClientListDryrunResponse]](),
		beginUpdate:         newTracker[azfake.PollerResponder[armservicelinker.ConnectorClientUpdateResponse]](),
		beginUpdateDryrun:   newTracker[azfake.PollerResponder[armservicelinker.ConnectorClientUpdateDryrunResponse]](),
		beginValidate:       newTracker[azfake.PollerResponder[armservicelinker.ConnectorClientValidateResponse]](),
	}
}

// ConnectorServerTransport connects instances of armservicelinker.ConnectorClient to instances of ConnectorServer.
// Don't use this type directly, use NewConnectorServerTransport instead.
type ConnectorServerTransport struct {
	srv                 *ConnectorServer
	beginCreateDryrun   *tracker[azfake.PollerResponder[armservicelinker.ConnectorClientCreateDryrunResponse]]
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armservicelinker.ConnectorClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armservicelinker.ConnectorClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armservicelinker.ConnectorClientListResponse]]
	newListDryrunPager  *tracker[azfake.PagerResponder[armservicelinker.ConnectorClientListDryrunResponse]]
	beginUpdate         *tracker[azfake.PollerResponder[armservicelinker.ConnectorClientUpdateResponse]]
	beginUpdateDryrun   *tracker[azfake.PollerResponder[armservicelinker.ConnectorClientUpdateDryrunResponse]]
	beginValidate       *tracker[azfake.PollerResponder[armservicelinker.ConnectorClientValidateResponse]]
}

// Do implements the policy.Transporter interface for ConnectorServerTransport.
func (c *ConnectorServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConnectorClient.BeginCreateDryrun":
		resp, err = c.dispatchBeginCreateDryrun(req)
	case "ConnectorClient.BeginCreateOrUpdate":
		resp, err = c.dispatchBeginCreateOrUpdate(req)
	case "ConnectorClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "ConnectorClient.DeleteDryrun":
		resp, err = c.dispatchDeleteDryrun(req)
	case "ConnectorClient.GenerateConfigurations":
		resp, err = c.dispatchGenerateConfigurations(req)
	case "ConnectorClient.Get":
		resp, err = c.dispatchGet(req)
	case "ConnectorClient.GetDryrun":
		resp, err = c.dispatchGetDryrun(req)
	case "ConnectorClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "ConnectorClient.NewListDryrunPager":
		resp, err = c.dispatchNewListDryrunPager(req)
	case "ConnectorClient.BeginUpdate":
		resp, err = c.dispatchBeginUpdate(req)
	case "ConnectorClient.BeginUpdateDryrun":
		resp, err = c.dispatchBeginUpdateDryrun(req)
	case "ConnectorClient.BeginValidate":
		resp, err = c.dispatchBeginValidate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConnectorServerTransport) dispatchBeginCreateDryrun(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateDryrun == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateDryrun not implemented")}
	}
	beginCreateDryrun := c.beginCreateDryrun.get(req)
	if beginCreateDryrun == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dryruns/(?P<dryrunName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armservicelinker.DryrunResource](req)
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		dryrunNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dryrunName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateDryrun(req.Context(), subscriptionIDParam, resourceGroupNameParam, locationParam, dryrunNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateDryrun = &respr
		c.beginCreateDryrun.add(req, beginCreateDryrun)
	}

	resp, err := server.PollerResponderNext(beginCreateDryrun, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateDryrun.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateDryrun) {
		c.beginCreateDryrun.remove(req)
	}

	return resp, nil
}

func (c *ConnectorServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := c.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors/(?P<connectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armservicelinker.LinkerResource](req)
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		connectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectorName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdate(req.Context(), subscriptionIDParam, resourceGroupNameParam, locationParam, connectorNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		c.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		c.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (c *ConnectorServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors/(?P<connectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		connectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectorName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), subscriptionIDParam, resourceGroupNameParam, locationParam, connectorNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *ConnectorServerTransport) dispatchDeleteDryrun(req *http.Request) (*http.Response, error) {
	if c.srv.DeleteDryrun == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteDryrun not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dryruns/(?P<dryrunName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	dryrunNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dryrunName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.DeleteDryrun(req.Context(), subscriptionIDParam, resourceGroupNameParam, locationParam, dryrunNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectorServerTransport) dispatchGenerateConfigurations(req *http.Request) (*http.Response, error) {
	if c.srv.GenerateConfigurations == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateConfigurations not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors/(?P<connectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateConfigurations`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armservicelinker.ConfigurationInfo](req)
	if err != nil {
		return nil, err
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	connectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectorName")])
	if err != nil {
		return nil, err
	}
	var options *armservicelinker.ConnectorClientGenerateConfigurationsOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armservicelinker.ConnectorClientGenerateConfigurationsOptions{
			Parameters: &body,
		}
	}
	respr, errRespr := c.srv.GenerateConfigurations(req.Context(), subscriptionIDParam, resourceGroupNameParam, locationParam, connectorNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConfigurationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectorServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors/(?P<connectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	connectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), subscriptionIDParam, resourceGroupNameParam, locationParam, connectorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LinkerResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectorServerTransport) dispatchGetDryrun(req *http.Request) (*http.Response, error) {
	if c.srv.GetDryrun == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDryrun not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dryruns/(?P<dryrunName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	dryrunNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dryrunName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetDryrun(req.Context(), subscriptionIDParam, resourceGroupNameParam, locationParam, dryrunNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DryrunResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectorServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListPager(subscriptionIDParam, resourceGroupNameParam, locationParam, nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armservicelinker.ConnectorClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *ConnectorServerTransport) dispatchNewListDryrunPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListDryrunPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDryrunPager not implemented")}
	}
	newListDryrunPager := c.newListDryrunPager.get(req)
	if newListDryrunPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dryruns`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListDryrunPager(subscriptionIDParam, resourceGroupNameParam, locationParam, nil)
		newListDryrunPager = &resp
		c.newListDryrunPager.add(req, newListDryrunPager)
		server.PagerResponderInjectNextLinks(newListDryrunPager, req, func(page *armservicelinker.ConnectorClientListDryrunResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDryrunPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListDryrunPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDryrunPager) {
		c.newListDryrunPager.remove(req)
	}
	return resp, nil
}

func (c *ConnectorServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := c.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors/(?P<connectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armservicelinker.LinkerPatch](req)
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		connectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectorName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdate(req.Context(), subscriptionIDParam, resourceGroupNameParam, locationParam, connectorNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		c.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		c.beginUpdate.remove(req)
	}

	return resp, nil
}

func (c *ConnectorServerTransport) dispatchBeginUpdateDryrun(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdateDryrun == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateDryrun not implemented")}
	}
	beginUpdateDryrun := c.beginUpdateDryrun.get(req)
	if beginUpdateDryrun == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dryruns/(?P<dryrunName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armservicelinker.DryrunPatch](req)
		if err != nil {
			return nil, err
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		dryrunNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dryrunName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdateDryrun(req.Context(), subscriptionIDParam, resourceGroupNameParam, locationParam, dryrunNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateDryrun = &respr
		c.beginUpdateDryrun.add(req, beginUpdateDryrun)
	}

	resp, err := server.PollerResponderNext(beginUpdateDryrun, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdateDryrun.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateDryrun) {
		c.beginUpdateDryrun.remove(req)
	}

	return resp, nil
}

func (c *ConnectorServerTransport) dispatchBeginValidate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginValidate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidate not implemented")}
	}
	beginValidate := c.beginValidate.get(req)
	if beginValidate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors/(?P<connectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		connectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectorName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginValidate(req.Context(), subscriptionIDParam, resourceGroupNameParam, locationParam, connectorNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidate = &respr
		c.beginValidate.add(req, beginValidate)
	}

	resp, err := server.PollerResponderNext(beginValidate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginValidate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidate) {
		c.beginValidate.remove(req)
	}

	return resp, nil
}
