//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicelinker

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	internal *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		internal: internal,
	}, nil
}

// NewConfigurationNamesClient creates a new instance of ConfigurationNamesClient.
func (c *ClientFactory) NewConfigurationNamesClient() *ConfigurationNamesClient {
	return &ConfigurationNamesClient{
		internal: c.internal,
	}
}

// NewConnectorClient creates a new instance of ConnectorClient.
func (c *ClientFactory) NewConnectorClient() *ConnectorClient {
	return &ConnectorClient{
		internal: c.internal,
	}
}

// NewLinkerClient creates a new instance of LinkerClient.
func (c *ClientFactory) NewLinkerClient() *LinkerClient {
	return &LinkerClient{
		internal: c.internal,
	}
}

// NewLinkersClient creates a new instance of LinkersClient.
func (c *ClientFactory) NewLinkersClient() *LinkersClient {
	return &LinkersClient{
		internal: c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}
