//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicefabric

import "time"

// ApplicationDeltaHealthPolicy - Defines a delta health policy used to evaluate the health of an application or one of its
// child entities when upgrading the cluster.
type ApplicationDeltaHealthPolicy struct {
	// The delta health policy used by default to evaluate the health of a service type when upgrading the cluster.
	DefaultServiceTypeDeltaHealthPolicy *ServiceTypeDeltaHealthPolicy

	// The map with service type delta health policy per service type name. The map is empty by default.
	ServiceTypeDeltaHealthPolicies map[string]*ServiceTypeDeltaHealthPolicy
}

// ApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children
// entities.
type ApplicationHealthPolicy struct {
	// The health policy used by default to evaluate the health of a service type.
	DefaultServiceTypeHealthPolicy *ServiceTypeHealthPolicy

	// The map with service type health policy per service type name. The map is empty by default.
	ServiceTypeHealthPolicies map[string]*ServiceTypeHealthPolicy
}

// ApplicationMetricDescription - Describes capacity information for a custom resource balancing metric. This can be used
// to limit the total consumption of this metric by the services of this application.
type ApplicationMetricDescription struct {
	// The maximum node capacity for Service Fabric application. This is the maximum Load for an instance of this application
	// on a single node. Even if the capacity of node is greater than this value,
	// Service Fabric will limit the total load of services within the application on each node to this value. If set to zero,
	// capacity for this metric is unlimited on each node. When creating a new
	// application with application capacity defined, the product of MaximumNodes and this value must always be smaller than or
	// equal to TotalApplicationCapacity. When updating existing application with
	// application capacity, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	MaximumCapacity *int64

	// The name of the metric.
	Name *string

	// The node reservation capacity for Service Fabric application. This is the amount of load which is reserved on nodes which
	// have instances of this application. If MinimumNodes is specified, then the
	// product of these values will be the capacity reserved in the cluster for the application. If set to zero, no capacity is
	// reserved for this metric. When setting application capacity or when updating
	// application capacity; this value must be smaller than or equal to MaximumCapacity for each metric.
	ReservationCapacity *int64

	// The total metric capacity for Service Fabric application. This is the total metric capacity for this application in the
	// cluster. Service Fabric will try to limit the sum of loads of services within
	// the application to this value. When creating a new application with application capacity defined, the product of MaximumNodes
	// and MaximumCapacity must always be smaller than or equal to this value.
	TotalApplicationCapacity *int64
}

// ApplicationResource - The application resource.
type ApplicationResource struct {
	// Describes the managed identities for an Azure resource.
	Identity *ManagedIdentity

	// It will be deprecated in New API, resource location depends on the parent resource.
	Location *string

	// The application resource properties.
	Properties *ApplicationResourceProperties

	// Azure resource tags.
	Tags map[string]*string

	// READ-ONLY; Azure resource etag.
	Etag *string

	// READ-ONLY; Azure resource identifier.
	ID *string

	// READ-ONLY; Azure resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Azure resource type.
	Type *string
}

// ApplicationResourceList - The list of application resources.
type ApplicationResourceList struct {
	Value []*ApplicationResource

	// READ-ONLY; URL to get the next set of application list results if there are any.
	NextLink *string
}

// ApplicationResourceProperties - The application resource properties.
type ApplicationResourceProperties struct {
	// List of user assigned identities for the application, each mapped to a friendly name.
	ManagedIdentities []*ApplicationUserAssignedIdentity

	// The maximum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean
	// that the services of this application will be placed on all of those nodes. By
	// default, the value of this property is zero and it means that the services can be placed on any node.
	MaximumNodes *int64

	// List of application capacity metric description.
	Metrics []*ApplicationMetricDescription

	// The minimum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean
	// that the services of this application will be placed on all of those nodes. If
	// this property is set to zero, no capacity will be reserved. The value of this property cannot be more than the value of
	// the MaximumNodes property.
	MinimumNodes *int64

	// List of application parameters with overridden values from their default values specified in the application manifest.
	Parameters map[string]*string

	// Remove the current application capacity settings.
	RemoveApplicationCapacity *bool

	// The application type name as defined in the application manifest.
	TypeName *string

	// The version of the application type as defined in the application manifest.
	TypeVersion *string

	// Describes the policy for a monitored application upgrade.
	UpgradePolicy *ApplicationUpgradePolicy

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string
}

// ApplicationResourceUpdate - The application resource for patch operations.
type ApplicationResourceUpdate struct {
	// It will be deprecated in New API, resource location depends on the parent resource.
	Location *string

	// The application resource properties for patch operations.
	Properties *ApplicationResourceUpdateProperties

	// Azure resource tags.
	Tags map[string]*string

	// READ-ONLY; Azure resource etag.
	Etag *string

	// READ-ONLY; Azure resource identifier.
	ID *string

	// READ-ONLY; Azure resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Azure resource type.
	Type *string
}

// ApplicationResourceUpdateProperties - The application resource properties for patch operations.
type ApplicationResourceUpdateProperties struct {
	// List of user assigned identities for the application, each mapped to a friendly name.
	ManagedIdentities []*ApplicationUserAssignedIdentity

	// The maximum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean
	// that the services of this application will be placed on all of those nodes. By
	// default, the value of this property is zero and it means that the services can be placed on any node.
	MaximumNodes *int64

	// List of application capacity metric description.
	Metrics []*ApplicationMetricDescription

	// The minimum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean
	// that the services of this application will be placed on all of those nodes. If
	// this property is set to zero, no capacity will be reserved. The value of this property cannot be more than the value of
	// the MaximumNodes property.
	MinimumNodes *int64

	// List of application parameters with overridden values from their default values specified in the application manifest.
	Parameters map[string]*string

	// Remove the current application capacity settings.
	RemoveApplicationCapacity *bool

	// The version of the application type as defined in the application manifest.
	TypeVersion *string

	// Describes the policy for a monitored application upgrade.
	UpgradePolicy *ApplicationUpgradePolicy
}

// ApplicationTypeResource - The application type name resource
type ApplicationTypeResource struct {
	// It will be deprecated in New API, resource location depends on the parent resource.
	Location *string

	// The application type name properties
	Properties *ApplicationTypeResourceProperties

	// Azure resource tags.
	Tags map[string]*string

	// READ-ONLY; Azure resource etag.
	Etag *string

	// READ-ONLY; Azure resource identifier.
	ID *string

	// READ-ONLY; Azure resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Azure resource type.
	Type *string
}

// ApplicationTypeResourceList - The list of application type names.
type ApplicationTypeResourceList struct {
	Value []*ApplicationTypeResource

	// READ-ONLY; URL to get the next set of application type list results if there are any.
	NextLink *string
}

// ApplicationTypeResourceProperties - The application type name properties
type ApplicationTypeResourceProperties struct {
	// READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string
}

// ApplicationTypeVersionResource - An application type version resource for the specified application type name resource.
type ApplicationTypeVersionResource struct {
	// It will be deprecated in New API, resource location depends on the parent resource.
	Location *string

	// The properties of the application type version resource.
	Properties *ApplicationTypeVersionResourceProperties

	// Azure resource tags.
	Tags map[string]*string

	// READ-ONLY; Azure resource etag.
	Etag *string

	// READ-ONLY; Azure resource identifier.
	ID *string

	// READ-ONLY; Azure resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Azure resource type.
	Type *string
}

// ApplicationTypeVersionResourceList - The list of application type version resources for the specified application type
// name resource.
type ApplicationTypeVersionResourceList struct {
	Value []*ApplicationTypeVersionResource

	// READ-ONLY; URL to get the next set of application type version list results if there are any.
	NextLink *string
}

// ApplicationTypeVersionResourceProperties - The properties of the application type version resource.
type ApplicationTypeVersionResourceProperties struct {
	// REQUIRED; The URL to the application package
	AppPackageURL *string

	// READ-ONLY; List of application type parameters that can be overridden when creating or updating the application.
	DefaultParameterList map[string]*string

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string
}

type ApplicationTypeVersionsCleanupPolicy struct {
	// REQUIRED; Number of unused versions per application type to keep.
	MaxUnusedVersionsToKeep *int64
}

// ApplicationUpgradePolicy - Describes the policy for a monitored application upgrade.
type ApplicationUpgradePolicy struct {
	// Defines a health policy used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicy *ArmApplicationHealthPolicy

	// If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade
	// only changes configuration or data).
	ForceRestart *bool

	// Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters
	// are not allowed and it will result in availability loss.
	RecreateApplication *bool

	// The policy used for monitoring the application upgrade
	RollingUpgradeMonitoringPolicy *ArmRollingUpgradeMonitoringPolicy

	// The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored.
	UpgradeMode *RollingUpgradeMode

	// The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected
	// issues. When this timeout expires, processing of the upgrade domain will
	// proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values
	// are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
	UpgradeReplicaSetCheckTimeout *string
}

type ApplicationUserAssignedIdentity struct {
	// REQUIRED; The friendly name of user assigned identity.
	Name *string

	// REQUIRED; The principal id of user assigned identity.
	PrincipalID *string
}

// ArmApplicationHealthPolicy - Defines a health policy used to evaluate the health of an application or one of its children
// entities.
type ArmApplicationHealthPolicy struct {
	// Indicates whether warnings are treated with the same severity as errors.
	ConsiderWarningAsError *bool

	// The health policy used by default to evaluate the health of a service type.
	DefaultServiceTypeHealthPolicy *ArmServiceTypeHealthPolicy

	// The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100. The
	// percentage represents the maximum tolerated percentage of deployed applications
	// that can be unhealthy before the application is considered in error. This is calculated by dividing the number of unhealthy
	// deployed applications over the number of nodes where the application is
	// currently deployed on in the cluster. The computation rounds up to tolerate one failure on small numbers of nodes. Default
	// percentage is zero.
	MaxPercentUnhealthyDeployedApplications *int32

	// The map with service type health policy per service type name. The map is empty by default.
	ServiceTypeHealthPolicyMap map[string]*ArmServiceTypeHealthPolicy
}

// ArmRollingUpgradeMonitoringPolicy - The policy used for monitoring the application upgrade
type ArmRollingUpgradeMonitoringPolicy struct {
	// The activation Mode of the service package
	FailureAction *ArmUpgradeFailureAction

	// The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed.
	// It is first interpreted as a string representing an ISO 8601 duration. If
	// that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckRetryTimeout *string

	// The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade
	// domain. It is first interpreted as a string representing an ISO 8601 duration. If
	// that fails, then it is interpreted as a number representing the total number of milliseconds.
	HealthCheckStableDuration *string

	// The amount of time to wait after completing an upgrade domain before applying health policies. It is first interpreted
	// as a string representing an ISO 8601 duration. If that fails, then it is
	// interpreted as a number representing the total number of milliseconds.
	HealthCheckWaitDuration *string

	// The amount of time each upgrade domain has to complete before FailureAction is executed. It is first interpreted as a string
	// representing an ISO 8601 duration. If that fails, then it is interpreted as
	// a number representing the total number of milliseconds.
	UpgradeDomainTimeout *string

	// The amount of time the overall upgrade has to complete before FailureAction is executed. It is first interpreted as a string
	// representing an ISO 8601 duration. If that fails, then it is interpreted as
	// a number representing the total number of milliseconds.
	UpgradeTimeout *string
}

// ArmServiceTypeHealthPolicy - Represents the health policy used to evaluate the health of services belonging to a service
// type.
type ArmServiceTypeHealthPolicy struct {
	// The maximum percentage of partitions per service allowed to be unhealthy before your application is considered in error.
	MaxPercentUnhealthyPartitionsPerService *int32

	// The maximum percentage of replicas per partition allowed to be unhealthy before your application is considered in error.
	MaxPercentUnhealthyReplicasPerPartition *int32

	// The maximum percentage of services allowed to be unhealthy before your application is considered in error.
	MaxPercentUnhealthyServices *int32
}

// AvailableOperationDisplay - Operation supported by the Service Fabric resource provider
type AvailableOperationDisplay struct {
	// Operation description
	Description *string

	// The operation that can be performed.
	Operation *string

	// The name of the provider.
	Provider *string

	// The resource on which the operation is performed
	Resource *string
}

// AzureActiveDirectory - The settings to enable AAD authentication on the cluster.
type AzureActiveDirectory struct {
	// Azure active directory client application id.
	ClientApplication *string

	// Azure active directory cluster application id.
	ClusterApplication *string

	// Azure active directory tenant id.
	TenantID *string
}

// CertificateDescription - Describes the certificate details.
type CertificateDescription struct {
	// REQUIRED; Thumbprint of the primary certificate.
	Thumbprint *string

	// Thumbprint of the secondary certificate.
	ThumbprintSecondary *string

	// The local certificate store location.
	X509StoreName *StoreName
}

// ClientCertificateCommonName - Describes the client certificate details using common name.
type ClientCertificateCommonName struct {
	// REQUIRED; The common name of the client certificate.
	CertificateCommonName *string

	// REQUIRED; The issuer thumbprint of the client certificate.
	CertificateIssuerThumbprint *string

	// REQUIRED; Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read
	// only operations on the cluster.
	IsAdmin *bool
}

// ClientCertificateThumbprint - Describes the client certificate details using thumbprint.
type ClientCertificateThumbprint struct {
	// REQUIRED; The thumbprint of the client certificate.
	CertificateThumbprint *string

	// REQUIRED; Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read
	// only operations on the cluster.
	IsAdmin *bool
}

// Cluster - The cluster resource
type Cluster struct {
	// REQUIRED; Azure resource location.
	Location *string

	// The cluster resource properties
	Properties *ClusterProperties

	// Azure resource tags.
	Tags map[string]*string

	// READ-ONLY; Azure resource etag.
	Etag *string

	// READ-ONLY; Azure resource identifier.
	ID *string

	// READ-ONLY; Azure resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Azure resource type.
	Type *string
}

// ClusterCodeVersionsListResult - The list results of the Service Fabric runtime versions.
type ClusterCodeVersionsListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string
	Value    []*ClusterCodeVersionsResult
}

// ClusterCodeVersionsResult - The result of the Service Fabric runtime versions
type ClusterCodeVersionsResult struct {
	// The identification of the result
	ID *string

	// The name of the result
	Name *string

	// The detail of the Service Fabric runtime version result
	Properties *ClusterVersionDetails

	// The result resource type
	Type *string
}

// ClusterHealthPolicy - Defines a health policy used to evaluate the health of the cluster or of a cluster node.
type ClusterHealthPolicy struct {
	// Defines the application health policy map used to evaluate the health of an application or one of its children entities.
	ApplicationHealthPolicies map[string]*ApplicationHealthPolicy

	// The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications
	// to be unhealthy, this value would be 10.
	// The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is
	// considered in error. If the percentage is respected but there is at least one
	// unhealthy application, the health is evaluated as Warning. This is calculated by dividing the number of unhealthy applications
	// over the total number of application instances in the cluster, excluding
	// applications of application types that are included in the ApplicationTypeHealthPolicyMap. The computation rounds up to
	// tolerate one failure on small numbers of applications. Default percentage is
	// zero.
	MaxPercentUnhealthyApplications *int32

	// The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy,
	// this value would be 10.
	// The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered
	// in error. If the percentage is respected but there is at least one unhealthy
	// node, the health is evaluated as Warning. The percentage is calculated by dividing the number of unhealthy nodes over the
	// total number of nodes in the cluster. The computation rounds up to tolerate
	// one failure on small numbers of nodes. Default percentage is zero.
	// In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate
	// that.
	MaxPercentUnhealthyNodes *int32
}

// ClusterListResult - Cluster list results
type ClusterListResult struct {
	// The URL to use for getting the next set of results.
	NextLink *string
	Value    []*Cluster
}

// ClusterProperties - Describes the cluster resource properties.
type ClusterProperties struct {
	// REQUIRED; The http management endpoint of the cluster.
	ManagementEndpoint *string

	// REQUIRED; The list of node types in the cluster.
	NodeTypes []*NodeTypeDescription

	// The list of add-on features to enable in the cluster.
	AddOnFeatures []*AddOnFeatures

	// The policy used to clean up unused versions.
	ApplicationTypeVersionsCleanupPolicy *ApplicationTypeVersionsCleanupPolicy

	// The AAD authentication settings of the cluster.
	AzureActiveDirectory *AzureActiveDirectory

	// The certificate to use for securing the cluster. The certificate provided will be used for node to node security within
	// the cluster, SSL certificate for cluster management endpoint and default admin
	// client.
	Certificate *CertificateDescription

	// Describes a list of server certificates referenced by common name that are used to secure the cluster.
	CertificateCommonNames *ServerCertificateCommonNames

	// The list of client certificates referenced by common name that are allowed to manage the cluster.
	ClientCertificateCommonNames []*ClientCertificateCommonName

	// The list of client certificates referenced by thumbprint that are allowed to manage the cluster.
	ClientCertificateThumbprints []*ClientCertificateThumbprint

	// The Service Fabric runtime version of the cluster. This property can only by set the user when upgradeMode is set to 'Manual'.
	// To get list of available Service Fabric versions for new clusters use
	// ClusterVersion API [https://learn.microsoft.com/rest/api/servicefabric/cluster-versions/list]. To get the list of available
	// version for existing clusters use availableClusterVersions.
	ClusterCodeVersion *string

	// The storage account information for storing Service Fabric diagnostic logs.
	DiagnosticsStorageAccountConfig *DiagnosticsStorageAccountConfig

	// Indicates if the event store service is enabled.
	EventStoreServiceEnabled *bool

	// The list of custom fabric settings to configure the cluster.
	FabricSettings []*SettingsSectionDescription

	// Indicates if infrastructure service manager is enabled.
	InfrastructureServiceManager *bool

	// Indicates a list of notification channels for cluster events.
	Notifications []*Notification

	// The reliability level sets the replica set size of system services. Learn about ReliabilityLevel [https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity].
	// * None - Run the System services with a target replica set count of 1. This should only be used for test clusters.
	// * Bronze - Run the System services with a target replica set count of 3. This should only be used for test clusters.
	// * Silver - Run the System services with a target replica set count of 5.
	// * Gold - Run the System services with a target replica set count of 7.
	// * Platinum - Run the System services with a target replica set count of 9.
	ReliabilityLevel *ReliabilityLevel

	// The server certificate used by reverse proxy.
	ReverseProxyCertificate *CertificateDescription

	// Describes a list of server certificates referenced by common name that are used to secure the cluster.
	ReverseProxyCertificateCommonNames *ServerCertificateCommonNames

	// This property controls the logical grouping of VMs in upgrade domains (UDs). This property can't be modified if a node
	// type with multiple Availability Zones is already present in the cluster.
	SfZonalUpgradeMode *SfZonalUpgradeMode

	// The policy to use when upgrading the cluster.
	UpgradeDescription *ClusterUpgradePolicy

	// The upgrade mode of the cluster when new Service Fabric runtime version is available.
	UpgradeMode *UpgradeMode

	// Indicates the end date and time to pause automatic runtime version upgrades on the cluster for an specific period of time
	// on the cluster (UTC).
	UpgradePauseEndTimestampUTC *time.Time

	// Indicates the start date and time to pause automatic runtime version upgrades on the cluster for an specific period of
	// time on the cluster (UTC).
	UpgradePauseStartTimestampUTC *time.Time

	// Indicates when new cluster runtime version upgrades will be applied after they are released. By default is Wave0. Only
	// applies when upgradeMode is set to 'Automatic'.
	UpgradeWave *ClusterUpgradeCadence

	// The VM image VMSS has been configured with. Generic names such as Windows or Linux can be used.
	VMImage *string

	// This property defines the upgrade mode for the virtual machine scale set, it is mandatory if a node type with multiple
	// Availability Zones is added.
	VmssZonalUpgradeMode *VmssZonalUpgradeMode

	// Boolean to pause automatic runtime version upgrades to the cluster.
	WaveUpgradePaused *bool

	// READ-ONLY; The Service Fabric runtime versions available for this cluster.
	AvailableClusterVersions []*ClusterVersionDetails

	// READ-ONLY; The Azure Resource Provider endpoint. A system service in the cluster connects to this endpoint.
	ClusterEndpoint *string

	// READ-ONLY; A service generated unique identifier for the cluster resource.
	ClusterID *string

	// READ-ONLY; The current state of the cluster.
	// * WaitingForNodes - Indicates that the cluster resource is created and the resource provider is waiting for Service Fabric
	// VM extension to boot up and report to it.
	// * Deploying - Indicates that the Service Fabric runtime is being installed on the VMs. Cluster resource will be in this
	// state until the cluster boots up and system services are up.
	// * BaselineUpgrade - Indicates that the cluster is upgrading to establishes the cluster version. This upgrade is automatically
	// initiated when the cluster boots up for the first time.
	// * UpdatingUserConfiguration - Indicates that the cluster is being upgraded with the user provided configuration.
	// * UpdatingUserCertificate - Indicates that the cluster is being upgraded with the user provided certificate.
	// * UpdatingInfrastructure - Indicates that the cluster is being upgraded with the latest Service Fabric runtime version.
	// This happens only when the upgradeMode is set to 'Automatic'.
	// * EnforcingClusterVersion - Indicates that cluster is on a different version than expected and the cluster is being upgraded
	// to the expected version.
	// * UpgradeServiceUnreachable - Indicates that the system service in the cluster is no longer polling the Resource Provider.
	// Clusters in this state cannot be managed by the Resource Provider.
	// * AutoScale - Indicates that the ReliabilityLevel of the cluster is being adjusted.
	// * Ready - Indicates that the cluster is in a stable state.
	ClusterState *ClusterState

	// READ-ONLY; The provisioning state of the cluster resource.
	ProvisioningState *ProvisioningState
}

// ClusterPropertiesUpdateParameters - Describes the cluster resource properties that can be updated during PATCH operation.
type ClusterPropertiesUpdateParameters struct {
	// The list of add-on features to enable in the cluster.
	AddOnFeatures []*AddOnFeatures

	// The policy used to clean up unused versions.
	ApplicationTypeVersionsCleanupPolicy *ApplicationTypeVersionsCleanupPolicy

	// The certificate to use for securing the cluster. The certificate provided will be used for node to node security within
	// the cluster, SSL certificate for cluster management endpoint and default admin
	// client.
	Certificate *CertificateDescription

	// Describes a list of server certificates referenced by common name that are used to secure the cluster.
	CertificateCommonNames *ServerCertificateCommonNames

	// The list of client certificates referenced by common name that are allowed to manage the cluster. This will overwrite the
	// existing list.
	ClientCertificateCommonNames []*ClientCertificateCommonName

	// The list of client certificates referenced by thumbprint that are allowed to manage the cluster. This will overwrite the
	// existing list.
	ClientCertificateThumbprints []*ClientCertificateThumbprint

	// The Service Fabric runtime version of the cluster. This property can only by set the user when upgradeMode is set to 'Manual'.
	// To get list of available Service Fabric versions for new clusters use
	// ClusterVersion API [https://learn.microsoft.com/rest/api/servicefabric/cluster-versions/list]. To get the list of available
	// version for existing clusters use availableClusterVersions.
	ClusterCodeVersion *string

	// Indicates if the event store service is enabled.
	EventStoreServiceEnabled *bool

	// The list of custom fabric settings to configure the cluster. This will overwrite the existing list.
	FabricSettings []*SettingsSectionDescription

	// Indicates if infrastructure service manager is enabled.
	InfrastructureServiceManager *bool

	// The list of node types in the cluster. This will overwrite the existing list.
	NodeTypes []*NodeTypeDescription

	// Indicates a list of notification channels for cluster events.
	Notifications []*Notification

	// The reliability level sets the replica set size of system services. Learn about ReliabilityLevel [https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity].
	// * None - Run the System services with a target replica set count of 1. This should only be used for test clusters.
	// * Bronze - Run the System services with a target replica set count of 3. This should only be used for test clusters.
	// * Silver - Run the System services with a target replica set count of 5.
	// * Gold - Run the System services with a target replica set count of 7.
	// * Platinum - Run the System services with a target replica set count of 9.
	ReliabilityLevel *ReliabilityLevel

	// The server certificate used by reverse proxy.
	ReverseProxyCertificate *CertificateDescription

	// This property controls the logical grouping of VMs in upgrade domains (UDs). This property can't be modified if a node
	// type with multiple Availability Zones is already present in the cluster.
	SfZonalUpgradeMode *SfZonalUpgradeMode

	// The policy to use when upgrading the cluster.
	UpgradeDescription *ClusterUpgradePolicy

	// The upgrade mode of the cluster when new Service Fabric runtime version is available.
	UpgradeMode *UpgradeMode

	// The end timestamp of pause runtime version upgrades on the cluster (UTC).
	UpgradePauseEndTimestampUTC *time.Time

	// The start timestamp to pause runtime version upgrades on the cluster (UTC).
	UpgradePauseStartTimestampUTC *time.Time

	// Indicates when new cluster runtime version upgrades will be applied after they are released. By default is Wave0. Only
	// applies when upgradeMode is set to 'Automatic'.
	UpgradeWave *ClusterUpgradeCadence

	// This property defines the upgrade mode for the virtual machine scale set, it is mandatory if a node type with multiple
	// Availability Zones is added.
	VmssZonalUpgradeMode *VmssZonalUpgradeMode

	// Boolean to pause automatic runtime version upgrades to the cluster.
	WaveUpgradePaused *bool
}

// ClusterUpdateParameters - Cluster update request
type ClusterUpdateParameters struct {
	// Describes the cluster resource properties that can be updated during PATCH operation.
	Properties *ClusterPropertiesUpdateParameters

	// Cluster update parameters
	Tags map[string]*string
}

// ClusterUpgradeDeltaHealthPolicy - Describes the delta health policies for the cluster upgrade.
type ClusterUpgradeDeltaHealthPolicy struct {
	// REQUIRED; The maximum allowed percentage of applications health degradation allowed during cluster upgrades. The delta
	// is measured between the state of the applications at the beginning of upgrade and the state
	// of the applications at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion
	// to make sure the global state of the cluster is within tolerated limits.
	// System services are not included in this.
	MaxPercentDeltaUnhealthyApplications *int32

	// REQUIRED; The maximum allowed percentage of nodes health degradation allowed during cluster upgrades. The delta is measured
	// between the state of the nodes at the beginning of upgrade and the state of the nodes
	// at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion to make sure
	// the global state of the cluster is within tolerated limits.
	MaxPercentDeltaUnhealthyNodes *int32

	// REQUIRED; The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades. The
	// delta is measured between the state of the upgrade domain nodes at the beginning of
	// upgrade and the state of the upgrade domain nodes at the time of the health evaluation. The check is performed after every
	// upgrade domain upgrade completion for all completed upgrade domains to make
	// sure the state of the upgrade domains is within tolerated limits.
	MaxPercentUpgradeDomainDeltaUnhealthyNodes *int32

	// Defines the application delta health policy map used to evaluate the health of an application or one of its child entities
	// when upgrading the cluster.
	ApplicationDeltaHealthPolicies map[string]*ApplicationDeltaHealthPolicy
}

// ClusterUpgradePolicy - Describes the policy used when upgrading the cluster.
type ClusterUpgradePolicy struct {
	// REQUIRED; The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade
	// rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	HealthCheckRetryTimeout *string

	// REQUIRED; The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next
	// upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	HealthCheckStableDuration *string

	// REQUIRED; The length of time to wait after completing an upgrade domain before performing health checks. The duration can
	// be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	HealthCheckWaitDuration *string

	// REQUIRED; The cluster health policy used when upgrading the cluster.
	HealthPolicy *ClusterHealthPolicy

	// REQUIRED; The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either
	// hh:mm:ss or in d.hh:mm:ss.ms format.
	UpgradeDomainTimeout *string

	// REQUIRED; The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there
	// are unexpected issues. When this timeout expires, processing of the upgrade domain will
	// proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can
	// be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	UpgradeReplicaSetCheckTimeout *string

	// REQUIRED; The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either
	// hh:mm:ss or in d.hh:mm:ss.ms format.
	UpgradeTimeout *string

	// The cluster delta health policy used when upgrading the cluster.
	DeltaHealthPolicy *ClusterUpgradeDeltaHealthPolicy

	// If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade
	// only changes configuration or data).
	ForceRestart *bool
}

// ClusterVersionDetails - The detail of the Service Fabric runtime version result
type ClusterVersionDetails struct {
	// The Service Fabric runtime version of the cluster.
	CodeVersion *string

	// Indicates if this version is for Windows or Linux operating system.
	Environment *ClusterEnvironment

	// The date of expiry of support of the version.
	SupportExpiryUTC *string
}

// DiagnosticsStorageAccountConfig - The storage account information for storing Service Fabric diagnostic logs.
type DiagnosticsStorageAccountConfig struct {
	// REQUIRED; The blob endpoint of the azure storage account.
	BlobEndpoint *string

	// REQUIRED; The protected diagnostics storage key name.
	ProtectedAccountKeyName *string

	// REQUIRED; The queue endpoint of the azure storage account.
	QueueEndpoint *string

	// REQUIRED; The Azure storage account name.
	StorageAccountName *string

	// REQUIRED; The table endpoint of the azure storage account.
	TableEndpoint *string

	// The secondary protected diagnostics storage key name. If one of the storage account keys is rotated the cluster will fallback
	// to using the other.
	ProtectedAccountKeyName2 *string
}

// EndpointRangeDescription - Port range details
type EndpointRangeDescription struct {
	// REQUIRED; End port of a range of ports
	EndPort *int32

	// REQUIRED; Starting port of a range of ports
	StartPort *int32
}

// ErrorModel - The structure of the error.
type ErrorModel struct {
	// The error details.
	Error *ErrorModelError
}

// ErrorModelError - The error details.
type ErrorModelError struct {
	// The error code.
	Code *string

	// The error message.
	Message *string
}

// ManagedIdentity - Describes the managed identities for an Azure resource.
type ManagedIdentity struct {
	// The type of managed identity for the resource.
	Type *ManagedIdentityType

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The principal id of the managed identity. This property will only be provided for a system assigned identity.
	PrincipalID *string

	// READ-ONLY; The tenant id of the managed identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// NamedPartitionSchemeDescription - Describes the named partition scheme of the service.
type NamedPartitionSchemeDescription struct {
	// REQUIRED; The number of partitions.
	Count *int32

	// REQUIRED; Array of size specified by the ‘count’ parameter, for the names of the partitions.
	Names []*string

	// REQUIRED; Specifies how the service is partitioned.
	PartitionScheme *PartitionScheme
}

// GetPartitionSchemeDescription implements the PartitionSchemeDescriptionClassification interface for type NamedPartitionSchemeDescription.
func (n *NamedPartitionSchemeDescription) GetPartitionSchemeDescription() *PartitionSchemeDescription {
	return &PartitionSchemeDescription{
		PartitionScheme: n.PartitionScheme,
	}
}

// NodeTypeDescription - Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
type NodeTypeDescription struct {
	// REQUIRED; The TCP cluster management endpoint port.
	ClientConnectionEndpointPort *int32

	// REQUIRED; The HTTP cluster management endpoint port.
	HTTPGatewayEndpointPort *int32

	// REQUIRED; The node type on which system services will run. Only one node type should be marked as primary. Primary node
	// type cannot be deleted or changed for existing clusters.
	IsPrimary *bool

	// REQUIRED; The name of the node type.
	Name *string

	// REQUIRED; VMInstanceCount should be 1 to n, where n indicates the number of VM instances corresponding to this nodeType.
	// VMInstanceCount = 0 can be done only in these scenarios: NodeType is a secondary
	// nodeType. Durability = Bronze or Durability >= Bronze and InfrastructureServiceManager = true. If VMInstanceCount = 0,
	// implies the VMs for this nodeType will not be used for the initial cluster size
	// computation.
	VMInstanceCount *int32

	// The range of ports from which cluster assigned port to Service Fabric applications.
	ApplicationPorts *EndpointRangeDescription

	// The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how
	// much resource a node has.
	Capacities map[string]*string

	// The durability level of the node type. Learn about DurabilityLevel [https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity].
	// * Bronze - No privileges. This is the default.
	// * Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
	// * Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold durability can be enabled only on
	// full node VM skus like D15_V2, G5 etc.
	DurabilityLevel *DurabilityLevel

	// The range of ephemeral ports that nodes in this node type should be configured with.
	EphemeralPorts *EndpointRangeDescription

	// Indicates if the node type can only host Stateless workloads.
	IsStateless *bool

	// Indicates if the node type is enabled to support multiple zones.
	MultipleAvailabilityZones *bool

	// The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should
	// run.
	PlacementProperties map[string]*string

	// The endpoint used by reverse proxy.
	ReverseProxyEndpointPort *int32
}

// Notification - Describes the notification channel for cluster events.
type Notification struct {
	// REQUIRED; Indicates if the notification is enabled.
	IsEnabled *bool

	// REQUIRED; The category of notification.
	NotificationCategory *NotificationCategory

	// REQUIRED; The level of notification.
	NotificationLevel *NotificationLevel

	// REQUIRED; List of targets that subscribe to the notification.
	NotificationTargets []*NotificationTarget
}

// NotificationTarget - Describes the notification target properties.
type NotificationTarget struct {
	// REQUIRED; The notification channel indicates the type of receivers subscribed to the notification, either user or subscription.
	NotificationChannel *NotificationChannel

	// REQUIRED; List of targets that subscribe to the notification.
	Receivers []*string
}

// OperationListResult - Describes the result of the request to list Service Fabric resource provider operations.
type OperationListResult struct {
	// List of operations supported by the Service Fabric resource provider.
	Value []*OperationResult

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string
}

// OperationResult - Available operation list result
type OperationResult struct {
	// The object that represents the operation.
	Display *AvailableOperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// The name of the operation.
	Name *string

	// The URL to use for getting the next set of results.
	NextLink *string

	// Origin result
	Origin *string
}

// PartitionSchemeDescription - Describes how the service is partitioned.
type PartitionSchemeDescription struct {
	// REQUIRED; Specifies how the service is partitioned.
	PartitionScheme *PartitionScheme
}

// GetPartitionSchemeDescription implements the PartitionSchemeDescriptionClassification interface for type PartitionSchemeDescription.
func (p *PartitionSchemeDescription) GetPartitionSchemeDescription() *PartitionSchemeDescription {
	return p
}

// ProxyResource - The resource model definition for proxy-only resource.
type ProxyResource struct {
	// It will be deprecated in New API, resource location depends on the parent resource.
	Location *string

	// Azure resource tags.
	Tags map[string]*string

	// READ-ONLY; Azure resource etag.
	Etag *string

	// READ-ONLY; Azure resource identifier.
	ID *string

	// READ-ONLY; Azure resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Azure resource type.
	Type *string
}

// Resource - The resource model definition.
type Resource struct {
	// REQUIRED; Azure resource location.
	Location *string

	// Azure resource tags.
	Tags map[string]*string

	// READ-ONLY; Azure resource etag.
	Etag *string

	// READ-ONLY; Azure resource identifier.
	ID *string

	// READ-ONLY; Azure resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Azure resource type.
	Type *string
}

// ServerCertificateCommonName - Describes the server certificate details using common name.
type ServerCertificateCommonName struct {
	// REQUIRED; The common name of the server certificate.
	CertificateCommonName *string

	// REQUIRED; The issuer thumbprint of the server certificate.
	CertificateIssuerThumbprint *string
}

// ServerCertificateCommonNames - Describes a list of server certificates referenced by common name that are used to secure
// the cluster.
type ServerCertificateCommonNames struct {
	// The list of server certificates referenced by common name that are used to secure the cluster.
	CommonNames []*ServerCertificateCommonName

	// The local certificate store location.
	X509StoreName *StoreName
}

// ServiceCorrelationDescription - Creates a particular correlation between services.
type ServiceCorrelationDescription struct {
	// REQUIRED; The ServiceCorrelationScheme which describes the relationship between this service and the service specified
	// via ServiceName.
	Scheme *ServiceCorrelationScheme

	// REQUIRED; The name of the service that the correlation relationship is established with.
	ServiceName *string
}

// ServiceLoadMetricDescription - Specifies a metric to load balance a service during runtime.
type ServiceLoadMetricDescription struct {
	// REQUIRED; The name of the metric. If the service chooses to report load during runtime, the load metric name should match
	// the name that is specified in Name exactly. Note that metric names are case sensitive.
	Name *string

	// Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
	DefaultLoad *int32

	// Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when
	// it is a Primary replica.
	PrimaryDefaultLoad *int32

	// Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when
	// it is a Secondary replica.
	SecondaryDefaultLoad *int32

	// The service load metric relative weight, compared to other metrics configured for this service, as a number.
	Weight *ServiceLoadMetricWeight
}

// ServicePlacementPolicyDescription - Describes the policy to be used for placement of a Service Fabric service.
type ServicePlacementPolicyDescription struct {
	// REQUIRED; The type of placement policy for a service fabric service. Following are the possible values.
	Type *ServicePlacementPolicyType
}

// GetServicePlacementPolicyDescription implements the ServicePlacementPolicyDescriptionClassification interface for type
// ServicePlacementPolicyDescription.
func (s *ServicePlacementPolicyDescription) GetServicePlacementPolicyDescription() *ServicePlacementPolicyDescription {
	return s
}

// ServiceResource - The service resource.
type ServiceResource struct {
	// It will be deprecated in New API, resource location depends on the parent resource.
	Location *string

	// The service resource properties.
	Properties ServiceResourcePropertiesClassification

	// Azure resource tags.
	Tags map[string]*string

	// READ-ONLY; Azure resource etag.
	Etag *string

	// READ-ONLY; Azure resource identifier.
	ID *string

	// READ-ONLY; Azure resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Azure resource type.
	Type *string
}

// ServiceResourceList - The list of service resources.
type ServiceResourceList struct {
	Value []*ServiceResource

	// READ-ONLY; URL to get the next set of service list results if there are any.
	NextLink *string
}

// ServiceResourceProperties - The service resource properties.
type ServiceResourceProperties struct {
	// REQUIRED; The kind of service (Stateless or Stateful).
	ServiceKind *ServiceKind

	// A list that describes the correlation of the service with other services.
	CorrelationScheme []*ServiceCorrelationDescription

	// Specifies the move cost for the service.
	DefaultMoveCost *MoveCost

	// Describes how the service is partitioned.
	PartitionDescription PartitionSchemeDescriptionClassification

	// The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting
	// a service to particular nodes based on the service requirements. For
	// example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string

	// Dns name used for the service. If this is specified, then the service can be accessed via its DNS name instead of service
	// name.
	ServiceDNSName *string

	// The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics []*ServiceLoadMetricDescription

	// The activation Mode of the service package
	ServicePackageActivationMode *ArmServicePackageActivationMode

	// A list that describes the correlation of the service with other services.
	ServicePlacementPolicies []ServicePlacementPolicyDescriptionClassification

	// The name of the service type
	ServiceTypeName *string

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type ServiceResourceProperties.
func (s *ServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return s
}

// ServiceResourcePropertiesBase - The common service resource properties.
type ServiceResourcePropertiesBase struct {
	// A list that describes the correlation of the service with other services.
	CorrelationScheme []*ServiceCorrelationDescription

	// Specifies the move cost for the service.
	DefaultMoveCost *MoveCost

	// The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting
	// a service to particular nodes based on the service requirements. For
	// example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string

	// The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics []*ServiceLoadMetricDescription

	// A list that describes the correlation of the service with other services.
	ServicePlacementPolicies []ServicePlacementPolicyDescriptionClassification
}

// ServiceResourceUpdate - The service resource for patch operations.
type ServiceResourceUpdate struct {
	// It will be deprecated in New API, resource location depends on the parent resource.
	Location *string

	// The service resource properties for patch operations.
	Properties ServiceResourceUpdatePropertiesClassification

	// Azure resource tags.
	Tags map[string]*string

	// READ-ONLY; Azure resource etag.
	Etag *string

	// READ-ONLY; Azure resource identifier.
	ID *string

	// READ-ONLY; Azure resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Azure resource type.
	Type *string
}

// ServiceResourceUpdateProperties - The service resource properties for patch operations.
type ServiceResourceUpdateProperties struct {
	// REQUIRED; The kind of service (Stateless or Stateful).
	ServiceKind *ServiceKind

	// A list that describes the correlation of the service with other services.
	CorrelationScheme []*ServiceCorrelationDescription

	// Specifies the move cost for the service.
	DefaultMoveCost *MoveCost

	// The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting
	// a service to particular nodes based on the service requirements. For
	// example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string

	// The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics []*ServiceLoadMetricDescription

	// A list that describes the correlation of the service with other services.
	ServicePlacementPolicies []ServicePlacementPolicyDescriptionClassification
}

// GetServiceResourceUpdateProperties implements the ServiceResourceUpdatePropertiesClassification interface for type ServiceResourceUpdateProperties.
func (s *ServiceResourceUpdateProperties) GetServiceResourceUpdateProperties() *ServiceResourceUpdateProperties {
	return s
}

// ServiceTypeDeltaHealthPolicy - Represents the delta health policy used to evaluate the health of services belonging to
// a service type when upgrading the cluster.
type ServiceTypeDeltaHealthPolicy struct {
	// The maximum allowed percentage of services health degradation allowed during cluster upgrades. The delta is measured between
	// the state of the services at the beginning of upgrade and the state of the
	// services at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion to
	// make sure the global state of the cluster is within tolerated limits.
	MaxPercentDeltaUnhealthyServices *int32
}

// ServiceTypeHealthPolicy - Represents the health policy used to evaluate the health of services belonging to a service type.
type ServiceTypeHealthPolicy struct {
	// The maximum percentage of services allowed to be unhealthy before your application is considered in error.
	MaxPercentUnhealthyServices *int32
}

// SettingsParameterDescription - Describes a parameter in fabric settings of the cluster.
type SettingsParameterDescription struct {
	// REQUIRED; The parameter name of fabric setting.
	Name *string

	// REQUIRED; The parameter value of fabric setting.
	Value *string
}

// SettingsSectionDescription - Describes a section in the fabric settings of the cluster.
type SettingsSectionDescription struct {
	// REQUIRED; The section name of the fabric settings.
	Name *string

	// REQUIRED; The collection of parameters in the section.
	Parameters []*SettingsParameterDescription
}

// SingletonPartitionSchemeDescription
type SingletonPartitionSchemeDescription struct {
	// REQUIRED; Specifies how the service is partitioned.
	PartitionScheme *PartitionScheme
}

// GetPartitionSchemeDescription implements the PartitionSchemeDescriptionClassification interface for type SingletonPartitionSchemeDescription.
func (s *SingletonPartitionSchemeDescription) GetPartitionSchemeDescription() *PartitionSchemeDescription {
	return &PartitionSchemeDescription{
		PartitionScheme: s.PartitionScheme,
	}
}

// StatefulServiceProperties - The properties of a stateful service resource.
type StatefulServiceProperties struct {
	// REQUIRED; The kind of service (Stateless or Stateful).
	ServiceKind *ServiceKind

	// A list that describes the correlation of the service with other services.
	CorrelationScheme []*ServiceCorrelationDescription

	// Specifies the move cost for the service.
	DefaultMoveCost *MoveCost

	// A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of
	// this property is true, if not it is false.
	HasPersistedState *bool

	// The minimum replica set size as a number.
	MinReplicaSetSize *int32

	// Describes how the service is partitioned.
	PartitionDescription PartitionSchemeDescriptionClassification

	// The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting
	// a service to particular nodes based on the service requirements. For
	// example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string

	// The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format (hh:mm:ss.s).
	QuorumLossWaitDuration *time.Time

	// The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format (hh:mm:ss.s).
	ReplicaRestartWaitDuration *time.Time

	// Dns name used for the service. If this is specified, then the service can be accessed via its DNS name instead of service
	// name.
	ServiceDNSName *string

	// The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics []*ServiceLoadMetricDescription

	// The activation Mode of the service package
	ServicePackageActivationMode *ArmServicePackageActivationMode

	// A list that describes the correlation of the service with other services.
	ServicePlacementPolicies []ServicePlacementPolicyDescriptionClassification

	// The name of the service type
	ServiceTypeName *string

	// The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format (hh:mm:ss.s).
	StandByReplicaKeepDuration *time.Time

	// The target replica set size as a number.
	TargetReplicaSetSize *int32

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type StatefulServiceProperties.
func (s *StatefulServiceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return &ServiceResourceProperties{
		CorrelationScheme:            s.CorrelationScheme,
		DefaultMoveCost:              s.DefaultMoveCost,
		PartitionDescription:         s.PartitionDescription,
		PlacementConstraints:         s.PlacementConstraints,
		ProvisioningState:            s.ProvisioningState,
		ServiceDNSName:               s.ServiceDNSName,
		ServiceKind:                  s.ServiceKind,
		ServiceLoadMetrics:           s.ServiceLoadMetrics,
		ServicePackageActivationMode: s.ServicePackageActivationMode,
		ServicePlacementPolicies:     s.ServicePlacementPolicies,
		ServiceTypeName:              s.ServiceTypeName,
	}
}

// StatefulServiceUpdateProperties - The properties of a stateful service resource for patch operations.
type StatefulServiceUpdateProperties struct {
	// REQUIRED; The kind of service (Stateless or Stateful).
	ServiceKind *ServiceKind

	// A list that describes the correlation of the service with other services.
	CorrelationScheme []*ServiceCorrelationDescription

	// Specifies the move cost for the service.
	DefaultMoveCost *MoveCost

	// The minimum replica set size as a number.
	MinReplicaSetSize *int32

	// The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting
	// a service to particular nodes based on the service requirements. For
	// example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string

	// The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format (hh:mm:ss.s).
	QuorumLossWaitDuration *time.Time

	// The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format (hh:mm:ss.s).
	ReplicaRestartWaitDuration *time.Time

	// The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics []*ServiceLoadMetricDescription

	// A list that describes the correlation of the service with other services.
	ServicePlacementPolicies []ServicePlacementPolicyDescriptionClassification

	// The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format (hh:mm:ss.s).
	StandByReplicaKeepDuration *time.Time

	// The target replica set size as a number.
	TargetReplicaSetSize *int32
}

// GetServiceResourceUpdateProperties implements the ServiceResourceUpdatePropertiesClassification interface for type StatefulServiceUpdateProperties.
func (s *StatefulServiceUpdateProperties) GetServiceResourceUpdateProperties() *ServiceResourceUpdateProperties {
	return &ServiceResourceUpdateProperties{
		CorrelationScheme:        s.CorrelationScheme,
		DefaultMoveCost:          s.DefaultMoveCost,
		PlacementConstraints:     s.PlacementConstraints,
		ServiceKind:              s.ServiceKind,
		ServiceLoadMetrics:       s.ServiceLoadMetrics,
		ServicePlacementPolicies: s.ServicePlacementPolicies,
	}
}

// StatelessServiceProperties - The properties of a stateless service resource.
type StatelessServiceProperties struct {
	// REQUIRED; The kind of service (Stateless or Stateful).
	ServiceKind *ServiceKind

	// A list that describes the correlation of the service with other services.
	CorrelationScheme []*ServiceCorrelationDescription

	// Specifies the move cost for the service.
	DefaultMoveCost *MoveCost

	// Delay duration for RequestDrain feature to ensures that the endpoint advertised by the stateless instance is removed before
	// the delay starts prior to closing the instance. This delay enables existing
	// requests to drain gracefully before the instance actually goes down
	// (https://docs.microsoft.com/en-us/azure/service-fabric/service-fabric-application-upgrade-advanced#avoid-connection-drops-during-stateless-service-planned-downtime-preview).
	// It is represented in ISO
	// 8601 format (hh:mm:ss.s).
	InstanceCloseDelayDuration *string

	// The instance count.
	InstanceCount *int32

	// Describes how the service is partitioned.
	PartitionDescription PartitionSchemeDescriptionClassification

	// The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting
	// a service to particular nodes based on the service requirements. For
	// example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string

	// Dns name used for the service. If this is specified, then the service can be accessed via its DNS name instead of service
	// name.
	ServiceDNSName *string

	// The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics []*ServiceLoadMetricDescription

	// The activation Mode of the service package
	ServicePackageActivationMode *ArmServicePackageActivationMode

	// A list that describes the correlation of the service with other services.
	ServicePlacementPolicies []ServicePlacementPolicyDescriptionClassification

	// The name of the service type
	ServiceTypeName *string

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type StatelessServiceProperties.
func (s *StatelessServiceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return &ServiceResourceProperties{
		CorrelationScheme:            s.CorrelationScheme,
		DefaultMoveCost:              s.DefaultMoveCost,
		PartitionDescription:         s.PartitionDescription,
		PlacementConstraints:         s.PlacementConstraints,
		ProvisioningState:            s.ProvisioningState,
		ServiceDNSName:               s.ServiceDNSName,
		ServiceKind:                  s.ServiceKind,
		ServiceLoadMetrics:           s.ServiceLoadMetrics,
		ServicePackageActivationMode: s.ServicePackageActivationMode,
		ServicePlacementPolicies:     s.ServicePlacementPolicies,
		ServiceTypeName:              s.ServiceTypeName,
	}
}

// StatelessServiceUpdateProperties - The properties of a stateless service resource for patch operations.
type StatelessServiceUpdateProperties struct {
	// REQUIRED; The kind of service (Stateless or Stateful).
	ServiceKind *ServiceKind

	// A list that describes the correlation of the service with other services.
	CorrelationScheme []*ServiceCorrelationDescription

	// Specifies the move cost for the service.
	DefaultMoveCost *MoveCost

	// Delay duration for RequestDrain feature to ensures that the endpoint advertised by the stateless instance is removed before
	// the delay starts prior to closing the instance. This delay enables existing
	// requests to drain gracefully before the instance actually goes down
	// (https://docs.microsoft.com/en-us/azure/service-fabric/service-fabric-application-upgrade-advanced#avoid-connection-drops-during-stateless-service-planned-downtime-preview).
	// It is first interpreted as
	// a string representing an ISO 8601 duration. It is represented in ISO 8601 format (hh:mm:ss.s).
	InstanceCloseDelayDuration *string

	// The instance count.
	InstanceCount *int32

	// The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting
	// a service to particular nodes based on the service requirements. For
	// example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints *string

	// The service load metrics is given as an array of ServiceLoadMetricDescription objects.
	ServiceLoadMetrics []*ServiceLoadMetricDescription

	// A list that describes the correlation of the service with other services.
	ServicePlacementPolicies []ServicePlacementPolicyDescriptionClassification
}

// GetServiceResourceUpdateProperties implements the ServiceResourceUpdatePropertiesClassification interface for type StatelessServiceUpdateProperties.
func (s *StatelessServiceUpdateProperties) GetServiceResourceUpdateProperties() *ServiceResourceUpdateProperties {
	return &ServiceResourceUpdateProperties{
		CorrelationScheme:        s.CorrelationScheme,
		DefaultMoveCost:          s.DefaultMoveCost,
		PlacementConstraints:     s.PlacementConstraints,
		ServiceKind:              s.ServiceKind,
		ServiceLoadMetrics:       s.ServiceLoadMetrics,
		ServicePlacementPolicies: s.ServicePlacementPolicies,
	}
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *string

	// The timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *string
}

// UniformInt64RangePartitionSchemeDescription - Describes a partitioning scheme where an integer range is allocated evenly
// across a number of partitions.
type UniformInt64RangePartitionSchemeDescription struct {
	// REQUIRED; The number of partitions.
	Count *int32

	// REQUIRED; String indicating the upper bound of the partition key range that should be split between the partition ‘count’
	HighKey *string

	// REQUIRED; String indicating the lower bound of the partition key range that should be split between the partition ‘count’
	LowKey *string

	// REQUIRED; Specifies how the service is partitioned.
	PartitionScheme *PartitionScheme
}

// GetPartitionSchemeDescription implements the PartitionSchemeDescriptionClassification interface for type UniformInt64RangePartitionSchemeDescription.
func (u *UniformInt64RangePartitionSchemeDescription) GetPartitionSchemeDescription() *PartitionSchemeDescription {
	return &PartitionSchemeDescription{
		PartitionScheme: u.PartitionScheme,
	}
}

// UpgradableVersionPathResult - The list of intermediate cluster code versions for an upgrade or downgrade. Or minimum and
// maximum upgradable version if no target was given
type UpgradableVersionPathResult struct {
	SupportedPath []*string
}

type UpgradableVersionsDescription struct {
	// REQUIRED; The target code version.
	TargetVersion *string
}

type UserAssignedIdentity struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}
