//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armselfhelp

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// DiscoverySolutionNLPTenantScopeClient contains the methods for the DiscoverySolutionNLPTenantScope group.
// Don't use this type directly, use NewDiscoverySolutionNLPTenantScopeClient() instead.
type DiscoverySolutionNLPTenantScopeClient struct {
	internal *arm.Client
}

// NewDiscoverySolutionNLPTenantScopeClient creates a new instance of DiscoverySolutionNLPTenantScopeClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDiscoverySolutionNLPTenantScopeClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*DiscoverySolutionNLPTenantScopeClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DiscoverySolutionNLPTenantScopeClient{
		internal: cl,
	}
	return client, nil
}

// Post - Search for relevant Azure Diagnostics, Solutions and Troubleshooters using a natural language issue summary.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01-preview
//   - options - DiscoverySolutionNLPTenantScopeClientPostOptions contains the optional parameters for the DiscoverySolutionNLPTenantScopeClient.Post
//     method.
func (client *DiscoverySolutionNLPTenantScopeClient) Post(ctx context.Context, options *DiscoverySolutionNLPTenantScopeClientPostOptions) (DiscoverySolutionNLPTenantScopeClientPostResponse, error) {
	var err error
	const operationName = "DiscoverySolutionNLPTenantScopeClient.Post"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.postCreateRequest(ctx, options)
	if err != nil {
		return DiscoverySolutionNLPTenantScopeClientPostResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DiscoverySolutionNLPTenantScopeClientPostResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DiscoverySolutionNLPTenantScopeClientPostResponse{}, err
	}
	resp, err := client.postHandleResponse(httpResp)
	return resp, err
}

// postCreateRequest creates the Post request.
func (client *DiscoverySolutionNLPTenantScopeClient) postCreateRequest(ctx context.Context, options *DiscoverySolutionNLPTenantScopeClientPostOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Help/discoverSolutions"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.DiscoverSolutionRequest != nil {
		if err := runtime.MarshalAsJSON(req, *options.DiscoverSolutionRequest); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// postHandleResponse handles the Post response.
func (client *DiscoverySolutionNLPTenantScopeClient) postHandleResponse(resp *http.Response) (DiscoverySolutionNLPTenantScopeClientPostResponse, error) {
	result := DiscoverySolutionNLPTenantScopeClientPostResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DiscoveryNlpResponse); err != nil {
		return DiscoverySolutionNLPTenantScopeClientPostResponse{}, err
	}
	return result, nil
}
