//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsScanResultsOperations/ArcMachineScanResults_Get.json
func ExampleSQLVulnerabilityAssessmentScanResultsClient_Get_getScanDetailsOfAScanRecord() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentScanResultsClient().Get(ctx, "Scheduled-20200623", "VA2063", "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScanResult = armsecurity.ScanResult{
	// 	Name: to.Ptr("VA2063"),
	// 	Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/scans/scanResults"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/Scheduled-20200623/scanResults/VA2063"),
	// 	Properties: &armsecurity.ScanResultProperties{
	// 		BaselineAdjustedResult: &armsecurity.BaselineAdjustedResult{
	// 			Baseline: &armsecurity.Baseline{
	// 				ExpectedResults: [][]*string{
	// 					[]*string{
	// 						to.Ptr("Test"),
	// 						to.Ptr("0.0.0.0"),
	// 						to.Ptr("125.125.125.125")}},
	// 						UpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T12:49:41.027Z"); return t}()),
	// 					},
	// 					ResultsNotInBaseline: [][]*string{
	// 					},
	// 					ResultsOnlyInBaseline: [][]*string{
	// 					},
	// 					Status: to.Ptr(armsecurity.RuleStatusNonFinding),
	// 				},
	// 				IsTrimmed: to.Ptr(false),
	// 				QueryResults: [][]*string{
	// 					[]*string{
	// 						to.Ptr("Test"),
	// 						to.Ptr("0.0.0.0"),
	// 						to.Ptr("125.125.125.125")}},
	// 						Remediation: &armsecurity.Remediation{
	// 							Description: to.Ptr("Remove server firewall rules that grant excessive access"),
	// 							Automated: to.Ptr(false),
	// 							PortalLink: to.Ptr("ReviewServerFirewallRules"),
	// 							Scripts: []*string{
	// 								to.Ptr("EXECUTE sp_delete_firewall_rule N'Test';")},
	// 							},
	// 							RuleID: to.Ptr("VA2063"),
	// 							RuleMetadata: &armsecurity.VaRule{
	// 								Description: to.Ptr("The Azure SQL server-level firewall helps protect your server by preventing all access to your databases until you specify which IP addresses have permission. Server-level firewall rules grant access to all databases that belong to the server based on the originating IP address of each request.\n\nServer-level firewall rules can only be created and managed through Transact-SQL as well as through the Azure portal or PowerShell. For more details please see: https://docs.microsoft.com/en-us/azure/sql-database/sql-database-firewall-configure\n\nThis check verifies that server-level firewall rules do not grant excessive access."),
	// 								BenchmarkReferences: []*armsecurity.BenchmarkReference{
	// 								},
	// 								Category: to.Ptr("SurfaceAreaReduction"),
	// 								QueryCheck: &armsecurity.QueryCheck{
	// 									ColumnNames: []*string{
	// 										to.Ptr("Firewall Rule Name"),
	// 										to.Ptr("Start Address"),
	// 										to.Ptr("End Address")},
	// 										ExpectedResult: [][]*string{
	// 										},
	// 										Query: to.Ptr("SELECT name\n    ,start_ip_address\n    ,end_ip_address\nFROM sys.firewall_rules\nWHERE ( \n        (CONVERT(bigint, parsename(end_ip_address, 1)) +\n         CONVERT(bigint, parsename(end_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(end_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(end_ip_address, 4)) * 16777216 ) \n        - \n        (CONVERT(bigint, parsename(start_ip_address, 1)) +\n         CONVERT(bigint, parsename(start_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(start_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(start_ip_address, 4)) * 16777216 )\n      ) > 255;"),
	// 									},
	// 									Rationale: to.Ptr("Often, administrators add rules that grant excessive access as part of a troubleshooting process � to eliminate the firewall as the source of a problem, they simply create a rule that allows all traffic to pass to the affected server.\n\nGranting excessive access using server firewall rules is a clear security concern, as it violates the principle of least privilege by allowing unnecessary access to your databases. In fact, it's the equivalent of placing the server outside of the firewall."),
	// 									RuleID: to.Ptr("VA2063"),
	// 									RuleType: to.Ptr(armsecurity.RuleTypeNegativeList),
	// 									Severity: to.Ptr(armsecurity.RuleSeverityHigh),
	// 									Title: to.Ptr("Server-level firewall rules should not grant excessive access"),
	// 								},
	// 								Status: to.Ptr(armsecurity.RuleStatusFinding),
	// 							},
	// 						}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsScanResultsOperations/ArcMachineScanResults_GetLatest.json
func ExampleSQLVulnerabilityAssessmentScanResultsClient_Get_getScanDetailsOfTheLatestScanRecord() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentScanResultsClient().Get(ctx, "latest", "VA2063", "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScanResult = armsecurity.ScanResult{
	// 	Name: to.Ptr("VA2063"),
	// 	Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/scans/scanResults"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/Scheduled-20200623/scanResults/VA2063"),
	// 	Properties: &armsecurity.ScanResultProperties{
	// 		BaselineAdjustedResult: &armsecurity.BaselineAdjustedResult{
	// 			Baseline: &armsecurity.Baseline{
	// 				ExpectedResults: [][]*string{
	// 					[]*string{
	// 						to.Ptr("Test"),
	// 						to.Ptr("0.0.0.0"),
	// 						to.Ptr("125.125.125.125")}},
	// 						UpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T12:49:41.027Z"); return t}()),
	// 					},
	// 					ResultsNotInBaseline: [][]*string{
	// 					},
	// 					ResultsOnlyInBaseline: [][]*string{
	// 					},
	// 					Status: to.Ptr(armsecurity.RuleStatusNonFinding),
	// 				},
	// 				IsTrimmed: to.Ptr(false),
	// 				QueryResults: [][]*string{
	// 					[]*string{
	// 						to.Ptr("Test"),
	// 						to.Ptr("0.0.0.0"),
	// 						to.Ptr("125.125.125.125")}},
	// 						Remediation: &armsecurity.Remediation{
	// 							Description: to.Ptr("Remove server firewall rules that grant excessive access"),
	// 							Automated: to.Ptr(false),
	// 							PortalLink: to.Ptr("ReviewServerFirewallRules"),
	// 							Scripts: []*string{
	// 								to.Ptr("EXECUTE sp_delete_firewall_rule N'Test';")},
	// 							},
	// 							RuleID: to.Ptr("VA2063"),
	// 							RuleMetadata: &armsecurity.VaRule{
	// 								Description: to.Ptr("The Azure SQL server-level firewall helps protect your server by preventing all access to your databases until you specify which IP addresses have permission. Server-level firewall rules grant access to all databases that belong to the server based on the originating IP address of each request.\n\nServer-level firewall rules can only be created and managed through Transact-SQL as well as through the Azure portal or PowerShell. For more details please see: https://docs.microsoft.com/en-us/azure/sql-database/sql-database-firewall-configure\n\nThis check verifies that server-level firewall rules do not grant excessive access."),
	// 								BenchmarkReferences: []*armsecurity.BenchmarkReference{
	// 								},
	// 								Category: to.Ptr("SurfaceAreaReduction"),
	// 								QueryCheck: &armsecurity.QueryCheck{
	// 									ColumnNames: []*string{
	// 										to.Ptr("Firewall Rule Name"),
	// 										to.Ptr("Start Address"),
	// 										to.Ptr("End Address")},
	// 										ExpectedResult: [][]*string{
	// 										},
	// 										Query: to.Ptr("SELECT name\n    ,start_ip_address\n    ,end_ip_address\nFROM sys.firewall_rules\nWHERE ( \n        (CONVERT(bigint, parsename(end_ip_address, 1)) +\n         CONVERT(bigint, parsename(end_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(end_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(end_ip_address, 4)) * 16777216 ) \n        - \n        (CONVERT(bigint, parsename(start_ip_address, 1)) +\n         CONVERT(bigint, parsename(start_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(start_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(start_ip_address, 4)) * 16777216 )\n      ) > 255;"),
	// 									},
	// 									Rationale: to.Ptr("Often, administrators add rules that grant excessive access as part of a troubleshooting process � to eliminate the firewall as the source of a problem, they simply create a rule that allows all traffic to pass to the affected server.\n\nGranting excessive access using server firewall rules is a clear security concern, as it violates the principle of least privilege by allowing unnecessary access to your databases. In fact, it's the equivalent of placing the server outside of the firewall."),
	// 									RuleID: to.Ptr("VA2063"),
	// 									RuleType: to.Ptr(armsecurity.RuleTypeNegativeList),
	// 									Severity: to.Ptr(armsecurity.RuleSeverityHigh),
	// 									Title: to.Ptr("Server-level firewall rules should not grant excessive access"),
	// 								},
	// 								Status: to.Ptr(armsecurity.RuleStatusFinding),
	// 							},
	// 						}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsScanResultsOperations/ArcMachineScanResults_List.json
func ExampleSQLVulnerabilityAssessmentScanResultsClient_List_listScanResults() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentScanResultsClient().List(ctx, "Scheduled-20200623", "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScanResults = armsecurity.ScanResults{
	// 	Value: []*armsecurity.ScanResult{
	// 		{
	// 			Name: to.Ptr("VA2062"),
	// 			Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/scans/scanResults"),
	// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/Scheduled-20200623/scanResults/VA2062"),
	// 			Properties: &armsecurity.ScanResultProperties{
	// 				IsTrimmed: to.Ptr(false),
	// 				QueryResults: [][]*string{
	// 				},
	// 				Remediation: &armsecurity.Remediation{
	// 					Description: to.Ptr("Remove database firewall rules that grant excessive access"),
	// 					Automated: to.Ptr(false),
	// 					PortalLink: to.Ptr(""),
	// 					Scripts: []*string{
	// 					},
	// 				},
	// 				RuleID: to.Ptr("VA2062"),
	// 				RuleMetadata: &armsecurity.VaRule{
	// 					Description: to.Ptr("The Azure SQL Database-level firewall helps protect your data by preventing all access to your database until you specify which IP addresses have permission. Database-level firewall rules grant access to the specific database based on the originating IP address of each request.\n\nDatabase-level firewall rules for master and user databases can only be created and managed through Transact-SQL (unlike server-level firewall rules which can also be created and managed using the Azure portal or PowerShell). For more details please see: https://docs.microsoft.com/en-us/azure/sql-database/sql-database-firewall-configure\n\nThis check verifies that database-level firewall rules do not grant excessive access."),
	// 					BenchmarkReferences: []*armsecurity.BenchmarkReference{
	// 					},
	// 					Category: to.Ptr("SurfaceAreaReduction"),
	// 					QueryCheck: &armsecurity.QueryCheck{
	// 						ColumnNames: []*string{
	// 							to.Ptr("Firewall Rule Name"),
	// 							to.Ptr("Start Address"),
	// 							to.Ptr("End Address")},
	// 							ExpectedResult: [][]*string{
	// 							},
	// 							Query: to.Ptr("SELECT name\n    ,start_ip_address\n    ,end_ip_address\nFROM sys.database_firewall_rules\nWHERE ( \n        (CONVERT(bigint, parsename(end_ip_address, 1)) +\n         CONVERT(bigint, parsename(end_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(end_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(end_ip_address, 4)) * 16777216 ) \n        - \n        (CONVERT(bigint, parsename(start_ip_address, 1)) +\n         CONVERT(bigint, parsename(start_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(start_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(start_ip_address, 4)) * 16777216 )\n      ) > 255;"),
	// 						},
	// 						Rationale: to.Ptr("Often, administrators add rules that grant excessive access as part of a troubleshooting process - to eliminate the firewall as the source of a problem, they simply create a rule that allows all traffic to pass to the affected database.\n\nGranting excessive access using database firewall rules is a clear security concern, as it violates the principle of least privilege by allowing unnecessary access to your database. In fact, it's the equivalent of placing the database outside of the firewall."),
	// 						RuleID: to.Ptr("VA2062"),
	// 						RuleType: to.Ptr(armsecurity.RuleTypeNegativeList),
	// 						Severity: to.Ptr(armsecurity.RuleSeverityHigh),
	// 						Title: to.Ptr("Database-level firewall rules should not grant excessive access"),
	// 					},
	// 					Status: to.Ptr(armsecurity.RuleStatusNonFinding),
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("VA2063"),
	// 				Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/scans/scanResults"),
	// 				ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/Scheduled-20200623/scanResults/VA2063"),
	// 				Properties: &armsecurity.ScanResultProperties{
	// 					BaselineAdjustedResult: &armsecurity.BaselineAdjustedResult{
	// 						Baseline: &armsecurity.Baseline{
	// 							ExpectedResults: [][]*string{
	// 								[]*string{
	// 									to.Ptr("Test"),
	// 									to.Ptr("0.0.0.0"),
	// 									to.Ptr("125.125.125.125")}},
	// 									UpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T12:49:41.027Z"); return t}()),
	// 								},
	// 								ResultsNotInBaseline: [][]*string{
	// 								},
	// 								ResultsOnlyInBaseline: [][]*string{
	// 								},
	// 								Status: to.Ptr(armsecurity.RuleStatusNonFinding),
	// 							},
	// 							IsTrimmed: to.Ptr(false),
	// 							QueryResults: [][]*string{
	// 								[]*string{
	// 									to.Ptr("Test"),
	// 									to.Ptr("0.0.0.0"),
	// 									to.Ptr("125.125.125.125")}},
	// 									Remediation: &armsecurity.Remediation{
	// 										Description: to.Ptr("Remove server firewall rules that grant excessive access"),
	// 										Automated: to.Ptr(false),
	// 										PortalLink: to.Ptr("ReviewServerFirewallRules"),
	// 										Scripts: []*string{
	// 											to.Ptr("EXECUTE sp_delete_firewall_rule N'Test';")},
	// 										},
	// 										RuleID: to.Ptr("VA2063"),
	// 										RuleMetadata: &armsecurity.VaRule{
	// 											Description: to.Ptr("The Azure SQL server-level firewall helps protect your server by preventing all access to your databases until you specify which IP addresses have permission. Server-level firewall rules grant access to all databases that belong to the server based on the originating IP address of each request.\n\nServer-level firewall rules can only be created and managed through Transact-SQL as well as through the Azure portal or PowerShell. For more details please see: https://docs.microsoft.com/en-us/azure/sql-database/sql-database-firewall-configure\n\nThis check verifies that server-level firewall rules do not grant excessive access."),
	// 											BenchmarkReferences: []*armsecurity.BenchmarkReference{
	// 											},
	// 											Category: to.Ptr("SurfaceAreaReduction"),
	// 											QueryCheck: &armsecurity.QueryCheck{
	// 												ColumnNames: []*string{
	// 													to.Ptr("Firewall Rule Name"),
	// 													to.Ptr("Start Address"),
	// 													to.Ptr("End Address")},
	// 													ExpectedResult: [][]*string{
	// 													},
	// 													Query: to.Ptr("SELECT name\n    ,start_ip_address\n    ,end_ip_address\nFROM sys.firewall_rules\nWHERE ( \n        (CONVERT(bigint, parsename(end_ip_address, 1)) +\n         CONVERT(bigint, parsename(end_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(end_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(end_ip_address, 4)) * 16777216 ) \n        - \n        (CONVERT(bigint, parsename(start_ip_address, 1)) +\n         CONVERT(bigint, parsename(start_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(start_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(start_ip_address, 4)) * 16777216 )\n      ) > 255;"),
	// 												},
	// 												Rationale: to.Ptr("Often, administrators add rules that grant excessive access as part of a troubleshooting process � to eliminate the firewall as the source of a problem, they simply create a rule that allows all traffic to pass to the affected server.\n\nGranting excessive access using server firewall rules is a clear security concern, as it violates the principle of least privilege by allowing unnecessary access to your databases. In fact, it's the equivalent of placing the server outside of the firewall."),
	// 												RuleID: to.Ptr("VA2063"),
	// 												RuleType: to.Ptr(armsecurity.RuleTypeNegativeList),
	// 												Severity: to.Ptr(armsecurity.RuleSeverityHigh),
	// 												Title: to.Ptr("Server-level firewall rules should not grant excessive access"),
	// 											},
	// 											Status: to.Ptr(armsecurity.RuleStatusFinding),
	// 										},
	// 								}},
	// 							}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsScanResultsOperations/ArcMachineScanResults_ListLatest.json
func ExampleSQLVulnerabilityAssessmentScanResultsClient_List_listScanResultsOfTheLatestScan() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentScanResultsClient().List(ctx, "latest", "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScanResults = armsecurity.ScanResults{
	// 	Value: []*armsecurity.ScanResult{
	// 		{
	// 			Name: to.Ptr("VA2062"),
	// 			Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/scans/scanResults"),
	// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/Scheduled-20200623/scanResults/VA2062"),
	// 			Properties: &armsecurity.ScanResultProperties{
	// 				IsTrimmed: to.Ptr(false),
	// 				QueryResults: [][]*string{
	// 				},
	// 				Remediation: &armsecurity.Remediation{
	// 					Description: to.Ptr("Remove database firewall rules that grant excessive access"),
	// 					Automated: to.Ptr(false),
	// 					PortalLink: to.Ptr(""),
	// 					Scripts: []*string{
	// 					},
	// 				},
	// 				RuleID: to.Ptr("VA2062"),
	// 				RuleMetadata: &armsecurity.VaRule{
	// 					Description: to.Ptr("The Azure SQL Database-level firewall helps protect your data by preventing all access to your database until you specify which IP addresses have permission. Database-level firewall rules grant access to the specific database based on the originating IP address of each request.\n\nDatabase-level firewall rules for master and user databases can only be created and managed through Transact-SQL (unlike server-level firewall rules which can also be created and managed using the Azure portal or PowerShell). For more details please see: https://docs.microsoft.com/en-us/azure/sql-database/sql-database-firewall-configure\n\nThis check verifies that database-level firewall rules do not grant excessive access."),
	// 					BenchmarkReferences: []*armsecurity.BenchmarkReference{
	// 					},
	// 					Category: to.Ptr("SurfaceAreaReduction"),
	// 					QueryCheck: &armsecurity.QueryCheck{
	// 						ColumnNames: []*string{
	// 							to.Ptr("Firewall Rule Name"),
	// 							to.Ptr("Start Address"),
	// 							to.Ptr("End Address")},
	// 							ExpectedResult: [][]*string{
	// 							},
	// 							Query: to.Ptr("SELECT name\n    ,start_ip_address\n    ,end_ip_address\nFROM sys.database_firewall_rules\nWHERE ( \n        (CONVERT(bigint, parsename(end_ip_address, 1)) +\n         CONVERT(bigint, parsename(end_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(end_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(end_ip_address, 4)) * 16777216 ) \n        - \n        (CONVERT(bigint, parsename(start_ip_address, 1)) +\n         CONVERT(bigint, parsename(start_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(start_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(start_ip_address, 4)) * 16777216 )\n      ) > 255;"),
	// 						},
	// 						Rationale: to.Ptr("Often, administrators add rules that grant excessive access as part of a troubleshooting process - to eliminate the firewall as the source of a problem, they simply create a rule that allows all traffic to pass to the affected database.\n\nGranting excessive access using database firewall rules is a clear security concern, as it violates the principle of least privilege by allowing unnecessary access to your database. In fact, it's the equivalent of placing the database outside of the firewall."),
	// 						RuleID: to.Ptr("VA2062"),
	// 						RuleType: to.Ptr(armsecurity.RuleTypeNegativeList),
	// 						Severity: to.Ptr(armsecurity.RuleSeverityHigh),
	// 						Title: to.Ptr("Database-level firewall rules should not grant excessive access"),
	// 					},
	// 					Status: to.Ptr(armsecurity.RuleStatusNonFinding),
	// 				},
	// 			},
	// 			{
	// 				Name: to.Ptr("VA2063"),
	// 				Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/scans/scanResults"),
	// 				ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/Scheduled-20200623/scanResults/VA2063"),
	// 				Properties: &armsecurity.ScanResultProperties{
	// 					BaselineAdjustedResult: &armsecurity.BaselineAdjustedResult{
	// 						Baseline: &armsecurity.Baseline{
	// 							ExpectedResults: [][]*string{
	// 								[]*string{
	// 									to.Ptr("Test"),
	// 									to.Ptr("0.0.0.0"),
	// 									to.Ptr("125.125.125.125")}},
	// 									UpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-04T12:49:41.027Z"); return t}()),
	// 								},
	// 								ResultsNotInBaseline: [][]*string{
	// 								},
	// 								ResultsOnlyInBaseline: [][]*string{
	// 								},
	// 								Status: to.Ptr(armsecurity.RuleStatusNonFinding),
	// 							},
	// 							IsTrimmed: to.Ptr(false),
	// 							QueryResults: [][]*string{
	// 								[]*string{
	// 									to.Ptr("Test"),
	// 									to.Ptr("0.0.0.0"),
	// 									to.Ptr("125.125.125.125")}},
	// 									Remediation: &armsecurity.Remediation{
	// 										Description: to.Ptr("Remove server firewall rules that grant excessive access"),
	// 										Automated: to.Ptr(false),
	// 										PortalLink: to.Ptr("ReviewServerFirewallRules"),
	// 										Scripts: []*string{
	// 											to.Ptr("EXECUTE sp_delete_firewall_rule N'Test';")},
	// 										},
	// 										RuleID: to.Ptr("VA2063"),
	// 										RuleMetadata: &armsecurity.VaRule{
	// 											Description: to.Ptr("The Azure SQL server-level firewall helps protect your server by preventing all access to your databases until you specify which IP addresses have permission. Server-level firewall rules grant access to all databases that belong to the server based on the originating IP address of each request.\n\nServer-level firewall rules can only be created and managed through Transact-SQL as well as through the Azure portal or PowerShell. For more details please see: https://docs.microsoft.com/en-us/azure/sql-database/sql-database-firewall-configure\n\nThis check verifies that server-level firewall rules do not grant excessive access."),
	// 											BenchmarkReferences: []*armsecurity.BenchmarkReference{
	// 											},
	// 											Category: to.Ptr("SurfaceAreaReduction"),
	// 											QueryCheck: &armsecurity.QueryCheck{
	// 												ColumnNames: []*string{
	// 													to.Ptr("Firewall Rule Name"),
	// 													to.Ptr("Start Address"),
	// 													to.Ptr("End Address")},
	// 													ExpectedResult: [][]*string{
	// 													},
	// 													Query: to.Ptr("SELECT name\n    ,start_ip_address\n    ,end_ip_address\nFROM sys.firewall_rules\nWHERE ( \n        (CONVERT(bigint, parsename(end_ip_address, 1)) +\n         CONVERT(bigint, parsename(end_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(end_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(end_ip_address, 4)) * 16777216 ) \n        - \n        (CONVERT(bigint, parsename(start_ip_address, 1)) +\n         CONVERT(bigint, parsename(start_ip_address, 2)) * 256 + \n         CONVERT(bigint, parsename(start_ip_address, 3)) * 65536 + \n         CONVERT(bigint, parsename(start_ip_address, 4)) * 16777216 )\n      ) > 255;"),
	// 												},
	// 												Rationale: to.Ptr("Often, administrators add rules that grant excessive access as part of a troubleshooting process � to eliminate the firewall as the source of a problem, they simply create a rule that allows all traffic to pass to the affected server.\n\nGranting excessive access using server firewall rules is a clear security concern, as it violates the principle of least privilege by allowing unnecessary access to your databases. In fact, it's the equivalent of placing the server outside of the firewall."),
	// 												RuleID: to.Ptr("VA2063"),
	// 												RuleType: to.Ptr(armsecurity.RuleTypeNegativeList),
	// 												Severity: to.Ptr(armsecurity.RuleSeverityHigh),
	// 												Title: to.Ptr("Server-level firewall rules should not grant excessive access"),
	// 											},
	// 											Status: to.Ptr(armsecurity.RuleStatusFinding),
	// 										},
	// 								}},
	// 							}
}
