//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/ListServerVulnerabilityAssessmentsSettings_example.json
func ExampleServerVulnerabilityAssessmentsSettingsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServerVulnerabilityAssessmentsSettingsClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServerVulnerabilityAssessmentsSettingsList = armsecurity.ServerVulnerabilityAssessmentsSettingsList{
		// 	Value: []armsecurity.ServerVulnerabilityAssessmentsSettingClassification{
		// 		&armsecurity.AzureServersSetting{
		// 			Name: to.Ptr("azureServersSetting"),
		// 			Type: to.Ptr("Microsoft.Security/serverVulnerabilityAssessmentsSettings"),
		// 			ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/azureServersSetting"),
		// 			SystemData: &armsecurity.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-05-12T13:47:50.328Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@contoso.com"),
		// 				CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-05-12T13:47:50.328Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@contoso.com"),
		// 				LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
		// 			},
		// 			Kind: to.Ptr(armsecurity.ServerVulnerabilityAssessmentsSettingKindAzureServersSetting),
		// 			Properties: &armsecurity.ServerVulnerabilityAssessmentsAzureSettingProperties{
		// 				SelectedProvider: to.Ptr(armsecurity.ServerVulnerabilityAssessmentsAzureSettingSelectedProviderMdeTvm),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/GetServerVulnerabilityAssessmentsSetting_example.json
func ExampleServerVulnerabilityAssessmentsSettingsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServerVulnerabilityAssessmentsSettingsClient().Get(ctx, armsecurity.ServerVulnerabilityAssessmentsSettingKindNameAzureServersSetting, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armsecurity.ServerVulnerabilityAssessmentsSettingsClientGetResponse{
	// 	                            ServerVulnerabilityAssessmentsSettingClassification: &armsecurity.AzureServersSetting{
	// 		Name: to.Ptr("azureServersSetting"),
	// 		Type: to.Ptr("Microsoft.Security/serverVulnerabilityAssessmentsSettings"),
	// 		ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/azureServersSetting"),
	// 		SystemData: &armsecurity.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-05-12T13:47:50.328Z"); return t}()),
	// 			CreatedBy: to.Ptr("user@contoso.com"),
	// 			CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-05-12T13:47:50.328Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("user@contoso.com"),
	// 			LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
	// 		},
	// 		Kind: to.Ptr(armsecurity.ServerVulnerabilityAssessmentsSettingKindAzureServersSetting),
	// 		Properties: &armsecurity.ServerVulnerabilityAssessmentsAzureSettingProperties{
	// 			SelectedProvider: to.Ptr(armsecurity.ServerVulnerabilityAssessmentsAzureSettingSelectedProviderMdeTvm),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/PutServerVulnerabilityAssessmentsSetting_example.json
func ExampleServerVulnerabilityAssessmentsSettingsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServerVulnerabilityAssessmentsSettingsClient().CreateOrUpdate(ctx, armsecurity.ServerVulnerabilityAssessmentsSettingKindNameAzureServersSetting, &armsecurity.AzureServersSetting{
		Kind: to.Ptr(armsecurity.ServerVulnerabilityAssessmentsSettingKindAzureServersSetting),
		Properties: &armsecurity.ServerVulnerabilityAssessmentsAzureSettingProperties{
			SelectedProvider: to.Ptr(armsecurity.ServerVulnerabilityAssessmentsAzureSettingSelectedProviderMdeTvm),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armsecurity.ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse{
	// 	                            ServerVulnerabilityAssessmentsSettingClassification: &armsecurity.AzureServersSetting{
	// 		Name: to.Ptr("azureServersSetting"),
	// 		Type: to.Ptr("Microsoft.Security/serverVulnerabilityAssessmentsSettings"),
	// 		ID: to.Ptr("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/azureServersSetting"),
	// 		SystemData: &armsecurity.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-12T13:47:50.328Z"); return t}()),
	// 			CreatedBy: to.Ptr("user@contoso.com"),
	// 			CreatedByType: to.Ptr(armsecurity.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-01-12T13:47:50.328Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("user@contoso.com"),
	// 			LastModifiedByType: to.Ptr(armsecurity.CreatedByTypeUser),
	// 		},
	// 		Kind: to.Ptr(armsecurity.ServerVulnerabilityAssessmentsSettingKindAzureServersSetting),
	// 		Properties: &armsecurity.ServerVulnerabilityAssessmentsAzureSettingProperties{
	// 			SelectedProvider: to.Ptr(armsecurity.ServerVulnerabilityAssessmentsAzureSettingSelectedProviderMdeTvm),
	// 		},
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2023-05-01/examples/ServerVulnerabilityAssessmentsSettings/DeleteServerVulnerabilityAssessmentsSetting_example.json
func ExampleServerVulnerabilityAssessmentsSettingsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewServerVulnerabilityAssessmentsSettingsClient().Delete(ctx, armsecurity.ServerVulnerabilityAssessmentsSettingKindNameAzureServersSetting, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
