//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

// APICollectionsClientGetByAzureAPIManagementServiceResponse contains the response from method APICollectionsClient.GetByAzureAPIManagementService.
type APICollectionsClientGetByAzureAPIManagementServiceResponse struct {
	// An API collection as represented by Microsoft Defender for APIs.
	APICollection
}

// APICollectionsClientListByAzureAPIManagementServiceResponse contains the response from method APICollectionsClient.NewListByAzureAPIManagementServicePager.
type APICollectionsClientListByAzureAPIManagementServiceResponse struct {
	// Page of a list of API collections as represented by Microsoft Defender for APIs.
	APICollectionList
}

// APICollectionsClientListByResourceGroupResponse contains the response from method APICollectionsClient.NewListByResourceGroupPager.
type APICollectionsClientListByResourceGroupResponse struct {
	// Page of a list of API collections as represented by Microsoft Defender for APIs.
	APICollectionList
}

// APICollectionsClientListBySubscriptionResponse contains the response from method APICollectionsClient.NewListBySubscriptionPager.
type APICollectionsClientListBySubscriptionResponse struct {
	// Page of a list of API collections as represented by Microsoft Defender for APIs.
	APICollectionList
}

// APICollectionsClientOffboardAzureAPIManagementAPIResponse contains the response from method APICollectionsClient.OffboardAzureAPIManagementAPI.
type APICollectionsClientOffboardAzureAPIManagementAPIResponse struct {
	// placeholder for future response values
}

// APICollectionsClientOnboardAzureAPIManagementAPIResponse contains the response from method APICollectionsClient.BeginOnboardAzureAPIManagementAPI.
type APICollectionsClientOnboardAzureAPIManagementAPIResponse struct {
	// An API collection as represented by Microsoft Defender for APIs.
	APICollection
}

// AccountConnectorsClientCreateOrUpdateResponse contains the response from method AccountConnectorsClient.CreateOrUpdate.
type AccountConnectorsClientCreateOrUpdateResponse struct {
	// The connector setting
	ConnectorSetting
}

// AccountConnectorsClientDeleteResponse contains the response from method AccountConnectorsClient.Delete.
type AccountConnectorsClientDeleteResponse struct {
	// placeholder for future response values
}

// AccountConnectorsClientGetResponse contains the response from method AccountConnectorsClient.Get.
type AccountConnectorsClientGetResponse struct {
	// The connector setting
	ConnectorSetting
}

// AccountConnectorsClientListResponse contains the response from method AccountConnectorsClient.NewListPager.
type AccountConnectorsClientListResponse struct {
	// For a subscription, list of all cloud account connectors and their settings
	ConnectorSettingList
}

// AdaptiveApplicationControlsClientDeleteResponse contains the response from method AdaptiveApplicationControlsClient.Delete.
type AdaptiveApplicationControlsClientDeleteResponse struct {
	// placeholder for future response values
}

// AdaptiveApplicationControlsClientGetResponse contains the response from method AdaptiveApplicationControlsClient.Get.
type AdaptiveApplicationControlsClientGetResponse struct {
	AdaptiveApplicationControlGroup
}

// AdaptiveApplicationControlsClientListResponse contains the response from method AdaptiveApplicationControlsClient.List.
type AdaptiveApplicationControlsClientListResponse struct {
	// Represents a list of VM/server groups and set of rules that are Recommended by Microsoft Defender for Cloud to be allowed
	AdaptiveApplicationControlGroups
}

// AdaptiveApplicationControlsClientPutResponse contains the response from method AdaptiveApplicationControlsClient.Put.
type AdaptiveApplicationControlsClientPutResponse struct {
	AdaptiveApplicationControlGroup
}

// AdaptiveNetworkHardeningsClientEnforceResponse contains the response from method AdaptiveNetworkHardeningsClient.BeginEnforce.
type AdaptiveNetworkHardeningsClientEnforceResponse struct {
	// placeholder for future response values
}

// AdaptiveNetworkHardeningsClientGetResponse contains the response from method AdaptiveNetworkHardeningsClient.Get.
type AdaptiveNetworkHardeningsClientGetResponse struct {
	// The resource whose properties describes the Adaptive Network Hardening settings for some Azure resource
	AdaptiveNetworkHardening
}

// AdaptiveNetworkHardeningsClientListByExtendedResourceResponse contains the response from method AdaptiveNetworkHardeningsClient.NewListByExtendedResourcePager.
type AdaptiveNetworkHardeningsClientListByExtendedResourceResponse struct {
	// Response for ListAdaptiveNetworkHardenings API service call
	AdaptiveNetworkHardeningsList
}

// AdvancedThreatProtectionClientCreateResponse contains the response from method AdvancedThreatProtectionClient.Create.
type AdvancedThreatProtectionClientCreateResponse struct {
	// The Advanced Threat Protection resource.
	AdvancedThreatProtectionSetting
}

// AdvancedThreatProtectionClientGetResponse contains the response from method AdvancedThreatProtectionClient.Get.
type AdvancedThreatProtectionClientGetResponse struct {
	// The Advanced Threat Protection resource.
	AdvancedThreatProtectionSetting
}

// AlertsClientGetResourceGroupLevelResponse contains the response from method AlertsClient.GetResourceGroupLevel.
type AlertsClientGetResourceGroupLevelResponse struct {
	// Security alert
	Alert
}

// AlertsClientGetSubscriptionLevelResponse contains the response from method AlertsClient.GetSubscriptionLevel.
type AlertsClientGetSubscriptionLevelResponse struct {
	// Security alert
	Alert
}

// AlertsClientListByResourceGroupResponse contains the response from method AlertsClient.NewListByResourceGroupPager.
type AlertsClientListByResourceGroupResponse struct {
	// List of security alerts
	AlertList
}

// AlertsClientListResourceGroupLevelByRegionResponse contains the response from method AlertsClient.NewListResourceGroupLevelByRegionPager.
type AlertsClientListResourceGroupLevelByRegionResponse struct {
	// List of security alerts
	AlertList
}

// AlertsClientListResponse contains the response from method AlertsClient.NewListPager.
type AlertsClientListResponse struct {
	// List of security alerts
	AlertList
}

// AlertsClientListSubscriptionLevelByRegionResponse contains the response from method AlertsClient.NewListSubscriptionLevelByRegionPager.
type AlertsClientListSubscriptionLevelByRegionResponse struct {
	// List of security alerts
	AlertList
}

// AlertsClientSimulateResponse contains the response from method AlertsClient.BeginSimulate.
type AlertsClientSimulateResponse struct {
	// placeholder for future response values
}

// AlertsClientUpdateResourceGroupLevelStateToActivateResponse contains the response from method AlertsClient.UpdateResourceGroupLevelStateToActivate.
type AlertsClientUpdateResourceGroupLevelStateToActivateResponse struct {
	// placeholder for future response values
}

// AlertsClientUpdateResourceGroupLevelStateToDismissResponse contains the response from method AlertsClient.UpdateResourceGroupLevelStateToDismiss.
type AlertsClientUpdateResourceGroupLevelStateToDismissResponse struct {
	// placeholder for future response values
}

// AlertsClientUpdateResourceGroupLevelStateToInProgressResponse contains the response from method AlertsClient.UpdateResourceGroupLevelStateToInProgress.
type AlertsClientUpdateResourceGroupLevelStateToInProgressResponse struct {
	// placeholder for future response values
}

// AlertsClientUpdateResourceGroupLevelStateToResolveResponse contains the response from method AlertsClient.UpdateResourceGroupLevelStateToResolve.
type AlertsClientUpdateResourceGroupLevelStateToResolveResponse struct {
	// placeholder for future response values
}

// AlertsClientUpdateSubscriptionLevelStateToActivateResponse contains the response from method AlertsClient.UpdateSubscriptionLevelStateToActivate.
type AlertsClientUpdateSubscriptionLevelStateToActivateResponse struct {
	// placeholder for future response values
}

// AlertsClientUpdateSubscriptionLevelStateToDismissResponse contains the response from method AlertsClient.UpdateSubscriptionLevelStateToDismiss.
type AlertsClientUpdateSubscriptionLevelStateToDismissResponse struct {
	// placeholder for future response values
}

// AlertsClientUpdateSubscriptionLevelStateToInProgressResponse contains the response from method AlertsClient.UpdateSubscriptionLevelStateToInProgress.
type AlertsClientUpdateSubscriptionLevelStateToInProgressResponse struct {
	// placeholder for future response values
}

// AlertsClientUpdateSubscriptionLevelStateToResolveResponse contains the response from method AlertsClient.UpdateSubscriptionLevelStateToResolve.
type AlertsClientUpdateSubscriptionLevelStateToResolveResponse struct {
	// placeholder for future response values
}

// AlertsSuppressionRulesClientDeleteResponse contains the response from method AlertsSuppressionRulesClient.Delete.
type AlertsSuppressionRulesClientDeleteResponse struct {
	// placeholder for future response values
}

// AlertsSuppressionRulesClientGetResponse contains the response from method AlertsSuppressionRulesClient.Get.
type AlertsSuppressionRulesClientGetResponse struct {
	// Describes the suppression rule
	AlertsSuppressionRule
}

// AlertsSuppressionRulesClientListResponse contains the response from method AlertsSuppressionRulesClient.NewListPager.
type AlertsSuppressionRulesClientListResponse struct {
	// Suppression rules list for subscription.
	AlertsSuppressionRulesList
}

// AlertsSuppressionRulesClientUpdateResponse contains the response from method AlertsSuppressionRulesClient.Update.
type AlertsSuppressionRulesClientUpdateResponse struct {
	// Describes the suppression rule
	AlertsSuppressionRule
}

// AllowedConnectionsClientGetResponse contains the response from method AllowedConnectionsClient.Get.
type AllowedConnectionsClientGetResponse struct {
	// The resource whose properties describes the allowed traffic between Azure resources
	AllowedConnectionsResource
}

// AllowedConnectionsClientListByHomeRegionResponse contains the response from method AllowedConnectionsClient.NewListByHomeRegionPager.
type AllowedConnectionsClientListByHomeRegionResponse struct {
	// List of all possible traffic between Azure resources
	AllowedConnectionsList
}

// AllowedConnectionsClientListResponse contains the response from method AllowedConnectionsClient.NewListPager.
type AllowedConnectionsClientListResponse struct {
	// List of all possible traffic between Azure resources
	AllowedConnectionsList
}

// ApplicationClientCreateOrUpdateResponse contains the response from method ApplicationClient.CreateOrUpdate.
type ApplicationClientCreateOrUpdateResponse struct {
	// Security Application over a given scope
	Application
}

// ApplicationClientDeleteResponse contains the response from method ApplicationClient.Delete.
type ApplicationClientDeleteResponse struct {
	// placeholder for future response values
}

// ApplicationClientGetResponse contains the response from method ApplicationClient.Get.
type ApplicationClientGetResponse struct {
	// Security Application over a given scope
	Application
}

// ApplicationsClientListResponse contains the response from method ApplicationsClient.NewListPager.
type ApplicationsClientListResponse struct {
	// Page of a security applications list
	ApplicationsList
}

// AssessmentsClientCreateOrUpdateResponse contains the response from method AssessmentsClient.CreateOrUpdate.
type AssessmentsClientCreateOrUpdateResponse struct {
	// Security assessment on a resource - response format
	AssessmentResponse
}

// AssessmentsClientDeleteResponse contains the response from method AssessmentsClient.Delete.
type AssessmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// AssessmentsClientGetResponse contains the response from method AssessmentsClient.Get.
type AssessmentsClientGetResponse struct {
	// Security assessment on a resource - response format
	AssessmentResponse
}

// AssessmentsClientListResponse contains the response from method AssessmentsClient.NewListPager.
type AssessmentsClientListResponse struct {
	// Page of a security assessments list
	AssessmentList
}

// AssessmentsMetadataClientCreateInSubscriptionResponse contains the response from method AssessmentsMetadataClient.CreateInSubscription.
type AssessmentsMetadataClientCreateInSubscriptionResponse struct {
	// Security assessment metadata response
	AssessmentMetadataResponse
}

// AssessmentsMetadataClientDeleteInSubscriptionResponse contains the response from method AssessmentsMetadataClient.DeleteInSubscription.
type AssessmentsMetadataClientDeleteInSubscriptionResponse struct {
	// placeholder for future response values
}

// AssessmentsMetadataClientGetInSubscriptionResponse contains the response from method AssessmentsMetadataClient.GetInSubscription.
type AssessmentsMetadataClientGetInSubscriptionResponse struct {
	// Security assessment metadata response
	AssessmentMetadataResponse
}

// AssessmentsMetadataClientGetResponse contains the response from method AssessmentsMetadataClient.Get.
type AssessmentsMetadataClientGetResponse struct {
	// Security assessment metadata response
	AssessmentMetadataResponse
}

// AssessmentsMetadataClientListBySubscriptionResponse contains the response from method AssessmentsMetadataClient.NewListBySubscriptionPager.
type AssessmentsMetadataClientListBySubscriptionResponse struct {
	// List of security assessment metadata
	AssessmentMetadataResponseList
}

// AssessmentsMetadataClientListResponse contains the response from method AssessmentsMetadataClient.NewListPager.
type AssessmentsMetadataClientListResponse struct {
	// List of security assessment metadata
	AssessmentMetadataResponseList
}

// AutoProvisioningSettingsClientCreateResponse contains the response from method AutoProvisioningSettingsClient.Create.
type AutoProvisioningSettingsClientCreateResponse struct {
	// Auto provisioning setting
	AutoProvisioningSetting
}

// AutoProvisioningSettingsClientGetResponse contains the response from method AutoProvisioningSettingsClient.Get.
type AutoProvisioningSettingsClientGetResponse struct {
	// Auto provisioning setting
	AutoProvisioningSetting
}

// AutoProvisioningSettingsClientListResponse contains the response from method AutoProvisioningSettingsClient.NewListPager.
type AutoProvisioningSettingsClientListResponse struct {
	// List of all the auto provisioning settings response
	AutoProvisioningSettingList
}

// AutomationsClientCreateOrUpdateResponse contains the response from method AutomationsClient.CreateOrUpdate.
type AutomationsClientCreateOrUpdateResponse struct {
	// The security automation resource.
	Automation
}

// AutomationsClientDeleteResponse contains the response from method AutomationsClient.Delete.
type AutomationsClientDeleteResponse struct {
	// placeholder for future response values
}

// AutomationsClientGetResponse contains the response from method AutomationsClient.Get.
type AutomationsClientGetResponse struct {
	// The security automation resource.
	Automation
}

// AutomationsClientListByResourceGroupResponse contains the response from method AutomationsClient.NewListByResourceGroupPager.
type AutomationsClientListByResourceGroupResponse struct {
	// List of security automations response.
	AutomationList
}

// AutomationsClientListResponse contains the response from method AutomationsClient.NewListPager.
type AutomationsClientListResponse struct {
	// List of security automations response.
	AutomationList
}

// AutomationsClientValidateResponse contains the response from method AutomationsClient.Validate.
type AutomationsClientValidateResponse struct {
	// The security automation model state property bag.
	AutomationValidationStatus
}

// AzureDevOpsOrgsClientCreateOrUpdateResponse contains the response from method AzureDevOpsOrgsClient.BeginCreateOrUpdate.
type AzureDevOpsOrgsClientCreateOrUpdateResponse struct {
	// Azure DevOps Organization resource.
	AzureDevOpsOrg
}

// AzureDevOpsOrgsClientGetResponse contains the response from method AzureDevOpsOrgsClient.Get.
type AzureDevOpsOrgsClientGetResponse struct {
	// Azure DevOps Organization resource.
	AzureDevOpsOrg
}

// AzureDevOpsOrgsClientListAvailableResponse contains the response from method AzureDevOpsOrgsClient.ListAvailable.
type AzureDevOpsOrgsClientListAvailableResponse struct {
	// List of RP resources which supports pagination.
	AzureDevOpsOrgListResponse
}

// AzureDevOpsOrgsClientListResponse contains the response from method AzureDevOpsOrgsClient.NewListPager.
type AzureDevOpsOrgsClientListResponse struct {
	// List of RP resources which supports pagination.
	AzureDevOpsOrgListResponse
}

// AzureDevOpsOrgsClientUpdateResponse contains the response from method AzureDevOpsOrgsClient.BeginUpdate.
type AzureDevOpsOrgsClientUpdateResponse struct {
	// Azure DevOps Organization resource.
	AzureDevOpsOrg
}

// AzureDevOpsProjectsClientCreateOrUpdateResponse contains the response from method AzureDevOpsProjectsClient.BeginCreateOrUpdate.
type AzureDevOpsProjectsClientCreateOrUpdateResponse struct {
	// Azure DevOps Project resource.
	AzureDevOpsProject
}

// AzureDevOpsProjectsClientGetResponse contains the response from method AzureDevOpsProjectsClient.Get.
type AzureDevOpsProjectsClientGetResponse struct {
	// Azure DevOps Project resource.
	AzureDevOpsProject
}

// AzureDevOpsProjectsClientListResponse contains the response from method AzureDevOpsProjectsClient.NewListPager.
type AzureDevOpsProjectsClientListResponse struct {
	// List of RP resources which supports pagination.
	AzureDevOpsProjectListResponse
}

// AzureDevOpsProjectsClientUpdateResponse contains the response from method AzureDevOpsProjectsClient.BeginUpdate.
type AzureDevOpsProjectsClientUpdateResponse struct {
	// Azure DevOps Project resource.
	AzureDevOpsProject
}

// AzureDevOpsReposClientCreateOrUpdateResponse contains the response from method AzureDevOpsReposClient.BeginCreateOrUpdate.
type AzureDevOpsReposClientCreateOrUpdateResponse struct {
	// Azure DevOps Repository resource.
	AzureDevOpsRepository
}

// AzureDevOpsReposClientGetResponse contains the response from method AzureDevOpsReposClient.Get.
type AzureDevOpsReposClientGetResponse struct {
	// Azure DevOps Repository resource.
	AzureDevOpsRepository
}

// AzureDevOpsReposClientListResponse contains the response from method AzureDevOpsReposClient.NewListPager.
type AzureDevOpsReposClientListResponse struct {
	// List of RP resources which supports pagination.
	AzureDevOpsRepositoryListResponse
}

// AzureDevOpsReposClientUpdateResponse contains the response from method AzureDevOpsReposClient.BeginUpdate.
type AzureDevOpsReposClientUpdateResponse struct {
	// Azure DevOps Repository resource.
	AzureDevOpsRepository
}

// CenterClientGetSensitivitySettingsResponse contains the response from method CenterClient.GetSensitivitySettings.
type CenterClientGetSensitivitySettingsResponse struct {
	// Data sensitivity settings for sensitive data discovery
	GetSensitivitySettingsResponse
}

// CenterClientUpdateSensitivitySettingsResponse contains the response from method CenterClient.UpdateSensitivitySettings.
type CenterClientUpdateSensitivitySettingsResponse struct {
	// Data sensitivity settings for sensitive data discovery
	GetSensitivitySettingsResponse
}

// ComplianceResultsClientGetResponse contains the response from method ComplianceResultsClient.Get.
type ComplianceResultsClientGetResponse struct {
	// a compliance result
	ComplianceResult
}

// ComplianceResultsClientListResponse contains the response from method ComplianceResultsClient.NewListPager.
type ComplianceResultsClientListResponse struct {
	// List of compliance results response
	ComplianceResultList
}

// CompliancesClientGetResponse contains the response from method CompliancesClient.Get.
type CompliancesClientGetResponse struct {
	// Compliance of a scope
	Compliance
}

// CompliancesClientListResponse contains the response from method CompliancesClient.NewListPager.
type CompliancesClientListResponse struct {
	// List of Compliance objects response
	ComplianceList
}

// ConnectorApplicationClientCreateOrUpdateResponse contains the response from method ConnectorApplicationClient.CreateOrUpdate.
type ConnectorApplicationClientCreateOrUpdateResponse struct {
	// Security Application over a given scope
	Application
}

// ConnectorApplicationClientDeleteResponse contains the response from method ConnectorApplicationClient.Delete.
type ConnectorApplicationClientDeleteResponse struct {
	// placeholder for future response values
}

// ConnectorApplicationClientGetResponse contains the response from method ConnectorApplicationClient.Get.
type ConnectorApplicationClientGetResponse struct {
	// Security Application over a given scope
	Application
}

// ConnectorApplicationsClientListResponse contains the response from method ConnectorApplicationsClient.NewListPager.
type ConnectorApplicationsClientListResponse struct {
	// Page of a security applications list
	ApplicationsList
}

// ConnectorsClientCreateOrUpdateResponse contains the response from method ConnectorsClient.CreateOrUpdate.
type ConnectorsClientCreateOrUpdateResponse struct {
	// The security connector resource.
	Connector
}

// ConnectorsClientDeleteResponse contains the response from method ConnectorsClient.Delete.
type ConnectorsClientDeleteResponse struct {
	// placeholder for future response values
}

// ConnectorsClientGetResponse contains the response from method ConnectorsClient.Get.
type ConnectorsClientGetResponse struct {
	// The security connector resource.
	Connector
}

// ConnectorsClientListByResourceGroupResponse contains the response from method ConnectorsClient.NewListByResourceGroupPager.
type ConnectorsClientListByResourceGroupResponse struct {
	// List of security connectors response.
	ConnectorsList
}

// ConnectorsClientListResponse contains the response from method ConnectorsClient.NewListPager.
type ConnectorsClientListResponse struct {
	// List of security connectors response.
	ConnectorsList
}

// ConnectorsClientUpdateResponse contains the response from method ConnectorsClient.Update.
type ConnectorsClientUpdateResponse struct {
	// The security connector resource.
	Connector
}

// ContactsClientCreateResponse contains the response from method ContactsClient.Create.
type ContactsClientCreateResponse struct {
	// Contact details and configurations for notifications coming from Microsoft Defender for Cloud.
	Contact
}

// ContactsClientDeleteResponse contains the response from method ContactsClient.Delete.
type ContactsClientDeleteResponse struct {
	// placeholder for future response values
}

// ContactsClientGetResponse contains the response from method ContactsClient.Get.
type ContactsClientGetResponse struct {
	// Contact details and configurations for notifications coming from Microsoft Defender for Cloud.
	Contact
}

// ContactsClientListResponse contains the response from method ContactsClient.NewListPager.
type ContactsClientListResponse struct {
	// List of security contacts response
	ContactList
}

// CustomAssessmentAutomationsClientCreateResponse contains the response from method CustomAssessmentAutomationsClient.Create.
type CustomAssessmentAutomationsClientCreateResponse struct {
	// Custom Assessment Automation
	CustomAssessmentAutomation
}

// CustomAssessmentAutomationsClientDeleteResponse contains the response from method CustomAssessmentAutomationsClient.Delete.
type CustomAssessmentAutomationsClientDeleteResponse struct {
	// placeholder for future response values
}

// CustomAssessmentAutomationsClientGetResponse contains the response from method CustomAssessmentAutomationsClient.Get.
type CustomAssessmentAutomationsClientGetResponse struct {
	// Custom Assessment Automation
	CustomAssessmentAutomation
}

// CustomAssessmentAutomationsClientListByResourceGroupResponse contains the response from method CustomAssessmentAutomationsClient.NewListByResourceGroupPager.
type CustomAssessmentAutomationsClientListByResourceGroupResponse struct {
	// A list of Custom Assessment Automations
	CustomAssessmentAutomationsListResult
}

// CustomAssessmentAutomationsClientListBySubscriptionResponse contains the response from method CustomAssessmentAutomationsClient.NewListBySubscriptionPager.
type CustomAssessmentAutomationsClientListBySubscriptionResponse struct {
	// A list of Custom Assessment Automations
	CustomAssessmentAutomationsListResult
}

// CustomEntityStoreAssignmentsClientCreateResponse contains the response from method CustomEntityStoreAssignmentsClient.Create.
type CustomEntityStoreAssignmentsClientCreateResponse struct {
	// Custom entity store assignment
	CustomEntityStoreAssignment
}

// CustomEntityStoreAssignmentsClientDeleteResponse contains the response from method CustomEntityStoreAssignmentsClient.Delete.
type CustomEntityStoreAssignmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// CustomEntityStoreAssignmentsClientGetResponse contains the response from method CustomEntityStoreAssignmentsClient.Get.
type CustomEntityStoreAssignmentsClientGetResponse struct {
	// Custom entity store assignment
	CustomEntityStoreAssignment
}

// CustomEntityStoreAssignmentsClientListByResourceGroupResponse contains the response from method CustomEntityStoreAssignmentsClient.NewListByResourceGroupPager.
type CustomEntityStoreAssignmentsClientListByResourceGroupResponse struct {
	// A list of custom entity store assignments
	CustomEntityStoreAssignmentsListResult
}

// CustomEntityStoreAssignmentsClientListBySubscriptionResponse contains the response from method CustomEntityStoreAssignmentsClient.NewListBySubscriptionPager.
type CustomEntityStoreAssignmentsClientListBySubscriptionResponse struct {
	// A list of custom entity store assignments
	CustomEntityStoreAssignmentsListResult
}

// DefenderForStorageClientCreateResponse contains the response from method DefenderForStorageClient.Create.
type DefenderForStorageClientCreateResponse struct {
	// The Defender for Storage resource.
	DefenderForStorageSetting
}

// DefenderForStorageClientGetResponse contains the response from method DefenderForStorageClient.Get.
type DefenderForStorageClientGetResponse struct {
	// The Defender for Storage resource.
	DefenderForStorageSetting
}

// DevOpsConfigurationsClientCreateOrUpdateResponse contains the response from method DevOpsConfigurationsClient.BeginCreateOrUpdate.
type DevOpsConfigurationsClientCreateOrUpdateResponse struct {
	// DevOps Configuration resource.
	DevOpsConfiguration
}

// DevOpsConfigurationsClientDeleteResponse contains the response from method DevOpsConfigurationsClient.BeginDelete.
type DevOpsConfigurationsClientDeleteResponse struct {
	// placeholder for future response values
}

// DevOpsConfigurationsClientGetResponse contains the response from method DevOpsConfigurationsClient.Get.
type DevOpsConfigurationsClientGetResponse struct {
	// DevOps Configuration resource.
	DevOpsConfiguration
}

// DevOpsConfigurationsClientListResponse contains the response from method DevOpsConfigurationsClient.NewListPager.
type DevOpsConfigurationsClientListResponse struct {
	// List of RP resources which supports pagination.
	DevOpsConfigurationListResponse
}

// DevOpsConfigurationsClientUpdateResponse contains the response from method DevOpsConfigurationsClient.BeginUpdate.
type DevOpsConfigurationsClientUpdateResponse struct {
	// DevOps Configuration resource.
	DevOpsConfiguration
}

// DevOpsOperationResultsClientGetResponse contains the response from method DevOpsOperationResultsClient.Get.
type DevOpsOperationResultsClientGetResponse struct {
	// The current status of an async operation.
	OperationStatusResult
}

// DeviceSecurityGroupsClientCreateOrUpdateResponse contains the response from method DeviceSecurityGroupsClient.CreateOrUpdate.
type DeviceSecurityGroupsClientCreateOrUpdateResponse struct {
	// The device security group resource
	DeviceSecurityGroup
}

// DeviceSecurityGroupsClientDeleteResponse contains the response from method DeviceSecurityGroupsClient.Delete.
type DeviceSecurityGroupsClientDeleteResponse struct {
	// placeholder for future response values
}

// DeviceSecurityGroupsClientGetResponse contains the response from method DeviceSecurityGroupsClient.Get.
type DeviceSecurityGroupsClientGetResponse struct {
	// The device security group resource
	DeviceSecurityGroup
}

// DeviceSecurityGroupsClientListResponse contains the response from method DeviceSecurityGroupsClient.NewListPager.
type DeviceSecurityGroupsClientListResponse struct {
	// List of device security groups
	DeviceSecurityGroupList
}

// DiscoveredSecuritySolutionsClientGetResponse contains the response from method DiscoveredSecuritySolutionsClient.Get.
type DiscoveredSecuritySolutionsClientGetResponse struct {
	DiscoveredSecuritySolution
}

// DiscoveredSecuritySolutionsClientListByHomeRegionResponse contains the response from method DiscoveredSecuritySolutionsClient.NewListByHomeRegionPager.
type DiscoveredSecuritySolutionsClientListByHomeRegionResponse struct {
	DiscoveredSecuritySolutionList
}

// DiscoveredSecuritySolutionsClientListResponse contains the response from method DiscoveredSecuritySolutionsClient.NewListPager.
type DiscoveredSecuritySolutionsClientListResponse struct {
	DiscoveredSecuritySolutionList
}

// ExternalSecuritySolutionsClientGetResponse contains the response from method ExternalSecuritySolutionsClient.Get.
type ExternalSecuritySolutionsClientGetResponse struct {
	// Represents a security solution external to Microsoft Defender for Cloud which sends information to an OMS workspace and
	// whose data is displayed by Microsoft Defender for Cloud.
	ExternalSecuritySolutionClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalSecuritySolutionsClientGetResponse.
func (e *ExternalSecuritySolutionsClientGetResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalExternalSecuritySolutionClassification(data)
	if err != nil {
		return err
	}
	e.ExternalSecuritySolutionClassification = res
	return nil
}

// ExternalSecuritySolutionsClientListByHomeRegionResponse contains the response from method ExternalSecuritySolutionsClient.NewListByHomeRegionPager.
type ExternalSecuritySolutionsClientListByHomeRegionResponse struct {
	ExternalSecuritySolutionList
}

// ExternalSecuritySolutionsClientListResponse contains the response from method ExternalSecuritySolutionsClient.NewListPager.
type ExternalSecuritySolutionsClientListResponse struct {
	ExternalSecuritySolutionList
}

// GitHubOwnersClientGetResponse contains the response from method GitHubOwnersClient.Get.
type GitHubOwnersClientGetResponse struct {
	// GitHub Owner resource.
	GitHubOwner
}

// GitHubOwnersClientListAvailableResponse contains the response from method GitHubOwnersClient.ListAvailable.
type GitHubOwnersClientListAvailableResponse struct {
	// List of RP resources which supports pagination.
	GitHubOwnerListResponse
}

// GitHubOwnersClientListResponse contains the response from method GitHubOwnersClient.NewListPager.
type GitHubOwnersClientListResponse struct {
	// List of RP resources which supports pagination.
	GitHubOwnerListResponse
}

// GitHubReposClientGetResponse contains the response from method GitHubReposClient.Get.
type GitHubReposClientGetResponse struct {
	// GitHub Repository resource.
	GitHubRepository
}

// GitHubReposClientListResponse contains the response from method GitHubReposClient.NewListPager.
type GitHubReposClientListResponse struct {
	// List of RP resources which supports pagination.
	GitHubRepositoryListResponse
}

// GitLabGroupsClientGetResponse contains the response from method GitLabGroupsClient.Get.
type GitLabGroupsClientGetResponse struct {
	// GitLab Group resource.
	GitLabGroup
}

// GitLabGroupsClientListAvailableResponse contains the response from method GitLabGroupsClient.ListAvailable.
type GitLabGroupsClientListAvailableResponse struct {
	// List of RP resources which supports pagination.
	GitLabGroupListResponse
}

// GitLabGroupsClientListResponse contains the response from method GitLabGroupsClient.NewListPager.
type GitLabGroupsClientListResponse struct {
	// List of RP resources which supports pagination.
	GitLabGroupListResponse
}

// GitLabProjectsClientGetResponse contains the response from method GitLabProjectsClient.Get.
type GitLabProjectsClientGetResponse struct {
	// GitLab Project resource.
	GitLabProject
}

// GitLabProjectsClientListResponse contains the response from method GitLabProjectsClient.NewListPager.
type GitLabProjectsClientListResponse struct {
	// List of RP resources which supports pagination.
	GitLabProjectListResponse
}

// GitLabSubgroupsClientListResponse contains the response from method GitLabSubgroupsClient.List.
type GitLabSubgroupsClientListResponse struct {
	// List of RP resources which supports pagination.
	GitLabGroupListResponse
}

// GovernanceAssignmentsClientCreateOrUpdateResponse contains the response from method GovernanceAssignmentsClient.CreateOrUpdate.
type GovernanceAssignmentsClientCreateOrUpdateResponse struct {
	// Governance assignment over a given scope
	GovernanceAssignment
}

// GovernanceAssignmentsClientDeleteResponse contains the response from method GovernanceAssignmentsClient.Delete.
type GovernanceAssignmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// GovernanceAssignmentsClientGetResponse contains the response from method GovernanceAssignmentsClient.Get.
type GovernanceAssignmentsClientGetResponse struct {
	// Governance assignment over a given scope
	GovernanceAssignment
}

// GovernanceAssignmentsClientListResponse contains the response from method GovernanceAssignmentsClient.NewListPager.
type GovernanceAssignmentsClientListResponse struct {
	// Page of a governance assignments list
	GovernanceAssignmentsList
}

// GovernanceRulesClientCreateOrUpdateResponse contains the response from method GovernanceRulesClient.CreateOrUpdate.
type GovernanceRulesClientCreateOrUpdateResponse struct {
	// Governance rule over a given scope
	GovernanceRule
}

// GovernanceRulesClientDeleteResponse contains the response from method GovernanceRulesClient.BeginDelete.
type GovernanceRulesClientDeleteResponse struct {
	// placeholder for future response values
}

// GovernanceRulesClientExecuteResponse contains the response from method GovernanceRulesClient.BeginExecute.
type GovernanceRulesClientExecuteResponse struct {
	// placeholder for future response values
}

// GovernanceRulesClientGetResponse contains the response from method GovernanceRulesClient.Get.
type GovernanceRulesClientGetResponse struct {
	// Governance rule over a given scope
	GovernanceRule
}

// GovernanceRulesClientListResponse contains the response from method GovernanceRulesClient.NewListPager.
type GovernanceRulesClientListResponse struct {
	// Page of a governance rules list
	GovernanceRuleList
}

// GovernanceRulesClientOperationResultsResponse contains the response from method GovernanceRulesClient.OperationResults.
type GovernanceRulesClientOperationResultsResponse struct {
	// Long run operation status of governance rule over a given scope
	OperationResultAutoGenerated

	// Location contains the information returned from the location header response.
	Location *string
}

// HealthReportsClientGetResponse contains the response from method HealthReportsClient.Get.
type HealthReportsClientGetResponse struct {
	// The health report resource
	HealthReport
}

// HealthReportsClientListResponse contains the response from method HealthReportsClient.NewListPager.
type HealthReportsClientListResponse struct {
	// Page of health reports list
	HealthReportsList
}

// InformationProtectionPoliciesClientCreateOrUpdateResponse contains the response from method InformationProtectionPoliciesClient.CreateOrUpdate.
type InformationProtectionPoliciesClientCreateOrUpdateResponse struct {
	// Information protection policy.
	InformationProtectionPolicy
}

// InformationProtectionPoliciesClientGetResponse contains the response from method InformationProtectionPoliciesClient.Get.
type InformationProtectionPoliciesClientGetResponse struct {
	// Information protection policy.
	InformationProtectionPolicy
}

// InformationProtectionPoliciesClientListResponse contains the response from method InformationProtectionPoliciesClient.NewListPager.
type InformationProtectionPoliciesClientListResponse struct {
	// Information protection policies response.
	InformationProtectionPolicyList
}

// IotSecuritySolutionAnalyticsClientGetResponse contains the response from method IotSecuritySolutionAnalyticsClient.Get.
type IotSecuritySolutionAnalyticsClientGetResponse struct {
	// Security analytics of your IoT Security solution
	IoTSecuritySolutionAnalyticsModel
}

// IotSecuritySolutionAnalyticsClientListResponse contains the response from method IotSecuritySolutionAnalyticsClient.List.
type IotSecuritySolutionAnalyticsClientListResponse struct {
	// List of Security analytics of your IoT Security solution
	IoTSecuritySolutionAnalyticsModelList
}

// IotSecuritySolutionClientCreateOrUpdateResponse contains the response from method IotSecuritySolutionClient.CreateOrUpdate.
type IotSecuritySolutionClientCreateOrUpdateResponse struct {
	// IoT Security solution configuration and resource information.
	IoTSecuritySolutionModel
}

// IotSecuritySolutionClientDeleteResponse contains the response from method IotSecuritySolutionClient.Delete.
type IotSecuritySolutionClientDeleteResponse struct {
	// placeholder for future response values
}

// IotSecuritySolutionClientGetResponse contains the response from method IotSecuritySolutionClient.Get.
type IotSecuritySolutionClientGetResponse struct {
	// IoT Security solution configuration and resource information.
	IoTSecuritySolutionModel
}

// IotSecuritySolutionClientListByResourceGroupResponse contains the response from method IotSecuritySolutionClient.NewListByResourceGroupPager.
type IotSecuritySolutionClientListByResourceGroupResponse struct {
	// List of IoT Security solutions.
	IoTSecuritySolutionsList
}

// IotSecuritySolutionClientListBySubscriptionResponse contains the response from method IotSecuritySolutionClient.NewListBySubscriptionPager.
type IotSecuritySolutionClientListBySubscriptionResponse struct {
	// List of IoT Security solutions.
	IoTSecuritySolutionsList
}

// IotSecuritySolutionClientUpdateResponse contains the response from method IotSecuritySolutionClient.Update.
type IotSecuritySolutionClientUpdateResponse struct {
	// IoT Security solution configuration and resource information.
	IoTSecuritySolutionModel
}

// IotSecuritySolutionsAnalyticsAggregatedAlertClientDismissResponse contains the response from method IotSecuritySolutionsAnalyticsAggregatedAlertClient.Dismiss.
type IotSecuritySolutionsAnalyticsAggregatedAlertClientDismissResponse struct {
	// placeholder for future response values
}

// IotSecuritySolutionsAnalyticsAggregatedAlertClientGetResponse contains the response from method IotSecuritySolutionsAnalyticsAggregatedAlertClient.Get.
type IotSecuritySolutionsAnalyticsAggregatedAlertClientGetResponse struct {
	// Security Solution Aggregated Alert information
	IoTSecurityAggregatedAlert
}

// IotSecuritySolutionsAnalyticsAggregatedAlertClientListResponse contains the response from method IotSecuritySolutionsAnalyticsAggregatedAlertClient.NewListPager.
type IotSecuritySolutionsAnalyticsAggregatedAlertClientListResponse struct {
	// List of IoT Security solution aggregated alert data.
	IoTSecurityAggregatedAlertList
}

// IotSecuritySolutionsAnalyticsRecommendationClientGetResponse contains the response from method IotSecuritySolutionsAnalyticsRecommendationClient.Get.
type IotSecuritySolutionsAnalyticsRecommendationClientGetResponse struct {
	// IoT Security solution recommendation information.
	IoTSecurityAggregatedRecommendation
}

// IotSecuritySolutionsAnalyticsRecommendationClientListResponse contains the response from method IotSecuritySolutionsAnalyticsRecommendationClient.NewListPager.
type IotSecuritySolutionsAnalyticsRecommendationClientListResponse struct {
	// List of IoT Security solution aggregated recommendations.
	IoTSecurityAggregatedRecommendationList
}

// JitNetworkAccessPoliciesClientCreateOrUpdateResponse contains the response from method JitNetworkAccessPoliciesClient.CreateOrUpdate.
type JitNetworkAccessPoliciesClientCreateOrUpdateResponse struct {
	JitNetworkAccessPolicy
}

// JitNetworkAccessPoliciesClientDeleteResponse contains the response from method JitNetworkAccessPoliciesClient.Delete.
type JitNetworkAccessPoliciesClientDeleteResponse struct {
	// placeholder for future response values
}

// JitNetworkAccessPoliciesClientGetResponse contains the response from method JitNetworkAccessPoliciesClient.Get.
type JitNetworkAccessPoliciesClientGetResponse struct {
	JitNetworkAccessPolicy
}

// JitNetworkAccessPoliciesClientInitiateResponse contains the response from method JitNetworkAccessPoliciesClient.Initiate.
type JitNetworkAccessPoliciesClientInitiateResponse struct {
	JitNetworkAccessRequest
}

// JitNetworkAccessPoliciesClientListByRegionResponse contains the response from method JitNetworkAccessPoliciesClient.NewListByRegionPager.
type JitNetworkAccessPoliciesClientListByRegionResponse struct {
	JitNetworkAccessPoliciesList
}

// JitNetworkAccessPoliciesClientListByResourceGroupAndRegionResponse contains the response from method JitNetworkAccessPoliciesClient.NewListByResourceGroupAndRegionPager.
type JitNetworkAccessPoliciesClientListByResourceGroupAndRegionResponse struct {
	JitNetworkAccessPoliciesList
}

// JitNetworkAccessPoliciesClientListByResourceGroupResponse contains the response from method JitNetworkAccessPoliciesClient.NewListByResourceGroupPager.
type JitNetworkAccessPoliciesClientListByResourceGroupResponse struct {
	JitNetworkAccessPoliciesList
}

// JitNetworkAccessPoliciesClientListResponse contains the response from method JitNetworkAccessPoliciesClient.NewListPager.
type JitNetworkAccessPoliciesClientListResponse struct {
	JitNetworkAccessPoliciesList
}

// LocationsClientGetResponse contains the response from method LocationsClient.Get.
type LocationsClientGetResponse struct {
	// The ASC location of the subscription is in the "name" field
	AscLocation
}

// LocationsClientListResponse contains the response from method LocationsClient.NewListPager.
type LocationsClientListResponse struct {
	// List of locations where ASC saves your data
	AscLocationList
}

// MdeOnboardingsClientGetResponse contains the response from method MdeOnboardingsClient.Get.
type MdeOnboardingsClientGetResponse struct {
	// The resource of the configuration or data needed to onboard the machine to MDE
	MdeOnboardingData
}

// MdeOnboardingsClientListResponse contains the response from method MdeOnboardingsClient.List.
type MdeOnboardingsClientListResponse struct {
	// List of all MDE onboarding data resources
	MdeOnboardingDataList
}

// OperationsClientListResponse contains the response from method OperationsClient.NewListPager.
type OperationsClientListResponse struct {
	// List of possible operations for Microsoft.Security resource provider
	OperationList
}

// OperatorsClientCreateOrUpdateResponse contains the response from method OperatorsClient.CreateOrUpdate.
type OperatorsClientCreateOrUpdateResponse struct {
	// Security operator under a given subscription and pricing
	OperatorResource
}

// OperatorsClientDeleteResponse contains the response from method OperatorsClient.Delete.
type OperatorsClientDeleteResponse struct {
	// placeholder for future response values
}

// OperatorsClientGetResponse contains the response from method OperatorsClient.Get.
type OperatorsClientGetResponse struct {
	// Security operator under a given subscription and pricing
	OperatorResource
}

// OperatorsClientListResponse contains the response from method OperatorsClient.List.
type OperatorsClientListResponse struct {
	// List of SecurityOperator response.
	OperatorList
}

// PricingsClientDeleteResponse contains the response from method PricingsClient.Delete.
type PricingsClientDeleteResponse struct {
	// placeholder for future response values
}

// PricingsClientGetResponse contains the response from method PricingsClient.Get.
type PricingsClientGetResponse struct {
	// Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security
	// capabilities, while the free tier offers basic security features.
	Pricing
}

// PricingsClientListResponse contains the response from method PricingsClient.List.
type PricingsClientListResponse struct {
	// List of pricing configurations response.
	PricingList
}

// PricingsClientUpdateResponse contains the response from method PricingsClient.Update.
type PricingsClientUpdateResponse struct {
	// Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced security
	// capabilities, while the free tier offers basic security features.
	Pricing
}

// RegulatoryComplianceAssessmentsClientGetResponse contains the response from method RegulatoryComplianceAssessmentsClient.Get.
type RegulatoryComplianceAssessmentsClientGetResponse struct {
	// Regulatory compliance assessment details and state
	RegulatoryComplianceAssessment
}

// RegulatoryComplianceAssessmentsClientListResponse contains the response from method RegulatoryComplianceAssessmentsClient.NewListPager.
type RegulatoryComplianceAssessmentsClientListResponse struct {
	// List of regulatory compliance assessment response
	RegulatoryComplianceAssessmentList
}

// RegulatoryComplianceControlsClientGetResponse contains the response from method RegulatoryComplianceControlsClient.Get.
type RegulatoryComplianceControlsClientGetResponse struct {
	// Regulatory compliance control details and state
	RegulatoryComplianceControl
}

// RegulatoryComplianceControlsClientListResponse contains the response from method RegulatoryComplianceControlsClient.NewListPager.
type RegulatoryComplianceControlsClientListResponse struct {
	// List of regulatory compliance controls response
	RegulatoryComplianceControlList
}

// RegulatoryComplianceStandardsClientGetResponse contains the response from method RegulatoryComplianceStandardsClient.Get.
type RegulatoryComplianceStandardsClientGetResponse struct {
	// Regulatory compliance standard details and state
	RegulatoryComplianceStandard
}

// RegulatoryComplianceStandardsClientListResponse contains the response from method RegulatoryComplianceStandardsClient.NewListPager.
type RegulatoryComplianceStandardsClientListResponse struct {
	// List of regulatory compliance standards response
	RegulatoryComplianceStandardList
}

// SQLVulnerabilityAssessmentBaselineRulesClientAddResponse contains the response from method SQLVulnerabilityAssessmentBaselineRulesClient.Add.
type SQLVulnerabilityAssessmentBaselineRulesClientAddResponse struct {
	// A list of rules results.
	RulesResults
}

// SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateResponse contains the response from method SQLVulnerabilityAssessmentBaselineRulesClient.CreateOrUpdate.
type SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateResponse struct {
	// Rule results.
	RuleResults
}

// SQLVulnerabilityAssessmentBaselineRulesClientDeleteResponse contains the response from method SQLVulnerabilityAssessmentBaselineRulesClient.Delete.
type SQLVulnerabilityAssessmentBaselineRulesClientDeleteResponse struct {
	// placeholder for future response values
}

// SQLVulnerabilityAssessmentBaselineRulesClientGetResponse contains the response from method SQLVulnerabilityAssessmentBaselineRulesClient.Get.
type SQLVulnerabilityAssessmentBaselineRulesClientGetResponse struct {
	// Rule results.
	RuleResults
}

// SQLVulnerabilityAssessmentBaselineRulesClientListResponse contains the response from method SQLVulnerabilityAssessmentBaselineRulesClient.List.
type SQLVulnerabilityAssessmentBaselineRulesClientListResponse struct {
	// A list of rules results.
	RulesResults
}

// SQLVulnerabilityAssessmentScanResultsClientGetResponse contains the response from method SQLVulnerabilityAssessmentScanResultsClient.Get.
type SQLVulnerabilityAssessmentScanResultsClientGetResponse struct {
	// A vulnerability assessment scan result for a single rule.
	ScanResult
}

// SQLVulnerabilityAssessmentScanResultsClientListResponse contains the response from method SQLVulnerabilityAssessmentScanResultsClient.List.
type SQLVulnerabilityAssessmentScanResultsClientListResponse struct {
	// A list of vulnerability assessment scan results.
	ScanResults
}

// SQLVulnerabilityAssessmentScansClientGetResponse contains the response from method SQLVulnerabilityAssessmentScansClient.Get.
type SQLVulnerabilityAssessmentScansClientGetResponse struct {
	// A vulnerability assessment scan record.
	Scan
}

// SQLVulnerabilityAssessmentScansClientListResponse contains the response from method SQLVulnerabilityAssessmentScansClient.List.
type SQLVulnerabilityAssessmentScansClientListResponse struct {
	// A list of vulnerability assessment scan records.
	Scans
}

// SecureScoreControlDefinitionsClientListBySubscriptionResponse contains the response from method SecureScoreControlDefinitionsClient.NewListBySubscriptionPager.
type SecureScoreControlDefinitionsClientListBySubscriptionResponse struct {
	// List of security controls definition
	SecureScoreControlDefinitionList
}

// SecureScoreControlDefinitionsClientListResponse contains the response from method SecureScoreControlDefinitionsClient.NewListPager.
type SecureScoreControlDefinitionsClientListResponse struct {
	// List of security controls definition
	SecureScoreControlDefinitionList
}

// SecureScoreControlsClientListBySecureScoreResponse contains the response from method SecureScoreControlsClient.NewListBySecureScorePager.
type SecureScoreControlsClientListBySecureScoreResponse struct {
	// List of security controls
	SecureScoreControlList
}

// SecureScoreControlsClientListResponse contains the response from method SecureScoreControlsClient.NewListPager.
type SecureScoreControlsClientListResponse struct {
	// List of security controls
	SecureScoreControlList
}

// SecureScoresClientGetResponse contains the response from method SecureScoresClient.Get.
type SecureScoresClientGetResponse struct {
	// Secure score item data model
	SecureScoreItem
}

// SecureScoresClientListResponse contains the response from method SecureScoresClient.NewListPager.
type SecureScoresClientListResponse struct {
	// List of secure scores
	SecureScoresList
}

// SensitivitySettingsClientListResponse contains the response from method SensitivitySettingsClient.List.
type SensitivitySettingsClientListResponse struct {
	// A list with a single sensitivity settings resource
	GetSensitivitySettingsListResponse
}

// ServerVulnerabilityAssessmentClientCreateOrUpdateResponse contains the response from method ServerVulnerabilityAssessmentClient.CreateOrUpdate.
type ServerVulnerabilityAssessmentClientCreateOrUpdateResponse struct {
	// Describes the server vulnerability assessment details on a resource
	ServerVulnerabilityAssessment
}

// ServerVulnerabilityAssessmentClientDeleteResponse contains the response from method ServerVulnerabilityAssessmentClient.BeginDelete.
type ServerVulnerabilityAssessmentClientDeleteResponse struct {
	// placeholder for future response values
}

// ServerVulnerabilityAssessmentClientGetResponse contains the response from method ServerVulnerabilityAssessmentClient.Get.
type ServerVulnerabilityAssessmentClientGetResponse struct {
	// Describes the server vulnerability assessment details on a resource
	ServerVulnerabilityAssessment
}

// ServerVulnerabilityAssessmentClientListByExtendedResourceResponse contains the response from method ServerVulnerabilityAssessmentClient.ListByExtendedResource.
type ServerVulnerabilityAssessmentClientListByExtendedResourceResponse struct {
	// List of server vulnerability assessments
	ServerVulnerabilityAssessmentsList
}

// ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse contains the response from method ServerVulnerabilityAssessmentsSettingsClient.CreateOrUpdate.
type ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse struct {
	// A base vulnerability assessments setting on servers in the defined scope.
	ServerVulnerabilityAssessmentsSettingClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse.
func (s *ServerVulnerabilityAssessmentsSettingsClientCreateOrUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalServerVulnerabilityAssessmentsSettingClassification(data)
	if err != nil {
		return err
	}
	s.ServerVulnerabilityAssessmentsSettingClassification = res
	return nil
}

// ServerVulnerabilityAssessmentsSettingsClientDeleteResponse contains the response from method ServerVulnerabilityAssessmentsSettingsClient.Delete.
type ServerVulnerabilityAssessmentsSettingsClientDeleteResponse struct {
	// placeholder for future response values
}

// ServerVulnerabilityAssessmentsSettingsClientGetResponse contains the response from method ServerVulnerabilityAssessmentsSettingsClient.Get.
type ServerVulnerabilityAssessmentsSettingsClientGetResponse struct {
	// A base vulnerability assessments setting on servers in the defined scope.
	ServerVulnerabilityAssessmentsSettingClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerVulnerabilityAssessmentsSettingsClientGetResponse.
func (s *ServerVulnerabilityAssessmentsSettingsClientGetResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalServerVulnerabilityAssessmentsSettingClassification(data)
	if err != nil {
		return err
	}
	s.ServerVulnerabilityAssessmentsSettingClassification = res
	return nil
}

// ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse contains the response from method ServerVulnerabilityAssessmentsSettingsClient.NewListBySubscriptionPager.
type ServerVulnerabilityAssessmentsSettingsClientListBySubscriptionResponse struct {
	// A page of a server vulnerability assessments settings list
	ServerVulnerabilityAssessmentsSettingsList
}

// SettingsClientGetResponse contains the response from method SettingsClient.Get.
type SettingsClientGetResponse struct {
	// The kind of the security setting
	SettingClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SettingsClientGetResponse.
func (s *SettingsClientGetResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalSettingClassification(data)
	if err != nil {
		return err
	}
	s.SettingClassification = res
	return nil
}

// SettingsClientListResponse contains the response from method SettingsClient.NewListPager.
type SettingsClientListResponse struct {
	// Subscription settings list.
	SettingsList
}

// SettingsClientUpdateResponse contains the response from method SettingsClient.Update.
type SettingsClientUpdateResponse struct {
	// The kind of the security setting
	SettingClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SettingsClientUpdateResponse.
func (s *SettingsClientUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalSettingClassification(data)
	if err != nil {
		return err
	}
	s.SettingClassification = res
	return nil
}

// SoftwareInventoriesClientGetResponse contains the response from method SoftwareInventoriesClient.Get.
type SoftwareInventoriesClientGetResponse struct {
	// Represents a software data
	Software
}

// SoftwareInventoriesClientListByExtendedResourceResponse contains the response from method SoftwareInventoriesClient.NewListByExtendedResourcePager.
type SoftwareInventoriesClientListByExtendedResourceResponse struct {
	// Represents the software inventory of the virtual machine.
	SoftwaresList
}

// SoftwareInventoriesClientListBySubscriptionResponse contains the response from method SoftwareInventoriesClient.NewListBySubscriptionPager.
type SoftwareInventoriesClientListBySubscriptionResponse struct {
	// Represents the software inventory of the virtual machine.
	SoftwaresList
}

// SolutionsClientGetResponse contains the response from method SolutionsClient.Get.
type SolutionsClientGetResponse struct {
	Solution
}

// SolutionsClientListResponse contains the response from method SolutionsClient.NewListPager.
type SolutionsClientListResponse struct {
	SolutionList
}

// SolutionsReferenceDataClientListByHomeRegionResponse contains the response from method SolutionsReferenceDataClient.ListByHomeRegion.
type SolutionsReferenceDataClientListByHomeRegionResponse struct {
	SolutionsReferenceDataList
}

// SolutionsReferenceDataClientListResponse contains the response from method SolutionsReferenceDataClient.List.
type SolutionsReferenceDataClientListResponse struct {
	SolutionsReferenceDataList
}

// SubAssessmentsClientGetResponse contains the response from method SubAssessmentsClient.Get.
type SubAssessmentsClientGetResponse struct {
	// Security sub-assessment on a resource
	SubAssessment
}

// SubAssessmentsClientListAllResponse contains the response from method SubAssessmentsClient.NewListAllPager.
type SubAssessmentsClientListAllResponse struct {
	// List of security sub-assessments
	SubAssessmentList
}

// SubAssessmentsClientListResponse contains the response from method SubAssessmentsClient.NewListPager.
type SubAssessmentsClientListResponse struct {
	// List of security sub-assessments
	SubAssessmentList
}

// TasksClientGetResourceGroupLevelTaskResponse contains the response from method TasksClient.GetResourceGroupLevelTask.
type TasksClientGetResourceGroupLevelTaskResponse struct {
	// Security task that we recommend to do in order to strengthen security
	Task
}

// TasksClientGetSubscriptionLevelTaskResponse contains the response from method TasksClient.GetSubscriptionLevelTask.
type TasksClientGetSubscriptionLevelTaskResponse struct {
	// Security task that we recommend to do in order to strengthen security
	Task
}

// TasksClientListByHomeRegionResponse contains the response from method TasksClient.NewListByHomeRegionPager.
type TasksClientListByHomeRegionResponse struct {
	// List of security task recommendations
	TaskList
}

// TasksClientListByResourceGroupResponse contains the response from method TasksClient.NewListByResourceGroupPager.
type TasksClientListByResourceGroupResponse struct {
	// List of security task recommendations
	TaskList
}

// TasksClientListResponse contains the response from method TasksClient.NewListPager.
type TasksClientListResponse struct {
	// List of security task recommendations
	TaskList
}

// TasksClientUpdateResourceGroupLevelTaskStateResponse contains the response from method TasksClient.UpdateResourceGroupLevelTaskState.
type TasksClientUpdateResourceGroupLevelTaskStateResponse struct {
	// placeholder for future response values
}

// TasksClientUpdateSubscriptionLevelTaskStateResponse contains the response from method TasksClient.UpdateSubscriptionLevelTaskState.
type TasksClientUpdateSubscriptionLevelTaskStateResponse struct {
	// placeholder for future response values
}

// TopologyClientGetResponse contains the response from method TopologyClient.Get.
type TopologyClientGetResponse struct {
	TopologyResource
}

// TopologyClientListByHomeRegionResponse contains the response from method TopologyClient.NewListByHomeRegionPager.
type TopologyClientListByHomeRegionResponse struct {
	TopologyList
}

// TopologyClientListResponse contains the response from method TopologyClient.NewListPager.
type TopologyClientListResponse struct {
	TopologyList
}

// WorkspaceSettingsClientCreateResponse contains the response from method WorkspaceSettingsClient.Create.
type WorkspaceSettingsClientCreateResponse struct {
	// Configures where to store the OMS agent data for workspaces under a scope
	WorkspaceSetting
}

// WorkspaceSettingsClientDeleteResponse contains the response from method WorkspaceSettingsClient.Delete.
type WorkspaceSettingsClientDeleteResponse struct {
	// placeholder for future response values
}

// WorkspaceSettingsClientGetResponse contains the response from method WorkspaceSettingsClient.Get.
type WorkspaceSettingsClientGetResponse struct {
	// Configures where to store the OMS agent data for workspaces under a scope
	WorkspaceSetting
}

// WorkspaceSettingsClientListResponse contains the response from method WorkspaceSettingsClient.NewListPager.
type WorkspaceSettingsClientListResponse struct {
	// List of workspace settings response
	WorkspaceSettingList
}

// WorkspaceSettingsClientUpdateResponse contains the response from method WorkspaceSettingsClient.Update.
type WorkspaceSettingsClientUpdateResponse struct {
	// Configures where to store the OMS agent data for workspaces under a scope
	WorkspaceSetting
}
