//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armsecurity.ClientFactory type.
type ServerFactory struct {
	APICollectionsServer                               APICollectionsServer
	AccountConnectorsServer                            AccountConnectorsServer
	AdaptiveApplicationControlsServer                  AdaptiveApplicationControlsServer
	AdaptiveNetworkHardeningsServer                    AdaptiveNetworkHardeningsServer
	AdvancedThreatProtectionServer                     AdvancedThreatProtectionServer
	AlertsServer                                       AlertsServer
	AlertsSuppressionRulesServer                       AlertsSuppressionRulesServer
	AllowedConnectionsServer                           AllowedConnectionsServer
	ApplicationServer                                  ApplicationServer
	ApplicationsServer                                 ApplicationsServer
	AssessmentsServer                                  AssessmentsServer
	AssessmentsMetadataServer                          AssessmentsMetadataServer
	AutoProvisioningSettingsServer                     AutoProvisioningSettingsServer
	AutomationsServer                                  AutomationsServer
	AzureDevOpsOrgsServer                              AzureDevOpsOrgsServer
	AzureDevOpsProjectsServer                          AzureDevOpsProjectsServer
	AzureDevOpsReposServer                             AzureDevOpsReposServer
	CenterServer                                       CenterServer
	ComplianceResultsServer                            ComplianceResultsServer
	CompliancesServer                                  CompliancesServer
	ConnectorApplicationServer                         ConnectorApplicationServer
	ConnectorApplicationsServer                        ConnectorApplicationsServer
	ConnectorsServer                                   ConnectorsServer
	ContactsServer                                     ContactsServer
	CustomAssessmentAutomationsServer                  CustomAssessmentAutomationsServer
	CustomEntityStoreAssignmentsServer                 CustomEntityStoreAssignmentsServer
	DefenderForStorageServer                           DefenderForStorageServer
	DevOpsConfigurationsServer                         DevOpsConfigurationsServer
	DevOpsOperationResultsServer                       DevOpsOperationResultsServer
	DeviceSecurityGroupsServer                         DeviceSecurityGroupsServer
	DiscoveredSecuritySolutionsServer                  DiscoveredSecuritySolutionsServer
	ExternalSecuritySolutionsServer                    ExternalSecuritySolutionsServer
	GitHubOwnersServer                                 GitHubOwnersServer
	GitHubReposServer                                  GitHubReposServer
	GitLabGroupsServer                                 GitLabGroupsServer
	GitLabProjectsServer                               GitLabProjectsServer
	GitLabSubgroupsServer                              GitLabSubgroupsServer
	GovernanceAssignmentsServer                        GovernanceAssignmentsServer
	GovernanceRulesServer                              GovernanceRulesServer
	HealthReportsServer                                HealthReportsServer
	InformationProtectionPoliciesServer                InformationProtectionPoliciesServer
	IotSecuritySolutionAnalyticsServer                 IotSecuritySolutionAnalyticsServer
	IotSecuritySolutionServer                          IotSecuritySolutionServer
	IotSecuritySolutionsAnalyticsAggregatedAlertServer IotSecuritySolutionsAnalyticsAggregatedAlertServer
	IotSecuritySolutionsAnalyticsRecommendationServer  IotSecuritySolutionsAnalyticsRecommendationServer
	JitNetworkAccessPoliciesServer                     JitNetworkAccessPoliciesServer
	LocationsServer                                    LocationsServer
	MdeOnboardingsServer                               MdeOnboardingsServer
	OperationsServer                                   OperationsServer
	OperatorsServer                                    OperatorsServer
	PricingsServer                                     PricingsServer
	RegulatoryComplianceAssessmentsServer              RegulatoryComplianceAssessmentsServer
	RegulatoryComplianceControlsServer                 RegulatoryComplianceControlsServer
	RegulatoryComplianceStandardsServer                RegulatoryComplianceStandardsServer
	SQLVulnerabilityAssessmentBaselineRulesServer      SQLVulnerabilityAssessmentBaselineRulesServer
	SQLVulnerabilityAssessmentScanResultsServer        SQLVulnerabilityAssessmentScanResultsServer
	SQLVulnerabilityAssessmentScansServer              SQLVulnerabilityAssessmentScansServer
	SecureScoreControlDefinitionsServer                SecureScoreControlDefinitionsServer
	SecureScoreControlsServer                          SecureScoreControlsServer
	SecureScoresServer                                 SecureScoresServer
	SensitivitySettingsServer                          SensitivitySettingsServer
	ServerVulnerabilityAssessmentServer                ServerVulnerabilityAssessmentServer
	ServerVulnerabilityAssessmentsSettingsServer       ServerVulnerabilityAssessmentsSettingsServer
	SettingsServer                                     SettingsServer
	SoftwareInventoriesServer                          SoftwareInventoriesServer
	SolutionsServer                                    SolutionsServer
	SolutionsReferenceDataServer                       SolutionsReferenceDataServer
	SubAssessmentsServer                               SubAssessmentsServer
	TasksServer                                        TasksServer
	TopologyServer                                     TopologyServer
	WorkspaceSettingsServer                            WorkspaceSettingsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armsecurity.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armsecurity.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                                  *ServerFactory
	trMu                                                 sync.Mutex
	trAPICollectionsServer                               *APICollectionsServerTransport
	trAccountConnectorsServer                            *AccountConnectorsServerTransport
	trAdaptiveApplicationControlsServer                  *AdaptiveApplicationControlsServerTransport
	trAdaptiveNetworkHardeningsServer                    *AdaptiveNetworkHardeningsServerTransport
	trAdvancedThreatProtectionServer                     *AdvancedThreatProtectionServerTransport
	trAlertsServer                                       *AlertsServerTransport
	trAlertsSuppressionRulesServer                       *AlertsSuppressionRulesServerTransport
	trAllowedConnectionsServer                           *AllowedConnectionsServerTransport
	trApplicationServer                                  *ApplicationServerTransport
	trApplicationsServer                                 *ApplicationsServerTransport
	trAssessmentsServer                                  *AssessmentsServerTransport
	trAssessmentsMetadataServer                          *AssessmentsMetadataServerTransport
	trAutoProvisioningSettingsServer                     *AutoProvisioningSettingsServerTransport
	trAutomationsServer                                  *AutomationsServerTransport
	trAzureDevOpsOrgsServer                              *AzureDevOpsOrgsServerTransport
	trAzureDevOpsProjectsServer                          *AzureDevOpsProjectsServerTransport
	trAzureDevOpsReposServer                             *AzureDevOpsReposServerTransport
	trCenterServer                                       *CenterServerTransport
	trComplianceResultsServer                            *ComplianceResultsServerTransport
	trCompliancesServer                                  *CompliancesServerTransport
	trConnectorApplicationServer                         *ConnectorApplicationServerTransport
	trConnectorApplicationsServer                        *ConnectorApplicationsServerTransport
	trConnectorsServer                                   *ConnectorsServerTransport
	trContactsServer                                     *ContactsServerTransport
	trCustomAssessmentAutomationsServer                  *CustomAssessmentAutomationsServerTransport
	trCustomEntityStoreAssignmentsServer                 *CustomEntityStoreAssignmentsServerTransport
	trDefenderForStorageServer                           *DefenderForStorageServerTransport
	trDevOpsConfigurationsServer                         *DevOpsConfigurationsServerTransport
	trDevOpsOperationResultsServer                       *DevOpsOperationResultsServerTransport
	trDeviceSecurityGroupsServer                         *DeviceSecurityGroupsServerTransport
	trDiscoveredSecuritySolutionsServer                  *DiscoveredSecuritySolutionsServerTransport
	trExternalSecuritySolutionsServer                    *ExternalSecuritySolutionsServerTransport
	trGitHubOwnersServer                                 *GitHubOwnersServerTransport
	trGitHubReposServer                                  *GitHubReposServerTransport
	trGitLabGroupsServer                                 *GitLabGroupsServerTransport
	trGitLabProjectsServer                               *GitLabProjectsServerTransport
	trGitLabSubgroupsServer                              *GitLabSubgroupsServerTransport
	trGovernanceAssignmentsServer                        *GovernanceAssignmentsServerTransport
	trGovernanceRulesServer                              *GovernanceRulesServerTransport
	trHealthReportsServer                                *HealthReportsServerTransport
	trInformationProtectionPoliciesServer                *InformationProtectionPoliciesServerTransport
	trIotSecuritySolutionAnalyticsServer                 *IotSecuritySolutionAnalyticsServerTransport
	trIotSecuritySolutionServer                          *IotSecuritySolutionServerTransport
	trIotSecuritySolutionsAnalyticsAggregatedAlertServer *IotSecuritySolutionsAnalyticsAggregatedAlertServerTransport
	trIotSecuritySolutionsAnalyticsRecommendationServer  *IotSecuritySolutionsAnalyticsRecommendationServerTransport
	trJitNetworkAccessPoliciesServer                     *JitNetworkAccessPoliciesServerTransport
	trLocationsServer                                    *LocationsServerTransport
	trMdeOnboardingsServer                               *MdeOnboardingsServerTransport
	trOperationsServer                                   *OperationsServerTransport
	trOperatorsServer                                    *OperatorsServerTransport
	trPricingsServer                                     *PricingsServerTransport
	trRegulatoryComplianceAssessmentsServer              *RegulatoryComplianceAssessmentsServerTransport
	trRegulatoryComplianceControlsServer                 *RegulatoryComplianceControlsServerTransport
	trRegulatoryComplianceStandardsServer                *RegulatoryComplianceStandardsServerTransport
	trSQLVulnerabilityAssessmentBaselineRulesServer      *SQLVulnerabilityAssessmentBaselineRulesServerTransport
	trSQLVulnerabilityAssessmentScanResultsServer        *SQLVulnerabilityAssessmentScanResultsServerTransport
	trSQLVulnerabilityAssessmentScansServer              *SQLVulnerabilityAssessmentScansServerTransport
	trSecureScoreControlDefinitionsServer                *SecureScoreControlDefinitionsServerTransport
	trSecureScoreControlsServer                          *SecureScoreControlsServerTransport
	trSecureScoresServer                                 *SecureScoresServerTransport
	trSensitivitySettingsServer                          *SensitivitySettingsServerTransport
	trServerVulnerabilityAssessmentServer                *ServerVulnerabilityAssessmentServerTransport
	trServerVulnerabilityAssessmentsSettingsServer       *ServerVulnerabilityAssessmentsSettingsServerTransport
	trSettingsServer                                     *SettingsServerTransport
	trSoftwareInventoriesServer                          *SoftwareInventoriesServerTransport
	trSolutionsServer                                    *SolutionsServerTransport
	trSolutionsReferenceDataServer                       *SolutionsReferenceDataServerTransport
	trSubAssessmentsServer                               *SubAssessmentsServerTransport
	trTasksServer                                        *TasksServerTransport
	trTopologyServer                                     *TopologyServerTransport
	trWorkspaceSettingsServer                            *WorkspaceSettingsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "APICollectionsClient":
		initServer(s, &s.trAPICollectionsServer, func() *APICollectionsServerTransport {
			return NewAPICollectionsServerTransport(&s.srv.APICollectionsServer)
		})
		resp, err = s.trAPICollectionsServer.Do(req)
	case "AccountConnectorsClient":
		initServer(s, &s.trAccountConnectorsServer, func() *AccountConnectorsServerTransport {
			return NewAccountConnectorsServerTransport(&s.srv.AccountConnectorsServer)
		})
		resp, err = s.trAccountConnectorsServer.Do(req)
	case "AdaptiveApplicationControlsClient":
		initServer(s, &s.trAdaptiveApplicationControlsServer, func() *AdaptiveApplicationControlsServerTransport {
			return NewAdaptiveApplicationControlsServerTransport(&s.srv.AdaptiveApplicationControlsServer)
		})
		resp, err = s.trAdaptiveApplicationControlsServer.Do(req)
	case "AdaptiveNetworkHardeningsClient":
		initServer(s, &s.trAdaptiveNetworkHardeningsServer, func() *AdaptiveNetworkHardeningsServerTransport {
			return NewAdaptiveNetworkHardeningsServerTransport(&s.srv.AdaptiveNetworkHardeningsServer)
		})
		resp, err = s.trAdaptiveNetworkHardeningsServer.Do(req)
	case "AdvancedThreatProtectionClient":
		initServer(s, &s.trAdvancedThreatProtectionServer, func() *AdvancedThreatProtectionServerTransport {
			return NewAdvancedThreatProtectionServerTransport(&s.srv.AdvancedThreatProtectionServer)
		})
		resp, err = s.trAdvancedThreatProtectionServer.Do(req)
	case "AlertsClient":
		initServer(s, &s.trAlertsServer, func() *AlertsServerTransport { return NewAlertsServerTransport(&s.srv.AlertsServer) })
		resp, err = s.trAlertsServer.Do(req)
	case "AlertsSuppressionRulesClient":
		initServer(s, &s.trAlertsSuppressionRulesServer, func() *AlertsSuppressionRulesServerTransport {
			return NewAlertsSuppressionRulesServerTransport(&s.srv.AlertsSuppressionRulesServer)
		})
		resp, err = s.trAlertsSuppressionRulesServer.Do(req)
	case "AllowedConnectionsClient":
		initServer(s, &s.trAllowedConnectionsServer, func() *AllowedConnectionsServerTransport {
			return NewAllowedConnectionsServerTransport(&s.srv.AllowedConnectionsServer)
		})
		resp, err = s.trAllowedConnectionsServer.Do(req)
	case "ApplicationClient":
		initServer(s, &s.trApplicationServer, func() *ApplicationServerTransport { return NewApplicationServerTransport(&s.srv.ApplicationServer) })
		resp, err = s.trApplicationServer.Do(req)
	case "ApplicationsClient":
		initServer(s, &s.trApplicationsServer, func() *ApplicationsServerTransport { return NewApplicationsServerTransport(&s.srv.ApplicationsServer) })
		resp, err = s.trApplicationsServer.Do(req)
	case "AssessmentsClient":
		initServer(s, &s.trAssessmentsServer, func() *AssessmentsServerTransport { return NewAssessmentsServerTransport(&s.srv.AssessmentsServer) })
		resp, err = s.trAssessmentsServer.Do(req)
	case "AssessmentsMetadataClient":
		initServer(s, &s.trAssessmentsMetadataServer, func() *AssessmentsMetadataServerTransport {
			return NewAssessmentsMetadataServerTransport(&s.srv.AssessmentsMetadataServer)
		})
		resp, err = s.trAssessmentsMetadataServer.Do(req)
	case "AutoProvisioningSettingsClient":
		initServer(s, &s.trAutoProvisioningSettingsServer, func() *AutoProvisioningSettingsServerTransport {
			return NewAutoProvisioningSettingsServerTransport(&s.srv.AutoProvisioningSettingsServer)
		})
		resp, err = s.trAutoProvisioningSettingsServer.Do(req)
	case "AutomationsClient":
		initServer(s, &s.trAutomationsServer, func() *AutomationsServerTransport { return NewAutomationsServerTransport(&s.srv.AutomationsServer) })
		resp, err = s.trAutomationsServer.Do(req)
	case "AzureDevOpsOrgsClient":
		initServer(s, &s.trAzureDevOpsOrgsServer, func() *AzureDevOpsOrgsServerTransport {
			return NewAzureDevOpsOrgsServerTransport(&s.srv.AzureDevOpsOrgsServer)
		})
		resp, err = s.trAzureDevOpsOrgsServer.Do(req)
	case "AzureDevOpsProjectsClient":
		initServer(s, &s.trAzureDevOpsProjectsServer, func() *AzureDevOpsProjectsServerTransport {
			return NewAzureDevOpsProjectsServerTransport(&s.srv.AzureDevOpsProjectsServer)
		})
		resp, err = s.trAzureDevOpsProjectsServer.Do(req)
	case "AzureDevOpsReposClient":
		initServer(s, &s.trAzureDevOpsReposServer, func() *AzureDevOpsReposServerTransport {
			return NewAzureDevOpsReposServerTransport(&s.srv.AzureDevOpsReposServer)
		})
		resp, err = s.trAzureDevOpsReposServer.Do(req)
	case "CenterClient":
		initServer(s, &s.trCenterServer, func() *CenterServerTransport { return NewCenterServerTransport(&s.srv.CenterServer) })
		resp, err = s.trCenterServer.Do(req)
	case "ComplianceResultsClient":
		initServer(s, &s.trComplianceResultsServer, func() *ComplianceResultsServerTransport {
			return NewComplianceResultsServerTransport(&s.srv.ComplianceResultsServer)
		})
		resp, err = s.trComplianceResultsServer.Do(req)
	case "CompliancesClient":
		initServer(s, &s.trCompliancesServer, func() *CompliancesServerTransport { return NewCompliancesServerTransport(&s.srv.CompliancesServer) })
		resp, err = s.trCompliancesServer.Do(req)
	case "ConnectorApplicationClient":
		initServer(s, &s.trConnectorApplicationServer, func() *ConnectorApplicationServerTransport {
			return NewConnectorApplicationServerTransport(&s.srv.ConnectorApplicationServer)
		})
		resp, err = s.trConnectorApplicationServer.Do(req)
	case "ConnectorApplicationsClient":
		initServer(s, &s.trConnectorApplicationsServer, func() *ConnectorApplicationsServerTransport {
			return NewConnectorApplicationsServerTransport(&s.srv.ConnectorApplicationsServer)
		})
		resp, err = s.trConnectorApplicationsServer.Do(req)
	case "ConnectorsClient":
		initServer(s, &s.trConnectorsServer, func() *ConnectorsServerTransport { return NewConnectorsServerTransport(&s.srv.ConnectorsServer) })
		resp, err = s.trConnectorsServer.Do(req)
	case "ContactsClient":
		initServer(s, &s.trContactsServer, func() *ContactsServerTransport { return NewContactsServerTransport(&s.srv.ContactsServer) })
		resp, err = s.trContactsServer.Do(req)
	case "CustomAssessmentAutomationsClient":
		initServer(s, &s.trCustomAssessmentAutomationsServer, func() *CustomAssessmentAutomationsServerTransport {
			return NewCustomAssessmentAutomationsServerTransport(&s.srv.CustomAssessmentAutomationsServer)
		})
		resp, err = s.trCustomAssessmentAutomationsServer.Do(req)
	case "CustomEntityStoreAssignmentsClient":
		initServer(s, &s.trCustomEntityStoreAssignmentsServer, func() *CustomEntityStoreAssignmentsServerTransport {
			return NewCustomEntityStoreAssignmentsServerTransport(&s.srv.CustomEntityStoreAssignmentsServer)
		})
		resp, err = s.trCustomEntityStoreAssignmentsServer.Do(req)
	case "DefenderForStorageClient":
		initServer(s, &s.trDefenderForStorageServer, func() *DefenderForStorageServerTransport {
			return NewDefenderForStorageServerTransport(&s.srv.DefenderForStorageServer)
		})
		resp, err = s.trDefenderForStorageServer.Do(req)
	case "DevOpsConfigurationsClient":
		initServer(s, &s.trDevOpsConfigurationsServer, func() *DevOpsConfigurationsServerTransport {
			return NewDevOpsConfigurationsServerTransport(&s.srv.DevOpsConfigurationsServer)
		})
		resp, err = s.trDevOpsConfigurationsServer.Do(req)
	case "DevOpsOperationResultsClient":
		initServer(s, &s.trDevOpsOperationResultsServer, func() *DevOpsOperationResultsServerTransport {
			return NewDevOpsOperationResultsServerTransport(&s.srv.DevOpsOperationResultsServer)
		})
		resp, err = s.trDevOpsOperationResultsServer.Do(req)
	case "DeviceSecurityGroupsClient":
		initServer(s, &s.trDeviceSecurityGroupsServer, func() *DeviceSecurityGroupsServerTransport {
			return NewDeviceSecurityGroupsServerTransport(&s.srv.DeviceSecurityGroupsServer)
		})
		resp, err = s.trDeviceSecurityGroupsServer.Do(req)
	case "DiscoveredSecuritySolutionsClient":
		initServer(s, &s.trDiscoveredSecuritySolutionsServer, func() *DiscoveredSecuritySolutionsServerTransport {
			return NewDiscoveredSecuritySolutionsServerTransport(&s.srv.DiscoveredSecuritySolutionsServer)
		})
		resp, err = s.trDiscoveredSecuritySolutionsServer.Do(req)
	case "ExternalSecuritySolutionsClient":
		initServer(s, &s.trExternalSecuritySolutionsServer, func() *ExternalSecuritySolutionsServerTransport {
			return NewExternalSecuritySolutionsServerTransport(&s.srv.ExternalSecuritySolutionsServer)
		})
		resp, err = s.trExternalSecuritySolutionsServer.Do(req)
	case "GitHubOwnersClient":
		initServer(s, &s.trGitHubOwnersServer, func() *GitHubOwnersServerTransport { return NewGitHubOwnersServerTransport(&s.srv.GitHubOwnersServer) })
		resp, err = s.trGitHubOwnersServer.Do(req)
	case "GitHubReposClient":
		initServer(s, &s.trGitHubReposServer, func() *GitHubReposServerTransport { return NewGitHubReposServerTransport(&s.srv.GitHubReposServer) })
		resp, err = s.trGitHubReposServer.Do(req)
	case "GitLabGroupsClient":
		initServer(s, &s.trGitLabGroupsServer, func() *GitLabGroupsServerTransport { return NewGitLabGroupsServerTransport(&s.srv.GitLabGroupsServer) })
		resp, err = s.trGitLabGroupsServer.Do(req)
	case "GitLabProjectsClient":
		initServer(s, &s.trGitLabProjectsServer, func() *GitLabProjectsServerTransport {
			return NewGitLabProjectsServerTransport(&s.srv.GitLabProjectsServer)
		})
		resp, err = s.trGitLabProjectsServer.Do(req)
	case "GitLabSubgroupsClient":
		initServer(s, &s.trGitLabSubgroupsServer, func() *GitLabSubgroupsServerTransport {
			return NewGitLabSubgroupsServerTransport(&s.srv.GitLabSubgroupsServer)
		})
		resp, err = s.trGitLabSubgroupsServer.Do(req)
	case "GovernanceAssignmentsClient":
		initServer(s, &s.trGovernanceAssignmentsServer, func() *GovernanceAssignmentsServerTransport {
			return NewGovernanceAssignmentsServerTransport(&s.srv.GovernanceAssignmentsServer)
		})
		resp, err = s.trGovernanceAssignmentsServer.Do(req)
	case "GovernanceRulesClient":
		initServer(s, &s.trGovernanceRulesServer, func() *GovernanceRulesServerTransport {
			return NewGovernanceRulesServerTransport(&s.srv.GovernanceRulesServer)
		})
		resp, err = s.trGovernanceRulesServer.Do(req)
	case "HealthReportsClient":
		initServer(s, &s.trHealthReportsServer, func() *HealthReportsServerTransport {
			return NewHealthReportsServerTransport(&s.srv.HealthReportsServer)
		})
		resp, err = s.trHealthReportsServer.Do(req)
	case "InformationProtectionPoliciesClient":
		initServer(s, &s.trInformationProtectionPoliciesServer, func() *InformationProtectionPoliciesServerTransport {
			return NewInformationProtectionPoliciesServerTransport(&s.srv.InformationProtectionPoliciesServer)
		})
		resp, err = s.trInformationProtectionPoliciesServer.Do(req)
	case "IotSecuritySolutionAnalyticsClient":
		initServer(s, &s.trIotSecuritySolutionAnalyticsServer, func() *IotSecuritySolutionAnalyticsServerTransport {
			return NewIotSecuritySolutionAnalyticsServerTransport(&s.srv.IotSecuritySolutionAnalyticsServer)
		})
		resp, err = s.trIotSecuritySolutionAnalyticsServer.Do(req)
	case "IotSecuritySolutionClient":
		initServer(s, &s.trIotSecuritySolutionServer, func() *IotSecuritySolutionServerTransport {
			return NewIotSecuritySolutionServerTransport(&s.srv.IotSecuritySolutionServer)
		})
		resp, err = s.trIotSecuritySolutionServer.Do(req)
	case "IotSecuritySolutionsAnalyticsAggregatedAlertClient":
		initServer(s, &s.trIotSecuritySolutionsAnalyticsAggregatedAlertServer, func() *IotSecuritySolutionsAnalyticsAggregatedAlertServerTransport {
			return NewIotSecuritySolutionsAnalyticsAggregatedAlertServerTransport(&s.srv.IotSecuritySolutionsAnalyticsAggregatedAlertServer)
		})
		resp, err = s.trIotSecuritySolutionsAnalyticsAggregatedAlertServer.Do(req)
	case "IotSecuritySolutionsAnalyticsRecommendationClient":
		initServer(s, &s.trIotSecuritySolutionsAnalyticsRecommendationServer, func() *IotSecuritySolutionsAnalyticsRecommendationServerTransport {
			return NewIotSecuritySolutionsAnalyticsRecommendationServerTransport(&s.srv.IotSecuritySolutionsAnalyticsRecommendationServer)
		})
		resp, err = s.trIotSecuritySolutionsAnalyticsRecommendationServer.Do(req)
	case "JitNetworkAccessPoliciesClient":
		initServer(s, &s.trJitNetworkAccessPoliciesServer, func() *JitNetworkAccessPoliciesServerTransport {
			return NewJitNetworkAccessPoliciesServerTransport(&s.srv.JitNetworkAccessPoliciesServer)
		})
		resp, err = s.trJitNetworkAccessPoliciesServer.Do(req)
	case "LocationsClient":
		initServer(s, &s.trLocationsServer, func() *LocationsServerTransport { return NewLocationsServerTransport(&s.srv.LocationsServer) })
		resp, err = s.trLocationsServer.Do(req)
	case "MdeOnboardingsClient":
		initServer(s, &s.trMdeOnboardingsServer, func() *MdeOnboardingsServerTransport {
			return NewMdeOnboardingsServerTransport(&s.srv.MdeOnboardingsServer)
		})
		resp, err = s.trMdeOnboardingsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "OperatorsClient":
		initServer(s, &s.trOperatorsServer, func() *OperatorsServerTransport { return NewOperatorsServerTransport(&s.srv.OperatorsServer) })
		resp, err = s.trOperatorsServer.Do(req)
	case "PricingsClient":
		initServer(s, &s.trPricingsServer, func() *PricingsServerTransport { return NewPricingsServerTransport(&s.srv.PricingsServer) })
		resp, err = s.trPricingsServer.Do(req)
	case "RegulatoryComplianceAssessmentsClient":
		initServer(s, &s.trRegulatoryComplianceAssessmentsServer, func() *RegulatoryComplianceAssessmentsServerTransport {
			return NewRegulatoryComplianceAssessmentsServerTransport(&s.srv.RegulatoryComplianceAssessmentsServer)
		})
		resp, err = s.trRegulatoryComplianceAssessmentsServer.Do(req)
	case "RegulatoryComplianceControlsClient":
		initServer(s, &s.trRegulatoryComplianceControlsServer, func() *RegulatoryComplianceControlsServerTransport {
			return NewRegulatoryComplianceControlsServerTransport(&s.srv.RegulatoryComplianceControlsServer)
		})
		resp, err = s.trRegulatoryComplianceControlsServer.Do(req)
	case "RegulatoryComplianceStandardsClient":
		initServer(s, &s.trRegulatoryComplianceStandardsServer, func() *RegulatoryComplianceStandardsServerTransport {
			return NewRegulatoryComplianceStandardsServerTransport(&s.srv.RegulatoryComplianceStandardsServer)
		})
		resp, err = s.trRegulatoryComplianceStandardsServer.Do(req)
	case "SQLVulnerabilityAssessmentBaselineRulesClient":
		initServer(s, &s.trSQLVulnerabilityAssessmentBaselineRulesServer, func() *SQLVulnerabilityAssessmentBaselineRulesServerTransport {
			return NewSQLVulnerabilityAssessmentBaselineRulesServerTransport(&s.srv.SQLVulnerabilityAssessmentBaselineRulesServer)
		})
		resp, err = s.trSQLVulnerabilityAssessmentBaselineRulesServer.Do(req)
	case "SQLVulnerabilityAssessmentScanResultsClient":
		initServer(s, &s.trSQLVulnerabilityAssessmentScanResultsServer, func() *SQLVulnerabilityAssessmentScanResultsServerTransport {
			return NewSQLVulnerabilityAssessmentScanResultsServerTransport(&s.srv.SQLVulnerabilityAssessmentScanResultsServer)
		})
		resp, err = s.trSQLVulnerabilityAssessmentScanResultsServer.Do(req)
	case "SQLVulnerabilityAssessmentScansClient":
		initServer(s, &s.trSQLVulnerabilityAssessmentScansServer, func() *SQLVulnerabilityAssessmentScansServerTransport {
			return NewSQLVulnerabilityAssessmentScansServerTransport(&s.srv.SQLVulnerabilityAssessmentScansServer)
		})
		resp, err = s.trSQLVulnerabilityAssessmentScansServer.Do(req)
	case "SecureScoreControlDefinitionsClient":
		initServer(s, &s.trSecureScoreControlDefinitionsServer, func() *SecureScoreControlDefinitionsServerTransport {
			return NewSecureScoreControlDefinitionsServerTransport(&s.srv.SecureScoreControlDefinitionsServer)
		})
		resp, err = s.trSecureScoreControlDefinitionsServer.Do(req)
	case "SecureScoreControlsClient":
		initServer(s, &s.trSecureScoreControlsServer, func() *SecureScoreControlsServerTransport {
			return NewSecureScoreControlsServerTransport(&s.srv.SecureScoreControlsServer)
		})
		resp, err = s.trSecureScoreControlsServer.Do(req)
	case "SecureScoresClient":
		initServer(s, &s.trSecureScoresServer, func() *SecureScoresServerTransport { return NewSecureScoresServerTransport(&s.srv.SecureScoresServer) })
		resp, err = s.trSecureScoresServer.Do(req)
	case "SensitivitySettingsClient":
		initServer(s, &s.trSensitivitySettingsServer, func() *SensitivitySettingsServerTransport {
			return NewSensitivitySettingsServerTransport(&s.srv.SensitivitySettingsServer)
		})
		resp, err = s.trSensitivitySettingsServer.Do(req)
	case "ServerVulnerabilityAssessmentClient":
		initServer(s, &s.trServerVulnerabilityAssessmentServer, func() *ServerVulnerabilityAssessmentServerTransport {
			return NewServerVulnerabilityAssessmentServerTransport(&s.srv.ServerVulnerabilityAssessmentServer)
		})
		resp, err = s.trServerVulnerabilityAssessmentServer.Do(req)
	case "ServerVulnerabilityAssessmentsSettingsClient":
		initServer(s, &s.trServerVulnerabilityAssessmentsSettingsServer, func() *ServerVulnerabilityAssessmentsSettingsServerTransport {
			return NewServerVulnerabilityAssessmentsSettingsServerTransport(&s.srv.ServerVulnerabilityAssessmentsSettingsServer)
		})
		resp, err = s.trServerVulnerabilityAssessmentsSettingsServer.Do(req)
	case "SettingsClient":
		initServer(s, &s.trSettingsServer, func() *SettingsServerTransport { return NewSettingsServerTransport(&s.srv.SettingsServer) })
		resp, err = s.trSettingsServer.Do(req)
	case "SoftwareInventoriesClient":
		initServer(s, &s.trSoftwareInventoriesServer, func() *SoftwareInventoriesServerTransport {
			return NewSoftwareInventoriesServerTransport(&s.srv.SoftwareInventoriesServer)
		})
		resp, err = s.trSoftwareInventoriesServer.Do(req)
	case "SolutionsClient":
		initServer(s, &s.trSolutionsServer, func() *SolutionsServerTransport { return NewSolutionsServerTransport(&s.srv.SolutionsServer) })
		resp, err = s.trSolutionsServer.Do(req)
	case "SolutionsReferenceDataClient":
		initServer(s, &s.trSolutionsReferenceDataServer, func() *SolutionsReferenceDataServerTransport {
			return NewSolutionsReferenceDataServerTransport(&s.srv.SolutionsReferenceDataServer)
		})
		resp, err = s.trSolutionsReferenceDataServer.Do(req)
	case "SubAssessmentsClient":
		initServer(s, &s.trSubAssessmentsServer, func() *SubAssessmentsServerTransport {
			return NewSubAssessmentsServerTransport(&s.srv.SubAssessmentsServer)
		})
		resp, err = s.trSubAssessmentsServer.Do(req)
	case "TasksClient":
		initServer(s, &s.trTasksServer, func() *TasksServerTransport { return NewTasksServerTransport(&s.srv.TasksServer) })
		resp, err = s.trTasksServer.Do(req)
	case "TopologyClient":
		initServer(s, &s.trTopologyServer, func() *TopologyServerTransport { return NewTopologyServerTransport(&s.srv.TopologyServer) })
		resp, err = s.trTopologyServer.Do(req)
	case "WorkspaceSettingsClient":
		initServer(s, &s.trWorkspaceSettingsServer, func() *WorkspaceSettingsServerTransport {
			return NewWorkspaceSettingsServerTransport(&s.srv.WorkspaceSettingsServer)
		})
		resp, err = s.trWorkspaceSettingsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
