//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// DevOpsOperationResultsServer is a fake server for instances of the armsecurity.DevOpsOperationResultsClient type.
type DevOpsOperationResultsServer struct {
	// Get is the fake for method DevOpsOperationResultsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, securityConnectorName string, operationResultID string, options *armsecurity.DevOpsOperationResultsClientGetOptions) (resp azfake.Responder[armsecurity.DevOpsOperationResultsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewDevOpsOperationResultsServerTransport creates a new instance of DevOpsOperationResultsServerTransport with the provided implementation.
// The returned DevOpsOperationResultsServerTransport instance is connected to an instance of armsecurity.DevOpsOperationResultsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDevOpsOperationResultsServerTransport(srv *DevOpsOperationResultsServer) *DevOpsOperationResultsServerTransport {
	return &DevOpsOperationResultsServerTransport{srv: srv}
}

// DevOpsOperationResultsServerTransport connects instances of armsecurity.DevOpsOperationResultsClient to instances of DevOpsOperationResultsServer.
// Don't use this type directly, use NewDevOpsOperationResultsServerTransport instead.
type DevOpsOperationResultsServerTransport struct {
	srv *DevOpsOperationResultsServer
}

// Do implements the policy.Transporter interface for DevOpsOperationResultsServerTransport.
func (d *DevOpsOperationResultsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DevOpsOperationResultsClient.Get":
		resp, err = d.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DevOpsOperationResultsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/securityConnectors/(?P<securityConnectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devops/default/operationResults/(?P<operationResultId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	securityConnectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("securityConnectorName")])
	if err != nil {
		return nil, err
	}
	operationResultIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationResultId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, securityConnectorNameParam, operationResultIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OperationStatusResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
