//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DefenderForStorageClient contains the methods for the DefenderForStorage group.
// Don't use this type directly, use NewDefenderForStorageClient() instead.
type DefenderForStorageClient struct {
	internal *arm.Client
}

// NewDefenderForStorageClient creates a new instance of DefenderForStorageClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDefenderForStorageClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*DefenderForStorageClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DefenderForStorageClient{
		internal: cl,
	}
	return client, nil
}

// Create - Creates or updates the Defender for Storage settings on a specified storage account.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-12-01-preview
//   - resourceID - The identifier of the resource.
//   - settingName - Defender for Storage setting name.
//   - defenderForStorageSetting - Defender for Storage Settings
//   - options - DefenderForStorageClientCreateOptions contains the optional parameters for the DefenderForStorageClient.Create
//     method.
func (client *DefenderForStorageClient) Create(ctx context.Context, resourceID string, settingName SettingName, defenderForStorageSetting DefenderForStorageSetting, options *DefenderForStorageClientCreateOptions) (DefenderForStorageClientCreateResponse, error) {
	var err error
	const operationName = "DefenderForStorageClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceID, settingName, defenderForStorageSetting, options)
	if err != nil {
		return DefenderForStorageClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DefenderForStorageClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return DefenderForStorageClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *DefenderForStorageClient) createCreateRequest(ctx context.Context, resourceID string, settingName SettingName, defenderForStorageSetting DefenderForStorageSetting, options *DefenderForStorageClientCreateOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	if settingName == "" {
		return nil, errors.New("parameter settingName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{settingName}", url.PathEscape(string(settingName)))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, defenderForStorageSetting); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *DefenderForStorageClient) createHandleResponse(resp *http.Response) (DefenderForStorageClientCreateResponse, error) {
	result := DefenderForStorageClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DefenderForStorageSetting); err != nil {
		return DefenderForStorageClientCreateResponse{}, err
	}
	return result, nil
}

// Get - Gets the Defender for Storage settings for the specified storage account.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-12-01-preview
//   - resourceID - The identifier of the resource.
//   - settingName - Defender for Storage setting name.
//   - options - DefenderForStorageClientGetOptions contains the optional parameters for the DefenderForStorageClient.Get method.
func (client *DefenderForStorageClient) Get(ctx context.Context, resourceID string, settingName SettingName, options *DefenderForStorageClientGetOptions) (DefenderForStorageClientGetResponse, error) {
	var err error
	const operationName = "DefenderForStorageClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceID, settingName, options)
	if err != nil {
		return DefenderForStorageClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DefenderForStorageClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DefenderForStorageClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DefenderForStorageClient) getCreateRequest(ctx context.Context, resourceID string, settingName SettingName, options *DefenderForStorageClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	if settingName == "" {
		return nil, errors.New("parameter settingName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{settingName}", url.PathEscape(string(settingName)))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DefenderForStorageClient) getHandleResponse(resp *http.Response) (DefenderForStorageClientGetResponse, error) {
	result := DefenderForStorageClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DefenderForStorageSetting); err != nil {
		return DefenderForStorageClientGetResponse{}, err
	}
	return result, nil
}
