//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armresources"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// DeploymentsServer is a fake server for instances of the armresources.DeploymentsClient type.
type DeploymentsServer struct {
	// CalculateTemplateHash is the fake for method DeploymentsClient.CalculateTemplateHash
	// HTTP status codes to indicate success: http.StatusOK
	CalculateTemplateHash func(ctx context.Context, templateParam any, options *armresources.DeploymentsClientCalculateTemplateHashOptions) (resp azfake.Responder[armresources.DeploymentsClientCalculateTemplateHashResponse], errResp azfake.ErrorResponder)

	// Cancel is the fake for method DeploymentsClient.Cancel
	// HTTP status codes to indicate success: http.StatusNoContent
	Cancel func(ctx context.Context, resourceGroupName string, deploymentName string, options *armresources.DeploymentsClientCancelOptions) (resp azfake.Responder[armresources.DeploymentsClientCancelResponse], errResp azfake.ErrorResponder)

	// CancelAtManagementGroupScope is the fake for method DeploymentsClient.CancelAtManagementGroupScope
	// HTTP status codes to indicate success: http.StatusNoContent
	CancelAtManagementGroupScope func(ctx context.Context, groupID string, deploymentName string, options *armresources.DeploymentsClientCancelAtManagementGroupScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientCancelAtManagementGroupScopeResponse], errResp azfake.ErrorResponder)

	// CancelAtScope is the fake for method DeploymentsClient.CancelAtScope
	// HTTP status codes to indicate success: http.StatusNoContent
	CancelAtScope func(ctx context.Context, scope string, deploymentName string, options *armresources.DeploymentsClientCancelAtScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientCancelAtScopeResponse], errResp azfake.ErrorResponder)

	// CancelAtSubscriptionScope is the fake for method DeploymentsClient.CancelAtSubscriptionScope
	// HTTP status codes to indicate success: http.StatusNoContent
	CancelAtSubscriptionScope func(ctx context.Context, deploymentName string, options *armresources.DeploymentsClientCancelAtSubscriptionScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientCancelAtSubscriptionScopeResponse], errResp azfake.ErrorResponder)

	// CancelAtTenantScope is the fake for method DeploymentsClient.CancelAtTenantScope
	// HTTP status codes to indicate success: http.StatusNoContent
	CancelAtTenantScope func(ctx context.Context, deploymentName string, options *armresources.DeploymentsClientCancelAtTenantScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientCancelAtTenantScopeResponse], errResp azfake.ErrorResponder)

	// CheckExistence is the fake for method DeploymentsClient.CheckExistence
	// HTTP status codes to indicate success: http.StatusNoContent, http.StatusNotFound
	CheckExistence func(ctx context.Context, resourceGroupName string, deploymentName string, options *armresources.DeploymentsClientCheckExistenceOptions) (resp azfake.Responder[armresources.DeploymentsClientCheckExistenceResponse], errResp azfake.ErrorResponder)

	// CheckExistenceAtManagementGroupScope is the fake for method DeploymentsClient.CheckExistenceAtManagementGroupScope
	// HTTP status codes to indicate success: http.StatusNoContent, http.StatusNotFound
	CheckExistenceAtManagementGroupScope func(ctx context.Context, groupID string, deploymentName string, options *armresources.DeploymentsClientCheckExistenceAtManagementGroupScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientCheckExistenceAtManagementGroupScopeResponse], errResp azfake.ErrorResponder)

	// CheckExistenceAtScope is the fake for method DeploymentsClient.CheckExistenceAtScope
	// HTTP status codes to indicate success: http.StatusNoContent, http.StatusNotFound
	CheckExistenceAtScope func(ctx context.Context, scope string, deploymentName string, options *armresources.DeploymentsClientCheckExistenceAtScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientCheckExistenceAtScopeResponse], errResp azfake.ErrorResponder)

	// CheckExistenceAtSubscriptionScope is the fake for method DeploymentsClient.CheckExistenceAtSubscriptionScope
	// HTTP status codes to indicate success: http.StatusNoContent, http.StatusNotFound
	CheckExistenceAtSubscriptionScope func(ctx context.Context, deploymentName string, options *armresources.DeploymentsClientCheckExistenceAtSubscriptionScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientCheckExistenceAtSubscriptionScopeResponse], errResp azfake.ErrorResponder)

	// CheckExistenceAtTenantScope is the fake for method DeploymentsClient.CheckExistenceAtTenantScope
	// HTTP status codes to indicate success: http.StatusNoContent, http.StatusNotFound
	CheckExistenceAtTenantScope func(ctx context.Context, deploymentName string, options *armresources.DeploymentsClientCheckExistenceAtTenantScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientCheckExistenceAtTenantScopeResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method DeploymentsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, deploymentName string, parameters armresources.Deployment, options *armresources.DeploymentsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateAtManagementGroupScope is the fake for method DeploymentsClient.BeginCreateOrUpdateAtManagementGroupScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAtManagementGroupScope func(ctx context.Context, groupID string, deploymentName string, parameters armresources.ScopedDeployment, options *armresources.DeploymentsClientBeginCreateOrUpdateAtManagementGroupScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtManagementGroupScopeResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateAtScope is the fake for method DeploymentsClient.BeginCreateOrUpdateAtScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAtScope func(ctx context.Context, scope string, deploymentName string, parameters armresources.Deployment, options *armresources.DeploymentsClientBeginCreateOrUpdateAtScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtScopeResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateAtSubscriptionScope is the fake for method DeploymentsClient.BeginCreateOrUpdateAtSubscriptionScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAtSubscriptionScope func(ctx context.Context, deploymentName string, parameters armresources.Deployment, options *armresources.DeploymentsClientBeginCreateOrUpdateAtSubscriptionScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtSubscriptionScopeResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateAtTenantScope is the fake for method DeploymentsClient.BeginCreateOrUpdateAtTenantScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAtTenantScope func(ctx context.Context, deploymentName string, parameters armresources.ScopedDeployment, options *armresources.DeploymentsClientBeginCreateOrUpdateAtTenantScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtTenantScopeResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DeploymentsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, deploymentName string, options *armresources.DeploymentsClientBeginDeleteOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeleteAtManagementGroupScope is the fake for method DeploymentsClient.BeginDeleteAtManagementGroupScope
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteAtManagementGroupScope func(ctx context.Context, groupID string, deploymentName string, options *armresources.DeploymentsClientBeginDeleteAtManagementGroupScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientDeleteAtManagementGroupScopeResponse], errResp azfake.ErrorResponder)

	// BeginDeleteAtScope is the fake for method DeploymentsClient.BeginDeleteAtScope
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteAtScope func(ctx context.Context, scope string, deploymentName string, options *armresources.DeploymentsClientBeginDeleteAtScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientDeleteAtScopeResponse], errResp azfake.ErrorResponder)

	// BeginDeleteAtSubscriptionScope is the fake for method DeploymentsClient.BeginDeleteAtSubscriptionScope
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteAtSubscriptionScope func(ctx context.Context, deploymentName string, options *armresources.DeploymentsClientBeginDeleteAtSubscriptionScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientDeleteAtSubscriptionScopeResponse], errResp azfake.ErrorResponder)

	// BeginDeleteAtTenantScope is the fake for method DeploymentsClient.BeginDeleteAtTenantScope
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteAtTenantScope func(ctx context.Context, deploymentName string, options *armresources.DeploymentsClientBeginDeleteAtTenantScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientDeleteAtTenantScopeResponse], errResp azfake.ErrorResponder)

	// ExportTemplate is the fake for method DeploymentsClient.ExportTemplate
	// HTTP status codes to indicate success: http.StatusOK
	ExportTemplate func(ctx context.Context, resourceGroupName string, deploymentName string, options *armresources.DeploymentsClientExportTemplateOptions) (resp azfake.Responder[armresources.DeploymentsClientExportTemplateResponse], errResp azfake.ErrorResponder)

	// ExportTemplateAtManagementGroupScope is the fake for method DeploymentsClient.ExportTemplateAtManagementGroupScope
	// HTTP status codes to indicate success: http.StatusOK
	ExportTemplateAtManagementGroupScope func(ctx context.Context, groupID string, deploymentName string, options *armresources.DeploymentsClientExportTemplateAtManagementGroupScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientExportTemplateAtManagementGroupScopeResponse], errResp azfake.ErrorResponder)

	// ExportTemplateAtScope is the fake for method DeploymentsClient.ExportTemplateAtScope
	// HTTP status codes to indicate success: http.StatusOK
	ExportTemplateAtScope func(ctx context.Context, scope string, deploymentName string, options *armresources.DeploymentsClientExportTemplateAtScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientExportTemplateAtScopeResponse], errResp azfake.ErrorResponder)

	// ExportTemplateAtSubscriptionScope is the fake for method DeploymentsClient.ExportTemplateAtSubscriptionScope
	// HTTP status codes to indicate success: http.StatusOK
	ExportTemplateAtSubscriptionScope func(ctx context.Context, deploymentName string, options *armresources.DeploymentsClientExportTemplateAtSubscriptionScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientExportTemplateAtSubscriptionScopeResponse], errResp azfake.ErrorResponder)

	// ExportTemplateAtTenantScope is the fake for method DeploymentsClient.ExportTemplateAtTenantScope
	// HTTP status codes to indicate success: http.StatusOK
	ExportTemplateAtTenantScope func(ctx context.Context, deploymentName string, options *armresources.DeploymentsClientExportTemplateAtTenantScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientExportTemplateAtTenantScopeResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DeploymentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, deploymentName string, options *armresources.DeploymentsClientGetOptions) (resp azfake.Responder[armresources.DeploymentsClientGetResponse], errResp azfake.ErrorResponder)

	// GetAtManagementGroupScope is the fake for method DeploymentsClient.GetAtManagementGroupScope
	// HTTP status codes to indicate success: http.StatusOK
	GetAtManagementGroupScope func(ctx context.Context, groupID string, deploymentName string, options *armresources.DeploymentsClientGetAtManagementGroupScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientGetAtManagementGroupScopeResponse], errResp azfake.ErrorResponder)

	// GetAtScope is the fake for method DeploymentsClient.GetAtScope
	// HTTP status codes to indicate success: http.StatusOK
	GetAtScope func(ctx context.Context, scope string, deploymentName string, options *armresources.DeploymentsClientGetAtScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientGetAtScopeResponse], errResp azfake.ErrorResponder)

	// GetAtSubscriptionScope is the fake for method DeploymentsClient.GetAtSubscriptionScope
	// HTTP status codes to indicate success: http.StatusOK
	GetAtSubscriptionScope func(ctx context.Context, deploymentName string, options *armresources.DeploymentsClientGetAtSubscriptionScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientGetAtSubscriptionScopeResponse], errResp azfake.ErrorResponder)

	// GetAtTenantScope is the fake for method DeploymentsClient.GetAtTenantScope
	// HTTP status codes to indicate success: http.StatusOK
	GetAtTenantScope func(ctx context.Context, deploymentName string, options *armresources.DeploymentsClientGetAtTenantScopeOptions) (resp azfake.Responder[armresources.DeploymentsClientGetAtTenantScopeResponse], errResp azfake.ErrorResponder)

	// NewListAtManagementGroupScopePager is the fake for method DeploymentsClient.NewListAtManagementGroupScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtManagementGroupScopePager func(groupID string, options *armresources.DeploymentsClientListAtManagementGroupScopeOptions) (resp azfake.PagerResponder[armresources.DeploymentsClientListAtManagementGroupScopeResponse])

	// NewListAtScopePager is the fake for method DeploymentsClient.NewListAtScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtScopePager func(scope string, options *armresources.DeploymentsClientListAtScopeOptions) (resp azfake.PagerResponder[armresources.DeploymentsClientListAtScopeResponse])

	// NewListAtSubscriptionScopePager is the fake for method DeploymentsClient.NewListAtSubscriptionScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtSubscriptionScopePager func(options *armresources.DeploymentsClientListAtSubscriptionScopeOptions) (resp azfake.PagerResponder[armresources.DeploymentsClientListAtSubscriptionScopeResponse])

	// NewListAtTenantScopePager is the fake for method DeploymentsClient.NewListAtTenantScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAtTenantScopePager func(options *armresources.DeploymentsClientListAtTenantScopeOptions) (resp azfake.PagerResponder[armresources.DeploymentsClientListAtTenantScopeResponse])

	// NewListByResourceGroupPager is the fake for method DeploymentsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armresources.DeploymentsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armresources.DeploymentsClientListByResourceGroupResponse])

	// BeginValidate is the fake for method DeploymentsClient.BeginValidate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusBadRequest
	BeginValidate func(ctx context.Context, resourceGroupName string, deploymentName string, parameters armresources.Deployment, options *armresources.DeploymentsClientBeginValidateOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientValidateResponse], errResp azfake.ErrorResponder)

	// BeginValidateAtManagementGroupScope is the fake for method DeploymentsClient.BeginValidateAtManagementGroupScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusBadRequest
	BeginValidateAtManagementGroupScope func(ctx context.Context, groupID string, deploymentName string, parameters armresources.ScopedDeployment, options *armresources.DeploymentsClientBeginValidateAtManagementGroupScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientValidateAtManagementGroupScopeResponse], errResp azfake.ErrorResponder)

	// BeginValidateAtScope is the fake for method DeploymentsClient.BeginValidateAtScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusBadRequest
	BeginValidateAtScope func(ctx context.Context, scope string, deploymentName string, parameters armresources.Deployment, options *armresources.DeploymentsClientBeginValidateAtScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientValidateAtScopeResponse], errResp azfake.ErrorResponder)

	// BeginValidateAtSubscriptionScope is the fake for method DeploymentsClient.BeginValidateAtSubscriptionScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusBadRequest
	BeginValidateAtSubscriptionScope func(ctx context.Context, deploymentName string, parameters armresources.Deployment, options *armresources.DeploymentsClientBeginValidateAtSubscriptionScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientValidateAtSubscriptionScopeResponse], errResp azfake.ErrorResponder)

	// BeginValidateAtTenantScope is the fake for method DeploymentsClient.BeginValidateAtTenantScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusBadRequest
	BeginValidateAtTenantScope func(ctx context.Context, deploymentName string, parameters armresources.ScopedDeployment, options *armresources.DeploymentsClientBeginValidateAtTenantScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientValidateAtTenantScopeResponse], errResp azfake.ErrorResponder)

	// BeginWhatIf is the fake for method DeploymentsClient.BeginWhatIf
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginWhatIf func(ctx context.Context, resourceGroupName string, deploymentName string, parameters armresources.DeploymentWhatIf, options *armresources.DeploymentsClientBeginWhatIfOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientWhatIfResponse], errResp azfake.ErrorResponder)

	// BeginWhatIfAtManagementGroupScope is the fake for method DeploymentsClient.BeginWhatIfAtManagementGroupScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginWhatIfAtManagementGroupScope func(ctx context.Context, groupID string, deploymentName string, parameters armresources.ScopedDeploymentWhatIf, options *armresources.DeploymentsClientBeginWhatIfAtManagementGroupScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientWhatIfAtManagementGroupScopeResponse], errResp azfake.ErrorResponder)

	// BeginWhatIfAtSubscriptionScope is the fake for method DeploymentsClient.BeginWhatIfAtSubscriptionScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginWhatIfAtSubscriptionScope func(ctx context.Context, deploymentName string, parameters armresources.DeploymentWhatIf, options *armresources.DeploymentsClientBeginWhatIfAtSubscriptionScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientWhatIfAtSubscriptionScopeResponse], errResp azfake.ErrorResponder)

	// BeginWhatIfAtTenantScope is the fake for method DeploymentsClient.BeginWhatIfAtTenantScope
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginWhatIfAtTenantScope func(ctx context.Context, deploymentName string, parameters armresources.ScopedDeploymentWhatIf, options *armresources.DeploymentsClientBeginWhatIfAtTenantScopeOptions) (resp azfake.PollerResponder[armresources.DeploymentsClientWhatIfAtTenantScopeResponse], errResp azfake.ErrorResponder)
}

// NewDeploymentsServerTransport creates a new instance of DeploymentsServerTransport with the provided implementation.
// The returned DeploymentsServerTransport instance is connected to an instance of armresources.DeploymentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDeploymentsServerTransport(srv *DeploymentsServer) *DeploymentsServerTransport {
	return &DeploymentsServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateResponse]](),
		beginCreateOrUpdateAtManagementGroupScope: newTracker[azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtManagementGroupScopeResponse]](),
		beginCreateOrUpdateAtScope:                newTracker[azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtScopeResponse]](),
		beginCreateOrUpdateAtSubscriptionScope:    newTracker[azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtSubscriptionScopeResponse]](),
		beginCreateOrUpdateAtTenantScope:          newTracker[azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtTenantScopeResponse]](),
		beginDelete:                               newTracker[azfake.PollerResponder[armresources.DeploymentsClientDeleteResponse]](),
		beginDeleteAtManagementGroupScope:         newTracker[azfake.PollerResponder[armresources.DeploymentsClientDeleteAtManagementGroupScopeResponse]](),
		beginDeleteAtScope:                        newTracker[azfake.PollerResponder[armresources.DeploymentsClientDeleteAtScopeResponse]](),
		beginDeleteAtSubscriptionScope:            newTracker[azfake.PollerResponder[armresources.DeploymentsClientDeleteAtSubscriptionScopeResponse]](),
		beginDeleteAtTenantScope:                  newTracker[azfake.PollerResponder[armresources.DeploymentsClientDeleteAtTenantScopeResponse]](),
		newListAtManagementGroupScopePager:        newTracker[azfake.PagerResponder[armresources.DeploymentsClientListAtManagementGroupScopeResponse]](),
		newListAtScopePager:                       newTracker[azfake.PagerResponder[armresources.DeploymentsClientListAtScopeResponse]](),
		newListAtSubscriptionScopePager:           newTracker[azfake.PagerResponder[armresources.DeploymentsClientListAtSubscriptionScopeResponse]](),
		newListAtTenantScopePager:                 newTracker[azfake.PagerResponder[armresources.DeploymentsClientListAtTenantScopeResponse]](),
		newListByResourceGroupPager:               newTracker[azfake.PagerResponder[armresources.DeploymentsClientListByResourceGroupResponse]](),
		beginValidate:                             newTracker[azfake.PollerResponder[armresources.DeploymentsClientValidateResponse]](),
		beginValidateAtManagementGroupScope:       newTracker[azfake.PollerResponder[armresources.DeploymentsClientValidateAtManagementGroupScopeResponse]](),
		beginValidateAtScope:                      newTracker[azfake.PollerResponder[armresources.DeploymentsClientValidateAtScopeResponse]](),
		beginValidateAtSubscriptionScope:          newTracker[azfake.PollerResponder[armresources.DeploymentsClientValidateAtSubscriptionScopeResponse]](),
		beginValidateAtTenantScope:                newTracker[azfake.PollerResponder[armresources.DeploymentsClientValidateAtTenantScopeResponse]](),
		beginWhatIf:                               newTracker[azfake.PollerResponder[armresources.DeploymentsClientWhatIfResponse]](),
		beginWhatIfAtManagementGroupScope:         newTracker[azfake.PollerResponder[armresources.DeploymentsClientWhatIfAtManagementGroupScopeResponse]](),
		beginWhatIfAtSubscriptionScope:            newTracker[azfake.PollerResponder[armresources.DeploymentsClientWhatIfAtSubscriptionScopeResponse]](),
		beginWhatIfAtTenantScope:                  newTracker[azfake.PollerResponder[armresources.DeploymentsClientWhatIfAtTenantScopeResponse]](),
	}
}

// DeploymentsServerTransport connects instances of armresources.DeploymentsClient to instances of DeploymentsServer.
// Don't use this type directly, use NewDeploymentsServerTransport instead.
type DeploymentsServerTransport struct {
	srv                                       *DeploymentsServer
	beginCreateOrUpdate                       *tracker[azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateResponse]]
	beginCreateOrUpdateAtManagementGroupScope *tracker[azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtManagementGroupScopeResponse]]
	beginCreateOrUpdateAtScope                *tracker[azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtScopeResponse]]
	beginCreateOrUpdateAtSubscriptionScope    *tracker[azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtSubscriptionScopeResponse]]
	beginCreateOrUpdateAtTenantScope          *tracker[azfake.PollerResponder[armresources.DeploymentsClientCreateOrUpdateAtTenantScopeResponse]]
	beginDelete                               *tracker[azfake.PollerResponder[armresources.DeploymentsClientDeleteResponse]]
	beginDeleteAtManagementGroupScope         *tracker[azfake.PollerResponder[armresources.DeploymentsClientDeleteAtManagementGroupScopeResponse]]
	beginDeleteAtScope                        *tracker[azfake.PollerResponder[armresources.DeploymentsClientDeleteAtScopeResponse]]
	beginDeleteAtSubscriptionScope            *tracker[azfake.PollerResponder[armresources.DeploymentsClientDeleteAtSubscriptionScopeResponse]]
	beginDeleteAtTenantScope                  *tracker[azfake.PollerResponder[armresources.DeploymentsClientDeleteAtTenantScopeResponse]]
	newListAtManagementGroupScopePager        *tracker[azfake.PagerResponder[armresources.DeploymentsClientListAtManagementGroupScopeResponse]]
	newListAtScopePager                       *tracker[azfake.PagerResponder[armresources.DeploymentsClientListAtScopeResponse]]
	newListAtSubscriptionScopePager           *tracker[azfake.PagerResponder[armresources.DeploymentsClientListAtSubscriptionScopeResponse]]
	newListAtTenantScopePager                 *tracker[azfake.PagerResponder[armresources.DeploymentsClientListAtTenantScopeResponse]]
	newListByResourceGroupPager               *tracker[azfake.PagerResponder[armresources.DeploymentsClientListByResourceGroupResponse]]
	beginValidate                             *tracker[azfake.PollerResponder[armresources.DeploymentsClientValidateResponse]]
	beginValidateAtManagementGroupScope       *tracker[azfake.PollerResponder[armresources.DeploymentsClientValidateAtManagementGroupScopeResponse]]
	beginValidateAtScope                      *tracker[azfake.PollerResponder[armresources.DeploymentsClientValidateAtScopeResponse]]
	beginValidateAtSubscriptionScope          *tracker[azfake.PollerResponder[armresources.DeploymentsClientValidateAtSubscriptionScopeResponse]]
	beginValidateAtTenantScope                *tracker[azfake.PollerResponder[armresources.DeploymentsClientValidateAtTenantScopeResponse]]
	beginWhatIf                               *tracker[azfake.PollerResponder[armresources.DeploymentsClientWhatIfResponse]]
	beginWhatIfAtManagementGroupScope         *tracker[azfake.PollerResponder[armresources.DeploymentsClientWhatIfAtManagementGroupScopeResponse]]
	beginWhatIfAtSubscriptionScope            *tracker[azfake.PollerResponder[armresources.DeploymentsClientWhatIfAtSubscriptionScopeResponse]]
	beginWhatIfAtTenantScope                  *tracker[azfake.PollerResponder[armresources.DeploymentsClientWhatIfAtTenantScopeResponse]]
}

// Do implements the policy.Transporter interface for DeploymentsServerTransport.
func (d *DeploymentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DeploymentsClient.CalculateTemplateHash":
		resp, err = d.dispatchCalculateTemplateHash(req)
	case "DeploymentsClient.Cancel":
		resp, err = d.dispatchCancel(req)
	case "DeploymentsClient.CancelAtManagementGroupScope":
		resp, err = d.dispatchCancelAtManagementGroupScope(req)
	case "DeploymentsClient.CancelAtScope":
		resp, err = d.dispatchCancelAtScope(req)
	case "DeploymentsClient.CancelAtSubscriptionScope":
		resp, err = d.dispatchCancelAtSubscriptionScope(req)
	case "DeploymentsClient.CancelAtTenantScope":
		resp, err = d.dispatchCancelAtTenantScope(req)
	case "DeploymentsClient.CheckExistence":
		resp, err = d.dispatchCheckExistence(req)
	case "DeploymentsClient.CheckExistenceAtManagementGroupScope":
		resp, err = d.dispatchCheckExistenceAtManagementGroupScope(req)
	case "DeploymentsClient.CheckExistenceAtScope":
		resp, err = d.dispatchCheckExistenceAtScope(req)
	case "DeploymentsClient.CheckExistenceAtSubscriptionScope":
		resp, err = d.dispatchCheckExistenceAtSubscriptionScope(req)
	case "DeploymentsClient.CheckExistenceAtTenantScope":
		resp, err = d.dispatchCheckExistenceAtTenantScope(req)
	case "DeploymentsClient.BeginCreateOrUpdate":
		resp, err = d.dispatchBeginCreateOrUpdate(req)
	case "DeploymentsClient.BeginCreateOrUpdateAtManagementGroupScope":
		resp, err = d.dispatchBeginCreateOrUpdateAtManagementGroupScope(req)
	case "DeploymentsClient.BeginCreateOrUpdateAtScope":
		resp, err = d.dispatchBeginCreateOrUpdateAtScope(req)
	case "DeploymentsClient.BeginCreateOrUpdateAtSubscriptionScope":
		resp, err = d.dispatchBeginCreateOrUpdateAtSubscriptionScope(req)
	case "DeploymentsClient.BeginCreateOrUpdateAtTenantScope":
		resp, err = d.dispatchBeginCreateOrUpdateAtTenantScope(req)
	case "DeploymentsClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DeploymentsClient.BeginDeleteAtManagementGroupScope":
		resp, err = d.dispatchBeginDeleteAtManagementGroupScope(req)
	case "DeploymentsClient.BeginDeleteAtScope":
		resp, err = d.dispatchBeginDeleteAtScope(req)
	case "DeploymentsClient.BeginDeleteAtSubscriptionScope":
		resp, err = d.dispatchBeginDeleteAtSubscriptionScope(req)
	case "DeploymentsClient.BeginDeleteAtTenantScope":
		resp, err = d.dispatchBeginDeleteAtTenantScope(req)
	case "DeploymentsClient.ExportTemplate":
		resp, err = d.dispatchExportTemplate(req)
	case "DeploymentsClient.ExportTemplateAtManagementGroupScope":
		resp, err = d.dispatchExportTemplateAtManagementGroupScope(req)
	case "DeploymentsClient.ExportTemplateAtScope":
		resp, err = d.dispatchExportTemplateAtScope(req)
	case "DeploymentsClient.ExportTemplateAtSubscriptionScope":
		resp, err = d.dispatchExportTemplateAtSubscriptionScope(req)
	case "DeploymentsClient.ExportTemplateAtTenantScope":
		resp, err = d.dispatchExportTemplateAtTenantScope(req)
	case "DeploymentsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DeploymentsClient.GetAtManagementGroupScope":
		resp, err = d.dispatchGetAtManagementGroupScope(req)
	case "DeploymentsClient.GetAtScope":
		resp, err = d.dispatchGetAtScope(req)
	case "DeploymentsClient.GetAtSubscriptionScope":
		resp, err = d.dispatchGetAtSubscriptionScope(req)
	case "DeploymentsClient.GetAtTenantScope":
		resp, err = d.dispatchGetAtTenantScope(req)
	case "DeploymentsClient.NewListAtManagementGroupScopePager":
		resp, err = d.dispatchNewListAtManagementGroupScopePager(req)
	case "DeploymentsClient.NewListAtScopePager":
		resp, err = d.dispatchNewListAtScopePager(req)
	case "DeploymentsClient.NewListAtSubscriptionScopePager":
		resp, err = d.dispatchNewListAtSubscriptionScopePager(req)
	case "DeploymentsClient.NewListAtTenantScopePager":
		resp, err = d.dispatchNewListAtTenantScopePager(req)
	case "DeploymentsClient.NewListByResourceGroupPager":
		resp, err = d.dispatchNewListByResourceGroupPager(req)
	case "DeploymentsClient.BeginValidate":
		resp, err = d.dispatchBeginValidate(req)
	case "DeploymentsClient.BeginValidateAtManagementGroupScope":
		resp, err = d.dispatchBeginValidateAtManagementGroupScope(req)
	case "DeploymentsClient.BeginValidateAtScope":
		resp, err = d.dispatchBeginValidateAtScope(req)
	case "DeploymentsClient.BeginValidateAtSubscriptionScope":
		resp, err = d.dispatchBeginValidateAtSubscriptionScope(req)
	case "DeploymentsClient.BeginValidateAtTenantScope":
		resp, err = d.dispatchBeginValidateAtTenantScope(req)
	case "DeploymentsClient.BeginWhatIf":
		resp, err = d.dispatchBeginWhatIf(req)
	case "DeploymentsClient.BeginWhatIfAtManagementGroupScope":
		resp, err = d.dispatchBeginWhatIfAtManagementGroupScope(req)
	case "DeploymentsClient.BeginWhatIfAtSubscriptionScope":
		resp, err = d.dispatchBeginWhatIfAtSubscriptionScope(req)
	case "DeploymentsClient.BeginWhatIfAtTenantScope":
		resp, err = d.dispatchBeginWhatIfAtTenantScope(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCalculateTemplateHash(req *http.Request) (*http.Response, error) {
	if d.srv.CalculateTemplateHash == nil {
		return nil, &nonRetriableError{errors.New("fake for method CalculateTemplateHash not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[any](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CalculateTemplateHash(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TemplateHashResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCancel(req *http.Request) (*http.Response, error) {
	if d.srv.Cancel == nil {
		return nil, &nonRetriableError{errors.New("fake for method Cancel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Cancel(req.Context(), resourceGroupNameParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCancelAtManagementGroupScope(req *http.Request) (*http.Response, error) {
	if d.srv.CancelAtManagementGroupScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CancelAtManagementGroupScope not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CancelAtManagementGroupScope(req.Context(), groupIDParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCancelAtScope(req *http.Request) (*http.Response, error) {
	if d.srv.CancelAtScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CancelAtScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CancelAtScope(req.Context(), scopeParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCancelAtSubscriptionScope(req *http.Request) (*http.Response, error) {
	if d.srv.CancelAtSubscriptionScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CancelAtSubscriptionScope not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CancelAtSubscriptionScope(req.Context(), deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCancelAtTenantScope(req *http.Request) (*http.Response, error) {
	if d.srv.CancelAtTenantScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CancelAtTenantScope not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CancelAtTenantScope(req.Context(), deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCheckExistence(req *http.Request) (*http.Response, error) {
	if d.srv.CheckExistence == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckExistence not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CheckExistence(req.Context(), resourceGroupNameParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCheckExistenceAtManagementGroupScope(req *http.Request) (*http.Response, error) {
	if d.srv.CheckExistenceAtManagementGroupScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckExistenceAtManagementGroupScope not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CheckExistenceAtManagementGroupScope(req.Context(), groupIDParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCheckExistenceAtScope(req *http.Request) (*http.Response, error) {
	if d.srv.CheckExistenceAtScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckExistenceAtScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CheckExistenceAtScope(req.Context(), scopeParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCheckExistenceAtSubscriptionScope(req *http.Request) (*http.Response, error) {
	if d.srv.CheckExistenceAtSubscriptionScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckExistenceAtSubscriptionScope not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CheckExistenceAtSubscriptionScope(req.Context(), deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchCheckExistenceAtTenantScope(req *http.Request) (*http.Response, error) {
	if d.srv.CheckExistenceAtTenantScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckExistenceAtTenantScope not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CheckExistenceAtTenantScope(req.Context(), deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent, http.StatusNotFound}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent, http.StatusNotFound", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := d.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.Deployment](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		d.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		d.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginCreateOrUpdateAtManagementGroupScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdateAtManagementGroupScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAtManagementGroupScope not implemented")}
	}
	beginCreateOrUpdateAtManagementGroupScope := d.beginCreateOrUpdateAtManagementGroupScope.get(req)
	if beginCreateOrUpdateAtManagementGroupScope == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.ScopedDeployment](req)
		if err != nil {
			return nil, err
		}
		groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdateAtManagementGroupScope(req.Context(), groupIDParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAtManagementGroupScope = &respr
		d.beginCreateOrUpdateAtManagementGroupScope.add(req, beginCreateOrUpdateAtManagementGroupScope)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAtManagementGroupScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginCreateOrUpdateAtManagementGroupScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAtManagementGroupScope) {
		d.beginCreateOrUpdateAtManagementGroupScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginCreateOrUpdateAtScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdateAtScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAtScope not implemented")}
	}
	beginCreateOrUpdateAtScope := d.beginCreateOrUpdateAtScope.get(req)
	if beginCreateOrUpdateAtScope == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.Deployment](req)
		if err != nil {
			return nil, err
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdateAtScope(req.Context(), scopeParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAtScope = &respr
		d.beginCreateOrUpdateAtScope.add(req, beginCreateOrUpdateAtScope)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAtScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginCreateOrUpdateAtScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAtScope) {
		d.beginCreateOrUpdateAtScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginCreateOrUpdateAtSubscriptionScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdateAtSubscriptionScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAtSubscriptionScope not implemented")}
	}
	beginCreateOrUpdateAtSubscriptionScope := d.beginCreateOrUpdateAtSubscriptionScope.get(req)
	if beginCreateOrUpdateAtSubscriptionScope == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.Deployment](req)
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdateAtSubscriptionScope(req.Context(), deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAtSubscriptionScope = &respr
		d.beginCreateOrUpdateAtSubscriptionScope.add(req, beginCreateOrUpdateAtSubscriptionScope)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAtSubscriptionScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginCreateOrUpdateAtSubscriptionScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAtSubscriptionScope) {
		d.beginCreateOrUpdateAtSubscriptionScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginCreateOrUpdateAtTenantScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdateAtTenantScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAtTenantScope not implemented")}
	}
	beginCreateOrUpdateAtTenantScope := d.beginCreateOrUpdateAtTenantScope.get(req)
	if beginCreateOrUpdateAtTenantScope == nil {
		const regexStr = `/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.ScopedDeployment](req)
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdateAtTenantScope(req.Context(), deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAtTenantScope = &respr
		d.beginCreateOrUpdateAtTenantScope.add(req, beginCreateOrUpdateAtTenantScope)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAtTenantScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginCreateOrUpdateAtTenantScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAtTenantScope) {
		d.beginCreateOrUpdateAtTenantScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), resourceGroupNameParam, deploymentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginDeleteAtManagementGroupScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDeleteAtManagementGroupScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteAtManagementGroupScope not implemented")}
	}
	beginDeleteAtManagementGroupScope := d.beginDeleteAtManagementGroupScope.get(req)
	if beginDeleteAtManagementGroupScope == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDeleteAtManagementGroupScope(req.Context(), groupIDParam, deploymentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteAtManagementGroupScope = &respr
		d.beginDeleteAtManagementGroupScope.add(req, beginDeleteAtManagementGroupScope)
	}

	resp, err := server.PollerResponderNext(beginDeleteAtManagementGroupScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDeleteAtManagementGroupScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteAtManagementGroupScope) {
		d.beginDeleteAtManagementGroupScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginDeleteAtScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDeleteAtScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteAtScope not implemented")}
	}
	beginDeleteAtScope := d.beginDeleteAtScope.get(req)
	if beginDeleteAtScope == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDeleteAtScope(req.Context(), scopeParam, deploymentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteAtScope = &respr
		d.beginDeleteAtScope.add(req, beginDeleteAtScope)
	}

	resp, err := server.PollerResponderNext(beginDeleteAtScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDeleteAtScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteAtScope) {
		d.beginDeleteAtScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginDeleteAtSubscriptionScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDeleteAtSubscriptionScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteAtSubscriptionScope not implemented")}
	}
	beginDeleteAtSubscriptionScope := d.beginDeleteAtSubscriptionScope.get(req)
	if beginDeleteAtSubscriptionScope == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDeleteAtSubscriptionScope(req.Context(), deploymentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteAtSubscriptionScope = &respr
		d.beginDeleteAtSubscriptionScope.add(req, beginDeleteAtSubscriptionScope)
	}

	resp, err := server.PollerResponderNext(beginDeleteAtSubscriptionScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDeleteAtSubscriptionScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteAtSubscriptionScope) {
		d.beginDeleteAtSubscriptionScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginDeleteAtTenantScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDeleteAtTenantScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteAtTenantScope not implemented")}
	}
	beginDeleteAtTenantScope := d.beginDeleteAtTenantScope.get(req)
	if beginDeleteAtTenantScope == nil {
		const regexStr = `/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDeleteAtTenantScope(req.Context(), deploymentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteAtTenantScope = &respr
		d.beginDeleteAtTenantScope.add(req, beginDeleteAtTenantScope)
	}

	resp, err := server.PollerResponderNext(beginDeleteAtTenantScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDeleteAtTenantScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteAtTenantScope) {
		d.beginDeleteAtTenantScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchExportTemplate(req *http.Request) (*http.Response, error) {
	if d.srv.ExportTemplate == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExportTemplate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportTemplate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.ExportTemplate(req.Context(), resourceGroupNameParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentExportResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchExportTemplateAtManagementGroupScope(req *http.Request) (*http.Response, error) {
	if d.srv.ExportTemplateAtManagementGroupScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExportTemplateAtManagementGroupScope not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportTemplate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.ExportTemplateAtManagementGroupScope(req.Context(), groupIDParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentExportResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchExportTemplateAtScope(req *http.Request) (*http.Response, error) {
	if d.srv.ExportTemplateAtScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExportTemplateAtScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportTemplate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.ExportTemplateAtScope(req.Context(), scopeParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentExportResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchExportTemplateAtSubscriptionScope(req *http.Request) (*http.Response, error) {
	if d.srv.ExportTemplateAtSubscriptionScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExportTemplateAtSubscriptionScope not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportTemplate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.ExportTemplateAtSubscriptionScope(req.Context(), deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentExportResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchExportTemplateAtTenantScope(req *http.Request) (*http.Response, error) {
	if d.srv.ExportTemplateAtTenantScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExportTemplateAtTenantScope not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportTemplate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.ExportTemplateAtTenantScope(req.Context(), deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentExportResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentExtended, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchGetAtManagementGroupScope(req *http.Request) (*http.Response, error) {
	if d.srv.GetAtManagementGroupScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtManagementGroupScope not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetAtManagementGroupScope(req.Context(), groupIDParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentExtended, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchGetAtScope(req *http.Request) (*http.Response, error) {
	if d.srv.GetAtScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtScope not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetAtScope(req.Context(), scopeParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentExtended, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchGetAtSubscriptionScope(req *http.Request) (*http.Response, error) {
	if d.srv.GetAtSubscriptionScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtSubscriptionScope not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetAtSubscriptionScope(req.Context(), deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentExtended, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchGetAtTenantScope(req *http.Request) (*http.Response, error) {
	if d.srv.GetAtTenantScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtTenantScope not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetAtTenantScope(req.Context(), deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentExtended, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchNewListAtManagementGroupScopePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListAtManagementGroupScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtManagementGroupScopePager not implemented")}
	}
	newListAtManagementGroupScopePager := d.newListAtManagementGroupScopePager.get(req)
	if newListAtManagementGroupScopePager == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armresources.DeploymentsClientListAtManagementGroupScopeOptions
		if filterParam != nil || topParam != nil {
			options = &armresources.DeploymentsClientListAtManagementGroupScopeOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := d.srv.NewListAtManagementGroupScopePager(groupIDParam, options)
		newListAtManagementGroupScopePager = &resp
		d.newListAtManagementGroupScopePager.add(req, newListAtManagementGroupScopePager)
		server.PagerResponderInjectNextLinks(newListAtManagementGroupScopePager, req, func(page *armresources.DeploymentsClientListAtManagementGroupScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAtManagementGroupScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListAtManagementGroupScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtManagementGroupScopePager) {
		d.newListAtManagementGroupScopePager.remove(req)
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchNewListAtScopePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListAtScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtScopePager not implemented")}
	}
	newListAtScopePager := d.newListAtScopePager.get(req)
	if newListAtScopePager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armresources.DeploymentsClientListAtScopeOptions
		if filterParam != nil || topParam != nil {
			options = &armresources.DeploymentsClientListAtScopeOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := d.srv.NewListAtScopePager(scopeParam, options)
		newListAtScopePager = &resp
		d.newListAtScopePager.add(req, newListAtScopePager)
		server.PagerResponderInjectNextLinks(newListAtScopePager, req, func(page *armresources.DeploymentsClientListAtScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAtScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListAtScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtScopePager) {
		d.newListAtScopePager.remove(req)
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchNewListAtSubscriptionScopePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListAtSubscriptionScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtSubscriptionScopePager not implemented")}
	}
	newListAtSubscriptionScopePager := d.newListAtSubscriptionScopePager.get(req)
	if newListAtSubscriptionScopePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armresources.DeploymentsClientListAtSubscriptionScopeOptions
		if filterParam != nil || topParam != nil {
			options = &armresources.DeploymentsClientListAtSubscriptionScopeOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := d.srv.NewListAtSubscriptionScopePager(options)
		newListAtSubscriptionScopePager = &resp
		d.newListAtSubscriptionScopePager.add(req, newListAtSubscriptionScopePager)
		server.PagerResponderInjectNextLinks(newListAtSubscriptionScopePager, req, func(page *armresources.DeploymentsClientListAtSubscriptionScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAtSubscriptionScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListAtSubscriptionScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtSubscriptionScopePager) {
		d.newListAtSubscriptionScopePager.remove(req)
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchNewListAtTenantScopePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListAtTenantScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAtTenantScopePager not implemented")}
	}
	newListAtTenantScopePager := d.newListAtTenantScopePager.get(req)
	if newListAtTenantScopePager == nil {
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armresources.DeploymentsClientListAtTenantScopeOptions
		if filterParam != nil || topParam != nil {
			options = &armresources.DeploymentsClientListAtTenantScopeOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := d.srv.NewListAtTenantScopePager(options)
		newListAtTenantScopePager = &resp
		d.newListAtTenantScopePager.add(req, newListAtTenantScopePager)
		server.PagerResponderInjectNextLinks(newListAtTenantScopePager, req, func(page *armresources.DeploymentsClientListAtTenantScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAtTenantScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListAtTenantScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAtTenantScopePager) {
		d.newListAtTenantScopePager.remove(req)
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := d.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armresources.DeploymentsClientListByResourceGroupOptions
		if filterParam != nil || topParam != nil {
			options = &armresources.DeploymentsClientListByResourceGroupOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := d.srv.NewListByResourceGroupPager(resourceGroupNameParam, options)
		newListByResourceGroupPager = &resp
		d.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armresources.DeploymentsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		d.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginValidate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginValidate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidate not implemented")}
	}
	beginValidate := d.beginValidate.get(req)
	if beginValidate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.Deployment](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginValidate(req.Context(), resourceGroupNameParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidate = &respr
		d.beginValidate.add(req, beginValidate)
	}

	resp, err := server.PollerResponderNext(beginValidate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusBadRequest}, resp.StatusCode) {
		d.beginValidate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusBadRequest", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidate) {
		d.beginValidate.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginValidateAtManagementGroupScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginValidateAtManagementGroupScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateAtManagementGroupScope not implemented")}
	}
	beginValidateAtManagementGroupScope := d.beginValidateAtManagementGroupScope.get(req)
	if beginValidateAtManagementGroupScope == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.ScopedDeployment](req)
		if err != nil {
			return nil, err
		}
		groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginValidateAtManagementGroupScope(req.Context(), groupIDParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateAtManagementGroupScope = &respr
		d.beginValidateAtManagementGroupScope.add(req, beginValidateAtManagementGroupScope)
	}

	resp, err := server.PollerResponderNext(beginValidateAtManagementGroupScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusBadRequest}, resp.StatusCode) {
		d.beginValidateAtManagementGroupScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusBadRequest", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateAtManagementGroupScope) {
		d.beginValidateAtManagementGroupScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginValidateAtScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginValidateAtScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateAtScope not implemented")}
	}
	beginValidateAtScope := d.beginValidateAtScope.get(req)
	if beginValidateAtScope == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.Deployment](req)
		if err != nil {
			return nil, err
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginValidateAtScope(req.Context(), scopeParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateAtScope = &respr
		d.beginValidateAtScope.add(req, beginValidateAtScope)
	}

	resp, err := server.PollerResponderNext(beginValidateAtScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusBadRequest}, resp.StatusCode) {
		d.beginValidateAtScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusBadRequest", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateAtScope) {
		d.beginValidateAtScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginValidateAtSubscriptionScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginValidateAtSubscriptionScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateAtSubscriptionScope not implemented")}
	}
	beginValidateAtSubscriptionScope := d.beginValidateAtSubscriptionScope.get(req)
	if beginValidateAtSubscriptionScope == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.Deployment](req)
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginValidateAtSubscriptionScope(req.Context(), deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateAtSubscriptionScope = &respr
		d.beginValidateAtSubscriptionScope.add(req, beginValidateAtSubscriptionScope)
	}

	resp, err := server.PollerResponderNext(beginValidateAtSubscriptionScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusBadRequest}, resp.StatusCode) {
		d.beginValidateAtSubscriptionScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusBadRequest", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateAtSubscriptionScope) {
		d.beginValidateAtSubscriptionScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginValidateAtTenantScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginValidateAtTenantScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateAtTenantScope not implemented")}
	}
	beginValidateAtTenantScope := d.beginValidateAtTenantScope.get(req)
	if beginValidateAtTenantScope == nil {
		const regexStr = `/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.ScopedDeployment](req)
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginValidateAtTenantScope(req.Context(), deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateAtTenantScope = &respr
		d.beginValidateAtTenantScope.add(req, beginValidateAtTenantScope)
	}

	resp, err := server.PollerResponderNext(beginValidateAtTenantScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusBadRequest}, resp.StatusCode) {
		d.beginValidateAtTenantScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusBadRequest", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateAtTenantScope) {
		d.beginValidateAtTenantScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginWhatIf(req *http.Request) (*http.Response, error) {
	if d.srv.BeginWhatIf == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginWhatIf not implemented")}
	}
	beginWhatIf := d.beginWhatIf.get(req)
	if beginWhatIf == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/whatIf`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.DeploymentWhatIf](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginWhatIf(req.Context(), resourceGroupNameParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginWhatIf = &respr
		d.beginWhatIf.add(req, beginWhatIf)
	}

	resp, err := server.PollerResponderNext(beginWhatIf, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginWhatIf.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginWhatIf) {
		d.beginWhatIf.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginWhatIfAtManagementGroupScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginWhatIfAtManagementGroupScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginWhatIfAtManagementGroupScope not implemented")}
	}
	beginWhatIfAtManagementGroupScope := d.beginWhatIfAtManagementGroupScope.get(req)
	if beginWhatIfAtManagementGroupScope == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<groupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/whatIf`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.ScopedDeploymentWhatIf](req)
		if err != nil {
			return nil, err
		}
		groupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupId")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginWhatIfAtManagementGroupScope(req.Context(), groupIDParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginWhatIfAtManagementGroupScope = &respr
		d.beginWhatIfAtManagementGroupScope.add(req, beginWhatIfAtManagementGroupScope)
	}

	resp, err := server.PollerResponderNext(beginWhatIfAtManagementGroupScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginWhatIfAtManagementGroupScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginWhatIfAtManagementGroupScope) {
		d.beginWhatIfAtManagementGroupScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginWhatIfAtSubscriptionScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginWhatIfAtSubscriptionScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginWhatIfAtSubscriptionScope not implemented")}
	}
	beginWhatIfAtSubscriptionScope := d.beginWhatIfAtSubscriptionScope.get(req)
	if beginWhatIfAtSubscriptionScope == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/whatIf`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.DeploymentWhatIf](req)
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginWhatIfAtSubscriptionScope(req.Context(), deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginWhatIfAtSubscriptionScope = &respr
		d.beginWhatIfAtSubscriptionScope.add(req, beginWhatIfAtSubscriptionScope)
	}

	resp, err := server.PollerResponderNext(beginWhatIfAtSubscriptionScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginWhatIfAtSubscriptionScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginWhatIfAtSubscriptionScope) {
		d.beginWhatIfAtSubscriptionScope.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginWhatIfAtTenantScope(req *http.Request) (*http.Response, error) {
	if d.srv.BeginWhatIfAtTenantScope == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginWhatIfAtTenantScope not implemented")}
	}
	beginWhatIfAtTenantScope := d.beginWhatIfAtTenantScope.get(req)
	if beginWhatIfAtTenantScope == nil {
		const regexStr = `/providers/Microsoft\.Resources/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/whatIf`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armresources.ScopedDeploymentWhatIf](req)
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginWhatIfAtTenantScope(req.Context(), deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginWhatIfAtTenantScope = &respr
		d.beginWhatIfAtTenantScope.add(req, beginWhatIfAtTenantScope)
	}

	resp, err := server.PollerResponderNext(beginWhatIfAtTenantScope, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginWhatIfAtTenantScope.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginWhatIfAtTenantScope) {
		d.beginWhatIfAtTenantScope.remove(req)
	}

	return resp, nil
}
