//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armrecoveryservicessiterecovery_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationJobs_List.json
func ExampleReplicationJobsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewReplicationJobsClient().NewListPager("vault1", "resourceGroupPS1", &armrecoveryservicessiterecovery.ReplicationJobsClientListOptions{Filter: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.JobCollection = armrecoveryservicessiterecovery.JobCollection{
		// 	Value: []*armrecoveryservicessiterecovery.Job{
		// 		{
		// 			Name: to.Ptr("1557d73f-6244-491e-8f0b-d300f752240b"),
		// 			ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationJobs/1557d73f-6244-491e-8f0b-d300f752240b"),
		// 			Properties: &armrecoveryservicessiterecovery.JobProperties{
		// 				AllowedActions: []*string{
		// 				},
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-27T12:46:11.000Z"); return t}()),
		// 				Errors: []*armrecoveryservicessiterecovery.JobErrorDetails{
		// 				},
		// 				FriendlyName: to.Ptr("Create replication policy"),
		// 				ScenarioName: to.Ptr("AddProtectionProfile"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-27T12:46:04.641Z"); return t}()),
		// 				State: to.Ptr("Succeeded"),
		// 				StateDescription: to.Ptr("Completed"),
		// 				TargetInstanceType: to.Ptr("ProtectionProfile"),
		// 				TargetObjectID: to.Ptr("af095a1e-1f1b-5365-87c9-99162ebcfaf0"),
		// 				TargetObjectName: to.Ptr("protectionprofile1"),
		// 				Tasks: []*armrecoveryservicessiterecovery.ASRTask{
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("0236416a-7573-4913-a4a1-6a286fbb1ceb"),
		// 			ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationJobs/0236416a-7573-4913-a4a1-6a286fbb1ceb"),
		// 			Properties: &armrecoveryservicessiterecovery.JobProperties{
		// 				AllowedActions: []*string{
		// 				},
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-02T14:07:21.000Z"); return t}()),
		// 				Errors: []*armrecoveryservicessiterecovery.JobErrorDetails{
		// 				},
		// 				FriendlyName: to.Ptr("Register the Azure Site Recovery Provider"),
		// 				ScenarioName: to.Ptr("RegisterDra"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-02T14:07:19.278Z"); return t}()),
		// 				State: to.Ptr("Succeeded"),
		// 				StateDescription: to.Ptr("Completed"),
		// 				TargetInstanceType: to.Ptr("Server"),
		// 				TargetObjectID: to.Ptr("6d224fc6-f326-5d35-96de-fbf51efb3179"),
		// 				TargetObjectName: to.Ptr("CP-B3L40406-12.ntdev.corp.microsoft.com"),
		// 				Tasks: []*armrecoveryservicessiterecovery.ASRTask{
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("2438d560-80f0-420b-839e-5c8ee0af90a1"),
		// 			ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationJobs/2438d560-80f0-420b-839e-5c8ee0af90a1"),
		// 			Properties: &armrecoveryservicessiterecovery.JobProperties{
		// 				AllowedActions: []*string{
		// 				},
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-02T05:56:16.000Z"); return t}()),
		// 				Errors: []*armrecoveryservicessiterecovery.JobErrorDetails{
		// 				},
		// 				FriendlyName: to.Ptr("Create a site"),
		// 				ScenarioName: to.Ptr("CreateSite"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-02T05:56:14.569Z"); return t}()),
		// 				State: to.Ptr("Succeeded"),
		// 				StateDescription: to.Ptr("Completed"),
		// 				TargetInstanceType: to.Ptr("Server"),
		// 				TargetObjectID: to.Ptr("6d224fc6-f326-5d35-96de-fbf51efb3179"),
		// 				TargetObjectName: to.Ptr("cloud1"),
		// 				Tasks: []*armrecoveryservicessiterecovery.ASRTask{
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationJobs_Get.json
func ExampleReplicationJobsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReplicationJobsClient().Get(ctx, "vault1", "resourceGroupPS1", "58776d0b-3141-48b2-a377-9ad863eb160d", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Job = armrecoveryservicessiterecovery.Job{
	// 	Name: to.Ptr("32ea4b9e-de62-49a1-b062-7864d5c3b897"),
	// 	ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationJobs/32ea4b9e-de62-49a1-b062-7864d5c3b897"),
	// 	Properties: &armrecoveryservicessiterecovery.JobProperties{
	// 		ActivityID: to.Ptr("fc8e9c8f-0e76-4b6b-8e7e-d37c1b31eba0 ActivityId: c506b6ba-0711-411e-8b09-1f3f4dcb824b"),
	// 		AllowedActions: []*string{
	// 		},
	// 		CustomDetails: &armrecoveryservicessiterecovery.AsrJobDetails{
	// 			AffectedObjectDetails: map[string]*string{
	// 				"PrimaryFabricProviderId": to.Ptr("HyperVSite"),
	// 				"PrimaryVmmId": to.Ptr("6d224fc6-f326-5d35-96de-fbf51efb3179"),
	// 				"PrimaryVmmName": to.Ptr("cloud1"),
	// 				"RecoveryFabricProviderId": to.Ptr("Azure"),
	// 				"RecoveryVmmId": to.Ptr("21a9403c-6ec1-44f2-b744-b4e50b792387"),
	// 			},
	// 			InstanceType: to.Ptr("AsrJobDetails"),
	// 		},
	// 		EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-27T11:25:57.000Z"); return t}()),
	// 		Errors: []*armrecoveryservicessiterecovery.JobErrorDetails{
	// 		},
	// 		FriendlyName: to.Ptr("Delete a recovery plan"),
	// 		ScenarioName: to.Ptr("DeleteRecoveryPlan"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-27T11:25:56.800Z"); return t}()),
	// 		State: to.Ptr("Succeeded"),
	// 		StateDescription: to.Ptr("Completed"),
	// 		TargetInstanceType: to.Ptr("RecoveryPlan"),
	// 		TargetObjectID: to.Ptr("966c33bb-66e7-4567-9786-f80b0694f5f9"),
	// 		TargetObjectName: to.Ptr("RPtest1"),
	// 		Tasks: []*armrecoveryservicessiterecovery.ASRTask{
	// 			{
	// 				Name: to.Ptr("DeleteRecoveryPlanTask"),
	// 				AllowedActions: []*string{
	// 				},
	// 				CustomDetails: &armrecoveryservicessiterecovery.ManualActionTaskDetails{
	// 					InstanceType: to.Ptr("ManualActionTaskDetails"),
	// 				},
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-27T11:25:57.318Z"); return t}()),
	// 				Errors: []*armrecoveryservicessiterecovery.JobErrorDetails{
	// 				},
	// 				FriendlyName: to.Ptr("Delete a recovery plan task"),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-27T11:25:57.302Z"); return t}()),
	// 				State: to.Ptr("Succeeded"),
	// 				StateDescription: to.Ptr("Completed"),
	// 				TaskID: to.Ptr("763326a2-01c9-4257-b2a1-0aac56465014"),
	// 				TaskType: to.Ptr("TaskDetails"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationJobs_Cancel.json
func ExampleReplicationJobsClient_BeginCancel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewReplicationJobsClient().BeginCancel(ctx, "vault1", "resourceGroupPS1", "2653c648-fc72-4316-86f3-fdf8eaa0066b", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Job = armrecoveryservicessiterecovery.Job{
	// 	Name: to.Ptr("2653c648-fc72-4316-86f3-fdf8eaa0066b"),
	// 	ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationJobs/2653c648-fc72-4316-86f3-fdf8eaa0066b"),
	// 	Properties: &armrecoveryservicessiterecovery.JobProperties{
	// 		ActivityID: to.Ptr("bfbbf6dd-9cbb-4cbc-98a6-faecc8891579 ActivityId: 07cc35ca-b63f-4e42-83c9-81ae0191c322"),
	// 		AllowedActions: []*string{
	// 		},
	// 		CustomDetails: &armrecoveryservicessiterecovery.AsrJobDetails{
	// 			AffectedObjectDetails: map[string]*string{
	// 				"PrimaryCloudId": to.Ptr("cloud_6d224fc6-f326-5d35-96de-fbf51efb3179"),
	// 				"PrimaryCloudName": to.Ptr("cloud1"),
	// 				"PrimaryFabricProviderId": to.Ptr("HyperVSite"),
	// 				"PrimaryVmId": to.Ptr("f8491e4f-817a-40dd-a90c-af773978c75b"),
	// 				"PrimaryVmName": to.Ptr("vm1"),
	// 				"PrimaryVmmId": to.Ptr("6d224fc6-f326-5d35-96de-fbf51efb3179"),
	// 				"PrimaryVmmName": to.Ptr("cloud1"),
	// 				"ProtectionProfileId": to.Ptr("af095a1e-1f1b-5365-87c9-99162ebcfaf0"),
	// 				"RecoveryCloudId": to.Ptr("d38048d4-b460-4791-8ece-108395ee8478"),
	// 				"RecoveryCloudName": to.Ptr("Microsoft Azure"),
	// 				"RecoveryFabricProviderId": to.Ptr("Azure"),
	// 				"RecoveryVmId": to.Ptr(""),
	// 				"RecoveryVmName": to.Ptr("vm1"),
	// 				"RecoveryVmmId": to.Ptr("21a9403c-6ec1-44f2-b744-b4e50b792387"),
	// 				"RecoveryVmmName": to.Ptr("Microsoft Azure"),
	// 			},
	// 			InstanceType: to.Ptr("AsrJobDetails"),
	// 		},
	// 		Errors: []*armrecoveryservicessiterecovery.JobErrorDetails{
	// 		},
	// 		FriendlyName: to.Ptr("Planned failover"),
	// 		ScenarioName: to.Ptr("PlannedFailover"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-03T06:16:06.323Z"); return t}()),
	// 		State: to.Ptr("Cancelling"),
	// 		StateDescription: to.Ptr("Cancelling"),
	// 		TargetInstanceType: to.Ptr("ProtectionEntity"),
	// 		TargetObjectID: to.Ptr("f8491e4f-817a-40dd-a90c-af773978c75b"),
	// 		TargetObjectName: to.Ptr("vm1"),
	// 		Tasks: []*armrecoveryservicessiterecovery.ASRTask{
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationJobs_Restart.json
func ExampleReplicationJobsClient_BeginRestart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewReplicationJobsClient().BeginRestart(ctx, "vault1", "resourceGroupPS1", "0664564c-353e-401a-ab0c-722257c10e25", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Job = armrecoveryservicessiterecovery.Job{
	// 	Name: to.Ptr("42c7d13b-790c-4609-8e0b-0936f1c5e5fb"),
	// 	ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationJobs/42c7d13b-790c-4609-8e0b-0936f1c5e5fb"),
	// 	Properties: &armrecoveryservicessiterecovery.JobProperties{
	// 		ActivityID: to.Ptr("2443a5b4-e675-499f-8983-4126ea0e232c ActivityId: 2a776896-5e56-470b-af55-3c981283c4bc"),
	// 		AllowedActions: []*string{
	// 		},
	// 		CustomDetails: &armrecoveryservicessiterecovery.AsrJobDetails{
	// 			AffectedObjectDetails: map[string]*string{
	// 			},
	// 			InstanceType: to.Ptr("AsrJobDetails"),
	// 		},
	// 		EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-03T10:45:14.000Z"); return t}()),
	// 		Errors: []*armrecoveryservicessiterecovery.JobErrorDetails{
	// 		},
	// 		FriendlyName: to.Ptr("Restart job"),
	// 		ScenarioName: to.Ptr("RestartJob"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-03T10:45:12.132Z"); return t}()),
	// 		State: to.Ptr("Succeeded"),
	// 		StateDescription: to.Ptr("Completed"),
	// 		TargetInstanceType: to.Ptr("ProtectionEntity"),
	// 		TargetObjectID: to.Ptr("f8491e4f-817a-40dd-a90c-af773978c75b"),
	// 		TargetObjectName: to.Ptr("vm1"),
	// 		Tasks: []*armrecoveryservicessiterecovery.ASRTask{
	// 			{
	// 				Name: to.Ptr("RemediateTask"),
	// 				AllowedActions: []*string{
	// 				},
	// 				CustomDetails: &armrecoveryservicessiterecovery.ManualActionTaskDetails{
	// 					InstanceType: to.Ptr("ManualActionTaskDetails"),
	// 				},
	// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-03T10:45:13.645Z"); return t}()),
	// 				Errors: []*armrecoveryservicessiterecovery.JobErrorDetails{
	// 				},
	// 				FriendlyName: to.Ptr("Restarting job"),
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-03T10:45:13.567Z"); return t}()),
	// 				State: to.Ptr("Succeeded"),
	// 				StateDescription: to.Ptr("Completed"),
	// 				TaskID: to.Ptr("RemediateWfTask"),
	// 				TaskType: to.Ptr("TaskDetails"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationJobs_Resume.json
func ExampleReplicationJobsClient_BeginResume() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewReplicationJobsClient().BeginResume(ctx, "vault1", "resourceGroupPS1", "58776d0b-3141-48b2-a377-9ad863eb160d", armrecoveryservicessiterecovery.ResumeJobParams{
		Properties: &armrecoveryservicessiterecovery.ResumeJobParamsProperties{
			Comments: to.Ptr(" "),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Job = armrecoveryservicessiterecovery.Job{
	// 	Name: to.Ptr("58776d0b-3141-48b2-a377-9ad863eb160d"),
	// 	ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationJobs/58776d0b-3141-48b2-a377-9ad863eb160d"),
	// 	Properties: &armrecoveryservicessiterecovery.JobProperties{
	// 		ActivityID: to.Ptr("1b808dfe-0451-44ac-894c-c7270711cd8c ActivityId: 9f6f849e-922a-43ec-a7a6-0be45fc85c56"),
	// 		AllowedActions: []*string{
	// 			to.Ptr("Cancel"),
	// 			to.Ptr("Resume")},
	// 			CustomDetails: &armrecoveryservicessiterecovery.TestFailoverJobDetails{
	// 				AffectedObjectDetails: map[string]*string{
	// 					"PrimaryCloudId": to.Ptr("cloud_6d224fc6-f326-5d35-96de-fbf51efb3179"),
	// 					"PrimaryCloudName": to.Ptr("cloud1"),
	// 					"PrimaryFabricProviderId": to.Ptr("HyperVSite"),
	// 					"PrimaryVmId": to.Ptr("f8491e4f-817a-40dd-a90c-af773978c75b"),
	// 					"PrimaryVmName": to.Ptr("vm1"),
	// 					"PrimaryVmmId": to.Ptr("6d224fc6-f326-5d35-96de-fbf51efb3179"),
	// 					"PrimaryVmmName": to.Ptr("cloud1"),
	// 					"ProtectionProfileId": to.Ptr("af095a1e-1f1b-5365-87c9-99162ebcfaf0"),
	// 					"RecoveryCloudId": to.Ptr("d38048d4-b460-4791-8ece-108395ee8478"),
	// 					"RecoveryCloudName": to.Ptr("Microsoft Azure"),
	// 					"RecoveryFabricProviderId": to.Ptr("Azure"),
	// 					"RecoveryVmId": to.Ptr(""),
	// 					"RecoveryVmName": to.Ptr("vm1"),
	// 					"RecoveryVmmId": to.Ptr("21a9403c-6ec1-44f2-b744-b4e50b792387"),
	// 					"RecoveryVmmName": to.Ptr("Microsoft Azure"),
	// 				},
	// 				InstanceType: to.Ptr("TestFailoverJobDetails"),
	// 				Comments: to.Ptr(" "),
	// 				NetworkFriendlyName: to.Ptr("vnetavrai"),
	// 				NetworkName: to.Ptr("vnetavrai"),
	// 				NetworkType: to.Ptr("VmNetworkAsInput"),
	// 				ProtectedItemDetails: []*armrecoveryservicessiterecovery.FailoverReplicationProtectedItemDetails{
	// 					{
	// 						Name: to.Ptr("f8491e4f-817a-40dd-a90c-af773978c75b"),
	// 						FriendlyName: to.Ptr("vm1"),
	// 						NetworkConnectionStatus: to.Ptr("Connected"),
	// 						NetworkFriendlyName: to.Ptr("vnetavrai"),
	// 						Subnet: to.Ptr("Subnet1"),
	// 						TestVMFriendlyName: to.Ptr("vm1-test"),
	// 						TestVMName: to.Ptr("vm1-test"),
	// 				}},
	// 				TestFailoverStatus: to.Ptr("Completed"),
	// 			},
	// 			Errors: []*armrecoveryservicessiterecovery.JobErrorDetails{
	// 			},
	// 			FriendlyName: to.Ptr("Test failover"),
	// 			ScenarioName: to.Ptr("TestFailover"),
	// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-25T09:57:57.035Z"); return t}()),
	// 			State: to.Ptr("Suspended"),
	// 			StateDescription: to.Ptr("WaitingForStopTestFailover"),
	// 			TargetInstanceType: to.Ptr("ProtectionEntity"),
	// 			TargetObjectID: to.Ptr("f8491e4f-817a-40dd-a90c-af773978c75b"),
	// 			TargetObjectName: to.Ptr("vm1"),
	// 			Tasks: []*armrecoveryservicessiterecovery.ASRTask{
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationJobs_Export.json
func ExampleReplicationJobsClient_BeginExport() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicessiterecovery.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewReplicationJobsClient().BeginExport(ctx, "vault1", "resourceGroupPS1", armrecoveryservicessiterecovery.JobQueryParameter{
		AffectedObjectTypes: to.Ptr(""),
		EndTime:             to.Ptr("2017-05-04T14:26:51.9161395Z"),
		JobStatus:           to.Ptr(""),
		StartTime:           to.Ptr("2017-04-27T14:26:51.9161395Z"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Job = armrecoveryservicessiterecovery.Job{
	// 	Name: to.Ptr("37e0fc2b-13f2-4817-aafa-0cd807d46842"),
	// 	ID: to.Ptr("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationJobs/37e0fc2b-13f2-4817-aafa-0cd807d46842"),
	// 	Properties: &armrecoveryservicessiterecovery.JobProperties{
	// 		ActivityID: to.Ptr("36841d27-34f6-49ad-b572-e7dc263f100b-2017-05-04 14:26:47Z-Ibz ActivityId: c124df21-7661-4541-b32a-3c723ebbb045"),
	// 		AllowedActions: []*string{
	// 		},
	// 		CustomDetails: &armrecoveryservicessiterecovery.ExportJobDetails{
	// 			AffectedObjectDetails: map[string]*string{
	// 			},
	// 			InstanceType: to.Ptr("ExportJobDetails"),
	// 			BlobURI: to.Ptr("<blobUri>"),
	// 			SasToken: to.Ptr("<sasToken>"),
	// 		},
	// 		EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-04T14:33:43.000Z"); return t}()),
	// 		Errors: []*armrecoveryservicessiterecovery.JobErrorDetails{
	// 		},
	// 		ScenarioName: to.Ptr("ExportJobs"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-04T14:33:42.276Z"); return t}()),
	// 		State: to.Ptr("Succeeded"),
	// 		StateDescription: to.Ptr("Completed"),
	// 		TargetInstanceType: to.Ptr("Other"),
	// 		TargetObjectID: to.Ptr(""),
	// 		TargetObjectName: to.Ptr(""),
	// 		Tasks: []*armrecoveryservicessiterecovery.ASRTask{
	// 		},
	// 	},
	// }
}
