//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armquota

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GroupQuotaSubscriptionAllocationRequestClient contains the methods for the GroupQuotaSubscriptionAllocationRequest group.
// Don't use this type directly, use NewGroupQuotaSubscriptionAllocationRequestClient() instead.
type GroupQuotaSubscriptionAllocationRequestClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewGroupQuotaSubscriptionAllocationRequestClient creates a new instance of GroupQuotaSubscriptionAllocationRequestClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGroupQuotaSubscriptionAllocationRequestClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*GroupQuotaSubscriptionAllocationRequestClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GroupQuotaSubscriptionAllocationRequestClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Request to assign quota from group quota to a specific Subscription. The assign GroupQuota to subscriptions
// or reduce the quota allocated to subscription to give back the unused quota ( quota >=
// usages) to the groupQuota. So, this API can be used to assign Quota to subscriptions and assign back unused quota to group
// quota, which can be assigned to another subscriptions in the GroupQuota.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - resourceName - Resource name.
//   - allocateQuotaRequest - Quota requests payload.
//   - options - GroupQuotaSubscriptionAllocationRequestClientBeginCreateOrUpdateOptions contains the optional parameters for
//     the GroupQuotaSubscriptionAllocationRequestClient.BeginCreateOrUpdate method.
func (client *GroupQuotaSubscriptionAllocationRequestClient) BeginCreateOrUpdate(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, allocateQuotaRequest AllocationRequestStatus, options *GroupQuotaSubscriptionAllocationRequestClientBeginCreateOrUpdateOptions) (*runtime.Poller[GroupQuotaSubscriptionAllocationRequestClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, managementGroupID, groupQuotaName, resourceProviderName, resourceName, allocateQuotaRequest, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GroupQuotaSubscriptionAllocationRequestClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GroupQuotaSubscriptionAllocationRequestClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Request to assign quota from group quota to a specific Subscription. The assign GroupQuota to subscriptions
// or reduce the quota allocated to subscription to give back the unused quota ( quota >=
// usages) to the groupQuota. So, this API can be used to assign Quota to subscriptions and assign back unused quota to group
// quota, which can be assigned to another subscriptions in the GroupQuota.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
func (client *GroupQuotaSubscriptionAllocationRequestClient) createOrUpdate(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, allocateQuotaRequest AllocationRequestStatus, options *GroupQuotaSubscriptionAllocationRequestClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "GroupQuotaSubscriptionAllocationRequestClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, resourceName, allocateQuotaRequest, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *GroupQuotaSubscriptionAllocationRequestClient) createOrUpdateCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, allocateQuotaRequest AllocationRequestStatus, options *GroupQuotaSubscriptionAllocationRequestClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/quotaAllocationRequests/{resourceName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, allocateQuotaRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// Get - Get the quota allocation request status for the subscriptionId by allocationId.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - allocationID - Request Id.
//   - options - GroupQuotaSubscriptionAllocationRequestClientGetOptions contains the optional parameters for the GroupQuotaSubscriptionAllocationRequestClient.Get
//     method.
func (client *GroupQuotaSubscriptionAllocationRequestClient) Get(ctx context.Context, managementGroupID string, groupQuotaName string, allocationID string, options *GroupQuotaSubscriptionAllocationRequestClientGetOptions) (GroupQuotaSubscriptionAllocationRequestClientGetResponse, error) {
	var err error
	const operationName = "GroupQuotaSubscriptionAllocationRequestClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, managementGroupID, groupQuotaName, allocationID, options)
	if err != nil {
		return GroupQuotaSubscriptionAllocationRequestClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GroupQuotaSubscriptionAllocationRequestClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GroupQuotaSubscriptionAllocationRequestClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *GroupQuotaSubscriptionAllocationRequestClient) getCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, allocationID string, options *GroupQuotaSubscriptionAllocationRequestClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocationRequests/{allocationId}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if allocationID == "" {
		return nil, errors.New("parameter allocationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{allocationId}", url.PathEscape(allocationID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *GroupQuotaSubscriptionAllocationRequestClient) getHandleResponse(resp *http.Response) (GroupQuotaSubscriptionAllocationRequestClientGetResponse, error) {
	result := GroupQuotaSubscriptionAllocationRequestClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AllocationRequestStatus); err != nil {
		return GroupQuotaSubscriptionAllocationRequestClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Get all the quotaAllocationRequests for a resourceProvider/location. The filter paramter for location is
// required.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - filter - FIELD SUPPORTED OPERATORS
//     location eq {location}
//     Example: $filter=location eq eastus
//   - options - GroupQuotaSubscriptionAllocationRequestClientListOptions contains the optional parameters for the GroupQuotaSubscriptionAllocationRequestClient.NewListPager
//     method.
func (client *GroupQuotaSubscriptionAllocationRequestClient) NewListPager(managementGroupID string, groupQuotaName string, resourceProviderName string, filter string, options *GroupQuotaSubscriptionAllocationRequestClientListOptions) *runtime.Pager[GroupQuotaSubscriptionAllocationRequestClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[GroupQuotaSubscriptionAllocationRequestClientListResponse]{
		More: func(page GroupQuotaSubscriptionAllocationRequestClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GroupQuotaSubscriptionAllocationRequestClientListResponse) (GroupQuotaSubscriptionAllocationRequestClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GroupQuotaSubscriptionAllocationRequestClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, filter, options)
			}, nil)
			if err != nil {
				return GroupQuotaSubscriptionAllocationRequestClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *GroupQuotaSubscriptionAllocationRequestClient) listCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, filter string, options *GroupQuotaSubscriptionAllocationRequestClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/quotaAllocationRequests"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("$filter", filter)
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *GroupQuotaSubscriptionAllocationRequestClient) listHandleResponse(resp *http.Response) (GroupQuotaSubscriptionAllocationRequestClientListResponse, error) {
	result := GroupQuotaSubscriptionAllocationRequestClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AllocationRequestStatusList); err != nil {
		return GroupQuotaSubscriptionAllocationRequestClientListResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Request to assign quota from group quota to a specific Subscription. The assign GroupQuota to subscriptions
// or reduce the quota allocated to subscription to give back the unused quota ( quota >=
// usages) to the groupQuota. So, this API can be used to assign Quota to subscriptions and assign back unused quota to group
// quota, which can be assigned to another subscriptions in the GroupQuota. User
// can collect unused quotas from multiple subscriptions within the groupQuota and assign the groupQuota to the subscription,
// where it's needed.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - resourceName - Resource name.
//   - allocateQuotaRequest - Quota requests payload.
//   - options - GroupQuotaSubscriptionAllocationRequestClientBeginUpdateOptions contains the optional parameters for the GroupQuotaSubscriptionAllocationRequestClient.BeginUpdate
//     method.
func (client *GroupQuotaSubscriptionAllocationRequestClient) BeginUpdate(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, allocateQuotaRequest AllocationRequestStatus, options *GroupQuotaSubscriptionAllocationRequestClientBeginUpdateOptions) (*runtime.Poller[GroupQuotaSubscriptionAllocationRequestClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, managementGroupID, groupQuotaName, resourceProviderName, resourceName, allocateQuotaRequest, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GroupQuotaSubscriptionAllocationRequestClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GroupQuotaSubscriptionAllocationRequestClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Request to assign quota from group quota to a specific Subscription. The assign GroupQuota to subscriptions or
// reduce the quota allocated to subscription to give back the unused quota ( quota >=
// usages) to the groupQuota. So, this API can be used to assign Quota to subscriptions and assign back unused quota to group
// quota, which can be assigned to another subscriptions in the GroupQuota. User
// can collect unused quotas from multiple subscriptions within the groupQuota and assign the groupQuota to the subscription,
// where it's needed.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
func (client *GroupQuotaSubscriptionAllocationRequestClient) update(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, allocateQuotaRequest AllocationRequestStatus, options *GroupQuotaSubscriptionAllocationRequestClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "GroupQuotaSubscriptionAllocationRequestClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, resourceName, allocateQuotaRequest, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *GroupQuotaSubscriptionAllocationRequestClient) updateCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, resourceName string, allocateQuotaRequest AllocationRequestStatus, options *GroupQuotaSubscriptionAllocationRequestClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/quotaAllocationRequests/{resourceName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, allocateQuotaRequest); err != nil {
		return nil, err
	}
	return req, nil
}
