//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armquota_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/quota/armquota"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/GroupQuotaLimitsRequests/PutGroupQuotaLimitsRequests-Compute.json
func ExampleGroupQuotaLimitsRequestClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewGroupQuotaLimitsRequestClient().BeginCreateOrUpdate(ctx, "E7EC67B3-7657-4966-BFFC-41EFD36BAA09", "groupquota1", "Microsoft.Compute", "standardav2family", &armquota.GroupQuotaLimitsRequestClientBeginCreateOrUpdateOptions{GroupQuotaRequest: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SubmittedResourceRequestStatus = armquota.SubmittedResourceRequestStatus{
	// 	Name: to.Ptr("requestId1"),
	// 	Type: to.Ptr("Microsoft.Quota/groupQuotas/groupQuotaLimitsRequests"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/E7EC67B3-7657-4966-BFFC-41EFD36BAA09/providers/Microsoft.Quota/groupQuotas/groupquota1/resourceProviders/Microsoft.Compute/groupQuotaLimitsRequests/requestId1"),
	// 	Properties: &armquota.SubmittedResourceRequestStatusProperties{
	// 		ProvisioningState: to.Ptr(armquota.RequestStateSucceeded),
	// 		RequestSubmitTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2024-03-08T12:09:27.978Z"); return t}()),
	// 		RequestedResource: &armquota.GroupQuotaRequestBase{
	// 			Properties: &armquota.GroupQuotaRequestBaseProperties{
	// 				Name: &armquota.GroupQuotaRequestBasePropertiesName{
	// 					LocalizedValue: to.Ptr("Standard AV2 Family vCPUs"),
	// 					Value: to.Ptr("standardav2family"),
	// 				},
	// 				Comments: to.Ptr("Contoso requires more quota."),
	// 				Limit: to.Ptr[int64](100),
	// 				Region: to.Ptr("westus"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/GroupQuotaLimitsRequests/PatchGroupQuotaLimitsRequests-Compute.json
func ExampleGroupQuotaLimitsRequestClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewGroupQuotaLimitsRequestClient().BeginUpdate(ctx, "E7EC67B3-7657-4966-BFFC-41EFD36BAA09", "groupquota1", "Microsoft.Compute", "standardav2family", &armquota.GroupQuotaLimitsRequestClientBeginUpdateOptions{GroupQuotaRequest: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SubmittedResourceRequestStatus = armquota.SubmittedResourceRequestStatus{
	// 	Name: to.Ptr("requestId1"),
	// 	Type: to.Ptr("Microsoft.Quota/groupQuotas/groupQuotaLimitsRequests"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/E7EC67B3-7657-4966-BFFC-41EFD36BAA09/providers/Microsoft.Quota/groupQuotas/groupquota1/resourceProviders/Microsoft.Compute/groupQuotaLimitsRequests/requestId1"),
	// 	Properties: &armquota.SubmittedResourceRequestStatusProperties{
	// 		ProvisioningState: to.Ptr(armquota.RequestStateSucceeded),
	// 		RequestSubmitTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2024-03-08T12:09:27.978Z"); return t}()),
	// 		RequestedResource: &armquota.GroupQuotaRequestBase{
	// 			Properties: &armquota.GroupQuotaRequestBaseProperties{
	// 				Name: &armquota.GroupQuotaRequestBasePropertiesName{
	// 					LocalizedValue: to.Ptr("Standard AV2 Family vCPUs"),
	// 					Value: to.Ptr("standardav2family"),
	// 				},
	// 				Comments: to.Ptr("Contoso requires more quota."),
	// 				Limit: to.Ptr[int64](100),
	// 				Region: to.Ptr("westus"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/GroupQuotaLimitsRequests/GroupQuotaLimitsRequests_Get.json
func ExampleGroupQuotaLimitsRequestClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewGroupQuotaLimitsRequestClient().Get(ctx, "E7EC67B3-7657-4966-BFFC-41EFD36BAA09", "groupquota1", "requestId", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SubmittedResourceRequestStatus = armquota.SubmittedResourceRequestStatus{
	// 	Name: to.Ptr("requestId"),
	// 	Type: to.Ptr("Microsoft.Quota/groupQuotas/groupQuotaLimitsRequests"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/E7EC67B3-7657-4966-BFFC-41EFD36BAA09/providers/Microsoft.Quota/groupQuotas/groupquota1/resourceProviders/Microsoft.Compute/groupQuotaLimitsRequests/requestId"),
	// 	Properties: &armquota.SubmittedResourceRequestStatusProperties{
	// 		FaultCode: to.Ptr("ResourceNotAvailableForOffer"),
	// 		ProvisioningState: to.Ptr(armquota.RequestStateSucceeded),
	// 		RequestSubmitTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2024-03-20T05:29:34.144Z"); return t}()),
	// 		RequestedResource: &armquota.GroupQuotaRequestBase{
	// 			Properties: &armquota.GroupQuotaRequestBaseProperties{
	// 				Name: &armquota.GroupQuotaRequestBasePropertiesName{
	// 					LocalizedValue: to.Ptr("standard DDv4 Family vCPUs"),
	// 					Value: to.Ptr("standardddv4family"),
	// 				},
	// 				Comments: to.Ptr(""),
	// 				Limit: to.Ptr[int64](100),
	// 				Region: to.Ptr("westus"),
	// 			},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/GroupQuotaLimitsRequests/GroupQuotaLimitsRequests_List.json
func ExampleGroupQuotaLimitsRequestClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewGroupQuotaLimitsRequestClient().NewListPager("E7EC67B3-7657-4966-BFFC-41EFD36BAA09", "groupquota1", "Microsoft.Compute", "location eq westus", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SubmittedResourceRequestStatusList = armquota.SubmittedResourceRequestStatusList{
		// 	Value: []*armquota.SubmittedResourceRequestStatus{
		// 		{
		// 			Name: to.Ptr("requestId1"),
		// 			Type: to.Ptr("Microsoft.Quota/groupQuotas/groupQuotaLimitsRequests"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/E7EC67B3-7657-4966-BFFC-41EFD36BAA09/providers/Microsoft.Quota/groupQuotas/groupquota1/resourceProviders/Microsoft.Compute/groupQuotaLimitsRequests/requestId1"),
		// 			Properties: &armquota.SubmittedResourceRequestStatusProperties{
		// 				FaultCode: to.Ptr("ResourceNotAvailableForOffer"),
		// 				ProvisioningState: to.Ptr(armquota.RequestStateSucceeded),
		// 				RequestSubmitTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-18T00:12:34.004Z"); return t}()),
		// 				RequestedResource: &armquota.GroupQuotaRequestBase{
		// 					Properties: &armquota.GroupQuotaRequestBaseProperties{
		// 						Name: &armquota.GroupQuotaRequestBasePropertiesName{
		// 							LocalizedValue: to.Ptr("standard DDv4 Family vCPUs"),
		// 							Value: to.Ptr("standardddv4family"),
		// 						},
		// 						Comments: to.Ptr("Contoso requires more quota."),
		// 						Limit: to.Ptr[int64](100),
		// 						Region: to.Ptr("westus"),
		// 					},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("requestId2"),
		// 			Type: to.Ptr("Microsoft.Quota/groupQuotas/groupQuotaLimitsRequests"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/E7EC67B3-7657-4966-BFFC-41EFD36BAA09/providers/Microsoft.Quota/groupQuotas/groupquota1/resourceProviders/Microsoft.Compute/groupQuotaLimitsRequests/requestId2"),
		// 			Properties: &armquota.SubmittedResourceRequestStatusProperties{
		// 				FaultCode: to.Ptr(""),
		// 				ProvisioningState: to.Ptr(armquota.RequestStateSucceeded),
		// 				RequestSubmitTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-11-17T00:57:43.410Z"); return t}()),
		// 				RequestedResource: &armquota.GroupQuotaRequestBase{
		// 					Properties: &armquota.GroupQuotaRequestBaseProperties{
		// 						Name: &armquota.GroupQuotaRequestBasePropertiesName{
		// 							LocalizedValue: to.Ptr("standardav2family"),
		// 							Value: to.Ptr("standardav2family"),
		// 						},
		// 						Comments: to.Ptr("Contoso requires more quota."),
		// 						Limit: to.Ptr[int64](150),
		// 						Region: to.Ptr("westus"),
		// 					},
		// 				},
		// 			},
		// 	}},
		// }
	}
}
