//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armquota

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/quota/armquota"
	moduleVersion = "v1.1.0-beta.1"
)

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// EnforcementState - Enforcement status.
type EnforcementState string

const (
	EnforcementStateDisabled     EnforcementState = "Disabled"
	EnforcementStateEnabled      EnforcementState = "Enabled"
	EnforcementStateNotAvailable EnforcementState = "NotAvailable"
)

// PossibleEnforcementStateValues returns the possible values for the EnforcementState const type.
func PossibleEnforcementStateValues() []EnforcementState {
	return []EnforcementState{
		EnforcementStateDisabled,
		EnforcementStateEnabled,
		EnforcementStateNotAvailable,
	}
}

// EnvironmentType - Environment name.
type EnvironmentType string

const (
	EnvironmentTypeNonProduction EnvironmentType = "NonProduction"
	EnvironmentTypeProduction    EnvironmentType = "Production"
)

// PossibleEnvironmentTypeValues returns the possible values for the EnvironmentType const type.
func PossibleEnvironmentTypeValues() []EnvironmentType {
	return []EnvironmentType{
		EnvironmentTypeNonProduction,
		EnvironmentTypeProduction,
	}
}

// GroupingIDType - GroupingId type. It is a required property. More types of groupIds can be supported in future.
type GroupingIDType string

const (
	GroupingIDTypeBillingID     GroupingIDType = "BillingId"
	GroupingIDTypeServiceTreeID GroupingIDType = "ServiceTreeId"
)

// PossibleGroupingIDTypeValues returns the possible values for the GroupingIDType const type.
func PossibleGroupingIDTypeValues() []GroupingIDType {
	return []GroupingIDType{
		GroupingIDTypeBillingID,
		GroupingIDTypeServiceTreeID,
	}
}

// LimitType - The limit object type.
type LimitType string

const (
	LimitTypeLimitValue LimitType = "LimitValue"
)

// PossibleLimitTypeValues returns the possible values for the LimitType const type.
func PossibleLimitTypeValues() []LimitType {
	return []LimitType{
		LimitTypeLimitValue,
	}
}

// QuotaLimitTypes - The quota or usages limit types.
type QuotaLimitTypes string

const (
	QuotaLimitTypesIndependent QuotaLimitTypes = "Independent"
	QuotaLimitTypesShared      QuotaLimitTypes = "Shared"
)

// PossibleQuotaLimitTypesValues returns the possible values for the QuotaLimitTypes const type.
func PossibleQuotaLimitTypesValues() []QuotaLimitTypes {
	return []QuotaLimitTypes{
		QuotaLimitTypesIndependent,
		QuotaLimitTypesShared,
	}
}

// QuotaRequestState - Quota request status.
type QuotaRequestState string

const (
	QuotaRequestStateAccepted   QuotaRequestState = "Accepted"
	QuotaRequestStateFailed     QuotaRequestState = "Failed"
	QuotaRequestStateInProgress QuotaRequestState = "InProgress"
	QuotaRequestStateInvalid    QuotaRequestState = "Invalid"
	QuotaRequestStateSucceeded  QuotaRequestState = "Succeeded"
)

// PossibleQuotaRequestStateValues returns the possible values for the QuotaRequestState const type.
func PossibleQuotaRequestStateValues() []QuotaRequestState {
	return []QuotaRequestState{
		QuotaRequestStateAccepted,
		QuotaRequestStateFailed,
		QuotaRequestStateInProgress,
		QuotaRequestStateInvalid,
		QuotaRequestStateSucceeded,
	}
}

// RequestState - Request status.
type RequestState string

const (
	RequestStateAccepted   RequestState = "Accepted"
	RequestStateCanceled   RequestState = "Canceled"
	RequestStateCreated    RequestState = "Created"
	RequestStateFailed     RequestState = "Failed"
	RequestStateInProgress RequestState = "InProgress"
	RequestStateInvalid    RequestState = "Invalid"
	RequestStateSucceeded  RequestState = "Succeeded"
)

// PossibleRequestStateValues returns the possible values for the RequestState const type.
func PossibleRequestStateValues() []RequestState {
	return []RequestState{
		RequestStateAccepted,
		RequestStateCanceled,
		RequestStateCreated,
		RequestStateFailed,
		RequestStateInProgress,
		RequestStateInvalid,
		RequestStateSucceeded,
	}
}

// UsagesTypes - The quota or usages limit types.
type UsagesTypes string

const (
	UsagesTypesCombined   UsagesTypes = "Combined"
	UsagesTypesIndividual UsagesTypes = "Individual"
)

// PossibleUsagesTypesValues returns the possible values for the UsagesTypes const type.
func PossibleUsagesTypesValues() []UsagesTypes {
	return []UsagesTypes{
		UsagesTypesCombined,
		UsagesTypesIndividual,
	}
}
