//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armquota_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/quota/armquota"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getComputeOneSkuQuotaLimit.json
func ExampleClient_Get_quotasGetRequestForCompute() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Get(ctx, "standardNDSFamily", "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armquota.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("standardNDSFamily"),
	// 	Type: to.Ptr("Microsoft.Quota/Quotas"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardNDSFamily"),
	// 	Properties: &armquota.Properties{
	// 		Name: &armquota.ResourceName{
	// 			LocalizedValue: to.Ptr("Standard NDS Family vCPUs"),
	// 			Value: to.Ptr("standardNDSFamily"),
	// 		},
	// 		IsQuotaApplicable: to.Ptr(true),
	// 		Limit: &armquota.LimitObject{
	// 			LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
	// 			LimitType: to.Ptr(armquota.QuotaLimitTypesIndependent),
	// 			Value: to.Ptr[int32](100),
	// 		},
	// 		Unit: to.Ptr("Count"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getNetworkOneSkuQuotaLimit.json
func ExampleClient_Get_quotasUsagesRequestForNetwork() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Get(ctx, "MinPublicIpInterNetworkPrefixLength", "subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armquota.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
	// 	Type: to.Ptr("Microsoft.Quota/Quotas"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/MinPublicIpInterNetworkPrefixLength"),
	// 	Properties: &armquota.Properties{
	// 		Name: &armquota.ResourceName{
	// 			LocalizedValue: to.Ptr("Min Public Ip InterNetwork Prefix Length"),
	// 			Value: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
	// 		},
	// 		IsQuotaApplicable: to.Ptr(true),
	// 		Limit: &armquota.LimitObject{
	// 			LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
	// 			Value: to.Ptr[int32](10),
	// 		},
	// 		ResourceType: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
	// 		Unit: to.Ptr("Count"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/putNetworkOneSkuQuotaRequest.json
func ExampleClient_BeginCreateOrUpdate_quotasPutRequestForNetwork() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreateOrUpdate(ctx, "MinPublicIpInterNetworkPrefixLength", "subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Network/locations/eastus", armquota.CurrentQuotaLimitBase{
		Properties: &armquota.Properties{
			Name: &armquota.ResourceName{
				Value: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
			},
			Limit: &armquota.LimitObject{
				LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
				Value:           to.Ptr[int32](10),
			},
			ResourceType: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armquota.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Type: to.Ptr("Microsoft.Quota/quotas"),
	// 	ID: to.Ptr("/subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/quotaRequests/2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Properties: &armquota.Properties{
	// 		Name: &armquota.ResourceName{
	// 			Value: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
	// 		},
	// 		Limit: &armquota.LimitObject{
	// 			LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
	// 			Value: to.Ptr[int32](10),
	// 		},
	// 		ResourceType: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/putNetworkOneSkuQuotaRequestStandardSkuPublicIpAddresses.json
func ExampleClient_BeginCreateOrUpdate_quotasPutRequestForNetworkStandardSkuPublicIpAddressesResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreateOrUpdate(ctx, "StandardSkuPublicIpAddresses", "subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Network/locations/eastus", armquota.CurrentQuotaLimitBase{
		Properties: &armquota.Properties{
			Name: &armquota.ResourceName{
				Value: to.Ptr("StandardSkuPublicIpAddresses"),
			},
			Limit: &armquota.LimitObject{
				LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
				Value:           to.Ptr[int32](10),
			},
			ResourceType: to.Ptr("PublicIpAddresses"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armquota.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Type: to.Ptr("Microsoft.Quota/quotas"),
	// 	ID: to.Ptr("/subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/quotaRequests/2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Properties: &armquota.Properties{
	// 		Name: &armquota.ResourceName{
	// 			Value: to.Ptr("StandardSkuPublicIpAddresses"),
	// 		},
	// 		Limit: &armquota.LimitObject{
	// 			LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
	// 			Value: to.Ptr[int32](10),
	// 		},
	// 		ResourceType: to.Ptr("PublicIpAddresses"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/putComputeOneSkuQuotaRequest.json
func ExampleClient_BeginCreateOrUpdate_quotasPutRequestForCompute() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreateOrUpdate(ctx, "standardFSv2Family", "subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Compute/locations/eastus", armquota.CurrentQuotaLimitBase{
		Properties: &armquota.Properties{
			Name: &armquota.ResourceName{
				Value: to.Ptr("standardFSv2Family"),
			},
			Limit: &armquota.LimitObject{
				LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
				Value:           to.Ptr[int32](10),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armquota.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("standardFSv2Family"),
	// 	Type: to.Ptr("Microsoft.Quota/quotas"),
	// 	ID: to.Ptr("/subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/quotas/standardFSv2Family"),
	// 	Properties: &armquota.Properties{
	// 		Name: &armquota.ResourceName{
	// 			Value: to.Ptr("standardFSv2Family"),
	// 		},
	// 		Limit: &armquota.LimitObject{
	// 			LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
	// 			Value: to.Ptr[int32](10),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/putMachineLearningServicesQuotaRequestLowPriority.json
func ExampleClient_BeginCreateOrUpdate_quotasRequestForMachineLearningServicesLowPriorityResource() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreateOrUpdate(ctx, "TotalLowPriorityCores", "subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.MachineLearningServices/locations/eastus", armquota.CurrentQuotaLimitBase{
		Properties: &armquota.Properties{
			Name: &armquota.ResourceName{
				Value: to.Ptr("TotalLowPriorityCores"),
			},
			Limit: &armquota.LimitObject{
				LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
				Value:           to.Ptr[int32](10),
			},
			ResourceType: to.Ptr("lowPriority"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armquota.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("TotalLowPriorityCores"),
	// 	Type: to.Ptr("Microsoft.Quota/quotas"),
	// 	ID: to.Ptr("/subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.MachineLearningServices/locations/eastus/providers/Microsoft.Quota/quotas/TotalLowPriorityCores"),
	// 	Properties: &armquota.Properties{
	// 		Name: &armquota.ResourceName{
	// 			Value: to.Ptr("TotalLowPriorityCores"),
	// 		},
	// 		Limit: &armquota.LimitObject{
	// 			LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
	// 			Value: to.Ptr[int32](10),
	// 		},
	// 		ResourceType: to.Ptr("lowPriority"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/patchComputeQuotaRequest.json
func ExampleClient_BeginUpdate_quotasRequestPatchForCompute() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginUpdate(ctx, "standardFSv2Family", "subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Compute/locations/eastus", armquota.CurrentQuotaLimitBase{
		Properties: &armquota.Properties{
			Name: &armquota.ResourceName{
				Value: to.Ptr("standardFSv2Family"),
			},
			Limit: &armquota.LimitObject{
				LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
				Value:           to.Ptr[int32](10),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armquota.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("standardFSv2Family"),
	// 	Type: to.Ptr("Microsoft.Quota/quotas"),
	// 	ID: to.Ptr("/subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/quotas/standardFSv2Family"),
	// 	Properties: &armquota.Properties{
	// 		Name: &armquota.ResourceName{
	// 			LocalizedValue: to.Ptr("Standard FSv2 Family vCPUs"),
	// 			Value: to.Ptr("standardFSv2Family"),
	// 		},
	// 		Limit: &armquota.LimitObject{
	// 			LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
	// 			Value: to.Ptr[int32](10),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/patchNetworkOneSkuQuotaRequest.json
func ExampleClient_BeginUpdate_quotasRequestPatchForNetwork() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginUpdate(ctx, "MinPublicIpInterNetworkPrefixLength", "subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Network/locations/eastus", armquota.CurrentQuotaLimitBase{
		Properties: &armquota.Properties{
			Name: &armquota.ResourceName{
				Value: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
			},
			Limit: &armquota.LimitObject{
				LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
				Value:           to.Ptr[int32](10),
			},
			ResourceType: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CurrentQuotaLimitBase = armquota.CurrentQuotaLimitBase{
	// 	Name: to.Ptr("2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Type: to.Ptr("Microsoft.Quota/quotas"),
	// 	ID: to.Ptr("/subscriptions/D7EC67B3-7657-4966-BFFC-41EFD36BAAB3/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/quotaRequests/2B5C8515-37D8-4B6A-879B-CD641A2CF605"),
	// 	Properties: &armquota.Properties{
	// 		Name: &armquota.ResourceName{
	// 			Value: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
	// 		},
	// 		Limit: &armquota.LimitObject{
	// 			LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
	// 			Value: to.Ptr[int32](10),
	// 		},
	// 		ResourceType: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getComputeQuotaLimits.json
func ExampleClient_NewListPager_quotasListQuotaLimitsForCompute() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.Limits = armquota.Limits{
		// 	Value: []*armquota.CurrentQuotaLimitBase{
		// 		{
		// 			Name: to.Ptr("standardFSv2Family"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardFSv2Family"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard FSv2 Family vCPUs"),
		// 					Value: to.Ptr("standardFSv2Family"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standardNDSFamily"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardNDSFamily"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard NDS Family vCPUs"),
		// 					Value: to.Ptr("standardNDSFamily"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standardNCSv2Family"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardNCSv2Family"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard NCSv2 Family vCPUs"),
		// 					Value: to.Ptr("standardNCSv2Family"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standardNCSv3Family"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardNCSv3Family"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard NCSv3 Family vCPUs"),
		// 					Value: to.Ptr("standardNCSv3Family"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standardLSv2Family"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardLSv2Family"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard LSv2 Family vCPUs"),
		// 					Value: to.Ptr("standardLSv2Family"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standardPBSFamily"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardPBSFamily"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard PBS Family vCPUs"),
		// 					Value: to.Ptr("standardPBSFamily"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standardEIv3Family"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardEIv3Family"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard EIv3 Family vCPUs"),
		// 					Value: to.Ptr("standardEIv3Family"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standardEISv3Family"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardEISv3Family"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard EISv3 Family vCPUs"),
		// 					Value: to.Ptr("standardEISv3Family"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standardDCSFamily"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardDCSFamily"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard DCS Family vCPUs"),
		// 					Value: to.Ptr("standardDCSFamily"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standardNVSv2Family"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardNVSv2Family"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard NVSv2 Family vCPUs"),
		// 					Value: to.Ptr("standardNVSv2Family"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standardMSv2Family"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/standardMSv2Family"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard MSv2 Family vCPUs"),
		// 					Value: to.Ptr("standardMSv2Family"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("availabilitySets"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Compute/locations/eastus/providers/Microsoft.Quota/Quotas/availabilitySets"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Availability Sets"),
		// 					Value: to.Ptr("availabilitySets"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getNetworkQuotaLimits.json
func ExampleClient_NewListPager_quotasListQuotaLimitsForNetwork() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.Limits = armquota.Limits{
		// 	Value: []*armquota.CurrentQuotaLimitBase{
		// 		{
		// 			Name: to.Ptr("VirtualNetworks"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Virtual Networks"),
		// 					Value: to.Ptr("VirtualNetworks"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("StaticPublicIPAddresses"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Static Public IP Addresses"),
		// 					Value: to.Ptr("StaticPublicIPAddresses"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("NetworkSecurityGroups"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Network Security Groups"),
		// 					Value: to.Ptr("NetworkSecurityGroups"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PublicIPAddresses"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Public IP Addresses - Basic"),
		// 					Value: to.Ptr("PublicIPAddresses"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PublicIpPrefixes"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Public Ip Prefixes"),
		// 					Value: to.Ptr("PublicIpPrefixes"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("NatGateways"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Nat Gateways"),
		// 					Value: to.Ptr("NatGateways"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("NetworkInterfaces"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Network Interfaces"),
		// 					Value: to.Ptr("NetworkInterfaces"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PrivateEndpoints"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Private Endpoints"),
		// 					Value: to.Ptr("PrivateEndpoints"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PrivateEndpointRedirectMaps"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Private Endpoint Redirect Maps"),
		// 					Value: to.Ptr("PrivateEndpointRedirectMaps"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("LoadBalancers"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Load Balancers"),
		// 					Value: to.Ptr("LoadBalancers"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PrivateLinkServices"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Private Link Services"),
		// 					Value: to.Ptr("PrivateLinkServices"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ApplicationGateways"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Application Gateways"),
		// 					Value: to.Ptr("ApplicationGateways"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("RouteTables"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Route Tables"),
		// 					Value: to.Ptr("RouteTables"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("RouteFilters"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Route Filters"),
		// 					Value: to.Ptr("RouteFilters"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("NetworkWatchers"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Network Watchers"),
		// 					Value: to.Ptr("NetworkWatchers"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PacketCaptures"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Packet Captures"),
		// 					Value: to.Ptr("PacketCaptures"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ApplicationSecurityGroups"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Application Security Groups."),
		// 					Value: to.Ptr("ApplicationSecurityGroups"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("DdosProtectionPlans"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("DDoS Protection Plans."),
		// 					Value: to.Ptr("DdosProtectionPlans"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("DdosCustomPolicies"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("DDoS customized policies"),
		// 					Value: to.Ptr("DdosCustomPolicies"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ServiceEndpointPolicies"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Service Endpoint Policies"),
		// 					Value: to.Ptr("ServiceEndpointPolicies"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("NetworkIntentPolicies"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Network Intent Policies"),
		// 					Value: to.Ptr("NetworkIntentPolicies"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("StandardSkuLoadBalancers"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard Sku Load Balancers"),
		// 					Value: to.Ptr("StandardSkuLoadBalancers"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("StandardSkuPublicIpAddresses"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Public IP Addresses - Standard"),
		// 					Value: to.Ptr("StandardSkuPublicIpAddresses"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("DnsServersPerVirtualNetwork"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("DNS servers per Virtual Network"),
		// 					Value: to.Ptr("DnsServersPerVirtualNetwork"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("CustomDnsServersPerP2SVpnGateway"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Custom DNS servers per P2SVpnGateway"),
		// 					Value: to.Ptr("CustomDnsServersPerP2SVpnGateway"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SubnetsPerVirtualNetwork"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Subnets per Virtual Network"),
		// 					Value: to.Ptr("SubnetsPerVirtualNetwork"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("IPConfigurationsPerVirtualNetwork"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("IP Configurations per Virtual Network"),
		// 					Value: to.Ptr("IPConfigurationsPerVirtualNetwork"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("PeeringsPerVirtualNetwork"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Peerings per Virtual Network"),
		// 					Value: to.Ptr("PeeringsPerVirtualNetwork"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SecurityRulesPerNetworkSecurityGroup"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Security rules per Network Security Group"),
		// 					Value: to.Ptr("SecurityRulesPerNetworkSecurityGroup"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SecurityRulesPerNetworkIntentPolicy"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Security rules per Network Intent Policy"),
		// 					Value: to.Ptr("SecurityRulesPerNetworkIntentPolicy"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("RoutesPerNetworkIntentPolicy"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Routes per Network Intent Policy"),
		// 					Value: to.Ptr("RoutesPerNetworkIntentPolicy"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SecurityRuleAddressesOrPortsPerNetworkSecurityGroup"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Security rules addresses or ports per Network Security Group"),
		// 					Value: to.Ptr("SecurityRuleAddressesOrPortsPerNetworkSecurityGroup"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("InboundRulesPerLoadBalancer"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Inbound Rules per Load Balancer"),
		// 					Value: to.Ptr("InboundRulesPerLoadBalancer"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("FrontendIPConfigurationPerLoadBalancer"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Frontend IP Configurations per Load Balancer"),
		// 					Value: to.Ptr("FrontendIPConfigurationPerLoadBalancer"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("OutboundRulesPerLoadBalancer"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Outbound Rules per Load Balancer"),
		// 					Value: to.Ptr("OutboundRulesPerLoadBalancer"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("RoutesPerRouteTable"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Routes per Route Table"),
		// 					Value: to.Ptr("RoutesPerRouteTable"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("RoutesWithServiceTagPerRouteTable"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Routes with service tag per Route Table"),
		// 					Value: to.Ptr("RoutesWithServiceTagPerRouteTable"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(false),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Network/locations/eastus/providers/Microsoft.Quota/Quotas/"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Min Public Ip InterNetwork Prefix Length"),
		// 					Value: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
		// 				},
		// 				IsQuotaApplicable: to.Ptr(true),
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				Properties: map[string]any{
		// 				},
		// 				ResourceType: to.Ptr("MinPublicIpInterNetworkPrefixLength"),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/106483d9f698ac3b6c0d481ab0c5fab14152e21f/specification/quota/resource-manager/Microsoft.Quota/preview/2023-06-01-preview/examples/getMachineLearningServicesQuotaLimits.json
func ExampleClient_NewListPager_quotasListQuotaLimitsMachineLearningServices() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armquota.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.MachineLearningServices/locations/eastus", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.Limits = armquota.Limits{
		// 	Value: []*armquota.CurrentQuotaLimitBase{
		// 		{
		// 			Name: to.Ptr("standardDv2Family"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.MachineLearningServices/locations/eastus/providers/Microsoft.Quota/Quotas/standardDv2Family"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Standard Dv2 Family vCPUs"),
		// 					Value: to.Ptr("standardDv2Family"),
		// 				},
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				ResourceType: to.Ptr("dedicated"),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("totalLowPriorityCores"),
		// 			Type: to.Ptr("Microsoft.Quota/Quotas"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.MachineLearningServices/locations/eastus/providers/Microsoft.Quota/Quotas/totalLowPriorityCores"),
		// 			Properties: &armquota.Properties{
		// 				Name: &armquota.ResourceName{
		// 					LocalizedValue: to.Ptr("Total Regional Low-priority vCPUs"),
		// 					Value: to.Ptr("totalLowPriorityCores"),
		// 				},
		// 				Limit: &armquota.LimitObject{
		// 					LimitObjectType: to.Ptr(armquota.LimitTypeLimitValue),
		// 					Value: to.Ptr[int32](10),
		// 				},
		// 				ResourceType: to.Ptr("lowPriority"),
		// 				Unit: to.Ptr("Count"),
		// 			},
		// 	}},
		// }
	}
}
