//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armnewrelicobservability.ClientFactory type.
type ServerFactory struct {
	AccountsServer                  AccountsServer
	BillingInfoServer               BillingInfoServer
	ConnectedPartnerResourcesServer ConnectedPartnerResourcesServer
	MonitoredSubscriptionsServer    MonitoredSubscriptionsServer
	MonitorsServer                  MonitorsServer
	OperationsServer                OperationsServer
	OrganizationsServer             OrganizationsServer
	PlansServer                     PlansServer
	TagRulesServer                  TagRulesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armnewrelicobservability.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armnewrelicobservability.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                               *ServerFactory
	trMu                              sync.Mutex
	trAccountsServer                  *AccountsServerTransport
	trBillingInfoServer               *BillingInfoServerTransport
	trConnectedPartnerResourcesServer *ConnectedPartnerResourcesServerTransport
	trMonitoredSubscriptionsServer    *MonitoredSubscriptionsServerTransport
	trMonitorsServer                  *MonitorsServerTransport
	trOperationsServer                *OperationsServerTransport
	trOrganizationsServer             *OrganizationsServerTransport
	trPlansServer                     *PlansServerTransport
	trTagRulesServer                  *TagRulesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AccountsClient":
		initServer(s, &s.trAccountsServer, func() *AccountsServerTransport { return NewAccountsServerTransport(&s.srv.AccountsServer) })
		resp, err = s.trAccountsServer.Do(req)
	case "BillingInfoClient":
		initServer(s, &s.trBillingInfoServer, func() *BillingInfoServerTransport { return NewBillingInfoServerTransport(&s.srv.BillingInfoServer) })
		resp, err = s.trBillingInfoServer.Do(req)
	case "ConnectedPartnerResourcesClient":
		initServer(s, &s.trConnectedPartnerResourcesServer, func() *ConnectedPartnerResourcesServerTransport {
			return NewConnectedPartnerResourcesServerTransport(&s.srv.ConnectedPartnerResourcesServer)
		})
		resp, err = s.trConnectedPartnerResourcesServer.Do(req)
	case "MonitoredSubscriptionsClient":
		initServer(s, &s.trMonitoredSubscriptionsServer, func() *MonitoredSubscriptionsServerTransport {
			return NewMonitoredSubscriptionsServerTransport(&s.srv.MonitoredSubscriptionsServer)
		})
		resp, err = s.trMonitoredSubscriptionsServer.Do(req)
	case "MonitorsClient":
		initServer(s, &s.trMonitorsServer, func() *MonitorsServerTransport { return NewMonitorsServerTransport(&s.srv.MonitorsServer) })
		resp, err = s.trMonitorsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "OrganizationsClient":
		initServer(s, &s.trOrganizationsServer, func() *OrganizationsServerTransport {
			return NewOrganizationsServerTransport(&s.srv.OrganizationsServer)
		})
		resp, err = s.trOrganizationsServer.Do(req)
	case "PlansClient":
		initServer(s, &s.trPlansServer, func() *PlansServerTransport { return NewPlansServerTransport(&s.srv.PlansServer) })
		resp, err = s.trPlansServer.Do(req)
	case "TagRulesClient":
		initServer(s, &s.trTagRulesServer, func() *TagRulesServerTransport { return NewTagRulesServerTransport(&s.srv.TagRulesServer) })
		resp, err = s.trTagRulesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
