//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetworkanalytics_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkanalytics/armnetworkanalytics"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_ListByDataProduct_MaximumSet_Gen.json
func ExampleDataTypesClient_NewListByDataProductPager_dataTypesListByDataProductMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDataTypesClient().NewListByDataProductPager("aoiresourceGroupName", "dataproduct01", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DataTypeListResult = armnetworkanalytics.DataTypeListResult{
		// 	Value: []*armnetworkanalytics.DataType{
		// 		{
		// 			Name: to.Ptr("datatypename"),
		// 			Type: to.Ptr("Microsoft.NetworkAnalytics/DataProducts/DataTypes"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/dataProducts/dataproduct01/dataTypes/datatypename"),
		// 			SystemData: &armnetworkanalytics.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
		// 				CreatedBy: to.Ptr("abc@micros.com"),
		// 				CreatedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("abc@micros.com"),
		// 				LastModifiedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
		// 			},
		// 			Properties: &armnetworkanalytics.DataTypeProperties{
		// 				DatabaseCacheRetention: to.Ptr[int32](23),
		// 				DatabaseRetention: to.Ptr[int32](6),
		// 				ProvisioningState: to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
		// 				State: to.Ptr(armnetworkanalytics.DataTypeState("STARTED")),
		// 				StateReason: to.Ptr("state Reason"),
		// 				StorageOutputRetention: to.Ptr[int32](27),
		// 				VisualizationURL: to.Ptr("visualizationUrl"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_ListByDataProduct_MinimumSet_Gen.json
func ExampleDataTypesClient_NewListByDataProductPager_dataTypesListByDataProductMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDataTypesClient().NewListByDataProductPager("aoiresourceGroupName", "dataproduct01", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DataTypeListResult = armnetworkanalytics.DataTypeListResult{
		// 	Value: []*armnetworkanalytics.DataType{
		// 		{
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/dataProducts/dataproduct01/dataTypes/datatypename"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_Get_MaximumSet_Gen.json
func ExampleDataTypesClient_Get_dataTypesGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataTypesClient().Get(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataType = armnetworkanalytics.DataType{
	// 	Name: to.Ptr("datatypename"),
	// 	Type: to.Ptr("Microsoft.NetworkAnalytics/DataProducts/DataTypes"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/dataProducts/dataproduct01/dataTypes/datatypename"),
	// 	SystemData: &armnetworkanalytics.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		CreatedBy: to.Ptr("abc@micros.com"),
	// 		CreatedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("abc@micros.com"),
	// 		LastModifiedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 	},
	// 	Properties: &armnetworkanalytics.DataTypeProperties{
	// 		DatabaseCacheRetention: to.Ptr[int32](23),
	// 		DatabaseRetention: to.Ptr[int32](6),
	// 		ProvisioningState: to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
	// 		State: to.Ptr(armnetworkanalytics.DataTypeState("STARTED")),
	// 		StateReason: to.Ptr("state Reason"),
	// 		StorageOutputRetention: to.Ptr[int32](27),
	// 		VisualizationURL: to.Ptr("visualizationUrl"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_Get_MinimumSet_Gen.json
func ExampleDataTypesClient_Get_dataTypesGetMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataTypesClient().Get(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataType = armnetworkanalytics.DataType{
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/dataProducts/dataproduct01/dataTypes/datatypename"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_Create_MaximumSet_Gen.json
func ExampleDataTypesClient_BeginCreate_dataTypesCreateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataTypesClient().BeginCreate(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", armnetworkanalytics.DataType{
		Properties: &armnetworkanalytics.DataTypeProperties{
			DatabaseCacheRetention: to.Ptr[int32](23),
			DatabaseRetention:      to.Ptr[int32](6),
			ProvisioningState:      to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
			State:                  to.Ptr(armnetworkanalytics.DataTypeState("STARTED")),
			StorageOutputRetention: to.Ptr[int32](27),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataType = armnetworkanalytics.DataType{
	// 	Name: to.Ptr("datatypeName"),
	// 	Type: to.Ptr("Microsoft.NetworkAnalytics/DataProducts/DataTypes"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/dataProducts/dataproduct01/dataTypes/datatypename"),
	// 	SystemData: &armnetworkanalytics.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		CreatedBy: to.Ptr("abc@micros.com"),
	// 		CreatedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("abc@micros.com"),
	// 		LastModifiedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 	},
	// 	Properties: &armnetworkanalytics.DataTypeProperties{
	// 		DatabaseCacheRetention: to.Ptr[int32](23),
	// 		DatabaseRetention: to.Ptr[int32](6),
	// 		ProvisioningState: to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
	// 		State: to.Ptr(armnetworkanalytics.DataTypeState("STARTED")),
	// 		StateReason: to.Ptr("State Reason"),
	// 		StorageOutputRetention: to.Ptr[int32](27),
	// 		VisualizationURL: to.Ptr("visualizationUrl"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_Create_MinimumSet_Gen.json
func ExampleDataTypesClient_BeginCreate_dataTypesCreateMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataTypesClient().BeginCreate(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", armnetworkanalytics.DataType{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataType = armnetworkanalytics.DataType{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_Update_MaximumSet_Gen.json
func ExampleDataTypesClient_BeginUpdate_dataTypesUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataTypesClient().BeginUpdate(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", armnetworkanalytics.DataTypeUpdate{
		Properties: &armnetworkanalytics.DataTypeUpdateProperties{
			DatabaseCacheRetention: to.Ptr[int32](16),
			DatabaseRetention:      to.Ptr[int32](9),
			State:                  to.Ptr(armnetworkanalytics.DataTypeState("STARTED")),
			StorageOutputRetention: to.Ptr[int32](30),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataType = armnetworkanalytics.DataType{
	// 	Name: to.Ptr("datatypename"),
	// 	Type: to.Ptr("Microsoft.NetworkAnalytics/DataProducts/DataTypes"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/dataProducts/dataproduct01/dataTypes/datatypename"),
	// 	SystemData: &armnetworkanalytics.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		CreatedBy: to.Ptr("abc@micros.com"),
	// 		CreatedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("abc@micros.com"),
	// 		LastModifiedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 	},
	// 	Properties: &armnetworkanalytics.DataTypeProperties{
	// 		DatabaseCacheRetention: to.Ptr[int32](16),
	// 		DatabaseRetention: to.Ptr[int32](9),
	// 		ProvisioningState: to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
	// 		State: to.Ptr(armnetworkanalytics.DataTypeState("STARTED")),
	// 		StateReason: to.Ptr("State Reason"),
	// 		StorageOutputRetention: to.Ptr[int32](30),
	// 		VisualizationURL: to.Ptr("visualizationUrl"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_Update_MinimumSet_Gen.json
func ExampleDataTypesClient_BeginUpdate_dataTypesUpdateMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataTypesClient().BeginUpdate(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", armnetworkanalytics.DataTypeUpdate{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataType = armnetworkanalytics.DataType{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_Delete_MaximumSet_Gen.json
func ExampleDataTypesClient_BeginDelete_dataTypesDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataTypesClient().BeginDelete(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_Delete_MinimumSet_Gen.json
func ExampleDataTypesClient_BeginDelete_dataTypesDeleteMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataTypesClient().BeginDelete(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_DeleteData_MaximumSet_Gen.json
func ExampleDataTypesClient_BeginDeleteData_dataTypesDeleteDataMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataTypesClient().BeginDeleteData(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", map[string]any{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_DeleteData_MinimumSet_Gen.json
func ExampleDataTypesClient_BeginDeleteData_dataTypesDeleteDataMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataTypesClient().BeginDeleteData(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", map[string]any{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_GenerateStorageContainerSasToken_MaximumSet_Gen.json
func ExampleDataTypesClient_GenerateStorageContainerSasToken_dataTypesGenerateStorageContainerSasTokenMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataTypesClient().GenerateStorageContainerSasToken(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", armnetworkanalytics.ContainerSaS{
		ExpiryTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-24T05:34:58.039Z"); return t }()),
		IPAddress:       to.Ptr("1.1.1.1"),
		StartTimeStamp:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-24T05:34:58.039Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerSasToken = armnetworkanalytics.ContainerSasToken{
	// 	StorageContainerSasToken: to.Ptr("storageContainerSasToken"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/21a8d55d74e4425e96d76e5835f52cfc9eb95a22/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataTypes_GenerateStorageContainerSasToken_MinimumSet_Gen.json
func ExampleDataTypesClient_GenerateStorageContainerSasToken_dataTypesGenerateStorageContainerSasTokenMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataTypesClient().GenerateStorageContainerSasToken(ctx, "aoiresourceGroupName", "dataproduct01", "datatypename", armnetworkanalytics.ContainerSaS{
		ExpiryTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-24T05:35:16.887Z"); return t }()),
		IPAddress:       to.Ptr("1.1.1.1"),
		StartTimeStamp:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-24T05:35:16.887Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ContainerSasToken = armnetworkanalytics.ContainerSasToken{
	// 	StorageContainerSasToken: to.Ptr("storageContainerSasToken"),
	// }
}
