//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v5"
	"net/http"
	"net/url"
	"regexp"
)

// AvailableResourceGroupDelegationsServer is a fake server for instances of the armnetwork.AvailableResourceGroupDelegationsClient type.
type AvailableResourceGroupDelegationsServer struct {
	// NewListPager is the fake for method AvailableResourceGroupDelegationsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(location string, resourceGroupName string, options *armnetwork.AvailableResourceGroupDelegationsClientListOptions) (resp azfake.PagerResponder[armnetwork.AvailableResourceGroupDelegationsClientListResponse])
}

// NewAvailableResourceGroupDelegationsServerTransport creates a new instance of AvailableResourceGroupDelegationsServerTransport with the provided implementation.
// The returned AvailableResourceGroupDelegationsServerTransport instance is connected to an instance of armnetwork.AvailableResourceGroupDelegationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAvailableResourceGroupDelegationsServerTransport(srv *AvailableResourceGroupDelegationsServer) *AvailableResourceGroupDelegationsServerTransport {
	return &AvailableResourceGroupDelegationsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armnetwork.AvailableResourceGroupDelegationsClientListResponse]](),
	}
}

// AvailableResourceGroupDelegationsServerTransport connects instances of armnetwork.AvailableResourceGroupDelegationsClient to instances of AvailableResourceGroupDelegationsServer.
// Don't use this type directly, use NewAvailableResourceGroupDelegationsServerTransport instead.
type AvailableResourceGroupDelegationsServerTransport struct {
	srv          *AvailableResourceGroupDelegationsServer
	newListPager *tracker[azfake.PagerResponder[armnetwork.AvailableResourceGroupDelegationsClientListResponse]]
}

// Do implements the policy.Transporter interface for AvailableResourceGroupDelegationsServerTransport.
func (a *AvailableResourceGroupDelegationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AvailableResourceGroupDelegationsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AvailableResourceGroupDelegationsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/availableDelegations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListPager(locationParam, resourceGroupNameParam, nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnetwork.AvailableResourceGroupDelegationsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
