//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetapp_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/netapp/armnetapp/v6"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/netapp/resource-manager/Microsoft.NetApp/stable/2023-07-01/examples/VolumeGroups_List_Oracle.json
func ExampleVolumeGroupsClient_NewListByNetAppAccountPager_volumeGroupsListOracle() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetapp.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVolumeGroupsClient().NewListByNetAppAccountPager("myRG", "account1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VolumeGroupList = armnetapp.VolumeGroupList{
		// 	Value: []*armnetapp.VolumeGroup{
		// 		{
		// 			Name: to.Ptr("group1"),
		// 			Type: to.Ptr("Microsoft.NetApp/netAppAccounts/volumeGroups"),
		// 			ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/volumeGroups/group1"),
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armnetapp.VolumeGroupListProperties{
		// 				GroupMetaData: &armnetapp.VolumeGroupMetaData{
		// 					ApplicationIdentifier: to.Ptr("DEV"),
		// 					ApplicationType: to.Ptr(armnetapp.ApplicationTypeORACLE),
		// 					GroupDescription: to.Ptr("Volume group"),
		// 					VolumesCount: to.Ptr[int64](12),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/netapp/resource-manager/Microsoft.NetApp/stable/2023-07-01/examples/VolumeGroups_List_SapHana.json
func ExampleVolumeGroupsClient_NewListByNetAppAccountPager_volumeGroupsListSapHana() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetapp.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVolumeGroupsClient().NewListByNetAppAccountPager("myRG", "account1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VolumeGroupList = armnetapp.VolumeGroupList{
		// 	Value: []*armnetapp.VolumeGroup{
		// 		{
		// 			Name: to.Ptr("group1"),
		// 			Type: to.Ptr("Microsoft.NetApp/netAppAccounts/volumeGroups"),
		// 			ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/volumeGroups/group1"),
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armnetapp.VolumeGroupListProperties{
		// 				GroupMetaData: &armnetapp.VolumeGroupMetaData{
		// 					ApplicationIdentifier: to.Ptr("SH9"),
		// 					ApplicationType: to.Ptr(armnetapp.ApplicationTypeSAPHANA),
		// 					GroupDescription: to.Ptr("Volume group"),
		// 					VolumesCount: to.Ptr[int64](5),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/netapp/resource-manager/Microsoft.NetApp/stable/2023-07-01/examples/VolumeGroups_Get_Oracle.json
func ExampleVolumeGroupsClient_Get_volumeGroupsGetOracle() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetapp.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVolumeGroupsClient().Get(ctx, "myRG", "account1", "group1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VolumeGroupDetails = armnetapp.VolumeGroupDetails{
	// 	Name: to.Ptr("group1"),
	// 	Type: to.Ptr("Microsoft.NetApp/netAppAccounts/volumeGroups"),
	// 	ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/volumeGroups/group1"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armnetapp.VolumeGroupProperties{
	// 		GroupMetaData: &armnetapp.VolumeGroupMetaData{
	// 			ApplicationIdentifier: to.Ptr("OR2"),
	// 			ApplicationType: to.Ptr(armnetapp.ApplicationTypeORACLE),
	// 			GroupDescription: to.Ptr("Volume group"),
	// 			VolumesCount: to.Ptr[int64](12),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Volumes: []*armnetapp.VolumeGroupVolumeProperties{
	// 			{
	// 				Name: to.Ptr("account1/pool1/test-ora-data1"),
	// 				Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 				ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-data1"),
	// 				Properties: &armnetapp.VolumeProperties{
	// 					CreationToken: to.Ptr("test-ora-data1"),
	// 					ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 						Rules: []*armnetapp.ExportPolicyRule{
	// 							{
	// 								AllowedClients: to.Ptr("0.0.0.0/0"),
	// 								Cifs: to.Ptr(false),
	// 								HasRootAccess: to.Ptr(true),
	// 								Kerberos5ReadOnly: to.Ptr(false),
	// 								Kerberos5ReadWrite: to.Ptr(false),
	// 								Kerberos5IReadOnly: to.Ptr(false),
	// 								Kerberos5IReadWrite: to.Ptr(false),
	// 								Kerberos5PReadOnly: to.Ptr(false),
	// 								Kerberos5PReadWrite: to.Ptr(false),
	// 								Nfsv3: to.Ptr(false),
	// 								Nfsv41: to.Ptr(true),
	// 								RuleIndex: to.Ptr[int32](1),
	// 								UnixReadOnly: to.Ptr(true),
	// 								UnixReadWrite: to.Ptr(true),
	// 						}},
	// 					},
	// 					ProtocolTypes: []*string{
	// 						to.Ptr("NFSv4.1")},
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 						SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 						ThroughputMibps: to.Ptr[float32](10),
	// 						UsageThreshold: to.Ptr[int64](107374182400),
	// 						VolumeSpecName: to.Ptr("ora-data1"),
	// 					},
	// 					Zones: []*string{
	// 						to.Ptr("1")},
	// 					},
	// 					{
	// 						Name: to.Ptr("account1/pool1/test-ora-data2"),
	// 						Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 						ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-data2"),
	// 						Properties: &armnetapp.VolumeProperties{
	// 							CreationToken: to.Ptr("test-ora-data2"),
	// 							ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 								Rules: []*armnetapp.ExportPolicyRule{
	// 									{
	// 										AllowedClients: to.Ptr("0.0.0.0/0"),
	// 										Cifs: to.Ptr(false),
	// 										HasRootAccess: to.Ptr(true),
	// 										Kerberos5ReadOnly: to.Ptr(false),
	// 										Kerberos5ReadWrite: to.Ptr(false),
	// 										Kerberos5IReadOnly: to.Ptr(false),
	// 										Kerberos5IReadWrite: to.Ptr(false),
	// 										Kerberos5PReadOnly: to.Ptr(false),
	// 										Kerberos5PReadWrite: to.Ptr(false),
	// 										Nfsv3: to.Ptr(false),
	// 										Nfsv41: to.Ptr(true),
	// 										RuleIndex: to.Ptr[int32](1),
	// 										UnixReadOnly: to.Ptr(true),
	// 										UnixReadWrite: to.Ptr(true),
	// 								}},
	// 							},
	// 							ProtocolTypes: []*string{
	// 								to.Ptr("NFSv4.1")},
	// 								ProvisioningState: to.Ptr("Succeeded"),
	// 								ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 								SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 								ThroughputMibps: to.Ptr[float32](10),
	// 								UsageThreshold: to.Ptr[int64](107374182400),
	// 								VolumeSpecName: to.Ptr("ora-data2"),
	// 							},
	// 							Zones: []*string{
	// 								to.Ptr("1")},
	// 							},
	// 							{
	// 								Name: to.Ptr("account1/pool1/test-ora-data3"),
	// 								Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 								ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-data3"),
	// 								Properties: &armnetapp.VolumeProperties{
	// 									CreationToken: to.Ptr("test-ora-data3"),
	// 									ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 										Rules: []*armnetapp.ExportPolicyRule{
	// 											{
	// 												AllowedClients: to.Ptr("0.0.0.0/0"),
	// 												Cifs: to.Ptr(false),
	// 												HasRootAccess: to.Ptr(true),
	// 												Kerberos5ReadOnly: to.Ptr(false),
	// 												Kerberos5ReadWrite: to.Ptr(false),
	// 												Kerberos5IReadOnly: to.Ptr(false),
	// 												Kerberos5IReadWrite: to.Ptr(false),
	// 												Kerberos5PReadOnly: to.Ptr(false),
	// 												Kerberos5PReadWrite: to.Ptr(false),
	// 												Nfsv3: to.Ptr(false),
	// 												Nfsv41: to.Ptr(true),
	// 												RuleIndex: to.Ptr[int32](1),
	// 												UnixReadOnly: to.Ptr(true),
	// 												UnixReadWrite: to.Ptr(true),
	// 										}},
	// 									},
	// 									ProtocolTypes: []*string{
	// 										to.Ptr("NFSv4.1")},
	// 										ProvisioningState: to.Ptr("Succeeded"),
	// 										ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 										SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 										ThroughputMibps: to.Ptr[float32](10),
	// 										UsageThreshold: to.Ptr[int64](107374182400),
	// 										VolumeSpecName: to.Ptr("ora-data3"),
	// 									},
	// 									Zones: []*string{
	// 										to.Ptr("1")},
	// 									},
	// 									{
	// 										Name: to.Ptr("account1/pool1/test-ora-data4"),
	// 										Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 										ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-data4"),
	// 										Properties: &armnetapp.VolumeProperties{
	// 											CreationToken: to.Ptr("test-ora-data4"),
	// 											ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 												Rules: []*armnetapp.ExportPolicyRule{
	// 													{
	// 														AllowedClients: to.Ptr("0.0.0.0/0"),
	// 														Cifs: to.Ptr(false),
	// 														HasRootAccess: to.Ptr(true),
	// 														Kerberos5ReadOnly: to.Ptr(false),
	// 														Kerberos5ReadWrite: to.Ptr(false),
	// 														Kerberos5IReadOnly: to.Ptr(false),
	// 														Kerberos5IReadWrite: to.Ptr(false),
	// 														Kerberos5PReadOnly: to.Ptr(false),
	// 														Kerberos5PReadWrite: to.Ptr(false),
	// 														Nfsv3: to.Ptr(false),
	// 														Nfsv41: to.Ptr(true),
	// 														RuleIndex: to.Ptr[int32](1),
	// 														UnixReadOnly: to.Ptr(true),
	// 														UnixReadWrite: to.Ptr(true),
	// 												}},
	// 											},
	// 											ProtocolTypes: []*string{
	// 												to.Ptr("NFSv4.1")},
	// 												ProvisioningState: to.Ptr("Succeeded"),
	// 												ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 												SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 												ThroughputMibps: to.Ptr[float32](10),
	// 												UsageThreshold: to.Ptr[int64](107374182400),
	// 												VolumeSpecName: to.Ptr("ora-data4"),
	// 											},
	// 											Zones: []*string{
	// 												to.Ptr("1")},
	// 											},
	// 											{
	// 												Name: to.Ptr("account1/pool1/test-ora-data5"),
	// 												Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 												ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-data5"),
	// 												Properties: &armnetapp.VolumeProperties{
	// 													CreationToken: to.Ptr("test-ora-data5"),
	// 													ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 														Rules: []*armnetapp.ExportPolicyRule{
	// 															{
	// 																AllowedClients: to.Ptr("0.0.0.0/0"),
	// 																Cifs: to.Ptr(false),
	// 																HasRootAccess: to.Ptr(true),
	// 																Kerberos5ReadOnly: to.Ptr(false),
	// 																Kerberos5ReadWrite: to.Ptr(false),
	// 																Kerberos5IReadOnly: to.Ptr(false),
	// 																Kerberos5IReadWrite: to.Ptr(false),
	// 																Kerberos5PReadOnly: to.Ptr(false),
	// 																Kerberos5PReadWrite: to.Ptr(false),
	// 																Nfsv3: to.Ptr(false),
	// 																Nfsv41: to.Ptr(true),
	// 																RuleIndex: to.Ptr[int32](1),
	// 																UnixReadOnly: to.Ptr(true),
	// 																UnixReadWrite: to.Ptr(true),
	// 														}},
	// 													},
	// 													ProtocolTypes: []*string{
	// 														to.Ptr("NFSv4.1")},
	// 														ProvisioningState: to.Ptr("Succeeded"),
	// 														ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 														SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 														ThroughputMibps: to.Ptr[float32](10),
	// 														UsageThreshold: to.Ptr[int64](107374182400),
	// 														VolumeSpecName: to.Ptr("ora-data5"),
	// 													},
	// 													Zones: []*string{
	// 														to.Ptr("1")},
	// 													},
	// 													{
	// 														Name: to.Ptr("account1/pool1/test-ora-data6"),
	// 														Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 														ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-data6"),
	// 														Properties: &armnetapp.VolumeProperties{
	// 															CreationToken: to.Ptr("test-ora-data6"),
	// 															ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 																Rules: []*armnetapp.ExportPolicyRule{
	// 																	{
	// 																		AllowedClients: to.Ptr("0.0.0.0/0"),
	// 																		Cifs: to.Ptr(false),
	// 																		HasRootAccess: to.Ptr(true),
	// 																		Kerberos5ReadOnly: to.Ptr(false),
	// 																		Kerberos5ReadWrite: to.Ptr(false),
	// 																		Kerberos5IReadOnly: to.Ptr(false),
	// 																		Kerberos5IReadWrite: to.Ptr(false),
	// 																		Kerberos5PReadOnly: to.Ptr(false),
	// 																		Kerberos5PReadWrite: to.Ptr(false),
	// 																		Nfsv3: to.Ptr(false),
	// 																		Nfsv41: to.Ptr(true),
	// 																		RuleIndex: to.Ptr[int32](1),
	// 																		UnixReadOnly: to.Ptr(true),
	// 																		UnixReadWrite: to.Ptr(true),
	// 																}},
	// 															},
	// 															ProtocolTypes: []*string{
	// 																to.Ptr("NFSv4.1")},
	// 																ProvisioningState: to.Ptr("Succeeded"),
	// 																ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 																SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 																ThroughputMibps: to.Ptr[float32](10),
	// 																UsageThreshold: to.Ptr[int64](107374182400),
	// 																VolumeSpecName: to.Ptr("ora-data6"),
	// 															},
	// 															Zones: []*string{
	// 																to.Ptr("1")},
	// 															},
	// 															{
	// 																Name: to.Ptr("account1/pool1/test-ora-data7"),
	// 																Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 																ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-data7"),
	// 																Properties: &armnetapp.VolumeProperties{
	// 																	CreationToken: to.Ptr("test-ora-data7"),
	// 																	ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 																		Rules: []*armnetapp.ExportPolicyRule{
	// 																			{
	// 																				AllowedClients: to.Ptr("0.0.0.0/0"),
	// 																				Cifs: to.Ptr(false),
	// 																				HasRootAccess: to.Ptr(true),
	// 																				Kerberos5ReadOnly: to.Ptr(false),
	// 																				Kerberos5ReadWrite: to.Ptr(false),
	// 																				Kerberos5IReadOnly: to.Ptr(false),
	// 																				Kerberos5IReadWrite: to.Ptr(false),
	// 																				Kerberos5PReadOnly: to.Ptr(false),
	// 																				Kerberos5PReadWrite: to.Ptr(false),
	// 																				Nfsv3: to.Ptr(false),
	// 																				Nfsv41: to.Ptr(true),
	// 																				RuleIndex: to.Ptr[int32](1),
	// 																				UnixReadOnly: to.Ptr(true),
	// 																				UnixReadWrite: to.Ptr(true),
	// 																		}},
	// 																	},
	// 																	ProtocolTypes: []*string{
	// 																		to.Ptr("NFSv4.1")},
	// 																		ProvisioningState: to.Ptr("Succeeded"),
	// 																		ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 																		SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 																		ThroughputMibps: to.Ptr[float32](10),
	// 																		UsageThreshold: to.Ptr[int64](107374182400),
	// 																		VolumeSpecName: to.Ptr("ora-data7"),
	// 																	},
	// 																	Zones: []*string{
	// 																		to.Ptr("1")},
	// 																	},
	// 																	{
	// 																		Name: to.Ptr("account1/pool1/test-ora-data8"),
	// 																		Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 																		ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-data8"),
	// 																		Properties: &armnetapp.VolumeProperties{
	// 																			CreationToken: to.Ptr("test-ora-data8"),
	// 																			ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 																				Rules: []*armnetapp.ExportPolicyRule{
	// 																					{
	// 																						AllowedClients: to.Ptr("0.0.0.0/0"),
	// 																						Cifs: to.Ptr(false),
	// 																						HasRootAccess: to.Ptr(true),
	// 																						Kerberos5ReadOnly: to.Ptr(false),
	// 																						Kerberos5ReadWrite: to.Ptr(false),
	// 																						Kerberos5IReadOnly: to.Ptr(false),
	// 																						Kerberos5IReadWrite: to.Ptr(false),
	// 																						Kerberos5PReadOnly: to.Ptr(false),
	// 																						Kerberos5PReadWrite: to.Ptr(false),
	// 																						Nfsv3: to.Ptr(false),
	// 																						Nfsv41: to.Ptr(true),
	// 																						RuleIndex: to.Ptr[int32](1),
	// 																						UnixReadOnly: to.Ptr(true),
	// 																						UnixReadWrite: to.Ptr(true),
	// 																				}},
	// 																			},
	// 																			ProtocolTypes: []*string{
	// 																				to.Ptr("NFSv4.1")},
	// 																				ProvisioningState: to.Ptr("Succeeded"),
	// 																				ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 																				SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 																				ThroughputMibps: to.Ptr[float32](10),
	// 																				UsageThreshold: to.Ptr[int64](107374182400),
	// 																				VolumeSpecName: to.Ptr("ora-data8"),
	// 																			},
	// 																			Zones: []*string{
	// 																				to.Ptr("1")},
	// 																			},
	// 																			{
	// 																				Name: to.Ptr("account1/pool1/test-ora-log"),
	// 																				Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 																				ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-log"),
	// 																				Properties: &armnetapp.VolumeProperties{
	// 																					CreationToken: to.Ptr("test-ora-log"),
	// 																					ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 																						Rules: []*armnetapp.ExportPolicyRule{
	// 																							{
	// 																								AllowedClients: to.Ptr("0.0.0.0/0"),
	// 																								Cifs: to.Ptr(false),
	// 																								HasRootAccess: to.Ptr(true),
	// 																								Kerberos5ReadOnly: to.Ptr(false),
	// 																								Kerberos5ReadWrite: to.Ptr(false),
	// 																								Kerberos5IReadOnly: to.Ptr(false),
	// 																								Kerberos5IReadWrite: to.Ptr(false),
	// 																								Kerberos5PReadOnly: to.Ptr(false),
	// 																								Kerberos5PReadWrite: to.Ptr(false),
	// 																								Nfsv3: to.Ptr(false),
	// 																								Nfsv41: to.Ptr(true),
	// 																								RuleIndex: to.Ptr[int32](1),
	// 																								UnixReadOnly: to.Ptr(true),
	// 																								UnixReadWrite: to.Ptr(true),
	// 																						}},
	// 																					},
	// 																					ProtocolTypes: []*string{
	// 																						to.Ptr("NFSv4.1")},
	// 																						ProvisioningState: to.Ptr("Succeeded"),
	// 																						ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 																						SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 																						ThroughputMibps: to.Ptr[float32](10),
	// 																						UsageThreshold: to.Ptr[int64](107374182400),
	// 																						VolumeSpecName: to.Ptr("ora-log"),
	// 																					},
	// 																					Zones: []*string{
	// 																						to.Ptr("1")},
	// 																					},
	// 																					{
	// 																						Name: to.Ptr("account1/pool1/test-ora-log-mirror"),
	// 																						Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 																						ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-log-mirror"),
	// 																						Properties: &armnetapp.VolumeProperties{
	// 																							CreationToken: to.Ptr("test-ora-log-mirror"),
	// 																							ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 																								Rules: []*armnetapp.ExportPolicyRule{
	// 																									{
	// 																										AllowedClients: to.Ptr("0.0.0.0/0"),
	// 																										Cifs: to.Ptr(false),
	// 																										HasRootAccess: to.Ptr(true),
	// 																										Kerberos5ReadOnly: to.Ptr(false),
	// 																										Kerberos5ReadWrite: to.Ptr(false),
	// 																										Kerberos5IReadOnly: to.Ptr(false),
	// 																										Kerberos5IReadWrite: to.Ptr(false),
	// 																										Kerberos5PReadOnly: to.Ptr(false),
	// 																										Kerberos5PReadWrite: to.Ptr(false),
	// 																										Nfsv3: to.Ptr(false),
	// 																										Nfsv41: to.Ptr(true),
	// 																										RuleIndex: to.Ptr[int32](1),
	// 																										UnixReadOnly: to.Ptr(true),
	// 																										UnixReadWrite: to.Ptr(true),
	// 																								}},
	// 																							},
	// 																							ProtocolTypes: []*string{
	// 																								to.Ptr("NFSv4.1")},
	// 																								ProvisioningState: to.Ptr("Succeeded"),
	// 																								ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 																								SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 																								ThroughputMibps: to.Ptr[float32](10),
	// 																								UsageThreshold: to.Ptr[int64](107374182400),
	// 																								VolumeSpecName: to.Ptr("ora-log-mirror"),
	// 																							},
	// 																							Zones: []*string{
	// 																								to.Ptr("1")},
	// 																							},
	// 																							{
	// 																								Name: to.Ptr("account1/pool1/test-ora-binary"),
	// 																								Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 																								ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-binary"),
	// 																								Properties: &armnetapp.VolumeProperties{
	// 																									CreationToken: to.Ptr("test-ora-binary"),
	// 																									ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 																										Rules: []*armnetapp.ExportPolicyRule{
	// 																											{
	// 																												AllowedClients: to.Ptr("0.0.0.0/0"),
	// 																												Cifs: to.Ptr(false),
	// 																												HasRootAccess: to.Ptr(true),
	// 																												Kerberos5ReadOnly: to.Ptr(false),
	// 																												Kerberos5ReadWrite: to.Ptr(false),
	// 																												Kerberos5IReadOnly: to.Ptr(false),
	// 																												Kerberos5IReadWrite: to.Ptr(false),
	// 																												Kerberos5PReadOnly: to.Ptr(false),
	// 																												Kerberos5PReadWrite: to.Ptr(false),
	// 																												Nfsv3: to.Ptr(false),
	// 																												Nfsv41: to.Ptr(true),
	// 																												RuleIndex: to.Ptr[int32](1),
	// 																												UnixReadOnly: to.Ptr(true),
	// 																												UnixReadWrite: to.Ptr(true),
	// 																										}},
	// 																									},
	// 																									ProtocolTypes: []*string{
	// 																										to.Ptr("NFSv4.1")},
	// 																										ProvisioningState: to.Ptr("Succeeded"),
	// 																										ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 																										SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 																										ThroughputMibps: to.Ptr[float32](10),
	// 																										UsageThreshold: to.Ptr[int64](107374182400),
	// 																										VolumeSpecName: to.Ptr("ora-binary"),
	// 																									},
	// 																									Zones: []*string{
	// 																										to.Ptr("1")},
	// 																									},
	// 																									{
	// 																										Name: to.Ptr("account1/pool1/test-ora-backup"),
	// 																										Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 																										ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-ora-backup"),
	// 																										Properties: &armnetapp.VolumeProperties{
	// 																											CreationToken: to.Ptr("test-ora-backup"),
	// 																											ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 																												Rules: []*armnetapp.ExportPolicyRule{
	// 																													{
	// 																														AllowedClients: to.Ptr("0.0.0.0/0"),
	// 																														Cifs: to.Ptr(false),
	// 																														HasRootAccess: to.Ptr(true),
	// 																														Kerberos5ReadOnly: to.Ptr(false),
	// 																														Kerberos5ReadWrite: to.Ptr(false),
	// 																														Kerberos5IReadOnly: to.Ptr(false),
	// 																														Kerberos5IReadWrite: to.Ptr(false),
	// 																														Kerberos5PReadOnly: to.Ptr(false),
	// 																														Kerberos5PReadWrite: to.Ptr(false),
	// 																														Nfsv3: to.Ptr(false),
	// 																														Nfsv41: to.Ptr(true),
	// 																														RuleIndex: to.Ptr[int32](1),
	// 																														UnixReadOnly: to.Ptr(true),
	// 																														UnixReadWrite: to.Ptr(true),
	// 																												}},
	// 																											},
	// 																											ProtocolTypes: []*string{
	// 																												to.Ptr("NFSv4.1")},
	// 																												ProvisioningState: to.Ptr("Succeeded"),
	// 																												ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 																												SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 																												ThroughputMibps: to.Ptr[float32](10),
	// 																												UsageThreshold: to.Ptr[int64](107374182400),
	// 																												VolumeSpecName: to.Ptr("ora-backup"),
	// 																											},
	// 																											Zones: []*string{
	// 																												to.Ptr("1")},
	// 																										}},
	// 																									},
	// 																								}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/netapp/resource-manager/Microsoft.NetApp/stable/2023-07-01/examples/VolumeGroups_Get_SapHana.json
func ExampleVolumeGroupsClient_Get_volumeGroupsGetSapHana() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetapp.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVolumeGroupsClient().Get(ctx, "myRG", "account1", "group1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VolumeGroupDetails = armnetapp.VolumeGroupDetails{
	// 	Name: to.Ptr("group1"),
	// 	Type: to.Ptr("Microsoft.NetApp/netAppAccounts/volumeGroups"),
	// 	ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/volumeGroups/group1"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armnetapp.VolumeGroupProperties{
	// 		GroupMetaData: &armnetapp.VolumeGroupMetaData{
	// 			ApplicationIdentifier: to.Ptr("SH9"),
	// 			ApplicationType: to.Ptr(armnetapp.ApplicationTypeSAPHANA),
	// 			GroupDescription: to.Ptr("Volume group"),
	// 			VolumesCount: to.Ptr[int64](5),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Volumes: []*armnetapp.VolumeGroupVolumeProperties{
	// 			{
	// 				Name: to.Ptr("account1/pool1/test-data-mnt00001"),
	// 				Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 				ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-data-mnt00001"),
	// 				Properties: &armnetapp.VolumeProperties{
	// 					CreationToken: to.Ptr("test-data-mnt00001"),
	// 					ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 						Rules: []*armnetapp.ExportPolicyRule{
	// 							{
	// 								AllowedClients: to.Ptr("0.0.0.0/0"),
	// 								Cifs: to.Ptr(false),
	// 								HasRootAccess: to.Ptr(true),
	// 								Kerberos5ReadOnly: to.Ptr(false),
	// 								Kerberos5ReadWrite: to.Ptr(false),
	// 								Kerberos5IReadOnly: to.Ptr(false),
	// 								Kerberos5IReadWrite: to.Ptr(false),
	// 								Kerberos5PReadOnly: to.Ptr(false),
	// 								Kerberos5PReadWrite: to.Ptr(false),
	// 								Nfsv3: to.Ptr(false),
	// 								Nfsv41: to.Ptr(true),
	// 								RuleIndex: to.Ptr[int32](1),
	// 								UnixReadOnly: to.Ptr(true),
	// 								UnixReadWrite: to.Ptr(true),
	// 						}},
	// 					},
	// 					ProtocolTypes: []*string{
	// 						to.Ptr("NFSv4.1")},
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ProximityPlacementGroup: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
	// 						ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 						SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 						ThroughputMibps: to.Ptr[float32](10),
	// 						UsageThreshold: to.Ptr[int64](107374182400),
	// 						VolumeSpecName: to.Ptr("data"),
	// 					},
	// 				},
	// 				{
	// 					Name: to.Ptr("account1/pool1/test-log-mnt00001"),
	// 					Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 					ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-log-mnt00001"),
	// 					Properties: &armnetapp.VolumeProperties{
	// 						CreationToken: to.Ptr("test-log-mnt00001"),
	// 						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 							Rules: []*armnetapp.ExportPolicyRule{
	// 								{
	// 									AllowedClients: to.Ptr("0.0.0.0/0"),
	// 									Cifs: to.Ptr(false),
	// 									HasRootAccess: to.Ptr(true),
	// 									Kerberos5ReadOnly: to.Ptr(false),
	// 									Kerberos5ReadWrite: to.Ptr(false),
	// 									Kerberos5IReadOnly: to.Ptr(false),
	// 									Kerberos5IReadWrite: to.Ptr(false),
	// 									Kerberos5PReadOnly: to.Ptr(false),
	// 									Kerberos5PReadWrite: to.Ptr(false),
	// 									Nfsv3: to.Ptr(false),
	// 									Nfsv41: to.Ptr(true),
	// 									RuleIndex: to.Ptr[int32](1),
	// 									UnixReadOnly: to.Ptr(true),
	// 									UnixReadWrite: to.Ptr(true),
	// 							}},
	// 						},
	// 						ProtocolTypes: []*string{
	// 							to.Ptr("NFSv4.1")},
	// 							ProvisioningState: to.Ptr("Succeeded"),
	// 							ProximityPlacementGroup: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
	// 							ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 							SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 							ThroughputMibps: to.Ptr[float32](10),
	// 							UsageThreshold: to.Ptr[int64](107374182400),
	// 							VolumeSpecName: to.Ptr("log"),
	// 						},
	// 					},
	// 					{
	// 						Name: to.Ptr("account1/pool1/test-shared"),
	// 						Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 						ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-shared"),
	// 						Properties: &armnetapp.VolumeProperties{
	// 							CreationToken: to.Ptr("test-shared"),
	// 							ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 								Rules: []*armnetapp.ExportPolicyRule{
	// 									{
	// 										AllowedClients: to.Ptr("0.0.0.0/0"),
	// 										Cifs: to.Ptr(false),
	// 										HasRootAccess: to.Ptr(true),
	// 										Kerberos5ReadOnly: to.Ptr(false),
	// 										Kerberos5ReadWrite: to.Ptr(false),
	// 										Kerberos5IReadOnly: to.Ptr(false),
	// 										Kerberos5IReadWrite: to.Ptr(false),
	// 										Kerberos5PReadOnly: to.Ptr(false),
	// 										Kerberos5PReadWrite: to.Ptr(false),
	// 										Nfsv3: to.Ptr(false),
	// 										Nfsv41: to.Ptr(true),
	// 										RuleIndex: to.Ptr[int32](1),
	// 										UnixReadOnly: to.Ptr(true),
	// 										UnixReadWrite: to.Ptr(true),
	// 								}},
	// 							},
	// 							ProtocolTypes: []*string{
	// 								to.Ptr("NFSv4.1")},
	// 								ProvisioningState: to.Ptr("Succeeded"),
	// 								ProximityPlacementGroup: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
	// 								ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 								SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 								ThroughputMibps: to.Ptr[float32](10),
	// 								UsageThreshold: to.Ptr[int64](107374182400),
	// 								VolumeSpecName: to.Ptr("shared"),
	// 							},
	// 						},
	// 						{
	// 							Name: to.Ptr("account1/pool1/test-data-backup"),
	// 							Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 							ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-data-backup"),
	// 							Properties: &armnetapp.VolumeProperties{
	// 								CreationToken: to.Ptr("test-data-backup"),
	// 								ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 									Rules: []*armnetapp.ExportPolicyRule{
	// 										{
	// 											AllowedClients: to.Ptr("0.0.0.0/0"),
	// 											Cifs: to.Ptr(false),
	// 											HasRootAccess: to.Ptr(true),
	// 											Kerberos5ReadOnly: to.Ptr(false),
	// 											Kerberos5ReadWrite: to.Ptr(false),
	// 											Kerberos5IReadOnly: to.Ptr(false),
	// 											Kerberos5IReadWrite: to.Ptr(false),
	// 											Kerberos5PReadOnly: to.Ptr(false),
	// 											Kerberos5PReadWrite: to.Ptr(false),
	// 											Nfsv3: to.Ptr(false),
	// 											Nfsv41: to.Ptr(true),
	// 											RuleIndex: to.Ptr[int32](1),
	// 											UnixReadOnly: to.Ptr(true),
	// 											UnixReadWrite: to.Ptr(true),
	// 									}},
	// 								},
	// 								ProtocolTypes: []*string{
	// 									to.Ptr("NFSv4.1")},
	// 									ProvisioningState: to.Ptr("Succeeded"),
	// 									ProximityPlacementGroup: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
	// 									ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 									SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 									ThroughputMibps: to.Ptr[float32](10),
	// 									UsageThreshold: to.Ptr[int64](107374182400),
	// 									VolumeSpecName: to.Ptr("data-backup"),
	// 								},
	// 							},
	// 							{
	// 								Name: to.Ptr("account1/pool1/test-log-backup"),
	// 								Type: to.Ptr("Microsoft.NetApp/netAppAccounts/capacityPools/volumes"),
	// 								ID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/test-log-backup"),
	// 								Properties: &armnetapp.VolumeProperties{
	// 									CreationToken: to.Ptr("test-log-backup"),
	// 									ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
	// 										Rules: []*armnetapp.ExportPolicyRule{
	// 											{
	// 												AllowedClients: to.Ptr("0.0.0.0/0"),
	// 												Cifs: to.Ptr(false),
	// 												HasRootAccess: to.Ptr(true),
	// 												Kerberos5ReadOnly: to.Ptr(false),
	// 												Kerberos5ReadWrite: to.Ptr(false),
	// 												Kerberos5IReadOnly: to.Ptr(false),
	// 												Kerberos5IReadWrite: to.Ptr(false),
	// 												Kerberos5PReadOnly: to.Ptr(false),
	// 												Kerberos5PReadWrite: to.Ptr(false),
	// 												Nfsv3: to.Ptr(false),
	// 												Nfsv41: to.Ptr(true),
	// 												RuleIndex: to.Ptr[int32](1),
	// 												UnixReadOnly: to.Ptr(true),
	// 												UnixReadWrite: to.Ptr(true),
	// 										}},
	// 									},
	// 									ProtocolTypes: []*string{
	// 										to.Ptr("NFSv4.1")},
	// 										ProvisioningState: to.Ptr("Succeeded"),
	// 										ProximityPlacementGroup: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
	// 										ServiceLevel: to.Ptr(armnetapp.ServiceLevelPremium),
	// 										SubnetID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
	// 										ThroughputMibps: to.Ptr[float32](10),
	// 										UsageThreshold: to.Ptr[int64](107374182400),
	// 										VolumeSpecName: to.Ptr("log-backup"),
	// 									},
	// 							}},
	// 						},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/netapp/resource-manager/Microsoft.NetApp/stable/2023-07-01/examples/VolumeGroups_Create_Oracle.json
func ExampleVolumeGroupsClient_BeginCreate_volumeGroupsCreateOracle() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetapp.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVolumeGroupsClient().BeginCreate(ctx, "myRG", "account1", "group1", armnetapp.VolumeGroupDetails{
		Location: to.Ptr("westus"),
		Properties: &armnetapp.VolumeGroupProperties{
			GroupMetaData: &armnetapp.VolumeGroupMetaData{
				ApplicationIdentifier: to.Ptr("OR2"),
				ApplicationType:       to.Ptr(armnetapp.ApplicationTypeORACLE),
				GroupDescription:      to.Ptr("Volume group"),
			},
			Volumes: []*armnetapp.VolumeGroupVolumeProperties{
				{
					Name: to.Ptr("test-ora-data1"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-data1"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-data1"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-data2"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-data2"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-data2"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-data3"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-data3"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-data3"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-data4"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-data4"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-data4"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-data5"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-data5"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-data5"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-data6"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-data6"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-data6"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-data7"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-data7"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-data7"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-data8"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-data8"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-data8"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-log"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-log"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-log"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-log-mirror"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-log-mirror"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-log-mirror"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-binary"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-binary"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-binary"),
					},
					Zones: []*string{
						to.Ptr("1")},
				},
				{
					Name: to.Ptr("test-ora-backup"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-ora-backup"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ServiceLevel:    to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:        to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps: to.Ptr[float32](10),
						UsageThreshold:  to.Ptr[int64](107374182400),
						VolumeSpecName:  to.Ptr("ora-backup"),
					},
					Zones: []*string{
						to.Ptr("1")},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/netapp/resource-manager/Microsoft.NetApp/stable/2023-07-01/examples/VolumeGroups_Create_SapHana.json
func ExampleVolumeGroupsClient_BeginCreate_volumeGroupsCreateSapHana() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetapp.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVolumeGroupsClient().BeginCreate(ctx, "myRG", "account1", "group1", armnetapp.VolumeGroupDetails{
		Location: to.Ptr("westus"),
		Properties: &armnetapp.VolumeGroupProperties{
			GroupMetaData: &armnetapp.VolumeGroupMetaData{
				ApplicationIdentifier: to.Ptr("SH9"),
				ApplicationType:       to.Ptr(armnetapp.ApplicationTypeSAPHANA),
				GroupDescription:      to.Ptr("Volume group"),
			},
			Volumes: []*armnetapp.VolumeGroupVolumeProperties{
				{
					Name: to.Ptr("test-data-mnt00001"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-data-mnt00001"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ProximityPlacementGroup: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
						ServiceLevel:            to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:                to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps:         to.Ptr[float32](10),
						UsageThreshold:          to.Ptr[int64](107374182400),
						VolumeSpecName:          to.Ptr("data"),
					},
				},
				{
					Name: to.Ptr("test-log-mnt00001"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-log-mnt00001"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ProximityPlacementGroup: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
						ServiceLevel:            to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:                to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps:         to.Ptr[float32](10),
						UsageThreshold:          to.Ptr[int64](107374182400),
						VolumeSpecName:          to.Ptr("log"),
					},
				},
				{
					Name: to.Ptr("test-shared"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-shared"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ProximityPlacementGroup: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
						ServiceLevel:            to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:                to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps:         to.Ptr[float32](10),
						UsageThreshold:          to.Ptr[int64](107374182400),
						VolumeSpecName:          to.Ptr("shared"),
					},
				},
				{
					Name: to.Ptr("test-data-backup"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-data-backup"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ProximityPlacementGroup: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
						ServiceLevel:            to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:                to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps:         to.Ptr[float32](10),
						UsageThreshold:          to.Ptr[int64](107374182400),
						VolumeSpecName:          to.Ptr("data-backup"),
					},
				},
				{
					Name: to.Ptr("test-log-backup"),
					Properties: &armnetapp.VolumeProperties{
						CapacityPoolResourceID: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRG/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1"),
						CreationToken:          to.Ptr("test-log-backup"),
						ExportPolicy: &armnetapp.VolumePropertiesExportPolicy{
							Rules: []*armnetapp.ExportPolicyRule{
								{
									AllowedClients:      to.Ptr("0.0.0.0/0"),
									Cifs:                to.Ptr(false),
									HasRootAccess:       to.Ptr(true),
									Kerberos5ReadOnly:   to.Ptr(false),
									Kerberos5ReadWrite:  to.Ptr(false),
									Kerberos5IReadOnly:  to.Ptr(false),
									Kerberos5IReadWrite: to.Ptr(false),
									Kerberos5PReadOnly:  to.Ptr(false),
									Kerberos5PReadWrite: to.Ptr(false),
									Nfsv3:               to.Ptr(false),
									Nfsv41:              to.Ptr(true),
									RuleIndex:           to.Ptr[int32](1),
									UnixReadOnly:        to.Ptr(true),
									UnixReadWrite:       to.Ptr(true),
								}},
						},
						ProtocolTypes: []*string{
							to.Ptr("NFSv4.1")},
						ProximityPlacementGroup: to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/cys_sjain_fcp_rg/providers/Microsoft.Compute/proximityPlacementGroups/svlqa_sjain_multivolume_ppg"),
						ServiceLevel:            to.Ptr(armnetapp.ServiceLevelPremium),
						SubnetID:                to.Ptr("/subscriptions/d633cc2e-722b-4ae1-b636-bbd9e4c60ed9/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
						ThroughputMibps:         to.Ptr[float32](10),
						UsageThreshold:          to.Ptr[int64](107374182400),
						VolumeSpecName:          to.Ptr("log-backup"),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/netapp/resource-manager/Microsoft.NetApp/stable/2023-07-01/examples/VolumeGroups_Delete.json
func ExampleVolumeGroupsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetapp.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVolumeGroupsClient().BeginDelete(ctx, "myRG", "account1", "group1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
