//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmobilenetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mobilenetwork/armmobilenetwork/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-02-01/examples/PacketCoreControlPlaneDelete.json
func ExamplePacketCoreControlPlanesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmobilenetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPacketCoreControlPlanesClient().BeginDelete(ctx, "rg1", "TestPacketCoreCP", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-02-01/examples/PacketCoreControlPlaneGet.json
func ExamplePacketCoreControlPlanesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmobilenetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPacketCoreControlPlanesClient().Get(ctx, "rg1", "TestPacketCoreCP", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PacketCoreControlPlane = armmobilenetwork.PacketCoreControlPlane{
	// 	Name: to.Ptr("TestPacketCoreCP"),
	// 	Type: to.Ptr("Microsoft.MobileNetwork/packetCoreControlPlane"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP"),
	// 	SystemData: &armmobilenetwork.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armmobilenetwork.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armmobilenetwork.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armmobilenetwork.PacketCoreControlPlanePropertiesFormat{
	// 		ControlPlaneAccessInterface: &armmobilenetwork.InterfaceProperties{
	// 			Name: to.Ptr("N2"),
	// 		},
	// 		CoreNetworkTechnology: to.Ptr(armmobilenetwork.CoreNetworkTypeFiveGC),
	// 		EventHub: &armmobilenetwork.EventHubConfiguration{
	// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.EventHub/namespaces/contosoNamespace/eventHubs/contosoHub"),
	// 			ReportingInterval: to.Ptr[int32](60),
	// 		},
	// 		HomeNetworkPrivateKeysProvisioning: &armmobilenetwork.HomeNetworkPrivateKeysProvisioning{
	// 			State: to.Ptr(armmobilenetwork.HomeNetworkPrivateKeysProvisioningStateProvisioned),
	// 		},
	// 		Installation: &armmobilenetwork.Installation{
	// 			Operation: &armmobilenetwork.AsyncOperationID{
	// 				ID: to.Ptr("/providers/Microsoft.MobileNetwork/locations/EASTUS/operationStatuses/abc"),
	// 			},
	// 			State: to.Ptr(armmobilenetwork.InstallationStateInstalling),
	// 		},
	// 		InstalledVersion: to.Ptr("0.2.0"),
	// 		LocalDiagnosticsAccess: &armmobilenetwork.LocalDiagnosticsAccessConfiguration{
	// 			AuthenticationType: to.Ptr(armmobilenetwork.AuthenticationTypePassword),
	// 			HTTPSServerCertificate: &armmobilenetwork.HTTPSServerCertificate{
	// 				CertificateURL: to.Ptr("https://contosovault.vault.azure.net/certificates/ingress"),
	// 				Provisioning: &armmobilenetwork.CertificateProvisioning{
	// 					State: to.Ptr(armmobilenetwork.CertificateProvisioningStateNotProvisioned),
	// 				},
	// 			},
	// 		},
	// 		Platform: &armmobilenetwork.PlatformConfiguration{
	// 			Type: to.Ptr(armmobilenetwork.PlatformTypeAKSHCI),
	// 			AzureStackEdgeDevice: &armmobilenetwork.AzureStackEdgeDeviceResourceID{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
	// 			},
	// 			AzureStackEdgeDevices: []*armmobilenetwork.AzureStackEdgeDeviceResourceID{
	// 				{
	// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
	// 				},
	// 				{
	// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice2"),
	// 			}},
	// 			ConnectedCluster: &armmobilenetwork.ConnectedClusterResourceID{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster"),
	// 			},
	// 			CustomLocation: &armmobilenetwork.CustomLocationResourceID{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armmobilenetwork.ProvisioningStateSucceeded),
	// 		RollbackVersion: to.Ptr("0.1.0"),
	// 		Signaling: &armmobilenetwork.SignalingConfiguration{
	// 			NasReroute: &armmobilenetwork.NASRerouteConfiguration{
	// 				MacroMmeGroupID: to.Ptr[int32](1024),
	// 			},
	// 		},
	// 		Sites: []*armmobilenetwork.SiteResourceID{
	// 			{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite"),
	// 		}},
	// 		SKU: to.Ptr(armmobilenetwork.BillingSKUG0),
	// 		UeMtu: to.Ptr[int32](1600),
	// 		Version: to.Ptr("0.2.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-02-01/examples/PacketCoreControlPlaneCreate.json
func ExamplePacketCoreControlPlanesClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmobilenetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPacketCoreControlPlanesClient().BeginCreateOrUpdate(ctx, "rg1", "TestPacketCoreCP", armmobilenetwork.PacketCoreControlPlane{
		Location: to.Ptr("eastus"),
		Properties: &armmobilenetwork.PacketCoreControlPlanePropertiesFormat{
			ControlPlaneAccessInterface: &armmobilenetwork.InterfaceProperties{
				Name: to.Ptr("N2"),
			},
			CoreNetworkTechnology: to.Ptr(armmobilenetwork.CoreNetworkTypeFiveGC),
			EventHub: &armmobilenetwork.EventHubConfiguration{
				ID:                to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.EventHub/namespaces/contosoNamespace/eventHubs/contosoHub"),
				ReportingInterval: to.Ptr[int32](60),
			},
			Installation: &armmobilenetwork.Installation{
				DesiredState: to.Ptr(armmobilenetwork.DesiredInstallationStateInstalled),
			},
			LocalDiagnosticsAccess: &armmobilenetwork.LocalDiagnosticsAccessConfiguration{
				AuthenticationType: to.Ptr(armmobilenetwork.AuthenticationTypeAAD),
				HTTPSServerCertificate: &armmobilenetwork.HTTPSServerCertificate{
					CertificateURL: to.Ptr("https://contosovault.vault.azure.net/certificates/ingress"),
				},
			},
			Platform: &armmobilenetwork.PlatformConfiguration{
				Type: to.Ptr(armmobilenetwork.PlatformTypeAKSHCI),
				AzureStackEdgeDevice: &armmobilenetwork.AzureStackEdgeDeviceResourceID{
					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
				},
				ConnectedCluster: &armmobilenetwork.ConnectedClusterResourceID{
					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster"),
				},
				CustomLocation: &armmobilenetwork.CustomLocationResourceID{
					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation"),
				},
			},
			Signaling: &armmobilenetwork.SignalingConfiguration{
				NasReroute: &armmobilenetwork.NASRerouteConfiguration{
					MacroMmeGroupID: to.Ptr[int32](1024),
				},
			},
			Sites: []*armmobilenetwork.SiteResourceID{
				{
					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite"),
				}},
			SKU:     to.Ptr(armmobilenetwork.BillingSKUG0),
			UeMtu:   to.Ptr[int32](1600),
			Version: to.Ptr("0.2.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PacketCoreControlPlane = armmobilenetwork.PacketCoreControlPlane{
	// 	Name: to.Ptr("TestPacketCoreCP"),
	// 	Type: to.Ptr("Microsoft.MobileNetwork/packetCoreControlPlane"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP"),
	// 	SystemData: &armmobilenetwork.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armmobilenetwork.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armmobilenetwork.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armmobilenetwork.PacketCoreControlPlanePropertiesFormat{
	// 		ControlPlaneAccessInterface: &armmobilenetwork.InterfaceProperties{
	// 			Name: to.Ptr("N2"),
	// 		},
	// 		CoreNetworkTechnology: to.Ptr(armmobilenetwork.CoreNetworkTypeFiveGC),
	// 		EventHub: &armmobilenetwork.EventHubConfiguration{
	// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.EventHub/namespaces/contosoNamespace/eventHubs/contosoHub"),
	// 			ReportingInterval: to.Ptr[int32](60),
	// 		},
	// 		Installation: &armmobilenetwork.Installation{
	// 			DesiredState: to.Ptr(armmobilenetwork.DesiredInstallationStateInstalled),
	// 			ReinstallRequired: to.Ptr(armmobilenetwork.ReinstallRequiredNotRequired),
	// 			State: to.Ptr(armmobilenetwork.InstallationStateInstalled),
	// 		},
	// 		LocalDiagnosticsAccess: &armmobilenetwork.LocalDiagnosticsAccessConfiguration{
	// 			AuthenticationType: to.Ptr(armmobilenetwork.AuthenticationTypeAAD),
	// 			HTTPSServerCertificate: &armmobilenetwork.HTTPSServerCertificate{
	// 				CertificateURL: to.Ptr("https://contosovault.vault.azure.net/certificates/ingress"),
	// 				Provisioning: &armmobilenetwork.CertificateProvisioning{
	// 					State: to.Ptr(armmobilenetwork.CertificateProvisioningStateNotProvisioned),
	// 				},
	// 			},
	// 		},
	// 		Platform: &armmobilenetwork.PlatformConfiguration{
	// 			Type: to.Ptr(armmobilenetwork.PlatformTypeAKSHCI),
	// 			AzureStackEdgeDevice: &armmobilenetwork.AzureStackEdgeDeviceResourceID{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
	// 			},
	// 			AzureStackEdgeDevices: []*armmobilenetwork.AzureStackEdgeDeviceResourceID{
	// 				{
	// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
	// 				},
	// 				{
	// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice2"),
	// 			}},
	// 			ConnectedCluster: &armmobilenetwork.ConnectedClusterResourceID{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster"),
	// 			},
	// 			CustomLocation: &armmobilenetwork.CustomLocationResourceID{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armmobilenetwork.ProvisioningStateSucceeded),
	// 		Signaling: &armmobilenetwork.SignalingConfiguration{
	// 			NasReroute: &armmobilenetwork.NASRerouteConfiguration{
	// 				MacroMmeGroupID: to.Ptr[int32](1024),
	// 			},
	// 		},
	// 		Sites: []*armmobilenetwork.SiteResourceID{
	// 			{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite"),
	// 		}},
	// 		SKU: to.Ptr(armmobilenetwork.BillingSKUG0),
	// 		UeMtu: to.Ptr[int32](1600),
	// 		Version: to.Ptr("0.2.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-02-01/examples/PacketCoreControlPlanePatch.json
func ExamplePacketCoreControlPlanesClient_UpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmobilenetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPacketCoreControlPlanesClient().UpdateTags(ctx, "rg1", "TestPacketCoreCP", armmobilenetwork.IdentityAndTagsObject{
		Identity: &armmobilenetwork.ManagedServiceIdentity{
			Type: to.Ptr(armmobilenetwork.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armmobilenetwork.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testUserAssignedManagedIdentity": {},
			},
		},
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PacketCoreControlPlane = armmobilenetwork.PacketCoreControlPlane{
	// 	Name: to.Ptr("TestPacketCoreCP"),
	// 	Type: to.Ptr("Microsoft.MobileNetwork/packetCoreControlPlane"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP"),
	// 	SystemData: &armmobilenetwork.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armmobilenetwork.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armmobilenetwork.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Identity: &armmobilenetwork.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmobilenetwork.ManagedServiceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armmobilenetwork.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/testUserAssignedManagedIdentity": &armmobilenetwork.UserAssignedIdentity{
	// 				ClientID: to.Ptr("12345678-abcd-dcba-abcd-0123456789ef"),
	// 				PrincipalID: to.Ptr("12345678-abcd-dcba-abcd-0123456789ef"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armmobilenetwork.PacketCoreControlPlanePropertiesFormat{
	// 		ControlPlaneAccessInterface: &armmobilenetwork.InterfaceProperties{
	// 			Name: to.Ptr("N2"),
	// 		},
	// 		CoreNetworkTechnology: to.Ptr(armmobilenetwork.CoreNetworkTypeFiveGC),
	// 		Installation: &armmobilenetwork.Installation{
	// 			State: to.Ptr(armmobilenetwork.InstallationStateInstalled),
	// 		},
	// 		InstalledVersion: to.Ptr("0.2.0"),
	// 		LocalDiagnosticsAccess: &armmobilenetwork.LocalDiagnosticsAccessConfiguration{
	// 			AuthenticationType: to.Ptr(armmobilenetwork.AuthenticationTypePassword),
	// 			HTTPSServerCertificate: &armmobilenetwork.HTTPSServerCertificate{
	// 				CertificateURL: to.Ptr("https://contosovault.vault.azure.net/certificates/ingress"),
	// 				Provisioning: &armmobilenetwork.CertificateProvisioning{
	// 					State: to.Ptr(armmobilenetwork.CertificateProvisioningStateNotProvisioned),
	// 				},
	// 			},
	// 		},
	// 		Platform: &armmobilenetwork.PlatformConfiguration{
	// 			Type: to.Ptr(armmobilenetwork.PlatformTypeAKSHCI),
	// 			AzureStackEdgeDevice: &armmobilenetwork.AzureStackEdgeDeviceResourceID{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
	// 			},
	// 			AzureStackEdgeDevices: []*armmobilenetwork.AzureStackEdgeDeviceResourceID{
	// 				{
	// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
	// 				},
	// 				{
	// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice2"),
	// 			}},
	// 			ConnectedCluster: &armmobilenetwork.ConnectedClusterResourceID{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster"),
	// 			},
	// 			CustomLocation: &armmobilenetwork.CustomLocationResourceID{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr(armmobilenetwork.ProvisioningStateSucceeded),
	// 		RollbackVersion: to.Ptr("0.1.0"),
	// 		Sites: []*armmobilenetwork.SiteResourceID{
	// 			{
	// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite"),
	// 		}},
	// 		SKU: to.Ptr(armmobilenetwork.BillingSKUG0),
	// 		UeMtu: to.Ptr[int32](1600),
	// 		Version: to.Ptr("0.2.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-02-01/examples/PacketCoreControlPlaneListBySubscription.json
func ExamplePacketCoreControlPlanesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmobilenetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPacketCoreControlPlanesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PacketCoreControlPlaneListResult = armmobilenetwork.PacketCoreControlPlaneListResult{
		// 	Value: []*armmobilenetwork.PacketCoreControlPlane{
		// 		{
		// 			Name: to.Ptr("TestPacketCoreCP"),
		// 			Type: to.Ptr("Microsoft.MobileNetwork/packetCoreControlPlane"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP"),
		// 			SystemData: &armmobilenetwork.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armmobilenetwork.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armmobilenetwork.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armmobilenetwork.PacketCoreControlPlanePropertiesFormat{
		// 				ControlPlaneAccessInterface: &armmobilenetwork.InterfaceProperties{
		// 					Name: to.Ptr("N2"),
		// 				},
		// 				CoreNetworkTechnology: to.Ptr(armmobilenetwork.CoreNetworkTypeFiveGC),
		// 				Installation: &armmobilenetwork.Installation{
		// 					State: to.Ptr(armmobilenetwork.InstallationStateInstalled),
		// 				},
		// 				InstalledVersion: to.Ptr("0.2.0"),
		// 				LocalDiagnosticsAccess: &armmobilenetwork.LocalDiagnosticsAccessConfiguration{
		// 					AuthenticationType: to.Ptr(armmobilenetwork.AuthenticationTypePassword),
		// 					HTTPSServerCertificate: &armmobilenetwork.HTTPSServerCertificate{
		// 						CertificateURL: to.Ptr("https://contosovault.vault.azure.net/certificates/ingress"),
		// 						Provisioning: &armmobilenetwork.CertificateProvisioning{
		// 							State: to.Ptr(armmobilenetwork.CertificateProvisioningStateNotProvisioned),
		// 						},
		// 					},
		// 				},
		// 				Platform: &armmobilenetwork.PlatformConfiguration{
		// 					Type: to.Ptr(armmobilenetwork.PlatformTypeAKSHCI),
		// 					AzureStackEdgeDevice: &armmobilenetwork.AzureStackEdgeDeviceResourceID{
		// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
		// 					},
		// 					AzureStackEdgeDevices: []*armmobilenetwork.AzureStackEdgeDeviceResourceID{
		// 						{
		// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
		// 						},
		// 						{
		// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice2"),
		// 					}},
		// 					ConnectedCluster: &armmobilenetwork.ConnectedClusterResourceID{
		// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster"),
		// 					},
		// 					CustomLocation: &armmobilenetwork.CustomLocationResourceID{
		// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation"),
		// 					},
		// 				},
		// 				ProvisioningState: to.Ptr(armmobilenetwork.ProvisioningStateSucceeded),
		// 				RollbackVersion: to.Ptr("0.1.0"),
		// 				Sites: []*armmobilenetwork.SiteResourceID{
		// 					{
		// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite"),
		// 				}},
		// 				SKU: to.Ptr(armmobilenetwork.BillingSKUG0),
		// 				UeMtu: to.Ptr[int32](1600),
		// 				Version: to.Ptr("0.2.0"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-02-01/examples/PacketCoreControlPlaneListByResourceGroup.json
func ExamplePacketCoreControlPlanesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmobilenetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPacketCoreControlPlanesClient().NewListByResourceGroupPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PacketCoreControlPlaneListResult = armmobilenetwork.PacketCoreControlPlaneListResult{
		// 	Value: []*armmobilenetwork.PacketCoreControlPlane{
		// 		{
		// 			Name: to.Ptr("TestPacketCoreCP"),
		// 			Type: to.Ptr("Microsoft.MobileNetwork/packetCoreControlPlane"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP"),
		// 			SystemData: &armmobilenetwork.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armmobilenetwork.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armmobilenetwork.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armmobilenetwork.PacketCoreControlPlanePropertiesFormat{
		// 				ControlPlaneAccessInterface: &armmobilenetwork.InterfaceProperties{
		// 					Name: to.Ptr("N2"),
		// 				},
		// 				CoreNetworkTechnology: to.Ptr(armmobilenetwork.CoreNetworkTypeFiveGC),
		// 				HomeNetworkPrivateKeysProvisioning: &armmobilenetwork.HomeNetworkPrivateKeysProvisioning{
		// 					State: to.Ptr(armmobilenetwork.HomeNetworkPrivateKeysProvisioningStateProvisioned),
		// 				},
		// 				Installation: &armmobilenetwork.Installation{
		// 					Reasons: []*armmobilenetwork.InstallationReason{
		// 						to.Ptr(armmobilenetwork.InstallationReasonNoSlices)},
		// 						State: to.Ptr(armmobilenetwork.InstallationStateUninstalled),
		// 					},
		// 					InstalledVersion: to.Ptr("0.2.0"),
		// 					LocalDiagnosticsAccess: &armmobilenetwork.LocalDiagnosticsAccessConfiguration{
		// 						AuthenticationType: to.Ptr(armmobilenetwork.AuthenticationTypePassword),
		// 						HTTPSServerCertificate: &armmobilenetwork.HTTPSServerCertificate{
		// 							CertificateURL: to.Ptr("https://contosovault.vault.azure.net/certificates/ingress"),
		// 							Provisioning: &armmobilenetwork.CertificateProvisioning{
		// 								State: to.Ptr(armmobilenetwork.CertificateProvisioningStateNotProvisioned),
		// 							},
		// 						},
		// 					},
		// 					Platform: &armmobilenetwork.PlatformConfiguration{
		// 						Type: to.Ptr(armmobilenetwork.PlatformTypeAKSHCI),
		// 						AzureStackEdgeDevice: &armmobilenetwork.AzureStackEdgeDeviceResourceID{
		// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
		// 						},
		// 						AzureStackEdgeDevices: []*armmobilenetwork.AzureStackEdgeDeviceResourceID{
		// 							{
		// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice"),
		// 							},
		// 							{
		// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/TestAzureStackEdgeDevice2"),
		// 						}},
		// 						ConnectedCluster: &armmobilenetwork.ConnectedClusterResourceID{
		// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/TestConnectedCluster"),
		// 						},
		// 						CustomLocation: &armmobilenetwork.CustomLocationResourceID{
		// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/TestCustomLocation"),
		// 						},
		// 					},
		// 					ProvisioningState: to.Ptr(armmobilenetwork.ProvisioningStateSucceeded),
		// 					RollbackVersion: to.Ptr("0.1.0"),
		// 					Sites: []*armmobilenetwork.SiteResourceID{
		// 						{
		// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/sites/testSite"),
		// 					}},
		// 					SKU: to.Ptr(armmobilenetwork.BillingSKUG0),
		// 					UeMtu: to.Ptr[int32](1600),
		// 					Version: to.Ptr("0.2.0"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-02-01/examples/PacketCoreControlPlaneRollback.json
func ExamplePacketCoreControlPlanesClient_BeginRollback() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmobilenetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPacketCoreControlPlanesClient().BeginRollback(ctx, "rg1", "TestPacketCoreCP", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AsyncOperationStatus = armmobilenetwork.AsyncOperationStatus{
	// 	Name: to.Ptr("testOperation"),
	// 	EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:38:07.000Z"); return t}()),
	// 	ID: to.Ptr("/providers/Microsoft.MobileNetwork/locations/testLocation/operationStatuses/testOperation"),
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:36:07.000Z"); return t}()),
	// 	Status: to.Ptr("Succeeded"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-02-01/examples/PacketCoreControlPlaneReinstall.json
func ExamplePacketCoreControlPlanesClient_BeginReinstall() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmobilenetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPacketCoreControlPlanesClient().BeginReinstall(ctx, "rg1", "TestPacketCoreCP", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AsyncOperationStatus = armmobilenetwork.AsyncOperationStatus{
	// 	Name: to.Ptr("testOperation"),
	// 	EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:38:07.000Z"); return t}()),
	// 	ID: to.Ptr("/providers/Microsoft.MobileNetwork/locations/testLocation/operationStatuses/testOperation"),
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:36:07.000Z"); return t}()),
	// 	Status: to.Ptr("Succeeded"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/mobilenetwork/resource-manager/Microsoft.MobileNetwork/stable/2024-02-01/examples/PacketCoreControlPlaneCollectDiagnosticsPackage.json
func ExamplePacketCoreControlPlanesClient_BeginCollectDiagnosticsPackage() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmobilenetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewPacketCoreControlPlanesClient().BeginCollectDiagnosticsPackage(ctx, "rg1", "TestPacketCoreCP", armmobilenetwork.PacketCoreControlPlaneCollectDiagnosticsPackage{
		StorageAccountBlobURL: to.Ptr("https://contosoaccount.blob.core.windows.net/container/diagnosticsPackage.zip"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AsyncOperationStatus = armmobilenetwork.AsyncOperationStatus{
	// 	Name: to.Ptr("testOperation"),
	// 	EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:38:07.000Z"); return t}()),
	// 	ID: to.Ptr("/providers/Microsoft.MobileNetwork/locations/testLocation/operationStatuses/testOperation"),
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:36:07.000Z"); return t}()),
	// 	Status: to.Ptr("Succeeded"),
	// }
}
