//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrationdiscoverysap

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/migrationdiscovery/armmigrationdiscoverysap"
	moduleVersion = "v0.1.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DataSource - The data source for this resource.
type DataSource string

const (
	// DataSourceExcel - The type of DataSource- Excel.
	DataSourceExcel DataSource = "Excel"
	// DataSourceNative - The type of DataSource- Native.
	DataSourceNative DataSource = "Native"
)

// PossibleDataSourceValues returns the possible values for the DataSource const type.
func PossibleDataSourceValues() []DataSource {
	return []DataSource{
		DataSourceExcel,
		DataSourceNative,
	}
}

// DatabaseType - Select the database if this is a database server. Leave blank or add Not Applicable for all other instances
// except the Database Instance.
type DatabaseType string

const (
	// DatabaseTypeAdabas - The type of Database- Adabas.
	DatabaseTypeAdabas DatabaseType = "Adabas"
	// DatabaseTypeDb2 - The type of Database- Db2.
	DatabaseTypeDb2 DatabaseType = "Db2"
	// DatabaseTypeHANA - The type of Database- HANA.
	DatabaseTypeHANA DatabaseType = "HANA"
	// DatabaseTypeInformix - The type of Database- Informix.
	DatabaseTypeInformix DatabaseType = "Informix"
	// DatabaseTypeOracle - The type of Database- Oracle.
	DatabaseTypeOracle DatabaseType = "Oracle"
	// DatabaseTypeSAPASE - The type of Database- SAPASE.
	DatabaseTypeSAPASE DatabaseType = "SAPASE"
	// DatabaseTypeSAPDB - The type of Database- SAPDB.
	DatabaseTypeSAPDB DatabaseType = "SAPDB"
	// DatabaseTypeSAPMaxDB - The type of Database- SAPMaxDB.
	DatabaseTypeSAPMaxDB DatabaseType = "SAPMaxDB"
	// DatabaseTypeSQLServer - The type of Database- SQLServer.
	DatabaseTypeSQLServer DatabaseType = "SQLServer"
)

// PossibleDatabaseTypeValues returns the possible values for the DatabaseType const type.
func PossibleDatabaseTypeValues() []DatabaseType {
	return []DatabaseType{
		DatabaseTypeAdabas,
		DatabaseTypeDb2,
		DatabaseTypeHANA,
		DatabaseTypeInformix,
		DatabaseTypeOracle,
		DatabaseTypeSAPASE,
		DatabaseTypeSAPDB,
		DatabaseTypeSAPMaxDB,
		DatabaseTypeSQLServer,
	}
}

// OperatingSystem - This is Operating System on which the host server is running.
type OperatingSystem string

const (
	// OperatingSystemIBMAIX - The type of Operating system- IBMAIX.
	OperatingSystemIBMAIX OperatingSystem = "IBMAIX"
	// OperatingSystemRedHat - The type of Operating system- RedHat.
	OperatingSystemRedHat OperatingSystem = "RedHat"
	// OperatingSystemSUSE - The type of Operating system- SUSE.
	OperatingSystemSUSE OperatingSystem = "SUSE"
	// OperatingSystemSolaris - The type of Operating system- Solaris.
	OperatingSystemSolaris OperatingSystem = "Solaris"
	// OperatingSystemUnix - The type of Operating system- Unix.
	OperatingSystemUnix OperatingSystem = "Unix"
	// OperatingSystemWindowsServer - The type of Operating system- WindowsServer.
	OperatingSystemWindowsServer OperatingSystem = "WindowsServer"
)

// PossibleOperatingSystemValues returns the possible values for the OperatingSystem const type.
func PossibleOperatingSystemValues() []OperatingSystem {
	return []OperatingSystem{
		OperatingSystemIBMAIX,
		OperatingSystemRedHat,
		OperatingSystemSUSE,
		OperatingSystemSolaris,
		OperatingSystemUnix,
		OperatingSystemWindowsServer,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// ProvisioningState - Defines the provisioning states.
type ProvisioningState string

const (
	// ProvisioningStateAccepted - The provisioning state Accepted.
	ProvisioningStateAccepted ProvisioningState = "Accepted"
	// ProvisioningStateCanceled - The provisioning state Cancelled.
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating - The provisioning state Creating.
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting - The provisioning state Deleting.
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed - The provisioning state Failed.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded - The provisioning state Succeeded.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUnknown - The provisioning state Unknown.
	ProvisioningStateUnknown ProvisioningState = "Unknown"
	// ProvisioningStateUpdating - The provisioning state Updating.
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateAccepted,
		ProvisioningStateCanceled,
		ProvisioningStateCreating,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
		ProvisioningStateUnknown,
		ProvisioningStateUpdating,
	}
}

// SapInstanceEnvironment - The Environment; PRD, QA, DEV, etc to which SAP system belongs to. Select from the list of available
// dropdown values.
type SapInstanceEnvironment string

const (
	// SapInstanceEnvironmentDevelopment - The type of Sap Instance Environment- Development.
	SapInstanceEnvironmentDevelopment SapInstanceEnvironment = "Development"
	// SapInstanceEnvironmentDisasterRecovery - The type of Sap Instance Environment- DisasterRecovery.
	SapInstanceEnvironmentDisasterRecovery SapInstanceEnvironment = "DisasterRecovery"
	// SapInstanceEnvironmentPreProduction - The type of Sap Instance Environment- PreProduction.
	SapInstanceEnvironmentPreProduction SapInstanceEnvironment = "PreProduction"
	// SapInstanceEnvironmentProduction - The type of Sap Instance Environment- Production.
	SapInstanceEnvironmentProduction SapInstanceEnvironment = "Production"
	// SapInstanceEnvironmentQualityAssurance - The type of Sap Instance Environment- QualityAssurance.
	SapInstanceEnvironmentQualityAssurance SapInstanceEnvironment = "QualityAssurance"
	// SapInstanceEnvironmentSandbox - The type of Sap Instance Environment- Sandbox.
	SapInstanceEnvironmentSandbox SapInstanceEnvironment = "Sandbox"
	// SapInstanceEnvironmentTest - The type of Sap Instance Environment- Test.
	SapInstanceEnvironmentTest SapInstanceEnvironment = "Test"
	// SapInstanceEnvironmentTraining - The type of Sap Instance Environment- Training.
	SapInstanceEnvironmentTraining SapInstanceEnvironment = "Training"
)

// PossibleSapInstanceEnvironmentValues returns the possible values for the SapInstanceEnvironment const type.
func PossibleSapInstanceEnvironmentValues() []SapInstanceEnvironment {
	return []SapInstanceEnvironment{
		SapInstanceEnvironmentDevelopment,
		SapInstanceEnvironmentDisasterRecovery,
		SapInstanceEnvironmentPreProduction,
		SapInstanceEnvironmentProduction,
		SapInstanceEnvironmentQualityAssurance,
		SapInstanceEnvironmentSandbox,
		SapInstanceEnvironmentTest,
		SapInstanceEnvironmentTraining,
	}
}

// SapInstanceType - The SAP instance type running on this machine, e.g., App, ASCS, DB, etc. Select from the list of available
// dropdown values. Only single server and distributed architectures are supported.
type SapInstanceType string

const (
	// SapInstanceTypeAPP - The type of Sap Instance- APP.
	SapInstanceTypeAPP SapInstanceType = "APP"
	// SapInstanceTypeASCS - The type of Sap Instance- ASCS.
	SapInstanceTypeASCS SapInstanceType = "ASCS"
	// SapInstanceTypeDB - The type of Sap Instance- DB.
	SapInstanceTypeDB SapInstanceType = "DB"
	// SapInstanceTypeSCS - The type of Sap Instance- SCS.
	SapInstanceTypeSCS SapInstanceType = "SCS"
	// SapInstanceTypeWEBDISP - The type of Sap Instance- WEBDISP.
	SapInstanceTypeWEBDISP SapInstanceType = "WEBDISP"
)

// PossibleSapInstanceTypeValues returns the possible values for the SapInstanceType const type.
func PossibleSapInstanceTypeValues() []SapInstanceType {
	return []SapInstanceType{
		SapInstanceTypeAPP,
		SapInstanceTypeASCS,
		SapInstanceTypeDB,
		SapInstanceTypeSCS,
		SapInstanceTypeWEBDISP,
	}
}
