//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/marketplace/armmarketplace"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// PrivateStoreServer is a fake server for instances of the armmarketplace.PrivateStoreClient type.
type PrivateStoreServer struct {
	// AcknowledgeOfferNotification is the fake for method PrivateStoreClient.AcknowledgeOfferNotification
	// HTTP status codes to indicate success: http.StatusOK
	AcknowledgeOfferNotification func(ctx context.Context, privateStoreID string, offerID string, options *armmarketplace.PrivateStoreClientAcknowledgeOfferNotificationOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientAcknowledgeOfferNotificationResponse], errResp azfake.ErrorResponder)

	// AdminRequestApprovalsList is the fake for method PrivateStoreClient.AdminRequestApprovalsList
	// HTTP status codes to indicate success: http.StatusOK
	AdminRequestApprovalsList func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientAdminRequestApprovalsListOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientAdminRequestApprovalsListResponse], errResp azfake.ErrorResponder)

	// BillingAccounts is the fake for method PrivateStoreClient.BillingAccounts
	// HTTP status codes to indicate success: http.StatusOK
	BillingAccounts func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientBillingAccountsOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientBillingAccountsResponse], errResp azfake.ErrorResponder)

	// BulkCollectionsAction is the fake for method PrivateStoreClient.BulkCollectionsAction
	// HTTP status codes to indicate success: http.StatusOK
	BulkCollectionsAction func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientBulkCollectionsActionOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientBulkCollectionsActionResponse], errResp azfake.ErrorResponder)

	// CollectionsToSubscriptionsMapping is the fake for method PrivateStoreClient.CollectionsToSubscriptionsMapping
	// HTTP status codes to indicate success: http.StatusOK
	CollectionsToSubscriptionsMapping func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientCollectionsToSubscriptionsMappingOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientCollectionsToSubscriptionsMappingResponse], errResp azfake.ErrorResponder)

	// CreateApprovalRequest is the fake for method PrivateStoreClient.CreateApprovalRequest
	// HTTP status codes to indicate success: http.StatusOK
	CreateApprovalRequest func(ctx context.Context, privateStoreID string, requestApprovalID string, options *armmarketplace.PrivateStoreClientCreateApprovalRequestOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientCreateApprovalRequestResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdate is the fake for method PrivateStoreClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientCreateOrUpdateOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method PrivateStoreClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientDeleteOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientDeleteResponse], errResp azfake.ErrorResponder)

	// FetchAllSubscriptionsInTenant is the fake for method PrivateStoreClient.FetchAllSubscriptionsInTenant
	// HTTP status codes to indicate success: http.StatusOK
	FetchAllSubscriptionsInTenant func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientFetchAllSubscriptionsInTenantOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientFetchAllSubscriptionsInTenantResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PrivateStoreClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientGetOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientGetResponse], errResp azfake.ErrorResponder)

	// GetAdminRequestApproval is the fake for method PrivateStoreClient.GetAdminRequestApproval
	// HTTP status codes to indicate success: http.StatusOK
	GetAdminRequestApproval func(ctx context.Context, privateStoreID string, adminRequestApprovalID string, publisherID string, options *armmarketplace.PrivateStoreClientGetAdminRequestApprovalOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientGetAdminRequestApprovalResponse], errResp azfake.ErrorResponder)

	// GetApprovalRequestsList is the fake for method PrivateStoreClient.GetApprovalRequestsList
	// HTTP status codes to indicate success: http.StatusOK
	GetApprovalRequestsList func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientGetApprovalRequestsListOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientGetApprovalRequestsListResponse], errResp azfake.ErrorResponder)

	// GetRequestApproval is the fake for method PrivateStoreClient.GetRequestApproval
	// HTTP status codes to indicate success: http.StatusOK
	GetRequestApproval func(ctx context.Context, privateStoreID string, requestApprovalID string, options *armmarketplace.PrivateStoreClientGetRequestApprovalOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientGetRequestApprovalResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PrivateStoreClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armmarketplace.PrivateStoreClientListOptions) (resp azfake.PagerResponder[armmarketplace.PrivateStoreClientListResponse])

	// ListNewPlansNotifications is the fake for method PrivateStoreClient.ListNewPlansNotifications
	// HTTP status codes to indicate success: http.StatusOK
	ListNewPlansNotifications func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientListNewPlansNotificationsOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientListNewPlansNotificationsResponse], errResp azfake.ErrorResponder)

	// ListStopSellOffersPlansNotifications is the fake for method PrivateStoreClient.ListStopSellOffersPlansNotifications
	// HTTP status codes to indicate success: http.StatusOK
	ListStopSellOffersPlansNotifications func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientListStopSellOffersPlansNotificationsOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientListStopSellOffersPlansNotificationsResponse], errResp azfake.ErrorResponder)

	// ListSubscriptionsContext is the fake for method PrivateStoreClient.ListSubscriptionsContext
	// HTTP status codes to indicate success: http.StatusOK
	ListSubscriptionsContext func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientListSubscriptionsContextOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientListSubscriptionsContextResponse], errResp azfake.ErrorResponder)

	// QueryApprovedPlans is the fake for method PrivateStoreClient.QueryApprovedPlans
	// HTTP status codes to indicate success: http.StatusOK
	QueryApprovedPlans func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientQueryApprovedPlansOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientQueryApprovedPlansResponse], errResp azfake.ErrorResponder)

	// QueryNotificationsState is the fake for method PrivateStoreClient.QueryNotificationsState
	// HTTP status codes to indicate success: http.StatusOK
	QueryNotificationsState func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientQueryNotificationsStateOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientQueryNotificationsStateResponse], errResp azfake.ErrorResponder)

	// QueryOffers is the fake for method PrivateStoreClient.QueryOffers
	// HTTP status codes to indicate success: http.StatusOK
	QueryOffers func(ctx context.Context, privateStoreID string, options *armmarketplace.PrivateStoreClientQueryOffersOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientQueryOffersResponse], errResp azfake.ErrorResponder)

	// QueryRequestApproval is the fake for method PrivateStoreClient.QueryRequestApproval
	// HTTP status codes to indicate success: http.StatusOK
	QueryRequestApproval func(ctx context.Context, privateStoreID string, requestApprovalID string, options *armmarketplace.PrivateStoreClientQueryRequestApprovalOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientQueryRequestApprovalResponse], errResp azfake.ErrorResponder)

	// UpdateAdminRequestApproval is the fake for method PrivateStoreClient.UpdateAdminRequestApproval
	// HTTP status codes to indicate success: http.StatusOK
	UpdateAdminRequestApproval func(ctx context.Context, privateStoreID string, adminRequestApprovalID string, options *armmarketplace.PrivateStoreClientUpdateAdminRequestApprovalOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientUpdateAdminRequestApprovalResponse], errResp azfake.ErrorResponder)

	// WithdrawPlan is the fake for method PrivateStoreClient.WithdrawPlan
	// HTTP status codes to indicate success: http.StatusOK
	WithdrawPlan func(ctx context.Context, privateStoreID string, requestApprovalID string, options *armmarketplace.PrivateStoreClientWithdrawPlanOptions) (resp azfake.Responder[armmarketplace.PrivateStoreClientWithdrawPlanResponse], errResp azfake.ErrorResponder)
}

// NewPrivateStoreServerTransport creates a new instance of PrivateStoreServerTransport with the provided implementation.
// The returned PrivateStoreServerTransport instance is connected to an instance of armmarketplace.PrivateStoreClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateStoreServerTransport(srv *PrivateStoreServer) *PrivateStoreServerTransport {
	return &PrivateStoreServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmarketplace.PrivateStoreClientListResponse]](),
	}
}

// PrivateStoreServerTransport connects instances of armmarketplace.PrivateStoreClient to instances of PrivateStoreServer.
// Don't use this type directly, use NewPrivateStoreServerTransport instead.
type PrivateStoreServerTransport struct {
	srv          *PrivateStoreServer
	newListPager *tracker[azfake.PagerResponder[armmarketplace.PrivateStoreClientListResponse]]
}

// Do implements the policy.Transporter interface for PrivateStoreServerTransport.
func (p *PrivateStoreServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateStoreClient.AcknowledgeOfferNotification":
		resp, err = p.dispatchAcknowledgeOfferNotification(req)
	case "PrivateStoreClient.AdminRequestApprovalsList":
		resp, err = p.dispatchAdminRequestApprovalsList(req)
	case "PrivateStoreClient.BillingAccounts":
		resp, err = p.dispatchBillingAccounts(req)
	case "PrivateStoreClient.BulkCollectionsAction":
		resp, err = p.dispatchBulkCollectionsAction(req)
	case "PrivateStoreClient.CollectionsToSubscriptionsMapping":
		resp, err = p.dispatchCollectionsToSubscriptionsMapping(req)
	case "PrivateStoreClient.CreateApprovalRequest":
		resp, err = p.dispatchCreateApprovalRequest(req)
	case "PrivateStoreClient.CreateOrUpdate":
		resp, err = p.dispatchCreateOrUpdate(req)
	case "PrivateStoreClient.Delete":
		resp, err = p.dispatchDelete(req)
	case "PrivateStoreClient.FetchAllSubscriptionsInTenant":
		resp, err = p.dispatchFetchAllSubscriptionsInTenant(req)
	case "PrivateStoreClient.Get":
		resp, err = p.dispatchGet(req)
	case "PrivateStoreClient.GetAdminRequestApproval":
		resp, err = p.dispatchGetAdminRequestApproval(req)
	case "PrivateStoreClient.GetApprovalRequestsList":
		resp, err = p.dispatchGetApprovalRequestsList(req)
	case "PrivateStoreClient.GetRequestApproval":
		resp, err = p.dispatchGetRequestApproval(req)
	case "PrivateStoreClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	case "PrivateStoreClient.ListNewPlansNotifications":
		resp, err = p.dispatchListNewPlansNotifications(req)
	case "PrivateStoreClient.ListStopSellOffersPlansNotifications":
		resp, err = p.dispatchListStopSellOffersPlansNotifications(req)
	case "PrivateStoreClient.ListSubscriptionsContext":
		resp, err = p.dispatchListSubscriptionsContext(req)
	case "PrivateStoreClient.QueryApprovedPlans":
		resp, err = p.dispatchQueryApprovedPlans(req)
	case "PrivateStoreClient.QueryNotificationsState":
		resp, err = p.dispatchQueryNotificationsState(req)
	case "PrivateStoreClient.QueryOffers":
		resp, err = p.dispatchQueryOffers(req)
	case "PrivateStoreClient.QueryRequestApproval":
		resp, err = p.dispatchQueryRequestApproval(req)
	case "PrivateStoreClient.UpdateAdminRequestApproval":
		resp, err = p.dispatchUpdateAdminRequestApproval(req)
	case "PrivateStoreClient.WithdrawPlan":
		resp, err = p.dispatchWithdrawPlan(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchAcknowledgeOfferNotification(req *http.Request) (*http.Response, error) {
	if p.srv.AcknowledgeOfferNotification == nil {
		return nil, &nonRetriableError{errors.New("fake for method AcknowledgeOfferNotification not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/offers/(?P<offerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/acknowledgeNotification`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.AcknowledgeOfferNotificationProperties](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	offerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("offerId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreClientAcknowledgeOfferNotificationOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreClientAcknowledgeOfferNotificationOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.AcknowledgeOfferNotification(req.Context(), privateStoreIDParam, offerIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchAdminRequestApprovalsList(req *http.Request) (*http.Response, error) {
	if p.srv.AdminRequestApprovalsList == nil {
		return nil, &nonRetriableError{errors.New("fake for method AdminRequestApprovalsList not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/adminRequestApprovals`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.AdminRequestApprovalsList(req.Context(), privateStoreIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdminRequestApprovalsList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchBillingAccounts(req *http.Request) (*http.Response, error) {
	if p.srv.BillingAccounts == nil {
		return nil, &nonRetriableError{errors.New("fake for method BillingAccounts not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingAccounts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.BillingAccounts(req.Context(), privateStoreIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BillingAccountsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchBulkCollectionsAction(req *http.Request) (*http.Response, error) {
	if p.srv.BulkCollectionsAction == nil {
		return nil, &nonRetriableError{errors.New("fake for method BulkCollectionsAction not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/bulkCollectionsAction`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.BulkCollectionsPayload](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreClientBulkCollectionsActionOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreClientBulkCollectionsActionOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.BulkCollectionsAction(req.Context(), privateStoreIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BulkCollectionsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchCollectionsToSubscriptionsMapping(req *http.Request) (*http.Response, error) {
	if p.srv.CollectionsToSubscriptionsMapping == nil {
		return nil, &nonRetriableError{errors.New("fake for method CollectionsToSubscriptionsMapping not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collectionsToSubscriptionsMapping`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.CollectionsToSubscriptionsMappingPayload](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreClientCollectionsToSubscriptionsMappingOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreClientCollectionsToSubscriptionsMappingOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.CollectionsToSubscriptionsMapping(req.Context(), privateStoreIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CollectionsToSubscriptionsMappingResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchCreateApprovalRequest(req *http.Request) (*http.Response, error) {
	if p.srv.CreateApprovalRequest == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateApprovalRequest not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/requestApprovals/(?P<requestApprovalId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.RequestApprovalResource](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	requestApprovalIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestApprovalId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreClientCreateApprovalRequestOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreClientCreateApprovalRequestOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.CreateApprovalRequest(req.Context(), privateStoreIDParam, requestApprovalIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RequestApprovalResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.PrivateStore](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreClientCreateOrUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreClientCreateOrUpdateOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.CreateOrUpdate(req.Context(), privateStoreIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if p.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Delete(req.Context(), privateStoreIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchFetchAllSubscriptionsInTenant(req *http.Request) (*http.Response, error) {
	if p.srv.FetchAllSubscriptionsInTenant == nil {
		return nil, &nonRetriableError{errors.New("fake for method FetchAllSubscriptionsInTenant not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fetchAllSubscriptionsInTenant`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	nextPageTokenParam := getOptional(getHeaderValue(req.Header, "next-page-token"))
	var options *armmarketplace.PrivateStoreClientFetchAllSubscriptionsInTenantOptions
	if nextPageTokenParam != nil {
		options = &armmarketplace.PrivateStoreClientFetchAllSubscriptionsInTenantOptions{
			NextPageToken: nextPageTokenParam,
		}
	}
	respr, errRespr := p.srv.FetchAllSubscriptionsInTenant(req.Context(), privateStoreIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SubscriptionsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), privateStoreIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateStore, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchGetAdminRequestApproval(req *http.Request) (*http.Response, error) {
	if p.srv.GetAdminRequestApproval == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAdminRequestApproval not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/adminRequestApprovals/(?P<adminRequestApprovalId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	adminRequestApprovalIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("adminRequestApprovalId")])
	if err != nil {
		return nil, err
	}
	publisherIDParam, err := url.QueryUnescape(qp.Get("publisherId"))
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetAdminRequestApproval(req.Context(), privateStoreIDParam, adminRequestApprovalIDParam, publisherIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdminRequestApprovalsResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchGetApprovalRequestsList(req *http.Request) (*http.Response, error) {
	if p.srv.GetApprovalRequestsList == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetApprovalRequestsList not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/requestApprovals`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetApprovalRequestsList(req.Context(), privateStoreIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RequestApprovalsList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchGetRequestApproval(req *http.Request) (*http.Response, error) {
	if p.srv.GetRequestApproval == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetRequestApproval not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/requestApprovals/(?P<requestApprovalId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	requestApprovalIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestApprovalId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetRequestApproval(req.Context(), privateStoreIDParam, requestApprovalIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RequestApprovalResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		qp := req.URL.Query()
		useCacheUnescaped, err := url.QueryUnescape(qp.Get("use-cache"))
		if err != nil {
			return nil, err
		}
		useCacheParam := getOptional(useCacheUnescaped)
		var options *armmarketplace.PrivateStoreClientListOptions
		if useCacheParam != nil {
			options = &armmarketplace.PrivateStoreClientListOptions{
				UseCache: useCacheParam,
			}
		}
		resp := p.srv.NewListPager(options)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmarketplace.PrivateStoreClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchListNewPlansNotifications(req *http.Request) (*http.Response, error) {
	if p.srv.ListNewPlansNotifications == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListNewPlansNotifications not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listNewPlansNotifications`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ListNewPlansNotifications(req.Context(), privateStoreIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).NewPlansNotificationsList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchListStopSellOffersPlansNotifications(req *http.Request) (*http.Response, error) {
	if p.srv.ListStopSellOffersPlansNotifications == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListStopSellOffersPlansNotifications not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listStopSellOffersPlansNotifications`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.StopSellSubscriptions](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreClientListStopSellOffersPlansNotificationsOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreClientListStopSellOffersPlansNotificationsOptions{
			StopSellSubscriptions: &body,
		}
	}
	respr, errRespr := p.srv.ListStopSellOffersPlansNotifications(req.Context(), privateStoreIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StopSellOffersPlansNotificationsList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchListSubscriptionsContext(req *http.Request) (*http.Response, error) {
	if p.srv.ListSubscriptionsContext == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListSubscriptionsContext not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listSubscriptionsContext`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ListSubscriptionsContext(req.Context(), privateStoreIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SubscriptionsContextList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchQueryApprovedPlans(req *http.Request) (*http.Response, error) {
	if p.srv.QueryApprovedPlans == nil {
		return nil, &nonRetriableError{errors.New("fake for method QueryApprovedPlans not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryApprovedPlans`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.QueryApprovedPlansPayload](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreClientQueryApprovedPlansOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreClientQueryApprovedPlansOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.QueryApprovedPlans(req.Context(), privateStoreIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).QueryApprovedPlansResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchQueryNotificationsState(req *http.Request) (*http.Response, error) {
	if p.srv.QueryNotificationsState == nil {
		return nil, &nonRetriableError{errors.New("fake for method QueryNotificationsState not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryNotificationsState`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.QueryNotificationsState(req.Context(), privateStoreIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateStoreNotificationsState, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchQueryOffers(req *http.Request) (*http.Response, error) {
	if p.srv.QueryOffers == nil {
		return nil, &nonRetriableError{errors.New("fake for method QueryOffers not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/queryOffers`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.QueryOffers(req.Context(), privateStoreIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).QueryOffers, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchQueryRequestApproval(req *http.Request) (*http.Response, error) {
	if p.srv.QueryRequestApproval == nil {
		return nil, &nonRetriableError{errors.New("fake for method QueryRequestApproval not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/requestApprovals/(?P<requestApprovalId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/query`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.QueryRequestApprovalProperties](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	requestApprovalIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestApprovalId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreClientQueryRequestApprovalOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreClientQueryRequestApprovalOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.QueryRequestApproval(req.Context(), privateStoreIDParam, requestApprovalIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).QueryRequestApproval, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchUpdateAdminRequestApproval(req *http.Request) (*http.Response, error) {
	if p.srv.UpdateAdminRequestApproval == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateAdminRequestApproval not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/adminRequestApprovals/(?P<adminRequestApprovalId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.AdminRequestApprovalsResource](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	adminRequestApprovalIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("adminRequestApprovalId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreClientUpdateAdminRequestApprovalOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreClientUpdateAdminRequestApprovalOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.UpdateAdminRequestApproval(req.Context(), privateStoreIDParam, adminRequestApprovalIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdminRequestApprovalsResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateStoreServerTransport) dispatchWithdrawPlan(req *http.Request) (*http.Response, error) {
	if p.srv.WithdrawPlan == nil {
		return nil, &nonRetriableError{errors.New("fake for method WithdrawPlan not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Marketplace/privateStores/(?P<privateStoreId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/requestApprovals/(?P<requestApprovalId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/withdrawPlan`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmarketplace.WithdrawProperties](req)
	if err != nil {
		return nil, err
	}
	privateStoreIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateStoreId")])
	if err != nil {
		return nil, err
	}
	requestApprovalIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestApprovalId")])
	if err != nil {
		return nil, err
	}
	var options *armmarketplace.PrivateStoreClientWithdrawPlanOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmarketplace.PrivateStoreClientWithdrawPlanOptions{
			Payload: &body,
		}
	}
	respr, errRespr := p.srv.WithdrawPlan(req.Context(), privateStoreIDParam, requestApprovalIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
