//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotfirmwaredefense

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FirmwaresClient contains the methods for the Firmwares group.
// Don't use this type directly, use NewFirmwaresClient() instead.
type FirmwaresClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewFirmwaresClient creates a new instance of FirmwaresClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewFirmwaresClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FirmwaresClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &FirmwaresClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Create - The operation to create a firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-10
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - firmware - Details of the firmware being created or updated.
//   - options - FirmwaresClientCreateOptions contains the optional parameters for the FirmwaresClient.Create method.
func (client *FirmwaresClient) Create(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware Firmware, options *FirmwaresClientCreateOptions) (FirmwaresClientCreateResponse, error) {
	var err error
	const operationName = "FirmwaresClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, firmware, options)
	if err != nil {
		return FirmwaresClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwaresClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FirmwaresClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *FirmwaresClient) createCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware Firmware, options *FirmwaresClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-10")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, firmware); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *FirmwaresClient) createHandleResponse(resp *http.Response) (FirmwaresClientCreateResponse, error) {
	result := FirmwaresClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Firmware); err != nil {
		return FirmwaresClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - The operation to delete a firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-10
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwaresClientDeleteOptions contains the optional parameters for the FirmwaresClient.Delete method.
func (client *FirmwaresClient) Delete(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwaresClientDeleteOptions) (FirmwaresClientDeleteResponse, error) {
	var err error
	const operationName = "FirmwaresClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwaresClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwaresClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return FirmwaresClientDeleteResponse{}, err
	}
	return FirmwaresClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *FirmwaresClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwaresClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-10")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GenerateDownloadURL - The operation to a url for file download.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-10
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwaresClientGenerateDownloadURLOptions contains the optional parameters for the FirmwaresClient.GenerateDownloadURL
//     method.
func (client *FirmwaresClient) GenerateDownloadURL(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwaresClientGenerateDownloadURLOptions) (FirmwaresClientGenerateDownloadURLResponse, error) {
	var err error
	const operationName = "FirmwaresClient.GenerateDownloadURL"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateDownloadURLCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwaresClientGenerateDownloadURLResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwaresClientGenerateDownloadURLResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwaresClientGenerateDownloadURLResponse{}, err
	}
	resp, err := client.generateDownloadURLHandleResponse(httpResp)
	return resp, err
}

// generateDownloadURLCreateRequest creates the GenerateDownloadURL request.
func (client *FirmwaresClient) generateDownloadURLCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwaresClientGenerateDownloadURLOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateDownloadUrl"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-10")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateDownloadURLHandleResponse handles the GenerateDownloadURL response.
func (client *FirmwaresClient) generateDownloadURLHandleResponse(resp *http.Response) (FirmwaresClientGenerateDownloadURLResponse, error) {
	result := FirmwaresClientGenerateDownloadURLResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.URLToken); err != nil {
		return FirmwaresClientGenerateDownloadURLResponse{}, err
	}
	return result, nil
}

// GenerateFilesystemDownloadURL - The operation to a url for tar file download.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-10
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwaresClientGenerateFilesystemDownloadURLOptions contains the optional parameters for the FirmwaresClient.GenerateFilesystemDownloadURL
//     method.
func (client *FirmwaresClient) GenerateFilesystemDownloadURL(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwaresClientGenerateFilesystemDownloadURLOptions) (FirmwaresClientGenerateFilesystemDownloadURLResponse, error) {
	var err error
	const operationName = "FirmwaresClient.GenerateFilesystemDownloadURL"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateFilesystemDownloadURLCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwaresClientGenerateFilesystemDownloadURLResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwaresClientGenerateFilesystemDownloadURLResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwaresClientGenerateFilesystemDownloadURLResponse{}, err
	}
	resp, err := client.generateFilesystemDownloadURLHandleResponse(httpResp)
	return resp, err
}

// generateFilesystemDownloadURLCreateRequest creates the GenerateFilesystemDownloadURL request.
func (client *FirmwaresClient) generateFilesystemDownloadURLCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwaresClientGenerateFilesystemDownloadURLOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}/generateFilesystemDownloadUrl"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-10")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// generateFilesystemDownloadURLHandleResponse handles the GenerateFilesystemDownloadURL response.
func (client *FirmwaresClient) generateFilesystemDownloadURLHandleResponse(resp *http.Response) (FirmwaresClientGenerateFilesystemDownloadURLResponse, error) {
	result := FirmwaresClientGenerateFilesystemDownloadURLResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.URLToken); err != nil {
		return FirmwaresClientGenerateFilesystemDownloadURLResponse{}, err
	}
	return result, nil
}

// Get - Get firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-10
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - options - FirmwaresClientGetOptions contains the optional parameters for the FirmwaresClient.Get method.
func (client *FirmwaresClient) Get(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwaresClientGetOptions) (FirmwaresClientGetResponse, error) {
	var err error
	const operationName = "FirmwaresClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, options)
	if err != nil {
		return FirmwaresClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwaresClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwaresClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *FirmwaresClient) getCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, options *FirmwaresClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-10")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FirmwaresClient) getHandleResponse(resp *http.Response) (FirmwaresClientGetResponse, error) {
	result := FirmwaresClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Firmware); err != nil {
		return FirmwaresClientGetResponse{}, err
	}
	return result, nil
}

// NewListByWorkspacePager - Lists all of firmwares inside a workspace.
//
// Generated from API version 2024-01-10
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - options - FirmwaresClientListByWorkspaceOptions contains the optional parameters for the FirmwaresClient.NewListByWorkspacePager
//     method.
func (client *FirmwaresClient) NewListByWorkspacePager(resourceGroupName string, workspaceName string, options *FirmwaresClientListByWorkspaceOptions) *runtime.Pager[FirmwaresClientListByWorkspaceResponse] {
	return runtime.NewPager(runtime.PagingHandler[FirmwaresClientListByWorkspaceResponse]{
		More: func(page FirmwaresClientListByWorkspaceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FirmwaresClientListByWorkspaceResponse) (FirmwaresClientListByWorkspaceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FirmwaresClient.NewListByWorkspacePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByWorkspaceCreateRequest(ctx, resourceGroupName, workspaceName, options)
			}, nil)
			if err != nil {
				return FirmwaresClientListByWorkspaceResponse{}, err
			}
			return client.listByWorkspaceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByWorkspaceCreateRequest creates the ListByWorkspace request.
func (client *FirmwaresClient) listByWorkspaceCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, options *FirmwaresClientListByWorkspaceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-10")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByWorkspaceHandleResponse handles the ListByWorkspace response.
func (client *FirmwaresClient) listByWorkspaceHandleResponse(resp *http.Response) (FirmwaresClientListByWorkspaceResponse, error) {
	result := FirmwaresClientListByWorkspaceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FirmwareList); err != nil {
		return FirmwaresClientListByWorkspaceResponse{}, err
	}
	return result, nil
}

// Update - The operation to update firmware.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-01-10
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the firmware analysis workspace.
//   - firmwareID - The id of the firmware.
//   - firmware - Details of the firmware being created or updated.
//   - options - FirmwaresClientUpdateOptions contains the optional parameters for the FirmwaresClient.Update method.
func (client *FirmwaresClient) Update(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware FirmwareUpdateDefinition, options *FirmwaresClientUpdateOptions) (FirmwaresClientUpdateResponse, error) {
	var err error
	const operationName = "FirmwaresClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, workspaceName, firmwareID, firmware, options)
	if err != nil {
		return FirmwaresClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FirmwaresClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FirmwaresClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *FirmwaresClient) updateCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, firmwareID string, firmware FirmwareUpdateDefinition, options *FirmwaresClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if firmwareID == "" {
		return nil, errors.New("parameter firmwareID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{firmwareId}", url.PathEscape(firmwareID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-01-10")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, firmware); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *FirmwaresClient) updateHandleResponse(resp *http.Response) (FirmwaresClientUpdateResponse, error) {
	result := FirmwaresClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Firmware); err != nil {
		return FirmwaresClientUpdateResponse{}, err
	}
	return result, nil
}
