//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hanaonazure/armhanaonazure"
	"net/http"
	"net/url"
	"regexp"
)

// ProviderInstancesServer is a fake server for instances of the armhanaonazure.ProviderInstancesClient type.
type ProviderInstancesServer struct {
	// BeginCreate is the fake for method ProviderInstancesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, providerInstanceParameter armhanaonazure.ProviderInstance, options *armhanaonazure.ProviderInstancesClientBeginCreateOptions) (resp azfake.PollerResponder[armhanaonazure.ProviderInstancesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ProviderInstancesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, options *armhanaonazure.ProviderInstancesClientBeginDeleteOptions) (resp azfake.PollerResponder[armhanaonazure.ProviderInstancesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ProviderInstancesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, sapMonitorName string, providerInstanceName string, options *armhanaonazure.ProviderInstancesClientGetOptions) (resp azfake.Responder[armhanaonazure.ProviderInstancesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ProviderInstancesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, sapMonitorName string, options *armhanaonazure.ProviderInstancesClientListOptions) (resp azfake.PagerResponder[armhanaonazure.ProviderInstancesClientListResponse])
}

// NewProviderInstancesServerTransport creates a new instance of ProviderInstancesServerTransport with the provided implementation.
// The returned ProviderInstancesServerTransport instance is connected to an instance of armhanaonazure.ProviderInstancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProviderInstancesServerTransport(srv *ProviderInstancesServer) *ProviderInstancesServerTransport {
	return &ProviderInstancesServerTransport{
		srv:          srv,
		beginCreate:  newTracker[azfake.PollerResponder[armhanaonazure.ProviderInstancesClientCreateResponse]](),
		beginDelete:  newTracker[azfake.PollerResponder[armhanaonazure.ProviderInstancesClientDeleteResponse]](),
		newListPager: newTracker[azfake.PagerResponder[armhanaonazure.ProviderInstancesClientListResponse]](),
	}
}

// ProviderInstancesServerTransport connects instances of armhanaonazure.ProviderInstancesClient to instances of ProviderInstancesServer.
// Don't use this type directly, use NewProviderInstancesServerTransport instead.
type ProviderInstancesServerTransport struct {
	srv          *ProviderInstancesServer
	beginCreate  *tracker[azfake.PollerResponder[armhanaonazure.ProviderInstancesClientCreateResponse]]
	beginDelete  *tracker[azfake.PollerResponder[armhanaonazure.ProviderInstancesClientDeleteResponse]]
	newListPager *tracker[azfake.PagerResponder[armhanaonazure.ProviderInstancesClientListResponse]]
}

// Do implements the policy.Transporter interface for ProviderInstancesServerTransport.
func (p *ProviderInstancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProviderInstancesClient.BeginCreate":
		resp, err = p.dispatchBeginCreate(req)
	case "ProviderInstancesClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "ProviderInstancesClient.Get":
		resp, err = p.dispatchGet(req)
	case "ProviderInstancesClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProviderInstancesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := p.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HanaOnAzure/sapMonitors/(?P<sapMonitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providerInstances/(?P<providerInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhanaonazure.ProviderInstance](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapMonitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapMonitorName")])
		if err != nil {
			return nil, err
		}
		providerInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreate(req.Context(), resourceGroupNameParam, sapMonitorNameParam, providerInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		p.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		p.beginCreate.remove(req)
	}

	return resp, nil
}

func (p *ProviderInstancesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HanaOnAzure/sapMonitors/(?P<sapMonitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providerInstances/(?P<providerInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapMonitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapMonitorName")])
		if err != nil {
			return nil, err
		}
		providerInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, sapMonitorNameParam, providerInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *ProviderInstancesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HanaOnAzure/sapMonitors/(?P<sapMonitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providerInstances/(?P<providerInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sapMonitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapMonitorName")])
	if err != nil {
		return nil, err
	}
	providerInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, sapMonitorNameParam, providerInstanceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProviderInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProviderInstancesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HanaOnAzure/sapMonitors/(?P<sapMonitorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providerInstances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapMonitorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapMonitorName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPager(resourceGroupNameParam, sapMonitorNameParam, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armhanaonazure.ProviderInstancesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}
