//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devtestlabs/armdevtestlabs"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// LabsServer is a fake server for instances of the armdevtestlabs.LabsClient type.
type LabsServer struct {
	// BeginClaimAnyVM is the fake for method LabsClient.BeginClaimAnyVM
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginClaimAnyVM func(ctx context.Context, resourceGroupName string, name string, options *armdevtestlabs.LabsClientBeginClaimAnyVMOptions) (resp azfake.PollerResponder[armdevtestlabs.LabsClientClaimAnyVMResponse], errResp azfake.ErrorResponder)

	// BeginCreateEnvironment is the fake for method LabsClient.BeginCreateEnvironment
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateEnvironment func(ctx context.Context, resourceGroupName string, name string, labVirtualMachineCreationParameter armdevtestlabs.LabVirtualMachineCreationParameter, options *armdevtestlabs.LabsClientBeginCreateEnvironmentOptions) (resp azfake.PollerResponder[armdevtestlabs.LabsClientCreateEnvironmentResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method LabsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, name string, lab armdevtestlabs.Lab, options *armdevtestlabs.LabsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdevtestlabs.LabsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method LabsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, name string, options *armdevtestlabs.LabsClientBeginDeleteOptions) (resp azfake.PollerResponder[armdevtestlabs.LabsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginExportResourceUsage is the fake for method LabsClient.BeginExportResourceUsage
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginExportResourceUsage func(ctx context.Context, resourceGroupName string, name string, exportResourceUsageParameters armdevtestlabs.ExportResourceUsageParameters, options *armdevtestlabs.LabsClientBeginExportResourceUsageOptions) (resp azfake.PollerResponder[armdevtestlabs.LabsClientExportResourceUsageResponse], errResp azfake.ErrorResponder)

	// GenerateUploadURI is the fake for method LabsClient.GenerateUploadURI
	// HTTP status codes to indicate success: http.StatusOK
	GenerateUploadURI func(ctx context.Context, resourceGroupName string, name string, generateUploadURIParameter armdevtestlabs.GenerateUploadURIParameter, options *armdevtestlabs.LabsClientGenerateUploadURIOptions) (resp azfake.Responder[armdevtestlabs.LabsClientGenerateUploadURIResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method LabsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, name string, options *armdevtestlabs.LabsClientGetOptions) (resp azfake.Responder[armdevtestlabs.LabsClientGetResponse], errResp azfake.ErrorResponder)

	// BeginImportVirtualMachine is the fake for method LabsClient.BeginImportVirtualMachine
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginImportVirtualMachine func(ctx context.Context, resourceGroupName string, name string, importLabVirtualMachineRequest armdevtestlabs.ImportLabVirtualMachineRequest, options *armdevtestlabs.LabsClientBeginImportVirtualMachineOptions) (resp azfake.PollerResponder[armdevtestlabs.LabsClientImportVirtualMachineResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method LabsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armdevtestlabs.LabsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armdevtestlabs.LabsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method LabsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armdevtestlabs.LabsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armdevtestlabs.LabsClientListBySubscriptionResponse])

	// NewListVhdsPager is the fake for method LabsClient.NewListVhdsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListVhdsPager func(resourceGroupName string, name string, options *armdevtestlabs.LabsClientListVhdsOptions) (resp azfake.PagerResponder[armdevtestlabs.LabsClientListVhdsResponse])

	// Update is the fake for method LabsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, name string, lab armdevtestlabs.LabFragment, options *armdevtestlabs.LabsClientUpdateOptions) (resp azfake.Responder[armdevtestlabs.LabsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewLabsServerTransport creates a new instance of LabsServerTransport with the provided implementation.
// The returned LabsServerTransport instance is connected to an instance of armdevtestlabs.LabsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLabsServerTransport(srv *LabsServer) *LabsServerTransport {
	return &LabsServerTransport{
		srv:                         srv,
		beginClaimAnyVM:             newTracker[azfake.PollerResponder[armdevtestlabs.LabsClientClaimAnyVMResponse]](),
		beginCreateEnvironment:      newTracker[azfake.PollerResponder[armdevtestlabs.LabsClientCreateEnvironmentResponse]](),
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armdevtestlabs.LabsClientCreateOrUpdateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armdevtestlabs.LabsClientDeleteResponse]](),
		beginExportResourceUsage:    newTracker[azfake.PollerResponder[armdevtestlabs.LabsClientExportResourceUsageResponse]](),
		beginImportVirtualMachine:   newTracker[azfake.PollerResponder[armdevtestlabs.LabsClientImportVirtualMachineResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armdevtestlabs.LabsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armdevtestlabs.LabsClientListBySubscriptionResponse]](),
		newListVhdsPager:            newTracker[azfake.PagerResponder[armdevtestlabs.LabsClientListVhdsResponse]](),
	}
}

// LabsServerTransport connects instances of armdevtestlabs.LabsClient to instances of LabsServer.
// Don't use this type directly, use NewLabsServerTransport instead.
type LabsServerTransport struct {
	srv                         *LabsServer
	beginClaimAnyVM             *tracker[azfake.PollerResponder[armdevtestlabs.LabsClientClaimAnyVMResponse]]
	beginCreateEnvironment      *tracker[azfake.PollerResponder[armdevtestlabs.LabsClientCreateEnvironmentResponse]]
	beginCreateOrUpdate         *tracker[azfake.PollerResponder[armdevtestlabs.LabsClientCreateOrUpdateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armdevtestlabs.LabsClientDeleteResponse]]
	beginExportResourceUsage    *tracker[azfake.PollerResponder[armdevtestlabs.LabsClientExportResourceUsageResponse]]
	beginImportVirtualMachine   *tracker[azfake.PollerResponder[armdevtestlabs.LabsClientImportVirtualMachineResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armdevtestlabs.LabsClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armdevtestlabs.LabsClientListBySubscriptionResponse]]
	newListVhdsPager            *tracker[azfake.PagerResponder[armdevtestlabs.LabsClientListVhdsResponse]]
}

// Do implements the policy.Transporter interface for LabsServerTransport.
func (l *LabsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LabsClient.BeginClaimAnyVM":
		resp, err = l.dispatchBeginClaimAnyVM(req)
	case "LabsClient.BeginCreateEnvironment":
		resp, err = l.dispatchBeginCreateEnvironment(req)
	case "LabsClient.BeginCreateOrUpdate":
		resp, err = l.dispatchBeginCreateOrUpdate(req)
	case "LabsClient.BeginDelete":
		resp, err = l.dispatchBeginDelete(req)
	case "LabsClient.BeginExportResourceUsage":
		resp, err = l.dispatchBeginExportResourceUsage(req)
	case "LabsClient.GenerateUploadURI":
		resp, err = l.dispatchGenerateUploadURI(req)
	case "LabsClient.Get":
		resp, err = l.dispatchGet(req)
	case "LabsClient.BeginImportVirtualMachine":
		resp, err = l.dispatchBeginImportVirtualMachine(req)
	case "LabsClient.NewListByResourceGroupPager":
		resp, err = l.dispatchNewListByResourceGroupPager(req)
	case "LabsClient.NewListBySubscriptionPager":
		resp, err = l.dispatchNewListBySubscriptionPager(req)
	case "LabsClient.NewListVhdsPager":
		resp, err = l.dispatchNewListVhdsPager(req)
	case "LabsClient.Update":
		resp, err = l.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LabsServerTransport) dispatchBeginClaimAnyVM(req *http.Request) (*http.Response, error) {
	if l.srv.BeginClaimAnyVM == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginClaimAnyVM not implemented")}
	}
	beginClaimAnyVM := l.beginClaimAnyVM.get(req)
	if beginClaimAnyVM == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/claimAnyVm`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginClaimAnyVM(req.Context(), resourceGroupNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginClaimAnyVM = &respr
		l.beginClaimAnyVM.add(req, beginClaimAnyVM)
	}

	resp, err := server.PollerResponderNext(beginClaimAnyVM, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginClaimAnyVM.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginClaimAnyVM) {
		l.beginClaimAnyVM.remove(req)
	}

	return resp, nil
}

func (l *LabsServerTransport) dispatchBeginCreateEnvironment(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCreateEnvironment == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateEnvironment not implemented")}
	}
	beginCreateEnvironment := l.beginCreateEnvironment.get(req)
	if beginCreateEnvironment == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/createEnvironment`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdevtestlabs.LabVirtualMachineCreationParameter](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCreateEnvironment(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateEnvironment = &respr
		l.beginCreateEnvironment.add(req, beginCreateEnvironment)
	}

	resp, err := server.PollerResponderNext(beginCreateEnvironment, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginCreateEnvironment.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateEnvironment) {
		l.beginCreateEnvironment.remove(req)
	}

	return resp, nil
}

func (l *LabsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := l.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdevtestlabs.Lab](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		l.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		l.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		l.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (l *LabsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if l.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := l.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginDelete(req.Context(), resourceGroupNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		l.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		l.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		l.beginDelete.remove(req)
	}

	return resp, nil
}

func (l *LabsServerTransport) dispatchBeginExportResourceUsage(req *http.Request) (*http.Response, error) {
	if l.srv.BeginExportResourceUsage == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginExportResourceUsage not implemented")}
	}
	beginExportResourceUsage := l.beginExportResourceUsage.get(req)
	if beginExportResourceUsage == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exportResourceUsage`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdevtestlabs.ExportResourceUsageParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginExportResourceUsage(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginExportResourceUsage = &respr
		l.beginExportResourceUsage.add(req, beginExportResourceUsage)
	}

	resp, err := server.PollerResponderNext(beginExportResourceUsage, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginExportResourceUsage.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginExportResourceUsage) {
		l.beginExportResourceUsage.remove(req)
	}

	return resp, nil
}

func (l *LabsServerTransport) dispatchGenerateUploadURI(req *http.Request) (*http.Response, error) {
	if l.srv.GenerateUploadURI == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateUploadURI not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateUploadUri`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdevtestlabs.GenerateUploadURIParameter](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.GenerateUploadURI(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GenerateUploadURIResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LabsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armdevtestlabs.LabsClientGetOptions
	if expandParam != nil {
		options = &armdevtestlabs.LabsClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := l.srv.Get(req.Context(), resourceGroupNameParam, nameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Lab, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LabsServerTransport) dispatchBeginImportVirtualMachine(req *http.Request) (*http.Response, error) {
	if l.srv.BeginImportVirtualMachine == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginImportVirtualMachine not implemented")}
	}
	beginImportVirtualMachine := l.beginImportVirtualMachine.get(req)
	if beginImportVirtualMachine == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/importVirtualMachine`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdevtestlabs.ImportLabVirtualMachineRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginImportVirtualMachine(req.Context(), resourceGroupNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginImportVirtualMachine = &respr
		l.beginImportVirtualMachine.add(req, beginImportVirtualMachine)
	}

	resp, err := server.PollerResponderNext(beginImportVirtualMachine, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginImportVirtualMachine.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginImportVirtualMachine) {
		l.beginImportVirtualMachine.remove(req)
	}

	return resp, nil
}

func (l *LabsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := l.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armdevtestlabs.LabsClientListByResourceGroupOptions
		if expandParam != nil || filterParam != nil || topParam != nil || orderbyParam != nil {
			options = &armdevtestlabs.LabsClientListByResourceGroupOptions{
				Expand:  expandParam,
				Filter:  filterParam,
				Top:     topParam,
				Orderby: orderbyParam,
			}
		}
		resp := l.srv.NewListByResourceGroupPager(resourceGroupNameParam, options)
		newListByResourceGroupPager = &resp
		l.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armdevtestlabs.LabsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		l.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (l *LabsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := l.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armdevtestlabs.LabsClientListBySubscriptionOptions
		if expandParam != nil || filterParam != nil || topParam != nil || orderbyParam != nil {
			options = &armdevtestlabs.LabsClientListBySubscriptionOptions{
				Expand:  expandParam,
				Filter:  filterParam,
				Top:     topParam,
				Orderby: orderbyParam,
			}
		}
		resp := l.srv.NewListBySubscriptionPager(options)
		newListBySubscriptionPager = &resp
		l.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armdevtestlabs.LabsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		l.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (l *LabsServerTransport) dispatchNewListVhdsPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListVhdsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListVhdsPager not implemented")}
	}
	newListVhdsPager := l.newListVhdsPager.get(req)
	if newListVhdsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listVhds`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListVhdsPager(resourceGroupNameParam, nameParam, nil)
		newListVhdsPager = &resp
		l.newListVhdsPager.add(req, newListVhdsPager)
		server.PagerResponderInjectNextLinks(newListVhdsPager, req, func(page *armdevtestlabs.LabsClientListVhdsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListVhdsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListVhdsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListVhdsPager) {
		l.newListVhdsPager.remove(req)
	}
	return resp, nil
}

func (l *LabsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdevtestlabs.LabFragment](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Update(req.Context(), resourceGroupNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Lab, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
