//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevhub

import "time"

// ACR - Information on the azure container registry
type ACR struct {
	// ACR registry
	AcrRegistryName *string

	// ACR repository
	AcrRepositoryName *string

	// ACR resource group
	AcrResourceGroup *string

	// ACR subscription id
	AcrSubscriptionID *string
}

// ArtifactGenerationProperties - Properties used for generating artifacts such as Dockerfiles and manifests.
type ArtifactGenerationProperties struct {
	// The name of the app.
	AppName *string

	// The version of the language image used for building the code in the generated dockerfile.
	BuilderVersion *string

	// The mode of generation to be used for generating Dockerfiles.
	DockerfileGenerationMode *DockerfileGenerationMode

	// The directory to output the generated Dockerfile to.
	DockerfileOutputDirectory *string

	// The programming language used.
	GenerationLanguage *GenerationLanguage

	// The name of the image to be generated.
	ImageName *string

	// The tag to apply to the generated image.
	ImageTag *string

	// The version of the language image used for execution in the generated dockerfile.
	LanguageVersion *string

	// The mode of generation to be used for generating Manifest.
	ManifestGenerationMode *ManifestGenerationMode

	// The directory to output the generated manifests to.
	ManifestOutputDirectory *string

	// Determines the type of manifests to be generated.
	ManifestType *GenerationManifestType

	// The namespace to deploy the application to.
	Namespace *string

	// The port the application is exposed on.
	Port *string
}

// DeleteWorkflowResponse - delete response if content must be provided on delete operation
type DeleteWorkflowResponse struct {
	// delete status message
	Status *string
}

type DeploymentProperties struct {
	// Helm chart directory path in repository.
	HelmChartPath *string

	// Helm Values.yaml file location in repository.
	HelmValues            *string
	KubeManifestLocations []*string

	// Determines the type of manifests within the repository.
	ManifestType *ManifestType

	// Manifest override values.
	Overrides map[string]*string
}

// GitHubOAuthCallRequest - GitHubOAuth request object
type GitHubOAuthCallRequest struct {
	// The URL the client will redirect to on successful authentication. If empty, no redirect will occur.
	RedirectURL *string
}

// GitHubOAuthInfoResponse - URL used to authorize the Developer Hub GitHub App
type GitHubOAuthInfoResponse struct {
	// URL for authorizing the Developer Hub GitHub App
	AuthURL *string

	// OAuth token used to make calls to GitHub
	Token *string
}

// GitHubOAuthListResponse - The response from List GitHubOAuth operation.
type GitHubOAuthListResponse struct {
	// Singleton list response containing one GitHubOAuthResponse response
	Value []*GitHubOAuthResponse
}

// GitHubOAuthProperties - The response from List GitHubOAuth operation.
type GitHubOAuthProperties struct {
	// user making request
	Username *string
}

// GitHubOAuthResponse - Singleton response of GitHubOAuth containing
type GitHubOAuthResponse struct {
	// Properties of a workflow.
	Properties *GitHubOAuthProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GitHubWorkflowProfile - GitHub Workflow Profile
type GitHubWorkflowProfile struct {
	// Information on the azure container registry
	Acr *ACR

	// The Azure Kubernetes Cluster Resource the application will be deployed to.
	AksResourceID *string

	// Repository Branch Name
	BranchName           *string
	DeploymentProperties *DeploymentProperties

	// Path to Dockerfile Build Context within the repository.
	DockerBuildContext *string

	// Path to the Dockerfile within the repository.
	Dockerfile      *string
	LastWorkflowRun *WorkflowRun

	// Kubernetes namespace the application is deployed to.
	Namespace *string

	// The fields needed for OIDC with GitHub.
	OidcCredentials *GitHubWorkflowProfileOidcCredentials

	// Repository Name
	RepositoryName *string

	// Repository Owner
	RepositoryOwner *string

	// READ-ONLY; Determines the authorization status of requests.
	AuthStatus *AuthorizationStatus

	// READ-ONLY; The status of the Pull Request submitted against the users repository.
	PrStatus *PullRequestStatus

	// READ-ONLY; The URL to the Pull Request submitted against the users repository.
	PrURL *string

	// READ-ONLY; The number associated with the submitted pull request.
	PullNumber *int32
}

// GitHubWorkflowProfileOidcCredentials - The fields needed for OIDC with GitHub.
type GitHubWorkflowProfileOidcCredentials struct {
	// Azure Application Client ID
	AzureClientID *string

	// Azure Directory (tenant) ID
	AzureTenantID *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagsObject - Resource tags.
type TagsObject struct {
	// Dictionary of
	Tags map[string]*string
}

// Workflow - Resource representation of a workflow
type Workflow struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Properties of a workflow.
	Properties *WorkflowProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WorkflowListResult - The response from List Workflows operation.
type WorkflowListResult struct {
	// The list of workflows.
	Value []*Workflow

	// READ-ONLY; The URL to the next set of workflow results.
	NextLink *string
}

// WorkflowProperties - Workflow properties
type WorkflowProperties struct {
	// Properties for generating artifacts like dockerfile and manifests.
	ArtifactGenerationProperties *ArtifactGenerationProperties

	// Profile of a github workflow.
	GithubWorkflowProfile *GitHubWorkflowProfile
}

type WorkflowRun struct {
	// Describes the status of the workflow run
	WorkflowRunStatus *WorkflowRunStatus

	// READ-ONLY; The timestamp of the last workflow run.
	LastRunAt *time.Time

	// READ-ONLY; Describes if the workflow run succeeded.
	Succeeded *bool

	// READ-ONLY; URL to the run of the workflow.
	WorkflowRunURL *string
}
