//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devcenter/armdevcenter/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ProjectCatalogEnvironmentDefinitionsServer is a fake server for instances of the armdevcenter.ProjectCatalogEnvironmentDefinitionsClient type.
type ProjectCatalogEnvironmentDefinitionsServer struct {
	// GetErrorDetails is the fake for method ProjectCatalogEnvironmentDefinitionsClient.GetErrorDetails
	// HTTP status codes to indicate success: http.StatusOK
	GetErrorDetails func(ctx context.Context, resourceGroupName string, projectName string, catalogName string, environmentDefinitionName string, options *armdevcenter.ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsOptions) (resp azfake.Responder[armdevcenter.ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsResponse], errResp azfake.ErrorResponder)
}

// NewProjectCatalogEnvironmentDefinitionsServerTransport creates a new instance of ProjectCatalogEnvironmentDefinitionsServerTransport with the provided implementation.
// The returned ProjectCatalogEnvironmentDefinitionsServerTransport instance is connected to an instance of armdevcenter.ProjectCatalogEnvironmentDefinitionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProjectCatalogEnvironmentDefinitionsServerTransport(srv *ProjectCatalogEnvironmentDefinitionsServer) *ProjectCatalogEnvironmentDefinitionsServerTransport {
	return &ProjectCatalogEnvironmentDefinitionsServerTransport{srv: srv}
}

// ProjectCatalogEnvironmentDefinitionsServerTransport connects instances of armdevcenter.ProjectCatalogEnvironmentDefinitionsClient to instances of ProjectCatalogEnvironmentDefinitionsServer.
// Don't use this type directly, use NewProjectCatalogEnvironmentDefinitionsServerTransport instead.
type ProjectCatalogEnvironmentDefinitionsServerTransport struct {
	srv *ProjectCatalogEnvironmentDefinitionsServer
}

// Do implements the policy.Transporter interface for ProjectCatalogEnvironmentDefinitionsServerTransport.
func (p *ProjectCatalogEnvironmentDefinitionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProjectCatalogEnvironmentDefinitionsClient.GetErrorDetails":
		resp, err = p.dispatchGetErrorDetails(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProjectCatalogEnvironmentDefinitionsServerTransport) dispatchGetErrorDetails(req *http.Request) (*http.Response, error) {
	if p.srv.GetErrorDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetErrorDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/environmentDefinitions/(?P<environmentDefinitionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getErrorDetails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
	if err != nil {
		return nil, err
	}
	environmentDefinitionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentDefinitionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetErrorDetails(req.Context(), resourceGroupNameParam, projectNameParam, catalogNameParam, environmentDefinitionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CatalogResourceValidationErrorDetails, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
