//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevcenter

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewAttachedNetworksClient creates a new instance of AttachedNetworksClient.
func (c *ClientFactory) NewAttachedNetworksClient() *AttachedNetworksClient {
	return &AttachedNetworksClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCatalogsClient creates a new instance of CatalogsClient.
func (c *ClientFactory) NewCatalogsClient() *CatalogsClient {
	return &CatalogsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCheckNameAvailabilityClient creates a new instance of CheckNameAvailabilityClient.
func (c *ClientFactory) NewCheckNameAvailabilityClient() *CheckNameAvailabilityClient {
	return &CheckNameAvailabilityClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewCheckScopedNameAvailabilityClient creates a new instance of CheckScopedNameAvailabilityClient.
func (c *ClientFactory) NewCheckScopedNameAvailabilityClient() *CheckScopedNameAvailabilityClient {
	return &CheckScopedNameAvailabilityClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDevBoxDefinitionsClient creates a new instance of DevBoxDefinitionsClient.
func (c *ClientFactory) NewDevBoxDefinitionsClient() *DevBoxDefinitionsClient {
	return &DevBoxDefinitionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDevCentersClient creates a new instance of DevCentersClient.
func (c *ClientFactory) NewDevCentersClient() *DevCentersClient {
	return &DevCentersClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewEnvironmentDefinitionsClient creates a new instance of EnvironmentDefinitionsClient.
func (c *ClientFactory) NewEnvironmentDefinitionsClient() *EnvironmentDefinitionsClient {
	return &EnvironmentDefinitionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewEnvironmentTypesClient creates a new instance of EnvironmentTypesClient.
func (c *ClientFactory) NewEnvironmentTypesClient() *EnvironmentTypesClient {
	return &EnvironmentTypesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewGalleriesClient creates a new instance of GalleriesClient.
func (c *ClientFactory) NewGalleriesClient() *GalleriesClient {
	return &GalleriesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewImageVersionsClient creates a new instance of ImageVersionsClient.
func (c *ClientFactory) NewImageVersionsClient() *ImageVersionsClient {
	return &ImageVersionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewImagesClient creates a new instance of ImagesClient.
func (c *ClientFactory) NewImagesClient() *ImagesClient {
	return &ImagesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewNetworkConnectionsClient creates a new instance of NetworkConnectionsClient.
func (c *ClientFactory) NewNetworkConnectionsClient() *NetworkConnectionsClient {
	return &NetworkConnectionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationStatusesClient creates a new instance of OperationStatusesClient.
func (c *ClientFactory) NewOperationStatusesClient() *OperationStatusesClient {
	return &OperationStatusesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}

// NewPoolsClient creates a new instance of PoolsClient.
func (c *ClientFactory) NewPoolsClient() *PoolsClient {
	return &PoolsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewProjectAllowedEnvironmentTypesClient creates a new instance of ProjectAllowedEnvironmentTypesClient.
func (c *ClientFactory) NewProjectAllowedEnvironmentTypesClient() *ProjectAllowedEnvironmentTypesClient {
	return &ProjectAllowedEnvironmentTypesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewProjectCatalogEnvironmentDefinitionsClient creates a new instance of ProjectCatalogEnvironmentDefinitionsClient.
func (c *ClientFactory) NewProjectCatalogEnvironmentDefinitionsClient() *ProjectCatalogEnvironmentDefinitionsClient {
	return &ProjectCatalogEnvironmentDefinitionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewProjectCatalogsClient creates a new instance of ProjectCatalogsClient.
func (c *ClientFactory) NewProjectCatalogsClient() *ProjectCatalogsClient {
	return &ProjectCatalogsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewProjectEnvironmentTypesClient creates a new instance of ProjectEnvironmentTypesClient.
func (c *ClientFactory) NewProjectEnvironmentTypesClient() *ProjectEnvironmentTypesClient {
	return &ProjectEnvironmentTypesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewProjectsClient creates a new instance of ProjectsClient.
func (c *ClientFactory) NewProjectsClient() *ProjectsClient {
	return &ProjectsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSKUsClient creates a new instance of SKUsClient.
func (c *ClientFactory) NewSKUsClient() *SKUsClient {
	return &SKUsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSchedulesClient creates a new instance of SchedulesClient.
func (c *ClientFactory) NewSchedulesClient() *SchedulesClient {
	return &SchedulesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewUsagesClient creates a new instance of UsagesClient.
func (c *ClientFactory) NewUsagesClient() *UsagesClient {
	return &UsagesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}
