//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataprotection

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ResourceGuardsClient contains the methods for the ResourceGuards group.
// Don't use this type directly, use NewResourceGuardsClient() instead.
type ResourceGuardsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewResourceGuardsClient creates a new instance of ResourceGuardsClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewResourceGuardsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ResourceGuardsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ResourceGuardsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Delete - Deletes a ResourceGuard resource from the resource group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceGuardsName - The name of ResourceGuard
//   - options - ResourceGuardsClientDeleteOptions contains the optional parameters for the ResourceGuardsClient.Delete method.
func (client *ResourceGuardsClient) Delete(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientDeleteOptions) (ResourceGuardsClientDeleteResponse, error) {
	var err error
	const operationName = "ResourceGuardsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, resourceGuardsName, options)
	if err != nil {
		return ResourceGuardsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceGuardsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ResourceGuardsClientDeleteResponse{}, err
	}
	return ResourceGuardsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ResourceGuardsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Returns a ResourceGuard belonging to a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceGuardsName - The name of ResourceGuard
//   - options - ResourceGuardsClientGetOptions contains the optional parameters for the ResourceGuardsClient.Get method.
func (client *ResourceGuardsClient) Get(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetOptions) (ResourceGuardsClientGetResponse, error) {
	var err error
	const operationName = "ResourceGuardsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, resourceGuardsName, options)
	if err != nil {
		return ResourceGuardsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceGuardsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ResourceGuardsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ResourceGuardsClient) getCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ResourceGuardsClient) getHandleResponse(resp *http.Response) (ResourceGuardsClientGetResponse, error) {
	result := ResourceGuardsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceGuardResource); err != nil {
		return ResourceGuardsClientGetResponse{}, err
	}
	return result, nil
}

// NewGetBackupSecurityPINRequestsObjectsPager - Returns collection of operation request objects for a critical operation
// protected by the given ResourceGuard resource.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetBackupSecurityPINRequestsObjectsOptions contains the optional parameters for the ResourceGuardsClient.NewGetBackupSecurityPINRequestsObjectsPager
//     method.
func (client *ResourceGuardsClient) NewGetBackupSecurityPINRequestsObjectsPager(resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetBackupSecurityPINRequestsObjectsOptions) *runtime.Pager[ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse]{
		More: func(page ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse) (ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ResourceGuardsClient.NewGetBackupSecurityPINRequestsObjectsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getBackupSecurityPINRequestsObjectsCreateRequest(ctx, resourceGroupName, resourceGuardsName, options)
			}, nil)
			if err != nil {
				return ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse{}, err
			}
			return client.getBackupSecurityPINRequestsObjectsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getBackupSecurityPINRequestsObjectsCreateRequest creates the GetBackupSecurityPINRequestsObjects request.
func (client *ResourceGuardsClient) getBackupSecurityPINRequestsObjectsCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetBackupSecurityPINRequestsObjectsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/getBackupSecurityPINRequests"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getBackupSecurityPINRequestsObjectsHandleResponse handles the GetBackupSecurityPINRequestsObjects response.
func (client *ResourceGuardsClient) getBackupSecurityPINRequestsObjectsHandleResponse(resp *http.Response) (ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse, error) {
	result := ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResourceList); err != nil {
		return ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse{}, err
	}
	return result, nil
}

// GetDefaultBackupSecurityPINRequestsObject - Returns collection of operation request objects for a critical operation protected
// by the given ResourceGuard resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectOptions contains the optional parameters for the
//     ResourceGuardsClient.GetDefaultBackupSecurityPINRequestsObject method.
func (client *ResourceGuardsClient) GetDefaultBackupSecurityPINRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectOptions) (ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectResponse, error) {
	var err error
	const operationName = "ResourceGuardsClient.GetDefaultBackupSecurityPINRequestsObject"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDefaultBackupSecurityPINRequestsObjectCreateRequest(ctx, resourceGroupName, resourceGuardsName, requestName, options)
	if err != nil {
		return ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectResponse{}, err
	}
	resp, err := client.getDefaultBackupSecurityPINRequestsObjectHandleResponse(httpResp)
	return resp, err
}

// getDefaultBackupSecurityPINRequestsObjectCreateRequest creates the GetDefaultBackupSecurityPINRequestsObject request.
func (client *ResourceGuardsClient) getDefaultBackupSecurityPINRequestsObjectCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/getBackupSecurityPINRequests/{requestName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	if requestName == "" {
		return nil, errors.New("parameter requestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestName}", url.PathEscape(requestName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDefaultBackupSecurityPINRequestsObjectHandleResponse handles the GetDefaultBackupSecurityPINRequestsObject response.
func (client *ResourceGuardsClient) getDefaultBackupSecurityPINRequestsObjectHandleResponse(resp *http.Response) (ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectResponse, error) {
	result := ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResource); err != nil {
		return ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectResponse{}, err
	}
	return result, nil
}

// GetDefaultDeleteProtectedItemRequestsObject - Returns collection of operation request objects for a critical operation
// protected by the given ResourceGuard resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectOptions contains the optional parameters for the
//     ResourceGuardsClient.GetDefaultDeleteProtectedItemRequestsObject method.
func (client *ResourceGuardsClient) GetDefaultDeleteProtectedItemRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectOptions) (ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectResponse, error) {
	var err error
	const operationName = "ResourceGuardsClient.GetDefaultDeleteProtectedItemRequestsObject"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDefaultDeleteProtectedItemRequestsObjectCreateRequest(ctx, resourceGroupName, resourceGuardsName, requestName, options)
	if err != nil {
		return ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectResponse{}, err
	}
	resp, err := client.getDefaultDeleteProtectedItemRequestsObjectHandleResponse(httpResp)
	return resp, err
}

// getDefaultDeleteProtectedItemRequestsObjectCreateRequest creates the GetDefaultDeleteProtectedItemRequestsObject request.
func (client *ResourceGuardsClient) getDefaultDeleteProtectedItemRequestsObjectCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteProtectedItemRequests/{requestName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	if requestName == "" {
		return nil, errors.New("parameter requestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestName}", url.PathEscape(requestName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDefaultDeleteProtectedItemRequestsObjectHandleResponse handles the GetDefaultDeleteProtectedItemRequestsObject response.
func (client *ResourceGuardsClient) getDefaultDeleteProtectedItemRequestsObjectHandleResponse(resp *http.Response) (ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectResponse, error) {
	result := ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResource); err != nil {
		return ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectResponse{}, err
	}
	return result, nil
}

// GetDefaultDeleteResourceGuardProxyRequestsObject - Returns collection of operation request objects for a critical operation
// protected by the given ResourceGuard resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectOptions contains the optional parameters
//     for the ResourceGuardsClient.GetDefaultDeleteResourceGuardProxyRequestsObject method.
func (client *ResourceGuardsClient) GetDefaultDeleteResourceGuardProxyRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectOptions) (ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectResponse, error) {
	var err error
	const operationName = "ResourceGuardsClient.GetDefaultDeleteResourceGuardProxyRequestsObject"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDefaultDeleteResourceGuardProxyRequestsObjectCreateRequest(ctx, resourceGroupName, resourceGuardsName, requestName, options)
	if err != nil {
		return ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectResponse{}, err
	}
	resp, err := client.getDefaultDeleteResourceGuardProxyRequestsObjectHandleResponse(httpResp)
	return resp, err
}

// getDefaultDeleteResourceGuardProxyRequestsObjectCreateRequest creates the GetDefaultDeleteResourceGuardProxyRequestsObject request.
func (client *ResourceGuardsClient) getDefaultDeleteResourceGuardProxyRequestsObjectCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteResourceGuardProxyRequests/{requestName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	if requestName == "" {
		return nil, errors.New("parameter requestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestName}", url.PathEscape(requestName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDefaultDeleteResourceGuardProxyRequestsObjectHandleResponse handles the GetDefaultDeleteResourceGuardProxyRequestsObject response.
func (client *ResourceGuardsClient) getDefaultDeleteResourceGuardProxyRequestsObjectHandleResponse(resp *http.Response) (ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectResponse, error) {
	result := ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResource); err != nil {
		return ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectResponse{}, err
	}
	return result, nil
}

// GetDefaultDisableSoftDeleteRequestsObject - Returns collection of operation request objects for a critical operation protected
// by the given ResourceGuard resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectOptions contains the optional parameters for the
//     ResourceGuardsClient.GetDefaultDisableSoftDeleteRequestsObject method.
func (client *ResourceGuardsClient) GetDefaultDisableSoftDeleteRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectOptions) (ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectResponse, error) {
	var err error
	const operationName = "ResourceGuardsClient.GetDefaultDisableSoftDeleteRequestsObject"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDefaultDisableSoftDeleteRequestsObjectCreateRequest(ctx, resourceGroupName, resourceGuardsName, requestName, options)
	if err != nil {
		return ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectResponse{}, err
	}
	resp, err := client.getDefaultDisableSoftDeleteRequestsObjectHandleResponse(httpResp)
	return resp, err
}

// getDefaultDisableSoftDeleteRequestsObjectCreateRequest creates the GetDefaultDisableSoftDeleteRequestsObject request.
func (client *ResourceGuardsClient) getDefaultDisableSoftDeleteRequestsObjectCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/disableSoftDeleteRequests/{requestName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	if requestName == "" {
		return nil, errors.New("parameter requestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestName}", url.PathEscape(requestName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDefaultDisableSoftDeleteRequestsObjectHandleResponse handles the GetDefaultDisableSoftDeleteRequestsObject response.
func (client *ResourceGuardsClient) getDefaultDisableSoftDeleteRequestsObjectHandleResponse(resp *http.Response) (ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectResponse, error) {
	result := ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResource); err != nil {
		return ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectResponse{}, err
	}
	return result, nil
}

// GetDefaultUpdateProtectedItemRequestsObject - Returns collection of operation request objects for a critical operation
// protected by the given ResourceGuard resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectOptions contains the optional parameters for the
//     ResourceGuardsClient.GetDefaultUpdateProtectedItemRequestsObject method.
func (client *ResourceGuardsClient) GetDefaultUpdateProtectedItemRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectOptions) (ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectResponse, error) {
	var err error
	const operationName = "ResourceGuardsClient.GetDefaultUpdateProtectedItemRequestsObject"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDefaultUpdateProtectedItemRequestsObjectCreateRequest(ctx, resourceGroupName, resourceGuardsName, requestName, options)
	if err != nil {
		return ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectResponse{}, err
	}
	resp, err := client.getDefaultUpdateProtectedItemRequestsObjectHandleResponse(httpResp)
	return resp, err
}

// getDefaultUpdateProtectedItemRequestsObjectCreateRequest creates the GetDefaultUpdateProtectedItemRequestsObject request.
func (client *ResourceGuardsClient) getDefaultUpdateProtectedItemRequestsObjectCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectedItemRequests/{requestName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	if requestName == "" {
		return nil, errors.New("parameter requestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestName}", url.PathEscape(requestName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDefaultUpdateProtectedItemRequestsObjectHandleResponse handles the GetDefaultUpdateProtectedItemRequestsObject response.
func (client *ResourceGuardsClient) getDefaultUpdateProtectedItemRequestsObjectHandleResponse(resp *http.Response) (ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectResponse, error) {
	result := ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResource); err != nil {
		return ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectResponse{}, err
	}
	return result, nil
}

// GetDefaultUpdateProtectionPolicyRequestsObject - Returns collection of operation request objects for a critical operation
// protected by the given ResourceGuard resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectOptions contains the optional parameters for
//     the ResourceGuardsClient.GetDefaultUpdateProtectionPolicyRequestsObject method.
func (client *ResourceGuardsClient) GetDefaultUpdateProtectionPolicyRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectOptions) (ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectResponse, error) {
	var err error
	const operationName = "ResourceGuardsClient.GetDefaultUpdateProtectionPolicyRequestsObject"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDefaultUpdateProtectionPolicyRequestsObjectCreateRequest(ctx, resourceGroupName, resourceGuardsName, requestName, options)
	if err != nil {
		return ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectResponse{}, err
	}
	resp, err := client.getDefaultUpdateProtectionPolicyRequestsObjectHandleResponse(httpResp)
	return resp, err
}

// getDefaultUpdateProtectionPolicyRequestsObjectCreateRequest creates the GetDefaultUpdateProtectionPolicyRequestsObject request.
func (client *ResourceGuardsClient) getDefaultUpdateProtectionPolicyRequestsObjectCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectionPolicyRequests/{requestName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	if requestName == "" {
		return nil, errors.New("parameter requestName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestName}", url.PathEscape(requestName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDefaultUpdateProtectionPolicyRequestsObjectHandleResponse handles the GetDefaultUpdateProtectionPolicyRequestsObject response.
func (client *ResourceGuardsClient) getDefaultUpdateProtectionPolicyRequestsObjectHandleResponse(resp *http.Response) (ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectResponse, error) {
	result := ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResource); err != nil {
		return ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectResponse{}, err
	}
	return result, nil
}

// NewGetDeleteProtectedItemRequestsObjectsPager - Returns collection of operation request objects for a critical operation
// protected by the given ResourceGuard resource.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsOptions contains the optional parameters for the ResourceGuardsClient.NewGetDeleteProtectedItemRequestsObjectsPager
//     method.
func (client *ResourceGuardsClient) NewGetDeleteProtectedItemRequestsObjectsPager(resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsOptions) *runtime.Pager[ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse]{
		More: func(page ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse) (ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ResourceGuardsClient.NewGetDeleteProtectedItemRequestsObjectsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getDeleteProtectedItemRequestsObjectsCreateRequest(ctx, resourceGroupName, resourceGuardsName, options)
			}, nil)
			if err != nil {
				return ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse{}, err
			}
			return client.getDeleteProtectedItemRequestsObjectsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getDeleteProtectedItemRequestsObjectsCreateRequest creates the GetDeleteProtectedItemRequestsObjects request.
func (client *ResourceGuardsClient) getDeleteProtectedItemRequestsObjectsCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteProtectedItemRequests"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeleteProtectedItemRequestsObjectsHandleResponse handles the GetDeleteProtectedItemRequestsObjects response.
func (client *ResourceGuardsClient) getDeleteProtectedItemRequestsObjectsHandleResponse(resp *http.Response) (ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse, error) {
	result := ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResourceList); err != nil {
		return ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse{}, err
	}
	return result, nil
}

// NewGetDeleteResourceGuardProxyRequestsObjectsPager - Returns collection of operation request objects for a critical operation
// protected by the given ResourceGuard resource.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsOptions contains the optional parameters for the
//     ResourceGuardsClient.NewGetDeleteResourceGuardProxyRequestsObjectsPager method.
func (client *ResourceGuardsClient) NewGetDeleteResourceGuardProxyRequestsObjectsPager(resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsOptions) *runtime.Pager[ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse]{
		More: func(page ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse) (ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ResourceGuardsClient.NewGetDeleteResourceGuardProxyRequestsObjectsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getDeleteResourceGuardProxyRequestsObjectsCreateRequest(ctx, resourceGroupName, resourceGuardsName, options)
			}, nil)
			if err != nil {
				return ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse{}, err
			}
			return client.getDeleteResourceGuardProxyRequestsObjectsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getDeleteResourceGuardProxyRequestsObjectsCreateRequest creates the GetDeleteResourceGuardProxyRequestsObjects request.
func (client *ResourceGuardsClient) getDeleteResourceGuardProxyRequestsObjectsCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteResourceGuardProxyRequests"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeleteResourceGuardProxyRequestsObjectsHandleResponse handles the GetDeleteResourceGuardProxyRequestsObjects response.
func (client *ResourceGuardsClient) getDeleteResourceGuardProxyRequestsObjectsHandleResponse(resp *http.Response) (ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse, error) {
	result := ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResourceList); err != nil {
		return ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse{}, err
	}
	return result, nil
}

// NewGetDisableSoftDeleteRequestsObjectsPager - Returns collection of operation request objects for a critical operation
// protected by the given ResourceGuard resource.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsOptions contains the optional parameters for the ResourceGuardsClient.NewGetDisableSoftDeleteRequestsObjectsPager
//     method.
func (client *ResourceGuardsClient) NewGetDisableSoftDeleteRequestsObjectsPager(resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsOptions) *runtime.Pager[ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse]{
		More: func(page ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse) (ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ResourceGuardsClient.NewGetDisableSoftDeleteRequestsObjectsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getDisableSoftDeleteRequestsObjectsCreateRequest(ctx, resourceGroupName, resourceGuardsName, options)
			}, nil)
			if err != nil {
				return ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse{}, err
			}
			return client.getDisableSoftDeleteRequestsObjectsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getDisableSoftDeleteRequestsObjectsCreateRequest creates the GetDisableSoftDeleteRequestsObjects request.
func (client *ResourceGuardsClient) getDisableSoftDeleteRequestsObjectsCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/disableSoftDeleteRequests"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDisableSoftDeleteRequestsObjectsHandleResponse handles the GetDisableSoftDeleteRequestsObjects response.
func (client *ResourceGuardsClient) getDisableSoftDeleteRequestsObjectsHandleResponse(resp *http.Response) (ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse, error) {
	result := ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResourceList); err != nil {
		return ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse{}, err
	}
	return result, nil
}

// NewGetResourcesInResourceGroupPager - Returns ResourceGuards collection belonging to a ResourceGroup.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetResourcesInResourceGroupOptions contains the optional parameters for the ResourceGuardsClient.NewGetResourcesInResourceGroupPager
//     method.
func (client *ResourceGuardsClient) NewGetResourcesInResourceGroupPager(resourceGroupName string, options *ResourceGuardsClientGetResourcesInResourceGroupOptions) *runtime.Pager[ResourceGuardsClientGetResourcesInResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceGuardsClientGetResourcesInResourceGroupResponse]{
		More: func(page ResourceGuardsClientGetResourcesInResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceGuardsClientGetResourcesInResourceGroupResponse) (ResourceGuardsClientGetResourcesInResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ResourceGuardsClient.NewGetResourcesInResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getResourcesInResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return ResourceGuardsClientGetResourcesInResourceGroupResponse{}, err
			}
			return client.getResourcesInResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getResourcesInResourceGroupCreateRequest creates the GetResourcesInResourceGroup request.
func (client *ResourceGuardsClient) getResourcesInResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *ResourceGuardsClientGetResourcesInResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getResourcesInResourceGroupHandleResponse handles the GetResourcesInResourceGroup response.
func (client *ResourceGuardsClient) getResourcesInResourceGroupHandleResponse(resp *http.Response) (ResourceGuardsClientGetResourcesInResourceGroupResponse, error) {
	result := ResourceGuardsClientGetResourcesInResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceGuardResourceList); err != nil {
		return ResourceGuardsClientGetResourcesInResourceGroupResponse{}, err
	}
	return result, nil
}

// NewGetResourcesInSubscriptionPager - Returns ResourceGuards collection belonging to a subscription.
//
// Generated from API version 2023-11-01
//   - options - ResourceGuardsClientGetResourcesInSubscriptionOptions contains the optional parameters for the ResourceGuardsClient.NewGetResourcesInSubscriptionPager
//     method.
func (client *ResourceGuardsClient) NewGetResourcesInSubscriptionPager(options *ResourceGuardsClientGetResourcesInSubscriptionOptions) *runtime.Pager[ResourceGuardsClientGetResourcesInSubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceGuardsClientGetResourcesInSubscriptionResponse]{
		More: func(page ResourceGuardsClientGetResourcesInSubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceGuardsClientGetResourcesInSubscriptionResponse) (ResourceGuardsClientGetResourcesInSubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ResourceGuardsClient.NewGetResourcesInSubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getResourcesInSubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ResourceGuardsClientGetResourcesInSubscriptionResponse{}, err
			}
			return client.getResourcesInSubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getResourcesInSubscriptionCreateRequest creates the GetResourcesInSubscription request.
func (client *ResourceGuardsClient) getResourcesInSubscriptionCreateRequest(ctx context.Context, options *ResourceGuardsClientGetResourcesInSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DataProtection/resourceGuards"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getResourcesInSubscriptionHandleResponse handles the GetResourcesInSubscription response.
func (client *ResourceGuardsClient) getResourcesInSubscriptionHandleResponse(resp *http.Response) (ResourceGuardsClientGetResourcesInSubscriptionResponse, error) {
	result := ResourceGuardsClientGetResourcesInSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceGuardResourceList); err != nil {
		return ResourceGuardsClientGetResourcesInSubscriptionResponse{}, err
	}
	return result, nil
}

// NewGetUpdateProtectedItemRequestsObjectsPager - Returns collection of operation request objects for a critical operation
// protected by the given ResourceGuard resource.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsOptions contains the optional parameters for the ResourceGuardsClient.NewGetUpdateProtectedItemRequestsObjectsPager
//     method.
func (client *ResourceGuardsClient) NewGetUpdateProtectedItemRequestsObjectsPager(resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsOptions) *runtime.Pager[ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse]{
		More: func(page ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse) (ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ResourceGuardsClient.NewGetUpdateProtectedItemRequestsObjectsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getUpdateProtectedItemRequestsObjectsCreateRequest(ctx, resourceGroupName, resourceGuardsName, options)
			}, nil)
			if err != nil {
				return ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse{}, err
			}
			return client.getUpdateProtectedItemRequestsObjectsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getUpdateProtectedItemRequestsObjectsCreateRequest creates the GetUpdateProtectedItemRequestsObjects request.
func (client *ResourceGuardsClient) getUpdateProtectedItemRequestsObjectsCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectedItemRequests"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getUpdateProtectedItemRequestsObjectsHandleResponse handles the GetUpdateProtectedItemRequestsObjects response.
func (client *ResourceGuardsClient) getUpdateProtectedItemRequestsObjectsHandleResponse(resp *http.Response) (ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse, error) {
	result := ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResourceList); err != nil {
		return ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse{}, err
	}
	return result, nil
}

// NewGetUpdateProtectionPolicyRequestsObjectsPager - Returns collection of operation request objects for a critical operation
// protected by the given ResourceGuard resource.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsOptions contains the optional parameters for the
//     ResourceGuardsClient.NewGetUpdateProtectionPolicyRequestsObjectsPager method.
func (client *ResourceGuardsClient) NewGetUpdateProtectionPolicyRequestsObjectsPager(resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsOptions) *runtime.Pager[ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse]{
		More: func(page ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse) (ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ResourceGuardsClient.NewGetUpdateProtectionPolicyRequestsObjectsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getUpdateProtectionPolicyRequestsObjectsCreateRequest(ctx, resourceGroupName, resourceGuardsName, options)
			}, nil)
			if err != nil {
				return ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse{}, err
			}
			return client.getUpdateProtectionPolicyRequestsObjectsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// getUpdateProtectionPolicyRequestsObjectsCreateRequest creates the GetUpdateProtectionPolicyRequestsObjects request.
func (client *ResourceGuardsClient) getUpdateProtectionPolicyRequestsObjectsCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectionPolicyRequests"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getUpdateProtectionPolicyRequestsObjectsHandleResponse handles the GetUpdateProtectionPolicyRequestsObjects response.
func (client *ResourceGuardsClient) getUpdateProtectionPolicyRequestsObjectsHandleResponse(resp *http.Response) (ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse, error) {
	result := ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DppBaseResourceList); err != nil {
		return ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse{}, err
	}
	return result, nil
}

// Patch - Updates a ResourceGuard resource belonging to a resource group. For example, updating tags for a resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceGuardsName - The name of ResourceGuard
//   - parameters - Request body for operation
//   - options - ResourceGuardsClientPatchOptions contains the optional parameters for the ResourceGuardsClient.Patch method.
func (client *ResourceGuardsClient) Patch(ctx context.Context, resourceGroupName string, resourceGuardsName string, parameters PatchResourceGuardInput, options *ResourceGuardsClientPatchOptions) (ResourceGuardsClientPatchResponse, error) {
	var err error
	const operationName = "ResourceGuardsClient.Patch"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.patchCreateRequest(ctx, resourceGroupName, resourceGuardsName, parameters, options)
	if err != nil {
		return ResourceGuardsClientPatchResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceGuardsClientPatchResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ResourceGuardsClientPatchResponse{}, err
	}
	resp, err := client.patchHandleResponse(httpResp)
	return resp, err
}

// patchCreateRequest creates the Patch request.
func (client *ResourceGuardsClient) patchCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, parameters PatchResourceGuardInput, options *ResourceGuardsClientPatchOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// patchHandleResponse handles the Patch response.
func (client *ResourceGuardsClient) patchHandleResponse(resp *http.Response) (ResourceGuardsClientPatchResponse, error) {
	result := ResourceGuardsClientPatchResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceGuardResource); err != nil {
		return ResourceGuardsClientPatchResponse{}, err
	}
	return result, nil
}

// Put - Creates or updates a ResourceGuard resource belonging to a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - resourceGuardsName - The name of ResourceGuard
//   - parameters - Request body for operation
//   - options - ResourceGuardsClientPutOptions contains the optional parameters for the ResourceGuardsClient.Put method.
func (client *ResourceGuardsClient) Put(ctx context.Context, resourceGroupName string, resourceGuardsName string, parameters ResourceGuardResource, options *ResourceGuardsClientPutOptions) (ResourceGuardsClientPutResponse, error) {
	var err error
	const operationName = "ResourceGuardsClient.Put"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.putCreateRequest(ctx, resourceGroupName, resourceGuardsName, parameters, options)
	if err != nil {
		return ResourceGuardsClientPutResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceGuardsClientPutResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ResourceGuardsClientPutResponse{}, err
	}
	resp, err := client.putHandleResponse(httpResp)
	return resp, err
}

// putCreateRequest creates the Put request.
func (client *ResourceGuardsClient) putCreateRequest(ctx context.Context, resourceGroupName string, resourceGuardsName string, parameters ResourceGuardResource, options *ResourceGuardsClientPutOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGuardsName == "" {
		return nil, errors.New("parameter resourceGuardsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGuardsName}", url.PathEscape(resourceGuardsName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// putHandleResponse handles the Put response.
func (client *ResourceGuardsClient) putHandleResponse(resp *http.Response) (ResourceGuardsClientPutResponse, error) {
	result := ResourceGuardsClientPutResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceGuardResource); err != nil {
		return ResourceGuardsClientPutResponse{}, err
	}
	return result, nil
}
