//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcosmos_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterList.json
func ExampleMongoClustersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMongoClustersClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MongoClusterListResult = armcosmos.MongoClusterListResult{
		// 	Value: []*armcosmos.MongoCluster{
		// 		{
		// 			Name: to.Ptr("myMongoCluster"),
		// 			Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster"),
		// 			SystemData: &armcosmos.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("westus2"),
		// 			Tags: map[string]*string{
		// 				"additionalProp1": to.Ptr("string"),
		// 				"additionalProp2": to.Ptr("string"),
		// 				"additionalProp3": to.Ptr("string"),
		// 			},
		// 			Properties: &armcosmos.MongoClusterProperties{
		// 				AdministratorLogin: to.Ptr("mongoAdmin"),
		// 				ConnectionString: to.Ptr("mongodb+srv://<user>:<password>@myMongoCluster.mongocluster.cosmos.azure.com"),
		// 				EarliestRestoreTime: to.Ptr("2023-01-13T20:07:35Z"),
		// 				NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
		// 					{
		// 						DiskSizeGB: to.Ptr[int64](128),
		// 						EnableHa: to.Ptr(true),
		// 						SKU: to.Ptr("M30"),
		// 						Kind: to.Ptr(armcosmos.NodeKindShard),
		// 						NodeCount: to.Ptr[int32](4),
		// 				}},
		// 				ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
		// 				ServerVersion: to.Ptr("5.0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myMongoCluster2"),
		// 			Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster2"),
		// 			SystemData: &armcosmos.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user2"),
		// 				CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"additionalProp1": to.Ptr("string"),
		// 			},
		// 			Properties: &armcosmos.MongoClusterProperties{
		// 				AdministratorLogin: to.Ptr("mongoAdmin"),
		// 				ConnectionString: to.Ptr("mongodb+srv://<user>:<password>@myMongoCluster.mongocluster.cosmos.azure.com"),
		// 				EarliestRestoreTime: to.Ptr("2023-01-10T20:07:35Z"),
		// 				NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
		// 					{
		// 						DiskSizeGB: to.Ptr[int64](256),
		// 						EnableHa: to.Ptr(true),
		// 						SKU: to.Ptr("M40"),
		// 						Kind: to.Ptr(armcosmos.NodeKindShard),
		// 						NodeCount: to.Ptr[int32](2),
		// 				}},
		// 				ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
		// 				ServerVersion: to.Ptr("5.0"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterListByResourceGroup.json
func ExampleMongoClustersClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMongoClustersClient().NewListByResourceGroupPager("TestResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MongoClusterListResult = armcosmos.MongoClusterListResult{
		// 	Value: []*armcosmos.MongoCluster{
		// 		{
		// 			Name: to.Ptr("myMongoCluster"),
		// 			Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster"),
		// 			SystemData: &armcosmos.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("westus2"),
		// 			Tags: map[string]*string{
		// 				"additionalProp1": to.Ptr("string"),
		// 				"additionalProp2": to.Ptr("string"),
		// 				"additionalProp3": to.Ptr("string"),
		// 			},
		// 			Properties: &armcosmos.MongoClusterProperties{
		// 				AdministratorLogin: to.Ptr("mongoAdmin"),
		// 				ConnectionString: to.Ptr("mongodb+srv://<user>:<password>@myMongoCluster.mongocluster.cosmos.azure.com"),
		// 				EarliestRestoreTime: to.Ptr("2023-01-13T20:07:35Z"),
		// 				NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
		// 					{
		// 						DiskSizeGB: to.Ptr[int64](128),
		// 						EnableHa: to.Ptr(true),
		// 						SKU: to.Ptr("M30"),
		// 						Kind: to.Ptr(armcosmos.NodeKindShard),
		// 						NodeCount: to.Ptr[int32](4),
		// 				}},
		// 				ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
		// 				ServerVersion: to.Ptr("5.0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myMongoCluster2"),
		// 			Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster2"),
		// 			SystemData: &armcosmos.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user2"),
		// 				CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"additionalProp1": to.Ptr("string"),
		// 			},
		// 			Properties: &armcosmos.MongoClusterProperties{
		// 				AdministratorLogin: to.Ptr("mongoAdmin"),
		// 				ConnectionString: to.Ptr("mongodb+srv://<user>:<password>@myMongoCluster2.mongocluster.cosmos.azure.com"),
		// 				EarliestRestoreTime: to.Ptr("2023-01-10T20:07:35Z"),
		// 				NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
		// 					{
		// 						DiskSizeGB: to.Ptr[int64](256),
		// 						EnableHa: to.Ptr(true),
		// 						SKU: to.Ptr("M40"),
		// 						Kind: to.Ptr(armcosmos.NodeKindShard),
		// 						NodeCount: to.Ptr[int32](2),
		// 				}},
		// 				ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
		// 				ServerVersion: to.Ptr("5.0"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterCreate.json
func ExampleMongoClustersClient_BeginCreateOrUpdate_createANewMongoCluster() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMongoClustersClient().BeginCreateOrUpdate(ctx, "TestResourceGroup", "myMongoCluster", armcosmos.MongoCluster{
		Location: to.Ptr("westus2"),
		Properties: &armcosmos.MongoClusterProperties{
			AdministratorLogin:         to.Ptr("mongoAdmin"),
			AdministratorLoginPassword: to.Ptr("password"),
			NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
				{
					DiskSizeGB: to.Ptr[int64](128),
					EnableHa:   to.Ptr(true),
					SKU:        to.Ptr("M30"),
					Kind:       to.Ptr(armcosmos.NodeKindShard),
					NodeCount:  to.Ptr[int32](3),
				}},
			ServerVersion: to.Ptr("5.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MongoCluster = armcosmos.MongoCluster{
	// 	Name: to.Ptr("myMongoCluster"),
	// 	Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster"),
	// 	SystemData: &armcosmos.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armcosmos.MongoClusterProperties{
	// 		AdministratorLogin: to.Ptr("mongoAdmin"),
	// 		ConnectionString: to.Ptr("mongodb+srv://<user>:<password>@myMongoCluster.mongocluster.cosmos.azure.com"),
	// 		EarliestRestoreTime: to.Ptr("2023-01-13T20:07:35Z"),
	// 		NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
	// 			{
	// 				DiskSizeGB: to.Ptr[int64](128),
	// 				EnableHa: to.Ptr(true),
	// 				SKU: to.Ptr("M30"),
	// 				Kind: to.Ptr(armcosmos.NodeKindShard),
	// 				NodeCount: to.Ptr[int32](3),
	// 		}},
	// 		ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
	// 		ServerVersion: to.Ptr("5.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterCreatePITR.json
func ExampleMongoClustersClient_BeginCreateOrUpdate_createANewMongoClusterWithPointInTimeRestore() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMongoClustersClient().BeginCreateOrUpdate(ctx, "TestResourceGroup", "myMongoCluster", armcosmos.MongoCluster{
		Location: to.Ptr("westus2"),
		Properties: &armcosmos.MongoClusterProperties{
			CreateMode: to.Ptr(armcosmos.CreateModePointInTimeRestore),
			RestoreParameters: &armcosmos.MongoClusterRestoreParameters{
				PointInTimeUTC:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-01-13T20:07:35.000Z"); return t }()),
				SourceResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myOtherMongoCluster"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MongoCluster = armcosmos.MongoCluster{
	// 	Name: to.Ptr("myMongoCluster"),
	// 	Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster"),
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armcosmos.MongoClusterProperties{
	// 		AdministratorLogin: to.Ptr("mongoAdmin"),
	// 		ConnectionString: to.Ptr("mongodb+srv://<user>:<password>@myMongoCluster.mongocluster.cosmos.azure.com"),
	// 		EarliestRestoreTime: to.Ptr("2023-01-13T20:07:35Z"),
	// 		NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
	// 			{
	// 				DiskSizeGB: to.Ptr[int64](128),
	// 				EnableHa: to.Ptr(true),
	// 				SKU: to.Ptr("M30"),
	// 				Kind: to.Ptr(armcosmos.NodeKindShard),
	// 				NodeCount: to.Ptr[int32](3),
	// 		}},
	// 		ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
	// 		ServerVersion: to.Ptr("5.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterGet.json
func ExampleMongoClustersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMongoClustersClient().Get(ctx, "TestResourceGroup", "myMongoCluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MongoCluster = armcosmos.MongoCluster{
	// 	Name: to.Ptr("myMongoCluster"),
	// 	Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster"),
	// 	SystemData: &armcosmos.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westus2"),
	// 	Tags: map[string]*string{
	// 		"additionalProp1": to.Ptr("string"),
	// 		"additionalProp2": to.Ptr("string"),
	// 		"additionalProp3": to.Ptr("string"),
	// 	},
	// 	Properties: &armcosmos.MongoClusterProperties{
	// 		AdministratorLogin: to.Ptr("mongoAdmin"),
	// 		ConnectionString: to.Ptr("mongodb+srv://<user>:<password>@myMongoCluster.mongocluster.cosmos.azure.com"),
	// 		EarliestRestoreTime: to.Ptr("2023-01-13T20:07:35Z"),
	// 		NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
	// 			{
	// 				DiskSizeGB: to.Ptr[int64](128),
	// 				EnableHa: to.Ptr(true),
	// 				SKU: to.Ptr("M30"),
	// 				Kind: to.Ptr(armcosmos.NodeKindShard),
	// 				NodeCount: to.Ptr[int32](4),
	// 		}},
	// 		ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
	// 		ServerVersion: to.Ptr("5.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterDelete.json
func ExampleMongoClustersClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMongoClustersClient().BeginDelete(ctx, "TestResourceGroup", "myMongoCluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterAddNode.json
func ExampleMongoClustersClient_BeginUpdate_addNewShardNodes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMongoClustersClient().BeginUpdate(ctx, "TestResourceGroup", "myMongoCluster", armcosmos.MongoClusterUpdate{
		Properties: &armcosmos.MongoClusterProperties{
			NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
				{
					Kind:      to.Ptr(armcosmos.NodeKindShard),
					NodeCount: to.Ptr[int32](4),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MongoCluster = armcosmos.MongoCluster{
	// 	Name: to.Ptr("myMongoCluster"),
	// 	Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster"),
	// 	SystemData: &armcosmos.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armcosmos.MongoClusterProperties{
	// 		AdministratorLogin: to.Ptr("mongoAdmin"),
	// 		ConnectionString: to.Ptr("mongodb+srv://<user>:<password>@myMongoCluster.mongocluster.cosmos.azure.com"),
	// 		EarliestRestoreTime: to.Ptr("2023-01-13T20:07:35Z"),
	// 		NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
	// 			{
	// 				DiskSizeGB: to.Ptr[int64](128),
	// 				EnableHa: to.Ptr(true),
	// 				SKU: to.Ptr("M30"),
	// 				Kind: to.Ptr(armcosmos.NodeKindShard),
	// 				NodeCount: to.Ptr[int32](4),
	// 		}},
	// 		ServerVersion: to.Ptr("5.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterUpdate.json
func ExampleMongoClustersClient_BeginUpdate_updateTheMongoCluster() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMongoClustersClient().BeginUpdate(ctx, "TestResourceGroup", "myMongoCluster", armcosmos.MongoClusterUpdate{
		Properties: &armcosmos.MongoClusterProperties{
			AdministratorLogin:         to.Ptr("mongoAdmin"),
			AdministratorLoginPassword: to.Ptr("password"),
			NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
				{
					DiskSizeGB: to.Ptr[int64](256),
					EnableHa:   to.Ptr(true),
					SKU:        to.Ptr("M50"),
					Kind:       to.Ptr(armcosmos.NodeKindShard),
					NodeCount:  to.Ptr[int32](4),
				}},
			ServerVersion: to.Ptr("5.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MongoCluster = armcosmos.MongoCluster{
	// 	Name: to.Ptr("myMongoCluster"),
	// 	Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster"),
	// 	SystemData: &armcosmos.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armcosmos.MongoClusterProperties{
	// 		AdministratorLogin: to.Ptr("mongoAdmin"),
	// 		ConnectionString: to.Ptr("mongodb+srv://<user>:<password>@myMongoCluster.mongocluster.cosmos.azure.com"),
	// 		EarliestRestoreTime: to.Ptr("2023-01-13T20:07:35Z"),
	// 		NodeGroupSpecs: []*armcosmos.NodeGroupSpec{
	// 			{
	// 				DiskSizeGB: to.Ptr[int64](256),
	// 				EnableHa: to.Ptr(true),
	// 				SKU: to.Ptr("M50"),
	// 				Kind: to.Ptr(armcosmos.NodeKindShard),
	// 				NodeCount: to.Ptr[int32](4),
	// 		}},
	// 		ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
	// 		ServerVersion: to.Ptr("5.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterFirewallRuleCreate.json
func ExampleMongoClustersClient_BeginCreateOrUpdateFirewallRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMongoClustersClient().BeginCreateOrUpdateFirewallRule(ctx, "TestGroup", "myMongoCluster", "rule1", armcosmos.FirewallRule{
		Properties: &armcosmos.FirewallRuleProperties{
			EndIPAddress:   to.Ptr("255.255.255.255"),
			StartIPAddress: to.Ptr("0.0.0.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FirewallRule = armcosmos.FirewallRule{
	// 	Name: to.Ptr("rule1"),
	// 	Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters/firewallRules"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster/firewallRules/rule1"),
	// 	SystemData: &armcosmos.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 	},
	// 	Properties: &armcosmos.FirewallRuleProperties{
	// 		EndIPAddress: to.Ptr("255.255.255.255"),
	// 		ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
	// 		StartIPAddress: to.Ptr("0.0.0.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterFirewallRuleDelete.json
func ExampleMongoClustersClient_BeginDeleteFirewallRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMongoClustersClient().BeginDeleteFirewallRule(ctx, "TestGroup", "myMongoCluster", "rule1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterFirewallRuleGet.json
func ExampleMongoClustersClient_GetFirewallRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMongoClustersClient().GetFirewallRule(ctx, "TestGroup", "myMongoCluster", "rule1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FirewallRule = armcosmos.FirewallRule{
	// 	Name: to.Ptr("rule1"),
	// 	Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters/firewallRules"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster/firewallRules/rule1"),
	// 	SystemData: &armcosmos.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
	// 	},
	// 	Properties: &armcosmos.FirewallRuleProperties{
	// 		EndIPAddress: to.Ptr("255.255.255.255"),
	// 		ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
	// 		StartIPAddress: to.Ptr("0.0.0.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterFirewallRuleList.json
func ExampleMongoClustersClient_NewListFirewallRulesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMongoClustersClient().NewListFirewallRulesPager("TestGroup", "myMongoCluster", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FirewallRuleListResult = armcosmos.FirewallRuleListResult{
		// 	Value: []*armcosmos.FirewallRule{
		// 		{
		// 			Name: to.Ptr("rule1"),
		// 			Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters/firewallRules"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster/firewallRules/rule1"),
		// 			SystemData: &armcosmos.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 			},
		// 			Properties: &armcosmos.FirewallRuleProperties{
		// 				EndIPAddress: to.Ptr("255.255.255.255"),
		// 				ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
		// 				StartIPAddress: to.Ptr("0.0.0.0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("rule2"),
		// 			Type: to.Ptr("/Microsoft.DocumentDB/mongoClusters/firewallRules"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DocumentDB/mongoClusters/myMongoCluster/firewallRules/rule2"),
		// 			SystemData: &armcosmos.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.123Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.123Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armcosmos.CreatedByTypeUser),
		// 			},
		// 			Properties: &armcosmos.FirewallRuleProperties{
		// 				EndIPAddress: to.Ptr("255.0.0.0"),
		// 				ProvisioningState: to.Ptr(armcosmos.ProvisioningStateSucceeded),
		// 				StartIPAddress: to.Ptr("1.0.0.0"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterNameAvailability.json
func ExampleMongoClustersClient_CheckNameAvailability_checkNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMongoClustersClient().CheckNameAvailability(ctx, "westus2", armcosmos.CheckNameAvailabilityRequest{
		Name: to.Ptr("newmongocluster"),
		Type: to.Ptr("Microsoft.DocumentDB/mongoClusters"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResponse = armcosmos.CheckNameAvailabilityResponse{
	// 	NameAvailable: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterNameAvailability_AlreadyExists.json
func ExampleMongoClustersClient_CheckNameAvailability_checkNameAvailabilityAlreadyExistsResult() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMongoClustersClient().CheckNameAvailability(ctx, "westus2", armcosmos.CheckNameAvailabilityRequest{
		Name: to.Ptr("existingmongocluster"),
		Type: to.Ptr("Microsoft.DocumentDB/mongoClusters"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResponse = armcosmos.CheckNameAvailabilityResponse{
	// 	Message: to.Ptr("Cluster name 'existingmongocluster' is already in use."),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr(armcosmos.CheckNameAvailabilityReasonAlreadyExists),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/mongo-cluster/CosmosDBMongoClusterListConnectionStrings.json
func ExampleMongoClustersClient_ListConnectionStrings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMongoClustersClient().ListConnectionStrings(ctx, "TestGroup", "myMongoCluster", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListConnectionStringsResult = armcosmos.ListConnectionStringsResult{
	// 	ConnectionStrings: []*armcosmos.ConnectionString{
	// 		{
	// 			Description: to.Ptr("default connection string"),
	// 			ConnectionString: to.Ptr("mongodb+srv://<user>:<password>@myMongoCluster.mongocluster.cosmos.azure.com"),
	// 	}},
	// }
}
