//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armautomation

import "time"

// Account - Definition of the automation account type.
type Account struct {
	// Gets or sets the etag of the resource.
	Etag *string

	// Identity for the resource.
	Identity *Identity

	// The Azure Region where the resource lives
	Location *string

	// Gets or sets the automation account properties.
	Properties *AccountProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Resource system metadata.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// AccountCreateOrUpdateParameters - The parameters supplied to the create or update automation account operation.
type AccountCreateOrUpdateParameters struct {
	// Sets the identity property for automation account
	Identity *Identity

	// Gets or sets the location of the resource.
	Location *string

	// Gets or sets name of the resource.
	Name *string

	// Gets or sets account create or update properties.
	Properties *AccountCreateOrUpdateProperties

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// AccountCreateOrUpdateProperties - The parameters supplied to the create or update account properties.
type AccountCreateOrUpdateProperties struct {
	// Indicates whether requests using non-AAD authentication are blocked
	DisableLocalAuth *bool

	// Set the encryption properties for the automation account
	Encryption *EncryptionProperties

	// Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
	PublicNetworkAccess *bool

	// Gets or sets account SKU.
	SKU *SKU
}

// AccountListResult - The response model for the list account operation.
type AccountListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets list of accounts.
	Value []*Account
}

// AccountProperties - Definition of the account property.
type AccountProperties struct {
	// URL of automation hybrid service which is used for hybrid worker on-boarding.
	AutomationHybridServiceURL *string

	// Gets or sets the description.
	Description *string

	// Indicates whether requests using non-AAD authentication are blocked
	DisableLocalAuth *bool

	// Encryption properties for the automation account
	Encryption *EncryptionProperties

	// Gets or sets the last modified by.
	LastModifiedBy *string

	// List of Automation operations supported by the Automation resource provider.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
	PublicNetworkAccess *bool

	// Gets or sets the SKU of account.
	SKU *SKU

	// READ-ONLY; Gets the creation time.
	CreationTime *time.Time

	// READ-ONLY; Gets the last modified time.
	LastModifiedTime *time.Time

	// READ-ONLY; Gets status of account.
	State *AutomationAccountState
}

// AccountUpdateParameters - The parameters supplied to the update automation account operation.
type AccountUpdateParameters struct {
	// Sets the identity property for automation account
	Identity *Identity

	// Gets or sets the location of the resource.
	Location *string

	// Gets or sets the name of the resource.
	Name *string

	// Gets or sets account update properties.
	Properties *AccountUpdateProperties

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// AccountUpdateProperties - The parameters supplied to the update account properties.
type AccountUpdateProperties struct {
	// Indicates whether requests using non-AAD authentication are blocked
	DisableLocalAuth *bool

	// Set the encryption properties for the automation account
	Encryption *EncryptionProperties

	// Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
	PublicNetworkAccess *bool

	// Gets or sets account SKU.
	SKU *SKU
}

// Activity - Definition of the activity.
type Activity struct {
	// Gets or sets the id of the resource.
	ID *string

	// Gets or sets the properties of the activity.
	Properties *ActivityProperties

	// READ-ONLY; Gets the name of the activity.
	Name *string
}

// ActivityListResult - The response model for the list activity operation.
type ActivityListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of activities.
	Value []*Activity
}

// ActivityOutputType - Definition of the activity output type.
type ActivityOutputType struct {
	// Gets or sets the name of the activity output type.
	Name *string

	// Gets or sets the type of the activity output type.
	Type *string
}

// ActivityParameter - Definition of the activity parameter.
type ActivityParameter struct {
	// Gets or sets the description of the activity parameter.
	Description *string

	// Gets or sets a Boolean value that indicates true if the parameter is dynamic.
	IsDynamic *bool

	// Gets or sets a Boolean value that indicates true if the parameter is required. If the value is false, the parameter is
	// optional.
	IsMandatory *bool

	// Gets or sets the name of the activity parameter.
	Name *string

	// Gets or sets the position of the activity parameter.
	Position *int64

	// Gets or sets the type of the activity parameter.
	Type *string

	// Gets or sets the validation set of activity parameter.
	ValidationSet []*ActivityParameterValidationSet

	// Gets or sets a Boolean value that indicates true if the parameter can take values from the incoming pipeline objects. This
	// setting is used if the cmdlet must access the complete input object. false
	// indicates that the parameter cannot take values from the complete input object.
	ValueFromPipeline *bool

	// Gets or sets a Boolean value that indicates true if the parameter can be filled from a property of the incoming pipeline
	// object that has the same name as this parameter. false indicates that the
	// parameter cannot be filled from the incoming pipeline object property with the same name.
	ValueFromPipelineByPropertyName *bool

	// Gets or sets a Boolean value that indicates true if the cmdlet parameter accepts all the remaining command-line arguments
	// that are associated with this parameter in the form of an array. false if the
	// cmdlet parameter does not accept all the remaining argument values.
	ValueFromRemainingArguments *bool
}

// ActivityParameterSet - Definition of the activity parameter set.
type ActivityParameterSet struct {
	// Gets or sets the name of the activity parameter set.
	Name *string

	// Gets or sets the parameters of the activity parameter set.
	Parameters []*ActivityParameter
}

// ActivityParameterValidationSet - Definition of the activity parameter validation set.
type ActivityParameterValidationSet struct {
	// Gets or sets the name of the activity parameter validation set member.
	MemberValue *string
}

// ActivityProperties - Properties of the activity.
type ActivityProperties struct {
	// Gets or sets the creation time.
	CreationTime *time.Time

	// Gets or sets the user name of the activity.
	Definition *string

	// Gets or sets the description.
	Description *string

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// Gets or sets the output types of the activity.
	OutputTypes []*ActivityOutputType

	// Gets or sets the parameter sets of the activity.
	ParameterSets []*ActivityParameterSet
}

// AdvancedSchedule - The properties of the create Advanced Schedule.
type AdvancedSchedule struct {
	// Days of the month that the job should execute on. Must be between 1 and 31.
	MonthDays []*int32

	// Occurrences of days within a month.
	MonthlyOccurrences []*AdvancedScheduleMonthlyOccurrence

	// Days of the week that the job should execute on.
	WeekDays []*string
}

// AdvancedScheduleMonthlyOccurrence - The properties of the create advanced schedule monthly occurrence.
type AdvancedScheduleMonthlyOccurrence struct {
	// Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
	Day *ScheduleDay

	// Occurrence of the week within the month. Must be between 1 and 5
	Occurrence *int32
}

// AgentRegistration - Definition of the agent registration information type.
type AgentRegistration struct {
	// Gets or sets the dsc meta configuration.
	DscMetaConfiguration *string

	// Gets or sets the dsc server endpoint.
	Endpoint *string

	// Gets or sets the id.
	ID *string

	// Gets or sets the agent registration keys.
	Keys *AgentRegistrationKeys
}

// AgentRegistrationKeys - Definition of the agent registration keys.
type AgentRegistrationKeys struct {
	// Gets or sets the primary key.
	Primary *string

	// Gets or sets the secondary key.
	Secondary *string
}

// AgentRegistrationRegenerateKeyParameter - The parameters supplied to the regenerate keys operation.
type AgentRegistrationRegenerateKeyParameter struct {
	// REQUIRED; Gets or sets the agent registration key name - primary or secondary.
	KeyName *AgentRegistrationKeyName
}

// AzureQueryProperties - Azure query for the update configuration.
type AzureQueryProperties struct {
	// List of locations to scope the query to.
	Locations []*string

	// List of Subscription or Resource Group ARM Ids.
	Scope []*string

	// Tag settings for the VM.
	TagSettings *TagSettingsProperties
}

// Certificate - Definition of the certificate.
type Certificate struct {
	// Gets or sets the properties of the certificate.
	Properties *CertificateProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// CertificateCreateOrUpdateParameters - The parameters supplied to the create or update or replace certificate operation.
type CertificateCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the certificate.
	Name *string

	// REQUIRED; Gets or sets the properties of the certificate.
	Properties *CertificateCreateOrUpdateProperties
}

// CertificateCreateOrUpdateProperties - The properties of the create certificate operation.
type CertificateCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the base64 encoded value of the certificate.
	Base64Value *string

	// Gets or sets the description of the certificate.
	Description *string

	// Gets or sets the is exportable flag of the certificate.
	IsExportable *bool

	// Gets or sets the thumbprint of the certificate.
	Thumbprint *string
}

// CertificateListResult - The response model for the list certificate operation.
type CertificateListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of certificates.
	Value []*Certificate
}

// CertificateProperties - Properties of the certificate.
type CertificateProperties struct {
	// Gets or sets the description.
	Description *string

	// READ-ONLY; Gets the creation time.
	CreationTime *time.Time

	// READ-ONLY; Gets the expiry time of the certificate.
	ExpiryTime *time.Time

	// READ-ONLY; Gets the is exportable flag of the certificate.
	IsExportable *bool

	// READ-ONLY; Gets the last modified time.
	LastModifiedTime *time.Time

	// READ-ONLY; Gets the thumbprint of the certificate.
	Thumbprint *string
}

// CertificateUpdateParameters - The parameters supplied to the update certificate operation.
type CertificateUpdateParameters struct {
	// Gets or sets the name of the certificate.
	Name *string

	// Gets or sets the properties of the certificate.
	Properties *CertificateUpdateProperties
}

// CertificateUpdateProperties - The properties of the update certificate operation
type CertificateUpdateProperties struct {
	// Gets or sets the description of the certificate.
	Description *string
}

type ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}

// Connection - Definition of the connection.
type Connection struct {
	// Gets or sets the properties of the connection.
	Properties *ConnectionProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// ConnectionCreateOrUpdateParameters - The parameters supplied to the create or update connection operation.
type ConnectionCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the connection.
	Name *string

	// REQUIRED; Gets or sets the properties of the connection.
	Properties *ConnectionCreateOrUpdateProperties
}

// ConnectionCreateOrUpdateProperties - The properties of the create connection properties
type ConnectionCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the connectionType of the connection.
	ConnectionType *ConnectionTypeAssociationProperty

	// Gets or sets the description of the connection.
	Description *string

	// Gets or sets the field definition properties of the connection.
	FieldDefinitionValues map[string]*string
}

// ConnectionListResult - The response model for the list connection operation.
type ConnectionListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of connection.
	Value []*Connection
}

// ConnectionProperties - Definition of the connection properties.
type ConnectionProperties struct {
	// Gets or sets the connectionType of the connection.
	ConnectionType *ConnectionTypeAssociationProperty

	// Gets or sets the description.
	Description *string

	// READ-ONLY; Gets the creation time.
	CreationTime *time.Time

	// READ-ONLY; Gets the field definition values of the connection.
	FieldDefinitionValues map[string]*string

	// READ-ONLY; Gets the last modified time.
	LastModifiedTime *time.Time
}

// ConnectionType - Definition of the connection type.
type ConnectionType struct {
	// Gets or sets the properties of the connection type.
	Properties *ConnectionTypeProperties

	// READ-ONLY; Gets the id of the resource.
	ID *string

	// READ-ONLY; Gets the name of the connection type.
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ConnectionTypeAssociationProperty - The connection type property associated with the entity.
type ConnectionTypeAssociationProperty struct {
	// Gets or sets the name of the connection type.
	Name *string
}

// ConnectionTypeCreateOrUpdateParameters - The parameters supplied to the create or update connection type operation.
type ConnectionTypeCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the connection type.
	Name *string

	// REQUIRED; Gets or sets the value of the connection type.
	Properties *ConnectionTypeCreateOrUpdateProperties
}

// ConnectionTypeCreateOrUpdateProperties - The properties of the create connection type.
type ConnectionTypeCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the field definitions of the connection type.
	FieldDefinitions map[string]*FieldDefinition

	// Gets or sets a Boolean value to indicate if the connection type is global.
	IsGlobal *bool
}

// ConnectionTypeListResult - The response model for the list connection type operation.
type ConnectionTypeListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of connection types.
	Value []*ConnectionType
}

// ConnectionTypeProperties - Properties of the connection type.
type ConnectionTypeProperties struct {
	// Gets or sets the description.
	Description *string

	// Gets or sets a Boolean value to indicate if the connection type is global.
	IsGlobal *bool

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// READ-ONLY; Gets the creation time.
	CreationTime *time.Time

	// READ-ONLY; Gets the field definitions of the connection type.
	FieldDefinitions map[string]*FieldDefinition
}

// ConnectionUpdateParameters - The parameters supplied to the update connection operation.
type ConnectionUpdateParameters struct {
	// Gets or sets the name of the connection.
	Name *string

	// Gets or sets the properties of the connection.
	Properties *ConnectionUpdateProperties
}

// ConnectionUpdateProperties - The properties of the update connection operation.
type ConnectionUpdateProperties struct {
	// Gets or sets the description of the connection.
	Description *string

	// Gets or sets the field definition values of the connection.
	FieldDefinitionValues map[string]*string
}

// ContentHash - Definition of the runbook property type.
type ContentHash struct {
	// REQUIRED; Gets or sets the content hash algorithm used to hash the content.
	Algorithm *string

	// REQUIRED; Gets or sets expected hash value of the content.
	Value *string
}

// ContentLink - Definition of the content link.
type ContentLink struct {
	// Gets or sets the hash.
	ContentHash *ContentHash

	// Gets or sets the uri of the runbook content.
	URI *string

	// Gets or sets the version of the content.
	Version *string
}

// ContentSource - Definition of the content source.
type ContentSource struct {
	// Gets or sets the hash.
	Hash *ContentHash

	// Gets or sets the content source type.
	Type *ContentSourceType

	// Gets or sets the value of the content. This is based on the content source type.
	Value *string

	// Gets or sets the version of the content.
	Version *string
}

// Credential - Definition of the credential.
type Credential struct {
	// Gets or sets the properties of the credential.
	Properties *CredentialProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// CredentialCreateOrUpdateParameters - The parameters supplied to the create or update credential operation.
type CredentialCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the credential.
	Name *string

	// REQUIRED; Gets or sets the properties of the credential.
	Properties *CredentialCreateOrUpdateProperties
}

// CredentialCreateOrUpdateProperties - The properties of the create credential operation.
type CredentialCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the password of the credential.
	Password *string

	// REQUIRED; Gets or sets the user name of the credential.
	UserName *string

	// Gets or sets the description of the credential.
	Description *string
}

// CredentialListResult - The response model for the list credential operation.
type CredentialListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of credentials.
	Value []*Credential
}

// CredentialProperties - Definition of the credential properties
type CredentialProperties struct {
	// Gets or sets the description.
	Description *string

	// READ-ONLY; Gets the creation time.
	CreationTime *time.Time

	// READ-ONLY; Gets the last modified time.
	LastModifiedTime *time.Time

	// READ-ONLY; Gets the user name of the credential.
	UserName *string
}

// CredentialUpdateParameters - The parameters supplied to the Update credential operation.
type CredentialUpdateParameters struct {
	// Gets or sets the name of the credential.
	Name *string

	// Gets or sets the properties of the variable.
	Properties *CredentialUpdateProperties
}

// CredentialUpdateProperties - The properties of the Update credential
type CredentialUpdateProperties struct {
	// Gets or sets the description of the credential.
	Description *string

	// Gets or sets the password of the credential.
	Password *string

	// Gets or sets the user name of the credential.
	UserName *string
}

// DeletedAutomationAccount - Definition of the deleted automation account type.
type DeletedAutomationAccount struct {
	// The resource id.
	ID *string

	// Gets or sets the location of the resource.
	Location *string

	// Gets or sets name of the resource.
	Name *string

	// Gets or sets the automation account properties.
	Properties *DeletedAutomationAccountProperties

	// The resource type.
	Type *string
}

// DeletedAutomationAccountListResult - The response model for the list deleted automation account.
type DeletedAutomationAccountListResult struct {
	// Gets or sets the list of deleted automation accounts.
	Value []*DeletedAutomationAccount
}

// DeletedAutomationAccountProperties - Definition of the deleted automation account properties.
type DeletedAutomationAccountProperties struct {
	// Gets or sets the Automation Account Id.
	AutomationAccountID *string

	// Gets or sets the Automation Account Resource Id.
	AutomationAccountResourceID *string

	// Gets or sets the location of the resource.
	Location *string

	// READ-ONLY; Gets the deletion time.
	DeletionTime *time.Time
}

// DscCompilationJob - Definition of the Dsc Compilation job.
type DscCompilationJob struct {
	// Gets or sets the properties of the Dsc Compilation job.
	Properties *DscCompilationJobProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// DscCompilationJobCreateParameters - The parameters supplied to the create compilation job operation.
type DscCompilationJobCreateParameters struct {
	// REQUIRED; Gets or sets the list of compilation job properties.
	Properties *DscCompilationJobCreateProperties

	// Gets or sets the location of the resource.
	Location *string

	// Gets or sets name of the resource.
	Name *string

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// DscCompilationJobCreateProperties - The parameters supplied to the create compilation job operation.
type DscCompilationJobCreateProperties struct {
	// REQUIRED; Gets or sets the configuration.
	Configuration *DscConfigurationAssociationProperty

	// If a new build version of NodeConfiguration is required.
	IncrementNodeConfigurationBuild *bool

	// Gets or sets the parameters of the job.
	Parameters map[string]*string
}

// DscCompilationJobListResult - The response model for the list job operation.
type DscCompilationJobListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of Dsc Compilation jobs.
	Value []*DscCompilationJob
}

// DscCompilationJobProperties - Definition of Dsc Compilation job properties.
type DscCompilationJobProperties struct {
	// Gets or sets the configuration.
	Configuration *DscConfigurationAssociationProperty

	// Gets or sets the parameters of the job.
	Parameters map[string]*string

	// The current provisioning state of the job.
	ProvisioningState *JobProvisioningState

	// Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string

	// Gets or sets the status of the job.
	Status *JobStatus

	// Gets or sets the status details of the job.
	StatusDetails *string

	// READ-ONLY; Gets the creation time of the job.
	CreationTime *time.Time

	// READ-ONLY; Gets the end time of the job.
	EndTime *time.Time

	// READ-ONLY; Gets the exception of the job.
	Exception *string

	// READ-ONLY; Gets the id of the job.
	JobID *string

	// READ-ONLY; Gets the last modified time of the job.
	LastModifiedTime *time.Time

	// READ-ONLY; Gets the last status modified time of the job.
	LastStatusModifiedTime *time.Time

	// READ-ONLY; Gets the start time of the job.
	StartTime *time.Time

	// READ-ONLY; Gets the compilation job started by.
	StartedBy *string
}

// DscConfiguration - Definition of the configuration type.
type DscConfiguration struct {
	// Gets or sets the etag of the resource.
	Etag *string

	// The Azure Region where the resource lives
	Location *string

	// Gets or sets the configuration properties.
	Properties *DscConfigurationProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// DscConfigurationAssociationProperty - The Dsc configuration property associated with the entity.
type DscConfigurationAssociationProperty struct {
	// Gets or sets the name of the Dsc configuration.
	Name *string
}

// DscConfigurationCreateOrUpdateParameters - The parameters supplied to the create or update configuration operation.
type DscConfigurationCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets configuration create or update properties.
	Properties *DscConfigurationCreateOrUpdateProperties

	// Gets or sets the location of the resource.
	Location *string

	// Gets or sets name of the resource.
	Name *string

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// DscConfigurationCreateOrUpdateProperties - The properties to create or update configuration.
type DscConfigurationCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the source.
	Source *ContentSource

	// Gets or sets the description of the configuration.
	Description *string

	// Gets or sets progress log option.
	LogProgress *bool

	// Gets or sets verbose log option.
	LogVerbose *bool

	// Gets or sets the configuration parameters.
	Parameters map[string]*DscConfigurationParameter
}

// DscConfigurationListResult - The response model for the list configuration operation.
type DscConfigurationListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets the total number of configurations matching filter criteria.
	TotalCount *int32

	// Gets or sets a list of configurations.
	Value []*DscConfiguration
}

// DscConfigurationParameter - Definition of the configuration parameter type.
type DscConfigurationParameter struct {
	// Gets or sets the default value of parameter.
	DefaultValue *string

	// Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
	IsMandatory *bool

	// Get or sets the position of the parameter.
	Position *int32

	// Gets or sets the type of the parameter.
	Type *string
}

// DscConfigurationProperties - Definition of the configuration property type.
type DscConfigurationProperties struct {
	// Gets or sets the creation time.
	CreationTime *time.Time

	// Gets or sets the description.
	Description *string

	// Gets or sets the job count of the configuration.
	JobCount *int32

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// Gets or sets verbose log option.
	LogVerbose *bool

	// Gets the number of compiled node configurations.
	NodeConfigurationCount *int32

	// Gets or sets the configuration parameters.
	Parameters map[string]*DscConfigurationParameter

	// Gets or sets the provisioning state of the configuration.
	ProvisioningState *string

	// Gets or sets the source.
	Source *ContentSource

	// Gets or sets the state of the configuration.
	State *DscConfigurationState
}

// DscConfigurationUpdateParameters - The parameters supplied to the create or update configuration operation.
type DscConfigurationUpdateParameters struct {
	// Gets or sets name of the resource.
	Name *string

	// Gets or sets configuration create or update properties.
	Properties *DscConfigurationCreateOrUpdateProperties

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// DscMetaConfiguration - Definition of the DSC Meta Configuration.
type DscMetaConfiguration struct {
	// Gets or sets the ActionAfterReboot value of the meta configuration.
	ActionAfterReboot *string

	// Gets or sets the AllowModuleOverwrite value of the meta configuration.
	AllowModuleOverwrite *bool

	// Gets or sets the CertificateId value of the meta configuration.
	CertificateID *string

	// Gets or sets the ConfigurationMode value of the meta configuration.
	ConfigurationMode *string

	// Gets or sets the ConfigurationModeFrequencyMins value of the meta configuration.
	ConfigurationModeFrequencyMins *int32

	// Gets or sets the RebootNodeIfNeeded value of the meta configuration.
	RebootNodeIfNeeded *bool

	// Gets or sets the RefreshFrequencyMins value of the meta configuration.
	RefreshFrequencyMins *int32
}

// DscNode - Definition of a DscNode
type DscNode struct {
	// The properties of a DscNode.
	Properties *DscNodeProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// DscNodeConfiguration - Definition of the dsc node configuration.
type DscNodeConfiguration struct {
	// Gets or sets the configuration properties.
	Properties *DscNodeConfigurationProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// DscNodeConfigurationAssociationProperty - The dsc node configuration property associated with the entity.
type DscNodeConfigurationAssociationProperty struct {
	// Gets or sets the name of the dsc node configuration.
	Name *string
}

// DscNodeConfigurationCreateOrUpdateParameters - The parameters supplied to the create or update node configuration operation.
type DscNodeConfigurationCreateOrUpdateParameters struct {
	// Name of the node configuration.
	Name *string

	// Node configuration properties
	Properties *DscNodeConfigurationCreateOrUpdateParametersProperties

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// DscNodeConfigurationCreateOrUpdateParametersProperties - The parameter properties supplied to the create or update node
// configuration operation.
type DscNodeConfigurationCreateOrUpdateParametersProperties struct {
	// REQUIRED; Gets or sets the configuration of the node.
	Configuration *DscConfigurationAssociationProperty

	// REQUIRED; Gets or sets the source.
	Source *ContentSource

	// If a new build version of NodeConfiguration is required.
	IncrementNodeConfigurationBuild *bool
}

// DscNodeConfigurationListResult - The response model for the list job operation.
type DscNodeConfigurationListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets the total rows in query.
	TotalCount *int32

	// Gets or sets a list of Dsc node configurations.
	Value []*DscNodeConfiguration
}

// DscNodeConfigurationProperties - Properties for the DscNodeConfiguration
type DscNodeConfigurationProperties struct {
	// Gets or sets the configuration of the node.
	Configuration *DscConfigurationAssociationProperty

	// Gets or sets creation time.
	CreationTime *time.Time

	// If a new build version of NodeConfiguration is required.
	IncrementNodeConfigurationBuild *bool

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// Number of nodes with this node configuration assigned
	NodeCount *int64

	// Source of node configuration.
	Source *string
}

// DscNodeExtensionHandlerAssociationProperty - The dsc extensionHandler property associated with the node
type DscNodeExtensionHandlerAssociationProperty struct {
	// Gets or sets the name of the extension handler.
	Name *string

	// Gets or sets the version of the extension handler.
	Version *string
}

// DscNodeListResult - The response model for the list dsc nodes operation.
type DscNodeListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets the total number of nodes matching filter criteria.
	TotalCount *int32

	// Gets or sets a list of dsc nodes.
	Value []*DscNode
}

// DscNodeProperties - The properties of a DscNode
type DscNodeProperties struct {
	// Gets or sets the account id of the node.
	AccountID *string

	// Gets or sets the etag of the resource.
	Etag *string

	// Gets or sets the list of extensionHandler properties for a Node.
	ExtensionHandler []*DscNodeExtensionHandlerAssociationProperty

	// Gets or sets the ip of the node.
	IP *string

	// Gets or sets the last seen time of the node.
	LastSeen *time.Time

	// Gets or sets the configuration of the node.
	NodeConfiguration *DscNodeConfigurationAssociationProperty

	// Gets or sets the node id.
	NodeID *string

	// Gets or sets the registration time of the node.
	RegistrationTime *time.Time

	// Gets or sets the status of the node.
	Status *string

	// Gets the total number of records matching filter criteria.
	TotalCount *int32
}

// DscNodeReport - Definition of the dsc node report type.
type DscNodeReport struct {
	// Gets or sets the configurationVersion of the node report.
	ConfigurationVersion *string

	// Gets or sets the end time of the node report.
	EndTime *time.Time

	// Gets or sets the errors for the node report.
	Errors []*DscReportError

	// Gets or sets the hostname of the node that sent the report.
	HostName *string

	// Gets or sets the id.
	ID *string

	// Gets or sets the IPv4 address of the node that sent the report.
	IPV4Addresses []*string

	// Gets or sets the IPv6 address of the node that sent the report.
	IPV6Addresses []*string

	// Gets or sets the lastModifiedTime of the node report.
	LastModifiedTime *time.Time

	// Gets or sets the metaConfiguration of the node at the time of the report.
	MetaConfiguration *DscMetaConfiguration

	// Gets or sets the number of resource in the node report.
	NumberOfResources *int32

	// Gets or sets the unparsed errors for the node report.
	RawErrors *string

	// Gets or sets the rebootRequested of the node report.
	RebootRequested *string

	// Gets or sets the refreshMode of the node report.
	RefreshMode *string

	// Gets or sets the reportFormatVersion of the node report.
	ReportFormatVersion *string

	// Gets or sets the id of the node report.
	ReportID *string

	// Gets or sets the resource for the node report.
	Resources []*DscReportResource

	// Gets or sets the start time of the node report.
	StartTime *time.Time

	// Gets or sets the status of the node report.
	Status *string

	// Gets or sets the type of the node report.
	Type *string
}

// DscNodeReportListResult - The response model for the list dsc nodes operation.
type DscNodeReportListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of dsc node reports.
	Value []*DscNodeReport
}

// DscNodeUpdateParameters - The parameters supplied to the update dsc node operation.
type DscNodeUpdateParameters struct {
	// Gets or sets the id of the dsc node.
	NodeID     *string
	Properties *DscNodeUpdateParametersProperties
}

type DscNodeUpdateParametersProperties struct {
	// Gets or sets the configuration of the node.
	NodeConfiguration *DscNodeConfigurationAssociationProperty
}

// DscReportError - Definition of the dsc node report error type.
type DscReportError struct {
	// Gets or sets the error code.
	ErrorCode *string

	// Gets or sets the error details.
	ErrorDetails *string

	// Gets or sets the error message.
	ErrorMessage *string

	// Gets or sets the source of the error.
	ErrorSource *string

	// Gets or sets the locale of the error.
	Locale *string

	// Gets or sets the resource ID which generated the error.
	ResourceID *string
}

// DscReportResource - Definition of the DSC Report Resource.
type DscReportResource struct {
	// Gets or sets the Resource Navigation values for resources the resource depends on.
	DependsOn []*DscReportResourceNavigation

	// Gets or sets the duration in seconds for the resource.
	DurationInSeconds *float64

	// Gets or sets the error of the resource.
	Error *string

	// Gets or sets the module name of the resource.
	ModuleName *string

	// Gets or sets the module version of the resource.
	ModuleVersion *string

	// Gets or sets the ID of the resource.
	ResourceID *string

	// Gets or sets the name of the resource.
	ResourceName *string

	// Gets or sets the source info of the resource.
	SourceInfo *string

	// Gets or sets the start date of the resource.
	StartDate *time.Time

	// Gets or sets the status of the resource.
	Status *string
}

// DscReportResourceNavigation - Navigation for DSC Report Resource.
type DscReportResourceNavigation struct {
	// Gets or sets the ID of the resource to navigate to.
	ResourceID *string
}

// EncryptionProperties - The encryption settings for automation account
type EncryptionProperties struct {
	// User identity used for CMK.
	Identity *EncryptionPropertiesIdentity

	// Encryption Key Source
	KeySource *EncryptionKeySourceType

	// Key vault properties.
	KeyVaultProperties *KeyVaultProperties
}

// EncryptionPropertiesIdentity - User identity used for CMK.
type EncryptionPropertiesIdentity struct {
	// The user identity used for CMK. It will be an ARM resource id in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentity any
}

// ErrorResponse - Error response of an operation failure
type ErrorResponse struct {
	// Error code
	Code *string

	// Error message indicating why the operation failed.
	Message *string
}

// FieldDefinition - Definition of the connection fields.
type FieldDefinition struct {
	// REQUIRED; Gets or sets the type of the connection field definition.
	Type *string

	// Gets or sets the isEncrypted flag of the connection field definition.
	IsEncrypted *bool

	// Gets or sets the isOptional flag of the connection field definition.
	IsOptional *bool
}

// GraphicalRunbookContent - Graphical Runbook Content
type GraphicalRunbookContent struct {
	// Graphical Runbook content as JSON
	GraphRunbookJSON *string

	// Raw graphical Runbook content.
	RawContent *RawGraphicalRunbookContent
}

// HybridRunbookWorker - Definition of hybrid runbook worker.
type HybridRunbookWorker struct {
	// Gets or sets the hybrid worker group properties.
	Properties *HybridRunbookWorkerProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Resource system metadata.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// HybridRunbookWorkerCreateOrUpdateParameters - The parameters supplied to the create or update hybrid runbook worker operation.
type HybridRunbookWorkerCreateOrUpdateParameters struct {
	// Azure Resource Manager Id for a virtual machine.
	VMResourceID *string
}

// HybridRunbookWorkerCreateParameters - The parameters supplied to the create hybrid runbook worker operation.
type HybridRunbookWorkerCreateParameters struct {
	// REQUIRED; Gets or sets hybrid runbook worker group create or update properties.
	Properties *HybridRunbookWorkerCreateOrUpdateParameters

	// Gets or sets the name of the resource.
	Name *string
}

// HybridRunbookWorkerGroup - Definition of hybrid runbook worker group.
type HybridRunbookWorkerGroup struct {
	// Gets or sets the hybrid worker group properties.
	Properties *HybridRunbookWorkerGroupProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Resource system metadata.
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// HybridRunbookWorkerGroupCreateOrUpdateParameters - The parameters supplied to the create hybrid runbook worker group operation.
type HybridRunbookWorkerGroupCreateOrUpdateParameters struct {
	// Gets or sets the name of the resource.
	Name *string

	// Gets or sets hybrid runbook worker group create or update properties.
	Properties *HybridRunbookWorkerGroupCreateOrUpdateProperties
}

// HybridRunbookWorkerGroupCreateOrUpdateProperties - The hybrid runbook worker group properties.
type HybridRunbookWorkerGroupCreateOrUpdateProperties struct {
	// Sets the credential of a worker group.
	Credential *RunAsCredentialAssociationProperty
}

// HybridRunbookWorkerGroupProperties - Definition of hybrid runbook worker group property.
type HybridRunbookWorkerGroupProperties struct {
	// Sets the credential of a worker group.
	Credential *RunAsCredentialAssociationProperty

	// Type of the HybridWorkerGroup.
	GroupType *GroupTypeEnum
}

// HybridRunbookWorkerGroupsListResult - The response model for the list hybrid runbook worker groups.
type HybridRunbookWorkerGroupsListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of hybrid runbook worker groups.
	Value []*HybridRunbookWorkerGroup
}

// HybridRunbookWorkerMoveParameters - Parameters supplied to move hybrid worker operation.
type HybridRunbookWorkerMoveParameters struct {
	// Gets or sets the target hybrid runbook worker group.
	HybridRunbookWorkerGroupName *string
}

// HybridRunbookWorkerProperties - Definition of hybrid runbook worker property.
type HybridRunbookWorkerProperties struct {
	// Gets or sets the assigned machine IP address.
	IP *string

	// Last Heartbeat from the Worker
	LastSeenDateTime *time.Time

	// Gets or sets the registration time of the worker machine.
	RegisteredDateTime *time.Time

	// Azure Resource Manager Id for a virtual machine.
	VMResourceID *string

	// Name of the HybridWorker.
	WorkerName *string

	// Type of the HybridWorker.
	WorkerType *WorkerType
}

// HybridRunbookWorkersListResult - The response model for the list hybrid runbook workers.
type HybridRunbookWorkersListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of hybrid runbook workers.
	Value []*HybridRunbookWorker
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// Job - Definition of the job.
type Job struct {
	// The properties of the job.
	Properties *JobProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// JobCollectionItem - Job collection item properties.
type JobCollectionItem struct {
	// REQUIRED; Job properties.
	Properties *JobCollectionItemProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// JobCollectionItemProperties - Job collection item properties.
type JobCollectionItemProperties struct {
	// Specifies the runOn group name where the job was executed.
	RunOn *string

	// READ-ONLY; The creation time of the job.
	CreationTime *time.Time

	// READ-ONLY; The end time of the job.
	EndTime *time.Time

	// READ-ONLY; The id of the job.
	JobID *string

	// READ-ONLY; The last modified time of the job.
	LastModifiedTime *time.Time

	// READ-ONLY; The provisioning state of a resource.
	ProvisioningState *string

	// READ-ONLY; The runbook association.
	Runbook *RunbookAssociationProperty

	// READ-ONLY; The start time of the job.
	StartTime *time.Time

	// READ-ONLY; The status of the job.
	Status *JobStatus
}

// JobCreateParameters - The parameters supplied to the create job operation.
type JobCreateParameters struct {
	// REQUIRED; Gets or sets the list of job properties.
	Properties *JobCreateProperties
}

type JobCreateProperties struct {
	// Gets or sets the parameters of the job.
	Parameters map[string]*string

	// Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string

	// Gets or sets the runbook.
	Runbook *RunbookAssociationProperty
}

// JobListResultV2 - The response model for the list job operation.
type JobListResultV2 struct {
	// List of jobs.
	Value []*JobCollectionItem

	// READ-ONLY; The link to the next page.
	NextLink *string
}

// JobNavigation - Software update configuration machine run job navigation properties.
type JobNavigation struct {
	// READ-ONLY; Id of the job associated with the software update configuration run
	ID *string
}

// JobProperties - Definition of job properties.
type JobProperties struct {
	// Gets or sets the creation time of the job.
	CreationTime *time.Time

	// Gets or sets the end time of the job.
	EndTime *time.Time

	// Gets or sets the exception of the job.
	Exception *string

	// Gets or sets the id of the job.
	JobID *string

	// Gets or sets the last modified time of the job.
	LastModifiedTime *time.Time

	// Gets or sets the last status modified time of the job.
	LastStatusModifiedTime *time.Time

	// Gets or sets the parameters of the job.
	Parameters map[string]*string

	// The current provisioning state of the job.
	ProvisioningState *JobProvisioningState

	// Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string

	// Gets or sets the runbook.
	Runbook *RunbookAssociationProperty

	// Gets or sets the start time of the job.
	StartTime *time.Time

	// Gets or sets the job started by.
	StartedBy *string

	// Gets or sets the status of the job.
	Status *JobStatus

	// Gets or sets the status details of the job.
	StatusDetails *string
}

// JobSchedule - Definition of the job schedule.
type JobSchedule struct {
	// Gets or sets the properties of the job schedule.
	Properties *JobScheduleProperties

	// READ-ONLY; Gets the id of the resource.
	ID *string

	// READ-ONLY; Gets the name of the variable.
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// JobScheduleCreateParameters - The parameters supplied to the create job schedule operation.
type JobScheduleCreateParameters struct {
	// REQUIRED; Gets or sets the list of job schedule properties.
	Properties *JobScheduleCreateProperties
}

// JobScheduleCreateProperties - The parameters supplied to the create job schedule operation.
type JobScheduleCreateProperties struct {
	// REQUIRED; Gets or sets the runbook.
	Runbook *RunbookAssociationProperty

	// REQUIRED; Gets or sets the schedule.
	Schedule *ScheduleAssociationProperty

	// Gets or sets a list of job properties.
	Parameters map[string]*string

	// Gets or sets the hybrid worker group that the scheduled job should run on.
	RunOn *string
}

// JobScheduleListResult - The response model for the list job schedule operation.
type JobScheduleListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of job schedules.
	Value []*JobSchedule
}

// JobScheduleProperties - Definition of job schedule parameters.
type JobScheduleProperties struct {
	// Gets or sets the id of job schedule.
	JobScheduleID *string

	// Gets or sets the parameters of the job schedule.
	Parameters map[string]*string

	// Gets or sets the hybrid worker group that the scheduled job should run on.
	RunOn *string

	// Gets or sets the runbook.
	Runbook *RunbookAssociationProperty

	// Gets or sets the schedule.
	Schedule *ScheduleAssociationProperty
}

// JobStream - Definition of the job stream.
type JobStream struct {
	// Gets or sets the id of the resource.
	ID *string

	// Gets or sets the id of the job stream.
	Properties *JobStreamProperties
}

// JobStreamListResult - The response model for the list job stream operation.
type JobStreamListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// A list of job streams.
	Value []*JobStream
}

// JobStreamProperties - Definition of the job stream.
type JobStreamProperties struct {
	// Gets or sets the id of the job stream.
	JobStreamID *string

	// Gets or sets the stream text.
	StreamText *string

	// Gets or sets the stream type.
	StreamType *JobStreamType

	// Gets or sets the summary.
	Summary *string

	// Gets or sets the creation time of the job.
	Time *time.Time

	// Gets or sets the values of the job stream.
	Value map[string]any
}

// Key - Automation key which is used to register a DSC Node
type Key struct {
	// READ-ONLY; Automation key name.
	KeyName *AutomationKeyName

	// READ-ONLY; Automation key permissions.
	Permissions *AutomationKeyPermissions

	// READ-ONLY; Value of the Automation Key used for registration.
	Value *string
}

type KeyListResult struct {
	// Lists the automation keys.
	Keys []*Key
}

// KeyVaultProperties - Settings concerning key vault encryption for a configuration store.
type KeyVaultProperties struct {
	// The name of key used to encrypt data.
	KeyName *string

	// The key version of the key used to encrypt data.
	KeyVersion *string

	// The URI of the key vault key used to encrypt data.
	KeyvaultURI *string
}

// LinkedWorkspace - Definition of the linked workspace.
type LinkedWorkspace struct {
	// READ-ONLY; Gets the id of the linked workspace.
	ID *string
}

// LinuxProperties - Linux specific update configuration.
type LinuxProperties struct {
	// packages excluded from the software update configuration.
	ExcludedPackageNameMasks []*string

	// Update classifications included in the software update configuration.
	IncludedPackageClassifications *LinuxUpdateClasses

	// packages included from the software update configuration.
	IncludedPackageNameMasks []*string

	// Reboot setting for the software update configuration.
	RebootSetting *string
}

// Module - Definition of the module type.
type Module struct {
	// Gets or sets the etag of the resource.
	Etag *string

	// The Azure Region where the resource lives
	Location *string

	// Gets or sets the module properties.
	Properties *ModuleProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// ModuleCreateOrUpdateParameters - The parameters supplied to the create or update module operation.
type ModuleCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the module create properties.
	Properties *ModuleCreateOrUpdateProperties

	// Gets or sets the location of the resource.
	Location *string

	// Gets or sets name of the resource.
	Name *string

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// ModuleCreateOrUpdateProperties - The parameters supplied to the create or update module properties.
type ModuleCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the module content link.
	ContentLink *ContentLink
}

// ModuleErrorInfo - Definition of the module error info type.
type ModuleErrorInfo struct {
	// Gets or sets the error code.
	Code *string

	// Gets or sets the error message.
	Message *string
}

// ModuleListResult - The response model for the list module operation.
type ModuleListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of modules.
	Value []*Module
}

// ModuleProperties - Definition of the module property type.
type ModuleProperties struct {
	// Gets or sets the activity count of the module.
	ActivityCount *int32

	// Gets or sets the contentLink of the module.
	ContentLink *ContentLink

	// Gets or sets the creation time.
	CreationTime *time.Time

	// Gets or sets the description.
	Description *string

	// Gets or sets the error info of the module.
	Error *ModuleErrorInfo

	// Gets or sets type of module, if its composite or not.
	IsComposite *bool

	// Gets or sets the isGlobal flag of the module.
	IsGlobal *bool

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// Gets or sets the provisioning state of the module.
	ProvisioningState *ModuleProvisioningState

	// Gets or sets the size in bytes of the module.
	SizeInBytes *int64

	// Gets or sets the version of the module.
	Version *string
}

// ModuleUpdateParameters - The parameters supplied to the update module operation.
type ModuleUpdateParameters struct {
	// Gets or sets the location of the resource.
	Location *string

	// Gets or sets name of the resource.
	Name *string

	// Gets or sets the module update properties.
	Properties *ModuleUpdateProperties

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// ModuleUpdateProperties - The parameters supplied to the update properties.
type ModuleUpdateProperties struct {
	// Gets or sets the module content link.
	ContentLink *ContentLink
}

// NodeCount - Number of nodes based on the Filter
type NodeCount struct {
	// Gets the name of a count type
	Name       *string
	Properties *NodeCountProperties
}

type NodeCountProperties struct {
	// Gets the count for the name
	Count *int32
}

// NodeCounts - Gets the count of nodes by count type
type NodeCounts struct {
	// Gets the total number of records matching countType criteria.
	TotalCount *int32

	// Gets an array of counts
	Value []*NodeCount
}

// NonAzureQueryProperties - Non Azure query for the update configuration.
type NonAzureQueryProperties struct {
	// Log Analytics Saved Search name.
	FunctionAlias *string

	// Workspace Id for Log Analytics in which the saved Search is resided.
	WorkspaceID *string
}

// Operation - Automation REST API operation
type Operation struct {
	// Provider, Resource and Operation values
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - Provider, Resource and Operation values
type OperationDisplay struct {
	// Operation type: Read, write, delete, etc.
	Operation *string

	// Service provider: Microsoft.Automation
	Provider *string

	// Resource on which the operation is performed: Runbooks, Jobs etc.
	Resource *string
}

// OperationListResult - The response model for the list of Automation operations
type OperationListResult struct {
	// List of Automation operations supported by the Automation resource provider.
	Value []*Operation
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// Gets the groupIds.
	GroupIDs []*string

	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty

	// Connection State of the Private Endpoint Connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty
}

// PrivateEndpointProperty - Private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionStateProperty - Connection State of the Private Endpoint Connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// The private link service connection description.
	Description *string

	// The private link service connection status.
	Status *string

	// READ-ONLY; Any action that is required beyond basic workflow (approve/ reject/ disconnect)
	ActionsRequired *string
}

// ProxyResource - ARM proxy resource.
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// PythonPackageCreateParameters - The parameters supplied to the create or update module operation.
type PythonPackageCreateParameters struct {
	// REQUIRED; Gets or sets the module create properties.
	Properties *PythonPackageCreateProperties

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// PythonPackageCreateProperties - The parameters supplied to the create or update module properties.
type PythonPackageCreateProperties struct {
	// REQUIRED; Gets or sets the module content link.
	ContentLink *ContentLink
}

// PythonPackageUpdateParameters - The parameters supplied to the update module operation.
type PythonPackageUpdateParameters struct {
	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// RawGraphicalRunbookContent - Raw Graphical Runbook content
type RawGraphicalRunbookContent struct {
	// Serialized Graphical runbook
	RunbookDefinition *string

	// Runbook Type
	RunbookType *GraphRunbookType

	// Schema version of the serializer.
	SchemaVersion *string
}

// Resource - The core properties of ARM resources
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// RunAsCredentialAssociationProperty - Definition of RunAs credential to use for hybrid worker.
type RunAsCredentialAssociationProperty struct {
	// Gets or sets the name of the credential.
	Name *string
}

// Runbook - Definition of the runbook type.
type Runbook struct {
	// Gets or sets the etag of the resource.
	Etag *string

	// The Azure Region where the resource lives
	Location *string

	// Gets or sets the runbook properties.
	Properties *RunbookProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// RunbookAssociationProperty - The runbook property associated with the entity.
type RunbookAssociationProperty struct {
	// Gets or sets the name of the runbook.
	Name *string
}

// RunbookCreateOrUpdateDraftParameters - The parameters supplied to the create or update runbook operation.
type RunbookCreateOrUpdateDraftParameters struct {
	// REQUIRED; Content of the Runbook.
	RunbookContent *string
}

// RunbookCreateOrUpdateDraftProperties - The parameters supplied to the create or update draft runbook properties.
type RunbookCreateOrUpdateDraftProperties struct {
	// REQUIRED; Gets or sets the draft runbook properties.
	Draft *RunbookDraft

	// REQUIRED; Gets or sets the type of the runbook.
	RunbookType *RunbookTypeEnum

	// Gets or sets the description of the runbook.
	Description *string

	// Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32

	// Gets or sets progress log option.
	LogProgress *bool

	// Gets or sets verbose log option.
	LogVerbose *bool
}

// RunbookCreateOrUpdateParameters - The parameters supplied to the create or update runbook operation.
type RunbookCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets runbook create or update properties.
	Properties *RunbookCreateOrUpdateProperties

	// Gets or sets the location of the resource.
	Location *string

	// Gets or sets the name of the resource.
	Name *string

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// RunbookCreateOrUpdateProperties - The parameters supplied to the create or update runbook properties.
type RunbookCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the type of the runbook.
	RunbookType *RunbookTypeEnum

	// Gets or sets the description of the runbook.
	Description *string

	// Gets or sets the draft runbook properties.
	Draft *RunbookDraft

	// Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32

	// Gets or sets progress log option.
	LogProgress *bool

	// Gets or sets verbose log option.
	LogVerbose *bool

	// Gets or sets the published runbook content link.
	PublishContentLink *ContentLink
}

type RunbookDraft struct {
	// Gets or sets the creation time of the runbook draft.
	CreationTime *time.Time

	// Gets or sets the draft runbook content link.
	DraftContentLink *ContentLink

	// Gets or sets whether runbook is in edit mode.
	InEdit *bool

	// Gets or sets the last modified time of the runbook draft.
	LastModifiedTime *time.Time

	// Gets or sets the runbook output types.
	OutputTypes []*string

	// Gets or sets the runbook draft parameters.
	Parameters map[string]*RunbookParameter
}

// RunbookDraftUndoEditResult - The response model for the undo edit runbook operation.
type RunbookDraftUndoEditResult struct {
	RequestID  *string
	StatusCode *HTTPStatusCode
}

// RunbookListResult - The response model for the list runbook operation.
type RunbookListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of runbooks.
	Value []*Runbook
}

// RunbookParameter - Definition of the runbook parameter type.
type RunbookParameter struct {
	// Gets or sets the default value of parameter.
	DefaultValue *string

	// Gets or sets a Boolean value to indicate whether the parameter is mandatory or not.
	IsMandatory *bool

	// Get or sets the position of the parameter.
	Position *int32

	// Gets or sets the type of the parameter.
	Type *string
}

// RunbookProperties - Definition of the runbook property type.
type RunbookProperties struct {
	// Gets or sets the creation time.
	CreationTime *time.Time

	// Gets or sets the description.
	Description *string

	// Gets or sets the draft runbook properties.
	Draft *RunbookDraft

	// Gets or sets the job count of the runbook.
	JobCount *int32

	// Gets or sets the last modified by.
	LastModifiedBy *string

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// Gets or sets the option to log activity trace of the runbook.
	LogActivityTrace *int32

	// Gets or sets progress log option.
	LogProgress *bool

	// Gets or sets verbose log option.
	LogVerbose *bool

	// Gets or sets the runbook output types.
	OutputTypes []*string

	// Gets or sets the runbook parameters.
	Parameters map[string]*RunbookParameter

	// Gets or sets the provisioning state of the runbook.
	ProvisioningState *string

	// Gets or sets the published runbook content link.
	PublishContentLink *ContentLink

	// Gets or sets the type of the runbook.
	RunbookType *RunbookTypeEnum

	// Gets or sets the state of the runbook.
	State *RunbookState
}

// RunbookUpdateParameters - The parameters supplied to the update runbook operation.
type RunbookUpdateParameters struct {
	// Gets or sets the location of the resource.
	Location *string

	// Gets or sets the name of the resource.
	Name *string

	// Gets or sets the runbook update properties.
	Properties *RunbookUpdateProperties

	// Gets or sets the tags attached to the resource.
	Tags map[string]*string
}

// RunbookUpdateProperties - The parameters supplied to the update runbook properties.
type RunbookUpdateProperties struct {
	// Gets or sets the description of the runbook.
	Description *string

	// Gets or sets the activity-level tracing options of the runbook.
	LogActivityTrace *int32

	// Gets or sets progress log option.
	LogProgress *bool

	// Gets or sets verbose log option.
	LogVerbose *bool
}

// SKU - The account SKU.
type SKU struct {
	// REQUIRED; Gets or sets the SKU name of the account.
	Name *SKUNameEnum

	// Gets or sets the SKU capacity.
	Capacity *int32

	// Gets or sets the SKU family.
	Family *string
}

// SUCScheduleProperties - Definition of schedule parameters.
type SUCScheduleProperties struct {
	// Gets or sets the advanced schedule.
	AdvancedSchedule *AdvancedSchedule

	// Gets or sets the creation time.
	CreationTime *time.Time

	// Gets or sets the description.
	Description *string

	// Gets or sets the end time of the schedule.
	ExpiryTime *time.Time

	// Gets or sets the expiry time's offset in minutes.
	ExpiryTimeOffsetMinutes *float64

	// Gets or sets the frequency of the schedule.
	Frequency *ScheduleFrequency

	// Gets or sets the interval of the schedule.
	Interval *int64

	// Gets or sets a value indicating whether this schedule is enabled.
	IsEnabled *bool

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// Gets or sets the next run time of the schedule.
	NextRun *time.Time

	// Gets or sets the next run time's offset in minutes.
	NextRunOffsetMinutes *float64

	// Gets or sets the start time of the schedule.
	StartTime *time.Time

	// Gets or sets the time zone of the schedule.
	TimeZone *string

	// READ-ONLY; Gets the start time's offset in minutes.
	StartTimeOffsetMinutes *float64
}

// Schedule - Definition of the schedule.
type Schedule struct {
	// Gets or sets the properties of the schedule.
	Properties *ScheduleProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// ScheduleAssociationProperty - The schedule property associated with the entity.
type ScheduleAssociationProperty struct {
	// Gets or sets the name of the Schedule.
	Name *string
}

// ScheduleCreateOrUpdateParameters - The parameters supplied to the create or update schedule operation.
type ScheduleCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the Schedule.
	Name *string

	// REQUIRED; Gets or sets the list of schedule properties.
	Properties *ScheduleCreateOrUpdateProperties
}

// ScheduleCreateOrUpdateProperties - The parameters supplied to the create or update schedule operation.
type ScheduleCreateOrUpdateProperties struct {
	// REQUIRED; Gets or sets the frequency of the schedule.
	Frequency *ScheduleFrequency

	// REQUIRED; Gets or sets the start time of the schedule.
	StartTime *time.Time

	// Gets or sets the AdvancedSchedule.
	AdvancedSchedule *AdvancedSchedule

	// Gets or sets the description of the schedule.
	Description *string

	// Gets or sets the end time of the schedule.
	ExpiryTime *time.Time

	// Gets or sets the interval of the schedule.
	Interval any

	// Gets or sets the time zone of the schedule.
	TimeZone *string
}

// ScheduleListResult - The response model for the list schedule operation.
type ScheduleListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of schedules.
	Value []*Schedule
}

// ScheduleProperties - Definition of schedule parameters.
type ScheduleProperties struct {
	// Gets or sets the advanced schedule.
	AdvancedSchedule *AdvancedSchedule

	// Gets or sets the creation time.
	CreationTime *time.Time

	// Gets or sets the description.
	Description *string

	// Gets or sets the end time of the schedule.
	ExpiryTime *time.Time

	// Gets or sets the expiry time's offset in minutes.
	ExpiryTimeOffsetMinutes *float64

	// Gets or sets the frequency of the schedule.
	Frequency *ScheduleFrequency

	// Gets or sets the interval of the schedule.
	Interval any

	// Gets or sets a value indicating whether this schedule is enabled.
	IsEnabled *bool

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// Gets or sets the next run time of the schedule.
	NextRun *time.Time

	// Gets or sets the next run time's offset in minutes.
	NextRunOffsetMinutes *float64

	// Gets or sets the start time of the schedule.
	StartTime *time.Time

	// Gets or sets the time zone of the schedule.
	TimeZone *string

	// READ-ONLY; Gets the start time's offset in minutes.
	StartTimeOffsetMinutes *float64
}

// ScheduleUpdateParameters - The parameters supplied to the update schedule operation.
type ScheduleUpdateParameters struct {
	// Gets or sets the name of the Schedule.
	Name *string

	// Gets or sets the list of schedule properties.
	Properties *ScheduleUpdateProperties
}

// ScheduleUpdateProperties - The parameters supplied to the update schedule operation.
type ScheduleUpdateProperties struct {
	// Gets or sets the description of the schedule.
	Description *string

	// Gets or sets a value indicating whether this schedule is enabled.
	IsEnabled *bool
}

// SoftwareUpdateConfiguration - Software update configuration properties.
type SoftwareUpdateConfiguration struct {
	// REQUIRED; Software update configuration properties.
	Properties *SoftwareUpdateConfigurationProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SoftwareUpdateConfigurationCollectionItem - Software update configuration collection item properties.
type SoftwareUpdateConfigurationCollectionItem struct {
	// REQUIRED; Software update configuration properties.
	Properties *SoftwareUpdateConfigurationCollectionItemProperties

	// READ-ONLY; Resource Id of the software update configuration
	ID *string

	// READ-ONLY; Name of the software update configuration.
	Name *string
}

// SoftwareUpdateConfigurationCollectionItemProperties - Software update configuration collection item properties.
type SoftwareUpdateConfigurationCollectionItemProperties struct {
	// execution frequency of the schedule associated with the software update configuration
	Frequency *ScheduleFrequency

	// ext run time of the update.
	NextRun *time.Time

	// the start time of the update.
	StartTime *time.Time

	// Pre and Post Tasks defined
	Tasks *SoftwareUpdateConfigurationTasks

	// Update specific properties of the software update configuration.
	UpdateConfiguration *UpdateConfiguration

	// READ-ONLY; Creation time of the software update configuration, which only appears in the response.
	CreationTime *time.Time

	// READ-ONLY; Last time software update configuration was modified, which only appears in the response.
	LastModifiedTime *time.Time

	// READ-ONLY; Provisioning state for the software update configuration, which only appears in the response.
	ProvisioningState *string
}

// SoftwareUpdateConfigurationListResult - result of listing all software update configuration
type SoftwareUpdateConfigurationListResult struct {
	// outer object returned when listing all software update configurations
	Value []*SoftwareUpdateConfigurationCollectionItem
}

// SoftwareUpdateConfigurationMachineRun - Software update configuration machine run model.
type SoftwareUpdateConfigurationMachineRun struct {
	// Software update configuration machine run properties.
	Properties *UpdateConfigurationMachineRunProperties

	// READ-ONLY; Resource Id of the software update configuration machine run
	ID *string

	// READ-ONLY; Name of the software update configuration machine run
	Name *string
}

// SoftwareUpdateConfigurationMachineRunListResult - result of listing all software update configuration machine runs
type SoftwareUpdateConfigurationMachineRunListResult struct {
	// link to next page of results.
	NextLink *string

	// outer object returned when listing all software update configuration machine runs
	Value []*SoftwareUpdateConfigurationMachineRun
}

// SoftwareUpdateConfigurationProperties - Software update configuration properties.
type SoftwareUpdateConfigurationProperties struct {
	// REQUIRED; Schedule information for the Software update configuration
	ScheduleInfo *SUCScheduleProperties

	// REQUIRED; update specific properties for the Software update configuration
	UpdateConfiguration *UpdateConfiguration

	// Details of provisioning error
	Error *ErrorResponse

	// Tasks information for the Software update configuration.
	Tasks *SoftwareUpdateConfigurationTasks

	// READ-ONLY; CreatedBy property, which only appears in the response.
	CreatedBy *string

	// READ-ONLY; Creation time of the resource, which only appears in the response.
	CreationTime *time.Time

	// READ-ONLY; LastModifiedBy property, which only appears in the response.
	LastModifiedBy *string

	// READ-ONLY; Last time resource was modified, which only appears in the response.
	LastModifiedTime *time.Time

	// READ-ONLY; Provisioning state for the software update configuration, which only appears in the response.
	ProvisioningState *string
}

// SoftwareUpdateConfigurationRun - Software update configuration Run properties.
type SoftwareUpdateConfigurationRun struct {
	// Software update configuration Run properties.
	Properties *SoftwareUpdateConfigurationRunProperties

	// READ-ONLY; Resource Id of the software update configuration run
	ID *string

	// READ-ONLY; Name of the software update configuration run.
	Name *string
}

// SoftwareUpdateConfigurationRunListResult - result of listing all software update configuration runs
type SoftwareUpdateConfigurationRunListResult struct {
	// link to next page of results.
	NextLink *string

	// outer object returned when listing all software update configuration runs
	Value []*SoftwareUpdateConfigurationRun
}

// SoftwareUpdateConfigurationRunProperties - Software update configuration properties.
type SoftwareUpdateConfigurationRunProperties struct {
	// software update configuration triggered this run
	SoftwareUpdateConfiguration *UpdateConfigurationNavigation

	// Software update configuration tasks triggered in this run
	Tasks *SoftwareUpdateConfigurationRunTasks

	// READ-ONLY; Number of computers in the software update configuration run.
	ComputerCount *int32

	// READ-ONLY; Configured duration for the software update configuration run.
	ConfiguredDuration *string

	// READ-ONLY; CreatedBy property, which only appears in the response.
	CreatedBy *string

	// READ-ONLY; Creation time of the resource, which only appears in the response.
	CreationTime *time.Time

	// READ-ONLY; End time of the software update configuration run.
	EndTime *time.Time

	// READ-ONLY; Number of computers with failed status.
	FailedCount *int32

	// READ-ONLY; LastModifiedBy property, which only appears in the response.
	LastModifiedBy *string

	// READ-ONLY; Last time resource was modified, which only appears in the response.
	LastModifiedTime *time.Time

	// READ-ONLY; Operating system target of the software update configuration triggered this run
	OSType *string

	// READ-ONLY; Start time of the software update configuration run.
	StartTime *time.Time

	// READ-ONLY; Status of the software update configuration run.
	Status *string
}

// SoftwareUpdateConfigurationRunTaskProperties - Task properties of the software update configuration.
type SoftwareUpdateConfigurationRunTaskProperties struct {
	// The job id of the task.
	JobID *string

	// The name of the source of the task.
	Source *string

	// The status of the task.
	Status *string
}

// SoftwareUpdateConfigurationRunTasks - Software update configuration run tasks model.
type SoftwareUpdateConfigurationRunTasks struct {
	// Post task properties.
	PostTask *SoftwareUpdateConfigurationRunTaskProperties

	// Pre task properties.
	PreTask *SoftwareUpdateConfigurationRunTaskProperties
}

// SoftwareUpdateConfigurationTasks - Task properties of the software update configuration.
type SoftwareUpdateConfigurationTasks struct {
	// Post task properties.
	PostTask *TaskProperties

	// Pre task properties.
	PreTask *TaskProperties
}

// SourceControl - Definition of the source control.
type SourceControl struct {
	// The properties of the source control.
	Properties *SourceControlProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// SourceControlCreateOrUpdateParameters - The parameters supplied to the create or update source control operation.
type SourceControlCreateOrUpdateParameters struct {
	// REQUIRED; The properties of the source control.
	Properties *SourceControlCreateOrUpdateProperties
}

// SourceControlCreateOrUpdateProperties - The properties of the create source control operation.
type SourceControlCreateOrUpdateProperties struct {
	// The auto async of the source control. Default is false.
	AutoSync *bool

	// The repo branch of the source control. Include branch as empty string for VsoTfvc.
	Branch *string

	// The user description of the source control.
	Description *string

	// The folder path of the source control. Path must be relative.
	FolderPath *string

	// The auto publish of the source control. Default is true.
	PublishRunbook *bool

	// The repo url of the source control.
	RepoURL *string

	// The authorization token for the repo of the source control.
	SecurityToken *SourceControlSecurityTokenProperties

	// The source type. Must be one of VsoGit, VsoTfvc, GitHub, case sensitive.
	SourceType *SourceType
}

// SourceControlListResult - The response model for the list source controls operation.
type SourceControlListResult struct {
	// The next link.
	NextLink *string

	// The list of source controls.
	Value []*SourceControl
}

// SourceControlProperties - Definition of the source control properties
type SourceControlProperties struct {
	// The auto sync of the source control. Default is false.
	AutoSync *bool

	// The repo branch of the source control. Include branch as empty string for VsoTfvc.
	Branch *string

	// The creation time.
	CreationTime *time.Time

	// The description.
	Description *string

	// The folder path of the source control.
	FolderPath *string

	// The last modified time.
	LastModifiedTime *time.Time

	// The auto publish of the source control. Default is true.
	PublishRunbook *bool

	// The repo url of the source control.
	RepoURL *string

	// The source type. Must be one of VsoGit, VsoTfvc, GitHub.
	SourceType *SourceType
}

type SourceControlSecurityTokenProperties struct {
	// The access token.
	AccessToken *string

	// The refresh token.
	RefreshToken *string

	// The token type. Must be either PersonalAccessToken or Oauth.
	TokenType *TokenType
}

// SourceControlSyncJob - Definition of the source control sync job.
type SourceControlSyncJob struct {
	// The properties of the source control sync job.
	Properties *SourceControlSyncJobProperties

	// READ-ONLY; Resource id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// SourceControlSyncJobByID - Definition of the source control sync job.
type SourceControlSyncJobByID struct {
	// The id of the job.
	ID *string

	// The properties of the source control sync job.
	Properties *SourceControlSyncJobByIDProperties
}

// SourceControlSyncJobByIDProperties - Definition of source control sync job properties.
type SourceControlSyncJobByIDProperties struct {
	// The exceptions that occurred while running the sync job.
	Exception *string

	// The provisioning state of the job.
	ProvisioningState *ProvisioningState

	// The source control sync job id.
	SourceControlSyncJobID *string

	// The sync type.
	SyncType *SyncType

	// READ-ONLY; The creation time of the job.
	CreationTime *time.Time

	// READ-ONLY; The end time of the job.
	EndTime *time.Time

	// READ-ONLY; The start time of the job.
	StartTime *time.Time
}

// SourceControlSyncJobCreateParameters - The parameters supplied to the create source control sync job operation.
type SourceControlSyncJobCreateParameters struct {
	// REQUIRED; The properties of the source control sync job.
	Properties *SourceControlSyncJobCreateProperties
}

// SourceControlSyncJobCreateProperties - Definition of create source control sync job properties.
type SourceControlSyncJobCreateProperties struct {
	// REQUIRED; The commit id of the source control sync job. If not syncing to a commitId, enter an empty string.
	CommitID *string
}

// SourceControlSyncJobListResult - The response model for the list source control sync jobs operation.
type SourceControlSyncJobListResult struct {
	// The next link.
	NextLink *string

	// The list of source control sync jobs.
	Value []*SourceControlSyncJob
}

// SourceControlSyncJobProperties - Definition of source control sync job properties.
type SourceControlSyncJobProperties struct {
	// The provisioning state of the job.
	ProvisioningState *ProvisioningState

	// The source control sync job id.
	SourceControlSyncJobID *string

	// The sync type.
	SyncType *SyncType

	// READ-ONLY; The creation time of the job.
	CreationTime *time.Time

	// READ-ONLY; The end time of the job.
	EndTime *time.Time

	// READ-ONLY; The start time of the job.
	StartTime *time.Time
}

// SourceControlSyncJobStream - Definition of the source control sync job stream.
type SourceControlSyncJobStream struct {
	// The properties of the source control sync job stream.
	Properties *SourceControlSyncJobStreamProperties

	// READ-ONLY; Resource id.
	ID *string
}

// SourceControlSyncJobStreamByID - Definition of the source control sync job stream by id.
type SourceControlSyncJobStreamByID struct {
	// The properties of the source control sync job stream.
	Properties *SourceControlSyncJobStreamByIDProperties

	// READ-ONLY; Resource id.
	ID *string
}

// SourceControlSyncJobStreamByIDProperties - Definition of source control sync job stream by id properties.
type SourceControlSyncJobStreamByIDProperties struct {
	// The sync job stream id.
	SourceControlSyncJobStreamID *string

	// The text of the sync job stream.
	StreamText *string

	// The type of the sync job stream.
	StreamType *StreamType

	// The summary of the sync job stream.
	Summary *string

	// The values of the job stream.
	Value map[string]any

	// READ-ONLY; The time of the sync job stream.
	Time *time.Time
}

// SourceControlSyncJobStreamProperties - Definition of source control sync job stream properties.
type SourceControlSyncJobStreamProperties struct {
	// The sync job stream id.
	SourceControlSyncJobStreamID *string

	// The type of the sync job stream.
	StreamType *StreamType

	// The summary of the sync job stream.
	Summary *string

	// READ-ONLY; The time of the sync job stream.
	Time *time.Time
}

// SourceControlSyncJobStreamsListBySyncJob - The response model for the list source control sync job streams operation.
type SourceControlSyncJobStreamsListBySyncJob struct {
	// The list of source control sync job streams.
	Value []*SourceControlSyncJobStream

	// READ-ONLY; The next link.
	NextLink *string
}

// SourceControlUpdateParameters - The parameters supplied to the update source control operation.
type SourceControlUpdateParameters struct {
	// The value of the source control.
	Properties *SourceControlUpdateProperties
}

// SourceControlUpdateProperties - The properties of the update source control
type SourceControlUpdateProperties struct {
	// The auto sync of the source control. Default is false.
	AutoSync *bool

	// The repo branch of the source control.
	Branch *string

	// The user description of the source control.
	Description *string

	// The folder path of the source control. Path must be relative.
	FolderPath *string

	// The auto publish of the source control. Default is true.
	PublishRunbook *bool

	// The authorization token for the repo of the source control.
	SecurityToken *SourceControlSecurityTokenProperties
}

// Statistics - Definition of the statistic.
type Statistics struct {
	// READ-ONLY; Gets the property value of the statistic.
	CounterProperty *string

	// READ-ONLY; Gets the value of the statistic.
	CounterValue *int64

	// READ-ONLY; Gets the endTime of the statistic.
	EndTime *time.Time

	// READ-ONLY; Gets the id.
	ID *string

	// READ-ONLY; Gets the startTime of the statistic.
	StartTime *time.Time
}

// StatisticsListResult - The response model for the list statistics operation.
type StatisticsListResult struct {
	// Gets or sets a list of statistics.
	Value []*Statistics
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagSettingsProperties - Tag filter information for the VM.
type TagSettingsProperties struct {
	// Filter VMs by Any or All specified tags.
	FilterOperator *TagOperators

	// Dictionary of tags with its list of values.
	Tags map[string][]*string
}

// TargetProperties - Group specific to the update configuration.
type TargetProperties struct {
	// List of Azure queries in the software update configuration.
	AzureQueries []*AzureQueryProperties

	// List of non Azure queries in the software update configuration.
	NonAzureQueries []*NonAzureQueryProperties
}

// TaskProperties - Task properties of the software update configuration.
type TaskProperties struct {
	// Gets or sets the parameters of the task.
	Parameters map[string]*string

	// Gets or sets the name of the runbook.
	Source *string
}

// TestJob - Definition of the test job.
type TestJob struct {
	// Gets or sets the creation time of the test job.
	CreationTime *time.Time

	// Gets or sets the end time of the test job.
	EndTime *time.Time

	// Gets or sets the exception of the test job.
	Exception *string

	// Gets or sets the last modified time of the test job.
	LastModifiedTime *time.Time

	// Gets or sets the last status modified time of the test job.
	LastStatusModifiedTime *time.Time

	// The activity-level tracing options of the runbook.
	LogActivityTrace *int32

	// Gets or sets the parameters of the test job.
	Parameters map[string]*string

	// Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string

	// Gets or sets the start time of the test job.
	StartTime *time.Time

	// Gets or sets the status of the test job.
	Status *string

	// Gets or sets the status details of the test job.
	StatusDetails *string
}

// TestJobCreateParameters - The parameters supplied to the create test job operation.
type TestJobCreateParameters struct {
	// Gets or sets the parameters of the test job.
	Parameters map[string]*string

	// Gets or sets the runOn which specifies the group name where the job is to be executed.
	RunOn *string
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// The Azure Region where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// TypeField - Information about a field of a type.
type TypeField struct {
	// Gets or sets the name of the field.
	Name *string

	// Gets or sets the type of the field.
	Type *string
}

// TypeFieldListResult - The response model for the list fields operation.
type TypeFieldListResult struct {
	// Gets or sets a list of fields.
	Value []*TypeField
}

// UpdateConfiguration - Update specific properties of the software update configuration.
type UpdateConfiguration struct {
	// REQUIRED; operating system of target machines
	OperatingSystem *OperatingSystemType

	// List of azure resource Ids for azure virtual machines targeted by the software update configuration.
	AzureVirtualMachines []*string

	// Maximum time allowed for the software update configuration run. Duration needs to be specified using the format PT[n]H[n]M[n]S
	// as per ISO8601
	Duration *string

	// Linux specific update configuration.
	Linux *LinuxProperties

	// List of names of non-azure machines targeted by the software update configuration.
	NonAzureComputerNames []*string

	// Group targets for the software update configuration.
	Targets *TargetProperties

	// Windows specific update configuration.
	Windows *WindowsProperties
}

// UpdateConfigurationMachineRunProperties - Software update configuration machine run properties.
type UpdateConfigurationMachineRunProperties struct {
	// Details of provisioning error
	Error *ErrorResponse

	// Job associated with the software update configuration machine run
	Job *JobNavigation

	// software update configuration triggered this run
	SoftwareUpdateConfiguration *UpdateConfigurationNavigation

	// READ-ONLY; configured duration for the software update configuration run.
	ConfiguredDuration *string

	// READ-ONLY; correlation id of the software update configuration machine run
	CorrelationID *string

	// READ-ONLY; createdBy property, which only appears in the response.
	CreatedBy *string

	// READ-ONLY; Creation time of the resource, which only appears in the response.
	CreationTime *time.Time

	// READ-ONLY; End time of the software update configuration machine run.
	EndTime *time.Time

	// READ-ONLY; lastModifiedBy property, which only appears in the response.
	LastModifiedBy *string

	// READ-ONLY; Last time resource was modified, which only appears in the response.
	LastModifiedTime *time.Time

	// READ-ONLY; Operating system target of the software update configuration triggered this run
	OSType *string

	// READ-ONLY; source computer id of the software update configuration machine run
	SourceComputerID *string

	// READ-ONLY; Start time of the software update configuration machine run.
	StartTime *time.Time

	// READ-ONLY; Status of the software update configuration machine run.
	Status *string

	// READ-ONLY; name of the updated computer
	TargetComputer *string

	// READ-ONLY; type of the updated computer.
	TargetComputerType *string
}

// UpdateConfigurationNavigation - Software update configuration Run Navigation model.
type UpdateConfigurationNavigation struct {
	// READ-ONLY; Name of the software update configuration triggered the software update configuration run
	Name *string
}

// Usage - Definition of Usage.
type Usage struct {
	// Gets or sets the current usage value.
	CurrentValue *float64

	// Gets or sets the id of the resource.
	ID *string

	// Gets or sets max limit. -1 for unlimited
	Limit *int64

	// Gets or sets the usage counter name.
	Name *UsageCounterName

	// Gets or sets the throttle status.
	ThrottleStatus *string

	// Gets or sets the usage unit name.
	Unit *string
}

// UsageCounterName - Definition of usage counter name.
type UsageCounterName struct {
	// Gets or sets the localized usage counter name.
	LocalizedValue *string

	// Gets or sets the usage counter name.
	Value *string
}

// UsageListResult - The response model for the get usage operation.
type UsageListResult struct {
	// Gets or sets usage.
	Value []*Usage
}

// Variable - Definition of the variable.
type Variable struct {
	// Gets or sets the properties of the variable.
	Properties *VariableProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// VariableCreateOrUpdateParameters - The parameters supplied to the create or update variable operation.
type VariableCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the variable.
	Name *string

	// REQUIRED; Gets or sets the properties of the variable.
	Properties *VariableCreateOrUpdateProperties
}

// VariableCreateOrUpdateProperties - The properties of the create variable operation.
type VariableCreateOrUpdateProperties struct {
	// Gets or sets the description of the variable.
	Description *string

	// Gets or sets the encrypted flag of the variable.
	IsEncrypted *bool

	// Gets or sets the value of the variable.
	Value *string
}

// VariableListResult - The response model for the list variables operation.
type VariableListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of variables.
	Value []*Variable
}

// VariableProperties - Definition of the variable properties
type VariableProperties struct {
	// Gets or sets the creation time.
	CreationTime *time.Time

	// Gets or sets the description.
	Description *string

	// Gets or sets the encrypted flag of the variable.
	IsEncrypted *bool

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// Gets or sets the value of the variable.
	Value *string
}

// VariableUpdateParameters - The parameters supplied to the update variable operation.
type VariableUpdateParameters struct {
	// Gets or sets the name of the variable.
	Name *string

	// Gets or sets the value of the variable.
	Properties *VariableUpdateProperties
}

// VariableUpdateProperties - The properties of the update variable
type VariableUpdateProperties struct {
	// Gets or sets the description of the variable.
	Description *string

	// Gets or sets the value of the variable.
	Value *string
}

// Watcher - Definition of the watcher type.
type Watcher struct {
	// Gets or sets the etag of the resource.
	Etag *string

	// The geo-location where the resource lives
	Location *string

	// Gets or sets the watcher properties.
	Properties *WatcherProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// WatcherListResult - The response model for the list watcher operation.
type WatcherListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of watchers.
	Value []*Watcher
}

// WatcherProperties - Definition of the watcher properties
type WatcherProperties struct {
	// Gets or sets the description.
	Description *string

	// Gets or sets the frequency at which the watcher is invoked.
	ExecutionFrequencyInSeconds *int64

	// Gets or sets the name of the script the watcher is attached to, i.e. the name of an existing runbook.
	ScriptName *string

	// Gets or sets the parameters of the script.
	ScriptParameters map[string]*string

	// Gets or sets the name of the hybrid worker group the watcher will run on.
	ScriptRunOn *string

	// READ-ONLY; Gets or sets the creation time.
	CreationTime *time.Time

	// READ-ONLY; Details of the user who last modified the watcher.
	LastModifiedBy *string

	// READ-ONLY; Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// READ-ONLY; Gets the current status of the watcher.
	Status *string
}

type WatcherUpdateParameters struct {
	// Gets or sets the name of the resource.
	Name *string

	// Gets or sets the watcher update properties.
	Properties *WatcherUpdateProperties
}

// WatcherUpdateProperties - The properties of the update watcher operation.
type WatcherUpdateProperties struct {
	// Gets or sets the frequency at which the watcher is invoked.
	ExecutionFrequencyInSeconds *int64
}

// Webhook - Definition of the webhook type.
type Webhook struct {
	// Gets or sets the webhook properties.
	Properties *WebhookProperties

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource.
	Type *string
}

// WebhookCreateOrUpdateParameters - The parameters supplied to the create or update webhook operation.
type WebhookCreateOrUpdateParameters struct {
	// REQUIRED; Gets or sets the name of the webhook.
	Name *string

	// REQUIRED; Gets or sets the properties of the webhook.
	Properties *WebhookCreateOrUpdateProperties
}

// WebhookCreateOrUpdateProperties - The properties of the create webhook operation.
type WebhookCreateOrUpdateProperties struct {
	// Gets or sets the expiry time.
	ExpiryTime *time.Time

	// Gets or sets the value of the enabled flag of webhook.
	IsEnabled *bool

	// Gets or sets the parameters of the job.
	Parameters map[string]*string

	// Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string

	// Gets or sets the runbook.
	Runbook *RunbookAssociationProperty

	// Gets or sets the uri.
	URI *string
}

// WebhookListResult - The response model for the list webhook operation.
type WebhookListResult struct {
	// Gets or sets the next link.
	NextLink *string

	// Gets or sets a list of webhooks.
	Value []*Webhook
}

// WebhookProperties - Definition of the webhook properties
type WebhookProperties struct {
	// Gets or sets the creation time.
	CreationTime *time.Time

	// Gets or sets the description.
	Description *string

	// Gets or sets the expiry time.
	ExpiryTime *time.Time

	// Gets or sets the value of the enabled flag of the webhook.
	IsEnabled *bool

	// Gets or sets the last invoked time.
	LastInvokedTime *time.Time

	// Details of the user who last modified the Webhook
	LastModifiedBy *string

	// Gets or sets the last modified time.
	LastModifiedTime *time.Time

	// Gets or sets the parameters of the job that is created when the webhook calls the runbook it is associated with.
	Parameters map[string]*string

	// Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string

	// Gets or sets the runbook the webhook is associated with.
	Runbook *RunbookAssociationProperty

	// Gets or sets the webhook uri.
	URI *string
}

// WebhookUpdateParameters - The parameters supplied to the update webhook operation.
type WebhookUpdateParameters struct {
	// Gets or sets the name of the webhook.
	Name *string

	// Gets or sets the value of the webhook.
	Properties *WebhookUpdateProperties
}

// WebhookUpdateProperties - The properties of the update webhook.
type WebhookUpdateProperties struct {
	// Gets or sets the description of the webhook.
	Description *string

	// Gets or sets the value of the enabled flag of webhook.
	IsEnabled *bool

	// Gets or sets the parameters of the job.
	Parameters map[string]*string

	// Gets or sets the name of the hybrid worker group the webhook job will run on.
	RunOn *string
}

// WindowsProperties - Windows specific update configuration.
type WindowsProperties struct {
	// KB numbers excluded from the software update configuration.
	ExcludedKbNumbers []*string

	// KB numbers included from the software update configuration.
	IncludedKbNumbers []*string

	// Update classification included in the software update configuration. A comma separated string with required values
	IncludedUpdateClassifications *WindowsUpdateClasses

	// Reboot setting for the software update configuration.
	RebootSetting *string
}
