//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azopenai

import (
	"context"
	"io"
	"net/http"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// Client contains the methods for the OpenAI group.
// Don't use this type directly, use a constructor function instead.
type Client struct {
	internal *azcore.Client
	clientData
}

// GenerateSpeechFromText - Generates text-to-speech audio from the input text.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01-preview
//   - options - GenerateSpeechFromTextOptions contains the optional parameters for the Client.GenerateSpeechFromText method.
func (client *Client) GenerateSpeechFromText(ctx context.Context, body SpeechGenerationOptions, options *GenerateSpeechFromTextOptions) (GenerateSpeechFromTextResponse, error) {
	var err error
	req, err := client.generateSpeechFromTextCreateRequest(ctx, body, options)
	if err != nil {
		return GenerateSpeechFromTextResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GenerateSpeechFromTextResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = client.newError(httpResp)
		return GenerateSpeechFromTextResponse{}, err
	}
	return GenerateSpeechFromTextResponse{Body: httpResp.Body}, nil
}

// generateSpeechFromTextCreateRequest creates the GenerateSpeechFromText request.
func (client *Client) generateSpeechFromTextCreateRequest(ctx context.Context, body SpeechGenerationOptions, options *GenerateSpeechFromTextOptions) (*policy.Request, error) {
	urlPath := "audio/speech"
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.formatURL(urlPath, getDeployment(body)))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	req.Raw().Header["Accept"] = []string{"application/octet-stream, application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// getAudioTranscriptionInternal - Gets transcribed text and associated metadata from provided spoken audio data. Audio will
// be transcribed in the written language corresponding to the language it was spoken in.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01-preview
//   - deploymentID - Specifies either the model deployment name (when using Azure OpenAI) or model name (when using non-Azure
//     OpenAI) to use for this request.
//   - file - The audio data to transcribe. This must be the binary content of a file in one of the supported media formats: flac,
//     mp3, mp4, mpeg, mpga, m4a, ogg, wav, webm.
//   - options - getAudioTranscriptionInternalOptions contains the optional parameters for the Client.getAudioTranscriptionInternal
//     method.
func (client *Client) getAudioTranscriptionInternal(ctx context.Context, file io.ReadSeekCloser, options *getAudioTranscriptionInternalOptions) (getAudioTranscriptionInternalResponse, error) {
	var err error
	req, err := client.getAudioTranscriptionInternalCreateRequest(ctx, file, options)
	if err != nil {
		return getAudioTranscriptionInternalResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return getAudioTranscriptionInternalResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = client.newError(httpResp)
		return getAudioTranscriptionInternalResponse{}, err
	}
	resp, err := getAudioTranscriptionInternalHandleResponse(httpResp)
	return resp, err
}

// getAudioTranscriptionInternalCreateRequest creates the getAudioTranscriptionInternal request.
func (client *Client) getAudioTranscriptionInternalCreateRequest(ctx context.Context, file io.ReadSeekCloser, body *getAudioTranscriptionInternalOptions) (*policy.Request, error) {
	urlPath := "audio/transcriptions"
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.formatURL(urlPath, getDeployment(body)))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := setMultipartFormData(req, file, *body); err != nil {
		return nil, err
	}
	return req, nil
}

// getAudioTranscriptionInternalHandleResponse handles the getAudioTranscriptionInternal response.
func (client *Client) getAudioTranscriptionInternalHandleResponse(resp *http.Response) (getAudioTranscriptionInternalResponse, error) {
	result := getAudioTranscriptionInternalResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AudioTranscription); err != nil {
		return getAudioTranscriptionInternalResponse{}, err
	}
	return result, nil
}

// getAudioTranslationInternal - Gets English language transcribed text and associated metadata from provided spoken audio
// data.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01-preview
//   - deploymentID - Specifies either the model deployment name (when using Azure OpenAI) or model name (when using non-Azure
//     OpenAI) to use for this request.
//   - file - The audio data to translate. This must be the binary content of a file in one of the supported media formats: flac,
//     mp3, mp4, mpeg, mpga, m4a, ogg, wav, webm.
//   - options - getAudioTranslationInternalOptions contains the optional parameters for the Client.getAudioTranslationInternal
//     method.
func (client *Client) getAudioTranslationInternal(ctx context.Context, file io.ReadSeekCloser, options *getAudioTranslationInternalOptions) (getAudioTranslationInternalResponse, error) {
	var err error
	req, err := client.getAudioTranslationInternalCreateRequest(ctx, file, options)
	if err != nil {
		return getAudioTranslationInternalResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return getAudioTranslationInternalResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = client.newError(httpResp)
		return getAudioTranslationInternalResponse{}, err
	}
	resp, err := getAudioTranslationInternalHandleResponse(httpResp)
	return resp, err
}

// getAudioTranslationInternalCreateRequest creates the getAudioTranslationInternal request.
func (client *Client) getAudioTranslationInternalCreateRequest(ctx context.Context, file io.ReadSeekCloser, body *getAudioTranslationInternalOptions) (*policy.Request, error) {
	urlPath := "audio/translations"
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.formatURL(urlPath, getDeployment(body)))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := setMultipartFormData(req, file, *body); err != nil {
		return nil, err
	}
	return req, nil
}

// getAudioTranslationInternalHandleResponse handles the getAudioTranslationInternal response.
func (client *Client) getAudioTranslationInternalHandleResponse(resp *http.Response) (getAudioTranslationInternalResponse, error) {
	result := getAudioTranslationInternalResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AudioTranslation); err != nil {
		return getAudioTranslationInternalResponse{}, err
	}
	return result, nil
}

// GetChatCompletions - Gets chat completions for the provided chat messages. Completions support a wide variety of tasks
// and generate text that continues from or "completes" provided prompt data.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01-preview
//   - options - GetChatCompletionsOptions contains the optional parameters for the Client.GetChatCompletions method.
func (client *Client) GetChatCompletions(ctx context.Context, body ChatCompletionsOptions, options *GetChatCompletionsOptions) (GetChatCompletionsResponse, error) {
	var err error
	req, err := client.getChatCompletionsCreateRequest(ctx, body, options)
	if err != nil {
		return GetChatCompletionsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetChatCompletionsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = client.newError(httpResp)
		return GetChatCompletionsResponse{}, err
	}
	resp, err := client.getChatCompletionsHandleResponse(httpResp)
	return resp, err
}

// getChatCompletionsCreateRequest creates the GetChatCompletions request.
func (client *Client) getChatCompletionsCreateRequest(ctx context.Context, body ChatCompletionsOptions, options *GetChatCompletionsOptions) (*policy.Request, error) {
	urlPath := "chat/completions"
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.formatURL(urlPath, getDeployment(body)))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// getChatCompletionsHandleResponse handles the GetChatCompletions response.
func (client *Client) getChatCompletionsHandleResponse(resp *http.Response) (GetChatCompletionsResponse, error) {
	result := GetChatCompletionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ChatCompletions); err != nil {
		return GetChatCompletionsResponse{}, err
	}
	return result, nil
}

// GetCompletions - Gets completions for the provided input prompts. Completions support a wide variety of tasks and generate
// text that continues from or "completes" provided prompt data.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01-preview
//   - options - GetCompletionsOptions contains the optional parameters for the Client.GetCompletions method.
func (client *Client) GetCompletions(ctx context.Context, body CompletionsOptions, options *GetCompletionsOptions) (GetCompletionsResponse, error) {
	var err error
	req, err := client.getCompletionsCreateRequest(ctx, body, options)
	if err != nil {
		return GetCompletionsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetCompletionsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = client.newError(httpResp)
		return GetCompletionsResponse{}, err
	}
	resp, err := client.getCompletionsHandleResponse(httpResp)
	return resp, err
}

// getCompletionsCreateRequest creates the GetCompletions request.
func (client *Client) getCompletionsCreateRequest(ctx context.Context, body CompletionsOptions, options *GetCompletionsOptions) (*policy.Request, error) {
	urlPath := "completions"
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.formatURL(urlPath, getDeployment(body)))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// getCompletionsHandleResponse handles the GetCompletions response.
func (client *Client) getCompletionsHandleResponse(resp *http.Response) (GetCompletionsResponse, error) {
	result := GetCompletionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Completions); err != nil {
		return GetCompletionsResponse{}, err
	}
	return result, nil
}

// GetEmbeddings - Return the embeddings for a given prompt.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01-preview
//   - options - GetEmbeddingsOptions contains the optional parameters for the Client.GetEmbeddings method.
func (client *Client) GetEmbeddings(ctx context.Context, body EmbeddingsOptions, options *GetEmbeddingsOptions) (GetEmbeddingsResponse, error) {
	var err error
	req, err := client.getEmbeddingsCreateRequest(ctx, body, options)
	if err != nil {
		return GetEmbeddingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetEmbeddingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = client.newError(httpResp)
		return GetEmbeddingsResponse{}, err
	}
	resp, err := client.getEmbeddingsHandleResponse(httpResp)
	return resp, err
}

// getEmbeddingsCreateRequest creates the GetEmbeddings request.
func (client *Client) getEmbeddingsCreateRequest(ctx context.Context, body EmbeddingsOptions, options *GetEmbeddingsOptions) (*policy.Request, error) {
	urlPath := "embeddings"
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.formatURL(urlPath, getDeployment(body)))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// getEmbeddingsHandleResponse handles the GetEmbeddings response.
func (client *Client) getEmbeddingsHandleResponse(resp *http.Response) (GetEmbeddingsResponse, error) {
	result := GetEmbeddingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Embeddings); err != nil {
		return GetEmbeddingsResponse{}, err
	}
	return result, nil
}

// GetImageGenerations - Creates an image given a prompt.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-04-01-preview
//   - options - GetImageGenerationsOptions contains the optional parameters for the Client.GetImageGenerations method.
func (client *Client) GetImageGenerations(ctx context.Context, body ImageGenerationOptions, options *GetImageGenerationsOptions) (GetImageGenerationsResponse, error) {
	var err error
	req, err := client.getImageGenerationsCreateRequest(ctx, body, options)
	if err != nil {
		return GetImageGenerationsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetImageGenerationsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = client.newError(httpResp)
		return GetImageGenerationsResponse{}, err
	}
	resp, err := client.getImageGenerationsHandleResponse(httpResp)
	return resp, err
}

// getImageGenerationsCreateRequest creates the GetImageGenerations request.
func (client *Client) getImageGenerationsCreateRequest(ctx context.Context, body ImageGenerationOptions, options *GetImageGenerationsOptions) (*policy.Request, error) {
	urlPath := "images/generations"
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.formatURL(urlPath, getDeployment(body)))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-04-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// getImageGenerationsHandleResponse handles the GetImageGenerations response.
func (client *Client) getImageGenerationsHandleResponse(resp *http.Response) (GetImageGenerationsResponse, error) {
	result := GetImageGenerationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ImageGenerations); err != nil {
		return GetImageGenerationsResponse{}, err
	}
	return result, nil
}
