//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AddressSpace.
func (a AddressSpace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefixes", a.AddressPrefixes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressSpace.
func (a *AddressSpace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefixes":
			err = unpopulate(val, "AddressPrefixes", &a.AddressPrefixes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendAddress.
func (a ApplicationGatewayBackendAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fqdn", a.Fqdn)
	populate(objectMap, "ipAddress", a.IPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendAddress.
func (a *ApplicationGatewayBackendAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fqdn":
			err = unpopulate(val, "Fqdn", &a.Fqdn)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &a.IPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendAddressPool.
func (a ApplicationGatewayBackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendAddressPool.
func (a *ApplicationGatewayBackendAddressPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationGatewayBackendAddressPoolPropertiesFormat.
func (a ApplicationGatewayBackendAddressPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddresses", a.BackendAddresses)
	populate(objectMap, "backendIPConfigurations", a.BackendIPConfigurations)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationGatewayBackendAddressPoolPropertiesFormat.
func (a *ApplicationGatewayBackendAddressPoolPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddresses":
			err = unpopulate(val, "BackendAddresses", &a.BackendAddresses)
			delete(rawMsg, key)
		case "backendIPConfigurations":
			err = unpopulate(val, "BackendIPConfigurations", &a.BackendIPConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationSecurityGroup.
func (a ApplicationSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationSecurityGroup.
func (a *ApplicationSecurityGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicationSecurityGroupPropertiesFormat.
func (a ApplicationSecurityGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "resourceGuid", a.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicationSecurityGroupPropertiesFormat.
func (a *ApplicationSecurityGroupPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &a.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Availability.
func (a Availability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", a.BlobDuration)
	populate(objectMap, "retention", a.Retention)
	populate(objectMap, "timeGrain", a.TimeGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Availability.
func (a *Availability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &a.BlobDuration)
			delete(rawMsg, key)
		case "retention":
			err = unpopulate(val, "Retention", &a.Retention)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &a.TimeGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureAsyncOperationResult.
func (a AzureAsyncOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureAsyncOperationResult.
func (a *AzureAsyncOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendAddressPool.
func (b BackendAddressPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendAddressPool.
func (b *BackendAddressPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackendAddressPoolPropertiesFormat.
func (b BackendAddressPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendIPConfigurations", b.BackendIPConfigurations)
	populate(objectMap, "loadBalancingRules", b.LoadBalancingRules)
	populate(objectMap, "outboundRule", b.OutboundRule)
	populate(objectMap, "outboundRules", b.OutboundRules)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackendAddressPoolPropertiesFormat.
func (b *BackendAddressPoolPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendIPConfigurations":
			err = unpopulate(val, "BackendIPConfigurations", &b.BackendIPConfigurations)
			delete(rawMsg, key)
		case "loadBalancingRules":
			err = unpopulate(val, "LoadBalancingRules", &b.LoadBalancingRules)
			delete(rawMsg, key)
		case "outboundRule":
			err = unpopulate(val, "OutboundRule", &b.OutboundRule)
			delete(rawMsg, key)
		case "outboundRules":
			err = unpopulate(val, "OutboundRules", &b.OutboundRules)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpPeerStatus.
func (b BgpPeerStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asn", b.Asn)
	populate(objectMap, "connectedDuration", b.ConnectedDuration)
	populate(objectMap, "localAddress", b.LocalAddress)
	populate(objectMap, "messagesReceived", b.MessagesReceived)
	populate(objectMap, "messagesSent", b.MessagesSent)
	populate(objectMap, "neighbor", b.Neighbor)
	populate(objectMap, "routesReceived", b.RoutesReceived)
	populate(objectMap, "state", b.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpPeerStatus.
func (b *BgpPeerStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asn":
			err = unpopulate(val, "Asn", &b.Asn)
			delete(rawMsg, key)
		case "connectedDuration":
			err = unpopulate(val, "ConnectedDuration", &b.ConnectedDuration)
			delete(rawMsg, key)
		case "localAddress":
			err = unpopulate(val, "LocalAddress", &b.LocalAddress)
			delete(rawMsg, key)
		case "messagesReceived":
			err = unpopulate(val, "MessagesReceived", &b.MessagesReceived)
			delete(rawMsg, key)
		case "messagesSent":
			err = unpopulate(val, "MessagesSent", &b.MessagesSent)
			delete(rawMsg, key)
		case "neighbor":
			err = unpopulate(val, "Neighbor", &b.Neighbor)
			delete(rawMsg, key)
		case "routesReceived":
			err = unpopulate(val, "RoutesReceived", &b.RoutesReceived)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &b.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpPeerStatusListResult.
func (b BgpPeerStatusListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpPeerStatusListResult.
func (b *BgpPeerStatusListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BgpSettings.
func (b BgpSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asn", b.Asn)
	populate(objectMap, "bgpPeeringAddress", b.BgpPeeringAddress)
	populate(objectMap, "peerWeight", b.PeerWeight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BgpSettings.
func (b *BgpSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asn":
			err = unpopulate(val, "Asn", &b.Asn)
			delete(rawMsg, key)
		case "bgpPeeringAddress":
			err = unpopulate(val, "BgpPeeringAddress", &b.BgpPeeringAddress)
			delete(rawMsg, key)
		case "peerWeight":
			err = unpopulate(val, "PeerWeight", &b.PeerWeight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.
func (c Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", c.ClientID)
	populate(objectMap, "principalId", c.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.
func (c *Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &c.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionResetSharedKey.
func (c ConnectionResetSharedKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyLength", c.KeyLength)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionResetSharedKey.
func (c *ConnectionResetSharedKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyLength":
			err = unpopulate(val, "KeyLength", &c.KeyLength)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionSharedKey.
func (c ConnectionSharedKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionSharedKey.
func (c *ConnectionSharedKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DdosSettings.
func (d DdosSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ddosCustomPolicy", d.DdosCustomPolicy)
	populate(objectMap, "protectionCoverage", d.ProtectionCoverage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DdosSettings.
func (d *DdosSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ddosCustomPolicy":
			err = unpopulate(val, "DdosCustomPolicy", &d.DdosCustomPolicy)
			delete(rawMsg, key)
		case "protectionCoverage":
			err = unpopulate(val, "ProtectionCoverage", &d.ProtectionCoverage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Delegation.
func (d Delegation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Delegation.
func (d *Delegation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DhcpOptions.
func (d DhcpOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServers", d.DNSServers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DhcpOptions.
func (d *DhcpOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &d.DNSServers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "internalName", d.InternalName)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dimension.
func (d *Dimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "internalName":
			err = unpopulate(val, "InternalName", &d.InternalName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveNetworkSecurityGroup.
func (e EffectiveNetworkSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "association", e.Association)
	populate(objectMap, "effectiveSecurityRules", e.EffectiveSecurityRules)
	populate(objectMap, "networkSecurityGroup", e.NetworkSecurityGroup)
	populate(objectMap, "tagMap", e.TagMap)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveNetworkSecurityGroup.
func (e *EffectiveNetworkSecurityGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "association":
			err = unpopulate(val, "Association", &e.Association)
			delete(rawMsg, key)
		case "effectiveSecurityRules":
			err = unpopulate(val, "EffectiveSecurityRules", &e.EffectiveSecurityRules)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &e.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "tagMap":
			err = unpopulate(val, "TagMap", &e.TagMap)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveNetworkSecurityGroupAssociation.
func (e EffectiveNetworkSecurityGroupAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkInterface", e.NetworkInterface)
	populate(objectMap, "subnet", e.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveNetworkSecurityGroupAssociation.
func (e *EffectiveNetworkSecurityGroupAssociation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterface":
			err = unpopulate(val, "NetworkInterface", &e.NetworkInterface)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &e.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveNetworkSecurityGroupListResult.
func (e EffectiveNetworkSecurityGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveNetworkSecurityGroupListResult.
func (e *EffectiveNetworkSecurityGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveNetworkSecurityRule.
func (e EffectiveNetworkSecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", e.Access)
	populate(objectMap, "destinationAddressPrefix", e.DestinationAddressPrefix)
	populate(objectMap, "destinationAddressPrefixes", e.DestinationAddressPrefixes)
	populate(objectMap, "destinationPortRange", e.DestinationPortRange)
	populate(objectMap, "destinationPortRanges", e.DestinationPortRanges)
	populate(objectMap, "direction", e.Direction)
	populate(objectMap, "expandedDestinationAddressPrefix", e.ExpandedDestinationAddressPrefix)
	populate(objectMap, "expandedSourceAddressPrefix", e.ExpandedSourceAddressPrefix)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "priority", e.Priority)
	populate(objectMap, "protocol", e.Protocol)
	populate(objectMap, "sourceAddressPrefix", e.SourceAddressPrefix)
	populate(objectMap, "sourceAddressPrefixes", e.SourceAddressPrefixes)
	populate(objectMap, "sourcePortRange", e.SourcePortRange)
	populate(objectMap, "sourcePortRanges", e.SourcePortRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveNetworkSecurityRule.
func (e *EffectiveNetworkSecurityRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &e.Access)
			delete(rawMsg, key)
		case "destinationAddressPrefix":
			err = unpopulate(val, "DestinationAddressPrefix", &e.DestinationAddressPrefix)
			delete(rawMsg, key)
		case "destinationAddressPrefixes":
			err = unpopulate(val, "DestinationAddressPrefixes", &e.DestinationAddressPrefixes)
			delete(rawMsg, key)
		case "destinationPortRange":
			err = unpopulate(val, "DestinationPortRange", &e.DestinationPortRange)
			delete(rawMsg, key)
		case "destinationPortRanges":
			err = unpopulate(val, "DestinationPortRanges", &e.DestinationPortRanges)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &e.Direction)
			delete(rawMsg, key)
		case "expandedDestinationAddressPrefix":
			err = unpopulate(val, "ExpandedDestinationAddressPrefix", &e.ExpandedDestinationAddressPrefix)
			delete(rawMsg, key)
		case "expandedSourceAddressPrefix":
			err = unpopulate(val, "ExpandedSourceAddressPrefix", &e.ExpandedSourceAddressPrefix)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &e.Priority)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &e.Protocol)
			delete(rawMsg, key)
		case "sourceAddressPrefix":
			err = unpopulate(val, "SourceAddressPrefix", &e.SourceAddressPrefix)
			delete(rawMsg, key)
		case "sourceAddressPrefixes":
			err = unpopulate(val, "SourceAddressPrefixes", &e.SourceAddressPrefixes)
			delete(rawMsg, key)
		case "sourcePortRange":
			err = unpopulate(val, "SourcePortRange", &e.SourcePortRange)
			delete(rawMsg, key)
		case "sourcePortRanges":
			err = unpopulate(val, "SourcePortRanges", &e.SourcePortRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveRoute.
func (e EffectiveRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", e.AddressPrefix)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "nextHopIpAddress", e.NextHopIPAddress)
	populate(objectMap, "nextHopType", e.NextHopType)
	populate(objectMap, "source", e.Source)
	populate(objectMap, "state", e.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveRoute.
func (e *EffectiveRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &e.AddressPrefix)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "nextHopIpAddress":
			err = unpopulate(val, "NextHopIPAddress", &e.NextHopIPAddress)
			delete(rawMsg, key)
		case "nextHopType":
			err = unpopulate(val, "NextHopType", &e.NextHopType)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &e.Source)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EffectiveRouteListResult.
func (e EffectiveRouteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EffectiveRouteListResult.
func (e *EffectiveRouteListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointService.
func (e EndpointService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointService.
func (e *EndpointService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "innerError", e.InnerError)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "innerError":
			err = unpopulate(val, "InnerError", &e.InnerError)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetails.
func (e ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetails.
func (e *ErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendIPConfiguration.
func (f FrontendIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "zones", f.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendIPConfiguration.
func (f *FrontendIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &f.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FrontendIPConfigurationPropertiesFormat.
func (f FrontendIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inboundNatPools", f.InboundNatPools)
	populate(objectMap, "inboundNatRules", f.InboundNatRules)
	populate(objectMap, "loadBalancingRules", f.LoadBalancingRules)
	populate(objectMap, "outboundRules", f.OutboundRules)
	populate(objectMap, "privateIPAddress", f.PrivateIPAddress)
	populate(objectMap, "privateIPAllocationMethod", f.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "publicIPAddress", f.PublicIPAddress)
	populate(objectMap, "publicIPPrefix", f.PublicIPPrefix)
	populate(objectMap, "subnet", f.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FrontendIPConfigurationPropertiesFormat.
func (f *FrontendIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inboundNatPools":
			err = unpopulate(val, "InboundNatPools", &f.InboundNatPools)
			delete(rawMsg, key)
		case "inboundNatRules":
			err = unpopulate(val, "InboundNatRules", &f.InboundNatRules)
			delete(rawMsg, key)
		case "loadBalancingRules":
			err = unpopulate(val, "LoadBalancingRules", &f.LoadBalancingRules)
			delete(rawMsg, key)
		case "outboundRules":
			err = unpopulate(val, "OutboundRules", &f.OutboundRules)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &f.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &f.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &f.PublicIPAddress)
			delete(rawMsg, key)
		case "publicIPPrefix":
			err = unpopulate(val, "PublicIPPrefix", &f.PublicIPPrefix)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &f.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayRoute.
func (g GatewayRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asPath", g.AsPath)
	populate(objectMap, "localAddress", g.LocalAddress)
	populate(objectMap, "network", g.Network)
	populate(objectMap, "nextHop", g.NextHop)
	populate(objectMap, "origin", g.Origin)
	populate(objectMap, "sourcePeer", g.SourcePeer)
	populate(objectMap, "weight", g.Weight)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayRoute.
func (g *GatewayRoute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asPath":
			err = unpopulate(val, "AsPath", &g.AsPath)
			delete(rawMsg, key)
		case "localAddress":
			err = unpopulate(val, "LocalAddress", &g.LocalAddress)
			delete(rawMsg, key)
		case "network":
			err = unpopulate(val, "Network", &g.Network)
			delete(rawMsg, key)
		case "nextHop":
			err = unpopulate(val, "NextHop", &g.NextHop)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &g.Origin)
			delete(rawMsg, key)
		case "sourcePeer":
			err = unpopulate(val, "SourcePeer", &g.SourcePeer)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &g.Weight)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GatewayRouteListResult.
func (g GatewayRouteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GatewayRouteListResult.
func (g *GatewayRouteListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPAddressAvailabilityResult.
func (i IPAddressAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "available", i.Available)
	populate(objectMap, "availableIPAddresses", i.AvailableIPAddresses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPAddressAvailabilityResult.
func (i *IPAddressAvailabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "available":
			err = unpopulate(val, "Available", &i.Available)
			delete(rawMsg, key)
		case "availableIPAddresses":
			err = unpopulate(val, "AvailableIPAddresses", &i.AvailableIPAddresses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfiguration.
func (i IPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfiguration.
func (i *IPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigurationProfile.
func (i IPConfigurationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfigurationProfile.
func (i *IPConfigurationProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigurationProfilePropertiesFormat.
func (i IPConfigurationProfilePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "subnet", i.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfigurationProfilePropertiesFormat.
func (i *IPConfigurationProfilePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigurationPropertiesFormat.
func (i IPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIPAddress", i.PrivateIPAddress)
	populate(objectMap, "privateIPAllocationMethod", i.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "publicIPAddress", i.PublicIPAddress)
	populate(objectMap, "subnet", i.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPConfigurationPropertiesFormat.
func (i *IPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &i.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &i.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &i.PublicIPAddress)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPSecPolicy.
func (i IPSecPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dhGroup", i.DhGroup)
	populate(objectMap, "ipsecEncryption", i.IPSecEncryption)
	populate(objectMap, "ipsecIntegrity", i.IPSecIntegrity)
	populate(objectMap, "ikeEncryption", i.IkeEncryption)
	populate(objectMap, "ikeIntegrity", i.IkeIntegrity)
	populate(objectMap, "pfsGroup", i.PfsGroup)
	populate(objectMap, "saDataSizeKilobytes", i.SaDataSizeKilobytes)
	populate(objectMap, "saLifeTimeSeconds", i.SaLifeTimeSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPSecPolicy.
func (i *IPSecPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dhGroup":
			err = unpopulate(val, "DhGroup", &i.DhGroup)
			delete(rawMsg, key)
		case "ipsecEncryption":
			err = unpopulate(val, "IPSecEncryption", &i.IPSecEncryption)
			delete(rawMsg, key)
		case "ipsecIntegrity":
			err = unpopulate(val, "IPSecIntegrity", &i.IPSecIntegrity)
			delete(rawMsg, key)
		case "ikeEncryption":
			err = unpopulate(val, "IkeEncryption", &i.IkeEncryption)
			delete(rawMsg, key)
		case "ikeIntegrity":
			err = unpopulate(val, "IkeIntegrity", &i.IkeIntegrity)
			delete(rawMsg, key)
		case "pfsGroup":
			err = unpopulate(val, "PfsGroup", &i.PfsGroup)
			delete(rawMsg, key)
		case "saDataSizeKilobytes":
			err = unpopulate(val, "SaDataSizeKilobytes", &i.SaDataSizeKilobytes)
			delete(rawMsg, key)
		case "saLifeTimeSeconds":
			err = unpopulate(val, "SaLifeTimeSeconds", &i.SaLifeTimeSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPTag.
func (i IPTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipTagType", i.IPTagType)
	populate(objectMap, "tag", i.Tag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPTag.
func (i *IPTag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipTagType":
			err = unpopulate(val, "IPTagType", &i.IPTagType)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &i.Tag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatPool.
func (i InboundNatPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatPool.
func (i *InboundNatPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatPoolPropertiesFormat.
func (i InboundNatPoolPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendPort", i.BackendPort)
	populate(objectMap, "enableFloatingIP", i.EnableFloatingIP)
	populate(objectMap, "enableTcpReset", i.EnableTCPReset)
	populate(objectMap, "frontendIPConfiguration", i.FrontendIPConfiguration)
	populate(objectMap, "frontendPortRangeEnd", i.FrontendPortRangeEnd)
	populate(objectMap, "frontendPortRangeStart", i.FrontendPortRangeStart)
	populate(objectMap, "idleTimeoutInMinutes", i.IdleTimeoutInMinutes)
	populate(objectMap, "protocol", i.Protocol)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatPoolPropertiesFormat.
func (i *InboundNatPoolPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendPort":
			err = unpopulate(val, "BackendPort", &i.BackendPort)
			delete(rawMsg, key)
		case "enableFloatingIP":
			err = unpopulate(val, "EnableFloatingIP", &i.EnableFloatingIP)
			delete(rawMsg, key)
		case "enableTcpReset":
			err = unpopulate(val, "EnableTCPReset", &i.EnableTCPReset)
			delete(rawMsg, key)
		case "frontendIPConfiguration":
			err = unpopulate(val, "FrontendIPConfiguration", &i.FrontendIPConfiguration)
			delete(rawMsg, key)
		case "frontendPortRangeEnd":
			err = unpopulate(val, "FrontendPortRangeEnd", &i.FrontendPortRangeEnd)
			delete(rawMsg, key)
		case "frontendPortRangeStart":
			err = unpopulate(val, "FrontendPortRangeStart", &i.FrontendPortRangeStart)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &i.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &i.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatRule.
func (i InboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatRule.
func (i *InboundNatRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatRuleListResult.
func (i InboundNatRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatRuleListResult.
func (i *InboundNatRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatRulePropertiesFormat.
func (i InboundNatRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendIPConfiguration", i.BackendIPConfiguration)
	populate(objectMap, "backendPort", i.BackendPort)
	populate(objectMap, "enableFloatingIP", i.EnableFloatingIP)
	populate(objectMap, "enableTcpReset", i.EnableTCPReset)
	populate(objectMap, "frontendIPConfiguration", i.FrontendIPConfiguration)
	populate(objectMap, "frontendPort", i.FrontendPort)
	populate(objectMap, "idleTimeoutInMinutes", i.IdleTimeoutInMinutes)
	populate(objectMap, "protocol", i.Protocol)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatRulePropertiesFormat.
func (i *InboundNatRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendIPConfiguration":
			err = unpopulate(val, "BackendIPConfiguration", &i.BackendIPConfiguration)
			delete(rawMsg, key)
		case "backendPort":
			err = unpopulate(val, "BackendPort", &i.BackendPort)
			delete(rawMsg, key)
		case "enableFloatingIP":
			err = unpopulate(val, "EnableFloatingIP", &i.EnableFloatingIP)
			delete(rawMsg, key)
		case "enableTcpReset":
			err = unpopulate(val, "EnableTCPReset", &i.EnableTCPReset)
			delete(rawMsg, key)
		case "frontendIPConfiguration":
			err = unpopulate(val, "FrontendIPConfiguration", &i.FrontendIPConfiguration)
			delete(rawMsg, key)
		case "frontendPort":
			err = unpopulate(val, "FrontendPort", &i.FrontendPort)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &i.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &i.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Interface.
func (i Interface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Interface.
func (i *Interface) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceDNSSettings.
func (i InterfaceDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedDnsServers", i.AppliedDNSServers)
	populate(objectMap, "dnsServers", i.DNSServers)
	populate(objectMap, "internalDnsNameLabel", i.InternalDNSNameLabel)
	populate(objectMap, "internalDomainNameSuffix", i.InternalDomainNameSuffix)
	populate(objectMap, "internalFqdn", i.InternalFqdn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceDNSSettings.
func (i *InterfaceDNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedDnsServers":
			err = unpopulate(val, "AppliedDNSServers", &i.AppliedDNSServers)
			delete(rawMsg, key)
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &i.DNSServers)
			delete(rawMsg, key)
		case "internalDnsNameLabel":
			err = unpopulate(val, "InternalDNSNameLabel", &i.InternalDNSNameLabel)
			delete(rawMsg, key)
		case "internalDomainNameSuffix":
			err = unpopulate(val, "InternalDomainNameSuffix", &i.InternalDomainNameSuffix)
			delete(rawMsg, key)
		case "internalFqdn":
			err = unpopulate(val, "InternalFqdn", &i.InternalFqdn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceEndpoint.
func (i InterfaceEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "tags", i.Tags)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceEndpoint.
func (i *InterfaceEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &i.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceEndpointProperties.
func (i InterfaceEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointService", i.EndpointService)
	populate(objectMap, "fqdn", i.Fqdn)
	populate(objectMap, "networkInterfaces", i.NetworkInterfaces)
	populate(objectMap, "owner", i.Owner)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "subnet", i.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceEndpointProperties.
func (i *InterfaceEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointService":
			err = unpopulate(val, "EndpointService", &i.EndpointService)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &i.Fqdn)
			delete(rawMsg, key)
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &i.NetworkInterfaces)
			delete(rawMsg, key)
		case "owner":
			err = unpopulate(val, "Owner", &i.Owner)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceIPConfiguration.
func (i InterfaceIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceIPConfiguration.
func (i *InterfaceIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceIPConfigurationListResult.
func (i InterfaceIPConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceIPConfigurationListResult.
func (i *InterfaceIPConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceIPConfigurationPropertiesFormat.
func (i InterfaceIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationGatewayBackendAddressPools", i.ApplicationGatewayBackendAddressPools)
	populate(objectMap, "applicationSecurityGroups", i.ApplicationSecurityGroups)
	populate(objectMap, "loadBalancerBackendAddressPools", i.LoadBalancerBackendAddressPools)
	populate(objectMap, "loadBalancerInboundNatRules", i.LoadBalancerInboundNatRules)
	populate(objectMap, "primary", i.Primary)
	populate(objectMap, "privateIPAddress", i.PrivateIPAddress)
	populate(objectMap, "privateIPAddressVersion", i.PrivateIPAddressVersion)
	populate(objectMap, "privateIPAllocationMethod", i.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "publicIPAddress", i.PublicIPAddress)
	populate(objectMap, "subnet", i.Subnet)
	populate(objectMap, "virtualNetworkTaps", i.VirtualNetworkTaps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceIPConfigurationPropertiesFormat.
func (i *InterfaceIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationGatewayBackendAddressPools":
			err = unpopulate(val, "ApplicationGatewayBackendAddressPools", &i.ApplicationGatewayBackendAddressPools)
			delete(rawMsg, key)
		case "applicationSecurityGroups":
			err = unpopulate(val, "ApplicationSecurityGroups", &i.ApplicationSecurityGroups)
			delete(rawMsg, key)
		case "loadBalancerBackendAddressPools":
			err = unpopulate(val, "LoadBalancerBackendAddressPools", &i.LoadBalancerBackendAddressPools)
			delete(rawMsg, key)
		case "loadBalancerInboundNatRules":
			err = unpopulate(val, "LoadBalancerInboundNatRules", &i.LoadBalancerInboundNatRules)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &i.Primary)
			delete(rawMsg, key)
		case "privateIPAddress":
			err = unpopulate(val, "PrivateIPAddress", &i.PrivateIPAddress)
			delete(rawMsg, key)
		case "privateIPAddressVersion":
			err = unpopulate(val, "PrivateIPAddressVersion", &i.PrivateIPAddressVersion)
			delete(rawMsg, key)
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &i.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &i.PublicIPAddress)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		case "virtualNetworkTaps":
			err = unpopulate(val, "VirtualNetworkTaps", &i.VirtualNetworkTaps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceListResult.
func (i InterfaceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceListResult.
func (i *InterfaceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceLoadBalancerListResult.
func (i InterfaceLoadBalancerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceLoadBalancerListResult.
func (i *InterfaceLoadBalancerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfacePropertiesFormat.
func (i InterfacePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", i.DNSSettings)
	populate(objectMap, "enableAcceleratedNetworking", i.EnableAcceleratedNetworking)
	populate(objectMap, "enableIPForwarding", i.EnableIPForwarding)
	populate(objectMap, "hostedWorkloads", i.HostedWorkloads)
	populate(objectMap, "ipConfigurations", i.IPConfigurations)
	populate(objectMap, "interfaceEndpoint", i.InterfaceEndpoint)
	populate(objectMap, "macAddress", i.MacAddress)
	populate(objectMap, "networkSecurityGroup", i.NetworkSecurityGroup)
	populate(objectMap, "primary", i.Primary)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "resourceGuid", i.ResourceGUID)
	populate(objectMap, "tapConfigurations", i.TapConfigurations)
	populate(objectMap, "virtualMachine", i.VirtualMachine)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfacePropertiesFormat.
func (i *InterfacePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &i.DNSSettings)
			delete(rawMsg, key)
		case "enableAcceleratedNetworking":
			err = unpopulate(val, "EnableAcceleratedNetworking", &i.EnableAcceleratedNetworking)
			delete(rawMsg, key)
		case "enableIPForwarding":
			err = unpopulate(val, "EnableIPForwarding", &i.EnableIPForwarding)
			delete(rawMsg, key)
		case "hostedWorkloads":
			err = unpopulate(val, "HostedWorkloads", &i.HostedWorkloads)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &i.IPConfigurations)
			delete(rawMsg, key)
		case "interfaceEndpoint":
			err = unpopulate(val, "InterfaceEndpoint", &i.InterfaceEndpoint)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &i.MacAddress)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &i.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "primary":
			err = unpopulate(val, "Primary", &i.Primary)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &i.ResourceGUID)
			delete(rawMsg, key)
		case "tapConfigurations":
			err = unpopulate(val, "TapConfigurations", &i.TapConfigurations)
			delete(rawMsg, key)
		case "virtualMachine":
			err = unpopulate(val, "VirtualMachine", &i.VirtualMachine)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceTapConfiguration.
func (i InterfaceTapConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceTapConfiguration.
func (i *InterfaceTapConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceTapConfigurationListResult.
func (i InterfaceTapConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceTapConfigurationListResult.
func (i *InterfaceTapConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InterfaceTapConfigurationPropertiesFormat.
func (i InterfaceTapConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "virtualNetworkTap", i.VirtualNetworkTap)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InterfaceTapConfigurationPropertiesFormat.
func (i *InterfaceTapConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "virtualNetworkTap":
			err = unpopulate(val, "VirtualNetworkTap", &i.VirtualNetworkTap)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancer.
func (l LoadBalancer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "sku", l.SKU)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancer.
func (l *LoadBalancer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &l.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerBackendAddressPoolListResult.
func (l LoadBalancerBackendAddressPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerBackendAddressPoolListResult.
func (l *LoadBalancerBackendAddressPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerFrontendIPConfigurationListResult.
func (l LoadBalancerFrontendIPConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerFrontendIPConfigurationListResult.
func (l *LoadBalancerFrontendIPConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerListResult.
func (l LoadBalancerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerListResult.
func (l *LoadBalancerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerLoadBalancingRuleListResult.
func (l LoadBalancerLoadBalancingRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerLoadBalancingRuleListResult.
func (l *LoadBalancerLoadBalancingRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerOutboundRuleListResult.
func (l LoadBalancerOutboundRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerOutboundRuleListResult.
func (l *LoadBalancerOutboundRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerProbeListResult.
func (l LoadBalancerProbeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerProbeListResult.
func (l *LoadBalancerProbeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerPropertiesFormat.
func (l LoadBalancerPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPools", l.BackendAddressPools)
	populate(objectMap, "frontendIPConfigurations", l.FrontendIPConfigurations)
	populate(objectMap, "inboundNatPools", l.InboundNatPools)
	populate(objectMap, "inboundNatRules", l.InboundNatRules)
	populate(objectMap, "loadBalancingRules", l.LoadBalancingRules)
	populate(objectMap, "outboundRules", l.OutboundRules)
	populate(objectMap, "probes", l.Probes)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "resourceGuid", l.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerPropertiesFormat.
func (l *LoadBalancerPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPools":
			err = unpopulate(val, "BackendAddressPools", &l.BackendAddressPools)
			delete(rawMsg, key)
		case "frontendIPConfigurations":
			err = unpopulate(val, "FrontendIPConfigurations", &l.FrontendIPConfigurations)
			delete(rawMsg, key)
		case "inboundNatPools":
			err = unpopulate(val, "InboundNatPools", &l.InboundNatPools)
			delete(rawMsg, key)
		case "inboundNatRules":
			err = unpopulate(val, "InboundNatRules", &l.InboundNatRules)
			delete(rawMsg, key)
		case "loadBalancingRules":
			err = unpopulate(val, "LoadBalancingRules", &l.LoadBalancingRules)
			delete(rawMsg, key)
		case "outboundRules":
			err = unpopulate(val, "OutboundRules", &l.OutboundRules)
			delete(rawMsg, key)
		case "probes":
			err = unpopulate(val, "Probes", &l.Probes)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &l.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancerSKU.
func (l LoadBalancerSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancerSKU.
func (l *LoadBalancerSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancingRule.
func (l LoadBalancingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancingRule.
func (l *LoadBalancingRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBalancingRulePropertiesFormat.
func (l LoadBalancingRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendAddressPool", l.BackendAddressPool)
	populate(objectMap, "backendPort", l.BackendPort)
	populate(objectMap, "disableOutboundSnat", l.DisableOutboundSnat)
	populate(objectMap, "enableFloatingIP", l.EnableFloatingIP)
	populate(objectMap, "enableTcpReset", l.EnableTCPReset)
	populate(objectMap, "frontendIPConfiguration", l.FrontendIPConfiguration)
	populate(objectMap, "frontendPort", l.FrontendPort)
	populate(objectMap, "idleTimeoutInMinutes", l.IdleTimeoutInMinutes)
	populate(objectMap, "loadDistribution", l.LoadDistribution)
	populate(objectMap, "probe", l.Probe)
	populate(objectMap, "protocol", l.Protocol)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBalancingRulePropertiesFormat.
func (l *LoadBalancingRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &l.BackendAddressPool)
			delete(rawMsg, key)
		case "backendPort":
			err = unpopulate(val, "BackendPort", &l.BackendPort)
			delete(rawMsg, key)
		case "disableOutboundSnat":
			err = unpopulate(val, "DisableOutboundSnat", &l.DisableOutboundSnat)
			delete(rawMsg, key)
		case "enableFloatingIP":
			err = unpopulate(val, "EnableFloatingIP", &l.EnableFloatingIP)
			delete(rawMsg, key)
		case "enableTcpReset":
			err = unpopulate(val, "EnableTCPReset", &l.EnableTCPReset)
			delete(rawMsg, key)
		case "frontendIPConfiguration":
			err = unpopulate(val, "FrontendIPConfiguration", &l.FrontendIPConfiguration)
			delete(rawMsg, key)
		case "frontendPort":
			err = unpopulate(val, "FrontendPort", &l.FrontendPort)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &l.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "loadDistribution":
			err = unpopulate(val, "LoadDistribution", &l.LoadDistribution)
			delete(rawMsg, key)
		case "probe":
			err = unpopulate(val, "Probe", &l.Probe)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &l.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalNetworkGateway.
func (l LocalNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalNetworkGateway.
func (l *LocalNetworkGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalNetworkGatewayListResult.
func (l LocalNetworkGatewayListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalNetworkGatewayListResult.
func (l *LocalNetworkGatewayListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LocalNetworkGatewayPropertiesFormat.
func (l LocalNetworkGatewayPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bgpSettings", l.BgpSettings)
	populate(objectMap, "gatewayIpAddress", l.GatewayIPAddress)
	populate(objectMap, "localNetworkAddressSpace", l.LocalNetworkAddressSpace)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "resourceGuid", l.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LocalNetworkGatewayPropertiesFormat.
func (l *LocalNetworkGatewayPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bgpSettings":
			err = unpopulate(val, "BgpSettings", &l.BgpSettings)
			delete(rawMsg, key)
		case "gatewayIpAddress":
			err = unpopulate(val, "GatewayIPAddress", &l.GatewayIPAddress)
			delete(rawMsg, key)
		case "localNetworkAddressSpace":
			err = unpopulate(val, "LocalNetworkAddressSpace", &l.LocalNetworkAddressSpace)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &l.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSpecification.
func (l LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobDuration", l.BlobDuration)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSpecification.
func (l *LogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobDuration":
			err = unpopulate(val, "BlobDuration", &l.BlobDuration)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecification.
func (m MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "availabilities", m.Availabilities)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "enableRegionalMdmAccount", m.EnableRegionalMdmAccount)
	populate(objectMap, "fillGapWithZero", m.FillGapWithZero)
	populate(objectMap, "isInternal", m.IsInternal)
	populate(objectMap, "metricFilterPattern", m.MetricFilterPattern)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "resourceIdDimensionNameOverride", m.ResourceIDDimensionNameOverride)
	populate(objectMap, "sourceMdmAccount", m.SourceMdmAccount)
	populate(objectMap, "sourceMdmNamespace", m.SourceMdmNamespace)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecification.
func (m *MetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "availabilities":
			err = unpopulate(val, "Availabilities", &m.Availabilities)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "enableRegionalMdmAccount":
			err = unpopulate(val, "EnableRegionalMdmAccount", &m.EnableRegionalMdmAccount)
			delete(rawMsg, key)
		case "fillGapWithZero":
			err = unpopulate(val, "FillGapWithZero", &m.FillGapWithZero)
			delete(rawMsg, key)
		case "isInternal":
			err = unpopulate(val, "IsInternal", &m.IsInternal)
			delete(rawMsg, key)
		case "metricFilterPattern":
			err = unpopulate(val, "MetricFilterPattern", &m.MetricFilterPattern)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "resourceIdDimensionNameOverride":
			err = unpopulate(val, "ResourceIDDimensionNameOverride", &m.ResourceIDDimensionNameOverride)
			delete(rawMsg, key)
		case "sourceMdmAccount":
			err = unpopulate(val, "SourceMdmAccount", &m.SourceMdmAccount)
			delete(rawMsg, key)
		case "sourceMdmNamespace":
			err = unpopulate(val, "SourceMdmNamespace", &m.SourceMdmNamespace)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationPropertiesFormat.
func (o OperationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", o.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationPropertiesFormat.
func (o *OperationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &o.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationPropertiesFormatServiceSpecification.
func (o OperationPropertiesFormatServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", o.LogSpecifications)
	populate(objectMap, "metricSpecifications", o.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationPropertiesFormatServiceSpecification.
func (o *OperationPropertiesFormatServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &o.LogSpecifications)
			delete(rawMsg, key)
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &o.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutboundRule.
func (o OutboundRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", o.Etag)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutboundRule.
func (o *OutboundRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &o.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutboundRulePropertiesFormat.
func (o OutboundRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocatedOutboundPorts", o.AllocatedOutboundPorts)
	populate(objectMap, "backendAddressPool", o.BackendAddressPool)
	populate(objectMap, "enableTcpReset", o.EnableTCPReset)
	populate(objectMap, "frontendIPConfigurations", o.FrontendIPConfigurations)
	populate(objectMap, "idleTimeoutInMinutes", o.IdleTimeoutInMinutes)
	populate(objectMap, "protocol", o.Protocol)
	populate(objectMap, "provisioningState", o.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutboundRulePropertiesFormat.
func (o *OutboundRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocatedOutboundPorts":
			err = unpopulate(val, "AllocatedOutboundPorts", &o.AllocatedOutboundPorts)
			delete(rawMsg, key)
		case "backendAddressPool":
			err = unpopulate(val, "BackendAddressPool", &o.BackendAddressPool)
			delete(rawMsg, key)
		case "enableTcpReset":
			err = unpopulate(val, "EnableTCPReset", &o.EnableTCPReset)
			delete(rawMsg, key)
		case "frontendIPConfigurations":
			err = unpopulate(val, "FrontendIPConfigurations", &o.FrontendIPConfigurations)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &o.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &o.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &o.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Probe.
func (p Probe) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Probe.
func (p *Probe) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProbePropertiesFormat.
func (p ProbePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "intervalInSeconds", p.IntervalInSeconds)
	populate(objectMap, "loadBalancingRules", p.LoadBalancingRules)
	populate(objectMap, "numberOfProbes", p.NumberOfProbes)
	populate(objectMap, "port", p.Port)
	populate(objectMap, "protocol", p.Protocol)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "requestPath", p.RequestPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProbePropertiesFormat.
func (p *ProbePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "intervalInSeconds":
			err = unpopulate(val, "IntervalInSeconds", &p.IntervalInSeconds)
			delete(rawMsg, key)
		case "loadBalancingRules":
			err = unpopulate(val, "LoadBalancingRules", &p.LoadBalancingRules)
			delete(rawMsg, key)
		case "numberOfProbes":
			err = unpopulate(val, "NumberOfProbes", &p.NumberOfProbes)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &p.Port)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &p.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "requestPath":
			err = unpopulate(val, "RequestPath", &p.RequestPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddress.
func (p PublicIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	populate(objectMap, "zones", p.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddress.
func (p *PublicIPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &p.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddressDNSSettings.
func (p PublicIPAddressDNSSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainNameLabel", p.DomainNameLabel)
	populate(objectMap, "fqdn", p.Fqdn)
	populate(objectMap, "reverseFqdn", p.ReverseFqdn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddressDNSSettings.
func (p *PublicIPAddressDNSSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainNameLabel":
			err = unpopulate(val, "DomainNameLabel", &p.DomainNameLabel)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &p.Fqdn)
			delete(rawMsg, key)
		case "reverseFqdn":
			err = unpopulate(val, "ReverseFqdn", &p.ReverseFqdn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddressListResult.
func (p PublicIPAddressListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddressListResult.
func (p *PublicIPAddressListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddressPropertiesFormat.
func (p PublicIPAddressPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsSettings", p.DNSSettings)
	populate(objectMap, "ddosSettings", p.DdosSettings)
	populate(objectMap, "ipAddress", p.IPAddress)
	populate(objectMap, "ipConfiguration", p.IPConfiguration)
	populate(objectMap, "ipTags", p.IPTags)
	populate(objectMap, "idleTimeoutInMinutes", p.IdleTimeoutInMinutes)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "publicIPAddressVersion", p.PublicIPAddressVersion)
	populate(objectMap, "publicIPAllocationMethod", p.PublicIPAllocationMethod)
	populate(objectMap, "publicIPPrefix", p.PublicIPPrefix)
	populate(objectMap, "resourceGuid", p.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddressPropertiesFormat.
func (p *PublicIPAddressPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsSettings":
			err = unpopulate(val, "DNSSettings", &p.DNSSettings)
			delete(rawMsg, key)
		case "ddosSettings":
			err = unpopulate(val, "DdosSettings", &p.DdosSettings)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &p.IPAddress)
			delete(rawMsg, key)
		case "ipConfiguration":
			err = unpopulate(val, "IPConfiguration", &p.IPConfiguration)
			delete(rawMsg, key)
		case "ipTags":
			err = unpopulate(val, "IPTags", &p.IPTags)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &p.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddressVersion":
			err = unpopulate(val, "PublicIPAddressVersion", &p.PublicIPAddressVersion)
			delete(rawMsg, key)
		case "publicIPAllocationMethod":
			err = unpopulate(val, "PublicIPAllocationMethod", &p.PublicIPAllocationMethod)
			delete(rawMsg, key)
		case "publicIPPrefix":
			err = unpopulate(val, "PublicIPPrefix", &p.PublicIPPrefix)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &p.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PublicIPAddressSKU.
func (p PublicIPAddressSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PublicIPAddressSKU.
func (p *PublicIPAddressSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNavigationLink.
func (r ResourceNavigationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNavigationLink.
func (r *ResourceNavigationLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNavigationLinkFormat.
func (r ResourceNavigationLinkFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "link", r.Link)
	populate(objectMap, "linkedResourceType", r.LinkedResourceType)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNavigationLinkFormat.
func (r *ResourceNavigationLinkFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "link":
			err = unpopulate(val, "Link", &r.Link)
			delete(rawMsg, key)
		case "linkedResourceType":
			err = unpopulate(val, "LinkedResourceType", &r.LinkedResourceType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Route.
func (r Route) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Route.
func (r *Route) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteListResult.
func (r RouteListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteListResult.
func (r *RouteListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RoutePropertiesFormat.
func (r RoutePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", r.AddressPrefix)
	populate(objectMap, "nextHopIpAddress", r.NextHopIPAddress)
	populate(objectMap, "nextHopType", r.NextHopType)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RoutePropertiesFormat.
func (r *RoutePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &r.AddressPrefix)
			delete(rawMsg, key)
		case "nextHopIpAddress":
			err = unpopulate(val, "NextHopIPAddress", &r.NextHopIPAddress)
			delete(rawMsg, key)
		case "nextHopType":
			err = unpopulate(val, "NextHopType", &r.NextHopType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteTable.
func (r RouteTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteTable.
func (r *RouteTable) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteTableListResult.
func (r RouteTableListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteTableListResult.
func (r *RouteTableListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RouteTablePropertiesFormat.
func (r RouteTablePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disableBgpRoutePropagation", r.DisableBgpRoutePropagation)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "routes", r.Routes)
	populate(objectMap, "subnets", r.Subnets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RouteTablePropertiesFormat.
func (r *RouteTablePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableBgpRoutePropagation":
			err = unpopulate(val, "DisableBgpRoutePropagation", &r.DisableBgpRoutePropagation)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "routes":
			err = unpopulate(val, "Routes", &r.Routes)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &r.Subnets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroup.
func (s SecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroup.
func (s *SecurityGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroupListResult.
func (s SecurityGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroupListResult.
func (s *SecurityGroupListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityGroupPropertiesFormat.
func (s SecurityGroupPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultSecurityRules", s.DefaultSecurityRules)
	populate(objectMap, "networkInterfaces", s.NetworkInterfaces)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "resourceGuid", s.ResourceGUID)
	populate(objectMap, "securityRules", s.SecurityRules)
	populate(objectMap, "subnets", s.Subnets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityGroupPropertiesFormat.
func (s *SecurityGroupPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultSecurityRules":
			err = unpopulate(val, "DefaultSecurityRules", &s.DefaultSecurityRules)
			delete(rawMsg, key)
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &s.NetworkInterfaces)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &s.ResourceGUID)
			delete(rawMsg, key)
		case "securityRules":
			err = unpopulate(val, "SecurityRules", &s.SecurityRules)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &s.Subnets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityRule.
func (s SecurityRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityRule.
func (s *SecurityRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityRuleListResult.
func (s SecurityRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityRuleListResult.
func (s *SecurityRuleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityRulePropertiesFormat.
func (s SecurityRulePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "access", s.Access)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "destinationAddressPrefix", s.DestinationAddressPrefix)
	populate(objectMap, "destinationAddressPrefixes", s.DestinationAddressPrefixes)
	populate(objectMap, "destinationApplicationSecurityGroups", s.DestinationApplicationSecurityGroups)
	populate(objectMap, "destinationPortRange", s.DestinationPortRange)
	populate(objectMap, "destinationPortRanges", s.DestinationPortRanges)
	populate(objectMap, "direction", s.Direction)
	populate(objectMap, "priority", s.Priority)
	populate(objectMap, "protocol", s.Protocol)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "sourceAddressPrefix", s.SourceAddressPrefix)
	populate(objectMap, "sourceAddressPrefixes", s.SourceAddressPrefixes)
	populate(objectMap, "sourceApplicationSecurityGroups", s.SourceApplicationSecurityGroups)
	populate(objectMap, "sourcePortRange", s.SourcePortRange)
	populate(objectMap, "sourcePortRanges", s.SourcePortRanges)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityRulePropertiesFormat.
func (s *SecurityRulePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "access":
			err = unpopulate(val, "Access", &s.Access)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "destinationAddressPrefix":
			err = unpopulate(val, "DestinationAddressPrefix", &s.DestinationAddressPrefix)
			delete(rawMsg, key)
		case "destinationAddressPrefixes":
			err = unpopulate(val, "DestinationAddressPrefixes", &s.DestinationAddressPrefixes)
			delete(rawMsg, key)
		case "destinationApplicationSecurityGroups":
			err = unpopulate(val, "DestinationApplicationSecurityGroups", &s.DestinationApplicationSecurityGroups)
			delete(rawMsg, key)
		case "destinationPortRange":
			err = unpopulate(val, "DestinationPortRange", &s.DestinationPortRange)
			delete(rawMsg, key)
		case "destinationPortRanges":
			err = unpopulate(val, "DestinationPortRanges", &s.DestinationPortRanges)
			delete(rawMsg, key)
		case "direction":
			err = unpopulate(val, "Direction", &s.Direction)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &s.Priority)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &s.Protocol)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "sourceAddressPrefix":
			err = unpopulate(val, "SourceAddressPrefix", &s.SourceAddressPrefix)
			delete(rawMsg, key)
		case "sourceAddressPrefixes":
			err = unpopulate(val, "SourceAddressPrefixes", &s.SourceAddressPrefixes)
			delete(rawMsg, key)
		case "sourceApplicationSecurityGroups":
			err = unpopulate(val, "SourceApplicationSecurityGroups", &s.SourceApplicationSecurityGroups)
			delete(rawMsg, key)
		case "sourcePortRange":
			err = unpopulate(val, "SourcePortRange", &s.SourcePortRange)
			delete(rawMsg, key)
		case "sourcePortRanges":
			err = unpopulate(val, "SourcePortRanges", &s.SourcePortRanges)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceAssociationLink.
func (s ServiceAssociationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceAssociationLink.
func (s *ServiceAssociationLink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceAssociationLinkPropertiesFormat.
func (s ServiceAssociationLinkPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "link", s.Link)
	populate(objectMap, "linkedResourceType", s.LinkedResourceType)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceAssociationLinkPropertiesFormat.
func (s *ServiceAssociationLinkPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "link":
			err = unpopulate(val, "Link", &s.Link)
			delete(rawMsg, key)
		case "linkedResourceType":
			err = unpopulate(val, "LinkedResourceType", &s.LinkedResourceType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceDelegationPropertiesFormat.
func (s ServiceDelegationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actions", s.Actions)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "serviceName", s.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceDelegationPropertiesFormat.
func (s *ServiceDelegationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actions":
			err = unpopulate(val, "Actions", &s.Actions)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &s.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPolicy.
func (s ServiceEndpointPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPolicy.
func (s *ServiceEndpointPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPolicyDefinition.
func (s ServiceEndpointPolicyDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPolicyDefinition.
func (s *ServiceEndpointPolicyDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPolicyDefinitionPropertiesFormat.
func (s ServiceEndpointPolicyDefinitionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "service", s.Service)
	populate(objectMap, "serviceResources", s.ServiceResources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPolicyDefinitionPropertiesFormat.
func (s *ServiceEndpointPolicyDefinitionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "service":
			err = unpopulate(val, "Service", &s.Service)
			delete(rawMsg, key)
		case "serviceResources":
			err = unpopulate(val, "ServiceResources", &s.ServiceResources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPolicyPropertiesFormat.
func (s ServiceEndpointPolicyPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "resourceGuid", s.ResourceGUID)
	populate(objectMap, "serviceEndpointPolicyDefinitions", s.ServiceEndpointPolicyDefinitions)
	populate(objectMap, "subnets", s.Subnets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPolicyPropertiesFormat.
func (s *ServiceEndpointPolicyPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &s.ResourceGUID)
			delete(rawMsg, key)
		case "serviceEndpointPolicyDefinitions":
			err = unpopulate(val, "ServiceEndpointPolicyDefinitions", &s.ServiceEndpointPolicyDefinitions)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &s.Subnets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceEndpointPropertiesFormat.
func (s ServiceEndpointPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "locations", s.Locations)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "service", s.Service)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceEndpointPropertiesFormat.
func (s *ServiceEndpointPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locations":
			err = unpopulate(val, "Locations", &s.Locations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "service":
			err = unpopulate(val, "Service", &s.Service)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Subnet.
func (s Subnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Subnet.
func (s *Subnet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubnetListResult.
func (s SubnetListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubnetListResult.
func (s *SubnetListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubnetPropertiesFormat.
func (s SubnetPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressPrefix", s.AddressPrefix)
	populate(objectMap, "addressPrefixes", s.AddressPrefixes)
	populate(objectMap, "delegations", s.Delegations)
	populate(objectMap, "ipConfigurationProfiles", s.IPConfigurationProfiles)
	populate(objectMap, "ipConfigurations", s.IPConfigurations)
	populate(objectMap, "interfaceEndpoints", s.InterfaceEndpoints)
	populate(objectMap, "networkSecurityGroup", s.NetworkSecurityGroup)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "purpose", s.Purpose)
	populate(objectMap, "resourceNavigationLinks", s.ResourceNavigationLinks)
	populate(objectMap, "routeTable", s.RouteTable)
	populate(objectMap, "serviceAssociationLinks", s.ServiceAssociationLinks)
	populate(objectMap, "serviceEndpointPolicies", s.ServiceEndpointPolicies)
	populate(objectMap, "serviceEndpoints", s.ServiceEndpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubnetPropertiesFormat.
func (s *SubnetPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressPrefix":
			err = unpopulate(val, "AddressPrefix", &s.AddressPrefix)
			delete(rawMsg, key)
		case "addressPrefixes":
			err = unpopulate(val, "AddressPrefixes", &s.AddressPrefixes)
			delete(rawMsg, key)
		case "delegations":
			err = unpopulate(val, "Delegations", &s.Delegations)
			delete(rawMsg, key)
		case "ipConfigurationProfiles":
			err = unpopulate(val, "IPConfigurationProfiles", &s.IPConfigurationProfiles)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &s.IPConfigurations)
			delete(rawMsg, key)
		case "interfaceEndpoints":
			err = unpopulate(val, "InterfaceEndpoints", &s.InterfaceEndpoints)
			delete(rawMsg, key)
		case "networkSecurityGroup":
			err = unpopulate(val, "NetworkSecurityGroup", &s.NetworkSecurityGroup)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "purpose":
			err = unpopulate(val, "Purpose", &s.Purpose)
			delete(rawMsg, key)
		case "resourceNavigationLinks":
			err = unpopulate(val, "ResourceNavigationLinks", &s.ResourceNavigationLinks)
			delete(rawMsg, key)
		case "routeTable":
			err = unpopulate(val, "RouteTable", &s.RouteTable)
			delete(rawMsg, key)
		case "serviceAssociationLinks":
			err = unpopulate(val, "ServiceAssociationLinks", &s.ServiceAssociationLinks)
			delete(rawMsg, key)
		case "serviceEndpointPolicies":
			err = unpopulate(val, "ServiceEndpointPolicies", &s.ServiceEndpointPolicies)
			delete(rawMsg, key)
		case "serviceEndpoints":
			err = unpopulate(val, "ServiceEndpoints", &s.ServiceEndpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsObject.
func (t *TagsObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TunnelConnectionHealth.
func (t TunnelConnectionHealth) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionStatus", t.ConnectionStatus)
	populate(objectMap, "egressBytesTransferred", t.EgressBytesTransferred)
	populate(objectMap, "ingressBytesTransferred", t.IngressBytesTransferred)
	populate(objectMap, "lastConnectionEstablishedUtcTime", t.LastConnectionEstablishedUTCTime)
	populate(objectMap, "tunnel", t.Tunnel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TunnelConnectionHealth.
func (t *TunnelConnectionHealth) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &t.ConnectionStatus)
			delete(rawMsg, key)
		case "egressBytesTransferred":
			err = unpopulate(val, "EgressBytesTransferred", &t.EgressBytesTransferred)
			delete(rawMsg, key)
		case "ingressBytesTransferred":
			err = unpopulate(val, "IngressBytesTransferred", &t.IngressBytesTransferred)
			delete(rawMsg, key)
		case "lastConnectionEstablishedUtcTime":
			err = unpopulate(val, "LastConnectionEstablishedUTCTime", &t.LastConnectionEstablishedUTCTime)
			delete(rawMsg, key)
		case "tunnel":
			err = unpopulate(val, "Tunnel", &t.Tunnel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientConfiguration.
func (v VPNClientConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "radiusServerAddress", v.RadiusServerAddress)
	populate(objectMap, "radiusServerSecret", v.RadiusServerSecret)
	populate(objectMap, "vpnClientAddressPool", v.VPNClientAddressPool)
	populate(objectMap, "vpnClientIpsecPolicies", v.VPNClientIPSecPolicies)
	populate(objectMap, "vpnClientProtocols", v.VPNClientProtocols)
	populate(objectMap, "vpnClientRevokedCertificates", v.VPNClientRevokedCertificates)
	populate(objectMap, "vpnClientRootCertificates", v.VPNClientRootCertificates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientConfiguration.
func (v *VPNClientConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "radiusServerAddress":
			err = unpopulate(val, "RadiusServerAddress", &v.RadiusServerAddress)
			delete(rawMsg, key)
		case "radiusServerSecret":
			err = unpopulate(val, "RadiusServerSecret", &v.RadiusServerSecret)
			delete(rawMsg, key)
		case "vpnClientAddressPool":
			err = unpopulate(val, "VPNClientAddressPool", &v.VPNClientAddressPool)
			delete(rawMsg, key)
		case "vpnClientIpsecPolicies":
			err = unpopulate(val, "VPNClientIPSecPolicies", &v.VPNClientIPSecPolicies)
			delete(rawMsg, key)
		case "vpnClientProtocols":
			err = unpopulate(val, "VPNClientProtocols", &v.VPNClientProtocols)
			delete(rawMsg, key)
		case "vpnClientRevokedCertificates":
			err = unpopulate(val, "VPNClientRevokedCertificates", &v.VPNClientRevokedCertificates)
			delete(rawMsg, key)
		case "vpnClientRootCertificates":
			err = unpopulate(val, "VPNClientRootCertificates", &v.VPNClientRootCertificates)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientIPsecParameters.
func (v VPNClientIPsecParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dhGroup", v.DhGroup)
	populate(objectMap, "ipsecEncryption", v.IPSecEncryption)
	populate(objectMap, "ipsecIntegrity", v.IPSecIntegrity)
	populate(objectMap, "ikeEncryption", v.IkeEncryption)
	populate(objectMap, "ikeIntegrity", v.IkeIntegrity)
	populate(objectMap, "pfsGroup", v.PfsGroup)
	populate(objectMap, "saDataSizeKilobytes", v.SaDataSizeKilobytes)
	populate(objectMap, "saLifeTimeSeconds", v.SaLifeTimeSeconds)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientIPsecParameters.
func (v *VPNClientIPsecParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dhGroup":
			err = unpopulate(val, "DhGroup", &v.DhGroup)
			delete(rawMsg, key)
		case "ipsecEncryption":
			err = unpopulate(val, "IPSecEncryption", &v.IPSecEncryption)
			delete(rawMsg, key)
		case "ipsecIntegrity":
			err = unpopulate(val, "IPSecIntegrity", &v.IPSecIntegrity)
			delete(rawMsg, key)
		case "ikeEncryption":
			err = unpopulate(val, "IkeEncryption", &v.IkeEncryption)
			delete(rawMsg, key)
		case "ikeIntegrity":
			err = unpopulate(val, "IkeIntegrity", &v.IkeIntegrity)
			delete(rawMsg, key)
		case "pfsGroup":
			err = unpopulate(val, "PfsGroup", &v.PfsGroup)
			delete(rawMsg, key)
		case "saDataSizeKilobytes":
			err = unpopulate(val, "SaDataSizeKilobytes", &v.SaDataSizeKilobytes)
			delete(rawMsg, key)
		case "saLifeTimeSeconds":
			err = unpopulate(val, "SaLifeTimeSeconds", &v.SaLifeTimeSeconds)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientParameters.
func (v VPNClientParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationMethod", v.AuthenticationMethod)
	populate(objectMap, "clientRootCertificates", v.ClientRootCertificates)
	populate(objectMap, "processorArchitecture", v.ProcessorArchitecture)
	populate(objectMap, "radiusServerAuthCertificate", v.RadiusServerAuthCertificate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientParameters.
func (v *VPNClientParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationMethod":
			err = unpopulate(val, "AuthenticationMethod", &v.AuthenticationMethod)
			delete(rawMsg, key)
		case "clientRootCertificates":
			err = unpopulate(val, "ClientRootCertificates", &v.ClientRootCertificates)
			delete(rawMsg, key)
		case "processorArchitecture":
			err = unpopulate(val, "ProcessorArchitecture", &v.ProcessorArchitecture)
			delete(rawMsg, key)
		case "radiusServerAuthCertificate":
			err = unpopulate(val, "RadiusServerAuthCertificate", &v.RadiusServerAuthCertificate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientRevokedCertificate.
func (v VPNClientRevokedCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientRevokedCertificate.
func (v *VPNClientRevokedCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientRevokedCertificatePropertiesFormat.
func (v VPNClientRevokedCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "thumbprint", v.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientRevokedCertificatePropertiesFormat.
func (v *VPNClientRevokedCertificatePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &v.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientRootCertificate.
func (v VPNClientRootCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientRootCertificate.
func (v *VPNClientRootCertificate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNClientRootCertificatePropertiesFormat.
func (v VPNClientRootCertificatePropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "publicCertData", v.PublicCertData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNClientRootCertificatePropertiesFormat.
func (v *VPNClientRootCertificatePropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "publicCertData":
			err = unpopulate(val, "PublicCertData", &v.PublicCertData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VPNDeviceScriptParameters.
func (v VPNDeviceScriptParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceFamily", v.DeviceFamily)
	populate(objectMap, "firmwareVersion", v.FirmwareVersion)
	populate(objectMap, "vendor", v.Vendor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VPNDeviceScriptParameters.
func (v *VPNDeviceScriptParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceFamily":
			err = unpopulate(val, "DeviceFamily", &v.DeviceFamily)
			delete(rawMsg, key)
		case "firmwareVersion":
			err = unpopulate(val, "FirmwareVersion", &v.FirmwareVersion)
			delete(rawMsg, key)
		case "vendor":
			err = unpopulate(val, "Vendor", &v.Vendor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetwork.
func (v VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetwork.
func (v *VirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkConnectionGatewayReference.
func (v VirtualNetworkConnectionGatewayReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkConnectionGatewayReference.
func (v *VirtualNetworkConnectionGatewayReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGateway.
func (v VirtualNetworkGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGateway.
func (v *VirtualNetworkGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewayConnection.
func (v VirtualNetworkGatewayConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewayConnection.
func (v *VirtualNetworkGatewayConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewayConnectionListEntity.
func (v VirtualNetworkGatewayConnectionListEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewayConnectionListEntity.
func (v *VirtualNetworkGatewayConnectionListEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewayConnectionListEntityPropertiesFormat.
func (v VirtualNetworkGatewayConnectionListEntityPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationKey", v.AuthorizationKey)
	populate(objectMap, "connectionProtocol", v.ConnectionProtocol)
	populate(objectMap, "connectionStatus", v.ConnectionStatus)
	populate(objectMap, "connectionType", v.ConnectionType)
	populate(objectMap, "egressBytesTransferred", v.EgressBytesTransferred)
	populate(objectMap, "enableBgp", v.EnableBgp)
	populate(objectMap, "expressRouteGatewayBypass", v.ExpressRouteGatewayBypass)
	populate(objectMap, "ipsecPolicies", v.IPSecPolicies)
	populate(objectMap, "ingressBytesTransferred", v.IngressBytesTransferred)
	populate(objectMap, "localNetworkGateway2", v.LocalNetworkGateway2)
	populate(objectMap, "peer", v.Peer)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "resourceGuid", v.ResourceGUID)
	populate(objectMap, "routingWeight", v.RoutingWeight)
	populate(objectMap, "sharedKey", v.SharedKey)
	populate(objectMap, "tunnelConnectionStatus", v.TunnelConnectionStatus)
	populate(objectMap, "usePolicyBasedTrafficSelectors", v.UsePolicyBasedTrafficSelectors)
	populate(objectMap, "virtualNetworkGateway1", v.VirtualNetworkGateway1)
	populate(objectMap, "virtualNetworkGateway2", v.VirtualNetworkGateway2)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewayConnectionListEntityPropertiesFormat.
func (v *VirtualNetworkGatewayConnectionListEntityPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationKey":
			err = unpopulate(val, "AuthorizationKey", &v.AuthorizationKey)
			delete(rawMsg, key)
		case "connectionProtocol":
			err = unpopulate(val, "ConnectionProtocol", &v.ConnectionProtocol)
			delete(rawMsg, key)
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &v.ConnectionStatus)
			delete(rawMsg, key)
		case "connectionType":
			err = unpopulate(val, "ConnectionType", &v.ConnectionType)
			delete(rawMsg, key)
		case "egressBytesTransferred":
			err = unpopulate(val, "EgressBytesTransferred", &v.EgressBytesTransferred)
			delete(rawMsg, key)
		case "enableBgp":
			err = unpopulate(val, "EnableBgp", &v.EnableBgp)
			delete(rawMsg, key)
		case "expressRouteGatewayBypass":
			err = unpopulate(val, "ExpressRouteGatewayBypass", &v.ExpressRouteGatewayBypass)
			delete(rawMsg, key)
		case "ipsecPolicies":
			err = unpopulate(val, "IPSecPolicies", &v.IPSecPolicies)
			delete(rawMsg, key)
		case "ingressBytesTransferred":
			err = unpopulate(val, "IngressBytesTransferred", &v.IngressBytesTransferred)
			delete(rawMsg, key)
		case "localNetworkGateway2":
			err = unpopulate(val, "LocalNetworkGateway2", &v.LocalNetworkGateway2)
			delete(rawMsg, key)
		case "peer":
			err = unpopulate(val, "Peer", &v.Peer)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &v.ResourceGUID)
			delete(rawMsg, key)
		case "routingWeight":
			err = unpopulate(val, "RoutingWeight", &v.RoutingWeight)
			delete(rawMsg, key)
		case "sharedKey":
			err = unpopulate(val, "SharedKey", &v.SharedKey)
			delete(rawMsg, key)
		case "tunnelConnectionStatus":
			err = unpopulate(val, "TunnelConnectionStatus", &v.TunnelConnectionStatus)
			delete(rawMsg, key)
		case "usePolicyBasedTrafficSelectors":
			err = unpopulate(val, "UsePolicyBasedTrafficSelectors", &v.UsePolicyBasedTrafficSelectors)
			delete(rawMsg, key)
		case "virtualNetworkGateway1":
			err = unpopulate(val, "VirtualNetworkGateway1", &v.VirtualNetworkGateway1)
			delete(rawMsg, key)
		case "virtualNetworkGateway2":
			err = unpopulate(val, "VirtualNetworkGateway2", &v.VirtualNetworkGateway2)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewayConnectionListResult.
func (v VirtualNetworkGatewayConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewayConnectionListResult.
func (v *VirtualNetworkGatewayConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewayConnectionPropertiesFormat.
func (v VirtualNetworkGatewayConnectionPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationKey", v.AuthorizationKey)
	populate(objectMap, "connectionProtocol", v.ConnectionProtocol)
	populate(objectMap, "connectionStatus", v.ConnectionStatus)
	populate(objectMap, "connectionType", v.ConnectionType)
	populate(objectMap, "egressBytesTransferred", v.EgressBytesTransferred)
	populate(objectMap, "enableBgp", v.EnableBgp)
	populate(objectMap, "expressRouteGatewayBypass", v.ExpressRouteGatewayBypass)
	populate(objectMap, "ipsecPolicies", v.IPSecPolicies)
	populate(objectMap, "ingressBytesTransferred", v.IngressBytesTransferred)
	populate(objectMap, "localNetworkGateway2", v.LocalNetworkGateway2)
	populate(objectMap, "peer", v.Peer)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "resourceGuid", v.ResourceGUID)
	populate(objectMap, "routingWeight", v.RoutingWeight)
	populate(objectMap, "sharedKey", v.SharedKey)
	populate(objectMap, "tunnelConnectionStatus", v.TunnelConnectionStatus)
	populate(objectMap, "usePolicyBasedTrafficSelectors", v.UsePolicyBasedTrafficSelectors)
	populate(objectMap, "virtualNetworkGateway1", v.VirtualNetworkGateway1)
	populate(objectMap, "virtualNetworkGateway2", v.VirtualNetworkGateway2)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewayConnectionPropertiesFormat.
func (v *VirtualNetworkGatewayConnectionPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationKey":
			err = unpopulate(val, "AuthorizationKey", &v.AuthorizationKey)
			delete(rawMsg, key)
		case "connectionProtocol":
			err = unpopulate(val, "ConnectionProtocol", &v.ConnectionProtocol)
			delete(rawMsg, key)
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &v.ConnectionStatus)
			delete(rawMsg, key)
		case "connectionType":
			err = unpopulate(val, "ConnectionType", &v.ConnectionType)
			delete(rawMsg, key)
		case "egressBytesTransferred":
			err = unpopulate(val, "EgressBytesTransferred", &v.EgressBytesTransferred)
			delete(rawMsg, key)
		case "enableBgp":
			err = unpopulate(val, "EnableBgp", &v.EnableBgp)
			delete(rawMsg, key)
		case "expressRouteGatewayBypass":
			err = unpopulate(val, "ExpressRouteGatewayBypass", &v.ExpressRouteGatewayBypass)
			delete(rawMsg, key)
		case "ipsecPolicies":
			err = unpopulate(val, "IPSecPolicies", &v.IPSecPolicies)
			delete(rawMsg, key)
		case "ingressBytesTransferred":
			err = unpopulate(val, "IngressBytesTransferred", &v.IngressBytesTransferred)
			delete(rawMsg, key)
		case "localNetworkGateway2":
			err = unpopulate(val, "LocalNetworkGateway2", &v.LocalNetworkGateway2)
			delete(rawMsg, key)
		case "peer":
			err = unpopulate(val, "Peer", &v.Peer)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &v.ResourceGUID)
			delete(rawMsg, key)
		case "routingWeight":
			err = unpopulate(val, "RoutingWeight", &v.RoutingWeight)
			delete(rawMsg, key)
		case "sharedKey":
			err = unpopulate(val, "SharedKey", &v.SharedKey)
			delete(rawMsg, key)
		case "tunnelConnectionStatus":
			err = unpopulate(val, "TunnelConnectionStatus", &v.TunnelConnectionStatus)
			delete(rawMsg, key)
		case "usePolicyBasedTrafficSelectors":
			err = unpopulate(val, "UsePolicyBasedTrafficSelectors", &v.UsePolicyBasedTrafficSelectors)
			delete(rawMsg, key)
		case "virtualNetworkGateway1":
			err = unpopulate(val, "VirtualNetworkGateway1", &v.VirtualNetworkGateway1)
			delete(rawMsg, key)
		case "virtualNetworkGateway2":
			err = unpopulate(val, "VirtualNetworkGateway2", &v.VirtualNetworkGateway2)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewayIPConfiguration.
func (v VirtualNetworkGatewayIPConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewayIPConfiguration.
func (v *VirtualNetworkGatewayIPConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewayIPConfigurationPropertiesFormat.
func (v VirtualNetworkGatewayIPConfigurationPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIPAllocationMethod", v.PrivateIPAllocationMethod)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "publicIPAddress", v.PublicIPAddress)
	populate(objectMap, "subnet", v.Subnet)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewayIPConfigurationPropertiesFormat.
func (v *VirtualNetworkGatewayIPConfigurationPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIPAllocationMethod":
			err = unpopulate(val, "PrivateIPAllocationMethod", &v.PrivateIPAllocationMethod)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "publicIPAddress":
			err = unpopulate(val, "PublicIPAddress", &v.PublicIPAddress)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &v.Subnet)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewayListConnectionsResult.
func (v VirtualNetworkGatewayListConnectionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewayListConnectionsResult.
func (v *VirtualNetworkGatewayListConnectionsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewayListResult.
func (v VirtualNetworkGatewayListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewayListResult.
func (v *VirtualNetworkGatewayListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewayPropertiesFormat.
func (v VirtualNetworkGatewayPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeActive", v.Active)
	populate(objectMap, "bgpSettings", v.BgpSettings)
	populate(objectMap, "enableBgp", v.EnableBgp)
	populate(objectMap, "gatewayDefaultSite", v.GatewayDefaultSite)
	populate(objectMap, "gatewayType", v.GatewayType)
	populate(objectMap, "ipConfigurations", v.IPConfigurations)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "resourceGuid", v.ResourceGUID)
	populate(objectMap, "sku", v.SKU)
	populate(objectMap, "vpnClientConfiguration", v.VPNClientConfiguration)
	populate(objectMap, "vpnType", v.VPNType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewayPropertiesFormat.
func (v *VirtualNetworkGatewayPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeActive":
			err = unpopulate(val, "Active", &v.Active)
			delete(rawMsg, key)
		case "bgpSettings":
			err = unpopulate(val, "BgpSettings", &v.BgpSettings)
			delete(rawMsg, key)
		case "enableBgp":
			err = unpopulate(val, "EnableBgp", &v.EnableBgp)
			delete(rawMsg, key)
		case "gatewayDefaultSite":
			err = unpopulate(val, "GatewayDefaultSite", &v.GatewayDefaultSite)
			delete(rawMsg, key)
		case "gatewayType":
			err = unpopulate(val, "GatewayType", &v.GatewayType)
			delete(rawMsg, key)
		case "ipConfigurations":
			err = unpopulate(val, "IPConfigurations", &v.IPConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &v.ResourceGUID)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &v.SKU)
			delete(rawMsg, key)
		case "vpnClientConfiguration":
			err = unpopulate(val, "VPNClientConfiguration", &v.VPNClientConfiguration)
			delete(rawMsg, key)
		case "vpnType":
			err = unpopulate(val, "VPNType", &v.VPNType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkGatewaySKU.
func (v VirtualNetworkGatewaySKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", v.Capacity)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "tier", v.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkGatewaySKU.
func (v *VirtualNetworkGatewaySKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &v.Capacity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &v.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkListResult.
func (v VirtualNetworkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkListResult.
func (v *VirtualNetworkListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkListUsageResult.
func (v VirtualNetworkListUsageResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkListUsageResult.
func (v *VirtualNetworkListUsageResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPeering.
func (v VirtualNetworkPeering) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPeering.
func (v *VirtualNetworkPeering) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPeeringListResult.
func (v VirtualNetworkPeeringListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPeeringListResult.
func (v *VirtualNetworkPeeringListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPeeringPropertiesFormat.
func (v VirtualNetworkPeeringPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowForwardedTraffic", v.AllowForwardedTraffic)
	populate(objectMap, "allowGatewayTransit", v.AllowGatewayTransit)
	populate(objectMap, "allowVirtualNetworkAccess", v.AllowVirtualNetworkAccess)
	populate(objectMap, "peeringState", v.PeeringState)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "remoteAddressSpace", v.RemoteAddressSpace)
	populate(objectMap, "remoteVirtualNetwork", v.RemoteVirtualNetwork)
	populate(objectMap, "useRemoteGateways", v.UseRemoteGateways)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPeeringPropertiesFormat.
func (v *VirtualNetworkPeeringPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowForwardedTraffic":
			err = unpopulate(val, "AllowForwardedTraffic", &v.AllowForwardedTraffic)
			delete(rawMsg, key)
		case "allowGatewayTransit":
			err = unpopulate(val, "AllowGatewayTransit", &v.AllowGatewayTransit)
			delete(rawMsg, key)
		case "allowVirtualNetworkAccess":
			err = unpopulate(val, "AllowVirtualNetworkAccess", &v.AllowVirtualNetworkAccess)
			delete(rawMsg, key)
		case "peeringState":
			err = unpopulate(val, "PeeringState", &v.PeeringState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "remoteAddressSpace":
			err = unpopulate(val, "RemoteAddressSpace", &v.RemoteAddressSpace)
			delete(rawMsg, key)
		case "remoteVirtualNetwork":
			err = unpopulate(val, "RemoteVirtualNetwork", &v.RemoteVirtualNetwork)
			delete(rawMsg, key)
		case "useRemoteGateways":
			err = unpopulate(val, "UseRemoteGateways", &v.UseRemoteGateways)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPropertiesFormat.
func (v VirtualNetworkPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressSpace", v.AddressSpace)
	populate(objectMap, "ddosProtectionPlan", v.DdosProtectionPlan)
	populate(objectMap, "dhcpOptions", v.DhcpOptions)
	populate(objectMap, "enableDdosProtection", v.EnableDdosProtection)
	populate(objectMap, "enableVmProtection", v.EnableVMProtection)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "resourceGuid", v.ResourceGUID)
	populate(objectMap, "subnets", v.Subnets)
	populate(objectMap, "virtualNetworkPeerings", v.VirtualNetworkPeerings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPropertiesFormat.
func (v *VirtualNetworkPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressSpace":
			err = unpopulate(val, "AddressSpace", &v.AddressSpace)
			delete(rawMsg, key)
		case "ddosProtectionPlan":
			err = unpopulate(val, "DdosProtectionPlan", &v.DdosProtectionPlan)
			delete(rawMsg, key)
		case "dhcpOptions":
			err = unpopulate(val, "DhcpOptions", &v.DhcpOptions)
			delete(rawMsg, key)
		case "enableDdosProtection":
			err = unpopulate(val, "EnableDdosProtection", &v.EnableDdosProtection)
			delete(rawMsg, key)
		case "enableVmProtection":
			err = unpopulate(val, "EnableVMProtection", &v.EnableVMProtection)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &v.ResourceGUID)
			delete(rawMsg, key)
		case "subnets":
			err = unpopulate(val, "Subnets", &v.Subnets)
			delete(rawMsg, key)
		case "virtualNetworkPeerings":
			err = unpopulate(val, "VirtualNetworkPeerings", &v.VirtualNetworkPeerings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkTap.
func (v VirtualNetworkTap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkTap.
func (v *VirtualNetworkTap) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkTapPropertiesFormat.
func (v VirtualNetworkTapPropertiesFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationLoadBalancerFrontEndIPConfiguration", v.DestinationLoadBalancerFrontEndIPConfiguration)
	populate(objectMap, "destinationNetworkInterfaceIPConfiguration", v.DestinationNetworkInterfaceIPConfiguration)
	populate(objectMap, "destinationPort", v.DestinationPort)
	populate(objectMap, "networkInterfaceTapConfigurations", v.NetworkInterfaceTapConfigurations)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "resourceGuid", v.ResourceGUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkTapPropertiesFormat.
func (v *VirtualNetworkTapPropertiesFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationLoadBalancerFrontEndIPConfiguration":
			err = unpopulate(val, "DestinationLoadBalancerFrontEndIPConfiguration", &v.DestinationLoadBalancerFrontEndIPConfiguration)
			delete(rawMsg, key)
		case "destinationNetworkInterfaceIPConfiguration":
			err = unpopulate(val, "DestinationNetworkInterfaceIPConfiguration", &v.DestinationNetworkInterfaceIPConfiguration)
			delete(rawMsg, key)
		case "destinationPort":
			err = unpopulate(val, "DestinationPort", &v.DestinationPort)
			delete(rawMsg, key)
		case "networkInterfaceTapConfigurations":
			err = unpopulate(val, "NetworkInterfaceTapConfigurations", &v.NetworkInterfaceTapConfigurations)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGuid":
			err = unpopulate(val, "ResourceGUID", &v.ResourceGUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkUsage.
func (v VirtualNetworkUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", v.CurrentValue)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "limit", v.Limit)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "unit", v.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkUsage.
func (v *VirtualNetworkUsage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &v.CurrentValue)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &v.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &v.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkUsageName.
func (v VirtualNetworkUsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", v.LocalizedValue)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkUsageName.
func (v *VirtualNetworkUsageName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &v.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
