!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Routines to manage CUBEUV messages
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeuv_messaging
  use gpack_def
  use gbl_message
  use cubetools_parameters
  !
  public :: uvseve
  public :: cubeuv_message_set_id,cubeuv_message
  public :: cubeuv_message_set_alloc,cubeuv_message_get_alloc
  public :: cubeuv_message_set_trace,cubeuv_message_get_trace
  public :: cubeuv_message_set_others,cubeuv_message_get_others
  private
  !
  ! Identifier used for message identification
  integer(kind=4) :: cubeuv_message_id = gpack_global_id  ! Default value for startup message
  !
  type :: cubeuv_messaging_debug_t
     integer(kind=code_k) :: alloc = seve%d
     integer(kind=code_k) :: trace = seve%t
     integer(kind=code_k) :: others = seve%d
  end type cubeuv_messaging_debug_t
  !
  type(cubeuv_messaging_debug_t) :: uvseve
  !
contains
  !
  subroutine cubeuv_message_set_id(id)
    !---------------------------------------------------------------------
    ! Alter library id into input id. Should be called by the library
    ! which wants to share its id with the current one.
    !---------------------------------------------------------------------
    integer(kind=4), intent(in) :: id
    !
    character(len=message_length) :: mess
    character(len=*), parameter :: rname='MESSAGE>SET>ID'
    !
    cubeuv_message_id = id
    write (mess,'(A,I0)') 'Now use id #',cubeuv_message_id
    call cubeuv_message(seve%d,rname,mess)
  end subroutine cubeuv_message_set_id
  !
  subroutine cubeuv_message(mkind,procname,message)
    use cubetools_cmessaging
    !---------------------------------------------------------------------
    ! Messaging facility for the current library. Calls the low-level
    ! (internal) messaging routine with its own identifier.
    !---------------------------------------------------------------------
    integer(kind=4),  intent(in) :: mkind     ! Message kind
    character(len=*), intent(in) :: procname  ! Name of calling procedure
    character(len=*), intent(in) :: message   ! Message string
    !
    call cubetools_cmessage(cubeuv_message_id,mkind,'UV>'//procname,message)
  end subroutine cubeuv_message
  !
  subroutine cubeuv_message_set_alloc(on)
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    logical, intent(in) :: on
    !
    if (on) then
       uvseve%alloc = seve%i
    else
       uvseve%alloc = seve%d
    endif
  end subroutine cubeuv_message_set_alloc
  !
  subroutine cubeuv_message_set_trace(on)
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    logical, intent(in) :: on
    !
    if (on) then
       uvseve%trace = seve%i
    else
       uvseve%trace = seve%t
    endif
  end subroutine cubeuv_message_set_trace
  !
  subroutine cubeuv_message_set_others(on)
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    logical, intent(in) :: on
    !
    if (on) then
       uvseve%others = seve%i
    else
       uvseve%others = seve%d
    endif
  end subroutine cubeuv_message_set_others
  !
  function cubeuv_message_get_alloc()
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    logical :: cubeuv_message_get_alloc
    !
    cubeuv_message_get_alloc = uvseve%alloc.eq.seve%i
    !
  end function cubeuv_message_get_alloc
  !
  function cubeuv_message_get_trace()
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    logical :: cubeuv_message_get_trace
    !
    cubeuv_message_get_trace = uvseve%trace.eq.seve%i
    !
  end function cubeuv_message_get_trace
  !
  function cubeuv_message_get_others()
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    logical :: cubeuv_message_get_others
    !
    cubeuv_message_get_others = uvseve%others.eq.seve%i
    !
  end function cubeuv_message_get_others
end module cubeuv_messaging
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
