!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubehistogram_ppv2xyv
  use cube_types 
  use cubetools_parameters
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubeadm_cubeprod_types
  use cubemain_ancillary_weight_types
  use cubetopology_cuberegion_types
  use cubehistogram_messaging
  !
  public :: ppv2xyv
  private
  !
  type :: ppv2xyv_comm_t
     type(option_t), pointer :: comm
!     type(cuberegion_comm_t) :: region
     type(cubeid_arg_t), pointer :: fromto
     type(cubeid_arg_t), pointer :: histo2d
     type(ancillary_weight_comm_t) :: ppvwei
     type(cubeid_arg_t), pointer :: ppvsig
     type(cube_prod_t),  pointer :: xyvsig
   contains
     procedure, public  :: register => cubehistogram_ppv2xyv_comm_register
     procedure, private :: parse    => cubehistogram_ppv2xyv_comm_parse
     procedure, private :: main     => cubehistogram_ppv2xyv_comm_main
  end type ppv2xyv_comm_t
  type(ppv2xyv_comm_t) :: ppv2xyv  
  !
  type ppv2xyv_user_t
     type(cubeid_user_t)           :: cubeids
     type(ancillary_weight_user_t) :: ppvwei
!     type(cuberegion_user_t)      :: region
   contains
     procedure, private :: toprog => cubehistogram_ppv2xyv_user_toprog
  end type ppv2xyv_user_t
  !
  type ppv2xyv_prog_t
!     type(cuberegion_prog_t) :: region
     type(cube_t), pointer         :: fromto
     type(cube_t), pointer         :: histo2d
     type(ancillary_weight_prog_t) :: ppvwei
     type(cube_t), pointer :: ppvsig
     type(cube_t), pointer :: xyvsig
     procedure(cubehistogram_ppv2xyv_prog_loop_with_weight), pointer :: loop => null()
   contains
     procedure, private :: header             => cubehistogram_ppv2xyv_prog_header
     procedure, private :: data               => cubehistogram_ppv2xyv_prog_data
     procedure, private :: act_without_weight => cubehistogram_ppv2xyv_prog_act_without_weight
     procedure, private :: act_with_weight    => cubehistogram_ppv2xyv_prog_act_with_weight
  end type ppv2xyv_prog_t
  !
contains
  !
  subroutine cubehistogram_ppv2xyv_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(ppv2xyv_user_t) :: user
    character(len=*), parameter :: rname='PPV2XYV>COMMAND'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call ppv2xyv%parse(line,user,error)
    if (error) return
    call ppv2xyv%main(user,error)
    if (error) continue
  end subroutine cubehistogram_ppv2xyv_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubehistogram_ppv2xyv_comm_register(comm,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ppv2xyv_comm_t), intent(inout) :: comm
    logical,                 intent(inout) :: error
    !
    type(cubeid_arg_t) :: incube
    type(cube_prod_t) :: oucube
    character(len=*), parameter :: rname='PPV2XYV>COMM>REGISTER'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    ! Syntax
    call cubetools_register_command(&
         'PPV2XYV','[ppvid fromtoid histo2did]',&
         'Stack spectra according to a 2D histogram',&
         strg_id,&
         cubehistogram_ppv2xyv_command,&
         comm%comm,&
         error)
    if (error) return
    call incube%register(&
         'PPV',&
         'Position-Position-Velocity cube',&
         strg_id,&
         code_arg_optional,&
         !         [flag_ppv,flag_cube],&
         [flag_cube],&
         code_read,&
         code_access_imaset,&
         comm%ppvsig,&
         error)
    if (error) return
    call incube%register(&
         'FROMTO',&
         'From PP to XY',&
         'Image explaining how to go from a PP image to a bin of XY histo2d',&
         code_arg_optional,&
         [flag_histo2d,flag_pointer],&
         code_read,&
         code_access_imaset,&
         comm%fromto,&
         error)
    if (error) return
    call incube%register(&
         'HISTO2D',&
         '2D histogram',&
         strg_id,&
         code_arg_optional,&
         [flag_histo2d],&
         code_read_head,&
         code_access_imaset,&
         comm%histo2d,&
         error)
    if (error) return
    call comm%ppvwei%register(&
         'Cube to weight the input data',&
         code_access_imaset,&
         error)
    if (error) return
!    call comm%region%register(error)
!    if (error) return
    !
    ! Products
    call oucube%register(&
         'XYV',&
         'X-Y-Velocity cube',&
         strg_id,&
         [flag_xyv,flag_cube],&
         comm%xyvsig,&
         error)
    if (error)  return
  end subroutine cubehistogram_ppv2xyv_comm_register
  !
  subroutine cubehistogram_ppv2xyv_comm_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! PPV2XYV ppvid fromtoid histo2did
    !----------------------------------------------------------------------
    class(ppv2xyv_comm_t), intent(in)    :: comm
    character(len=*),      intent(in)    :: line
    type(ppv2xyv_user_t),  intent(out)   :: user
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='PPV2XYV>COMM>PARSE'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,comm%comm,user%cubeids,error)
    if (error) return
    call comm%ppvwei%parse(line,user%ppvwei,error)
    if (error) return
!!$    call comm%region%parse(line,user%region,error)
!!$    if (error) return
  end subroutine cubehistogram_ppv2xyv_comm_parse
  !
  subroutine cubehistogram_ppv2xyv_comm_main(comm,user,error)
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ppv2xyv_comm_t), intent(in)    :: comm
    type(ppv2xyv_user_t),  intent(inout) :: user
    logical,               intent(inout) :: error
    !
    type(ppv2xyv_prog_t) :: prog
    character(len=*), parameter :: rname='PPV2XYV>MAIN'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call user%toprog(comm,prog,error)
    if (error) return
    call prog%header(comm,error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubehistogram_ppv2xyv_comm_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubehistogram_ppv2xyv_user_toprog(user,comm,prog,error)
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ppv2xyv_user_t), intent(in)    :: user
    type(ppv2xyv_comm_t),  intent(in)    :: comm
    type(ppv2xyv_prog_t),  intent(out)   :: prog
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='PPV2XYV>USER>TOPROG'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call cubeadm_get_header(comm%ppvsig,user%cubeids,prog%ppvsig,error)
    if (error) return
    call user%ppvwei%toprog(comm%ppvwei,prog%ppvwei,error)
    if (error) return
    call prog%ppvwei%check_consistency(prog%ppvsig,error)
    if (error) return
    call cubeadm_get_header(comm%fromto,user%cubeids,prog%fromto,error)
    if (error) return
    call cubeadm_get_header(comm%histo2d,user%cubeids,prog%histo2d,error)
    if (error) return
    if (prog%ppvwei%do) then
       prog%loop => cubehistogram_ppv2xyv_prog_loop_with_weight
    else
       prog%loop => cubehistogram_ppv2xyv_prog_loop_without_weight
    endif
!!$    call user%region%toprog(prog%fromto,prog%region,error)
!!$    if (error) return
    !
    ! User feedback about the interpretation of his command line
!!$    call prog%region%list(error)
!!$    if (error) return    
  end subroutine cubehistogram_ppv2xyv_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubehistogram_ppv2xyv_prog_header(prog,comm,error)
    use cubeadm_clone
    use cubetools_header_methods
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ppv2xyv_prog_t), intent(inout) :: prog
    type(ppv2xyv_comm_t),  intent(in)    :: comm
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='PPV2XYV>PROG>HEADER'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(comm%xyvsig,prog%ppvsig,prog%xyvsig,error)
    if (error) return
    call cubetools_header_spatial_like(prog%histo2d%head,prog%xyvsig%head,error)
    if (error) return
!!$    call prog%region%header(prog%xyvsig,error)
!!$    if (error) return
  end subroutine cubehistogram_ppv2xyv_prog_header
  !
  subroutine cubehistogram_ppv2xyv_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(ppv2xyv_prog_t), intent(inout) :: prog
    logical,               intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='PPV2XYV>PROG>DATA'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error) exit
       !$OMP TASK SHARED(prog,error) FIRSTPRIVATE(iter)
       if (.not.error) &
         call prog%loop(iter,error)
       !$OMP END TASK
    enddo
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubehistogram_ppv2xyv_prog_data
  !
  !----------------------------------------------------------------------
  !
  subroutine cubehistogram_ppv2xyv_prog_loop_without_weight(prog,iter,error)
    use cubeadm_taskloop
    use cubetools_array_types
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ppv2xyv_prog_t),    intent(inout) :: prog
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
    !
    type(image_t) :: fromto
    type(image_t) :: ppsig,xysig
    type(dble_2d_t) :: xysum
    type(long_2d_t) :: xywei
    character(len=*), parameter :: rname='PPV2XYV>PROG>LOOP>WITHOUT>WEIGHT'
    !
    call fromto%associate('fromto',prog%fromto,iter,error)
    if (error) return
    call ppsig%associate('ppsig',prog%ppvsig,iter,error)
    if (error) return
    call xysig%allocate('xysig',prog%xyvsig,iter,error)
    if (error) return
    call xysum%reallocate('xysum',xysig%nx,xysig%ny,error)
    if (error) return
    call xywei%reallocate('xywei',xysig%nx,xysig%ny,error)
    if (error) return
    !
    do while (iter%iterate_entry(error))
      call prog%act_without_weight(iter%ie,fromto,ppsig,xysig,xysum,xywei,error)
      if (error) return
    enddo ! ie
  end subroutine cubehistogram_ppv2xyv_prog_loop_without_weight
  !
  subroutine cubehistogram_ppv2xyv_prog_act_without_weight(&
       prog,ie,fromto,ppsig,xysig,xysum,xywei,error)
    use cubetools_nan
    use cubetools_array_types
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ppv2xyv_prog_t), intent(inout) :: prog
    integer(kind=entr_k),  intent(in)    :: ie
    type(image_t),         intent(inout) :: fromto
    type(image_t),         intent(inout) :: ppsig
    type(image_t),         intent(inout) :: xysig
    type(dble_2d_t),       intent(inout) :: xysum
    type(long_2d_t),       intent(inout) :: xywei
    logical,               intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    integer(kind=pixe_k) :: jx,jy
    integer(kind=indx_k) :: index
    integer(kind=long_k), parameter :: zero=0
    character(len=*), parameter :: rname='PPV2XYV>PROG>ACT>WITHOUT>WEIGHT'
    !
    call fromto%get(ie,error)
    if (error) return
    call ppsig%get(ie,error)
    if (error) return
    ! Initialize
    call xywei%set(zero,error)
    if (error) return
    call xysum%set(0d0,error)
    if (error) return
    ! Sum the input pixels using the fromto mask
    do iy=1,fromto%ny
       do ix=1,fromto%nx
          if (ieee_is_nan(fromto%val(ix,iy))) cycle
          index = fromto%val(ix,iy)
          if (index.eq.0) cycle
          jx = 1+mod(index-1,xysig%nx)
          jy = 1+(index-jx)/xysig%nx
          ! The user can provide an inconsistent set of fromto and histo2d images!
          if ((1.le.jx).and.(jx.le.xywei%nx).and.(1.le.jy).and.(jy.le.xywei%ny)) then
             xywei%val(jx,jy) = xywei%val(jx,jy) + 1
             xysum%val(jx,jy) = xysum%val(jx,jy) + ppsig%val(ix,iy)
          else
             ! ***JP: Some shorter feedback to user? For instance counting
             ! ***JP: the number of points outside and stating it at the end?
             print *,jx,jy,xywei%nx,xywei%ny
          endif
       enddo ! ix
    enddo ! iy
    ! Compute xy
    do iy=1,xysig%ny
       do ix=1,xysig%nx
          if (xywei%val(ix,iy).ne.zero) then
             xysig%val(ix,iy) = xysum%val(ix,iy)/xywei%val(ix,iy)
          else
             xysig%val(ix,iy) = gr4nan
          endif
       enddo ! ix
    enddo ! iy
    call xysig%put(ie,error)
    if (error) return
  end subroutine cubehistogram_ppv2xyv_prog_act_without_weight
  !
  !----------------------------------------------------------------------
  !
  subroutine cubehistogram_ppv2xyv_prog_loop_with_weight(prog,iter,error)
    use cubeadm_taskloop
    use cubetools_array_types
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ppv2xyv_prog_t),    intent(inout) :: prog
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
    !
    type(image_t) :: fromto
    type(image_t) :: ppsig,ppwei,xysig
    type(dble_2d_t) :: xysum,xywei
    character(len=*), parameter :: rname='PPV2XYV>PROG>LOOP>WITH>WEIGHT'
    !
    call fromto%associate('fromto',prog%fromto,iter,error)
    if (error) return
    call ppsig%associate('ppsig',prog%ppvsig,iter,error)
    if (error) return
    call ppwei%associate('ppwei',prog%ppvwei%cube,iter,error)
    if (error) return
    call xysig%allocate('xysig',prog%xyvsig,iter,error)
    if (error) return
    call xysum%reallocate('xysum',xysig%nx,xysig%ny,error)
    if (error) return
    call xywei%reallocate('xywei',xysig%nx,xysig%ny,error)
    if (error) return
    !
    do while (iter%iterate_entry(error))
      call prog%act_with_weight(iter%ie,fromto,ppsig,ppwei,xysig,xysum,xywei,error)
      if (error) return
    enddo ! ie
  end subroutine cubehistogram_ppv2xyv_prog_loop_with_weight
  !
  subroutine cubehistogram_ppv2xyv_prog_act_with_weight(&
       prog,ie,fromto,ppsig,ppwei,xysig,xysum,xywei,error)
    use cubetools_nan
    use cubetools_array_types
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ppv2xyv_prog_t), intent(inout) :: prog
    integer(kind=entr_k),  intent(in)    :: ie
    type(image_t),         intent(inout) :: fromto
    type(image_t),         intent(inout) :: ppsig
    type(image_t),         intent(inout) :: ppwei
    type(image_t),         intent(inout) :: xysig
    type(dble_2d_t),       intent(inout) :: xysum
    type(dble_2d_t),       intent(inout) :: xywei
    logical,               intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    integer(kind=pixe_k) :: jx,jy
    integer(kind=indx_k) :: index
    real(kind=dble_k), parameter :: zero=0d0
    character(len=*), parameter :: rname='PPV2XYV>PROG>ACT>WITH>WEIGHT'
    !
    call fromto%get(ie,error)
    if (error) return
    call ppsig%get(ie,error)
    if (error) return
    call ppwei%get(ie,error)
    if (error) return
    ! Initialize
    call xywei%set(zero,error)
    if (error) return
    call xysum%set(zero,error)
    if (error) return
    ! Sum the input pixels using the fromto mask
    do iy=1,fromto%ny
       do ix=1,fromto%nx
          if (ieee_is_nan(fromto%val(ix,iy))) cycle
          if (ieee_is_nan(ppsig%val(ix,iy)))  cycle
          if (ieee_is_nan(ppwei%val(ix,iy)))  cycle
          index = fromto%val(ix,iy)
          if (index.eq.0) cycle
          jx = 1+mod(index-1,xysig%nx)
          jy = 1+(index-jx)/xysig%nx
          ! The user can provide an inconsistent set of fromto and histo2d images!
          if ((1.le.jx).and.(jx.le.xywei%nx).and.(1.le.jy).and.(jy.le.xywei%ny)) then
             xywei%val(jx,jy) = xywei%val(jx,jy) + ppwei%val(ix,iy)
             xysum%val(jx,jy) = xysum%val(jx,jy) + ppwei%val(ix,iy)*ppsig%val(ix,iy)
          else
             ! ***JP: Some shorter feedback to user? For instance counting
             ! ***JP: the number of points outside and stating it at the end?
             print *,jx,jy,xywei%nx,xywei%ny
          endif
       enddo ! ix
    enddo ! iy
    ! Compute xy
    do iy=1,xysig%ny
       do ix=1,xysig%nx
          if (xywei%val(ix,iy).ne.zero) then
             xysig%val(ix,iy) = xysum%val(ix,iy)/xywei%val(ix,iy)
          else
             xysig%val(ix,iy) = gr4nan
          endif
       enddo ! ix
    enddo ! iy
    call xysig%put(ie,error)
    if (error) return
  end subroutine cubehistogram_ppv2xyv_prog_act_with_weight
end module cubehistogram_ppv2xyv
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
